"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""

from twisted.internet.protocol import DatagramProtocol
from twisted.internet import reactor


class FakeDriverProtocol(DatagramProtocol):

   def datagramReceived(self, line, (host, port)):
      try:
         line = line.rstrip()[10:][:13]
         if len(line) != 0:
            self.TwistedLoop.fakeDriverMessage(line)
      except:
         pass

class FakeDriver:

   connector=False

   def __init__(self, TwistedLoop):
      self.TwistedLoop = TwistedLoop

   def startDriver(self):
      self.factory = FakeDriverProtocol()
      self.factory.TwistedLoop = self.TwistedLoop
      self.connector = reactor.listenUDP(43333, self.factory) #, interface='127.0.0.1')
      self.TwistedLoop.fakedstarted = True

   def stopDriver(self):
      if self.connector:
         self.connector.stopListening()
         self.connector =  False
