import re, cgi

urifinder = re.compile("(\s|\A)(((news|telnet|nttp|file|http|ftp|https|sip)://\S+)|((www|ftp)\.[a-zA-Z]+\.\S+))", re.IGNORECASE)

def _urlMatch(txt):
   match=urifinder.finditer(txt)
   if match:
      for uri in match:
         url=uri.groups()[1]
         htmlurl="<a href=\""+url+"\">"+url+"</a>"
         txt=txt.replace(url, htmlurl)
   return txt



def toHtml(txt):
   txt=cgi.escape(txt)
   txt=_urlMatch(txt)
   txt=txt.replace("\n", "<br />")
   return txt

