#!/usr/bin/env python
"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""
"""
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2007/09/25 22:13:23 $"
"""

import platform

import traceback
import sys, os


def myexcepthook(type, value, traceback):
      #print 'ExceptHook: ', type, value, traceback
      pass

#sys.excepthook = myexcepthook

from skylive.utils import genutils as utils

if platform.system() == 'Darwin' and utils.is_frozen():
   # This is for osx 10.4. We need to wrap our
   # updated versions here as we can't do it 
   # from a shell script in old osx versions, cause it
   # complain that it need pythonw if we rename
   # the app bundle executable.
   sup = False
   mydir = os.path.normpath(os.path.abspath(os.path.dirname(sys.executable)))
   myexe = mydir+"/skylive-ng" 
   userhome = os.path.expanduser("~")
   upexe = userhome+'/.SkyLIVE.app/Contents/MacOS/skylive-ng'
   uppath = userhome+'/.SkyLIVE.app'
   upv = uppath+"/Contents/MacOS/VERSION.txt"
   myv = mydir+"/VERSION.txt"
   if myexe != upexe:
      if os.path.exists(upv):
         if os.path.exists(myv):
            f = open(myv, "r")
            myn  = int(f.read())
            f.close()
            f =  open(upv, "r")
            upn = int(f.read())
            f.close()
            if upn > myn:
               sup = True
         else:
            sup = True
   if sup:
      import subprocess
      subprocess.Popen(upexe, shell=True, preexec_fn = os.setsid)
      sys.exit(0)

if platform.system() == 'Darwin':
   import shutil
   # This is for our Live Audio Streaming. OSX don't have vorbis codecs
   # installed by default. Look if it is already installed, if not, install
   # it.
   installed=False
   userhome = os.path.expanduser("~")
   if os.path.isdir('/Library/QuickTime'):
      if os.path.isdir('/Library/QuickTime/XiphQT.component'):
         installed=True
   if os.path.isdir('/Library/Components'):
      if os.path.isdir('/Library/Components/XiphQT.component'):
         installed=True
   if os.path.isdir(userhome+'/Library/QuickTime'):
      if os.path.isdir(userhome+'/Library/QuickTime/XiphQT.component'):
         installed=True
   if os.path.isdir(userhome+'/Library/Components'):
      if os.path.isdir(userhome+'/Library/Components/XiphQT.component'):
         installed=True
   if not installed and (os.path.isdir(userhome+'/Library/QuickTime') or os.path.isdir('/Library/QuickTime')):
      if utils.is_frozen():
         mydir = os.path.normpath(os.path.abspath(os.path.dirname(sys.executable)))
         try:
            shutil.copytree(mydir+'/../../XiphQT.component', '/Library/QuickTime/XiphQT.component')
         except:
            shutil.copytree(mydir+'/../../XiphQT.component', userhome+'/Library/QuickTime/XiphQT.component')

      else:
         print "WARNING: Please install Vorbis Codecs for QuickTime if you want to have Audio Streaming!"


from Pycard import model, splash
from Pycard.twistedsupport import twistedThreadModel
from twisted.internet import reactor
try:
   import psyco
   psyco.cannotcompile(traceback.export_stack)
   psyco.full()
except:
   pass

from gui import main as guimain
from skylive import config, main


if __name__ == "__main__":
   if platform.system() == 'Windows' or platform.system() == "Microsoft":
      sys.stderr = open('errors.log', 'w')

   if len(sys.argv) > 1:
      debug=False
      #for opt in sys.argv:
      #   if opt == '-d':
      #      debug=True
      #sys.argv=[sys.argv[0]]
      
      if debug:
         # requested debug mode. We need to authenticate the user *before* to
         # permit to use this mode, so, remove the config module!
         import os
         userhome = os.path.expanduser("~")
         sys.argv.append('-d')

   #app = twistedModel.TwistedApplication(main.skyLive, "./gui/main."+sysType+".rsrc.py")
   #app = twistedThreadModel.TwistedApplication(main.skyLive, "./gui/main."+sysType+".rsrc.py")
   wxapp = splash.PycardSplashedApp(guimain.skyLive, './gui/img/splash.jpg', 40)
   app = twistedThreadModel.TwistedApplication(main.skyLive, wxapp, "./gui/main.rsrc.py")
   #sys.excepthook = myexcepthook
   app.MainLoop()
