"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""



from Pycard import model, dialog
from skylive import config
from skylive.lang import language
import platform

class TextSizes(model.PageBackground):

   def on_initialize(self, event):
      self.lang = self._parent.lang
      self.gui = 'textsize'
      self.ItemText = language.getItemText
      self.setGui()
      self.currentSizes = self._parent.charSizes
      self.setChatCharCombo()
      self.setListCharCombo()
      self.setInputCharCombo()
      self.setTestInputSize(self.currentSizes['inputsize'])
      self.setTestChatSize(self.currentSizes['chatsize'])
      self.setTestListSize(self.currentSizes['listsize'])
    
#start text char size section
   def setChatCharCombo(self):
      minsize = 1
      maxsize = 4
      if platform.system() == 'Darwin':
         maxsize = 5
      for n in range(minsize, maxsize+1):
         self.components.ComboChatSize.append(str(n))
      self.components.ComboChatSize.text = str(self.currentSizes['chatsize'])
   
   def setInputCharCombo(self):
      minsize = 8
      maxsize = 10
      if platform.system() == 'Darwin':
         maxsize = 13
      for n in range(minsize, maxsize+1):
         self.components.ComboInputSize.append(str(n))
      self.components.ComboInputSize.text = str(self.currentSizes['inputsize'])
    
   def setListCharCombo(self):
      minsize = 7
      maxsize = 9
      if platform.system() == 'Darwin':
         maxsize = 13
      for n in range(minsize, maxsize+1):
         self.components.ComboListSize.append(str(n))
      self.components.ComboListSize.text = str(self.currentSizes['listsize'])
    
   def setTestChatSize(self, size=8):
      try:
         self.components.testChatSize.font = {'size':int(size)}
      except:
         pass
   
   def setTestInputSize(self, size=8):
      try:
         self.components.testInputSize.font = {'size':int(size)}
      except:
         pass
   
   def setTestListSize(self, size=7):
      try:
         self.components.testListSize.font = {'size':int(size)}
      except:
         pass
         
   def on_ComboChatSize_textUpdate(self, event):
      self.setTestChatSize(self.components.ComboChatSize.text)
    
   def on_ComboListSize_textUpdate(self, event):
      self.setTestListSize(self.components.ComboListSize.text)
   
   def on_ComboInputSize_textUpdate(self, event):
      self.setTestInputSize(self.components.ComboInputSize.text)
   
   def on_applyButton_mouseClick(self, event):
      try:
         self._parent.components.ChatArea.font = {'size': int(self.components.ComboChatSize.text)}
         self._parent.components.UserlistArea.font = {'size': int(self.components.ComboListSize.text)}
         self._parent.components.ChatField.font = {'size': int(self.components.ComboInputSize.text)}
         config.put_usrCharSizes(self.components.ComboChatSize.text, self.components.ComboListSize.text, self.components.ComboInputSize.text)
      except:
         pass

   def on_defaultButton_mouseClick(self, event):
      chatsize = 8
      listsize = 7
      inputsize = 8
      if platform.system() == 'Darwin':
         chatsize = 11
         listsize = 10
         inputsize = 11

      self.components.ComboChatSize.text = str(chatsize)
      self.components.ComboListSize.text = str(listsize)
      self.components.ComboInputSize.text = str(inputsize)
      self.setTestInputSize(inputsize)
      self.setTestChatSize(chatsize)
      self.setTestListSize(listsize)
#end text char size section


   def on_closeButton_mouseClick(self, event):
      self.parent.close()

   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)
   
   def setGui(self):
      self.components.inputsize.text = self.getText('inputsize')
      self.components.listsize.text = self.getText('listsize')
      self.components.chatsize.text = self.getText('chatsize')
      self.components.textbox.label = self.getText('textbox')
      self.components.defaultButton.label = self.getText('defaultButton')
      self.components.applyButton.label = self.getText('applyButton')
      self.components.closeButton.label = self.getText('closeButton')
