#!/usr/bin/python

"""
__version__ = "$Revision: 1.3 $"
__date__ = "$Date: 2004/04/14 02:38:47 $"
"""

from Pycard import model
import textsize, pointer, extra, langs, proxyconf, pvt
from skylive.lang import language
import os
from skylive.utils import genutils

def expandDarwin(win):
   if genutils.platform() == 'Darwin':
      w, h = win.size
      win.size = (w+60, h)
      win.panel.SetSize(win.size)


class Settings(model.Background):

   def on_initialize(self, event):
      self._parent = self.getParent()
      self.lang = self._parent.lang
      self.gui = 'settings'
      self.ItemText = language.getItemText
      self.components.notebook.SetMinSize(self.components.notebook.size)
      self.singleItemExpandingSizerLayout()

      # OSX need a different resize!
      expandDarwin(self)

      win1 = model.childWindow(self.components.notebook, textsize.TextSizes, os.path.normpath("./gui/settings/textsize.rsrc.py"))
      self.components.notebook.AddPage(win1, self.getText('win1'), True)
      win1._parent = self._parent
      win1.parent = self
      win2 = model.childWindow(self.components.notebook, pointer.Pointer, os.path.normpath("./gui/settings/pointer.rsrc.py"))
      self.components.notebook.AddPage(win2, self.getText('win2'), True)
      win2._parent = self._parent
      win2.parent = self
      win4 = model.childWindow(self.components.notebook, langs.Langs, os.path.normpath("./gui/settings/langs.rsrc.py"))
      self.components.notebook.AddPage(win4, self.getText('win4'), True)
      win4._parent = self._parent
      win4.parent = self
      win5 = model.childWindow(self.components.notebook, proxyconf.proxyConf, os.path.normpath("./gui/settings/proxyconf.rsrc.py"))
      self.components.notebook.AddPage(win5, self.getText('win5'), True)
      win5._parent = self._parent
      win5.parent = self
      win6 = model.childWindow(self.components.notebook, pvt.Pvt, os.path.normpath("./gui/settings/pvt.rsrc.py"))
      self.components.notebook.AddPage(win6, self.getText('win6'), True)
      win6._parent = self._parent
      win6.parent = self
      win3 = model.childWindow(self.components.notebook, extra.Extras, os.path.normpath("./gui/settings/extra.rsrc.py"))
      self.components.notebook.AddPage(win3, self.getText('win3'), True)
      win3._parent = self._parent
      win3.parent = self
      self.components.notebook.stringSelection = self.getText('win1')
   
   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)
