 
from Pycard import model
from skylive import config
from skylive.lang import language

class Pvt(model.PageBackground):

   def on_initialize(self, event):
      self.lang = self._parent.lang
      self.gui = 'pvt'
      self.ItemText = language.getItemText
      self.setGui()
      self.canBeep, self.canPopup = config.get_pvtPref()
      self.components.useBeep.checked = self.canBeep
      self.components.usePopup.checked = self.canPopup
      

   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)
   
   def setGui(self):
      self.components.pvtBox.label = self.getText('pvtBox')
      self.components.useBeep.label = self.getText('useBeep')
      self.components.usePopup.label = self.getText('usePopup')
      self.components.applyButton.label = self.getText('applyButton')
      self.components.defaultButton.label = self.getText('defaultButton')
      self.components.closeButton.label = self.getText('closeButton')

   def on_applyButton_mouseClick(self, event):
      b = self.components.useBeep.checked
      p = self.components.usePopup.checked
      config.put_pvtPref(str(b), str(p))
   
   def on_defaultButton_mouseClick(self, event):
      self.components.useBeep.checked = True
      self.components.usePopup.checked = True
      config.put_pvtPref(True, True)
   
   def on_closeButton_mouseClick(self, event):
      self.parent.close()
