 
from Pycard import model, dialog
from skylive import config
from skylive.lang import language

class Pointer(model.PageBackground):

   def on_initialize(self, event):
      self.lang = self._parent.lang
      self.gui = 'pointer'
      self.ItemText = language.getItemText
      self.setGui()
      self.currentColorPointer = self._parent.defaultPointerColor
      self.setPointerColorTest(self._parent.defaultPointerColor)
      

#start color pointer section
   def setPointerColorTest(self, color='#FF7700'):
      self.components.testColor.backgroundColor = color
      self.PointerColorSelected = color

   def on_colorButton_mouseClick(self, event):
      result = dialog.colorDialog(self)
      if result.accepted:
         color = self.RGBToHTMLColor(result.color)
         self.setPointerColorTest(color)
         
   
   def on_applyColorButton_mouseClick(self, event):
      self._parent.defaultPointerColor = self.PointerColorSelected
      config.put_usrPointerColor(self.PointerColorSelected)
   
   def on_defaultColorButton_mouseClick(self, event):
      self.setPointerColorTest()

   def RGBToHTMLColor(self, rgb_tuple):
      hexcolor = '#%02x%02x%02x' % rgb_tuple
      return hexcolor


   def on_closeButton_mouseClick(self, event):
      self.parent.close()
   
   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)

   def setGui(self):
      self.components.colorButton.label = self.getText('colorButton')
      self.components.color.text = self.getText('color')
      self.components.pointerBox.label = self.getText('pointerBox')
      self.components.defaultColorButton.label = self.getText('defaultColorButton')
      self.components.applyColorButton.label = self.getText('applyColorButton')
      self.components.closeButton.label = self.getText('closeButton')
