 
from Pycard import model, dialog
from skylive import config
from skylive.lang import language
import platform

class Langs(model.PageBackground):

   def on_initialize(self, event):
      self.lang = self._parent.lang
      self.gui = 'langs'
      self.langsList = {'en':'English', 'it':'Italiano'}
      self.ItemText = language.getItemText
      self.setGui()
      self.setComboLangs()
      
   def setComboLangs(self):
      for l in self.langsList.values():
         self.components.langsAvaiable.append(l)
      self.components.langsAvaiable.text = self.langsList[self.lang]
   
   def on_langsAvaiable_select(self, event):
      for l in self.langsList.keys():
         if self.langsList[l] == self.components.langsAvaiable.text:
            self.selectedLanguage = l
            break
         else:
            pass

   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)
   
   def setGui(self):
      self.components.langsAvaiableTXT.text = self.getText('langsAvaiableTXT')
      self.components.closeButton.label = self.getText('closeButton')
      self.components.defaultButton.label = self.getText('defaultButton')
      self.components.applyButton.label = self.getText('applyButton')
      self.components.langsBox.label = self.getText('langsBox')
   
   def on_applyButton_mouseClick(self, event):
      config.put_usrLang(self.selectedLanguage)
      self.lang = self.selectedLanguage
      self._parent.lang = self.lang
      self.setGui()
      self._parent.setGui()
   
   def on_defaultButton_mouseClick(self, event):
      config.put_usrLang('en')
      self.lang = 'en'
      self._parent.lang = self.lang
      self.setGui()
      self._parent.setGui()
   
   def on_closeButton_mouseClick(self, event):
      self.parent.close()
