 
from Pycard import model, dialog
from skylive import config
from skylive.lang import language
import platform

class Extras(model.PageBackground):

   def on_initialize(self, event):
      self.faketext = 'useARDEC'
      self.inditext = 'useINDI'
      self.lang = self._parent.lang
      self.forcedLowRes = self._parent.forcedLowRes
      self.gui = 'extra'
      self.ItemText = language.getItemText
      self.setGui()
      self.useExtProgram = self._parent.useExtProgram
      self.useINDIProgram = self._parent.useINDIProgram
      self.enableStream = self._parent.enableStream
      self.askStream = self._parent.askStream
      self.enableARDECCheck()
      self.enableINDICheck()
      self.enableStreamCheck()
      self.askStreamCheck()
      if self.forcedLowRes:
         self.components.forceLowRes.checked = True
   
   def enableStreamCheck(self):
      if self.enableStream in ['True', 'yes', 'y', 'Yes', '1']:
         self.components.enableStream.checked = True

   def askStreamCheck(self):
      if self.askStream  == ['True', 'yes', 'y', 'Yes', '1']:
         self.components.askStream.checked = True

   def enableARDECCheck(self):
      if platform.system() == "Microsoft" or platform.system() == "Windows":
         self.components.useARDEC.enabled = True
         self.components.useARDEC.visible = True
         if self.useExtProgram == ['True', 'yes', 'y', 'Yes', '1']:
            self.components.useARDEC.checked = True

   def enableINDICheck(self):
      self.components.useINDI.enabled = True
      if self.useINDIProgram == ['True', 'yes', 'y', 'Yes', '1']:
         self.components.useINDI.checked = True

   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)
   
   def setGui(self):
      self.components.useARDEC.label = self.getText(self.faketext)
      self.components.useINDI.label = self.getText(self.inditext)
      self.components.closeButton.label = self.getText('closeButton')
      self.components.defaultButton.label = self.getText('defaultButton')
      self.components.applyButton.label = self.getText('applyButton')
      self.components.extraBox.label = self.getText('extraBox')
      self.components.enableStream.label =  self.getText('enableStream')
      self.components.askStream.label = self.getText('askStream')

   def on_applyButton_mouseClick(self, event=None):
      if self.components.useARDEC.checked:
         config.put_extProgram('True')
         self._parent.useExtProgram = 'True'
         self._parent.startFake()
      else:
         config.put_extProgram('False')
         self._parent.useExtProgram = 'False'
         self._parent.stopFake()

      if self.components.useINDI.checked:
         config.put_extINDIProgram('True')
         self._parent.useINDIProgram = 'True'
         self._parent.startINDI()
      else:
         config.put_extINDIProgram('False')
         self._parent.useINDIProgram = 'False'
         self._parent.stopINDI()
      
      config.put_streamingPref(self.components.enableStream.checked, self.components.askStream.checked)
      self._parent.askStream = str(self.components.askStream.checked)
      self._parent.enableStream = str(self.components.enableStream.checked)


      oldres = self._parent.forcedLowRes
      newres = self.components.forceLowRes.checked
      if oldres != newres:
         config.put_lowResPref(newres)
         self._parent.forcedLowRes = newres
         # TODO: change resolution at runtime!
         dialog.alertDialog(self, 'Please restart program to take effect')
   
   def on_defaultButton_mouseClick(self, event):
      self.components.useARDEC.checked = False
      self.components.useINDI.checked =  False
      self.components.forceLowRes.checked = False
      self.on_applyButton_mouseClick()

   def on_closeButton_mouseClick(self, event):
      self.parent.close()
