"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""


from skylive import config, conn, protocol
from skylive.utils import genutils as utils
import maingui
import wx, time, sys, os, platform
from Pycard import model, resource


class skyLive(model.Background):

   mainpanel=False

   def __getattribute__(self, name):
      try:
         selfattr = model.Background.__getattribute__(self, name)
         return selfattr
      except:
         mainpanel = model.Background.__getattribute__(self, 'mainpanel')
         if mainpanel:
            if hasattr(mainpanel, name):
               return getattr(mainpanel, name)

   def on_initialize(self, event):
      config.initialize()
      sysType = utils.platform()
      if sysType == "Microsoft":
         self.systemType = "Windows"
      else:
         self.systemType = sysType
      if (self.systemType == 'Linux') and (utils.is_eeepc()) or config.get_lowResPref('boot'):
         self.systemType = 'EeePC'
      if not self.systemType in ['EeePC', 'Linux', 'Windows', 'Darwin']:
         self.systemType='Linux'

      mainrsrc = resource.ResourceFile("./gui/maingui."+self.systemType+".rsrc.py").getResource()
      self.mainpanel = maingui.mainPanel(self, mainrsrc.application.backgrounds[0])
      #self.mainpanel.visible = True

