"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""


from Pycard import model, graphic
import ImageEnhance, wx, ImageOps
try:
   from PIL import Image
except:
   import Image
from skylive.lang import language

class imageAdj(model.Background):

   def on_initialize(self, event):
      self.parent = self.getParent()
      self.image = self._parent.origImage
      self.lang = self.parent.lang
      self.gui = 'imageadj'
      self.ItemText = language.getItemText
      self.setGui()
      self.origImage = self.image[0]
      self.origImage2 = self.image[6]
      self.resetValues()

   def resetValues(self):
      self.brightedImg = False
      self.contrastedImg = False
      self.negSel = False
      self.components.Contrast.value = 100
      self.components.Bright.value = 100
      self.contrValue = 1.0
      self.brightValue = 1.0
      #self.minNewVal = -1 # assigned -1 because min max value are positive when setted
      #self.maxNewVal = -1
      # hack to put stretch bars to the right levels on open and on reset
      self.maxNewVal = self._parent.autoMax
      self.minNewVal = self._parent.autoMin
      self.components.strMax.value = self.minNewVal
      self.components.strMax.value = self.maxNewVal
      self.stretchImage()
      # end hack
      self.components.contrShow.text = str(int(self.contrValue*100))+"%"
      self.components.brightShow.text = str(int(self.brightValue*100))+"%"
      self.actualModImage = self.origImage
      self.getMinMax(self.origImage)
      

   def on_Contrast_select(self, event):
      self.contrValue = float(self.components.Contrast.value) / 100
      self.components.contrShow.text = str(int(self.contrValue*100))+"%"
      if self.brightedImg:
         if self.brightedImg != self.actualModImage:
            ImageToMod = self.actualModImage
         else:
            ImageToMod = self.brightedImg
      else:
         if self.origImage != self.actualModImage:
            ImageToMod = self.actualModImage
         else:
            ImageToMod = self.origImage
      modImage = ImageEnhance.Contrast(ImageToMod)
      newmodImage = modImage.enhance(self.contrValue)
      self.contrastedImg = newmodImage
      self.refreshImg(newmodImage)

   def on_Bright_select(self, event):
      self.brightValue = float(self.components.Bright.value) / 100
      self.components.brightShow.text = str(int(self.brightValue*100))+"%"
      if self.contrastedImg:
         if self.contrastedImg != self.actualModImage:
            ImageToMod = self.actualModImage
         else:
            ImageToMod = self.contrastedImg
      else:
         if self.origImage != self.actualModImage:
            ImageToMod = self.actualModImage
         else:
            ImageToMod = self.origImage
      modImage = ImageEnhance.Brightness(ImageToMod)
      newmodImage = modImage.enhance(self.brightValue)
      self.brightedImg = newmodImage
      self.refreshImg(newmodImage)

   def refreshImg(self, imgmod):
      self._parent.pilImage = imgmod
      if self.image[7]:
         imgTomod = imgmod.resize((self.image[1], self.image[2]))
      else:
         imgTomod = imgmod
      image = wx.EmptyImage(self.image[1], self.image[2])
      image.SetData(imgTomod.convert("RGB").tostring())
      newBitmap = graphic.Bitmap()
      newBitmap.setImageBits(image)
      self._parent.components.ImageShow.bitmap = newBitmap
      if self.contrValue == 1.0:
         self.contrastedImg = False
      if self.brightValue == 1.0:
         self.brightedImg = False

   def on_resetButton_mouseClick(self, event):
      self.resetValues()
      self.origImage = self.image[0]
      self.refreshImg(self.origImage)
      
   def on_negativeButton_mouseClick(self, event):
      if self.negSel:
         self.components.negativeButton.label = u"Negative"
         self.negSel = False
      else:
         self.components.negativeButton.label = u"Positive"
         self.negSel = True
      newmodImage = ImageOps.invert(self.actualModImage)
      self.refreshImg(newmodImage)
      self.actualModImage = newmodImage
   
   def on_autoContrastButton_mouseClick(self, event):
      newmodImage = ImageOps.autocontrast(self.actualModImage, 0)
      self.refreshImg(newmodImage)
      self.actualModImage = newmodImage
      
   def on_equalizeButton_mouseClick(self, event):
      newmodImage = ImageOps.equalize(self.actualModImage)
      self.refreshImg(newmodImage)
      self.actualModImage = newmodImage
      
   def stretchImage(self):
      if self.minNewVal == -1:
         min = self.strMinImg
      else:
         min = self.minNewVal
      if self.maxNewVal == -1:
         max = self.strMaxImg
      else:
         max = self.maxNewVal
      if (max - min) != 0:
         scale = self.image[5] / (max - min)
         offset = -min * scale
         newmodImage = self.origImage2.point(lambda i: i * scale + offset)
         newmodImage = ImageOps.grayscale(newmodImage)
         imgToview = self.applyPrevContrBright(newmodImage)
         self.refreshImg(imgToview)
         self.actualModImage = imgToview
      else:
         pass
   
   def getMinMax(self, imgmod):
      #min,max = imgmod.getextrema()
      min = self.image[3]
      max = self.image[4]
      self.components.strMin.min = min
      self.components.strMin.max = max
      self.components.strMin.value = self.minNewVal
      self.components.strMinVal.text = str(int(self.minNewVal))
      self.components.strMax.min = min
      self.components.strMax.max = max
      self.components.strMax.value = self.maxNewVal
      self.components.strMaxVal.text = str(int(self.maxNewVal))
      self.strMinImg = min
      self.strMaxImg = max

   def on_strMin_select(self, event):
      self.minNewVal = self.components.strMin.value
      self.components.strMinVal.text = str(self.minNewVal)
      self.stretchImage()

   def on_strMax_select(self, event):
      self.maxNewVal = self.components.strMax.value
      self.components.strMaxVal.text = str(self.maxNewVal)
      self.stretchImage()
   
   def getText(self, item):
      return self.ItemText(self.lang, self.gui, item)

   def setGui(self):
      self.components.luminanceTXT.text = self.getText('luminanceTXT')
      self.components.contrastTXT.text = self.getText('contrastTXT')
      self.components.adjustBox.label = self.getText('adjustBox')
      self.components.toolsBox.label = self.getText('toolsBox')
      self.components.resetButton.label = self.getText('resetButton')
      self.components.negativeButton.label = self.getText('negativeButton')
      self.components.autoContrastButton.label = self.getText('autoContrastButton')
      self.components.equalizeButton.label = self.getText('equalizeButton')
   
   def applyPrevContrBright(self, img):
      brightImage = ImageEnhance.Brightness(img)
      brightedIMG = brightImage.enhance(self.brightValue)
      contrastImage = ImageEnhance.Contrast(brightedIMG)
      contrastedImage = contrastImage.enhance(self.contrValue)
      return contrastedImage
      
      

      
