"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""


import wx
import math
from Pycard import model, resource
from skylive.lang import language

ID_OK=10
ID_CANCEL=15
ID_REG=20
ID_LOST=21
ID_NO=11
ID_LATER=12


ItemText = language.getItemText

def getText(item):
   from skylive import config
   lang = config.get_usrLang()
   return ItemText(lang, 'gui', item)


class loginDialog(wx.Dialog):
   
   def __init__(self):
      wx.Dialog.__init__(self, None, wx.NewId(), "SkyLive Login", 
            style=wx.DEFAULT_DIALOG_STYLE | wx.STAY_ON_TOP | wx.CAPTION)
      self.main_sizer = wx.FlexGridSizer(cols=2, vgap=5, hgap=5)

      self.username = wx.TextCtrl(self, 1, size=(150, -1))
      self.main_sizer.Add(wx.StaticText(self, -1, "Username"),1, wx.ALIGN_CENTER)
      self.main_sizer.Add(self.username, 1, wx.ALIGN_CENTER)
      #self.main_sizer.Add(wx.StaticText(self, -1, " "),1, wx.ALIGN_CENTER)

      self.password = wx.TextCtrl(self, -1, style=wx.TE_PASSWORD, size=(150, -1))
      self.main_sizer.Add(wx.StaticText(self, -1, "Password"),1, wx.ALIGN_CENTER)
      self.main_sizer.Add(self.password, 1, wx.ALIGN_CENTER)
      #self.main_sizer.Add(wx.StaticText(self, -1, " "),1, wx.ALIGN_CENTER)


      self.button_sizer = wx.FlexGridSizer(cols=2, vgap=5, hgap=5)

      self.ok_button = wx.Button(self, ID_OK, "OK")
      #self.main_sizer.Add(wx.StaticText(self, -1, " "),1, wx.ALIGN_CENTER)
      self.button_sizer.Add(self.ok_button,1, wx.ALIGN_CENTER)
      #self.main_sizer.Add(wx.StaticText(self, -1, " "),1, wx.ALIGN_CENTER)
      wx.EVT_BUTTON(self, ID_OK, self.Ok)

      self.cancel_button = wx.Button(self, ID_CANCEL, "CANCEL")
      #self.main_sizer.Add(wx.StaticText(self, -1, " "),1, wx.ALIGN_CENTER)
      self.button_sizer.Add(self.cancel_button, 1, wx.ALIGN_CENTER)
      wx.EVT_BUTTON(self, ID_CANCEL, self.cancel)


      # XXX Questo lo rimettiamo!
      #self.reg_button = wx.Button(self, ID_REG, "new login")
      #self.button_sizer.Add(self.reg_button, 1, wx.ALIGN_CENTER)
      #wx.EVT_BUTTON(self, ID_REG, self.register)

      # XXX Questo lo rimettiamo!
      #self.lost_button = wx.Button(self, ID_LOST, "lost login")
      #self.button_sizer.Add(self.lost_button, 1, wx.ALIGN_CENTER)
      #wx.EVT_BUTTON(self, ID_LOST, self.lostaccount)

      #self.hbox = wx.BoxSizer(wx.HORIZONTAL)
      self.hbox = wx.BoxSizer(wx.VERTICAL)
      self.hbox.Add(self.main_sizer, 1, wx.ALL | wx.EXPAND, 10)
      self.hbox.Add(self.button_sizer, 1, wx.ALIGN_CENTER_HORIZONTAL, 1)
      self.SetSizer(self.hbox)
      self.SetAutoLayout(1)
      self.hbox.Fit(self)

   def register(self, event):
      self.SetReturnCode( ID_REG )
      self.EndModal( ID_REG )
      #import register
      #self.Pop = model.childWindow(self, register.Register, "./gui/register.rsrc.py")
      #self.Pop.title = self.getText('downloadtitle')+size+" kb"
      #self.Pop.components.downpr.text = self.getText('downloadtext')+size+" kb"
      #self.Pop.visible = True


   def lostaccount(self, event):
      import lostaccount
      self.Pop = model.childWindow(self, lostaccount.LostAccount, "./gui/lostaccount.rsrc.py")
      #self.Pop.title = self.getText('downloadtitle')+size+" kb"
      #self.Pop.components.downpr.text = self.getText('downloadtext')+size+" kb"
      self.Pop.visible = True


   def Ok(self, event):
      self.SetReturnCode( ID_OK )
      self.EndModal( ID_OK )
   
   def cancel(self, event):
      self.SetReturnCode( ID_CANCEL )
      self.EndModal( ID_CANCEL )
      

def OldLogin():
   dl=loginDialog()
   dl.Enable(enable=True)
   mainbg = wx.GetApp().getCurrentBackground()
   ret = dl.ShowModal()
   if ID_OK==ret:
      user = dl.username.GetValue()
      pwd = dl.password.GetValue()
      if len(user) < 1:
         user=None
      if len(pwd) < 4:
         pwd=None
      print 'OK'
      return [user, pwd]
   elif ID_CANCEL==ret:
      user = "stoplogin"
      pwd = "stoplogin"
      print 'CANCEL'
      return [user, pwd]
   elif ID_REG==ret:
      import register,time
      Pop = model.childWindow(mainbg, register.Register, "./gui/register.rsrc.py")
      Pop.visible = True
      Pop.done = False
      while not Pop.done:
         time.sleep(0.2)
      print 'USCITO!'
   else:
      print 'NONE'
      return [None, None] 

def Login():
   done=False
   todo='login'
   while not done:

      if todo=='login':
         dl=loginDialog()
         dl.Enable(enable=True)
         ret = dl.ShowModal()
         if ID_OK==ret:
            user = dl.username.GetValue()
            pwd = dl.password.GetValue()
            if len(user) < 1:
               user=None
            if len(pwd) < 4:
               pwd=None
            print 'OK'
            done=True
            retvar = [user, pwd]
         elif ID_CANCEL==ret:
            user = "stoplogin"
            pwd = "stoplogin"
            print 'CANCEL'
            done=True
            retvar =  [user, pwd]
         elif ID_REG==ret:
            todo='register'
         else:
            print 'NONE'
            done=True
            retvar = [None, None]

      elif todo=='register':
         import register
         dl=register.Register(wx.GetApp().getCurrentBackground(), 
               resource.ResourceFile("./gui/register.rsrc.py").getResource())
         dl.visible=True
         ret = dl.ShowModal()
         print 'USCITO'

   return retvar
      

upgradeText="""
Una nuova versione di SkyliveNG e' disponibile.
Vuoi aggiornare ora?

A new version of the SkyliveNG client is available.
Do you want to upgrade now?
"""

class upgradeDialog(wx.Dialog):

   def __init__(self):
      wx.Dialog.__init__(self, None, wx.NewId(), "SkyliveNG Upgrade",
            style=wx.DEFAULT_DIALOG_STYLE | wx.STAY_ON_TOP | wx.CAPTION)
      self.main_sizer = wx.FlexGridSizer(cols=1, vgap=5, hgap=5)
      self.main_sizer.Add(wx.StaticText(self, -1, getText("upgradeText")),1, wx.ALIGN_CENTER)

      self.button_sizer = wx.FlexGridSizer(cols=3, vgap=5, hgap=5)
      
      self.ok_button = wx.Button(self, ID_OK, "OK")
      self.button_sizer.Add(self.ok_button,1, wx.ALIGN_CENTER)
      wx.EVT_BUTTON(self, ID_OK, self.Ok)

      self.no_button = wx.Button(self, ID_NO, "NO")
      self.button_sizer.Add(self.no_button, 1, wx.ALIGN_CENTER)
      wx.EVT_BUTTON(self, ID_NO, self.no)

      self.later_button = wx.Button(self, ID_LATER, "LATER")
      self.button_sizer.Add(self.later_button, 1, wx.ALIGN_CENTER)
      wx.EVT_BUTTON(self, ID_LATER, self.later)

      self.hbox = wx.BoxSizer(wx.VERTICAL)
      self.hbox.Add(self.main_sizer, 1, wx.ALL | wx.EXPAND, 10)
      self.hbox.Add(self.button_sizer, 0, wx.ALIGN_CENTER_HORIZONTAL, 1)
      self.SetSizer(self.hbox)
      self.SetAutoLayout(1)
      self.hbox.Fit(self)
      

   def Ok(self, event):
      self.SetReturnCode( ID_OK )
      self.EndModal( ID_OK )

   def later(self, event):
      self.SetReturnCode( ID_LATER )
      self.EndModal( ID_LATER )

   def no(self, event):
      self.SetReturnCode( ID_NO )
      self.EndModal( ID_NO )

def Upgrade():
   du = upgradeDialog()
   du.Enable(enable=True)
   mainbg = wx.GetApp().getCurrentBackground()
   ret = du.ShowModal()
   if ID_OK==ret:
      return 'UPGRADE'
   elif ID_NO==ret:
      return 'NOUPGRADE'
   return 'LATERUPGRADE'
