
"""
__version__ = "$Revision: 1.29 $"
__date__ = "$Date: 2005/12/25 13:44:50 $"
"""

import wx
from Pycard import event, widget
from Pycard.components import list as orlist


ContainerMixin = orlist.ContainerMixin
ListSelectEvent = orlist.ListSelectEvent
ListMouseDoubleClickEvent = orlist.ListMouseDoubleClickEvent


class UListSpec(widget.WidgetSpec):
   def __init__(self):
      events = list(orlist.ListEvents)
      attributes = {
         'items' : { 'presence' : 'optional', 'default' : [] },
         'stringSelection' : { 'presence' : 'optional', 'default' : None }
      }
      widget.WidgetSpec.__init__( self, 'UList', 'Widget', events, attributes )
      self._events.remove(event.MouseDoubleClickEvent)

class UList(orlist.List):
   """
   A list that only allows a single item to be selected.
   """
   
   _spec = UListSpec()

   def __init__(self, aParent, aResource):
      wx.ListBox.__init__(
         self,
         aParent, 
         widget.makeNewId(aResource.id), 
         aResource.position, 
         aResource.size, 
         aResource.items,
         style = wx.LB_SINGLE | wx.LB_ALWAYS_SB | wx.NO_FULL_REPAINT_ON_RESIZE | wx.CLIP_SIBLINGS,
         name = aResource.name
      )

      widget.Widget.__init__(self, aParent, aResource)

      if aResource.stringSelection:
         self._setStringSelection(aResource.stringSelection)

      self._bindEvents(self._spec._events)

import sys
from Pycard import registry
registry.Registry.getInstance().register(sys.modules[__name__].UList)

