#!/bin/sh

up="NO"
root="NO"
if [ "$UID" = "0" ] ; then
   root="SI"
fi

if [ "$1" = "UPGRADE" ] ; then
   root="NO"
   up="SI"
fi

if [ "$up" = "NO" ] ; then
   echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
   echo
   echo "       SkyliveNG V 0.1.4 Installer"
   echo
   echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
   echo
fi


ask_yn()
{
   if [ -n "$1" ] ; then
      question=$1
      if [ -n "$2" ] ; then
         def="$2"
      else
         def="N"
      fi
      
      don=""
      resp="$def"

      while [ x"$don" = x"" ] ; do
         read -p "$question ($def) " userinput
         if [ x"$userinput" != x"" ] ; then
            resp=$userinput
         else
            resp=$def
         fi
         case "$resp" in
            y|Y|yes|Yes)
               ret=0
               don="Y"
               ;;
            n|N|no|No)
               don="Y"
               ret=1
               ;;
         esac
      done
      return $ret
   fi
}


cancel() 
{
   if [ -n $1 ] ; then
      echo "$1"
   fi
   exit 0
}

if [ "$up" = "NO" ] ; then
   question="Do you want to install SkyliveNG client?"
   ask_yn "$question" "N" || cancel "Cancelling."

   if [ -f LICENSE.txt ] ; then
      cat LICENSE.txt | more
      question="Do you accept the License?"
      ask_yn "$question" "N" || cancel "Cancelling."
   fi
fi


if [ "$root" = "SI" ] ; then
   skpath="/usr/share/skylive"
   if [ -d /usr/bin ] ; then
      d="/usr/bin"
   else
      d="/bin"
   fi
else
   skpath="$HOME/.SkyLIVE"
fi


if [ -d "${skpath}" ] ; then
   if [ "$up" = "NO" ] ; then
      echo "The installer has detected another skyliveng installation."
      question="Would you like to override the old install?"
      ask_yn "$question" "N" || cancel "Cancelling."
   fi
   rm -rf ${skpath}
   if [ "$root" = "SI" ] ; then
      rm -f $d/skylive
   fi
fi

if [ "$up" = "NO" ] ; then
   echo -n "Copying files... "
fi
mkdir -p ${skpath}
cp -r ./*  ${skpath}
if [ "$up" = "NO" ] ; then
   echo "OK"
fi

if [ "$up" = "NO" ] ; then
   echo -n "Fixing permission... "
fi
chmod +x ${skpath}/skylive-ng 
if [ "$up" = "NO" ] ; then
   echo "OK"
fi

if [ "$up" = "NO" ] ; then
   echo -n "Generating launcher wrapper... "
fi

if [ "$root" = "SI" ] ; then
   cat >  $d/skylive << EOF
#!/bin/sh
if [ -f "\$HOME/.SkyLIVE/skylivengWrap" ] ; then
   u="NO"
   if [ -f "\$HOME/.SkyLIVE/VERSION.txt" ] ; then
      if [ -f "/usr/share/skylive/VERSION.txt" ] ; then
         rv=\$(cat /usr/share/skylive/VERSION.txt)
         uv=\$(cat "\$HOME/.SkyLIVE/VERSION.txt")
         if [ "\$uv" -gt "\$rv"  ] ; then
            u="OK"
         fi
      else
         u="OK"
      fi
   fi
else
   u="NO"
fi

if [ "\$u" = "OK" ] ; then
   . \$HOME/.SkyLIVE/skylivengWrap
else
   if [ ! -h "\$HOME/Desktop/skyliveng.desktop" ] ; then
      ln -s /usr/share/skylive/skyliveng.desktop \$HOME/Desktop/skyliveng.desktop
   fi
   SKYPATH=/usr/share/skylive
   SKYLINKER=\$SKYPATH/lib/ld-linux.so.2
   cd "\$SKYPATH"
   export GSTREAMER_PLUGIN_SYSTEM_PATH="\$SKYPATH/lib/gstreamer-0.10"
   export GST_PLUGIN_SYSTEM_PATH="\${GSTREAMER_PLUGIN_SYSTEM_PATH}"
   export GNOME_VFS_MODULE_PATH="\$SKYPATH/lib/gnome-vfs-2.0/modules/"
   LD_LIBRARY_PATH=\$SKYPATH:\$SKYPATH/lib \$SKYLINKER ./skylive-ng \$@ >/dev/null 2>&1
fi

EOF

chmod +x $d/skylive
else
   cat >  ${skpath}/skylivengWrap << EOF
#!/bin/sh
SKYPATH=${skpath}
SKYLINKER=\$SKYPATH/lib/ld-linux.so.2
cd "\$SKYPATH"
export GSTREAMER_PLUGIN_SYSTEM_PATH="\$SKYPATH/lib/gstreamer-0.10"
export GST_PLUGIN_SYSTEM_PATH="\${GSTREAMER_PLUGIN_SYSTEM_PATH}"
export GNOME_VFS_MODULE_PATH="\$SKYPATH/lib/gnome-vfs-2.0/modules/"
LD_LIBRARY_PATH=\$SKYPATH:\$SKYPATH/lib \$SKYLINKER ./skylive-ng \$@ >/dev/null 2>&1
EOF
chmod +x ${skpath}/skylivengWrap
fi
if [ "$up" = "NO" ] ; then
   echo "OK"
fi

if [ "$up" = "NO" ] ; then
   echo -n "Trying to install .desktop file..."
fi

desk="NO"
if [ "$root" = "SI" ] ; then
   if [ -d "/usr/share/applications" ] ; then
      rm -f /usr/share/applications/skyliveng.desktop
      ln -s /usr/share/skylive/skyliveng.desktop /usr/share/applications/skyliveng.desktop
      desk="SI"
   fi
else
   
   cat > ${skpath}/skyliveng.desktop << EOF
[Desktop Entry]
Name=SkyLiveNG
Exec=${skpath}/skylivengWrap
Icon=${skpath}/ICONA.ico
Categories=Science;Astronomy;Education;

EOF
   if [ -d $HOME/Desktop/ ] ; then
      rm -f $HOME/Desktop/skyliveng.desktop
      ln -s ${skpath}/skyliveng.desktop $HOME/Desktop/skyliveng.desktop
      desk="SI"
   fi
   if [ "$desk" != "SI" ] ; then
      xdg=`which xdg-desktop-icon`
      if [ x"$xdg" != x"" ] ; then
         xdg-desktop-icon install --novendor ${skpath}/skyliveng.desktop
         desk="SI"
      fi
   fi
fi
if [ "$up" = "NO" ] ; then
   if [ "$desk" = "SI" ] ; then
      echo "OK"
   else
      echo "No. I can't."
   fi
fi

if [ "$up" = "NO" ] ; then
   echo -n "Trying to install menu entry..."
fi
me="NO"
if [ "$root" = "SI" ] ; then
   xdg=`which xdg-desktop-menu`
   if [ x"$xdg" != x"" ] ; then
      export XDG_UTILS_INSTALL_MODE="system"
      xdg-desktop-menu install --novendor --mode system ${skpath}/skylive-science.directory ${skpath}/skyliveng.desktop
      me="SI"
   fi
else
   xdg=`which xdg-desktop-menu`
   if [ x"$xdg" != x"" ] ; then
      export XDG_UTILS_INSTALL_MODE="user"
      xdg-desktop-menu install --novendor --mode user ${skpath}/skylive-science.directory ${skpath}/skyliveng.desktop
      me="SI"
   fi
fi
if [ "$up" = "NO" ] ; then
   if [ "$me" = "SI" ] ; then
      echo "OK"
   else
      echo "No. I can't."
   fi
fi

if [ "$up" = "NO" ] ; then
   echo -n "Cleaning installer..."
fi
rm -f ${skpath}/linux_install.sh

if [ "$up" = "NO" ] ; then
   echo "OK"
   echo 
   echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
   echo "                                                                                "
   if [ "$root" = "SI" ] ; then
      echo " Installation finished. Launch \"$d/skylive\" to run the client.    "
   else
      echo " Installation finished. Launch \"${skpath}/skylivengWrap\" to run the client    "
   fi
   echo " For more informations, look at the \"$skpath/README.txt\" file.  "
   echo "                                                                                "
   echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
   echo
else
   setsid ${skpath}/skylivengWrap
fi
