; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=Skylive-NG
AppVerName=Skylive-NG 0.1.5
AppPublisher=Skylive
AppPublisherURL=http://www.skylive.it/
AppSupportURL=http://www.skylive.it/
AppUpdatesURL=http://www.skylive.it/
DefaultDirName={pf}\Skylive-NG
DefaultGroupName=Skylive-NG
LicenseFile=..\dist\LICENSE.txt
OutputBaseFilename=SkyliveNG-0.1.5_Win32_install
SetupIconFile=..\dist\ICONA.ico
Compression=lzma/ultra
VersionInfoVersion=0.1.5.5
SolidCompression=yes

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; 
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; 

; Temporaneo
[InstallDelete]
Type: filesandordirs; Name: "{app}\skylive"
Type: files; Name: "{app}\skylive*"
Type: files; Name: "{app}\*rsrc.py"

[Files]
Source: "..\scripts\kill.exe"; DestDir: "{tmp}"; AfterInstall: killProc
Source: "..\scripts\oggcodecs.exe"; DestDir: "{tmp}"; AfterInstall: InstallVorbis
Source: "..\dist\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs

[Icons]
Name: "{group}\Skylive-NG"; Filename: "{app}\skylive-ng.exe"; WorkingDir: "{app}"; IconFilename: "{app}\ICONA.ico"
Name: "{group}\{cm:ProgramOnTheWeb,Skylive-NG}"; Filename: "http://www.skylive.it/"
Name: "{group}\{cm:UninstallProgram,Skylive-NG}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\Skylive-NG"; Filename: "{app}\skylive-ng.exe"; Tasks: desktopicon; WorkingDir: "{app}"; IconFilename: "{app}\ICONA.ico"
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Skylive-NG"; Filename: "{app}\skylive-ng.exe"; Tasks: quicklaunchicon; WorkingDir: "{app}"; IconFilename: "{app}\ICONA.ico"

[Run]
Filename: "{app}\README.txt"; Description: "Read README.txt"; Flags: shellexec nowait skipifsilent unchecked
Filename: "{app}\skylive-ng.exe"; Description: "{cm:LaunchProgram,Skylive-NG}"; Flags: nowait postinstall
 
[Code]
procedure killProc();
var
   ReturnCode: Integer;
begin
   Exec(ExpandConstant('{tmp}\kill.exe'), 'skylive-ng.exe', '', SW_HIDE, ewWaitUntilTerminated, ReturnCode);
end;

procedure InstallVorbis();
var
   ReturnCode: Integer;
begin
   Exec(ExpandConstant('{tmp}\oggcodecs.exe'), '/S', '', SW_HIDE, ewWaitUntilTerminated, ReturnCode);
end;

