#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
test_extension.py - A script to test the chrome.runtime API emulation with a test extension

This script launches the browser with the test extension loaded and opens the test extension's popup
to verify that the chrome.runtime API emulation works correctly.
"""

import os
import sys
import time
from test import main as browser_main

def main():
    """Main function to run the browser with the test extension."""
    # Make sure the test extension exists
    test_ext_dir = "assets/browser/extensions/test-extension"
    if not os.path.exists(test_ext_dir):
        print(f"Error: Test extension directory not found: {test_ext_dir}")
        return 1
    
    # Check for manifest.json
    manifest_path = os.path.join(test_ext_dir, "manifest.json")
    if not os.path.exists(manifest_path):
        print(f"Error: Manifest file not found: {manifest_path}")
        return 1
    
    # Set up command line arguments
    sys.argv = [sys.argv[0], "--ext-dev-mode"]
    
    # Launch the browser
    print("Launching browser with test extension...")
    return browser_main()

if __name__ == "__main__":
    sys.exit(main())