# Chrome Extension Runtime API Emulation

This directory contains a test extension and implementation for emulating the Chrome Extension Runtime API in our Qt6-based browser.

## Overview

The implementation consists of:

1. **RuntimeBridge** (`assets/browser/js/runtime_bridge.py`): A Python QObject that bridges between the browser and JavaScript
2. **chrome-runtime-api.js** (`assets/browser/js/chrome-runtime-api.js`): JavaScript implementation of the chrome.runtime API
3. **Test Extension** (`assets/browser/extensions/test-extension/`): A simple extension to test the API implementation

## Supported APIs

The following chrome.runtime APIs are supported:

- `chrome.runtime.id` - Returns the extension ID
- `chrome.runtime.getURL()` - Converts a relative path to a fully-qualified extension URL
- `chrome.runtime.getManifest()` - Returns the extension's manifest.json contents
- `chrome.runtime.sendMessage()` - Sends a message to the extension or another extension
- `chrome.runtime.onMessage` - Event fired when a message is received
- `chrome.runtime.connect()` - Creates a connection to the extension or another extension
- `chrome.runtime.onConnect` - Event fired when a connection is made
- `chrome.runtime.getBackgroundPage()` - Returns the background page
- Various lifecycle events: `onInstalled`, `onStartup`, `onSuspend`, `onUpdateAvailable`

## Test Extension

The test extension demonstrates the use of the chrome.runtime API. It includes:

- **Popup** (`popup.html`, `popup.js`): A simple UI to test various chrome.runtime methods
- **Background Script** (`background.js`): A background script that listens for messages and connections
- **Content Script** (`content.js`): A content script that injects a control panel into web pages

## Testing

To test the chrome.runtime API implementation:

1. Run the test script: `python test_extension.py`
2. Click the "Test Extension" button in the toolbar
3. Use the buttons in the popup to test various chrome.runtime API methods
4. Check the browser console for log messages

You can also test the content script by navigating to any website and looking for the control panel in the bottom-right corner.

## Implementation Details

### Extension Loading

Extensions are loaded from the `assets/browser/extensions` directory and copied to the browser profile's extensions directory. The browser scans for extensions on startup and registers them with the runtime bridge.

### URL Scheme Handling

The browser uses a custom URL scheme handler (`qextension://`) to load extension resources. This allows extensions to use relative paths in their manifest and code.

### Message Passing

Message passing is implemented using QWebChannel to communicate between JavaScript and Python. The RuntimeBridge class handles routing messages between different parts of an extension.

### Background Pages

Background pages are loaded in hidden tabs. For service workers, a special HTML page is created that loads the service worker script.

## Limitations

- This is a simplified implementation and does not support all chrome.runtime APIs
- Service workers are not fully supported; they are loaded in a regular page context
- Cross-extension messaging is limited
- Some APIs may behave differently than in Chrome