/*! @name videojs-xr @version 0.1.0 @license MIT */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('video.js'), require('global/window')) :
  typeof define === 'function' && define.amd ? define(['video.js', 'global/window'], factory) :
  (global = global || self, global.videojsXr = factory(global.videojs, global.window));
}(this, (function (videojs, window$1) { 'use strict';

  videojs = videojs && Object.prototype.hasOwnProperty.call(videojs, 'default') ? videojs['default'] : videojs;
  window$1 = window$1 && Object.prototype.hasOwnProperty.call(window$1, 'default') ? window$1['default'] : window$1;

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;

    _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  var version = "0.1.0";

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var _global = createCommonjsModule(function (module) {
  // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
  var global = module.exports = typeof window != 'undefined' && window.Math == Math
    ? window : typeof self != 'undefined' && self.Math == Math ? self
    // eslint-disable-next-line no-new-func
    : Function('return this')();
  if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef
  });

  var hasOwnProperty = {}.hasOwnProperty;
  var _has = function (it, key) {
    return hasOwnProperty.call(it, key);
  };

  var _fails = function (exec) {
    try {
      return !!exec();
    } catch (e) {
      return true;
    }
  };

  // Thank's IE8 for his funny defineProperty
  var _descriptors = !_fails(function () {
    return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
  });

  var _core = createCommonjsModule(function (module) {
  var core = module.exports = { version: '2.6.12' };
  if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef
  });
  var _core_1 = _core.version;

  var _isObject = function (it) {
    return typeof it === 'object' ? it !== null : typeof it === 'function';
  };

  var _anObject = function (it) {
    if (!_isObject(it)) throw TypeError(it + ' is not an object!');
    return it;
  };

  var document$1 = _global.document;
  // typeof document.createElement is 'object' in old IE
  var is = _isObject(document$1) && _isObject(document$1.createElement);
  var _domCreate = function (it) {
    return is ? document$1.createElement(it) : {};
  };

  var _ie8DomDefine = !_descriptors && !_fails(function () {
    return Object.defineProperty(_domCreate('div'), 'a', { get: function () { return 7; } }).a != 7;
  });

  // 7.1.1 ToPrimitive(input [, PreferredType])

  // instead of the ES6 spec version, we didn't implement @@toPrimitive case
  // and the second argument - flag - preferred type is a string
  var _toPrimitive = function (it, S) {
    if (!_isObject(it)) return it;
    var fn, val;
    if (S && typeof (fn = it.toString) == 'function' && !_isObject(val = fn.call(it))) return val;
    if (typeof (fn = it.valueOf) == 'function' && !_isObject(val = fn.call(it))) return val;
    if (!S && typeof (fn = it.toString) == 'function' && !_isObject(val = fn.call(it))) return val;
    throw TypeError("Can't convert object to primitive value");
  };

  var dP = Object.defineProperty;

  var f = _descriptors ? Object.defineProperty : function defineProperty(O, P, Attributes) {
    _anObject(O);
    P = _toPrimitive(P, true);
    _anObject(Attributes);
    if (_ie8DomDefine) try {
      return dP(O, P, Attributes);
    } catch (e) { /* empty */ }
    if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
    if ('value' in Attributes) O[P] = Attributes.value;
    return O;
  };

  var _objectDp = {
  	f: f
  };

  var _propertyDesc = function (bitmap, value) {
    return {
      enumerable: !(bitmap & 1),
      configurable: !(bitmap & 2),
      writable: !(bitmap & 4),
      value: value
    };
  };

  var _hide = _descriptors ? function (object, key, value) {
    return _objectDp.f(object, key, _propertyDesc(1, value));
  } : function (object, key, value) {
    object[key] = value;
    return object;
  };

  var id = 0;
  var px = Math.random();
  var _uid = function (key) {
    return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
  };

  var _library = false;

  var _shared = createCommonjsModule(function (module) {
  var SHARED = '__core-js_shared__';
  var store = _global[SHARED] || (_global[SHARED] = {});

  (module.exports = function (key, value) {
    return store[key] || (store[key] = value !== undefined ? value : {});
  })('versions', []).push({
    version: _core.version,
    mode:  'global',
    copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
  });
  });

  var _functionToString = _shared('native-function-to-string', Function.toString);

  var _redefine = createCommonjsModule(function (module) {
  var SRC = _uid('src');

  var TO_STRING = 'toString';
  var TPL = ('' + _functionToString).split(TO_STRING);

  _core.inspectSource = function (it) {
    return _functionToString.call(it);
  };

  (module.exports = function (O, key, val, safe) {
    var isFunction = typeof val == 'function';
    if (isFunction) _has(val, 'name') || _hide(val, 'name', key);
    if (O[key] === val) return;
    if (isFunction) _has(val, SRC) || _hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));
    if (O === _global) {
      O[key] = val;
    } else if (!safe) {
      delete O[key];
      _hide(O, key, val);
    } else if (O[key]) {
      O[key] = val;
    } else {
      _hide(O, key, val);
    }
  // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
  })(Function.prototype, TO_STRING, function toString() {
    return typeof this == 'function' && this[SRC] || _functionToString.call(this);
  });
  });

  var _aFunction = function (it) {
    if (typeof it != 'function') throw TypeError(it + ' is not a function!');
    return it;
  };

  // optional / simple context binding

  var _ctx = function (fn, that, length) {
    _aFunction(fn);
    if (that === undefined) return fn;
    switch (length) {
      case 1: return function (a) {
        return fn.call(that, a);
      };
      case 2: return function (a, b) {
        return fn.call(that, a, b);
      };
      case 3: return function (a, b, c) {
        return fn.call(that, a, b, c);
      };
    }
    return function (/* ...args */) {
      return fn.apply(that, arguments);
    };
  };

  var PROTOTYPE = 'prototype';

  var $export = function (type, name, source) {
    var IS_FORCED = type & $export.F;
    var IS_GLOBAL = type & $export.G;
    var IS_STATIC = type & $export.S;
    var IS_PROTO = type & $export.P;
    var IS_BIND = type & $export.B;
    var target = IS_GLOBAL ? _global : IS_STATIC ? _global[name] || (_global[name] = {}) : (_global[name] || {})[PROTOTYPE];
    var exports = IS_GLOBAL ? _core : _core[name] || (_core[name] = {});
    var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});
    var key, own, out, exp;
    if (IS_GLOBAL) source = name;
    for (key in source) {
      // contains in native
      own = !IS_FORCED && target && target[key] !== undefined;
      // export native or passed
      out = (own ? target : source)[key];
      // bind timers to global for call from export context
      exp = IS_BIND && own ? _ctx(out, _global) : IS_PROTO && typeof out == 'function' ? _ctx(Function.call, out) : out;
      // extend global
      if (target) _redefine(target, key, out, type & $export.U);
      // export
      if (exports[key] != out) _hide(exports, key, exp);
      if (IS_PROTO && expProto[key] != out) expProto[key] = out;
    }
  };
  _global.core = _core;
  // type bitmap
  $export.F = 1;   // forced
  $export.G = 2;   // global
  $export.S = 4;   // static
  $export.P = 8;   // proto
  $export.B = 16;  // bind
  $export.W = 32;  // wrap
  $export.U = 64;  // safe
  $export.R = 128; // real proto method for `library`
  var _export = $export;

  var _meta = createCommonjsModule(function (module) {
  var META = _uid('meta');


  var setDesc = _objectDp.f;
  var id = 0;
  var isExtensible = Object.isExtensible || function () {
    return true;
  };
  var FREEZE = !_fails(function () {
    return isExtensible(Object.preventExtensions({}));
  });
  var setMeta = function (it) {
    setDesc(it, META, { value: {
      i: 'O' + ++id, // object ID
      w: {}          // weak collections IDs
    } });
  };
  var fastKey = function (it, create) {
    // return primitive with prefix
    if (!_isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
    if (!_has(it, META)) {
      // can't set metadata to uncaught frozen object
      if (!isExtensible(it)) return 'F';
      // not necessary to add metadata
      if (!create) return 'E';
      // add missing metadata
      setMeta(it);
    // return object ID
    } return it[META].i;
  };
  var getWeak = function (it, create) {
    if (!_has(it, META)) {
      // can't set metadata to uncaught frozen object
      if (!isExtensible(it)) return true;
      // not necessary to add metadata
      if (!create) return false;
      // add missing metadata
      setMeta(it);
    // return hash weak collections IDs
    } return it[META].w;
  };
  // add metadata on freeze-family methods calling
  var onFreeze = function (it) {
    if (FREEZE && meta.NEED && isExtensible(it) && !_has(it, META)) setMeta(it);
    return it;
  };
  var meta = module.exports = {
    KEY: META,
    NEED: false,
    fastKey: fastKey,
    getWeak: getWeak,
    onFreeze: onFreeze
  };
  });
  var _meta_1 = _meta.KEY;
  var _meta_2 = _meta.NEED;
  var _meta_3 = _meta.fastKey;
  var _meta_4 = _meta.getWeak;
  var _meta_5 = _meta.onFreeze;

  var _wks = createCommonjsModule(function (module) {
  var store = _shared('wks');

  var Symbol = _global.Symbol;
  var USE_SYMBOL = typeof Symbol == 'function';

  var $exports = module.exports = function (name) {
    return store[name] || (store[name] =
      USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : _uid)('Symbol.' + name));
  };

  $exports.store = store;
  });

  var def = _objectDp.f;

  var TAG = _wks('toStringTag');

  var _setToStringTag = function (it, tag, stat) {
    if (it && !_has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
  };

  var f$1 = _wks;

  var _wksExt = {
  	f: f$1
  };

  var defineProperty = _objectDp.f;
  var _wksDefine = function (name) {
    var $Symbol = _core.Symbol || (_core.Symbol =  _global.Symbol || {});
    if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: _wksExt.f(name) });
  };

  var toString = {}.toString;

  var _cof = function (it) {
    return toString.call(it).slice(8, -1);
  };

  // fallback for non-array-like ES3 and non-enumerable old V8 strings

  // eslint-disable-next-line no-prototype-builtins
  var _iobject = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
    return _cof(it) == 'String' ? it.split('') : Object(it);
  };

  // 7.2.1 RequireObjectCoercible(argument)
  var _defined = function (it) {
    if (it == undefined) throw TypeError("Can't call method on  " + it);
    return it;
  };

  // to indexed object, toObject with fallback for non-array-like ES3 strings


  var _toIobject = function (it) {
    return _iobject(_defined(it));
  };

  // 7.1.4 ToInteger
  var ceil = Math.ceil;
  var floor = Math.floor;
  var _toInteger = function (it) {
    return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
  };

  // 7.1.15 ToLength

  var min = Math.min;
  var _toLength = function (it) {
    return it > 0 ? min(_toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
  };

  var max = Math.max;
  var min$1 = Math.min;
  var _toAbsoluteIndex = function (index, length) {
    index = _toInteger(index);
    return index < 0 ? max(index + length, 0) : min$1(index, length);
  };

  // false -> Array#indexOf
  // true  -> Array#includes



  var _arrayIncludes = function (IS_INCLUDES) {
    return function ($this, el, fromIndex) {
      var O = _toIobject($this);
      var length = _toLength(O.length);
      var index = _toAbsoluteIndex(fromIndex, length);
      var value;
      // Array#includes uses SameValueZero equality algorithm
      // eslint-disable-next-line no-self-compare
      if (IS_INCLUDES && el != el) while (length > index) {
        value = O[index++];
        // eslint-disable-next-line no-self-compare
        if (value != value) return true;
      // Array#indexOf ignores holes, Array#includes - not
      } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
        if (O[index] === el) return IS_INCLUDES || index || 0;
      } return !IS_INCLUDES && -1;
    };
  };

  var shared = _shared('keys');

  var _sharedKey = function (key) {
    return shared[key] || (shared[key] = _uid(key));
  };

  var arrayIndexOf = _arrayIncludes(false);
  var IE_PROTO = _sharedKey('IE_PROTO');

  var _objectKeysInternal = function (object, names) {
    var O = _toIobject(object);
    var i = 0;
    var result = [];
    var key;
    for (key in O) if (key != IE_PROTO) _has(O, key) && result.push(key);
    // Don't enum bug & hidden keys
    while (names.length > i) if (_has(O, key = names[i++])) {
      ~arrayIndexOf(result, key) || result.push(key);
    }
    return result;
  };

  // IE 8- don't enum bug keys
  var _enumBugKeys = (
    'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
  ).split(',');

  // 19.1.2.14 / 15.2.3.14 Object.keys(O)



  var _objectKeys = Object.keys || function keys(O) {
    return _objectKeysInternal(O, _enumBugKeys);
  };

  var f$2 = Object.getOwnPropertySymbols;

  var _objectGops = {
  	f: f$2
  };

  var f$3 = {}.propertyIsEnumerable;

  var _objectPie = {
  	f: f$3
  };

  // all enumerable object keys, includes symbols



  var _enumKeys = function (it) {
    var result = _objectKeys(it);
    var getSymbols = _objectGops.f;
    if (getSymbols) {
      var symbols = getSymbols(it);
      var isEnum = _objectPie.f;
      var i = 0;
      var key;
      while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
    } return result;
  };

  // 7.2.2 IsArray(argument)

  var _isArray = Array.isArray || function isArray(arg) {
    return _cof(arg) == 'Array';
  };

  // 7.1.13 ToObject(argument)

  var _toObject = function (it) {
    return Object(_defined(it));
  };

  var _objectDps = _descriptors ? Object.defineProperties : function defineProperties(O, Properties) {
    _anObject(O);
    var keys = _objectKeys(Properties);
    var length = keys.length;
    var i = 0;
    var P;
    while (length > i) _objectDp.f(O, P = keys[i++], Properties[P]);
    return O;
  };

  var document$2 = _global.document;
  var _html = document$2 && document$2.documentElement;

  // 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])



  var IE_PROTO$1 = _sharedKey('IE_PROTO');
  var Empty = function () { /* empty */ };
  var PROTOTYPE$1 = 'prototype';

  // Create object with fake `null` prototype: use iframe Object with cleared prototype
  var createDict = function () {
    // Thrash, waste and sodomy: IE GC bug
    var iframe = _domCreate('iframe');
    var i = _enumBugKeys.length;
    var lt = '<';
    var gt = '>';
    var iframeDocument;
    iframe.style.display = 'none';
    _html.appendChild(iframe);
    iframe.src = 'javascript:'; // eslint-disable-line no-script-url
    // createDict = iframe.contentWindow.Object;
    // html.removeChild(iframe);
    iframeDocument = iframe.contentWindow.document;
    iframeDocument.open();
    iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
    iframeDocument.close();
    createDict = iframeDocument.F;
    while (i--) delete createDict[PROTOTYPE$1][_enumBugKeys[i]];
    return createDict();
  };

  var _objectCreate = Object.create || function create(O, Properties) {
    var result;
    if (O !== null) {
      Empty[PROTOTYPE$1] = _anObject(O);
      result = new Empty();
      Empty[PROTOTYPE$1] = null;
      // add "__proto__" for Object.getPrototypeOf polyfill
      result[IE_PROTO$1] = O;
    } else result = createDict();
    return Properties === undefined ? result : _objectDps(result, Properties);
  };

  // 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)

  var hiddenKeys = _enumBugKeys.concat('length', 'prototype');

  var f$4 = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
    return _objectKeysInternal(O, hiddenKeys);
  };

  var _objectGopn = {
  	f: f$4
  };

  // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window

  var gOPN = _objectGopn.f;
  var toString$1 = {}.toString;

  var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
    ? Object.getOwnPropertyNames(window) : [];

  var getWindowNames = function (it) {
    try {
      return gOPN(it);
    } catch (e) {
      return windowNames.slice();
    }
  };

  var f$5 = function getOwnPropertyNames(it) {
    return windowNames && toString$1.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(_toIobject(it));
  };

  var _objectGopnExt = {
  	f: f$5
  };

  var gOPD = Object.getOwnPropertyDescriptor;

  var f$6 = _descriptors ? gOPD : function getOwnPropertyDescriptor(O, P) {
    O = _toIobject(O);
    P = _toPrimitive(P, true);
    if (_ie8DomDefine) try {
      return gOPD(O, P);
    } catch (e) { /* empty */ }
    if (_has(O, P)) return _propertyDesc(!_objectPie.f.call(O, P), O[P]);
  };

  var _objectGopd = {
  	f: f$6
  };

  // ECMAScript 6 symbols shim





  var META = _meta.KEY;





















  var gOPD$1 = _objectGopd.f;
  var dP$1 = _objectDp.f;
  var gOPN$1 = _objectGopnExt.f;
  var $Symbol = _global.Symbol;
  var $JSON = _global.JSON;
  var _stringify = $JSON && $JSON.stringify;
  var PROTOTYPE$2 = 'prototype';
  var HIDDEN = _wks('_hidden');
  var TO_PRIMITIVE = _wks('toPrimitive');
  var isEnum = {}.propertyIsEnumerable;
  var SymbolRegistry = _shared('symbol-registry');
  var AllSymbols = _shared('symbols');
  var OPSymbols = _shared('op-symbols');
  var ObjectProto = Object[PROTOTYPE$2];
  var USE_NATIVE = typeof $Symbol == 'function' && !!_objectGops.f;
  var QObject = _global.QObject;
  // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
  var setter = !QObject || !QObject[PROTOTYPE$2] || !QObject[PROTOTYPE$2].findChild;

  // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
  var setSymbolDesc = _descriptors && _fails(function () {
    return _objectCreate(dP$1({}, 'a', {
      get: function () { return dP$1(this, 'a', { value: 7 }).a; }
    })).a != 7;
  }) ? function (it, key, D) {
    var protoDesc = gOPD$1(ObjectProto, key);
    if (protoDesc) delete ObjectProto[key];
    dP$1(it, key, D);
    if (protoDesc && it !== ObjectProto) dP$1(ObjectProto, key, protoDesc);
  } : dP$1;

  var wrap = function (tag) {
    var sym = AllSymbols[tag] = _objectCreate($Symbol[PROTOTYPE$2]);
    sym._k = tag;
    return sym;
  };

  var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {
    return typeof it == 'symbol';
  } : function (it) {
    return it instanceof $Symbol;
  };

  var $defineProperty = function defineProperty(it, key, D) {
    if (it === ObjectProto) $defineProperty(OPSymbols, key, D);
    _anObject(it);
    key = _toPrimitive(key, true);
    _anObject(D);
    if (_has(AllSymbols, key)) {
      if (!D.enumerable) {
        if (!_has(it, HIDDEN)) dP$1(it, HIDDEN, _propertyDesc(1, {}));
        it[HIDDEN][key] = true;
      } else {
        if (_has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
        D = _objectCreate(D, { enumerable: _propertyDesc(0, false) });
      } return setSymbolDesc(it, key, D);
    } return dP$1(it, key, D);
  };
  var $defineProperties = function defineProperties(it, P) {
    _anObject(it);
    var keys = _enumKeys(P = _toIobject(P));
    var i = 0;
    var l = keys.length;
    var key;
    while (l > i) $defineProperty(it, key = keys[i++], P[key]);
    return it;
  };
  var $create = function create(it, P) {
    return P === undefined ? _objectCreate(it) : $defineProperties(_objectCreate(it), P);
  };
  var $propertyIsEnumerable = function propertyIsEnumerable(key) {
    var E = isEnum.call(this, key = _toPrimitive(key, true));
    if (this === ObjectProto && _has(AllSymbols, key) && !_has(OPSymbols, key)) return false;
    return E || !_has(this, key) || !_has(AllSymbols, key) || _has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
  };
  var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
    it = _toIobject(it);
    key = _toPrimitive(key, true);
    if (it === ObjectProto && _has(AllSymbols, key) && !_has(OPSymbols, key)) return;
    var D = gOPD$1(it, key);
    if (D && _has(AllSymbols, key) && !(_has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
    return D;
  };
  var $getOwnPropertyNames = function getOwnPropertyNames(it) {
    var names = gOPN$1(_toIobject(it));
    var result = [];
    var i = 0;
    var key;
    while (names.length > i) {
      if (!_has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
    } return result;
  };
  var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
    var IS_OP = it === ObjectProto;
    var names = gOPN$1(IS_OP ? OPSymbols : _toIobject(it));
    var result = [];
    var i = 0;
    var key;
    while (names.length > i) {
      if (_has(AllSymbols, key = names[i++]) && (IS_OP ? _has(ObjectProto, key) : true)) result.push(AllSymbols[key]);
    } return result;
  };

  // 19.4.1.1 Symbol([description])
  if (!USE_NATIVE) {
    $Symbol = function Symbol() {
      if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
      var tag = _uid(arguments.length > 0 ? arguments[0] : undefined);
      var $set = function (value) {
        if (this === ObjectProto) $set.call(OPSymbols, value);
        if (_has(this, HIDDEN) && _has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
        setSymbolDesc(this, tag, _propertyDesc(1, value));
      };
      if (_descriptors && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });
      return wrap(tag);
    };
    _redefine($Symbol[PROTOTYPE$2], 'toString', function toString() {
      return this._k;
    });

    _objectGopd.f = $getOwnPropertyDescriptor;
    _objectDp.f = $defineProperty;
    _objectGopn.f = _objectGopnExt.f = $getOwnPropertyNames;
    _objectPie.f = $propertyIsEnumerable;
    _objectGops.f = $getOwnPropertySymbols;

    if (_descriptors && !_library) {
      _redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
    }

    _wksExt.f = function (name) {
      return wrap(_wks(name));
    };
  }

  _export(_export.G + _export.W + _export.F * !USE_NATIVE, { Symbol: $Symbol });

  for (var es6Symbols = (
    // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
    'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
  ).split(','), j = 0; es6Symbols.length > j;)_wks(es6Symbols[j++]);

  for (var wellKnownSymbols = _objectKeys(_wks.store), k = 0; wellKnownSymbols.length > k;) _wksDefine(wellKnownSymbols[k++]);

  _export(_export.S + _export.F * !USE_NATIVE, 'Symbol', {
    // 19.4.2.1 Symbol.for(key)
    'for': function (key) {
      return _has(SymbolRegistry, key += '')
        ? SymbolRegistry[key]
        : SymbolRegistry[key] = $Symbol(key);
    },
    // 19.4.2.5 Symbol.keyFor(sym)
    keyFor: function keyFor(sym) {
      if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol!');
      for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;
    },
    useSetter: function () { setter = true; },
    useSimple: function () { setter = false; }
  });

  _export(_export.S + _export.F * !USE_NATIVE, 'Object', {
    // 19.1.2.2 Object.create(O [, Properties])
    create: $create,
    // 19.1.2.4 Object.defineProperty(O, P, Attributes)
    defineProperty: $defineProperty,
    // 19.1.2.3 Object.defineProperties(O, Properties)
    defineProperties: $defineProperties,
    // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
    getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
    // 19.1.2.7 Object.getOwnPropertyNames(O)
    getOwnPropertyNames: $getOwnPropertyNames,
    // 19.1.2.8 Object.getOwnPropertySymbols(O)
    getOwnPropertySymbols: $getOwnPropertySymbols
  });

  // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
  // https://bugs.chromium.org/p/v8/issues/detail?id=3443
  var FAILS_ON_PRIMITIVES = _fails(function () { _objectGops.f(1); });

  _export(_export.S + _export.F * FAILS_ON_PRIMITIVES, 'Object', {
    getOwnPropertySymbols: function getOwnPropertySymbols(it) {
      return _objectGops.f(_toObject(it));
    }
  });

  // 24.3.2 JSON.stringify(value [, replacer [, space]])
  $JSON && _export(_export.S + _export.F * (!USE_NATIVE || _fails(function () {
    var S = $Symbol();
    // MS Edge converts symbol values to JSON as {}
    // WebKit converts symbol values to JSON as null
    // V8 throws on boxed symbols
    return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';
  })), 'JSON', {
    stringify: function stringify(it) {
      var args = [it];
      var i = 1;
      var replacer, $replacer;
      while (arguments.length > i) args.push(arguments[i++]);
      $replacer = replacer = args[1];
      if (!_isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
      if (!_isArray(replacer)) replacer = function (key, value) {
        if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
        if (!isSymbol(value)) return value;
      };
      args[1] = replacer;
      return _stringify.apply($JSON, args);
    }
  });

  // 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
  $Symbol[PROTOTYPE$2][TO_PRIMITIVE] || _hide($Symbol[PROTOTYPE$2], TO_PRIMITIVE, $Symbol[PROTOTYPE$2].valueOf);
  // 19.4.3.5 Symbol.prototype[@@toStringTag]
  _setToStringTag($Symbol, 'Symbol');
  // 20.2.1.9 Math[@@toStringTag]
  _setToStringTag(Math, 'Math', true);
  // 24.3.3 JSON[@@toStringTag]
  _setToStringTag(_global.JSON, 'JSON', true);

  // 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
  _export(_export.S, 'Object', { create: _objectCreate });

  // 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
  _export(_export.S + _export.F * !_descriptors, 'Object', { defineProperty: _objectDp.f });

  // 19.1.2.3 / 15.2.3.7 Object.defineProperties(O, Properties)
  _export(_export.S + _export.F * !_descriptors, 'Object', { defineProperties: _objectDps });

  // most Object methods by ES6 should accept primitives



  var _objectSap = function (KEY, exec) {
    var fn = (_core.Object || {})[KEY] || Object[KEY];
    var exp = {};
    exp[KEY] = exec(fn);
    _export(_export.S + _export.F * _fails(function () { fn(1); }), 'Object', exp);
  };

  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)

  var $getOwnPropertyDescriptor$1 = _objectGopd.f;

  _objectSap('getOwnPropertyDescriptor', function () {
    return function getOwnPropertyDescriptor(it, key) {
      return $getOwnPropertyDescriptor$1(_toIobject(it), key);
    };
  });

  // 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)


  var IE_PROTO$2 = _sharedKey('IE_PROTO');
  var ObjectProto$1 = Object.prototype;

  var _objectGpo = Object.getPrototypeOf || function (O) {
    O = _toObject(O);
    if (_has(O, IE_PROTO$2)) return O[IE_PROTO$2];
    if (typeof O.constructor == 'function' && O instanceof O.constructor) {
      return O.constructor.prototype;
    } return O instanceof Object ? ObjectProto$1 : null;
  };

  // 19.1.2.9 Object.getPrototypeOf(O)



  _objectSap('getPrototypeOf', function () {
    return function getPrototypeOf(it) {
      return _objectGpo(_toObject(it));
    };
  });

  // 19.1.2.14 Object.keys(O)



  _objectSap('keys', function () {
    return function keys(it) {
      return _objectKeys(_toObject(it));
    };
  });

  // 19.1.2.7 Object.getOwnPropertyNames(O)
  _objectSap('getOwnPropertyNames', function () {
    return _objectGopnExt.f;
  });

  // 19.1.2.5 Object.freeze(O)

  var meta = _meta.onFreeze;

  _objectSap('freeze', function ($freeze) {
    return function freeze(it) {
      return $freeze && _isObject(it) ? $freeze(meta(it)) : it;
    };
  });

  // 19.1.2.17 Object.seal(O)

  var meta$1 = _meta.onFreeze;

  _objectSap('seal', function ($seal) {
    return function seal(it) {
      return $seal && _isObject(it) ? $seal(meta$1(it)) : it;
    };
  });

  // 19.1.2.15 Object.preventExtensions(O)

  var meta$2 = _meta.onFreeze;

  _objectSap('preventExtensions', function ($preventExtensions) {
    return function preventExtensions(it) {
      return $preventExtensions && _isObject(it) ? $preventExtensions(meta$2(it)) : it;
    };
  });

  // 19.1.2.12 Object.isFrozen(O)


  _objectSap('isFrozen', function ($isFrozen) {
    return function isFrozen(it) {
      return _isObject(it) ? $isFrozen ? $isFrozen(it) : false : true;
    };
  });

  // 19.1.2.13 Object.isSealed(O)


  _objectSap('isSealed', function ($isSealed) {
    return function isSealed(it) {
      return _isObject(it) ? $isSealed ? $isSealed(it) : false : true;
    };
  });

  // 19.1.2.11 Object.isExtensible(O)


  _objectSap('isExtensible', function ($isExtensible) {
    return function isExtensible(it) {
      return _isObject(it) ? $isExtensible ? $isExtensible(it) : true : false;
    };
  });

  // 19.1.2.1 Object.assign(target, source, ...)






  var $assign = Object.assign;

  // should work with symbols and should have deterministic property order (V8 bug)
  var _objectAssign = !$assign || _fails(function () {
    var A = {};
    var B = {};
    // eslint-disable-next-line no-undef
    var S = Symbol();
    var K = 'abcdefghijklmnopqrst';
    A[S] = 7;
    K.split('').forEach(function (k) { B[k] = k; });
    return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
  }) ? function assign(target, source) { // eslint-disable-line no-unused-vars
    var T = _toObject(target);
    var aLen = arguments.length;
    var index = 1;
    var getSymbols = _objectGops.f;
    var isEnum = _objectPie.f;
    while (aLen > index) {
      var S = _iobject(arguments[index++]);
      var keys = getSymbols ? _objectKeys(S).concat(getSymbols(S)) : _objectKeys(S);
      var length = keys.length;
      var j = 0;
      var key;
      while (length > j) {
        key = keys[j++];
        if (!_descriptors || isEnum.call(S, key)) T[key] = S[key];
      }
    } return T;
  } : $assign;

  // 19.1.3.1 Object.assign(target, source)


  _export(_export.S + _export.F, 'Object', { assign: _objectAssign });

  // 7.2.9 SameValue(x, y)
  var _sameValue = Object.is || function is(x, y) {
    // eslint-disable-next-line no-self-compare
    return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
  };

  // 19.1.3.10 Object.is(value1, value2)

  _export(_export.S, 'Object', { is: _sameValue });

  // Works with __proto__ only. Old v8 can't work with null proto objects.
  /* eslint-disable no-proto */


  var check = function (O, proto) {
    _anObject(O);
    if (!_isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
  };
  var _setProto = {
    set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
      function (test, buggy, set) {
        try {
          set = _ctx(Function.call, _objectGopd.f(Object.prototype, '__proto__').set, 2);
          set(test, []);
          buggy = !(test instanceof Array);
        } catch (e) { buggy = true; }
        return function setPrototypeOf(O, proto) {
          check(O, proto);
          if (buggy) O.__proto__ = proto;
          else set(O, proto);
          return O;
        };
      }({}, false) : undefined),
    check: check
  };

  // 19.1.3.19 Object.setPrototypeOf(O, proto)

  _export(_export.S, 'Object', { setPrototypeOf: _setProto.set });

  // getting tag from 19.1.3.6 Object.prototype.toString()

  var TAG$1 = _wks('toStringTag');
  // ES3 wrong here
  var ARG = _cof(function () { return arguments; }()) == 'Arguments';

  // fallback for IE11 Script Access Denied error
  var tryGet = function (it, key) {
    try {
      return it[key];
    } catch (e) { /* empty */ }
  };

  var _classof = function (it) {
    var O, T, B;
    return it === undefined ? 'Undefined' : it === null ? 'Null'
      // @@toStringTag case
      : typeof (T = tryGet(O = Object(it), TAG$1)) == 'string' ? T
      // builtinTag case
      : ARG ? _cof(O)
      // ES3 arguments fallback
      : (B = _cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
  };

  // 19.1.3.6 Object.prototype.toString()

  var test = {};
  test[_wks('toStringTag')] = 'z';
  if (test + '' != '[object z]') {
    _redefine(Object.prototype, 'toString', function toString() {
      return '[object ' + _classof(this) + ']';
    }, true);
  }

  // fast apply, http://jsperf.lnkit.com/fast-apply/5
  var _invoke = function (fn, args, that) {
    var un = that === undefined;
    switch (args.length) {
      case 0: return un ? fn()
                        : fn.call(that);
      case 1: return un ? fn(args[0])
                        : fn.call(that, args[0]);
      case 2: return un ? fn(args[0], args[1])
                        : fn.call(that, args[0], args[1]);
      case 3: return un ? fn(args[0], args[1], args[2])
                        : fn.call(that, args[0], args[1], args[2]);
      case 4: return un ? fn(args[0], args[1], args[2], args[3])
                        : fn.call(that, args[0], args[1], args[2], args[3]);
    } return fn.apply(that, args);
  };

  var arraySlice = [].slice;
  var factories = {};

  var construct = function (F, len, args) {
    if (!(len in factories)) {
      for (var n = [], i = 0; i < len; i++) n[i] = 'a[' + i + ']';
      // eslint-disable-next-line no-new-func
      factories[len] = Function('F,a', 'return new F(' + n.join(',') + ')');
    } return factories[len](F, args);
  };

  var _bind = Function.bind || function bind(that /* , ...args */) {
    var fn = _aFunction(this);
    var partArgs = arraySlice.call(arguments, 1);
    var bound = function (/* args... */) {
      var args = partArgs.concat(arraySlice.call(arguments));
      return this instanceof bound ? construct(fn, args.length, args) : _invoke(fn, args, that);
    };
    if (_isObject(fn.prototype)) bound.prototype = fn.prototype;
    return bound;
  };

  // 19.2.3.2 / 15.3.4.5 Function.prototype.bind(thisArg, args...)


  _export(_export.P, 'Function', { bind: _bind });

  var dP$2 = _objectDp.f;
  var FProto = Function.prototype;
  var nameRE = /^\s*function ([^ (]*)/;
  var NAME = 'name';

  // 19.2.4.2 name
  NAME in FProto || _descriptors && dP$2(FProto, NAME, {
    configurable: true,
    get: function () {
      try {
        return ('' + this).match(nameRE)[1];
      } catch (e) {
        return '';
      }
    }
  });

  var HAS_INSTANCE = _wks('hasInstance');
  var FunctionProto = Function.prototype;
  // 19.2.3.6 Function.prototype[@@hasInstance](V)
  if (!(HAS_INSTANCE in FunctionProto)) _objectDp.f(FunctionProto, HAS_INSTANCE, { value: function (O) {
    if (typeof this != 'function' || !_isObject(O)) return false;
    if (!_isObject(this.prototype)) return O instanceof this;
    // for environment w/o native `@@hasInstance` logic enough `instanceof`, but add this:
    while (O = _objectGpo(O)) if (this.prototype === O) return true;
    return false;
  } });

  var _stringWs = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003' +
    '\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

  var space = '[' + _stringWs + ']';
  var non = '\u200b\u0085';
  var ltrim = RegExp('^' + space + space + '*');
  var rtrim = RegExp(space + space + '*$');

  var exporter = function (KEY, exec, ALIAS) {
    var exp = {};
    var FORCE = _fails(function () {
      return !!_stringWs[KEY]() || non[KEY]() != non;
    });
    var fn = exp[KEY] = FORCE ? exec(trim) : _stringWs[KEY];
    if (ALIAS) exp[ALIAS] = fn;
    _export(_export.P + _export.F * FORCE, 'String', exp);
  };

  // 1 -> String#trimLeft
  // 2 -> String#trimRight
  // 3 -> String#trim
  var trim = exporter.trim = function (string, TYPE) {
    string = String(_defined(string));
    if (TYPE & 1) string = string.replace(ltrim, '');
    if (TYPE & 2) string = string.replace(rtrim, '');
    return string;
  };

  var _stringTrim = exporter;

  var $parseInt = _global.parseInt;
  var $trim = _stringTrim.trim;

  var hex = /^[-+]?0[xX]/;

  var _parseInt = $parseInt(_stringWs + '08') !== 8 || $parseInt(_stringWs + '0x16') !== 22 ? function parseInt(str, radix) {
    var string = $trim(String(str), 3);
    return $parseInt(string, (radix >>> 0) || (hex.test(string) ? 16 : 10));
  } : $parseInt;

  // 18.2.5 parseInt(string, radix)
  _export(_export.G + _export.F * (parseInt != _parseInt), { parseInt: _parseInt });

  var $parseFloat = _global.parseFloat;
  var $trim$1 = _stringTrim.trim;

  var _parseFloat = 1 / $parseFloat(_stringWs + '-0') !== -Infinity ? function parseFloat(str) {
    var string = $trim$1(String(str), 3);
    var result = $parseFloat(string);
    return result === 0 && string.charAt(0) == '-' ? -0 : result;
  } : $parseFloat;

  // 18.2.4 parseFloat(string)
  _export(_export.G + _export.F * (parseFloat != _parseFloat), { parseFloat: _parseFloat });

  var setPrototypeOf = _setProto.set;
  var _inheritIfRequired = function (that, target, C) {
    var S = target.constructor;
    var P;
    if (S !== C && typeof S == 'function' && (P = S.prototype) !== C.prototype && _isObject(P) && setPrototypeOf) {
      setPrototypeOf(that, P);
    } return that;
  };

  var gOPN$2 = _objectGopn.f;
  var gOPD$2 = _objectGopd.f;
  var dP$3 = _objectDp.f;
  var $trim$2 = _stringTrim.trim;
  var NUMBER = 'Number';
  var $Number = _global[NUMBER];
  var Base = $Number;
  var proto = $Number.prototype;
  // Opera ~12 has broken Object#toString
  var BROKEN_COF = _cof(_objectCreate(proto)) == NUMBER;
  var TRIM = 'trim' in String.prototype;

  // 7.1.3 ToNumber(argument)
  var toNumber = function (argument) {
    var it = _toPrimitive(argument, false);
    if (typeof it == 'string' && it.length > 2) {
      it = TRIM ? it.trim() : $trim$2(it, 3);
      var first = it.charCodeAt(0);
      var third, radix, maxCode;
      if (first === 43 || first === 45) {
        third = it.charCodeAt(2);
        if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
      } else if (first === 48) {
        switch (it.charCodeAt(1)) {
          case 66: case 98: radix = 2; maxCode = 49; break; // fast equal /^0b[01]+$/i
          case 79: case 111: radix = 8; maxCode = 55; break; // fast equal /^0o[0-7]+$/i
          default: return +it;
        }
        for (var digits = it.slice(2), i = 0, l = digits.length, code; i < l; i++) {
          code = digits.charCodeAt(i);
          // parseInt parses a string to a first unavailable symbol
          // but ToNumber should return NaN if a string contains unavailable symbols
          if (code < 48 || code > maxCode) return NaN;
        } return parseInt(digits, radix);
      }
    } return +it;
  };

  if (!$Number(' 0o1') || !$Number('0b1') || $Number('+0x1')) {
    $Number = function Number(value) {
      var it = arguments.length < 1 ? 0 : value;
      var that = this;
      return that instanceof $Number
        // check on 1..constructor(foo) case
        && (BROKEN_COF ? _fails(function () { proto.valueOf.call(that); }) : _cof(that) != NUMBER)
          ? _inheritIfRequired(new Base(toNumber(it)), that, $Number) : toNumber(it);
    };
    for (var keys = _descriptors ? gOPN$2(Base) : (
      // ES3:
      'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +
      // ES6 (in case, if modules with ES6 Number statics required before):
      'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' +
      'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger'
    ).split(','), j$1 = 0, key; keys.length > j$1; j$1++) {
      if (_has(Base, key = keys[j$1]) && !_has($Number, key)) {
        dP$3($Number, key, gOPD$2(Base, key));
      }
    }
    $Number.prototype = proto;
    proto.constructor = $Number;
    _redefine(_global, NUMBER, $Number);
  }

  var _aNumberValue = function (it, msg) {
    if (typeof it != 'number' && _cof(it) != 'Number') throw TypeError(msg);
    return +it;
  };

  var _stringRepeat = function repeat(count) {
    var str = String(_defined(this));
    var res = '';
    var n = _toInteger(count);
    if (n < 0 || n == Infinity) throw RangeError("Count can't be negative");
    for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) res += str;
    return res;
  };

  var $toFixed = 1.0.toFixed;
  var floor$1 = Math.floor;
  var data = [0, 0, 0, 0, 0, 0];
  var ERROR = 'Number.toFixed: incorrect invocation!';
  var ZERO = '0';

  var multiply = function (n, c) {
    var i = -1;
    var c2 = c;
    while (++i < 6) {
      c2 += n * data[i];
      data[i] = c2 % 1e7;
      c2 = floor$1(c2 / 1e7);
    }
  };
  var divide = function (n) {
    var i = 6;
    var c = 0;
    while (--i >= 0) {
      c += data[i];
      data[i] = floor$1(c / n);
      c = (c % n) * 1e7;
    }
  };
  var numToString = function () {
    var i = 6;
    var s = '';
    while (--i >= 0) {
      if (s !== '' || i === 0 || data[i] !== 0) {
        var t = String(data[i]);
        s = s === '' ? t : s + _stringRepeat.call(ZERO, 7 - t.length) + t;
      }
    } return s;
  };
  var pow = function (x, n, acc) {
    return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
  };
  var log = function (x) {
    var n = 0;
    var x2 = x;
    while (x2 >= 4096) {
      n += 12;
      x2 /= 4096;
    }
    while (x2 >= 2) {
      n += 1;
      x2 /= 2;
    } return n;
  };

  _export(_export.P + _export.F * (!!$toFixed && (
    0.00008.toFixed(3) !== '0.000' ||
    0.9.toFixed(0) !== '1' ||
    1.255.toFixed(2) !== '1.25' ||
    1000000000000000128.0.toFixed(0) !== '1000000000000000128'
  ) || !_fails(function () {
    // V8 ~ Android 4.3-
    $toFixed.call({});
  })), 'Number', {
    toFixed: function toFixed(fractionDigits) {
      var x = _aNumberValue(this, ERROR);
      var f = _toInteger(fractionDigits);
      var s = '';
      var m = ZERO;
      var e, z, j, k;
      if (f < 0 || f > 20) throw RangeError(ERROR);
      // eslint-disable-next-line no-self-compare
      if (x != x) return 'NaN';
      if (x <= -1e21 || x >= 1e21) return String(x);
      if (x < 0) {
        s = '-';
        x = -x;
      }
      if (x > 1e-21) {
        e = log(x * pow(2, 69, 1)) - 69;
        z = e < 0 ? x * pow(2, -e, 1) : x / pow(2, e, 1);
        z *= 0x10000000000000;
        e = 52 - e;
        if (e > 0) {
          multiply(0, z);
          j = f;
          while (j >= 7) {
            multiply(1e7, 0);
            j -= 7;
          }
          multiply(pow(10, j, 1), 0);
          j = e - 1;
          while (j >= 23) {
            divide(1 << 23);
            j -= 23;
          }
          divide(1 << j);
          multiply(1, 1);
          divide(2);
          m = numToString();
        } else {
          multiply(0, z);
          multiply(1 << -e, 0);
          m = numToString() + _stringRepeat.call(ZERO, f);
        }
      }
      if (f > 0) {
        k = m.length;
        m = s + (k <= f ? '0.' + _stringRepeat.call(ZERO, f - k) + m : m.slice(0, k - f) + '.' + m.slice(k - f));
      } else {
        m = s + m;
      } return m;
    }
  });

  var $toPrecision = 1.0.toPrecision;

  _export(_export.P + _export.F * (_fails(function () {
    // IE7-
    return $toPrecision.call(1, undefined) !== '1';
  }) || !_fails(function () {
    // V8 ~ Android 4.3-
    $toPrecision.call({});
  })), 'Number', {
    toPrecision: function toPrecision(precision) {
      var that = _aNumberValue(this, 'Number#toPrecision: incorrect invocation!');
      return precision === undefined ? $toPrecision.call(that) : $toPrecision.call(that, precision);
    }
  });

  // 20.1.2.1 Number.EPSILON


  _export(_export.S, 'Number', { EPSILON: Math.pow(2, -52) });

  // 20.1.2.2 Number.isFinite(number)

  var _isFinite = _global.isFinite;

  _export(_export.S, 'Number', {
    isFinite: function isFinite(it) {
      return typeof it == 'number' && _isFinite(it);
    }
  });

  // 20.1.2.3 Number.isInteger(number)

  var floor$2 = Math.floor;
  var _isInteger = function isInteger(it) {
    return !_isObject(it) && isFinite(it) && floor$2(it) === it;
  };

  // 20.1.2.3 Number.isInteger(number)


  _export(_export.S, 'Number', { isInteger: _isInteger });

  // 20.1.2.4 Number.isNaN(number)


  _export(_export.S, 'Number', {
    isNaN: function isNaN(number) {
      // eslint-disable-next-line no-self-compare
      return number != number;
    }
  });

  // 20.1.2.5 Number.isSafeInteger(number)


  var abs = Math.abs;

  _export(_export.S, 'Number', {
    isSafeInteger: function isSafeInteger(number) {
      return _isInteger(number) && abs(number) <= 0x1fffffffffffff;
    }
  });

  // 20.1.2.6 Number.MAX_SAFE_INTEGER


  _export(_export.S, 'Number', { MAX_SAFE_INTEGER: 0x1fffffffffffff });

  // 20.1.2.10 Number.MIN_SAFE_INTEGER


  _export(_export.S, 'Number', { MIN_SAFE_INTEGER: -0x1fffffffffffff });

  // 20.1.2.12 Number.parseFloat(string)
  _export(_export.S + _export.F * (Number.parseFloat != _parseFloat), 'Number', { parseFloat: _parseFloat });

  // 20.1.2.13 Number.parseInt(string, radix)
  _export(_export.S + _export.F * (Number.parseInt != _parseInt), 'Number', { parseInt: _parseInt });

  // 20.2.2.20 Math.log1p(x)
  var _mathLog1p = Math.log1p || function log1p(x) {
    return (x = +x) > -1e-8 && x < 1e-8 ? x - x * x / 2 : Math.log(1 + x);
  };

  // 20.2.2.3 Math.acosh(x)


  var sqrt = Math.sqrt;
  var $acosh = Math.acosh;

  _export(_export.S + _export.F * !($acosh
    // V8 bug: https://code.google.com/p/v8/issues/detail?id=3509
    && Math.floor($acosh(Number.MAX_VALUE)) == 710
    // Tor Browser bug: Math.acosh(Infinity) -> NaN
    && $acosh(Infinity) == Infinity
  ), 'Math', {
    acosh: function acosh(x) {
      return (x = +x) < 1 ? NaN : x > 94906265.62425156
        ? Math.log(x) + Math.LN2
        : _mathLog1p(x - 1 + sqrt(x - 1) * sqrt(x + 1));
    }
  });

  // 20.2.2.5 Math.asinh(x)

  var $asinh = Math.asinh;

  function asinh(x) {
    return !isFinite(x = +x) || x == 0 ? x : x < 0 ? -asinh(-x) : Math.log(x + Math.sqrt(x * x + 1));
  }

  // Tor Browser bug: Math.asinh(0) -> -0
  _export(_export.S + _export.F * !($asinh && 1 / $asinh(0) > 0), 'Math', { asinh: asinh });

  // 20.2.2.7 Math.atanh(x)

  var $atanh = Math.atanh;

  // Tor Browser bug: Math.atanh(-0) -> 0
  _export(_export.S + _export.F * !($atanh && 1 / $atanh(-0) < 0), 'Math', {
    atanh: function atanh(x) {
      return (x = +x) == 0 ? x : Math.log((1 + x) / (1 - x)) / 2;
    }
  });

  // 20.2.2.28 Math.sign(x)
  var _mathSign = Math.sign || function sign(x) {
    // eslint-disable-next-line no-self-compare
    return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;
  };

  // 20.2.2.9 Math.cbrt(x)



  _export(_export.S, 'Math', {
    cbrt: function cbrt(x) {
      return _mathSign(x = +x) * Math.pow(Math.abs(x), 1 / 3);
    }
  });

  // 20.2.2.11 Math.clz32(x)


  _export(_export.S, 'Math', {
    clz32: function clz32(x) {
      return (x >>>= 0) ? 31 - Math.floor(Math.log(x + 0.5) * Math.LOG2E) : 32;
    }
  });

  // 20.2.2.12 Math.cosh(x)

  var exp = Math.exp;

  _export(_export.S, 'Math', {
    cosh: function cosh(x) {
      return (exp(x = +x) + exp(-x)) / 2;
    }
  });

  // 20.2.2.14 Math.expm1(x)
  var $expm1 = Math.expm1;
  var _mathExpm1 = (!$expm1
    // Old FF bug
    || $expm1(10) > 22025.465794806719 || $expm1(10) < 22025.4657948067165168
    // Tor Browser bug
    || $expm1(-2e-17) != -2e-17
  ) ? function expm1(x) {
    return (x = +x) == 0 ? x : x > -1e-6 && x < 1e-6 ? x + x * x / 2 : Math.exp(x) - 1;
  } : $expm1;

  // 20.2.2.14 Math.expm1(x)



  _export(_export.S + _export.F * (_mathExpm1 != Math.expm1), 'Math', { expm1: _mathExpm1 });

  // 20.2.2.16 Math.fround(x)

  var pow$1 = Math.pow;
  var EPSILON = pow$1(2, -52);
  var EPSILON32 = pow$1(2, -23);
  var MAX32 = pow$1(2, 127) * (2 - EPSILON32);
  var MIN32 = pow$1(2, -126);

  var roundTiesToEven = function (n) {
    return n + 1 / EPSILON - 1 / EPSILON;
  };

  var _mathFround = Math.fround || function fround(x) {
    var $abs = Math.abs(x);
    var $sign = _mathSign(x);
    var a, result;
    if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;
    a = (1 + EPSILON32 / EPSILON) * $abs;
    result = a - (a - $abs);
    // eslint-disable-next-line no-self-compare
    if (result > MAX32 || result != result) return $sign * Infinity;
    return $sign * result;
  };

  // 20.2.2.16 Math.fround(x)


  _export(_export.S, 'Math', { fround: _mathFround });

  // 20.2.2.17 Math.hypot([value1[, value2[, … ]]])

  var abs$1 = Math.abs;

  _export(_export.S, 'Math', {
    hypot: function hypot(value1, value2) { // eslint-disable-line no-unused-vars
      var sum = 0;
      var i = 0;
      var aLen = arguments.length;
      var larg = 0;
      var arg, div;
      while (i < aLen) {
        arg = abs$1(arguments[i++]);
        if (larg < arg) {
          div = larg / arg;
          sum = sum * div * div + 1;
          larg = arg;
        } else if (arg > 0) {
          div = arg / larg;
          sum += div * div;
        } else sum += arg;
      }
      return larg === Infinity ? Infinity : larg * Math.sqrt(sum);
    }
  });

  // 20.2.2.18 Math.imul(x, y)

  var $imul = Math.imul;

  // some WebKit versions fails with big numbers, some has wrong arity
  _export(_export.S + _export.F * _fails(function () {
    return $imul(0xffffffff, 5) != -5 || $imul.length != 2;
  }), 'Math', {
    imul: function imul(x, y) {
      var UINT16 = 0xffff;
      var xn = +x;
      var yn = +y;
      var xl = UINT16 & xn;
      var yl = UINT16 & yn;
      return 0 | xl * yl + ((UINT16 & xn >>> 16) * yl + xl * (UINT16 & yn >>> 16) << 16 >>> 0);
    }
  });

  // 20.2.2.21 Math.log10(x)


  _export(_export.S, 'Math', {
    log10: function log10(x) {
      return Math.log(x) * Math.LOG10E;
    }
  });

  // 20.2.2.20 Math.log1p(x)


  _export(_export.S, 'Math', { log1p: _mathLog1p });

  // 20.2.2.22 Math.log2(x)


  _export(_export.S, 'Math', {
    log2: function log2(x) {
      return Math.log(x) / Math.LN2;
    }
  });

  // 20.2.2.28 Math.sign(x)


  _export(_export.S, 'Math', { sign: _mathSign });

  // 20.2.2.30 Math.sinh(x)


  var exp$1 = Math.exp;

  // V8 near Chromium 38 has a problem with very small numbers
  _export(_export.S + _export.F * _fails(function () {
    return !Math.sinh(-2e-17) != -2e-17;
  }), 'Math', {
    sinh: function sinh(x) {
      return Math.abs(x = +x) < 1
        ? (_mathExpm1(x) - _mathExpm1(-x)) / 2
        : (exp$1(x - 1) - exp$1(-x - 1)) * (Math.E / 2);
    }
  });

  // 20.2.2.33 Math.tanh(x)


  var exp$2 = Math.exp;

  _export(_export.S, 'Math', {
    tanh: function tanh(x) {
      var a = _mathExpm1(x = +x);
      var b = _mathExpm1(-x);
      return a == Infinity ? 1 : b == Infinity ? -1 : (a - b) / (exp$2(x) + exp$2(-x));
    }
  });

  // 20.2.2.34 Math.trunc(x)


  _export(_export.S, 'Math', {
    trunc: function trunc(it) {
      return (it > 0 ? Math.floor : Math.ceil)(it);
    }
  });

  var fromCharCode = String.fromCharCode;
  var $fromCodePoint = String.fromCodePoint;

  // length should be 1, old FF problem
  _export(_export.S + _export.F * (!!$fromCodePoint && $fromCodePoint.length != 1), 'String', {
    // 21.1.2.2 String.fromCodePoint(...codePoints)
    fromCodePoint: function fromCodePoint(x) { // eslint-disable-line no-unused-vars
      var res = [];
      var aLen = arguments.length;
      var i = 0;
      var code;
      while (aLen > i) {
        code = +arguments[i++];
        if (_toAbsoluteIndex(code, 0x10ffff) !== code) throw RangeError(code + ' is not a valid code point');
        res.push(code < 0x10000
          ? fromCharCode(code)
          : fromCharCode(((code -= 0x10000) >> 10) + 0xd800, code % 0x400 + 0xdc00)
        );
      } return res.join('');
    }
  });

  _export(_export.S, 'String', {
    // 21.1.2.4 String.raw(callSite, ...substitutions)
    raw: function raw(callSite) {
      var tpl = _toIobject(callSite.raw);
      var len = _toLength(tpl.length);
      var aLen = arguments.length;
      var res = [];
      var i = 0;
      while (len > i) {
        res.push(String(tpl[i++]));
        if (i < aLen) res.push(String(arguments[i]));
      } return res.join('');
    }
  });

  // 21.1.3.25 String.prototype.trim()
  _stringTrim('trim', function ($trim) {
    return function trim() {
      return $trim(this, 3);
    };
  });

  // true  -> String#at
  // false -> String#codePointAt
  var _stringAt = function (TO_STRING) {
    return function (that, pos) {
      var s = String(_defined(that));
      var i = _toInteger(pos);
      var l = s.length;
      var a, b;
      if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
      a = s.charCodeAt(i);
      return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
        ? TO_STRING ? s.charAt(i) : a
        : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
    };
  };

  var _iterators = {};

  var IteratorPrototype = {};

  // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
  _hide(IteratorPrototype, _wks('iterator'), function () { return this; });

  var _iterCreate = function (Constructor, NAME, next) {
    Constructor.prototype = _objectCreate(IteratorPrototype, { next: _propertyDesc(1, next) });
    _setToStringTag(Constructor, NAME + ' Iterator');
  };

  var ITERATOR = _wks('iterator');
  var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
  var FF_ITERATOR = '@@iterator';
  var KEYS = 'keys';
  var VALUES = 'values';

  var returnThis = function () { return this; };

  var _iterDefine = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
    _iterCreate(Constructor, NAME, next);
    var getMethod = function (kind) {
      if (!BUGGY && kind in proto) return proto[kind];
      switch (kind) {
        case KEYS: return function keys() { return new Constructor(this, kind); };
        case VALUES: return function values() { return new Constructor(this, kind); };
      } return function entries() { return new Constructor(this, kind); };
    };
    var TAG = NAME + ' Iterator';
    var DEF_VALUES = DEFAULT == VALUES;
    var VALUES_BUG = false;
    var proto = Base.prototype;
    var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
    var $default = $native || getMethod(DEFAULT);
    var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
    var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
    var methods, key, IteratorPrototype;
    // Fix native
    if ($anyNative) {
      IteratorPrototype = _objectGpo($anyNative.call(new Base()));
      if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
        // Set @@toStringTag to native iterators
        _setToStringTag(IteratorPrototype, TAG, true);
        // fix for some old engines
        if ( typeof IteratorPrototype[ITERATOR] != 'function') _hide(IteratorPrototype, ITERATOR, returnThis);
      }
    }
    // fix Array#{values, @@iterator}.name in V8 / FF
    if (DEF_VALUES && $native && $native.name !== VALUES) {
      VALUES_BUG = true;
      $default = function values() { return $native.call(this); };
    }
    // Define iterator
    if ( (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
      _hide(proto, ITERATOR, $default);
    }
    // Plug for library
    _iterators[NAME] = $default;
    _iterators[TAG] = returnThis;
    if (DEFAULT) {
      methods = {
        values: DEF_VALUES ? $default : getMethod(VALUES),
        keys: IS_SET ? $default : getMethod(KEYS),
        entries: $entries
      };
      if (FORCED) for (key in methods) {
        if (!(key in proto)) _redefine(proto, key, methods[key]);
      } else _export(_export.P + _export.F * (BUGGY || VALUES_BUG), NAME, methods);
    }
    return methods;
  };

  var $at = _stringAt(true);

  // 21.1.3.27 String.prototype[@@iterator]()
  _iterDefine(String, 'String', function (iterated) {
    this._t = String(iterated); // target
    this._i = 0;                // next index
  // 21.1.5.2.1 %StringIteratorPrototype%.next()
  }, function () {
    var O = this._t;
    var index = this._i;
    var point;
    if (index >= O.length) return { value: undefined, done: true };
    point = $at(O, index);
    this._i += point.length;
    return { value: point, done: false };
  });

  var $at$1 = _stringAt(false);
  _export(_export.P, 'String', {
    // 21.1.3.3 String.prototype.codePointAt(pos)
    codePointAt: function codePointAt(pos) {
      return $at$1(this, pos);
    }
  });

  // 7.2.8 IsRegExp(argument)


  var MATCH = _wks('match');
  var _isRegexp = function (it) {
    var isRegExp;
    return _isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : _cof(it) == 'RegExp');
  };

  // helper for String#{startsWith, endsWith, includes}



  var _stringContext = function (that, searchString, NAME) {
    if (_isRegexp(searchString)) throw TypeError('String#' + NAME + " doesn't accept regex!");
    return String(_defined(that));
  };

  var MATCH$1 = _wks('match');
  var _failsIsRegexp = function (KEY) {
    var re = /./;
    try {
      '/./'[KEY](re);
    } catch (e) {
      try {
        re[MATCH$1] = false;
        return !'/./'[KEY](re);
      } catch (f) { /* empty */ }
    } return true;
  };

  var ENDS_WITH = 'endsWith';
  var $endsWith = ''[ENDS_WITH];

  _export(_export.P + _export.F * _failsIsRegexp(ENDS_WITH), 'String', {
    endsWith: function endsWith(searchString /* , endPosition = @length */) {
      var that = _stringContext(this, searchString, ENDS_WITH);
      var endPosition = arguments.length > 1 ? arguments[1] : undefined;
      var len = _toLength(that.length);
      var end = endPosition === undefined ? len : Math.min(_toLength(endPosition), len);
      var search = String(searchString);
      return $endsWith
        ? $endsWith.call(that, search, end)
        : that.slice(end - search.length, end) === search;
    }
  });

  var INCLUDES = 'includes';

  _export(_export.P + _export.F * _failsIsRegexp(INCLUDES), 'String', {
    includes: function includes(searchString /* , position = 0 */) {
      return !!~_stringContext(this, searchString, INCLUDES)
        .indexOf(searchString, arguments.length > 1 ? arguments[1] : undefined);
    }
  });

  _export(_export.P, 'String', {
    // 21.1.3.13 String.prototype.repeat(count)
    repeat: _stringRepeat
  });

  var STARTS_WITH = 'startsWith';
  var $startsWith = ''[STARTS_WITH];

  _export(_export.P + _export.F * _failsIsRegexp(STARTS_WITH), 'String', {
    startsWith: function startsWith(searchString /* , position = 0 */) {
      var that = _stringContext(this, searchString, STARTS_WITH);
      var index = _toLength(Math.min(arguments.length > 1 ? arguments[1] : undefined, that.length));
      var search = String(searchString);
      return $startsWith
        ? $startsWith.call(that, search, index)
        : that.slice(index, index + search.length) === search;
    }
  });

  var quot = /"/g;
  // B.2.3.2.1 CreateHTML(string, tag, attribute, value)
  var createHTML = function (string, tag, attribute, value) {
    var S = String(_defined(string));
    var p1 = '<' + tag;
    if (attribute !== '') p1 += ' ' + attribute + '="' + String(value).replace(quot, '&quot;') + '"';
    return p1 + '>' + S + '</' + tag + '>';
  };
  var _stringHtml = function (NAME, exec) {
    var O = {};
    O[NAME] = exec(createHTML);
    _export(_export.P + _export.F * _fails(function () {
      var test = ''[NAME]('"');
      return test !== test.toLowerCase() || test.split('"').length > 3;
    }), 'String', O);
  };

  // B.2.3.2 String.prototype.anchor(name)
  _stringHtml('anchor', function (createHTML) {
    return function anchor(name) {
      return createHTML(this, 'a', 'name', name);
    };
  });

  // B.2.3.3 String.prototype.big()
  _stringHtml('big', function (createHTML) {
    return function big() {
      return createHTML(this, 'big', '', '');
    };
  });

  // B.2.3.4 String.prototype.blink()
  _stringHtml('blink', function (createHTML) {
    return function blink() {
      return createHTML(this, 'blink', '', '');
    };
  });

  // B.2.3.5 String.prototype.bold()
  _stringHtml('bold', function (createHTML) {
    return function bold() {
      return createHTML(this, 'b', '', '');
    };
  });

  // B.2.3.6 String.prototype.fixed()
  _stringHtml('fixed', function (createHTML) {
    return function fixed() {
      return createHTML(this, 'tt', '', '');
    };
  });

  // B.2.3.7 String.prototype.fontcolor(color)
  _stringHtml('fontcolor', function (createHTML) {
    return function fontcolor(color) {
      return createHTML(this, 'font', 'color', color);
    };
  });

  // B.2.3.8 String.prototype.fontsize(size)
  _stringHtml('fontsize', function (createHTML) {
    return function fontsize(size) {
      return createHTML(this, 'font', 'size', size);
    };
  });

  // B.2.3.9 String.prototype.italics()
  _stringHtml('italics', function (createHTML) {
    return function italics() {
      return createHTML(this, 'i', '', '');
    };
  });

  // B.2.3.10 String.prototype.link(url)
  _stringHtml('link', function (createHTML) {
    return function link(url) {
      return createHTML(this, 'a', 'href', url);
    };
  });

  // B.2.3.11 String.prototype.small()
  _stringHtml('small', function (createHTML) {
    return function small() {
      return createHTML(this, 'small', '', '');
    };
  });

  // B.2.3.12 String.prototype.strike()
  _stringHtml('strike', function (createHTML) {
    return function strike() {
      return createHTML(this, 'strike', '', '');
    };
  });

  // B.2.3.13 String.prototype.sub()
  _stringHtml('sub', function (createHTML) {
    return function sub() {
      return createHTML(this, 'sub', '', '');
    };
  });

  // B.2.3.14 String.prototype.sup()
  _stringHtml('sup', function (createHTML) {
    return function sup() {
      return createHTML(this, 'sup', '', '');
    };
  });

  // 20.3.3.1 / 15.9.4.4 Date.now()


  _export(_export.S, 'Date', { now: function () { return new Date().getTime(); } });

  _export(_export.P + _export.F * _fails(function () {
    return new Date(NaN).toJSON() !== null
      || Date.prototype.toJSON.call({ toISOString: function () { return 1; } }) !== 1;
  }), 'Date', {
    // eslint-disable-next-line no-unused-vars
    toJSON: function toJSON(key) {
      var O = _toObject(this);
      var pv = _toPrimitive(O);
      return typeof pv == 'number' && !isFinite(pv) ? null : O.toISOString();
    }
  });

  // 20.3.4.36 / 15.9.5.43 Date.prototype.toISOString()

  var getTime = Date.prototype.getTime;
  var $toISOString = Date.prototype.toISOString;

  var lz = function (num) {
    return num > 9 ? num : '0' + num;
  };

  // PhantomJS / old WebKit has a broken implementations
  var _dateToIsoString = (_fails(function () {
    return $toISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';
  }) || !_fails(function () {
    $toISOString.call(new Date(NaN));
  })) ? function toISOString() {
    if (!isFinite(getTime.call(this))) throw RangeError('Invalid time value');
    var d = this;
    var y = d.getUTCFullYear();
    var m = d.getUTCMilliseconds();
    var s = y < 0 ? '-' : y > 9999 ? '+' : '';
    return s + ('00000' + Math.abs(y)).slice(s ? -6 : -4) +
      '-' + lz(d.getUTCMonth() + 1) + '-' + lz(d.getUTCDate()) +
      'T' + lz(d.getUTCHours()) + ':' + lz(d.getUTCMinutes()) +
      ':' + lz(d.getUTCSeconds()) + '.' + (m > 99 ? m : '0' + lz(m)) + 'Z';
  } : $toISOString;

  // 20.3.4.36 / 15.9.5.43 Date.prototype.toISOString()



  // PhantomJS / old WebKit has a broken implementations
  _export(_export.P + _export.F * (Date.prototype.toISOString !== _dateToIsoString), 'Date', {
    toISOString: _dateToIsoString
  });

  var DateProto = Date.prototype;
  var INVALID_DATE = 'Invalid Date';
  var TO_STRING = 'toString';
  var $toString = DateProto[TO_STRING];
  var getTime$1 = DateProto.getTime;
  if (new Date(NaN) + '' != INVALID_DATE) {
    _redefine(DateProto, TO_STRING, function toString() {
      var value = getTime$1.call(this);
      // eslint-disable-next-line no-self-compare
      return value === value ? $toString.call(this) : INVALID_DATE;
    });
  }

  var NUMBER$1 = 'number';

  var _dateToPrimitive = function (hint) {
    if (hint !== 'string' && hint !== NUMBER$1 && hint !== 'default') throw TypeError('Incorrect hint');
    return _toPrimitive(_anObject(this), hint != NUMBER$1);
  };

  var TO_PRIMITIVE$1 = _wks('toPrimitive');
  var proto$1 = Date.prototype;

  if (!(TO_PRIMITIVE$1 in proto$1)) _hide(proto$1, TO_PRIMITIVE$1, _dateToPrimitive);

  // 22.1.2.2 / 15.4.3.2 Array.isArray(arg)


  _export(_export.S, 'Array', { isArray: _isArray });

  // call something on iterator step with safe closing on error

  var _iterCall = function (iterator, fn, value, entries) {
    try {
      return entries ? fn(_anObject(value)[0], value[1]) : fn(value);
    // 7.4.6 IteratorClose(iterator, completion)
    } catch (e) {
      var ret = iterator['return'];
      if (ret !== undefined) _anObject(ret.call(iterator));
      throw e;
    }
  };

  // check on default Array iterator

  var ITERATOR$1 = _wks('iterator');
  var ArrayProto = Array.prototype;

  var _isArrayIter = function (it) {
    return it !== undefined && (_iterators.Array === it || ArrayProto[ITERATOR$1] === it);
  };

  var _createProperty = function (object, index, value) {
    if (index in object) _objectDp.f(object, index, _propertyDesc(0, value));
    else object[index] = value;
  };

  var ITERATOR$2 = _wks('iterator');

  var core_getIteratorMethod = _core.getIteratorMethod = function (it) {
    if (it != undefined) return it[ITERATOR$2]
      || it['@@iterator']
      || _iterators[_classof(it)];
  };

  var ITERATOR$3 = _wks('iterator');
  var SAFE_CLOSING = false;

  try {
    var riter = [7][ITERATOR$3]();
    riter['return'] = function () { SAFE_CLOSING = true; };
    // eslint-disable-next-line no-throw-literal
    Array.from(riter, function () { throw 2; });
  } catch (e) { /* empty */ }

  var _iterDetect = function (exec, skipClosing) {
    if (!skipClosing && !SAFE_CLOSING) return false;
    var safe = false;
    try {
      var arr = [7];
      var iter = arr[ITERATOR$3]();
      iter.next = function () { return { done: safe = true }; };
      arr[ITERATOR$3] = function () { return iter; };
      exec(arr);
    } catch (e) { /* empty */ }
    return safe;
  };

  _export(_export.S + _export.F * !_iterDetect(function (iter) { Array.from(iter); }), 'Array', {
    // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)
    from: function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
      var O = _toObject(arrayLike);
      var C = typeof this == 'function' ? this : Array;
      var aLen = arguments.length;
      var mapfn = aLen > 1 ? arguments[1] : undefined;
      var mapping = mapfn !== undefined;
      var index = 0;
      var iterFn = core_getIteratorMethod(O);
      var length, result, step, iterator;
      if (mapping) mapfn = _ctx(mapfn, aLen > 2 ? arguments[2] : undefined, 2);
      // if object isn't iterable or it's array with default iterator - use simple case
      if (iterFn != undefined && !(C == Array && _isArrayIter(iterFn))) {
        for (iterator = iterFn.call(O), result = new C(); !(step = iterator.next()).done; index++) {
          _createProperty(result, index, mapping ? _iterCall(iterator, mapfn, [step.value, index], true) : step.value);
        }
      } else {
        length = _toLength(O.length);
        for (result = new C(length); length > index; index++) {
          _createProperty(result, index, mapping ? mapfn(O[index], index) : O[index]);
        }
      }
      result.length = index;
      return result;
    }
  });

  // WebKit Array.of isn't generic
  _export(_export.S + _export.F * _fails(function () {
    function F() { /* empty */ }
    return !(Array.of.call(F) instanceof F);
  }), 'Array', {
    // 22.1.2.3 Array.of( ...items)
    of: function of(/* ...args */) {
      var index = 0;
      var aLen = arguments.length;
      var result = new (typeof this == 'function' ? this : Array)(aLen);
      while (aLen > index) _createProperty(result, index, arguments[index++]);
      result.length = aLen;
      return result;
    }
  });

  var _strictMethod = function (method, arg) {
    return !!method && _fails(function () {
      // eslint-disable-next-line no-useless-call
      arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);
    });
  };

  // 22.1.3.13 Array.prototype.join(separator)


  var arrayJoin = [].join;

  // fallback for not array-like strings
  _export(_export.P + _export.F * (_iobject != Object || !_strictMethod(arrayJoin)), 'Array', {
    join: function join(separator) {
      return arrayJoin.call(_toIobject(this), separator === undefined ? ',' : separator);
    }
  });

  var arraySlice$1 = [].slice;

  // fallback for not array-like ES3 strings and DOM objects
  _export(_export.P + _export.F * _fails(function () {
    if (_html) arraySlice$1.call(_html);
  }), 'Array', {
    slice: function slice(begin, end) {
      var len = _toLength(this.length);
      var klass = _cof(this);
      end = end === undefined ? len : end;
      if (klass == 'Array') return arraySlice$1.call(this, begin, end);
      var start = _toAbsoluteIndex(begin, len);
      var upTo = _toAbsoluteIndex(end, len);
      var size = _toLength(upTo - start);
      var cloned = new Array(size);
      var i = 0;
      for (; i < size; i++) cloned[i] = klass == 'String'
        ? this.charAt(start + i)
        : this[start + i];
      return cloned;
    }
  });

  var $sort = [].sort;
  var test$1 = [1, 2, 3];

  _export(_export.P + _export.F * (_fails(function () {
    // IE8-
    test$1.sort(undefined);
  }) || !_fails(function () {
    // V8 bug
    test$1.sort(null);
    // Old WebKit
  }) || !_strictMethod($sort)), 'Array', {
    // 22.1.3.25 Array.prototype.sort(comparefn)
    sort: function sort(comparefn) {
      return comparefn === undefined
        ? $sort.call(_toObject(this))
        : $sort.call(_toObject(this), _aFunction(comparefn));
    }
  });

  var SPECIES = _wks('species');

  var _arraySpeciesConstructor = function (original) {
    var C;
    if (_isArray(original)) {
      C = original.constructor;
      // cross-realm fallback
      if (typeof C == 'function' && (C === Array || _isArray(C.prototype))) C = undefined;
      if (_isObject(C)) {
        C = C[SPECIES];
        if (C === null) C = undefined;
      }
    } return C === undefined ? Array : C;
  };

  // 9.4.2.3 ArraySpeciesCreate(originalArray, length)


  var _arraySpeciesCreate = function (original, length) {
    return new (_arraySpeciesConstructor(original))(length);
  };

  // 0 -> Array#forEach
  // 1 -> Array#map
  // 2 -> Array#filter
  // 3 -> Array#some
  // 4 -> Array#every
  // 5 -> Array#find
  // 6 -> Array#findIndex





  var _arrayMethods = function (TYPE, $create) {
    var IS_MAP = TYPE == 1;
    var IS_FILTER = TYPE == 2;
    var IS_SOME = TYPE == 3;
    var IS_EVERY = TYPE == 4;
    var IS_FIND_INDEX = TYPE == 6;
    var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
    var create = $create || _arraySpeciesCreate;
    return function ($this, callbackfn, that) {
      var O = _toObject($this);
      var self = _iobject(O);
      var f = _ctx(callbackfn, that, 3);
      var length = _toLength(self.length);
      var index = 0;
      var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
      var val, res;
      for (;length > index; index++) if (NO_HOLES || index in self) {
        val = self[index];
        res = f(val, index, O);
        if (TYPE) {
          if (IS_MAP) result[index] = res;   // map
          else if (res) switch (TYPE) {
            case 3: return true;             // some
            case 5: return val;              // find
            case 6: return index;            // findIndex
            case 2: result.push(val);        // filter
          } else if (IS_EVERY) return false; // every
        }
      }
      return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
    };
  };

  var $forEach = _arrayMethods(0);
  var STRICT = _strictMethod([].forEach, true);

  _export(_export.P + _export.F * !STRICT, 'Array', {
    // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])
    forEach: function forEach(callbackfn /* , thisArg */) {
      return $forEach(this, callbackfn, arguments[1]);
    }
  });

  var $map = _arrayMethods(1);

  _export(_export.P + _export.F * !_strictMethod([].map, true), 'Array', {
    // 22.1.3.15 / 15.4.4.19 Array.prototype.map(callbackfn [, thisArg])
    map: function map(callbackfn /* , thisArg */) {
      return $map(this, callbackfn, arguments[1]);
    }
  });

  var $filter = _arrayMethods(2);

  _export(_export.P + _export.F * !_strictMethod([].filter, true), 'Array', {
    // 22.1.3.7 / 15.4.4.20 Array.prototype.filter(callbackfn [, thisArg])
    filter: function filter(callbackfn /* , thisArg */) {
      return $filter(this, callbackfn, arguments[1]);
    }
  });

  var $some = _arrayMethods(3);

  _export(_export.P + _export.F * !_strictMethod([].some, true), 'Array', {
    // 22.1.3.23 / 15.4.4.17 Array.prototype.some(callbackfn [, thisArg])
    some: function some(callbackfn /* , thisArg */) {
      return $some(this, callbackfn, arguments[1]);
    }
  });

  var $every = _arrayMethods(4);

  _export(_export.P + _export.F * !_strictMethod([].every, true), 'Array', {
    // 22.1.3.5 / 15.4.4.16 Array.prototype.every(callbackfn [, thisArg])
    every: function every(callbackfn /* , thisArg */) {
      return $every(this, callbackfn, arguments[1]);
    }
  });

  var _arrayReduce = function (that, callbackfn, aLen, memo, isRight) {
    _aFunction(callbackfn);
    var O = _toObject(that);
    var self = _iobject(O);
    var length = _toLength(O.length);
    var index = isRight ? length - 1 : 0;
    var i = isRight ? -1 : 1;
    if (aLen < 2) for (;;) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (isRight ? index < 0 : length <= index) {
        throw TypeError('Reduce of empty array with no initial value');
      }
    }
    for (;isRight ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };

  _export(_export.P + _export.F * !_strictMethod([].reduce, true), 'Array', {
    // 22.1.3.18 / 15.4.4.21 Array.prototype.reduce(callbackfn [, initialValue])
    reduce: function reduce(callbackfn /* , initialValue */) {
      return _arrayReduce(this, callbackfn, arguments.length, arguments[1], false);
    }
  });

  _export(_export.P + _export.F * !_strictMethod([].reduceRight, true), 'Array', {
    // 22.1.3.19 / 15.4.4.22 Array.prototype.reduceRight(callbackfn [, initialValue])
    reduceRight: function reduceRight(callbackfn /* , initialValue */) {
      return _arrayReduce(this, callbackfn, arguments.length, arguments[1], true);
    }
  });

  var $indexOf = _arrayIncludes(false);
  var $native = [].indexOf;
  var NEGATIVE_ZERO = !!$native && 1 / [1].indexOf(1, -0) < 0;

  _export(_export.P + _export.F * (NEGATIVE_ZERO || !_strictMethod($native)), 'Array', {
    // 22.1.3.11 / 15.4.4.14 Array.prototype.indexOf(searchElement [, fromIndex])
    indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
      return NEGATIVE_ZERO
        // convert -0 to +0
        ? $native.apply(this, arguments) || 0
        : $indexOf(this, searchElement, arguments[1]);
    }
  });

  var $native$1 = [].lastIndexOf;
  var NEGATIVE_ZERO$1 = !!$native$1 && 1 / [1].lastIndexOf(1, -0) < 0;

  _export(_export.P + _export.F * (NEGATIVE_ZERO$1 || !_strictMethod($native$1)), 'Array', {
    // 22.1.3.14 / 15.4.4.15 Array.prototype.lastIndexOf(searchElement [, fromIndex])
    lastIndexOf: function lastIndexOf(searchElement /* , fromIndex = @[*-1] */) {
      // convert -0 to +0
      if (NEGATIVE_ZERO$1) return $native$1.apply(this, arguments) || 0;
      var O = _toIobject(this);
      var length = _toLength(O.length);
      var index = length - 1;
      if (arguments.length > 1) index = Math.min(index, _toInteger(arguments[1]));
      if (index < 0) index = length + index;
      for (;index >= 0; index--) if (index in O) if (O[index] === searchElement) return index || 0;
      return -1;
    }
  });

  var _arrayCopyWithin = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
    var O = _toObject(this);
    var len = _toLength(O.length);
    var to = _toAbsoluteIndex(target, len);
    var from = _toAbsoluteIndex(start, len);
    var end = arguments.length > 2 ? arguments[2] : undefined;
    var count = Math.min((end === undefined ? len : _toAbsoluteIndex(end, len)) - from, len - to);
    var inc = 1;
    if (from < to && to < from + count) {
      inc = -1;
      from += count - 1;
      to += count - 1;
    }
    while (count-- > 0) {
      if (from in O) O[to] = O[from];
      else delete O[to];
      to += inc;
      from += inc;
    } return O;
  };

  // 22.1.3.31 Array.prototype[@@unscopables]
  var UNSCOPABLES = _wks('unscopables');
  var ArrayProto$1 = Array.prototype;
  if (ArrayProto$1[UNSCOPABLES] == undefined) _hide(ArrayProto$1, UNSCOPABLES, {});
  var _addToUnscopables = function (key) {
    ArrayProto$1[UNSCOPABLES][key] = true;
  };

  // 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)


  _export(_export.P, 'Array', { copyWithin: _arrayCopyWithin });

  _addToUnscopables('copyWithin');

  var _arrayFill = function fill(value /* , start = 0, end = @length */) {
    var O = _toObject(this);
    var length = _toLength(O.length);
    var aLen = arguments.length;
    var index = _toAbsoluteIndex(aLen > 1 ? arguments[1] : undefined, length);
    var end = aLen > 2 ? arguments[2] : undefined;
    var endPos = end === undefined ? length : _toAbsoluteIndex(end, length);
    while (endPos > index) O[index++] = value;
    return O;
  };

  // 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)


  _export(_export.P, 'Array', { fill: _arrayFill });

  _addToUnscopables('fill');

  // 22.1.3.8 Array.prototype.find(predicate, thisArg = undefined)

  var $find = _arrayMethods(5);
  var KEY = 'find';
  var forced = true;
  // Shouldn't skip holes
  if (KEY in []) Array(1)[KEY](function () { forced = false; });
  _export(_export.P + _export.F * forced, 'Array', {
    find: function find(callbackfn /* , that = undefined */) {
      return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    }
  });
  _addToUnscopables(KEY);

  // 22.1.3.9 Array.prototype.findIndex(predicate, thisArg = undefined)

  var $find$1 = _arrayMethods(6);
  var KEY$1 = 'findIndex';
  var forced$1 = true;
  // Shouldn't skip holes
  if (KEY$1 in []) Array(1)[KEY$1](function () { forced$1 = false; });
  _export(_export.P + _export.F * forced$1, 'Array', {
    findIndex: function findIndex(callbackfn /* , that = undefined */) {
      return $find$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    }
  });
  _addToUnscopables(KEY$1);

  var SPECIES$1 = _wks('species');

  var _setSpecies = function (KEY) {
    var C = _global[KEY];
    if (_descriptors && C && !C[SPECIES$1]) _objectDp.f(C, SPECIES$1, {
      configurable: true,
      get: function () { return this; }
    });
  };

  _setSpecies('Array');

  var _iterStep = function (done, value) {
    return { value: value, done: !!done };
  };

  // 22.1.3.4 Array.prototype.entries()
  // 22.1.3.13 Array.prototype.keys()
  // 22.1.3.29 Array.prototype.values()
  // 22.1.3.30 Array.prototype[@@iterator]()
  var es6_array_iterator = _iterDefine(Array, 'Array', function (iterated, kind) {
    this._t = _toIobject(iterated); // target
    this._i = 0;                   // next index
    this._k = kind;                // kind
  // 22.1.5.2.1 %ArrayIteratorPrototype%.next()
  }, function () {
    var O = this._t;
    var kind = this._k;
    var index = this._i++;
    if (!O || index >= O.length) {
      this._t = undefined;
      return _iterStep(1);
    }
    if (kind == 'keys') return _iterStep(0, index);
    if (kind == 'values') return _iterStep(0, O[index]);
    return _iterStep(0, [index, O[index]]);
  }, 'values');

  // argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
  _iterators.Arguments = _iterators.Array;

  _addToUnscopables('keys');
  _addToUnscopables('values');
  _addToUnscopables('entries');

  // 21.2.5.3 get RegExp.prototype.flags

  var _flags = function () {
    var that = _anObject(this);
    var result = '';
    if (that.global) result += 'g';
    if (that.ignoreCase) result += 'i';
    if (that.multiline) result += 'm';
    if (that.unicode) result += 'u';
    if (that.sticky) result += 'y';
    return result;
  };

  var dP$4 = _objectDp.f;
  var gOPN$3 = _objectGopn.f;


  var $RegExp = _global.RegExp;
  var Base$1 = $RegExp;
  var proto$2 = $RegExp.prototype;
  var re1 = /a/g;
  var re2 = /a/g;
  // "new" creates a new object, old webkit buggy here
  var CORRECT_NEW = new $RegExp(re1) !== re1;

  if (_descriptors && (!CORRECT_NEW || _fails(function () {
    re2[_wks('match')] = false;
    // RegExp constructor can alter flags and IsRegExp works correct with @@match
    return $RegExp(re1) != re1 || $RegExp(re2) == re2 || $RegExp(re1, 'i') != '/a/i';
  }))) {
    $RegExp = function RegExp(p, f) {
      var tiRE = this instanceof $RegExp;
      var piRE = _isRegexp(p);
      var fiU = f === undefined;
      return !tiRE && piRE && p.constructor === $RegExp && fiU ? p
        : _inheritIfRequired(CORRECT_NEW
          ? new Base$1(piRE && !fiU ? p.source : p, f)
          : Base$1((piRE = p instanceof $RegExp) ? p.source : p, piRE && fiU ? _flags.call(p) : f)
        , tiRE ? this : proto$2, $RegExp);
    };
    var proxy = function (key) {
      key in $RegExp || dP$4($RegExp, key, {
        configurable: true,
        get: function () { return Base$1[key]; },
        set: function (it) { Base$1[key] = it; }
      });
    };
    for (var keys$1 = gOPN$3(Base$1), i = 0; keys$1.length > i;) proxy(keys$1[i++]);
    proto$2.constructor = $RegExp;
    $RegExp.prototype = proto$2;
    _redefine(_global, 'RegExp', $RegExp);
  }

  _setSpecies('RegExp');

  var nativeExec = RegExp.prototype.exec;
  // This always refers to the native implementation, because the
  // String#replace polyfill uses ./fix-regexp-well-known-symbol-logic.js,
  // which loads this file before patching the method.
  var nativeReplace = String.prototype.replace;

  var patchedExec = nativeExec;

  var LAST_INDEX = 'lastIndex';

  var UPDATES_LAST_INDEX_WRONG = (function () {
    var re1 = /a/,
        re2 = /b*/g;
    nativeExec.call(re1, 'a');
    nativeExec.call(re2, 'a');
    return re1[LAST_INDEX] !== 0 || re2[LAST_INDEX] !== 0;
  })();

  // nonparticipating capturing group, copied from es5-shim's String#split patch.
  var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

  var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED;

  if (PATCH) {
    patchedExec = function exec(str) {
      var re = this;
      var lastIndex, reCopy, match, i;

      if (NPCG_INCLUDED) {
        reCopy = new RegExp('^' + re.source + '$(?!\\s)', _flags.call(re));
      }
      if (UPDATES_LAST_INDEX_WRONG) lastIndex = re[LAST_INDEX];

      match = nativeExec.call(re, str);

      if (UPDATES_LAST_INDEX_WRONG && match) {
        re[LAST_INDEX] = re.global ? match.index + match[0].length : lastIndex;
      }
      if (NPCG_INCLUDED && match && match.length > 1) {
        // Fix browsers whose `exec` methods don't consistently return `undefined`
        // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
        // eslint-disable-next-line no-loop-func
        nativeReplace.call(match[0], reCopy, function () {
          for (i = 1; i < arguments.length - 2; i++) {
            if (arguments[i] === undefined) match[i] = undefined;
          }
        });
      }

      return match;
    };
  }

  var _regexpExec = patchedExec;

  _export({
    target: 'RegExp',
    proto: true,
    forced: _regexpExec !== /./.exec
  }, {
    exec: _regexpExec
  });

  // 21.2.5.3 get RegExp.prototype.flags()
  if (_descriptors && /./g.flags != 'g') _objectDp.f(RegExp.prototype, 'flags', {
    configurable: true,
    get: _flags
  });

  var TO_STRING$1 = 'toString';
  var $toString$1 = /./[TO_STRING$1];

  var define = function (fn) {
    _redefine(RegExp.prototype, TO_STRING$1, fn, true);
  };

  // 21.2.5.14 RegExp.prototype.toString()
  if (_fails(function () { return $toString$1.call({ source: 'a', flags: 'b' }) != '/a/b'; })) {
    define(function toString() {
      var R = _anObject(this);
      return '/'.concat(R.source, '/',
        'flags' in R ? R.flags : !_descriptors && R instanceof RegExp ? _flags.call(R) : undefined);
    });
  // FF44- RegExp#toString has a wrong name
  } else if ($toString$1.name != TO_STRING$1) {
    define(function toString() {
      return $toString$1.call(this);
    });
  }

  var at = _stringAt(true);

   // `AdvanceStringIndex` abstract operation
  // https://tc39.github.io/ecma262/#sec-advancestringindex
  var _advanceStringIndex = function (S, index, unicode) {
    return index + (unicode ? at(S, index).length : 1);
  };

  var builtinExec = RegExp.prototype.exec;

   // `RegExpExec` abstract operation
  // https://tc39.github.io/ecma262/#sec-regexpexec
  var _regexpExecAbstract = function (R, S) {
    var exec = R.exec;
    if (typeof exec === 'function') {
      var result = exec.call(R, S);
      if (typeof result !== 'object') {
        throw new TypeError('RegExp exec method returned something other than an Object or null');
      }
      return result;
    }
    if (_classof(R) !== 'RegExp') {
      throw new TypeError('RegExp#exec called on incompatible receiver');
    }
    return builtinExec.call(R, S);
  };

  var SPECIES$2 = _wks('species');

  var REPLACE_SUPPORTS_NAMED_GROUPS = !_fails(function () {
    // #replace needs built-in support for named groups.
    // #match works fine because it just return the exec results, even if it has
    // a "grops" property.
    var re = /./;
    re.exec = function () {
      var result = [];
      result.groups = { a: '7' };
      return result;
    };
    return ''.replace(re, '$<a>') !== '7';
  });

  var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = (function () {
    // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
    var re = /(?:)/;
    var originalExec = re.exec;
    re.exec = function () { return originalExec.apply(this, arguments); };
    var result = 'ab'.split(re);
    return result.length === 2 && result[0] === 'a' && result[1] === 'b';
  })();

  var _fixReWks = function (KEY, length, exec) {
    var SYMBOL = _wks(KEY);

    var DELEGATES_TO_SYMBOL = !_fails(function () {
      // String methods call symbol-named RegEp methods
      var O = {};
      O[SYMBOL] = function () { return 7; };
      return ''[KEY](O) != 7;
    });

    var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL ? !_fails(function () {
      // Symbol-named RegExp methods call .exec
      var execCalled = false;
      var re = /a/;
      re.exec = function () { execCalled = true; return null; };
      if (KEY === 'split') {
        // RegExp[@@split] doesn't call the regex's exec method, but first creates
        // a new one. We need to return the patched regex when creating the new one.
        re.constructor = {};
        re.constructor[SPECIES$2] = function () { return re; };
      }
      re[SYMBOL]('');
      return !execCalled;
    }) : undefined;

    if (
      !DELEGATES_TO_SYMBOL ||
      !DELEGATES_TO_EXEC ||
      (KEY === 'replace' && !REPLACE_SUPPORTS_NAMED_GROUPS) ||
      (KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC)
    ) {
      var nativeRegExpMethod = /./[SYMBOL];
      var fns = exec(
        _defined,
        SYMBOL,
        ''[KEY],
        function maybeCallNative(nativeMethod, regexp, str, arg2, forceStringMethod) {
          if (regexp.exec === _regexpExec) {
            if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
              // The native String method already delegates to @@method (this
              // polyfilled function), leasing to infinite recursion.
              // We avoid it by directly calling the native @@method method.
              return { done: true, value: nativeRegExpMethod.call(regexp, str, arg2) };
            }
            return { done: true, value: nativeMethod.call(str, regexp, arg2) };
          }
          return { done: false };
        }
      );
      var strfn = fns[0];
      var rxfn = fns[1];

      _redefine(String.prototype, KEY, strfn);
      _hide(RegExp.prototype, SYMBOL, length == 2
        // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
        // 21.2.5.11 RegExp.prototype[@@split](string, limit)
        ? function (string, arg) { return rxfn.call(string, this, arg); }
        // 21.2.5.6 RegExp.prototype[@@match](string)
        // 21.2.5.9 RegExp.prototype[@@search](string)
        : function (string) { return rxfn.call(string, this); }
      );
    }
  };

  // @@match logic
  _fixReWks('match', 1, function (defined, MATCH, $match, maybeCallNative) {
    return [
      // `String.prototype.match` method
      // https://tc39.github.io/ecma262/#sec-string.prototype.match
      function match(regexp) {
        var O = defined(this);
        var fn = regexp == undefined ? undefined : regexp[MATCH];
        return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
      },
      // `RegExp.prototype[@@match]` method
      // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@match
      function (regexp) {
        var res = maybeCallNative($match, regexp, this);
        if (res.done) return res.value;
        var rx = _anObject(regexp);
        var S = String(this);
        if (!rx.global) return _regexpExecAbstract(rx, S);
        var fullUnicode = rx.unicode;
        rx.lastIndex = 0;
        var A = [];
        var n = 0;
        var result;
        while ((result = _regexpExecAbstract(rx, S)) !== null) {
          var matchStr = String(result[0]);
          A[n] = matchStr;
          if (matchStr === '') rx.lastIndex = _advanceStringIndex(S, _toLength(rx.lastIndex), fullUnicode);
          n++;
        }
        return n === 0 ? null : A;
      }
    ];
  });

  var max$1 = Math.max;
  var min$2 = Math.min;
  var floor$3 = Math.floor;
  var SUBSTITUTION_SYMBOLS = /\$([$&`']|\d\d?|<[^>]*>)/g;
  var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&`']|\d\d?)/g;

  var maybeToString = function (it) {
    return it === undefined ? it : String(it);
  };

  // @@replace logic
  _fixReWks('replace', 2, function (defined, REPLACE, $replace, maybeCallNative) {
    return [
      // `String.prototype.replace` method
      // https://tc39.github.io/ecma262/#sec-string.prototype.replace
      function replace(searchValue, replaceValue) {
        var O = defined(this);
        var fn = searchValue == undefined ? undefined : searchValue[REPLACE];
        return fn !== undefined
          ? fn.call(searchValue, O, replaceValue)
          : $replace.call(String(O), searchValue, replaceValue);
      },
      // `RegExp.prototype[@@replace]` method
      // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace
      function (regexp, replaceValue) {
        var res = maybeCallNative($replace, regexp, this, replaceValue);
        if (res.done) return res.value;

        var rx = _anObject(regexp);
        var S = String(this);
        var functionalReplace = typeof replaceValue === 'function';
        if (!functionalReplace) replaceValue = String(replaceValue);
        var global = rx.global;
        if (global) {
          var fullUnicode = rx.unicode;
          rx.lastIndex = 0;
        }
        var results = [];
        while (true) {
          var result = _regexpExecAbstract(rx, S);
          if (result === null) break;
          results.push(result);
          if (!global) break;
          var matchStr = String(result[0]);
          if (matchStr === '') rx.lastIndex = _advanceStringIndex(S, _toLength(rx.lastIndex), fullUnicode);
        }
        var accumulatedResult = '';
        var nextSourcePosition = 0;
        for (var i = 0; i < results.length; i++) {
          result = results[i];
          var matched = String(result[0]);
          var position = max$1(min$2(_toInteger(result.index), S.length), 0);
          var captures = [];
          // NOTE: This is equivalent to
          //   captures = result.slice(1).map(maybeToString)
          // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
          // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
          // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
          for (var j = 1; j < result.length; j++) captures.push(maybeToString(result[j]));
          var namedCaptures = result.groups;
          if (functionalReplace) {
            var replacerArgs = [matched].concat(captures, position, S);
            if (namedCaptures !== undefined) replacerArgs.push(namedCaptures);
            var replacement = String(replaceValue.apply(undefined, replacerArgs));
          } else {
            replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
          }
          if (position >= nextSourcePosition) {
            accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
            nextSourcePosition = position + matched.length;
          }
        }
        return accumulatedResult + S.slice(nextSourcePosition);
      }
    ];

      // https://tc39.github.io/ecma262/#sec-getsubstitution
    function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
      var tailPos = position + matched.length;
      var m = captures.length;
      var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
      if (namedCaptures !== undefined) {
        namedCaptures = _toObject(namedCaptures);
        symbols = SUBSTITUTION_SYMBOLS;
      }
      return $replace.call(replacement, symbols, function (match, ch) {
        var capture;
        switch (ch.charAt(0)) {
          case '$': return '$';
          case '&': return matched;
          case '`': return str.slice(0, position);
          case "'": return str.slice(tailPos);
          case '<':
            capture = namedCaptures[ch.slice(1, -1)];
            break;
          default: // \d\d?
            var n = +ch;
            if (n === 0) return match;
            if (n > m) {
              var f = floor$3(n / 10);
              if (f === 0) return match;
              if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
              return match;
            }
            capture = captures[n - 1];
        }
        return capture === undefined ? '' : capture;
      });
    }
  });

  // @@search logic
  _fixReWks('search', 1, function (defined, SEARCH, $search, maybeCallNative) {
    return [
      // `String.prototype.search` method
      // https://tc39.github.io/ecma262/#sec-string.prototype.search
      function search(regexp) {
        var O = defined(this);
        var fn = regexp == undefined ? undefined : regexp[SEARCH];
        return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[SEARCH](String(O));
      },
      // `RegExp.prototype[@@search]` method
      // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@search
      function (regexp) {
        var res = maybeCallNative($search, regexp, this);
        if (res.done) return res.value;
        var rx = _anObject(regexp);
        var S = String(this);
        var previousLastIndex = rx.lastIndex;
        if (!_sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
        var result = _regexpExecAbstract(rx, S);
        if (!_sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
        return result === null ? -1 : result.index;
      }
    ];
  });

  // 7.3.20 SpeciesConstructor(O, defaultConstructor)


  var SPECIES$3 = _wks('species');
  var _speciesConstructor = function (O, D) {
    var C = _anObject(O).constructor;
    var S;
    return C === undefined || (S = _anObject(C)[SPECIES$3]) == undefined ? D : _aFunction(S);
  };

  var $min = Math.min;
  var $push = [].push;
  var $SPLIT = 'split';
  var LENGTH = 'length';
  var LAST_INDEX$1 = 'lastIndex';
  var MAX_UINT32 = 0xffffffff;

  // babel-minify transpiles RegExp('x', 'y') -> /x/y and it causes SyntaxError
  var SUPPORTS_Y = !_fails(function () { RegExp(MAX_UINT32, 'y'); });

  // @@split logic
  _fixReWks('split', 2, function (defined, SPLIT, $split, maybeCallNative) {
    var internalSplit;
    if (
      'abbc'[$SPLIT](/(b)*/)[1] == 'c' ||
      'test'[$SPLIT](/(?:)/, -1)[LENGTH] != 4 ||
      'ab'[$SPLIT](/(?:ab)*/)[LENGTH] != 2 ||
      '.'[$SPLIT](/(.?)(.?)/)[LENGTH] != 4 ||
      '.'[$SPLIT](/()()/)[LENGTH] > 1 ||
      ''[$SPLIT](/.?/)[LENGTH]
    ) {
      // based on es5-shim implementation, need to rework it
      internalSplit = function (separator, limit) {
        var string = String(this);
        if (separator === undefined && limit === 0) return [];
        // If `separator` is not a regex, use native split
        if (!_isRegexp(separator)) return $split.call(string, separator, limit);
        var output = [];
        var flags = (separator.ignoreCase ? 'i' : '') +
                    (separator.multiline ? 'm' : '') +
                    (separator.unicode ? 'u' : '') +
                    (separator.sticky ? 'y' : '');
        var lastLastIndex = 0;
        var splitLimit = limit === undefined ? MAX_UINT32 : limit >>> 0;
        // Make `global` and avoid `lastIndex` issues by working with a copy
        var separatorCopy = new RegExp(separator.source, flags + 'g');
        var match, lastIndex, lastLength;
        while (match = _regexpExec.call(separatorCopy, string)) {
          lastIndex = separatorCopy[LAST_INDEX$1];
          if (lastIndex > lastLastIndex) {
            output.push(string.slice(lastLastIndex, match.index));
            if (match[LENGTH] > 1 && match.index < string[LENGTH]) $push.apply(output, match.slice(1));
            lastLength = match[0][LENGTH];
            lastLastIndex = lastIndex;
            if (output[LENGTH] >= splitLimit) break;
          }
          if (separatorCopy[LAST_INDEX$1] === match.index) separatorCopy[LAST_INDEX$1]++; // Avoid an infinite loop
        }
        if (lastLastIndex === string[LENGTH]) {
          if (lastLength || !separatorCopy.test('')) output.push('');
        } else output.push(string.slice(lastLastIndex));
        return output[LENGTH] > splitLimit ? output.slice(0, splitLimit) : output;
      };
    // Chakra, V8
    } else if ('0'[$SPLIT](undefined, 0)[LENGTH]) {
      internalSplit = function (separator, limit) {
        return separator === undefined && limit === 0 ? [] : $split.call(this, separator, limit);
      };
    } else {
      internalSplit = $split;
    }

    return [
      // `String.prototype.split` method
      // https://tc39.github.io/ecma262/#sec-string.prototype.split
      function split(separator, limit) {
        var O = defined(this);
        var splitter = separator == undefined ? undefined : separator[SPLIT];
        return splitter !== undefined
          ? splitter.call(separator, O, limit)
          : internalSplit.call(String(O), separator, limit);
      },
      // `RegExp.prototype[@@split]` method
      // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@split
      //
      // NOTE: This cannot be properly polyfilled in engines that don't support
      // the 'y' flag.
      function (regexp, limit) {
        var res = maybeCallNative(internalSplit, regexp, this, limit, internalSplit !== $split);
        if (res.done) return res.value;

        var rx = _anObject(regexp);
        var S = String(this);
        var C = _speciesConstructor(rx, RegExp);

        var unicodeMatching = rx.unicode;
        var flags = (rx.ignoreCase ? 'i' : '') +
                    (rx.multiline ? 'm' : '') +
                    (rx.unicode ? 'u' : '') +
                    (SUPPORTS_Y ? 'y' : 'g');

        // ^(? + rx + ) is needed, in combination with some S slicing, to
        // simulate the 'y' flag.
        var splitter = new C(SUPPORTS_Y ? rx : '^(?:' + rx.source + ')', flags);
        var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
        if (lim === 0) return [];
        if (S.length === 0) return _regexpExecAbstract(splitter, S) === null ? [S] : [];
        var p = 0;
        var q = 0;
        var A = [];
        while (q < S.length) {
          splitter.lastIndex = SUPPORTS_Y ? q : 0;
          var z = _regexpExecAbstract(splitter, SUPPORTS_Y ? S : S.slice(q));
          var e;
          if (
            z === null ||
            (e = $min(_toLength(splitter.lastIndex + (SUPPORTS_Y ? 0 : q)), S.length)) === p
          ) {
            q = _advanceStringIndex(S, q, unicodeMatching);
          } else {
            A.push(S.slice(p, q));
            if (A.length === lim) return A;
            for (var i = 1; i <= z.length - 1; i++) {
              A.push(z[i]);
              if (A.length === lim) return A;
            }
            q = p = e;
          }
        }
        A.push(S.slice(p));
        return A;
      }
    ];
  });

  var _anInstance = function (it, Constructor, name, forbiddenField) {
    if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {
      throw TypeError(name + ': incorrect invocation!');
    } return it;
  };

  var _forOf = createCommonjsModule(function (module) {
  var BREAK = {};
  var RETURN = {};
  var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
    var iterFn = ITERATOR ? function () { return iterable; } : core_getIteratorMethod(iterable);
    var f = _ctx(fn, that, entries ? 2 : 1);
    var index = 0;
    var length, step, iterator, result;
    if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
    // fast case for arrays with default iterator
    if (_isArrayIter(iterFn)) for (length = _toLength(iterable.length); length > index; index++) {
      result = entries ? f(_anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
      if (result === BREAK || result === RETURN) return result;
    } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
      result = _iterCall(iterator, f, step.value, entries);
      if (result === BREAK || result === RETURN) return result;
    }
  };
  exports.BREAK = BREAK;
  exports.RETURN = RETURN;
  });

  var process = _global.process;
  var setTask = _global.setImmediate;
  var clearTask = _global.clearImmediate;
  var MessageChannel = _global.MessageChannel;
  var Dispatch = _global.Dispatch;
  var counter = 0;
  var queue = {};
  var ONREADYSTATECHANGE = 'onreadystatechange';
  var defer, channel, port;
  var run = function () {
    var id = +this;
    // eslint-disable-next-line no-prototype-builtins
    if (queue.hasOwnProperty(id)) {
      var fn = queue[id];
      delete queue[id];
      fn();
    }
  };
  var listener = function (event) {
    run.call(event.data);
  };
  // Node.js 0.9+ & IE10+ has setImmediate, otherwise:
  if (!setTask || !clearTask) {
    setTask = function setImmediate(fn) {
      var args = [];
      var i = 1;
      while (arguments.length > i) args.push(arguments[i++]);
      queue[++counter] = function () {
        // eslint-disable-next-line no-new-func
        _invoke(typeof fn == 'function' ? fn : Function(fn), args);
      };
      defer(counter);
      return counter;
    };
    clearTask = function clearImmediate(id) {
      delete queue[id];
    };
    // Node.js 0.8-
    if (_cof(process) == 'process') {
      defer = function (id) {
        process.nextTick(_ctx(run, id, 1));
      };
    // Sphere (JS game engine) Dispatch API
    } else if (Dispatch && Dispatch.now) {
      defer = function (id) {
        Dispatch.now(_ctx(run, id, 1));
      };
    // Browsers with MessageChannel, includes WebWorkers
    } else if (MessageChannel) {
      channel = new MessageChannel();
      port = channel.port2;
      channel.port1.onmessage = listener;
      defer = _ctx(port.postMessage, port, 1);
    // Browsers with postMessage, skip WebWorkers
    // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
    } else if (_global.addEventListener && typeof postMessage == 'function' && !_global.importScripts) {
      defer = function (id) {
        _global.postMessage(id + '', '*');
      };
      _global.addEventListener('message', listener, false);
    // IE8-
    } else if (ONREADYSTATECHANGE in _domCreate('script')) {
      defer = function (id) {
        _html.appendChild(_domCreate('script'))[ONREADYSTATECHANGE] = function () {
          _html.removeChild(this);
          run.call(id);
        };
      };
    // Rest old browsers
    } else {
      defer = function (id) {
        setTimeout(_ctx(run, id, 1), 0);
      };
    }
  }
  var _task = {
    set: setTask,
    clear: clearTask
  };

  var macrotask = _task.set;
  var Observer = _global.MutationObserver || _global.WebKitMutationObserver;
  var process$1 = _global.process;
  var Promise$1 = _global.Promise;
  var isNode = _cof(process$1) == 'process';

  var _microtask = function () {
    var head, last, notify;

    var flush = function () {
      var parent, fn;
      if (isNode && (parent = process$1.domain)) parent.exit();
      while (head) {
        fn = head.fn;
        head = head.next;
        try {
          fn();
        } catch (e) {
          if (head) notify();
          else last = undefined;
          throw e;
        }
      } last = undefined;
      if (parent) parent.enter();
    };

    // Node.js
    if (isNode) {
      notify = function () {
        process$1.nextTick(flush);
      };
    // browsers with MutationObserver, except iOS Safari - https://github.com/zloirock/core-js/issues/339
    } else if (Observer && !(_global.navigator && _global.navigator.standalone)) {
      var toggle = true;
      var node = document.createTextNode('');
      new Observer(flush).observe(node, { characterData: true }); // eslint-disable-line no-new
      notify = function () {
        node.data = toggle = !toggle;
      };
    // environments with maybe non-completely correct, but existent Promise
    } else if (Promise$1 && Promise$1.resolve) {
      // Promise.resolve without an argument throws an error in LG WebOS 2
      var promise = Promise$1.resolve(undefined);
      notify = function () {
        promise.then(flush);
      };
    // for other environments - macrotask based on:
    // - setImmediate
    // - MessageChannel
    // - window.postMessag
    // - onreadystatechange
    // - setTimeout
    } else {
      notify = function () {
        // strange IE + webpack dev server bug - use .call(global)
        macrotask.call(_global, flush);
      };
    }

    return function (fn) {
      var task = { fn: fn, next: undefined };
      if (last) last.next = task;
      if (!head) {
        head = task;
        notify();
      } last = task;
    };
  };

  // 25.4.1.5 NewPromiseCapability(C)


  function PromiseCapability(C) {
    var resolve, reject;
    this.promise = new C(function ($$resolve, $$reject) {
      if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
      resolve = $$resolve;
      reject = $$reject;
    });
    this.resolve = _aFunction(resolve);
    this.reject = _aFunction(reject);
  }

  var f$7 = function (C) {
    return new PromiseCapability(C);
  };

  var _newPromiseCapability = {
  	f: f$7
  };

  var _perform = function (exec) {
    try {
      return { e: false, v: exec() };
    } catch (e) {
      return { e: true, v: e };
    }
  };

  var navigator$1 = _global.navigator;

  var _userAgent = navigator$1 && navigator$1.userAgent || '';

  var _promiseResolve = function (C, x) {
    _anObject(C);
    if (_isObject(x) && x.constructor === C) return x;
    var promiseCapability = _newPromiseCapability.f(C);
    var resolve = promiseCapability.resolve;
    resolve(x);
    return promiseCapability.promise;
  };

  var _redefineAll = function (target, src, safe) {
    for (var key in src) _redefine(target, key, src[key], safe);
    return target;
  };

  var task = _task.set;
  var microtask = _microtask();




  var PROMISE = 'Promise';
  var TypeError$1 = _global.TypeError;
  var process$2 = _global.process;
  var versions = process$2 && process$2.versions;
  var v8 = versions && versions.v8 || '';
  var $Promise = _global[PROMISE];
  var isNode$1 = _classof(process$2) == 'process';
  var empty = function () { /* empty */ };
  var Internal, newGenericPromiseCapability, OwnPromiseCapability, Wrapper;
  var newPromiseCapability = newGenericPromiseCapability = _newPromiseCapability.f;

  var USE_NATIVE$1 = !!function () {
    try {
      // correct subclassing with @@species support
      var promise = $Promise.resolve(1);
      var FakePromise = (promise.constructor = {})[_wks('species')] = function (exec) {
        exec(empty, empty);
      };
      // unhandled rejections tracking support, NodeJS Promise without it fails @@species test
      return (isNode$1 || typeof PromiseRejectionEvent == 'function')
        && promise.then(empty) instanceof FakePromise
        // v8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
        // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
        // we can't detect it synchronously, so just check versions
        && v8.indexOf('6.6') !== 0
        && _userAgent.indexOf('Chrome/66') === -1;
    } catch (e) { /* empty */ }
  }();

  // helpers
  var isThenable = function (it) {
    var then;
    return _isObject(it) && typeof (then = it.then) == 'function' ? then : false;
  };
  var notify = function (promise, isReject) {
    if (promise._n) return;
    promise._n = true;
    var chain = promise._c;
    microtask(function () {
      var value = promise._v;
      var ok = promise._s == 1;
      var i = 0;
      var run = function (reaction) {
        var handler = ok ? reaction.ok : reaction.fail;
        var resolve = reaction.resolve;
        var reject = reaction.reject;
        var domain = reaction.domain;
        var result, then, exited;
        try {
          if (handler) {
            if (!ok) {
              if (promise._h == 2) onHandleUnhandled(promise);
              promise._h = 1;
            }
            if (handler === true) result = value;
            else {
              if (domain) domain.enter();
              result = handler(value); // may throw
              if (domain) {
                domain.exit();
                exited = true;
              }
            }
            if (result === reaction.promise) {
              reject(TypeError$1('Promise-chain cycle'));
            } else if (then = isThenable(result)) {
              then.call(result, resolve, reject);
            } else resolve(result);
          } else reject(value);
        } catch (e) {
          if (domain && !exited) domain.exit();
          reject(e);
        }
      };
      while (chain.length > i) run(chain[i++]); // variable length - can't use forEach
      promise._c = [];
      promise._n = false;
      if (isReject && !promise._h) onUnhandled(promise);
    });
  };
  var onUnhandled = function (promise) {
    task.call(_global, function () {
      var value = promise._v;
      var unhandled = isUnhandled(promise);
      var result, handler, console;
      if (unhandled) {
        result = _perform(function () {
          if (isNode$1) {
            process$2.emit('unhandledRejection', value, promise);
          } else if (handler = _global.onunhandledrejection) {
            handler({ promise: promise, reason: value });
          } else if ((console = _global.console) && console.error) {
            console.error('Unhandled promise rejection', value);
          }
        });
        // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
        promise._h = isNode$1 || isUnhandled(promise) ? 2 : 1;
      } promise._a = undefined;
      if (unhandled && result.e) throw result.v;
    });
  };
  var isUnhandled = function (promise) {
    return promise._h !== 1 && (promise._a || promise._c).length === 0;
  };
  var onHandleUnhandled = function (promise) {
    task.call(_global, function () {
      var handler;
      if (isNode$1) {
        process$2.emit('rejectionHandled', promise);
      } else if (handler = _global.onrejectionhandled) {
        handler({ promise: promise, reason: promise._v });
      }
    });
  };
  var $reject = function (value) {
    var promise = this;
    if (promise._d) return;
    promise._d = true;
    promise = promise._w || promise; // unwrap
    promise._v = value;
    promise._s = 2;
    if (!promise._a) promise._a = promise._c.slice();
    notify(promise, true);
  };
  var $resolve = function (value) {
    var promise = this;
    var then;
    if (promise._d) return;
    promise._d = true;
    promise = promise._w || promise; // unwrap
    try {
      if (promise === value) throw TypeError$1("Promise can't be resolved itself");
      if (then = isThenable(value)) {
        microtask(function () {
          var wrapper = { _w: promise, _d: false }; // wrap
          try {
            then.call(value, _ctx($resolve, wrapper, 1), _ctx($reject, wrapper, 1));
          } catch (e) {
            $reject.call(wrapper, e);
          }
        });
      } else {
        promise._v = value;
        promise._s = 1;
        notify(promise, false);
      }
    } catch (e) {
      $reject.call({ _w: promise, _d: false }, e); // wrap
    }
  };

  // constructor polyfill
  if (!USE_NATIVE$1) {
    // 25.4.3.1 Promise(executor)
    $Promise = function Promise(executor) {
      _anInstance(this, $Promise, PROMISE, '_h');
      _aFunction(executor);
      Internal.call(this);
      try {
        executor(_ctx($resolve, this, 1), _ctx($reject, this, 1));
      } catch (err) {
        $reject.call(this, err);
      }
    };
    // eslint-disable-next-line no-unused-vars
    Internal = function Promise(executor) {
      this._c = [];             // <- awaiting reactions
      this._a = undefined;      // <- checked in isUnhandled reactions
      this._s = 0;              // <- state
      this._d = false;          // <- done
      this._v = undefined;      // <- value
      this._h = 0;              // <- rejection state, 0 - default, 1 - handled, 2 - unhandled
      this._n = false;          // <- notify
    };
    Internal.prototype = _redefineAll($Promise.prototype, {
      // 25.4.5.3 Promise.prototype.then(onFulfilled, onRejected)
      then: function then(onFulfilled, onRejected) {
        var reaction = newPromiseCapability(_speciesConstructor(this, $Promise));
        reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
        reaction.fail = typeof onRejected == 'function' && onRejected;
        reaction.domain = isNode$1 ? process$2.domain : undefined;
        this._c.push(reaction);
        if (this._a) this._a.push(reaction);
        if (this._s) notify(this, false);
        return reaction.promise;
      },
      // 25.4.5.1 Promise.prototype.catch(onRejected)
      'catch': function (onRejected) {
        return this.then(undefined, onRejected);
      }
    });
    OwnPromiseCapability = function () {
      var promise = new Internal();
      this.promise = promise;
      this.resolve = _ctx($resolve, promise, 1);
      this.reject = _ctx($reject, promise, 1);
    };
    _newPromiseCapability.f = newPromiseCapability = function (C) {
      return C === $Promise || C === Wrapper
        ? new OwnPromiseCapability(C)
        : newGenericPromiseCapability(C);
    };
  }

  _export(_export.G + _export.W + _export.F * !USE_NATIVE$1, { Promise: $Promise });
  _setToStringTag($Promise, PROMISE);
  _setSpecies(PROMISE);
  Wrapper = _core[PROMISE];

  // statics
  _export(_export.S + _export.F * !USE_NATIVE$1, PROMISE, {
    // 25.4.4.5 Promise.reject(r)
    reject: function reject(r) {
      var capability = newPromiseCapability(this);
      var $$reject = capability.reject;
      $$reject(r);
      return capability.promise;
    }
  });
  _export(_export.S + _export.F * ( !USE_NATIVE$1), PROMISE, {
    // 25.4.4.6 Promise.resolve(x)
    resolve: function resolve(x) {
      return _promiseResolve( this, x);
    }
  });
  _export(_export.S + _export.F * !(USE_NATIVE$1 && _iterDetect(function (iter) {
    $Promise.all(iter)['catch'](empty);
  })), PROMISE, {
    // 25.4.4.1 Promise.all(iterable)
    all: function all(iterable) {
      var C = this;
      var capability = newPromiseCapability(C);
      var resolve = capability.resolve;
      var reject = capability.reject;
      var result = _perform(function () {
        var values = [];
        var index = 0;
        var remaining = 1;
        _forOf(iterable, false, function (promise) {
          var $index = index++;
          var alreadyCalled = false;
          values.push(undefined);
          remaining++;
          C.resolve(promise).then(function (value) {
            if (alreadyCalled) return;
            alreadyCalled = true;
            values[$index] = value;
            --remaining || resolve(values);
          }, reject);
        });
        --remaining || resolve(values);
      });
      if (result.e) reject(result.v);
      return capability.promise;
    },
    // 25.4.4.4 Promise.race(iterable)
    race: function race(iterable) {
      var C = this;
      var capability = newPromiseCapability(C);
      var reject = capability.reject;
      var result = _perform(function () {
        _forOf(iterable, false, function (promise) {
          C.resolve(promise).then(capability.resolve, reject);
        });
      });
      if (result.e) reject(result.v);
      return capability.promise;
    }
  });

  var _validateCollection = function (it, TYPE) {
    if (!_isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');
    return it;
  };

  var dP$5 = _objectDp.f;









  var fastKey = _meta.fastKey;

  var SIZE = _descriptors ? '_s' : 'size';

  var getEntry = function (that, key) {
    // fast case
    var index = fastKey(key);
    var entry;
    if (index !== 'F') return that._i[index];
    // frozen object case
    for (entry = that._f; entry; entry = entry.n) {
      if (entry.k == key) return entry;
    }
  };

  var _collectionStrong = {
    getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
      var C = wrapper(function (that, iterable) {
        _anInstance(that, C, NAME, '_i');
        that._t = NAME;         // collection type
        that._i = _objectCreate(null); // index
        that._f = undefined;    // first entry
        that._l = undefined;    // last entry
        that[SIZE] = 0;         // size
        if (iterable != undefined) _forOf(iterable, IS_MAP, that[ADDER], that);
      });
      _redefineAll(C.prototype, {
        // 23.1.3.1 Map.prototype.clear()
        // 23.2.3.2 Set.prototype.clear()
        clear: function clear() {
          for (var that = _validateCollection(this, NAME), data = that._i, entry = that._f; entry; entry = entry.n) {
            entry.r = true;
            if (entry.p) entry.p = entry.p.n = undefined;
            delete data[entry.i];
          }
          that._f = that._l = undefined;
          that[SIZE] = 0;
        },
        // 23.1.3.3 Map.prototype.delete(key)
        // 23.2.3.4 Set.prototype.delete(value)
        'delete': function (key) {
          var that = _validateCollection(this, NAME);
          var entry = getEntry(that, key);
          if (entry) {
            var next = entry.n;
            var prev = entry.p;
            delete that._i[entry.i];
            entry.r = true;
            if (prev) prev.n = next;
            if (next) next.p = prev;
            if (that._f == entry) that._f = next;
            if (that._l == entry) that._l = prev;
            that[SIZE]--;
          } return !!entry;
        },
        // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
        // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
        forEach: function forEach(callbackfn /* , that = undefined */) {
          _validateCollection(this, NAME);
          var f = _ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
          var entry;
          while (entry = entry ? entry.n : this._f) {
            f(entry.v, entry.k, this);
            // revert to the last existing entry
            while (entry && entry.r) entry = entry.p;
          }
        },
        // 23.1.3.7 Map.prototype.has(key)
        // 23.2.3.7 Set.prototype.has(value)
        has: function has(key) {
          return !!getEntry(_validateCollection(this, NAME), key);
        }
      });
      if (_descriptors) dP$5(C.prototype, 'size', {
        get: function () {
          return _validateCollection(this, NAME)[SIZE];
        }
      });
      return C;
    },
    def: function (that, key, value) {
      var entry = getEntry(that, key);
      var prev, index;
      // change existing entry
      if (entry) {
        entry.v = value;
      // create new entry
      } else {
        that._l = entry = {
          i: index = fastKey(key, true), // <- index
          k: key,                        // <- key
          v: value,                      // <- value
          p: prev = that._l,             // <- previous entry
          n: undefined,                  // <- next entry
          r: false                       // <- removed
        };
        if (!that._f) that._f = entry;
        if (prev) prev.n = entry;
        that[SIZE]++;
        // add to index
        if (index !== 'F') that._i[index] = entry;
      } return that;
    },
    getEntry: getEntry,
    setStrong: function (C, NAME, IS_MAP) {
      // add .keys, .values, .entries, [@@iterator]
      // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
      _iterDefine(C, NAME, function (iterated, kind) {
        this._t = _validateCollection(iterated, NAME); // target
        this._k = kind;                     // kind
        this._l = undefined;                // previous
      }, function () {
        var that = this;
        var kind = that._k;
        var entry = that._l;
        // revert to the last existing entry
        while (entry && entry.r) entry = entry.p;
        // get next entry
        if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {
          // or finish the iteration
          that._t = undefined;
          return _iterStep(1);
        }
        // return step by kind
        if (kind == 'keys') return _iterStep(0, entry.k);
        if (kind == 'values') return _iterStep(0, entry.v);
        return _iterStep(0, [entry.k, entry.v]);
      }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

      // add [@@species], 23.1.2.2, 23.2.2.2
      _setSpecies(NAME);
    }
  };

  var _collection = function (NAME, wrapper, methods, common, IS_MAP, IS_WEAK) {
    var Base = _global[NAME];
    var C = Base;
    var ADDER = IS_MAP ? 'set' : 'add';
    var proto = C && C.prototype;
    var O = {};
    var fixMethod = function (KEY) {
      var fn = proto[KEY];
      _redefine(proto, KEY,
        KEY == 'delete' ? function (a) {
          return IS_WEAK && !_isObject(a) ? false : fn.call(this, a === 0 ? 0 : a);
        } : KEY == 'has' ? function has(a) {
          return IS_WEAK && !_isObject(a) ? false : fn.call(this, a === 0 ? 0 : a);
        } : KEY == 'get' ? function get(a) {
          return IS_WEAK && !_isObject(a) ? undefined : fn.call(this, a === 0 ? 0 : a);
        } : KEY == 'add' ? function add(a) { fn.call(this, a === 0 ? 0 : a); return this; }
          : function set(a, b) { fn.call(this, a === 0 ? 0 : a, b); return this; }
      );
    };
    if (typeof C != 'function' || !(IS_WEAK || proto.forEach && !_fails(function () {
      new C().entries().next();
    }))) {
      // create collection constructor
      C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);
      _redefineAll(C.prototype, methods);
      _meta.NEED = true;
    } else {
      var instance = new C();
      // early implementations not supports chaining
      var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
      // V8 ~  Chromium 40- weak-collections throws on primitives, but should return false
      var THROWS_ON_PRIMITIVES = _fails(function () { instance.has(1); });
      // most early implementations doesn't supports iterables, most modern - not close it correctly
      var ACCEPT_ITERABLES = _iterDetect(function (iter) { new C(iter); }); // eslint-disable-line no-new
      // for early implementations -0 and +0 not the same
      var BUGGY_ZERO = !IS_WEAK && _fails(function () {
        // V8 ~ Chromium 42- fails only with 5+ elements
        var $instance = new C();
        var index = 5;
        while (index--) $instance[ADDER](index, index);
        return !$instance.has(-0);
      });
      if (!ACCEPT_ITERABLES) {
        C = wrapper(function (target, iterable) {
          _anInstance(target, C, NAME);
          var that = _inheritIfRequired(new Base(), target, C);
          if (iterable != undefined) _forOf(iterable, IS_MAP, that[ADDER], that);
          return that;
        });
        C.prototype = proto;
        proto.constructor = C;
      }
      if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
        fixMethod('delete');
        fixMethod('has');
        IS_MAP && fixMethod('get');
      }
      if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);
      // weak collections should not contains .clear method
      if (IS_WEAK && proto.clear) delete proto.clear;
    }

    _setToStringTag(C, NAME);

    O[NAME] = C;
    _export(_export.G + _export.W + _export.F * (C != Base), O);

    if (!IS_WEAK) common.setStrong(C, NAME, IS_MAP);

    return C;
  };

  var MAP = 'Map';

  // 23.1 Map Objects
  var es6_map = _collection(MAP, function (get) {
    return function Map() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
  }, {
    // 23.1.3.6 Map.prototype.get(key)
    get: function get(key) {
      var entry = _collectionStrong.getEntry(_validateCollection(this, MAP), key);
      return entry && entry.v;
    },
    // 23.1.3.9 Map.prototype.set(key, value)
    set: function set(key, value) {
      return _collectionStrong.def(_validateCollection(this, MAP), key === 0 ? 0 : key, value);
    }
  }, _collectionStrong, true);

  var SET = 'Set';

  // 23.2 Set Objects
  var es6_set = _collection(SET, function (get) {
    return function Set() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
  }, {
    // 23.2.3.1 Set.prototype.add(value)
    add: function add(value) {
      return _collectionStrong.def(_validateCollection(this, SET), value = value === 0 ? 0 : value, value);
    }
  }, _collectionStrong);

  var getWeak = _meta.getWeak;







  var arrayFind = _arrayMethods(5);
  var arrayFindIndex = _arrayMethods(6);
  var id$1 = 0;

  // fallback for uncaught frozen keys
  var uncaughtFrozenStore = function (that) {
    return that._l || (that._l = new UncaughtFrozenStore());
  };
  var UncaughtFrozenStore = function () {
    this.a = [];
  };
  var findUncaughtFrozen = function (store, key) {
    return arrayFind(store.a, function (it) {
      return it[0] === key;
    });
  };
  UncaughtFrozenStore.prototype = {
    get: function (key) {
      var entry = findUncaughtFrozen(this, key);
      if (entry) return entry[1];
    },
    has: function (key) {
      return !!findUncaughtFrozen(this, key);
    },
    set: function (key, value) {
      var entry = findUncaughtFrozen(this, key);
      if (entry) entry[1] = value;
      else this.a.push([key, value]);
    },
    'delete': function (key) {
      var index = arrayFindIndex(this.a, function (it) {
        return it[0] === key;
      });
      if (~index) this.a.splice(index, 1);
      return !!~index;
    }
  };

  var _collectionWeak = {
    getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
      var C = wrapper(function (that, iterable) {
        _anInstance(that, C, NAME, '_i');
        that._t = NAME;      // collection type
        that._i = id$1++;      // collection id
        that._l = undefined; // leak store for uncaught frozen objects
        if (iterable != undefined) _forOf(iterable, IS_MAP, that[ADDER], that);
      });
      _redefineAll(C.prototype, {
        // 23.3.3.2 WeakMap.prototype.delete(key)
        // 23.4.3.3 WeakSet.prototype.delete(value)
        'delete': function (key) {
          if (!_isObject(key)) return false;
          var data = getWeak(key);
          if (data === true) return uncaughtFrozenStore(_validateCollection(this, NAME))['delete'](key);
          return data && _has(data, this._i) && delete data[this._i];
        },
        // 23.3.3.4 WeakMap.prototype.has(key)
        // 23.4.3.4 WeakSet.prototype.has(value)
        has: function has(key) {
          if (!_isObject(key)) return false;
          var data = getWeak(key);
          if (data === true) return uncaughtFrozenStore(_validateCollection(this, NAME)).has(key);
          return data && _has(data, this._i);
        }
      });
      return C;
    },
    def: function (that, key, value) {
      var data = getWeak(_anObject(key), true);
      if (data === true) uncaughtFrozenStore(that).set(key, value);
      else data[that._i] = value;
      return that;
    },
    ufstore: uncaughtFrozenStore
  };

  var es6_weakMap = createCommonjsModule(function (module) {

  var each = _arrayMethods(0);






  var NATIVE_WEAK_MAP = _validateCollection;
  var IS_IE11 = !_global.ActiveXObject && 'ActiveXObject' in _global;
  var WEAK_MAP = 'WeakMap';
  var getWeak = _meta.getWeak;
  var isExtensible = Object.isExtensible;
  var uncaughtFrozenStore = _collectionWeak.ufstore;
  var InternalMap;

  var wrapper = function (get) {
    return function WeakMap() {
      return get(this, arguments.length > 0 ? arguments[0] : undefined);
    };
  };

  var methods = {
    // 23.3.3.3 WeakMap.prototype.get(key)
    get: function get(key) {
      if (_isObject(key)) {
        var data = getWeak(key);
        if (data === true) return uncaughtFrozenStore(_validateCollection(this, WEAK_MAP)).get(key);
        return data ? data[this._i] : undefined;
      }
    },
    // 23.3.3.5 WeakMap.prototype.set(key, value)
    set: function set(key, value) {
      return _collectionWeak.def(_validateCollection(this, WEAK_MAP), key, value);
    }
  };

  // 23.3 WeakMap Objects
  var $WeakMap = module.exports = _collection(WEAK_MAP, wrapper, methods, _collectionWeak, true, true);

  // IE11 WeakMap frozen keys fix
  if (NATIVE_WEAK_MAP && IS_IE11) {
    InternalMap = _collectionWeak.getConstructor(wrapper, WEAK_MAP);
    _objectAssign(InternalMap.prototype, methods);
    _meta.NEED = true;
    each(['delete', 'has', 'get', 'set'], function (key) {
      var proto = $WeakMap.prototype;
      var method = proto[key];
      _redefine(proto, key, function (a, b) {
        // store frozen objects on internal weakmap shim
        if (_isObject(a) && !isExtensible(a)) {
          if (!this._f) this._f = new InternalMap();
          var result = this._f[key](a, b);
          return key == 'set' ? this : result;
        // store all the rest on native weakmap
        } return method.call(this, a, b);
      });
    });
  }
  });

  var WEAK_SET = 'WeakSet';

  // 23.4 WeakSet Objects
  _collection(WEAK_SET, function (get) {
    return function WeakSet() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
  }, {
    // 23.4.3.1 WeakSet.prototype.add(value)
    add: function add(value) {
      return _collectionWeak.def(_validateCollection(this, WEAK_SET), value, true);
    }
  }, _collectionWeak, false, true);

  var TYPED = _uid('typed_array');
  var VIEW = _uid('view');
  var ABV = !!(_global.ArrayBuffer && _global.DataView);
  var CONSTR = ABV;
  var i$1 = 0;
  var l = 9;
  var Typed;

  var TypedArrayConstructors = (
    'Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array'
  ).split(',');

  while (i$1 < l) {
    if (Typed = _global[TypedArrayConstructors[i$1++]]) {
      _hide(Typed.prototype, TYPED, true);
      _hide(Typed.prototype, VIEW, true);
    } else CONSTR = false;
  }

  var _typed = {
    ABV: ABV,
    CONSTR: CONSTR,
    TYPED: TYPED,
    VIEW: VIEW
  };

  // https://tc39.github.io/ecma262/#sec-toindex


  var _toIndex = function (it) {
    if (it === undefined) return 0;
    var number = _toInteger(it);
    var length = _toLength(number);
    if (number !== length) throw RangeError('Wrong length!');
    return length;
  };

  var _typedBuffer = createCommonjsModule(function (module, exports) {











  var gOPN = _objectGopn.f;
  var dP = _objectDp.f;


  var ARRAY_BUFFER = 'ArrayBuffer';
  var DATA_VIEW = 'DataView';
  var PROTOTYPE = 'prototype';
  var WRONG_LENGTH = 'Wrong length!';
  var WRONG_INDEX = 'Wrong index!';
  var $ArrayBuffer = _global[ARRAY_BUFFER];
  var $DataView = _global[DATA_VIEW];
  var Math = _global.Math;
  var RangeError = _global.RangeError;
  // eslint-disable-next-line no-shadow-restricted-names
  var Infinity = _global.Infinity;
  var BaseBuffer = $ArrayBuffer;
  var abs = Math.abs;
  var pow = Math.pow;
  var floor = Math.floor;
  var log = Math.log;
  var LN2 = Math.LN2;
  var BUFFER = 'buffer';
  var BYTE_LENGTH = 'byteLength';
  var BYTE_OFFSET = 'byteOffset';
  var $BUFFER = _descriptors ? '_b' : BUFFER;
  var $LENGTH = _descriptors ? '_l' : BYTE_LENGTH;
  var $OFFSET = _descriptors ? '_o' : BYTE_OFFSET;

  // IEEE754 conversions based on https://github.com/feross/ieee754
  function packIEEE754(value, mLen, nBytes) {
    var buffer = new Array(nBytes);
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = mLen === 23 ? pow(2, -24) - pow(2, -77) : 0;
    var i = 0;
    var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
    var e, m, c;
    value = abs(value);
    // eslint-disable-next-line no-self-compare
    if (value != value || value === Infinity) {
      // eslint-disable-next-line no-self-compare
      m = value != value ? 1 : 0;
      e = eMax;
    } else {
      e = floor(log(value) / LN2);
      if (value * (c = pow(2, -e)) < 1) {
        e--;
        c *= 2;
      }
      if (e + eBias >= 1) {
        value += rt / c;
      } else {
        value += rt * pow(2, 1 - eBias);
      }
      if (value * c >= 2) {
        e++;
        c /= 2;
      }
      if (e + eBias >= eMax) {
        m = 0;
        e = eMax;
      } else if (e + eBias >= 1) {
        m = (value * c - 1) * pow(2, mLen);
        e = e + eBias;
      } else {
        m = value * pow(2, eBias - 1) * pow(2, mLen);
        e = 0;
      }
    }
    for (; mLen >= 8; buffer[i++] = m & 255, m /= 256, mLen -= 8);
    e = e << mLen | m;
    eLen += mLen;
    for (; eLen > 0; buffer[i++] = e & 255, e /= 256, eLen -= 8);
    buffer[--i] |= s * 128;
    return buffer;
  }
  function unpackIEEE754(buffer, mLen, nBytes) {
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = eLen - 7;
    var i = nBytes - 1;
    var s = buffer[i--];
    var e = s & 127;
    var m;
    s >>= 7;
    for (; nBits > 0; e = e * 256 + buffer[i], i--, nBits -= 8);
    m = e & (1 << -nBits) - 1;
    e >>= -nBits;
    nBits += mLen;
    for (; nBits > 0; m = m * 256 + buffer[i], i--, nBits -= 8);
    if (e === 0) {
      e = 1 - eBias;
    } else if (e === eMax) {
      return m ? NaN : s ? -Infinity : Infinity;
    } else {
      m = m + pow(2, mLen);
      e = e - eBias;
    } return (s ? -1 : 1) * m * pow(2, e - mLen);
  }

  function unpackI32(bytes) {
    return bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
  }
  function packI8(it) {
    return [it & 0xff];
  }
  function packI16(it) {
    return [it & 0xff, it >> 8 & 0xff];
  }
  function packI32(it) {
    return [it & 0xff, it >> 8 & 0xff, it >> 16 & 0xff, it >> 24 & 0xff];
  }
  function packF64(it) {
    return packIEEE754(it, 52, 8);
  }
  function packF32(it) {
    return packIEEE754(it, 23, 4);
  }

  function addGetter(C, key, internal) {
    dP(C[PROTOTYPE], key, { get: function () { return this[internal]; } });
  }

  function get(view, bytes, index, isLittleEndian) {
    var numIndex = +index;
    var intIndex = _toIndex(numIndex);
    if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);
    var store = view[$BUFFER]._b;
    var start = intIndex + view[$OFFSET];
    var pack = store.slice(start, start + bytes);
    return isLittleEndian ? pack : pack.reverse();
  }
  function set(view, bytes, index, conversion, value, isLittleEndian) {
    var numIndex = +index;
    var intIndex = _toIndex(numIndex);
    if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);
    var store = view[$BUFFER]._b;
    var start = intIndex + view[$OFFSET];
    var pack = conversion(+value);
    for (var i = 0; i < bytes; i++) store[start + i] = pack[isLittleEndian ? i : bytes - i - 1];
  }

  if (!_typed.ABV) {
    $ArrayBuffer = function ArrayBuffer(length) {
      _anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
      var byteLength = _toIndex(length);
      this._b = _arrayFill.call(new Array(byteLength), 0);
      this[$LENGTH] = byteLength;
    };

    $DataView = function DataView(buffer, byteOffset, byteLength) {
      _anInstance(this, $DataView, DATA_VIEW);
      _anInstance(buffer, $ArrayBuffer, DATA_VIEW);
      var bufferLength = buffer[$LENGTH];
      var offset = _toInteger(byteOffset);
      if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset!');
      byteLength = byteLength === undefined ? bufferLength - offset : _toLength(byteLength);
      if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);
      this[$BUFFER] = buffer;
      this[$OFFSET] = offset;
      this[$LENGTH] = byteLength;
    };

    if (_descriptors) {
      addGetter($ArrayBuffer, BYTE_LENGTH, '_l');
      addGetter($DataView, BUFFER, '_b');
      addGetter($DataView, BYTE_LENGTH, '_l');
      addGetter($DataView, BYTE_OFFSET, '_o');
    }

    _redefineAll($DataView[PROTOTYPE], {
      getInt8: function getInt8(byteOffset) {
        return get(this, 1, byteOffset)[0] << 24 >> 24;
      },
      getUint8: function getUint8(byteOffset) {
        return get(this, 1, byteOffset)[0];
      },
      getInt16: function getInt16(byteOffset /* , littleEndian */) {
        var bytes = get(this, 2, byteOffset, arguments[1]);
        return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
      },
      getUint16: function getUint16(byteOffset /* , littleEndian */) {
        var bytes = get(this, 2, byteOffset, arguments[1]);
        return bytes[1] << 8 | bytes[0];
      },
      getInt32: function getInt32(byteOffset /* , littleEndian */) {
        return unpackI32(get(this, 4, byteOffset, arguments[1]));
      },
      getUint32: function getUint32(byteOffset /* , littleEndian */) {
        return unpackI32(get(this, 4, byteOffset, arguments[1])) >>> 0;
      },
      getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
        return unpackIEEE754(get(this, 4, byteOffset, arguments[1]), 23, 4);
      },
      getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
        return unpackIEEE754(get(this, 8, byteOffset, arguments[1]), 52, 8);
      },
      setInt8: function setInt8(byteOffset, value) {
        set(this, 1, byteOffset, packI8, value);
      },
      setUint8: function setUint8(byteOffset, value) {
        set(this, 1, byteOffset, packI8, value);
      },
      setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
        set(this, 2, byteOffset, packI16, value, arguments[2]);
      },
      setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
        set(this, 2, byteOffset, packI16, value, arguments[2]);
      },
      setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
        set(this, 4, byteOffset, packI32, value, arguments[2]);
      },
      setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
        set(this, 4, byteOffset, packI32, value, arguments[2]);
      },
      setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
        set(this, 4, byteOffset, packF32, value, arguments[2]);
      },
      setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
        set(this, 8, byteOffset, packF64, value, arguments[2]);
      }
    });
  } else {
    if (!_fails(function () {
      $ArrayBuffer(1);
    }) || !_fails(function () {
      new $ArrayBuffer(-1); // eslint-disable-line no-new
    }) || _fails(function () {
      new $ArrayBuffer(); // eslint-disable-line no-new
      new $ArrayBuffer(1.5); // eslint-disable-line no-new
      new $ArrayBuffer(NaN); // eslint-disable-line no-new
      return $ArrayBuffer.name != ARRAY_BUFFER;
    })) {
      $ArrayBuffer = function ArrayBuffer(length) {
        _anInstance(this, $ArrayBuffer);
        return new BaseBuffer(_toIndex(length));
      };
      var ArrayBufferProto = $ArrayBuffer[PROTOTYPE] = BaseBuffer[PROTOTYPE];
      for (var keys = gOPN(BaseBuffer), j = 0, key; keys.length > j;) {
        if (!((key = keys[j++]) in $ArrayBuffer)) _hide($ArrayBuffer, key, BaseBuffer[key]);
      }
      ArrayBufferProto.constructor = $ArrayBuffer;
    }
    // iOS Safari 7.x bug
    var view = new $DataView(new $ArrayBuffer(2));
    var $setInt8 = $DataView[PROTOTYPE].setInt8;
    view.setInt8(0, 2147483648);
    view.setInt8(1, 2147483649);
    if (view.getInt8(0) || !view.getInt8(1)) _redefineAll($DataView[PROTOTYPE], {
      setInt8: function setInt8(byteOffset, value) {
        $setInt8.call(this, byteOffset, value << 24 >> 24);
      },
      setUint8: function setUint8(byteOffset, value) {
        $setInt8.call(this, byteOffset, value << 24 >> 24);
      }
    }, true);
  }
  _setToStringTag($ArrayBuffer, ARRAY_BUFFER);
  _setToStringTag($DataView, DATA_VIEW);
  _hide($DataView[PROTOTYPE], _typed.VIEW, true);
  exports[ARRAY_BUFFER] = $ArrayBuffer;
  exports[DATA_VIEW] = $DataView;
  });

  var ArrayBuffer$1 = _global.ArrayBuffer;

  var $ArrayBuffer = _typedBuffer.ArrayBuffer;
  var $DataView = _typedBuffer.DataView;
  var $isView = _typed.ABV && ArrayBuffer$1.isView;
  var $slice = $ArrayBuffer.prototype.slice;
  var VIEW$1 = _typed.VIEW;
  var ARRAY_BUFFER = 'ArrayBuffer';

  _export(_export.G + _export.W + _export.F * (ArrayBuffer$1 !== $ArrayBuffer), { ArrayBuffer: $ArrayBuffer });

  _export(_export.S + _export.F * !_typed.CONSTR, ARRAY_BUFFER, {
    // 24.1.3.1 ArrayBuffer.isView(arg)
    isView: function isView(it) {
      return $isView && $isView(it) || _isObject(it) && VIEW$1 in it;
    }
  });

  _export(_export.P + _export.U + _export.F * _fails(function () {
    return !new $ArrayBuffer(2).slice(1, undefined).byteLength;
  }), ARRAY_BUFFER, {
    // 24.1.4.3 ArrayBuffer.prototype.slice(start, end)
    slice: function slice(start, end) {
      if ($slice !== undefined && end === undefined) return $slice.call(_anObject(this), start); // FF fix
      var len = _anObject(this).byteLength;
      var first = _toAbsoluteIndex(start, len);
      var fin = _toAbsoluteIndex(end === undefined ? len : end, len);
      var result = new (_speciesConstructor(this, $ArrayBuffer))(_toLength(fin - first));
      var viewS = new $DataView(this);
      var viewT = new $DataView(result);
      var index = 0;
      while (first < fin) {
        viewT.setUint8(index++, viewS.getUint8(first++));
      } return result;
    }
  });

  _setSpecies(ARRAY_BUFFER);

  _export(_export.G + _export.W + _export.F * !_typed.ABV, {
    DataView: _typedBuffer.DataView
  });

  var _typedArray = createCommonjsModule(function (module) {
  if (_descriptors) {
    var LIBRARY = _library;
    var global = _global;
    var fails = _fails;
    var $export = _export;
    var $typed = _typed;
    var $buffer = _typedBuffer;
    var ctx = _ctx;
    var anInstance = _anInstance;
    var propertyDesc = _propertyDesc;
    var hide = _hide;
    var redefineAll = _redefineAll;
    var toInteger = _toInteger;
    var toLength = _toLength;
    var toIndex = _toIndex;
    var toAbsoluteIndex = _toAbsoluteIndex;
    var toPrimitive = _toPrimitive;
    var has = _has;
    var classof = _classof;
    var isObject = _isObject;
    var toObject = _toObject;
    var isArrayIter = _isArrayIter;
    var create = _objectCreate;
    var getPrototypeOf = _objectGpo;
    var gOPN = _objectGopn.f;
    var getIterFn = core_getIteratorMethod;
    var uid = _uid;
    var wks = _wks;
    var createArrayMethod = _arrayMethods;
    var createArrayIncludes = _arrayIncludes;
    var speciesConstructor = _speciesConstructor;
    var ArrayIterators = es6_array_iterator;
    var Iterators = _iterators;
    var $iterDetect = _iterDetect;
    var setSpecies = _setSpecies;
    var arrayFill = _arrayFill;
    var arrayCopyWithin = _arrayCopyWithin;
    var $DP = _objectDp;
    var $GOPD = _objectGopd;
    var dP = $DP.f;
    var gOPD = $GOPD.f;
    var RangeError = global.RangeError;
    var TypeError = global.TypeError;
    var Uint8Array = global.Uint8Array;
    var ARRAY_BUFFER = 'ArrayBuffer';
    var SHARED_BUFFER = 'Shared' + ARRAY_BUFFER;
    var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
    var PROTOTYPE = 'prototype';
    var ArrayProto = Array[PROTOTYPE];
    var $ArrayBuffer = $buffer.ArrayBuffer;
    var $DataView = $buffer.DataView;
    var arrayForEach = createArrayMethod(0);
    var arrayFilter = createArrayMethod(2);
    var arraySome = createArrayMethod(3);
    var arrayEvery = createArrayMethod(4);
    var arrayFind = createArrayMethod(5);
    var arrayFindIndex = createArrayMethod(6);
    var arrayIncludes = createArrayIncludes(true);
    var arrayIndexOf = createArrayIncludes(false);
    var arrayValues = ArrayIterators.values;
    var arrayKeys = ArrayIterators.keys;
    var arrayEntries = ArrayIterators.entries;
    var arrayLastIndexOf = ArrayProto.lastIndexOf;
    var arrayReduce = ArrayProto.reduce;
    var arrayReduceRight = ArrayProto.reduceRight;
    var arrayJoin = ArrayProto.join;
    var arraySort = ArrayProto.sort;
    var arraySlice = ArrayProto.slice;
    var arrayToString = ArrayProto.toString;
    var arrayToLocaleString = ArrayProto.toLocaleString;
    var ITERATOR = wks('iterator');
    var TAG = wks('toStringTag');
    var TYPED_CONSTRUCTOR = uid('typed_constructor');
    var DEF_CONSTRUCTOR = uid('def_constructor');
    var ALL_CONSTRUCTORS = $typed.CONSTR;
    var TYPED_ARRAY = $typed.TYPED;
    var VIEW = $typed.VIEW;
    var WRONG_LENGTH = 'Wrong length!';

    var $map = createArrayMethod(1, function (O, length) {
      return allocate(speciesConstructor(O, O[DEF_CONSTRUCTOR]), length);
    });

    var LITTLE_ENDIAN = fails(function () {
      // eslint-disable-next-line no-undef
      return new Uint8Array(new Uint16Array([1]).buffer)[0] === 1;
    });

    var FORCED_SET = !!Uint8Array && !!Uint8Array[PROTOTYPE].set && fails(function () {
      new Uint8Array(1).set({});
    });

    var toOffset = function (it, BYTES) {
      var offset = toInteger(it);
      if (offset < 0 || offset % BYTES) throw RangeError('Wrong offset!');
      return offset;
    };

    var validate = function (it) {
      if (isObject(it) && TYPED_ARRAY in it) return it;
      throw TypeError(it + ' is not a typed array!');
    };

    var allocate = function (C, length) {
      if (!(isObject(C) && TYPED_CONSTRUCTOR in C)) {
        throw TypeError('It is not a typed array constructor!');
      } return new C(length);
    };

    var speciesFromList = function (O, list) {
      return fromList(speciesConstructor(O, O[DEF_CONSTRUCTOR]), list);
    };

    var fromList = function (C, list) {
      var index = 0;
      var length = list.length;
      var result = allocate(C, length);
      while (length > index) result[index] = list[index++];
      return result;
    };

    var addGetter = function (it, key, internal) {
      dP(it, key, { get: function () { return this._d[internal]; } });
    };

    var $from = function from(source /* , mapfn, thisArg */) {
      var O = toObject(source);
      var aLen = arguments.length;
      var mapfn = aLen > 1 ? arguments[1] : undefined;
      var mapping = mapfn !== undefined;
      var iterFn = getIterFn(O);
      var i, length, values, result, step, iterator;
      if (iterFn != undefined && !isArrayIter(iterFn)) {
        for (iterator = iterFn.call(O), values = [], i = 0; !(step = iterator.next()).done; i++) {
          values.push(step.value);
        } O = values;
      }
      if (mapping && aLen > 2) mapfn = ctx(mapfn, arguments[2], 2);
      for (i = 0, length = toLength(O.length), result = allocate(this, length); length > i; i++) {
        result[i] = mapping ? mapfn(O[i], i) : O[i];
      }
      return result;
    };

    var $of = function of(/* ...items */) {
      var index = 0;
      var length = arguments.length;
      var result = allocate(this, length);
      while (length > index) result[index] = arguments[index++];
      return result;
    };

    // iOS Safari 6.x fails here
    var TO_LOCALE_BUG = !!Uint8Array && fails(function () { arrayToLocaleString.call(new Uint8Array(1)); });

    var $toLocaleString = function toLocaleString() {
      return arrayToLocaleString.apply(TO_LOCALE_BUG ? arraySlice.call(validate(this)) : validate(this), arguments);
    };

    var proto = {
      copyWithin: function copyWithin(target, start /* , end */) {
        return arrayCopyWithin.call(validate(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
      },
      every: function every(callbackfn /* , thisArg */) {
        return arrayEvery(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
      },
      fill: function fill(value /* , start, end */) { // eslint-disable-line no-unused-vars
        return arrayFill.apply(validate(this), arguments);
      },
      filter: function filter(callbackfn /* , thisArg */) {
        return speciesFromList(this, arrayFilter(validate(this), callbackfn,
          arguments.length > 1 ? arguments[1] : undefined));
      },
      find: function find(predicate /* , thisArg */) {
        return arrayFind(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
      },
      findIndex: function findIndex(predicate /* , thisArg */) {
        return arrayFindIndex(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
      },
      forEach: function forEach(callbackfn /* , thisArg */) {
        arrayForEach(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
      },
      indexOf: function indexOf(searchElement /* , fromIndex */) {
        return arrayIndexOf(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
      },
      includes: function includes(searchElement /* , fromIndex */) {
        return arrayIncludes(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
      },
      join: function join(separator) { // eslint-disable-line no-unused-vars
        return arrayJoin.apply(validate(this), arguments);
      },
      lastIndexOf: function lastIndexOf(searchElement /* , fromIndex */) { // eslint-disable-line no-unused-vars
        return arrayLastIndexOf.apply(validate(this), arguments);
      },
      map: function map(mapfn /* , thisArg */) {
        return $map(validate(this), mapfn, arguments.length > 1 ? arguments[1] : undefined);
      },
      reduce: function reduce(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars
        return arrayReduce.apply(validate(this), arguments);
      },
      reduceRight: function reduceRight(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars
        return arrayReduceRight.apply(validate(this), arguments);
      },
      reverse: function reverse() {
        var that = this;
        var length = validate(that).length;
        var middle = Math.floor(length / 2);
        var index = 0;
        var value;
        while (index < middle) {
          value = that[index];
          that[index++] = that[--length];
          that[length] = value;
        } return that;
      },
      some: function some(callbackfn /* , thisArg */) {
        return arraySome(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
      },
      sort: function sort(comparefn) {
        return arraySort.call(validate(this), comparefn);
      },
      subarray: function subarray(begin, end) {
        var O = validate(this);
        var length = O.length;
        var $begin = toAbsoluteIndex(begin, length);
        return new (speciesConstructor(O, O[DEF_CONSTRUCTOR]))(
          O.buffer,
          O.byteOffset + $begin * O.BYTES_PER_ELEMENT,
          toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - $begin)
        );
      }
    };

    var $slice = function slice(start, end) {
      return speciesFromList(this, arraySlice.call(validate(this), start, end));
    };

    var $set = function set(arrayLike /* , offset */) {
      validate(this);
      var offset = toOffset(arguments[1], 1);
      var length = this.length;
      var src = toObject(arrayLike);
      var len = toLength(src.length);
      var index = 0;
      if (len + offset > length) throw RangeError(WRONG_LENGTH);
      while (index < len) this[offset + index] = src[index++];
    };

    var $iterators = {
      entries: function entries() {
        return arrayEntries.call(validate(this));
      },
      keys: function keys() {
        return arrayKeys.call(validate(this));
      },
      values: function values() {
        return arrayValues.call(validate(this));
      }
    };

    var isTAIndex = function (target, key) {
      return isObject(target)
        && target[TYPED_ARRAY]
        && typeof key != 'symbol'
        && key in target
        && String(+key) == String(key);
    };
    var $getDesc = function getOwnPropertyDescriptor(target, key) {
      return isTAIndex(target, key = toPrimitive(key, true))
        ? propertyDesc(2, target[key])
        : gOPD(target, key);
    };
    var $setDesc = function defineProperty(target, key, desc) {
      if (isTAIndex(target, key = toPrimitive(key, true))
        && isObject(desc)
        && has(desc, 'value')
        && !has(desc, 'get')
        && !has(desc, 'set')
        // TODO: add validation descriptor w/o calling accessors
        && !desc.configurable
        && (!has(desc, 'writable') || desc.writable)
        && (!has(desc, 'enumerable') || desc.enumerable)
      ) {
        target[key] = desc.value;
        return target;
      } return dP(target, key, desc);
    };

    if (!ALL_CONSTRUCTORS) {
      $GOPD.f = $getDesc;
      $DP.f = $setDesc;
    }

    $export($export.S + $export.F * !ALL_CONSTRUCTORS, 'Object', {
      getOwnPropertyDescriptor: $getDesc,
      defineProperty: $setDesc
    });

    if (fails(function () { arrayToString.call({}); })) {
      arrayToString = arrayToLocaleString = function toString() {
        return arrayJoin.call(this);
      };
    }

    var $TypedArrayPrototype$ = redefineAll({}, proto);
    redefineAll($TypedArrayPrototype$, $iterators);
    hide($TypedArrayPrototype$, ITERATOR, $iterators.values);
    redefineAll($TypedArrayPrototype$, {
      slice: $slice,
      set: $set,
      constructor: function () { /* noop */ },
      toString: arrayToString,
      toLocaleString: $toLocaleString
    });
    addGetter($TypedArrayPrototype$, 'buffer', 'b');
    addGetter($TypedArrayPrototype$, 'byteOffset', 'o');
    addGetter($TypedArrayPrototype$, 'byteLength', 'l');
    addGetter($TypedArrayPrototype$, 'length', 'e');
    dP($TypedArrayPrototype$, TAG, {
      get: function () { return this[TYPED_ARRAY]; }
    });

    // eslint-disable-next-line max-statements
    module.exports = function (KEY, BYTES, wrapper, CLAMPED) {
      CLAMPED = !!CLAMPED;
      var NAME = KEY + (CLAMPED ? 'Clamped' : '') + 'Array';
      var GETTER = 'get' + KEY;
      var SETTER = 'set' + KEY;
      var TypedArray = global[NAME];
      var Base = TypedArray || {};
      var TAC = TypedArray && getPrototypeOf(TypedArray);
      var FORCED = !TypedArray || !$typed.ABV;
      var O = {};
      var TypedArrayPrototype = TypedArray && TypedArray[PROTOTYPE];
      var getter = function (that, index) {
        var data = that._d;
        return data.v[GETTER](index * BYTES + data.o, LITTLE_ENDIAN);
      };
      var setter = function (that, index, value) {
        var data = that._d;
        if (CLAMPED) value = (value = Math.round(value)) < 0 ? 0 : value > 0xff ? 0xff : value & 0xff;
        data.v[SETTER](index * BYTES + data.o, value, LITTLE_ENDIAN);
      };
      var addElement = function (that, index) {
        dP(that, index, {
          get: function () {
            return getter(this, index);
          },
          set: function (value) {
            return setter(this, index, value);
          },
          enumerable: true
        });
      };
      if (FORCED) {
        TypedArray = wrapper(function (that, data, $offset, $length) {
          anInstance(that, TypedArray, NAME, '_d');
          var index = 0;
          var offset = 0;
          var buffer, byteLength, length, klass;
          if (!isObject(data)) {
            length = toIndex(data);
            byteLength = length * BYTES;
            buffer = new $ArrayBuffer(byteLength);
          } else if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {
            buffer = data;
            offset = toOffset($offset, BYTES);
            var $len = data.byteLength;
            if ($length === undefined) {
              if ($len % BYTES) throw RangeError(WRONG_LENGTH);
              byteLength = $len - offset;
              if (byteLength < 0) throw RangeError(WRONG_LENGTH);
            } else {
              byteLength = toLength($length) * BYTES;
              if (byteLength + offset > $len) throw RangeError(WRONG_LENGTH);
            }
            length = byteLength / BYTES;
          } else if (TYPED_ARRAY in data) {
            return fromList(TypedArray, data);
          } else {
            return $from.call(TypedArray, data);
          }
          hide(that, '_d', {
            b: buffer,
            o: offset,
            l: byteLength,
            e: length,
            v: new $DataView(buffer)
          });
          while (index < length) addElement(that, index++);
        });
        TypedArrayPrototype = TypedArray[PROTOTYPE] = create($TypedArrayPrototype$);
        hide(TypedArrayPrototype, 'constructor', TypedArray);
      } else if (!fails(function () {
        TypedArray(1);
      }) || !fails(function () {
        new TypedArray(-1); // eslint-disable-line no-new
      }) || !$iterDetect(function (iter) {
        new TypedArray(); // eslint-disable-line no-new
        new TypedArray(null); // eslint-disable-line no-new
        new TypedArray(1.5); // eslint-disable-line no-new
        new TypedArray(iter); // eslint-disable-line no-new
      }, true)) {
        TypedArray = wrapper(function (that, data, $offset, $length) {
          anInstance(that, TypedArray, NAME);
          var klass;
          // `ws` module bug, temporarily remove validation length for Uint8Array
          // https://github.com/websockets/ws/pull/645
          if (!isObject(data)) return new Base(toIndex(data));
          if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {
            return $length !== undefined
              ? new Base(data, toOffset($offset, BYTES), $length)
              : $offset !== undefined
                ? new Base(data, toOffset($offset, BYTES))
                : new Base(data);
          }
          if (TYPED_ARRAY in data) return fromList(TypedArray, data);
          return $from.call(TypedArray, data);
        });
        arrayForEach(TAC !== Function.prototype ? gOPN(Base).concat(gOPN(TAC)) : gOPN(Base), function (key) {
          if (!(key in TypedArray)) hide(TypedArray, key, Base[key]);
        });
        TypedArray[PROTOTYPE] = TypedArrayPrototype;
        if (!LIBRARY) TypedArrayPrototype.constructor = TypedArray;
      }
      var $nativeIterator = TypedArrayPrototype[ITERATOR];
      var CORRECT_ITER_NAME = !!$nativeIterator
        && ($nativeIterator.name == 'values' || $nativeIterator.name == undefined);
      var $iterator = $iterators.values;
      hide(TypedArray, TYPED_CONSTRUCTOR, true);
      hide(TypedArrayPrototype, TYPED_ARRAY, NAME);
      hide(TypedArrayPrototype, VIEW, true);
      hide(TypedArrayPrototype, DEF_CONSTRUCTOR, TypedArray);

      if (CLAMPED ? new TypedArray(1)[TAG] != NAME : !(TAG in TypedArrayPrototype)) {
        dP(TypedArrayPrototype, TAG, {
          get: function () { return NAME; }
        });
      }

      O[NAME] = TypedArray;

      $export($export.G + $export.W + $export.F * (TypedArray != Base), O);

      $export($export.S, NAME, {
        BYTES_PER_ELEMENT: BYTES
      });

      $export($export.S + $export.F * fails(function () { Base.of.call(TypedArray, 1); }), NAME, {
        from: $from,
        of: $of
      });

      if (!(BYTES_PER_ELEMENT in TypedArrayPrototype)) hide(TypedArrayPrototype, BYTES_PER_ELEMENT, BYTES);

      $export($export.P, NAME, proto);

      setSpecies(NAME);

      $export($export.P + $export.F * FORCED_SET, NAME, { set: $set });

      $export($export.P + $export.F * !CORRECT_ITER_NAME, NAME, $iterators);

      if (!LIBRARY && TypedArrayPrototype.toString != arrayToString) TypedArrayPrototype.toString = arrayToString;

      $export($export.P + $export.F * fails(function () {
        new TypedArray(1).slice();
      }), NAME, { slice: $slice });

      $export($export.P + $export.F * (fails(function () {
        return [1, 2].toLocaleString() != new TypedArray([1, 2]).toLocaleString();
      }) || !fails(function () {
        TypedArrayPrototype.toLocaleString.call([1, 2]);
      })), NAME, { toLocaleString: $toLocaleString });

      Iterators[NAME] = CORRECT_ITER_NAME ? $nativeIterator : $iterator;
      if (!LIBRARY && !CORRECT_ITER_NAME) hide(TypedArrayPrototype, ITERATOR, $iterator);
    };
  } else module.exports = function () { /* empty */ };
  });

  _typedArray('Int8', 1, function (init) {
    return function Int8Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Uint8', 1, function (init) {
    return function Uint8Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Uint8', 1, function (init) {
    return function Uint8ClampedArray(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  }, true);

  _typedArray('Int16', 2, function (init) {
    return function Int16Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Uint16', 2, function (init) {
    return function Uint16Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Int32', 4, function (init) {
    return function Int32Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Uint32', 4, function (init) {
    return function Uint32Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Float32', 4, function (init) {
    return function Float32Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  _typedArray('Float64', 8, function (init) {
    return function Float64Array(data, byteOffset, length) {
      return init(this, data, byteOffset, length);
    };
  });

  // 26.1.1 Reflect.apply(target, thisArgument, argumentsList)



  var rApply = (_global.Reflect || {}).apply;
  var fApply = Function.apply;
  // MS Edge argumentsList argument is optional
  _export(_export.S + _export.F * !_fails(function () {
    rApply(function () { /* empty */ });
  }), 'Reflect', {
    apply: function apply(target, thisArgument, argumentsList) {
      var T = _aFunction(target);
      var L = _anObject(argumentsList);
      return rApply ? rApply(T, thisArgument, L) : fApply.call(T, thisArgument, L);
    }
  });

  // 26.1.2 Reflect.construct(target, argumentsList [, newTarget])







  var rConstruct = (_global.Reflect || {}).construct;

  // MS Edge supports only 2 arguments and argumentsList argument is optional
  // FF Nightly sets third argument as `new.target`, but does not create `this` from it
  var NEW_TARGET_BUG = _fails(function () {
    function F() { /* empty */ }
    return !(rConstruct(function () { /* empty */ }, [], F) instanceof F);
  });
  var ARGS_BUG = !_fails(function () {
    rConstruct(function () { /* empty */ });
  });

  _export(_export.S + _export.F * (NEW_TARGET_BUG || ARGS_BUG), 'Reflect', {
    construct: function construct(Target, args /* , newTarget */) {
      _aFunction(Target);
      _anObject(args);
      var newTarget = arguments.length < 3 ? Target : _aFunction(arguments[2]);
      if (ARGS_BUG && !NEW_TARGET_BUG) return rConstruct(Target, args, newTarget);
      if (Target == newTarget) {
        // w/o altered newTarget, optimization for 0-4 arguments
        switch (args.length) {
          case 0: return new Target();
          case 1: return new Target(args[0]);
          case 2: return new Target(args[0], args[1]);
          case 3: return new Target(args[0], args[1], args[2]);
          case 4: return new Target(args[0], args[1], args[2], args[3]);
        }
        // w/o altered newTarget, lot of arguments case
        var $args = [null];
        $args.push.apply($args, args);
        return new (_bind.apply(Target, $args))();
      }
      // with altered newTarget, not support built-in constructors
      var proto = newTarget.prototype;
      var instance = _objectCreate(_isObject(proto) ? proto : Object.prototype);
      var result = Function.apply.call(Target, instance, args);
      return _isObject(result) ? result : instance;
    }
  });

  // 26.1.3 Reflect.defineProperty(target, propertyKey, attributes)





  // MS Edge has broken Reflect.defineProperty - throwing instead of returning false
  _export(_export.S + _export.F * _fails(function () {
    // eslint-disable-next-line no-undef
    Reflect.defineProperty(_objectDp.f({}, 1, { value: 1 }), 1, { value: 2 });
  }), 'Reflect', {
    defineProperty: function defineProperty(target, propertyKey, attributes) {
      _anObject(target);
      propertyKey = _toPrimitive(propertyKey, true);
      _anObject(attributes);
      try {
        _objectDp.f(target, propertyKey, attributes);
        return true;
      } catch (e) {
        return false;
      }
    }
  });

  // 26.1.4 Reflect.deleteProperty(target, propertyKey)

  var gOPD$3 = _objectGopd.f;


  _export(_export.S, 'Reflect', {
    deleteProperty: function deleteProperty(target, propertyKey) {
      var desc = gOPD$3(_anObject(target), propertyKey);
      return desc && !desc.configurable ? false : delete target[propertyKey];
    }
  });

  // 26.1.5 Reflect.enumerate(target)


  var Enumerate = function (iterated) {
    this._t = _anObject(iterated); // target
    this._i = 0;                  // next index
    var keys = this._k = [];      // keys
    var key;
    for (key in iterated) keys.push(key);
  };
  _iterCreate(Enumerate, 'Object', function () {
    var that = this;
    var keys = that._k;
    var key;
    do {
      if (that._i >= keys.length) return { value: undefined, done: true };
    } while (!((key = keys[that._i++]) in that._t));
    return { value: key, done: false };
  });

  _export(_export.S, 'Reflect', {
    enumerate: function enumerate(target) {
      return new Enumerate(target);
    }
  });

  // 26.1.6 Reflect.get(target, propertyKey [, receiver])







  function get(target, propertyKey /* , receiver */) {
    var receiver = arguments.length < 3 ? target : arguments[2];
    var desc, proto;
    if (_anObject(target) === receiver) return target[propertyKey];
    if (desc = _objectGopd.f(target, propertyKey)) return _has(desc, 'value')
      ? desc.value
      : desc.get !== undefined
        ? desc.get.call(receiver)
        : undefined;
    if (_isObject(proto = _objectGpo(target))) return get(proto, propertyKey, receiver);
  }

  _export(_export.S, 'Reflect', { get: get });

  // 26.1.7 Reflect.getOwnPropertyDescriptor(target, propertyKey)




  _export(_export.S, 'Reflect', {
    getOwnPropertyDescriptor: function getOwnPropertyDescriptor(target, propertyKey) {
      return _objectGopd.f(_anObject(target), propertyKey);
    }
  });

  // 26.1.8 Reflect.getPrototypeOf(target)




  _export(_export.S, 'Reflect', {
    getPrototypeOf: function getPrototypeOf(target) {
      return _objectGpo(_anObject(target));
    }
  });

  // 26.1.9 Reflect.has(target, propertyKey)


  _export(_export.S, 'Reflect', {
    has: function has(target, propertyKey) {
      return propertyKey in target;
    }
  });

  // 26.1.10 Reflect.isExtensible(target)


  var $isExtensible = Object.isExtensible;

  _export(_export.S, 'Reflect', {
    isExtensible: function isExtensible(target) {
      _anObject(target);
      return $isExtensible ? $isExtensible(target) : true;
    }
  });

  // all object keys, includes non-enumerable and symbols



  var Reflect$1 = _global.Reflect;
  var _ownKeys = Reflect$1 && Reflect$1.ownKeys || function ownKeys(it) {
    var keys = _objectGopn.f(_anObject(it));
    var getSymbols = _objectGops.f;
    return getSymbols ? keys.concat(getSymbols(it)) : keys;
  };

  // 26.1.11 Reflect.ownKeys(target)


  _export(_export.S, 'Reflect', { ownKeys: _ownKeys });

  // 26.1.12 Reflect.preventExtensions(target)


  var $preventExtensions = Object.preventExtensions;

  _export(_export.S, 'Reflect', {
    preventExtensions: function preventExtensions(target) {
      _anObject(target);
      try {
        if ($preventExtensions) $preventExtensions(target);
        return true;
      } catch (e) {
        return false;
      }
    }
  });

  // 26.1.13 Reflect.set(target, propertyKey, V [, receiver])









  function set(target, propertyKey, V /* , receiver */) {
    var receiver = arguments.length < 4 ? target : arguments[3];
    var ownDesc = _objectGopd.f(_anObject(target), propertyKey);
    var existingDescriptor, proto;
    if (!ownDesc) {
      if (_isObject(proto = _objectGpo(target))) {
        return set(proto, propertyKey, V, receiver);
      }
      ownDesc = _propertyDesc(0);
    }
    if (_has(ownDesc, 'value')) {
      if (ownDesc.writable === false || !_isObject(receiver)) return false;
      if (existingDescriptor = _objectGopd.f(receiver, propertyKey)) {
        if (existingDescriptor.get || existingDescriptor.set || existingDescriptor.writable === false) return false;
        existingDescriptor.value = V;
        _objectDp.f(receiver, propertyKey, existingDescriptor);
      } else _objectDp.f(receiver, propertyKey, _propertyDesc(0, V));
      return true;
    }
    return ownDesc.set === undefined ? false : (ownDesc.set.call(receiver, V), true);
  }

  _export(_export.S, 'Reflect', { set: set });

  // 26.1.14 Reflect.setPrototypeOf(target, proto)



  if (_setProto) _export(_export.S, 'Reflect', {
    setPrototypeOf: function setPrototypeOf(target, proto) {
      _setProto.check(target, proto);
      try {
        _setProto.set(target, proto);
        return true;
      } catch (e) {
        return false;
      }
    }
  });

  // https://github.com/tc39/Array.prototype.includes

  var $includes = _arrayIncludes(true);

  _export(_export.P, 'Array', {
    includes: function includes(el /* , fromIndex = 0 */) {
      return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
    }
  });

  _addToUnscopables('includes');

  // https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray




  var IS_CONCAT_SPREADABLE = _wks('isConcatSpreadable');

  function flattenIntoArray(target, original, source, sourceLen, start, depth, mapper, thisArg) {
    var targetIndex = start;
    var sourceIndex = 0;
    var mapFn = mapper ? _ctx(mapper, thisArg, 3) : false;
    var element, spreadable;

    while (sourceIndex < sourceLen) {
      if (sourceIndex in source) {
        element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

        spreadable = false;
        if (_isObject(element)) {
          spreadable = element[IS_CONCAT_SPREADABLE];
          spreadable = spreadable !== undefined ? !!spreadable : _isArray(element);
        }

        if (spreadable && depth > 0) {
          targetIndex = flattenIntoArray(target, original, element, _toLength(element.length), targetIndex, depth - 1) - 1;
        } else {
          if (targetIndex >= 0x1fffffffffffff) throw TypeError();
          target[targetIndex] = element;
        }

        targetIndex++;
      }
      sourceIndex++;
    }
    return targetIndex;
  }

  var _flattenIntoArray = flattenIntoArray;

  // https://tc39.github.io/proposal-flatMap/#sec-Array.prototype.flatMap







  _export(_export.P, 'Array', {
    flatMap: function flatMap(callbackfn /* , thisArg */) {
      var O = _toObject(this);
      var sourceLen, A;
      _aFunction(callbackfn);
      sourceLen = _toLength(O.length);
      A = _arraySpeciesCreate(O, 0);
      _flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments[1]);
      return A;
    }
  });

  _addToUnscopables('flatMap');

  // https://tc39.github.io/proposal-flatMap/#sec-Array.prototype.flatten







  _export(_export.P, 'Array', {
    flatten: function flatten(/* depthArg = 1 */) {
      var depthArg = arguments[0];
      var O = _toObject(this);
      var sourceLen = _toLength(O.length);
      var A = _arraySpeciesCreate(O, 0);
      _flattenIntoArray(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : _toInteger(depthArg));
      return A;
    }
  });

  _addToUnscopables('flatten');

  // https://github.com/mathiasbynens/String.prototype.at

  var $at$2 = _stringAt(true);


  var FORCED = _fails(function () {
    return '𠮷'.at(0) !== '𠮷';
  });

  _export(_export.P + _export.F * FORCED, 'String', {
    at: function at(pos) {
      return $at$2(this, pos);
    }
  });

  // https://github.com/tc39/proposal-string-pad-start-end




  var _stringPad = function (that, maxLength, fillString, left) {
    var S = String(_defined(that));
    var stringLength = S.length;
    var fillStr = fillString === undefined ? ' ' : String(fillString);
    var intMaxLength = _toLength(maxLength);
    if (intMaxLength <= stringLength || fillStr == '') return S;
    var fillLen = intMaxLength - stringLength;
    var stringFiller = _stringRepeat.call(fillStr, Math.ceil(fillLen / fillStr.length));
    if (stringFiller.length > fillLen) stringFiller = stringFiller.slice(0, fillLen);
    return left ? stringFiller + S : S + stringFiller;
  };

  // https://github.com/tc39/proposal-string-pad-start-end




  // https://github.com/zloirock/core-js/issues/280
  var WEBKIT_BUG = /Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(_userAgent);

  _export(_export.P + _export.F * WEBKIT_BUG, 'String', {
    padStart: function padStart(maxLength /* , fillString = ' ' */) {
      return _stringPad(this, maxLength, arguments.length > 1 ? arguments[1] : undefined, true);
    }
  });

  // https://github.com/tc39/proposal-string-pad-start-end




  // https://github.com/zloirock/core-js/issues/280
  var WEBKIT_BUG$1 = /Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(_userAgent);

  _export(_export.P + _export.F * WEBKIT_BUG$1, 'String', {
    padEnd: function padEnd(maxLength /* , fillString = ' ' */) {
      return _stringPad(this, maxLength, arguments.length > 1 ? arguments[1] : undefined, false);
    }
  });

  // https://github.com/sebmarkbage/ecmascript-string-left-right-trim
  _stringTrim('trimLeft', function ($trim) {
    return function trimLeft() {
      return $trim(this, 1);
    };
  }, 'trimStart');

  // https://github.com/sebmarkbage/ecmascript-string-left-right-trim
  _stringTrim('trimRight', function ($trim) {
    return function trimRight() {
      return $trim(this, 2);
    };
  }, 'trimEnd');

  // https://tc39.github.io/String.prototype.matchAll/





  var RegExpProto = RegExp.prototype;

  var $RegExpStringIterator = function (regexp, string) {
    this._r = regexp;
    this._s = string;
  };

  _iterCreate($RegExpStringIterator, 'RegExp String', function next() {
    var match = this._r.exec(this._s);
    return { value: match, done: match === null };
  });

  _export(_export.P, 'String', {
    matchAll: function matchAll(regexp) {
      _defined(this);
      if (!_isRegexp(regexp)) throw TypeError(regexp + ' is not a regexp!');
      var S = String(this);
      var flags = 'flags' in RegExpProto ? String(regexp.flags) : _flags.call(regexp);
      var rx = new RegExp(regexp.source, ~flags.indexOf('g') ? flags : 'g' + flags);
      rx.lastIndex = _toLength(regexp.lastIndex);
      return new $RegExpStringIterator(rx, S);
    }
  });

  _wksDefine('asyncIterator');

  _wksDefine('observable');

  // https://github.com/tc39/proposal-object-getownpropertydescriptors






  _export(_export.S, 'Object', {
    getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
      var O = _toIobject(object);
      var getDesc = _objectGopd.f;
      var keys = _ownKeys(O);
      var result = {};
      var i = 0;
      var key, desc;
      while (keys.length > i) {
        desc = getDesc(O, key = keys[i++]);
        if (desc !== undefined) _createProperty(result, key, desc);
      }
      return result;
    }
  });

  var isEnum$1 = _objectPie.f;
  var _objectToArray = function (isEntries) {
    return function (it) {
      var O = _toIobject(it);
      var keys = _objectKeys(O);
      var length = keys.length;
      var i = 0;
      var result = [];
      var key;
      while (length > i) {
        key = keys[i++];
        if (!_descriptors || isEnum$1.call(O, key)) {
          result.push(isEntries ? [key, O[key]] : O[key]);
        }
      }
      return result;
    };
  };

  // https://github.com/tc39/proposal-object-values-entries

  var $values = _objectToArray(false);

  _export(_export.S, 'Object', {
    values: function values(it) {
      return $values(it);
    }
  });

  // https://github.com/tc39/proposal-object-values-entries

  var $entries = _objectToArray(true);

  _export(_export.S, 'Object', {
    entries: function entries(it) {
      return $entries(it);
    }
  });

  // Forced replacement prototype accessors methods
  var _objectForcedPam =  !_fails(function () {
    var K = Math.random();
    // In FF throws only define methods
    // eslint-disable-next-line no-undef, no-useless-call
    __defineSetter__.call(null, K, function () { /* empty */ });
    delete _global[K];
  });

  // B.2.2.2 Object.prototype.__defineGetter__(P, getter)
  _descriptors && _export(_export.P + _objectForcedPam, 'Object', {
    __defineGetter__: function __defineGetter__(P, getter) {
      _objectDp.f(_toObject(this), P, { get: _aFunction(getter), enumerable: true, configurable: true });
    }
  });

  // B.2.2.3 Object.prototype.__defineSetter__(P, setter)
  _descriptors && _export(_export.P + _objectForcedPam, 'Object', {
    __defineSetter__: function __defineSetter__(P, setter) {
      _objectDp.f(_toObject(this), P, { set: _aFunction(setter), enumerable: true, configurable: true });
    }
  });

  var getOwnPropertyDescriptor = _objectGopd.f;

  // B.2.2.4 Object.prototype.__lookupGetter__(P)
  _descriptors && _export(_export.P + _objectForcedPam, 'Object', {
    __lookupGetter__: function __lookupGetter__(P) {
      var O = _toObject(this);
      var K = _toPrimitive(P, true);
      var D;
      do {
        if (D = getOwnPropertyDescriptor(O, K)) return D.get;
      } while (O = _objectGpo(O));
    }
  });

  var getOwnPropertyDescriptor$1 = _objectGopd.f;

  // B.2.2.5 Object.prototype.__lookupSetter__(P)
  _descriptors && _export(_export.P + _objectForcedPam, 'Object', {
    __lookupSetter__: function __lookupSetter__(P) {
      var O = _toObject(this);
      var K = _toPrimitive(P, true);
      var D;
      do {
        if (D = getOwnPropertyDescriptor$1(O, K)) return D.set;
      } while (O = _objectGpo(O));
    }
  });

  var _arrayFromIterable = function (iter, ITERATOR) {
    var result = [];
    _forOf(iter, false, result.push, result, ITERATOR);
    return result;
  };

  // https://github.com/DavidBruant/Map-Set.prototype.toJSON


  var _collectionToJson = function (NAME) {
    return function toJSON() {
      if (_classof(this) != NAME) throw TypeError(NAME + "#toJSON isn't generic");
      return _arrayFromIterable(this);
    };
  };

  // https://github.com/DavidBruant/Map-Set.prototype.toJSON


  _export(_export.P + _export.R, 'Map', { toJSON: _collectionToJson('Map') });

  // https://github.com/DavidBruant/Map-Set.prototype.toJSON


  _export(_export.P + _export.R, 'Set', { toJSON: _collectionToJson('Set') });

  // https://tc39.github.io/proposal-setmap-offrom/


  var _setCollectionOf = function (COLLECTION) {
    _export(_export.S, COLLECTION, { of: function of() {
      var length = arguments.length;
      var A = new Array(length);
      while (length--) A[length] = arguments[length];
      return new this(A);
    } });
  };

  // https://tc39.github.io/proposal-setmap-offrom/#sec-map.of
  _setCollectionOf('Map');

  // https://tc39.github.io/proposal-setmap-offrom/#sec-set.of
  _setCollectionOf('Set');

  // https://tc39.github.io/proposal-setmap-offrom/#sec-weakmap.of
  _setCollectionOf('WeakMap');

  // https://tc39.github.io/proposal-setmap-offrom/#sec-weakset.of
  _setCollectionOf('WeakSet');

  // https://tc39.github.io/proposal-setmap-offrom/





  var _setCollectionFrom = function (COLLECTION) {
    _export(_export.S, COLLECTION, { from: function from(source /* , mapFn, thisArg */) {
      var mapFn = arguments[1];
      var mapping, A, n, cb;
      _aFunction(this);
      mapping = mapFn !== undefined;
      if (mapping) _aFunction(mapFn);
      if (source == undefined) return new this();
      A = [];
      if (mapping) {
        n = 0;
        cb = _ctx(mapFn, arguments[2], 2);
        _forOf(source, false, function (nextItem) {
          A.push(cb(nextItem, n++));
        });
      } else {
        _forOf(source, false, A.push, A);
      }
      return new this(A);
    } });
  };

  // https://tc39.github.io/proposal-setmap-offrom/#sec-map.from
  _setCollectionFrom('Map');

  // https://tc39.github.io/proposal-setmap-offrom/#sec-set.from
  _setCollectionFrom('Set');

  // https://tc39.github.io/proposal-setmap-offrom/#sec-weakmap.from
  _setCollectionFrom('WeakMap');

  // https://tc39.github.io/proposal-setmap-offrom/#sec-weakset.from
  _setCollectionFrom('WeakSet');

  // https://github.com/tc39/proposal-global


  _export(_export.G, { global: _global });

  // https://github.com/tc39/proposal-global


  _export(_export.S, 'System', { global: _global });

  // https://github.com/ljharb/proposal-is-error



  _export(_export.S, 'Error', {
    isError: function isError(it) {
      return _cof(it) === 'Error';
    }
  });

  // https://rwaldron.github.io/proposal-math-extensions/


  _export(_export.S, 'Math', {
    clamp: function clamp(x, lower, upper) {
      return Math.min(upper, Math.max(lower, x));
    }
  });

  // https://rwaldron.github.io/proposal-math-extensions/


  _export(_export.S, 'Math', { DEG_PER_RAD: Math.PI / 180 });

  // https://rwaldron.github.io/proposal-math-extensions/

  var RAD_PER_DEG = 180 / Math.PI;

  _export(_export.S, 'Math', {
    degrees: function degrees(radians) {
      return radians * RAD_PER_DEG;
    }
  });

  // https://rwaldron.github.io/proposal-math-extensions/
  var _mathScale = Math.scale || function scale(x, inLow, inHigh, outLow, outHigh) {
    if (
      arguments.length === 0
        // eslint-disable-next-line no-self-compare
        || x != x
        // eslint-disable-next-line no-self-compare
        || inLow != inLow
        // eslint-disable-next-line no-self-compare
        || inHigh != inHigh
        // eslint-disable-next-line no-self-compare
        || outLow != outLow
        // eslint-disable-next-line no-self-compare
        || outHigh != outHigh
    ) return NaN;
    if (x === Infinity || x === -Infinity) return x;
    return (x - inLow) * (outHigh - outLow) / (inHigh - inLow) + outLow;
  };

  // https://rwaldron.github.io/proposal-math-extensions/




  _export(_export.S, 'Math', {
    fscale: function fscale(x, inLow, inHigh, outLow, outHigh) {
      return _mathFround(_mathScale(x, inLow, inHigh, outLow, outHigh));
    }
  });

  // https://gist.github.com/BrendanEich/4294d5c212a6d2254703


  _export(_export.S, 'Math', {
    iaddh: function iaddh(x0, x1, y0, y1) {
      var $x0 = x0 >>> 0;
      var $x1 = x1 >>> 0;
      var $y0 = y0 >>> 0;
      return $x1 + (y1 >>> 0) + (($x0 & $y0 | ($x0 | $y0) & ~($x0 + $y0 >>> 0)) >>> 31) | 0;
    }
  });

  // https://gist.github.com/BrendanEich/4294d5c212a6d2254703


  _export(_export.S, 'Math', {
    isubh: function isubh(x0, x1, y0, y1) {
      var $x0 = x0 >>> 0;
      var $x1 = x1 >>> 0;
      var $y0 = y0 >>> 0;
      return $x1 - (y1 >>> 0) - ((~$x0 & $y0 | ~($x0 ^ $y0) & $x0 - $y0 >>> 0) >>> 31) | 0;
    }
  });

  // https://gist.github.com/BrendanEich/4294d5c212a6d2254703


  _export(_export.S, 'Math', {
    imulh: function imulh(u, v) {
      var UINT16 = 0xffff;
      var $u = +u;
      var $v = +v;
      var u0 = $u & UINT16;
      var v0 = $v & UINT16;
      var u1 = $u >> 16;
      var v1 = $v >> 16;
      var t = (u1 * v0 >>> 0) + (u0 * v0 >>> 16);
      return u1 * v1 + (t >> 16) + ((u0 * v1 >>> 0) + (t & UINT16) >> 16);
    }
  });

  // https://rwaldron.github.io/proposal-math-extensions/


  _export(_export.S, 'Math', { RAD_PER_DEG: 180 / Math.PI });

  // https://rwaldron.github.io/proposal-math-extensions/

  var DEG_PER_RAD = Math.PI / 180;

  _export(_export.S, 'Math', {
    radians: function radians(degrees) {
      return degrees * DEG_PER_RAD;
    }
  });

  // https://rwaldron.github.io/proposal-math-extensions/


  _export(_export.S, 'Math', { scale: _mathScale });

  // https://gist.github.com/BrendanEich/4294d5c212a6d2254703


  _export(_export.S, 'Math', {
    umulh: function umulh(u, v) {
      var UINT16 = 0xffff;
      var $u = +u;
      var $v = +v;
      var u0 = $u & UINT16;
      var v0 = $v & UINT16;
      var u1 = $u >>> 16;
      var v1 = $v >>> 16;
      var t = (u1 * v0 >>> 0) + (u0 * v0 >>> 16);
      return u1 * v1 + (t >>> 16) + ((u0 * v1 >>> 0) + (t & UINT16) >>> 16);
    }
  });

  // http://jfbastien.github.io/papers/Math.signbit.html


  _export(_export.S, 'Math', { signbit: function signbit(x) {
    // eslint-disable-next-line no-self-compare
    return (x = +x) != x ? x : x == 0 ? 1 / x == Infinity : x > 0;
  } });

  _export(_export.P + _export.R, 'Promise', { 'finally': function (onFinally) {
    var C = _speciesConstructor(this, _core.Promise || _global.Promise);
    var isFunction = typeof onFinally == 'function';
    return this.then(
      isFunction ? function (x) {
        return _promiseResolve(C, onFinally()).then(function () { return x; });
      } : onFinally,
      isFunction ? function (e) {
        return _promiseResolve(C, onFinally()).then(function () { throw e; });
      } : onFinally
    );
  } });

  // https://github.com/tc39/proposal-promise-try




  _export(_export.S, 'Promise', { 'try': function (callbackfn) {
    var promiseCapability = _newPromiseCapability.f(this);
    var result = _perform(callbackfn);
    (result.e ? promiseCapability.reject : promiseCapability.resolve)(result.v);
    return promiseCapability.promise;
  } });

  var shared$1 = _shared('metadata');
  var store = shared$1.store || (shared$1.store = new (es6_weakMap)());

  var getOrCreateMetadataMap = function (target, targetKey, create) {
    var targetMetadata = store.get(target);
    if (!targetMetadata) {
      if (!create) return undefined;
      store.set(target, targetMetadata = new es6_map());
    }
    var keyMetadata = targetMetadata.get(targetKey);
    if (!keyMetadata) {
      if (!create) return undefined;
      targetMetadata.set(targetKey, keyMetadata = new es6_map());
    } return keyMetadata;
  };
  var ordinaryHasOwnMetadata = function (MetadataKey, O, P) {
    var metadataMap = getOrCreateMetadataMap(O, P, false);
    return metadataMap === undefined ? false : metadataMap.has(MetadataKey);
  };
  var ordinaryGetOwnMetadata = function (MetadataKey, O, P) {
    var metadataMap = getOrCreateMetadataMap(O, P, false);
    return metadataMap === undefined ? undefined : metadataMap.get(MetadataKey);
  };
  var ordinaryDefineOwnMetadata = function (MetadataKey, MetadataValue, O, P) {
    getOrCreateMetadataMap(O, P, true).set(MetadataKey, MetadataValue);
  };
  var ordinaryOwnMetadataKeys = function (target, targetKey) {
    var metadataMap = getOrCreateMetadataMap(target, targetKey, false);
    var keys = [];
    if (metadataMap) metadataMap.forEach(function (_, key) { keys.push(key); });
    return keys;
  };
  var toMetaKey = function (it) {
    return it === undefined || typeof it == 'symbol' ? it : String(it);
  };
  var exp$3 = function (O) {
    _export(_export.S, 'Reflect', O);
  };

  var _metadata = {
    store: store,
    map: getOrCreateMetadataMap,
    has: ordinaryHasOwnMetadata,
    get: ordinaryGetOwnMetadata,
    set: ordinaryDefineOwnMetadata,
    keys: ordinaryOwnMetadataKeys,
    key: toMetaKey,
    exp: exp$3
  };

  var toMetaKey$1 = _metadata.key;
  var ordinaryDefineOwnMetadata$1 = _metadata.set;

  _metadata.exp({ defineMetadata: function defineMetadata(metadataKey, metadataValue, target, targetKey) {
    ordinaryDefineOwnMetadata$1(metadataKey, metadataValue, _anObject(target), toMetaKey$1(targetKey));
  } });

  var toMetaKey$2 = _metadata.key;
  var getOrCreateMetadataMap$1 = _metadata.map;
  var store$1 = _metadata.store;

  _metadata.exp({ deleteMetadata: function deleteMetadata(metadataKey, target /* , targetKey */) {
    var targetKey = arguments.length < 3 ? undefined : toMetaKey$2(arguments[2]);
    var metadataMap = getOrCreateMetadataMap$1(_anObject(target), targetKey, false);
    if (metadataMap === undefined || !metadataMap['delete'](metadataKey)) return false;
    if (metadataMap.size) return true;
    var targetMetadata = store$1.get(target);
    targetMetadata['delete'](targetKey);
    return !!targetMetadata.size || store$1['delete'](target);
  } });

  var ordinaryHasOwnMetadata$1 = _metadata.has;
  var ordinaryGetOwnMetadata$1 = _metadata.get;
  var toMetaKey$3 = _metadata.key;

  var ordinaryGetMetadata = function (MetadataKey, O, P) {
    var hasOwn = ordinaryHasOwnMetadata$1(MetadataKey, O, P);
    if (hasOwn) return ordinaryGetOwnMetadata$1(MetadataKey, O, P);
    var parent = _objectGpo(O);
    return parent !== null ? ordinaryGetMetadata(MetadataKey, parent, P) : undefined;
  };

  _metadata.exp({ getMetadata: function getMetadata(metadataKey, target /* , targetKey */) {
    return ordinaryGetMetadata(metadataKey, _anObject(target), arguments.length < 3 ? undefined : toMetaKey$3(arguments[2]));
  } });

  var ordinaryOwnMetadataKeys$1 = _metadata.keys;
  var toMetaKey$4 = _metadata.key;

  var ordinaryMetadataKeys = function (O, P) {
    var oKeys = ordinaryOwnMetadataKeys$1(O, P);
    var parent = _objectGpo(O);
    if (parent === null) return oKeys;
    var pKeys = ordinaryMetadataKeys(parent, P);
    return pKeys.length ? oKeys.length ? _arrayFromIterable(new es6_set(oKeys.concat(pKeys))) : pKeys : oKeys;
  };

  _metadata.exp({ getMetadataKeys: function getMetadataKeys(target /* , targetKey */) {
    return ordinaryMetadataKeys(_anObject(target), arguments.length < 2 ? undefined : toMetaKey$4(arguments[1]));
  } });

  var ordinaryGetOwnMetadata$2 = _metadata.get;
  var toMetaKey$5 = _metadata.key;

  _metadata.exp({ getOwnMetadata: function getOwnMetadata(metadataKey, target /* , targetKey */) {
    return ordinaryGetOwnMetadata$2(metadataKey, _anObject(target)
      , arguments.length < 3 ? undefined : toMetaKey$5(arguments[2]));
  } });

  var ordinaryOwnMetadataKeys$2 = _metadata.keys;
  var toMetaKey$6 = _metadata.key;

  _metadata.exp({ getOwnMetadataKeys: function getOwnMetadataKeys(target /* , targetKey */) {
    return ordinaryOwnMetadataKeys$2(_anObject(target), arguments.length < 2 ? undefined : toMetaKey$6(arguments[1]));
  } });

  var ordinaryHasOwnMetadata$2 = _metadata.has;
  var toMetaKey$7 = _metadata.key;

  var ordinaryHasMetadata = function (MetadataKey, O, P) {
    var hasOwn = ordinaryHasOwnMetadata$2(MetadataKey, O, P);
    if (hasOwn) return true;
    var parent = _objectGpo(O);
    return parent !== null ? ordinaryHasMetadata(MetadataKey, parent, P) : false;
  };

  _metadata.exp({ hasMetadata: function hasMetadata(metadataKey, target /* , targetKey */) {
    return ordinaryHasMetadata(metadataKey, _anObject(target), arguments.length < 3 ? undefined : toMetaKey$7(arguments[2]));
  } });

  var ordinaryHasOwnMetadata$3 = _metadata.has;
  var toMetaKey$8 = _metadata.key;

  _metadata.exp({ hasOwnMetadata: function hasOwnMetadata(metadataKey, target /* , targetKey */) {
    return ordinaryHasOwnMetadata$3(metadataKey, _anObject(target)
      , arguments.length < 3 ? undefined : toMetaKey$8(arguments[2]));
  } });

  var toMetaKey$9 = _metadata.key;
  var ordinaryDefineOwnMetadata$2 = _metadata.set;

  _metadata.exp({ metadata: function metadata(metadataKey, metadataValue) {
    return function decorator(target, targetKey) {
      ordinaryDefineOwnMetadata$2(
        metadataKey, metadataValue,
        (targetKey !== undefined ? _anObject : _aFunction)(target),
        toMetaKey$9(targetKey)
      );
    };
  } });

  // https://github.com/rwaldron/tc39-notes/blob/master/es6/2014-09/sept-25.md#510-globalasap-for-enqueuing-a-microtask

  var microtask$1 = _microtask();
  var process$3 = _global.process;
  var isNode$2 = _cof(process$3) == 'process';

  _export(_export.G, {
    asap: function asap(fn) {
      var domain = isNode$2 && process$3.domain;
      microtask$1(domain ? domain.bind(fn) : fn);
    }
  });

  // https://github.com/zenparsing/es-observable



  var microtask$2 = _microtask();
  var OBSERVABLE = _wks('observable');






  var RETURN = _forOf.RETURN;

  var getMethod = function (fn) {
    return fn == null ? undefined : _aFunction(fn);
  };

  var cleanupSubscription = function (subscription) {
    var cleanup = subscription._c;
    if (cleanup) {
      subscription._c = undefined;
      cleanup();
    }
  };

  var subscriptionClosed = function (subscription) {
    return subscription._o === undefined;
  };

  var closeSubscription = function (subscription) {
    if (!subscriptionClosed(subscription)) {
      subscription._o = undefined;
      cleanupSubscription(subscription);
    }
  };

  var Subscription = function (observer, subscriber) {
    _anObject(observer);
    this._c = undefined;
    this._o = observer;
    observer = new SubscriptionObserver(this);
    try {
      var cleanup = subscriber(observer);
      var subscription = cleanup;
      if (cleanup != null) {
        if (typeof cleanup.unsubscribe === 'function') cleanup = function () { subscription.unsubscribe(); };
        else _aFunction(cleanup);
        this._c = cleanup;
      }
    } catch (e) {
      observer.error(e);
      return;
    } if (subscriptionClosed(this)) cleanupSubscription(this);
  };

  Subscription.prototype = _redefineAll({}, {
    unsubscribe: function unsubscribe() { closeSubscription(this); }
  });

  var SubscriptionObserver = function (subscription) {
    this._s = subscription;
  };

  SubscriptionObserver.prototype = _redefineAll({}, {
    next: function next(value) {
      var subscription = this._s;
      if (!subscriptionClosed(subscription)) {
        var observer = subscription._o;
        try {
          var m = getMethod(observer.next);
          if (m) return m.call(observer, value);
        } catch (e) {
          try {
            closeSubscription(subscription);
          } finally {
            throw e;
          }
        }
      }
    },
    error: function error(value) {
      var subscription = this._s;
      if (subscriptionClosed(subscription)) throw value;
      var observer = subscription._o;
      subscription._o = undefined;
      try {
        var m = getMethod(observer.error);
        if (!m) throw value;
        value = m.call(observer, value);
      } catch (e) {
        try {
          cleanupSubscription(subscription);
        } finally {
          throw e;
        }
      } cleanupSubscription(subscription);
      return value;
    },
    complete: function complete(value) {
      var subscription = this._s;
      if (!subscriptionClosed(subscription)) {
        var observer = subscription._o;
        subscription._o = undefined;
        try {
          var m = getMethod(observer.complete);
          value = m ? m.call(observer, value) : undefined;
        } catch (e) {
          try {
            cleanupSubscription(subscription);
          } finally {
            throw e;
          }
        } cleanupSubscription(subscription);
        return value;
      }
    }
  });

  var $Observable = function Observable(subscriber) {
    _anInstance(this, $Observable, 'Observable', '_f')._f = _aFunction(subscriber);
  };

  _redefineAll($Observable.prototype, {
    subscribe: function subscribe(observer) {
      return new Subscription(observer, this._f);
    },
    forEach: function forEach(fn) {
      var that = this;
      return new (_core.Promise || _global.Promise)(function (resolve, reject) {
        _aFunction(fn);
        var subscription = that.subscribe({
          next: function (value) {
            try {
              return fn(value);
            } catch (e) {
              reject(e);
              subscription.unsubscribe();
            }
          },
          error: reject,
          complete: resolve
        });
      });
    }
  });

  _redefineAll($Observable, {
    from: function from(x) {
      var C = typeof this === 'function' ? this : $Observable;
      var method = getMethod(_anObject(x)[OBSERVABLE]);
      if (method) {
        var observable = _anObject(method.call(x));
        return observable.constructor === C ? observable : new C(function (observer) {
          return observable.subscribe(observer);
        });
      }
      return new C(function (observer) {
        var done = false;
        microtask$2(function () {
          if (!done) {
            try {
              if (_forOf(x, false, function (it) {
                observer.next(it);
                if (done) return RETURN;
              }) === RETURN) return;
            } catch (e) {
              if (done) throw e;
              observer.error(e);
              return;
            } observer.complete();
          }
        });
        return function () { done = true; };
      });
    },
    of: function of() {
      for (var i = 0, l = arguments.length, items = new Array(l); i < l;) items[i] = arguments[i++];
      return new (typeof this === 'function' ? this : $Observable)(function (observer) {
        var done = false;
        microtask$2(function () {
          if (!done) {
            for (var j = 0; j < items.length; ++j) {
              observer.next(items[j]);
              if (done) return;
            } observer.complete();
          }
        });
        return function () { done = true; };
      });
    }
  });

  _hide($Observable.prototype, OBSERVABLE, function () { return this; });

  _export(_export.G, { Observable: $Observable });

  _setSpecies('Observable');

  // ie9- setTimeout & setInterval additional parameters fix



  var slice = [].slice;
  var MSIE = /MSIE .\./.test(_userAgent); // <- dirty ie9- check
  var wrap$1 = function (set) {
    return function (fn, time /* , ...args */) {
      var boundArgs = arguments.length > 2;
      var args = boundArgs ? slice.call(arguments, 2) : false;
      return set(boundArgs ? function () {
        // eslint-disable-next-line no-new-func
        (typeof fn == 'function' ? fn : Function(fn)).apply(this, args);
      } : fn, time);
    };
  };
  _export(_export.G + _export.B + _export.F * MSIE, {
    setTimeout: wrap$1(_global.setTimeout),
    setInterval: wrap$1(_global.setInterval)
  });

  _export(_export.G + _export.B, {
    setImmediate: _task.set,
    clearImmediate: _task.clear
  });

  var ITERATOR$4 = _wks('iterator');
  var TO_STRING_TAG = _wks('toStringTag');
  var ArrayValues = _iterators.Array;

  var DOMIterables = {
    CSSRuleList: true, // TODO: Not spec compliant, should be false.
    CSSStyleDeclaration: false,
    CSSValueList: false,
    ClientRectList: false,
    DOMRectList: false,
    DOMStringList: false,
    DOMTokenList: true,
    DataTransferItemList: false,
    FileList: false,
    HTMLAllCollection: false,
    HTMLCollection: false,
    HTMLFormElement: false,
    HTMLSelectElement: false,
    MediaList: true, // TODO: Not spec compliant, should be false.
    MimeTypeArray: false,
    NamedNodeMap: false,
    NodeList: true,
    PaintRequestList: false,
    Plugin: false,
    PluginArray: false,
    SVGLengthList: false,
    SVGNumberList: false,
    SVGPathSegList: false,
    SVGPointList: false,
    SVGStringList: false,
    SVGTransformList: false,
    SourceBufferList: false,
    StyleSheetList: true, // TODO: Not spec compliant, should be false.
    TextTrackCueList: false,
    TextTrackList: false,
    TouchList: false
  };

  for (var collections = _objectKeys(DOMIterables), i$2 = 0; i$2 < collections.length; i$2++) {
    var NAME$1 = collections[i$2];
    var explicit = DOMIterables[NAME$1];
    var Collection = _global[NAME$1];
    var proto$3 = Collection && Collection.prototype;
    var key$1;
    if (proto$3) {
      if (!proto$3[ITERATOR$4]) _hide(proto$3, ITERATOR$4, ArrayValues);
      if (!proto$3[TO_STRING_TAG]) _hide(proto$3, TO_STRING_TAG, NAME$1);
      _iterators[NAME$1] = ArrayValues;
      if (explicit) for (key$1 in es6_array_iterator) if (!proto$3[key$1]) _redefine(proto$3, key$1, es6_array_iterator[key$1], true);
    }
  }

  var runtime = createCommonjsModule(function (module) {
  /**
   * Copyright (c) 2014, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * https://raw.github.com/facebook/regenerator/master/LICENSE file. An
   * additional grant of patent rights can be found in the PATENTS file in
   * the same directory.
   */

  !(function(global) {

    var Op = Object.prototype;
    var hasOwn = Op.hasOwnProperty;
    var undefined$1; // More compressible than void 0.
    var $Symbol = typeof Symbol === "function" ? Symbol : {};
    var iteratorSymbol = $Symbol.iterator || "@@iterator";
    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
    var runtime = global.regeneratorRuntime;
    if (runtime) {
      {
        // If regeneratorRuntime is defined globally and we're in a module,
        // make the exports object identical to regeneratorRuntime.
        module.exports = runtime;
      }
      // Don't bother evaluating the rest of this file if the runtime was
      // already defined globally.
      return;
    }

    // Define the runtime globally (as expected by generated code) as either
    // module.exports (if we're in a module) or a new, empty object.
    runtime = global.regeneratorRuntime =  module.exports ;

    function wrap(innerFn, outerFn, self, tryLocsList) {
      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
      var generator = Object.create(protoGenerator.prototype);
      var context = new Context(tryLocsList || []);

      // The ._invoke method unifies the implementations of the .next,
      // .throw, and .return methods.
      generator._invoke = makeInvokeMethod(innerFn, self, context);

      return generator;
    }
    runtime.wrap = wrap;

    // Try/catch helper to minimize deoptimizations. Returns a completion
    // record like context.tryEntries[i].completion. This interface could
    // have been (and was previously) designed to take a closure to be
    // invoked without arguments, but in all the cases we care about we
    // already have an existing method we want to call, so there's no need
    // to create a new function object. We can even get away with assuming
    // the method takes exactly one argument, since that happens to be true
    // in every case, so we don't have to touch the arguments object. The
    // only additional allocation required is the completion record, which
    // has a stable shape and so hopefully should be cheap to allocate.
    function tryCatch(fn, obj, arg) {
      try {
        return { type: "normal", arg: fn.call(obj, arg) };
      } catch (err) {
        return { type: "throw", arg: err };
      }
    }

    var GenStateSuspendedStart = "suspendedStart";
    var GenStateSuspendedYield = "suspendedYield";
    var GenStateExecuting = "executing";
    var GenStateCompleted = "completed";

    // Returning this object from the innerFn has the same effect as
    // breaking out of the dispatch switch statement.
    var ContinueSentinel = {};

    // Dummy constructor functions that we use as the .constructor and
    // .constructor.prototype properties for functions that return Generator
    // objects. For full spec compliance, you may wish to configure your
    // minifier not to mangle the names of these two functions.
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}

    // This is a polyfill for %IteratorPrototype% for environments that
    // don't natively support it.
    var IteratorPrototype = {};
    IteratorPrototype[iteratorSymbol] = function () {
      return this;
    };

    var getProto = Object.getPrototypeOf;
    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    if (NativeIteratorPrototype &&
        NativeIteratorPrototype !== Op &&
        hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
      // This environment has a native %IteratorPrototype%; use it instead
      // of the polyfill.
      IteratorPrototype = NativeIteratorPrototype;
    }

    var Gp = GeneratorFunctionPrototype.prototype =
      Generator.prototype = Object.create(IteratorPrototype);
    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
    GeneratorFunctionPrototype.constructor = GeneratorFunction;
    GeneratorFunctionPrototype[toStringTagSymbol] =
      GeneratorFunction.displayName = "GeneratorFunction";

    // Helper for defining the .next, .throw, and .return methods of the
    // Iterator interface in terms of a single ._invoke method.
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function(method) {
        prototype[method] = function(arg) {
          return this._invoke(method, arg);
        };
      });
    }

    runtime.isGeneratorFunction = function(genFun) {
      var ctor = typeof genFun === "function" && genFun.constructor;
      return ctor
        ? ctor === GeneratorFunction ||
          // For the native GeneratorFunction constructor, the best we can
          // do is to check its .name property.
          (ctor.displayName || ctor.name) === "GeneratorFunction"
        : false;
    };

    runtime.mark = function(genFun) {
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
      } else {
        genFun.__proto__ = GeneratorFunctionPrototype;
        if (!(toStringTagSymbol in genFun)) {
          genFun[toStringTagSymbol] = "GeneratorFunction";
        }
      }
      genFun.prototype = Object.create(Gp);
      return genFun;
    };

    // Within the body of any async function, `await x` is transformed to
    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
    // `hasOwn.call(value, "__await")` to determine if the yielded value is
    // meant to be awaited.
    runtime.awrap = function(arg) {
      return { __await: arg };
    };

    function AsyncIterator(generator) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if (record.type === "throw") {
          reject(record.arg);
        } else {
          var result = record.arg;
          var value = result.value;
          if (value &&
              typeof value === "object" &&
              hasOwn.call(value, "__await")) {
            return Promise.resolve(value.__await).then(function(value) {
              invoke("next", value, resolve, reject);
            }, function(err) {
              invoke("throw", err, resolve, reject);
            });
          }

          return Promise.resolve(value).then(function(unwrapped) {
            // When a yielded Promise is resolved, its final value becomes
            // the .value of the Promise<{value,done}> result for the
            // current iteration. If the Promise is rejected, however, the
            // result for this iteration will be rejected with the same
            // reason. Note that rejections of yielded Promises are not
            // thrown back into the generator function, as is the case
            // when an awaited Promise is rejected. This difference in
            // behavior between yield and await is important, because it
            // allows the consumer to decide what to do with the yielded
            // rejection (swallow it and continue, manually .throw it back
            // into the generator, abandon iteration, whatever). With
            // await, by contrast, there is no opportunity to examine the
            // rejection reason outside the generator function, so the
            // only option is to throw it from the await expression, and
            // let the generator function handle the exception.
            result.value = unwrapped;
            resolve(result);
          }, reject);
        }
      }

      if (typeof global.process === "object" && global.process.domain) {
        invoke = global.process.domain.bind(invoke);
      }

      var previousPromise;

      function enqueue(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new Promise(function(resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }

        return previousPromise =
          // If enqueue has been called before, then we want to wait until
          // all previous Promises have been resolved before calling invoke,
          // so that results are always delivered in the correct order. If
          // enqueue has not been called before, then it is important to
          // call invoke immediately, without waiting on a callback to fire,
          // so that the async generator function has the opportunity to do
          // any necessary setup in a predictable way. This predictability
          // is why the Promise constructor synchronously invokes its
          // executor callback, and why async functions synchronously
          // execute code before the first await. Since we implement simple
          // async functions in terms of async generators, it is especially
          // important to get this right, even though it requires care.
          previousPromise ? previousPromise.then(
            callInvokeWithMethodAndArg,
            // Avoid propagating failures to Promises returned by later
            // invocations of the iterator.
            callInvokeWithMethodAndArg
          ) : callInvokeWithMethodAndArg();
      }

      // Define the unified helper method that is used to implement .next,
      // .throw, and .return (see defineIteratorMethods).
      this._invoke = enqueue;
    }

    defineIteratorMethods(AsyncIterator.prototype);
    AsyncIterator.prototype[asyncIteratorSymbol] = function () {
      return this;
    };
    runtime.AsyncIterator = AsyncIterator;

    // Note that simple async functions are implemented on top of
    // AsyncIterator objects; they just return a Promise for the value of
    // the final result produced by the iterator.
    runtime.async = function(innerFn, outerFn, self, tryLocsList) {
      var iter = new AsyncIterator(
        wrap(innerFn, outerFn, self, tryLocsList)
      );

      return runtime.isGeneratorFunction(outerFn)
        ? iter // If outerFn is a generator, return the full iterator.
        : iter.next().then(function(result) {
            return result.done ? result.value : iter.next();
          });
    };

    function makeInvokeMethod(innerFn, self, context) {
      var state = GenStateSuspendedStart;

      return function invoke(method, arg) {
        if (state === GenStateExecuting) {
          throw new Error("Generator is already running");
        }

        if (state === GenStateCompleted) {
          if (method === "throw") {
            throw arg;
          }

          // Be forgiving, per 25.3.3.3.3 of the spec:
          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
          return doneResult();
        }

        context.method = method;
        context.arg = arg;

        while (true) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }

          if (context.method === "next") {
            // Setting context._sent for legacy support of Babel's
            // function.sent implementation.
            context.sent = context._sent = context.arg;

          } else if (context.method === "throw") {
            if (state === GenStateSuspendedStart) {
              state = GenStateCompleted;
              throw context.arg;
            }

            context.dispatchException(context.arg);

          } else if (context.method === "return") {
            context.abrupt("return", context.arg);
          }

          state = GenStateExecuting;

          var record = tryCatch(innerFn, self, context);
          if (record.type === "normal") {
            // If an exception is thrown from innerFn, we leave state ===
            // GenStateExecuting and loop back for another invocation.
            state = context.done
              ? GenStateCompleted
              : GenStateSuspendedYield;

            if (record.arg === ContinueSentinel) {
              continue;
            }

            return {
              value: record.arg,
              done: context.done
            };

          } else if (record.type === "throw") {
            state = GenStateCompleted;
            // Dispatch the exception by looping back around to the
            // context.dispatchException(context.arg) call above.
            context.method = "throw";
            context.arg = record.arg;
          }
        }
      };
    }

    // Call delegate.iterator[context.method](context.arg) and handle the
    // result, either by returning a { value, done } result from the
    // delegate iterator, or by modifying context.method and context.arg,
    // setting context.delegate to null, and returning the ContinueSentinel.
    function maybeInvokeDelegate(delegate, context) {
      var method = delegate.iterator[context.method];
      if (method === undefined$1) {
        // A .throw or .return when the delegate iterator has no .throw
        // method always terminates the yield* loop.
        context.delegate = null;

        if (context.method === "throw") {
          if (delegate.iterator.return) {
            // If the delegate iterator has a return method, give it a
            // chance to clean up.
            context.method = "return";
            context.arg = undefined$1;
            maybeInvokeDelegate(delegate, context);

            if (context.method === "throw") {
              // If maybeInvokeDelegate(context) changed context.method from
              // "return" to "throw", let that override the TypeError below.
              return ContinueSentinel;
            }
          }

          context.method = "throw";
          context.arg = new TypeError(
            "The iterator does not provide a 'throw' method");
        }

        return ContinueSentinel;
      }

      var record = tryCatch(method, delegate.iterator, context.arg);

      if (record.type === "throw") {
        context.method = "throw";
        context.arg = record.arg;
        context.delegate = null;
        return ContinueSentinel;
      }

      var info = record.arg;

      if (! info) {
        context.method = "throw";
        context.arg = new TypeError("iterator result is not an object");
        context.delegate = null;
        return ContinueSentinel;
      }

      if (info.done) {
        // Assign the result of the finished delegate to the temporary
        // variable specified by delegate.resultName (see delegateYield).
        context[delegate.resultName] = info.value;

        // Resume execution at the desired location (see delegateYield).
        context.next = delegate.nextLoc;

        // If context.method was "throw" but the delegate handled the
        // exception, let the outer generator proceed normally. If
        // context.method was "next", forget context.arg since it has been
        // "consumed" by the delegate iterator. If context.method was
        // "return", allow the original .return call to continue in the
        // outer generator.
        if (context.method !== "return") {
          context.method = "next";
          context.arg = undefined$1;
        }

      } else {
        // Re-yield the result returned by the delegate method.
        return info;
      }

      // The delegate iterator is finished, so forget it and continue with
      // the outer generator.
      context.delegate = null;
      return ContinueSentinel;
    }

    // Define Generator.prototype.{next,throw,return} in terms of the
    // unified ._invoke helper method.
    defineIteratorMethods(Gp);

    Gp[toStringTagSymbol] = "Generator";

    // A Generator should always return itself as the iterator object when the
    // @@iterator function is called on it. Some browsers' implementations of the
    // iterator prototype chain incorrectly implement this, causing the Generator
    // object to not be returned from this call. This ensures that doesn't happen.
    // See https://github.com/facebook/regenerator/issues/274 for more details.
    Gp[iteratorSymbol] = function() {
      return this;
    };

    Gp.toString = function() {
      return "[object Generator]";
    };

    function pushTryEntry(locs) {
      var entry = { tryLoc: locs[0] };

      if (1 in locs) {
        entry.catchLoc = locs[1];
      }

      if (2 in locs) {
        entry.finallyLoc = locs[2];
        entry.afterLoc = locs[3];
      }

      this.tryEntries.push(entry);
    }

    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal";
      delete record.arg;
      entry.completion = record;
    }

    function Context(tryLocsList) {
      // The root entry object (effectively a try statement without a catch
      // or a finally block) gives us a place to store values thrown from
      // locations where there is no enclosing try statement.
      this.tryEntries = [{ tryLoc: "root" }];
      tryLocsList.forEach(pushTryEntry, this);
      this.reset(true);
    }

    runtime.keys = function(object) {
      var keys = [];
      for (var key in object) {
        keys.push(key);
      }
      keys.reverse();

      // Rather than returning an object with a next method, we keep
      // things simple and return the next function itself.
      return function next() {
        while (keys.length) {
          var key = keys.pop();
          if (key in object) {
            next.value = key;
            next.done = false;
            return next;
          }
        }

        // To avoid creating an additional object, we just hang the .value
        // and .done properties off the next function object itself. This
        // also ensures that the minifier will not anonymize the function.
        next.done = true;
        return next;
      };
    };

    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) {
          return iteratorMethod.call(iterable);
        }

        if (typeof iterable.next === "function") {
          return iterable;
        }

        if (!isNaN(iterable.length)) {
          var i = -1, next = function next() {
            while (++i < iterable.length) {
              if (hasOwn.call(iterable, i)) {
                next.value = iterable[i];
                next.done = false;
                return next;
              }
            }

            next.value = undefined$1;
            next.done = true;

            return next;
          };

          return next.next = next;
        }
      }

      // Return an iterator with no values.
      return { next: doneResult };
    }
    runtime.values = values;

    function doneResult() {
      return { value: undefined$1, done: true };
    }

    Context.prototype = {
      constructor: Context,

      reset: function(skipTempReset) {
        this.prev = 0;
        this.next = 0;
        // Resetting context._sent for legacy support of Babel's
        // function.sent implementation.
        this.sent = this._sent = undefined$1;
        this.done = false;
        this.delegate = null;

        this.method = "next";
        this.arg = undefined$1;

        this.tryEntries.forEach(resetTryEntry);

        if (!skipTempReset) {
          for (var name in this) {
            // Not sure about the optimal order of these conditions:
            if (name.charAt(0) === "t" &&
                hasOwn.call(this, name) &&
                !isNaN(+name.slice(1))) {
              this[name] = undefined$1;
            }
          }
        }
      },

      stop: function() {
        this.done = true;

        var rootEntry = this.tryEntries[0];
        var rootRecord = rootEntry.completion;
        if (rootRecord.type === "throw") {
          throw rootRecord.arg;
        }

        return this.rval;
      },

      dispatchException: function(exception) {
        if (this.done) {
          throw exception;
        }

        var context = this;
        function handle(loc, caught) {
          record.type = "throw";
          record.arg = exception;
          context.next = loc;

          if (caught) {
            // If the dispatched exception was caught by a catch block,
            // then let that catch block handle the exception normally.
            context.method = "next";
            context.arg = undefined$1;
          }

          return !! caught;
        }

        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          var record = entry.completion;

          if (entry.tryLoc === "root") {
            // Exception thrown outside of any try block that could handle
            // it, so set the completion value of the entire function to
            // throw the exception.
            return handle("end");
          }

          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc");
            var hasFinally = hasOwn.call(entry, "finallyLoc");

            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              } else if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }

            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              }

            } else if (hasFinally) {
              if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }

            } else {
              throw new Error("try statement without catch or finally");
            }
          }
        }
      },

      abrupt: function(type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev &&
              hasOwn.call(entry, "finallyLoc") &&
              this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }

        if (finallyEntry &&
            (type === "break" ||
             type === "continue") &&
            finallyEntry.tryLoc <= arg &&
            arg <= finallyEntry.finallyLoc) {
          // Ignore the finally entry if control is not jumping to a
          // location outside the try/catch block.
          finallyEntry = null;
        }

        var record = finallyEntry ? finallyEntry.completion : {};
        record.type = type;
        record.arg = arg;

        if (finallyEntry) {
          this.method = "next";
          this.next = finallyEntry.finallyLoc;
          return ContinueSentinel;
        }

        return this.complete(record);
      },

      complete: function(record, afterLoc) {
        if (record.type === "throw") {
          throw record.arg;
        }

        if (record.type === "break" ||
            record.type === "continue") {
          this.next = record.arg;
        } else if (record.type === "return") {
          this.rval = this.arg = record.arg;
          this.method = "return";
          this.next = "end";
        } else if (record.type === "normal" && afterLoc) {
          this.next = afterLoc;
        }

        return ContinueSentinel;
      },

      finish: function(finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) {
            this.complete(entry.completion, entry.afterLoc);
            resetTryEntry(entry);
            return ContinueSentinel;
          }
        }
      },

      "catch": function(tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if (record.type === "throw") {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }

        // The context.catch method must only be called with a location
        // argument that corresponds to a known catch block.
        throw new Error("illegal catch attempt");
      },

      delegateYield: function(iterable, resultName, nextLoc) {
        this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        };

        if (this.method === "next") {
          // Deliberately forget the last sent value so that we don't
          // accidentally pass it on to the delegate.
          this.arg = undefined$1;
        }

        return ContinueSentinel;
      }
    };
  })(
    // Among the various tricks for obtaining a reference to the global
    // object, this seems to be the most reliable technique that does not
    // use indirect eval (which violates Content Security Policy).
    typeof commonjsGlobal === "object" ? commonjsGlobal :
    typeof window === "object" ? window :
    typeof self === "object" ? self : commonjsGlobal
  );
  });

  var _replacer = function (regExp, replace) {
    var replacer = replace === Object(replace) ? function (part) {
      return replace[part];
    } : replace;
    return function (it) {
      return String(it).replace(regExp, replacer);
    };
  };

  // https://github.com/benjamingr/RexExp.escape

  var $re = _replacer(/[\\^$*+?.()|[\]{}]/g, '\\$&');

  _export(_export.S, 'RegExp', { escape: function escape(it) { return $re(it); } });

  var _escape = _core.RegExp.escape;

  if (commonjsGlobal._babelPolyfill) {
    throw new Error("only one instance of babel-polyfill is allowed");
  }
  commonjsGlobal._babelPolyfill = true;

  var DEFINE_PROPERTY = "defineProperty";
  function define$1(O, key, value) {
    O[key] || Object[DEFINE_PROPERTY](O, key, {
      writable: true,
      configurable: true,
      value: value
    });
  }

  define$1(String.prototype, "padLeft", "".padStart);
  define$1(String.prototype, "padRight", "".padEnd);

  "pop,reverse,shift,keys,values,entries,indexOf,every,some,forEach,map,filter,find,findIndex,includes,join,slice,concat,push,splice,unshift,sort,lastIndexOf,reduce,reduceRight,copyWithin,fill".split(",").forEach(function (key) {
    [][key] && define$1(Array, key, Function.call.bind([][key]));
  });

  /**
   * @license
   * webxr-polyfill
   * Copyright (c) 2017 Google
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   * http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  /**
   * @license
   * cardboard-vr-display
   * Copyright (c) 2015-2017 Google
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   * http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  /**
   * @license
   * webvr-polyfill-dpdb 
   * Copyright (c) 2017 Google
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   * http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  /**
   * @license
   * wglu-preserve-state
   * Copyright (c) 2016, Brandon Jones.
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in
   * all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   * THE SOFTWARE.
   */

  /**
   * @license
   * nosleep.js
   * Copyright (c) 2017, Rich Tibbett
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in
   * all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   * THE SOFTWARE.
   */

  const _global$1 = typeof global !== 'undefined' ? global :
                  typeof self !== 'undefined' ? self :
                  typeof window !== 'undefined' ? window : {};

  const PRIVATE = Symbol('@@webxr-polyfill/EventTarget');
  class EventTarget {
    constructor() {
      this[PRIVATE] = {
        listeners: new Map(),
      };
    }
    addEventListener(type, listener) {
      if (typeof type !== 'string') { throw new Error('`type` must be a string'); }
      if (typeof listener !== 'function') { throw new Error('`listener` must be a function'); }
      const typedListeners = this[PRIVATE].listeners.get(type) || [];
      typedListeners.push(listener);
      this[PRIVATE].listeners.set(type, typedListeners);
    }
    removeEventListener(type, listener) {
      if (typeof type !== 'string') { throw new Error('`type` must be a string'); }
      if (typeof listener !== 'function') { throw new Error('`listener` must be a function'); }
      const typedListeners = this[PRIVATE].listeners.get(type) || [];
      for (let i = typedListeners.length; i >= 0; i--) {
        if (typedListeners[i] === listener) {
          typedListeners.pop();
        }
      }
    }
    dispatchEvent(type, event) {
      const typedListeners = this[PRIVATE].listeners.get(type) || [];
      const queue = [];
      for (let i = 0; i < typedListeners.length; i++) {
        queue[i] = typedListeners[i];
      }
      for (let listener of queue) {
        listener(event);
      }
      if (typeof this[`on${type}`] === 'function') {
        this[`on${type}`](event);
      }
    }
  }

  const EPSILON$1 = 0.000001;
  let ARRAY_TYPE = (typeof Float32Array !== 'undefined') ? Float32Array : Array;

  function create() {
    let out = new ARRAY_TYPE(16);
    if(ARRAY_TYPE != Float32Array) {
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
    }
    out[0] = 1;
    out[5] = 1;
    out[10] = 1;
    out[15] = 1;
    return out;
  }

  function copy(out, a) {
    out[0] = a[0];
    out[1] = a[1];
    out[2] = a[2];
    out[3] = a[3];
    out[4] = a[4];
    out[5] = a[5];
    out[6] = a[6];
    out[7] = a[7];
    out[8] = a[8];
    out[9] = a[9];
    out[10] = a[10];
    out[11] = a[11];
    out[12] = a[12];
    out[13] = a[13];
    out[14] = a[14];
    out[15] = a[15];
    return out;
  }


  function identity(out) {
    out[0] = 1;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = 1;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 1;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }

  function invert(out, a) {
    let a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3];
    let a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
    let a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
    let a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
    let b00 = a00 * a11 - a01 * a10;
    let b01 = a00 * a12 - a02 * a10;
    let b02 = a00 * a13 - a03 * a10;
    let b03 = a01 * a12 - a02 * a11;
    let b04 = a01 * a13 - a03 * a11;
    let b05 = a02 * a13 - a03 * a12;
    let b06 = a20 * a31 - a21 * a30;
    let b07 = a20 * a32 - a22 * a30;
    let b08 = a20 * a33 - a23 * a30;
    let b09 = a21 * a32 - a22 * a31;
    let b10 = a21 * a33 - a23 * a31;
    let b11 = a22 * a33 - a23 * a32;
    let det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
    if (!det) {
      return null;
    }
    det = 1.0 / det;
    out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
    out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
    out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
    out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
    out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
    out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
    out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
    out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
    out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
    out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
    out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
    out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
    out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
    out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
    out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
    out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
    return out;
  }


  function multiply$1(out, a, b) {
    let a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3];
    let a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
    let a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
    let a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
    let b0  = b[0], b1 = b[1], b2 = b[2], b3 = b[3];
    out[0] = b0*a00 + b1*a10 + b2*a20 + b3*a30;
    out[1] = b0*a01 + b1*a11 + b2*a21 + b3*a31;
    out[2] = b0*a02 + b1*a12 + b2*a22 + b3*a32;
    out[3] = b0*a03 + b1*a13 + b2*a23 + b3*a33;
    b0 = b[4]; b1 = b[5]; b2 = b[6]; b3 = b[7];
    out[4] = b0*a00 + b1*a10 + b2*a20 + b3*a30;
    out[5] = b0*a01 + b1*a11 + b2*a21 + b3*a31;
    out[6] = b0*a02 + b1*a12 + b2*a22 + b3*a32;
    out[7] = b0*a03 + b1*a13 + b2*a23 + b3*a33;
    b0 = b[8]; b1 = b[9]; b2 = b[10]; b3 = b[11];
    out[8] = b0*a00 + b1*a10 + b2*a20 + b3*a30;
    out[9] = b0*a01 + b1*a11 + b2*a21 + b3*a31;
    out[10] = b0*a02 + b1*a12 + b2*a22 + b3*a32;
    out[11] = b0*a03 + b1*a13 + b2*a23 + b3*a33;
    b0 = b[12]; b1 = b[13]; b2 = b[14]; b3 = b[15];
    out[12] = b0*a00 + b1*a10 + b2*a20 + b3*a30;
    out[13] = b0*a01 + b1*a11 + b2*a21 + b3*a31;
    out[14] = b0*a02 + b1*a12 + b2*a22 + b3*a32;
    out[15] = b0*a03 + b1*a13 + b2*a23 + b3*a33;
    return out;
  }












  function fromRotationTranslation(out, q, v) {
    let x = q[0], y = q[1], z = q[2], w = q[3];
    let x2 = x + x;
    let y2 = y + y;
    let z2 = z + z;
    let xx = x * x2;
    let xy = x * y2;
    let xz = x * z2;
    let yy = y * y2;
    let yz = y * z2;
    let zz = z * z2;
    let wx = w * x2;
    let wy = w * y2;
    let wz = w * z2;
    out[0] = 1 - (yy + zz);
    out[1] = xy + wz;
    out[2] = xz - wy;
    out[3] = 0;
    out[4] = xy - wz;
    out[5] = 1 - (xx + zz);
    out[6] = yz + wx;
    out[7] = 0;
    out[8] = xz + wy;
    out[9] = yz - wx;
    out[10] = 1 - (xx + yy);
    out[11] = 0;
    out[12] = v[0];
    out[13] = v[1];
    out[14] = v[2];
    out[15] = 1;
    return out;
  }

  function getTranslation(out, mat) {
    out[0] = mat[12];
    out[1] = mat[13];
    out[2] = mat[14];
    return out;
  }

  function getRotation(out, mat) {
    let trace = mat[0] + mat[5] + mat[10];
    let S = 0;
    if (trace > 0) {
      S = Math.sqrt(trace + 1.0) * 2;
      out[3] = 0.25 * S;
      out[0] = (mat[6] - mat[9]) / S;
      out[1] = (mat[8] - mat[2]) / S;
      out[2] = (mat[1] - mat[4]) / S;
    } else if ((mat[0] > mat[5]) && (mat[0] > mat[10])) {
      S = Math.sqrt(1.0 + mat[0] - mat[5] - mat[10]) * 2;
      out[3] = (mat[6] - mat[9]) / S;
      out[0] = 0.25 * S;
      out[1] = (mat[1] + mat[4]) / S;
      out[2] = (mat[8] + mat[2]) / S;
    } else if (mat[5] > mat[10]) {
      S = Math.sqrt(1.0 + mat[5] - mat[0] - mat[10]) * 2;
      out[3] = (mat[8] - mat[2]) / S;
      out[0] = (mat[1] + mat[4]) / S;
      out[1] = 0.25 * S;
      out[2] = (mat[6] + mat[9]) / S;
    } else {
      S = Math.sqrt(1.0 + mat[10] - mat[0] - mat[5]) * 2;
      out[3] = (mat[1] - mat[4]) / S;
      out[0] = (mat[8] + mat[2]) / S;
      out[1] = (mat[6] + mat[9]) / S;
      out[2] = 0.25 * S;
    }
    return out;
  }




  function perspective(out, fovy, aspect, near, far) {
    let f = 1.0 / Math.tan(fovy / 2), nf;
    out[0] = f / aspect;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = f;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[15] = 0;
    if (far != null && far !== Infinity) {
      nf = 1 / (near - far);
      out[10] = (far + near) * nf;
      out[14] = (2 * far * near) * nf;
    } else {
      out[10] = -1;
      out[14] = -2 * near;
    }
    return out;
  }

  function create$1() {
    let out = new ARRAY_TYPE(3);
    if(ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    return out;
  }
  function clone$1(a) {
    var out = new ARRAY_TYPE(3);
    out[0] = a[0];
    out[1] = a[1];
    out[2] = a[2];
    return out;
  }
  function length(a) {
    let x = a[0];
    let y = a[1];
    let z = a[2];
    return Math.sqrt(x*x + y*y + z*z);
  }
  function fromValues$1(x, y, z) {
    let out = new ARRAY_TYPE(3);
    out[0] = x;
    out[1] = y;
    out[2] = z;
    return out;
  }
  function copy$1(out, a) {
    out[0] = a[0];
    out[1] = a[1];
    out[2] = a[2];
    return out;
  }

  function add$1(out, a, b) {
    out[0] = a[0] + b[0];
    out[1] = a[1] + b[1];
    out[2] = a[2] + b[2];
    return out;
  }








  function scale$1(out, a, b) {
    out[0] = a[0] * b;
    out[1] = a[1] * b;
    out[2] = a[2] * b;
    return out;
  }






  function normalize(out, a) {
    let x = a[0];
    let y = a[1];
    let z = a[2];
    let len = x*x + y*y + z*z;
    if (len > 0) {
      len = 1 / Math.sqrt(len);
      out[0] = a[0] * len;
      out[1] = a[1] * len;
      out[2] = a[2] * len;
    }
    return out;
  }
  function dot(a, b) {
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
  }
  function cross(out, a, b) {
    let ax = a[0], ay = a[1], az = a[2];
    let bx = b[0], by = b[1], bz = b[2];
    out[0] = ay * bz - az * by;
    out[1] = az * bx - ax * bz;
    out[2] = ax * by - ay * bx;
    return out;
  }






  function transformQuat(out, a, q) {
      let qx = q[0], qy = q[1], qz = q[2], qw = q[3];
      let x = a[0], y = a[1], z = a[2];
      let uvx = qy * z - qz * y,
          uvy = qz * x - qx * z,
          uvz = qx * y - qy * x;
      let uuvx = qy * uvz - qz * uvy,
          uuvy = qz * uvx - qx * uvz,
          uuvz = qx * uvy - qy * uvx;
      let w2 = qw * 2;
      uvx *= w2;
      uvy *= w2;
      uvz *= w2;
      uuvx *= 2;
      uuvy *= 2;
      uuvz *= 2;
      out[0] = x + uvx + uuvx;
      out[1] = y + uvy + uuvy;
      out[2] = z + uvz + uuvz;
      return out;
  }



  function angle(a, b) {
    let tempA = fromValues$1(a[0], a[1], a[2]);
    let tempB = fromValues$1(b[0], b[1], b[2]);
    normalize(tempA, tempA);
    normalize(tempB, tempB);
    let cosine = dot(tempA, tempB);
    if(cosine > 1.0) {
      return 0;
    }
    else if(cosine < -1.0) {
      return Math.PI;
    } else {
      return Math.acos(cosine);
    }
  }








  const len = length;

  const forEach = (function() {
    let vec = create$1();
    return function(a, stride, offset, count, fn, arg) {
      let i, l;
      if(!stride) {
        stride = 3;
      }
      if(!offset) {
        offset = 0;
      }
      if(count) {
        l = Math.min((count * stride) + offset, a.length);
      } else {
        l = a.length;
      }
      for(i = offset; i < l; i += stride) {
        vec[0] = a[i]; vec[1] = a[i+1]; vec[2] = a[i+2];
        fn(vec, vec, arg);
        a[i] = vec[0]; a[i+1] = vec[1]; a[i+2] = vec[2];
      }
      return a;
    };
  })();

  function create$2() {
    let out = new ARRAY_TYPE(9);
    if(ARRAY_TYPE != Float32Array) {
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[5] = 0;
      out[6] = 0;
      out[7] = 0;
    }
    out[0] = 1;
    out[4] = 1;
    out[8] = 1;
    return out;
  }

  function create$3() {
    let out = new ARRAY_TYPE(4);
    if(ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
    }
    return out;
  }
  function clone$3(a) {
    let out = new ARRAY_TYPE(4);
    out[0] = a[0];
    out[1] = a[1];
    out[2] = a[2];
    out[3] = a[3];
    return out;
  }
  function fromValues$3(x, y, z, w) {
    let out = new ARRAY_TYPE(4);
    out[0] = x;
    out[1] = y;
    out[2] = z;
    out[3] = w;
    return out;
  }
  function copy$3(out, a) {
    out[0] = a[0];
    out[1] = a[1];
    out[2] = a[2];
    out[3] = a[3];
    return out;
  }


















  function normalize$1(out, a) {
    let x = a[0];
    let y = a[1];
    let z = a[2];
    let w = a[3];
    let len = x*x + y*y + z*z + w*w;
    if (len > 0) {
      len = 1 / Math.sqrt(len);
      out[0] = x * len;
      out[1] = y * len;
      out[2] = z * len;
      out[3] = w * len;
    }
    return out;
  }















  const forEach$1 = (function() {
    let vec = create$3();
    return function(a, stride, offset, count, fn, arg) {
      let i, l;
      if(!stride) {
        stride = 4;
      }
      if(!offset) {
        offset = 0;
      }
      if(count) {
        l = Math.min((count * stride) + offset, a.length);
      } else {
        l = a.length;
      }
      for(i = offset; i < l; i += stride) {
        vec[0] = a[i]; vec[1] = a[i+1]; vec[2] = a[i+2]; vec[3] = a[i+3];
        fn(vec, vec, arg);
        a[i] = vec[0]; a[i+1] = vec[1]; a[i+2] = vec[2]; a[i+3] = vec[3];
      }
      return a;
    };
  })();

  function create$4() {
    let out = new ARRAY_TYPE(4);
    if(ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    out[3] = 1;
    return out;
  }

  function setAxisAngle(out, axis, rad) {
    rad = rad * 0.5;
    let s = Math.sin(rad);
    out[0] = s * axis[0];
    out[1] = s * axis[1];
    out[2] = s * axis[2];
    out[3] = Math.cos(rad);
    return out;
  }

  function multiply$4(out, a, b) {
    let ax = a[0], ay = a[1], az = a[2], aw = a[3];
    let bx = b[0], by = b[1], bz = b[2], bw = b[3];
    out[0] = ax * bw + aw * bx + ay * bz - az * by;
    out[1] = ay * bw + aw * by + az * bx - ax * bz;
    out[2] = az * bw + aw * bz + ax * by - ay * bx;
    out[3] = aw * bw - ax * bx - ay * by - az * bz;
    return out;
  }




  function slerp(out, a, b, t) {
    let ax = a[0], ay = a[1], az = a[2], aw = a[3];
    let bx = b[0], by = b[1], bz = b[2], bw = b[3];
    let omega, cosom, sinom, scale0, scale1;
    cosom = ax * bx + ay * by + az * bz + aw * bw;
    if ( cosom < 0.0 ) {
      cosom = -cosom;
      bx = - bx;
      by = - by;
      bz = - bz;
      bw = - bw;
    }
    if ( (1.0 - cosom) > EPSILON$1 ) {
      omega  = Math.acos(cosom);
      sinom  = Math.sin(omega);
      scale0 = Math.sin((1.0 - t) * omega) / sinom;
      scale1 = Math.sin(t * omega) / sinom;
    } else {
      scale0 = 1.0 - t;
      scale1 = t;
    }
    out[0] = scale0 * ax + scale1 * bx;
    out[1] = scale0 * ay + scale1 * by;
    out[2] = scale0 * az + scale1 * bz;
    out[3] = scale0 * aw + scale1 * bw;
    return out;
  }

  function invert$2(out, a) {
    let a0 = a[0], a1 = a[1], a2 = a[2], a3 = a[3];
    let dot$$1 = a0*a0 + a1*a1 + a2*a2 + a3*a3;
    let invDot = dot$$1 ? 1.0/dot$$1 : 0;
    out[0] = -a0*invDot;
    out[1] = -a1*invDot;
    out[2] = -a2*invDot;
    out[3] = a3*invDot;
    return out;
  }

  function fromMat3(out, m) {
    let fTrace = m[0] + m[4] + m[8];
    let fRoot;
    if ( fTrace > 0.0 ) {
      fRoot = Math.sqrt(fTrace + 1.0);
      out[3] = 0.5 * fRoot;
      fRoot = 0.5/fRoot;
      out[0] = (m[5]-m[7])*fRoot;
      out[1] = (m[6]-m[2])*fRoot;
      out[2] = (m[1]-m[3])*fRoot;
    } else {
      let i = 0;
      if ( m[4] > m[0] )
        i = 1;
      if ( m[8] > m[i*3+i] )
        i = 2;
      let j = (i+1)%3;
      let k = (i+2)%3;
      fRoot = Math.sqrt(m[i*3+i]-m[j*3+j]-m[k*3+k] + 1.0);
      out[i] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[3] = (m[j*3+k] - m[k*3+j]) * fRoot;
      out[j] = (m[j*3+i] + m[i*3+j]) * fRoot;
      out[k] = (m[k*3+i] + m[i*3+k]) * fRoot;
    }
    return out;
  }
  function fromEuler(out, x, y, z) {
      let halfToRad = 0.5 * Math.PI / 180.0;
      x *= halfToRad;
      y *= halfToRad;
      z *= halfToRad;
      let sx = Math.sin(x);
      let cx = Math.cos(x);
      let sy = Math.sin(y);
      let cy = Math.cos(y);
      let sz = Math.sin(z);
      let cz = Math.cos(z);
      out[0] = sx * cy * cz - cx * sy * sz;
      out[1] = cx * sy * cz + sx * cy * sz;
      out[2] = cx * cy * sz - sx * sy * cz;
      out[3] = cx * cy * cz + sx * sy * sz;
      return out;
  }

  const clone$4 = clone$3;
  const fromValues$4 = fromValues$3;
  const copy$4 = copy$3;










  const normalize$2 = normalize$1;


  const rotationTo = (function() {
    let tmpvec3 = create$1();
    let xUnitVec3 = fromValues$1(1,0,0);
    let yUnitVec3 = fromValues$1(0,1,0);
    return function(out, a, b) {
      let dot$$1 = dot(a, b);
      if (dot$$1 < -0.999999) {
        cross(tmpvec3, xUnitVec3, a);
        if (len(tmpvec3) < 0.000001)
          cross(tmpvec3, yUnitVec3, a);
        normalize(tmpvec3, tmpvec3);
        setAxisAngle(out, tmpvec3, Math.PI);
        return out;
      } else if (dot$$1 > 0.999999) {
        out[0] = 0;
        out[1] = 0;
        out[2] = 0;
        out[3] = 1;
        return out;
      } else {
        cross(tmpvec3, a, b);
        out[0] = tmpvec3[0];
        out[1] = tmpvec3[1];
        out[2] = tmpvec3[2];
        out[3] = 1 + dot$$1;
        return normalize$2(out, out);
      }
    };
  })();
  const sqlerp = (function () {
    let temp1 = create$4();
    let temp2 = create$4();
    return function (out, a, b, c, d, t) {
      slerp(temp1, a, d, t);
      slerp(temp2, b, c, t);
      slerp(out, temp1, temp2, 2 * t * (1 - t));
      return out;
    };
  }());
  const setAxes = (function() {
    let matr = create$2();
    return function(out, view, right, up) {
      matr[0] = right[0];
      matr[3] = right[1];
      matr[6] = right[2];
      matr[1] = up[0];
      matr[4] = up[1];
      matr[7] = up[2];
      matr[2] = -view[0];
      matr[5] = -view[1];
      matr[8] = -view[2];
      return normalize$2(out, fromMat3(out, matr));
    };
  })();

  const PRIVATE$1 = Symbol('@@webxr-polyfill/XRRigidTransform');
  class XRRigidTransform$1 {
    constructor() {
      this[PRIVATE$1] = {
        matrix: null,
        position: null,
        orientation: null,
        inverse: null,
      };
      if (arguments.length === 0) {
        this[PRIVATE$1].matrix = identity(new Float32Array(16));
      } else if (arguments.length === 1) {
        if (arguments[0] instanceof Float32Array) {
          this[PRIVATE$1].matrix = arguments[0];
        } else {
          this[PRIVATE$1].position = this._getPoint(arguments[0]);
          this[PRIVATE$1].orientation = DOMPointReadOnly.fromPoint({
              x: 0, y: 0, z: 0, w: 1
          });
        }
      } else if (arguments.length === 2) {
        this[PRIVATE$1].position = this._getPoint(arguments[0]);
        this[PRIVATE$1].orientation = this._getPoint(arguments[1]);
      } else {
        throw new Error("Too many arguments!");
      }
      if (this[PRIVATE$1].matrix) {
          let position = create$1();
          getTranslation(position, this[PRIVATE$1].matrix);
          this[PRIVATE$1].position = DOMPointReadOnly.fromPoint({
              x: position[0],
              y: position[1],
              z: position[2]
          });
          let orientation = create$4();
          getRotation(orientation, this[PRIVATE$1].matrix);
          this[PRIVATE$1].orientation = DOMPointReadOnly.fromPoint({
            x: orientation[0],
            y: orientation[1],
            z: orientation[2],
            w: orientation[3]
          });
      } else {
          this[PRIVATE$1].matrix = identity(new Float32Array(16));
          fromRotationTranslation(
            this[PRIVATE$1].matrix,
            fromValues$4(
              this[PRIVATE$1].orientation.x,
              this[PRIVATE$1].orientation.y,
              this[PRIVATE$1].orientation.z,
              this[PRIVATE$1].orientation.w),
            fromValues$1(
              this[PRIVATE$1].position.x,
              this[PRIVATE$1].position.y,
              this[PRIVATE$1].position.z)
          );
      }
    }
    _getPoint(arg) {
      if (arg instanceof DOMPointReadOnly) {
        return arg;
      }
      return DOMPointReadOnly.fromPoint(arg);
    }
    get matrix() { return this[PRIVATE$1].matrix; }
    get position() { return this[PRIVATE$1].position; }
    get orientation() { return this[PRIVATE$1].orientation; }
    get inverse() {
      if (this[PRIVATE$1].inverse === null) {
        let invMatrix = identity(new Float32Array(16));
        invert(invMatrix, this[PRIVATE$1].matrix);
        this[PRIVATE$1].inverse = new XRRigidTransform$1(invMatrix);
        this[PRIVATE$1].inverse[PRIVATE$1].inverse = this;
      }
      return this[PRIVATE$1].inverse;
    }
  }

  const PRIVATE$2 = Symbol('@@webxr-polyfill/XRSpace');

  class XRSpace {
    constructor(specialType = null, inputSource = null) {
      this[PRIVATE$2] = {
        specialType,
        inputSource,
        baseMatrix: null,
        inverseBaseMatrix: null,
        lastFrameId: -1
      };
    }
    get _specialType() {
      return this[PRIVATE$2].specialType;
    }
    get _inputSource() {
      return this[PRIVATE$2].inputSource;
    }
    _ensurePoseUpdated(device, frameId) {
      if (frameId == this[PRIVATE$2].lastFrameId) return;
      this[PRIVATE$2].lastFrameId = frameId;
      this._onPoseUpdate(device);
    }
    _onPoseUpdate(device) {
      if (this[PRIVATE$2].specialType == 'viewer') {
        this._baseMatrix = device.getBasePoseMatrix();
      }
    }
    set _baseMatrix(matrix) {
      this[PRIVATE$2].baseMatrix = matrix;
      this[PRIVATE$2].inverseBaseMatrix = null;
    }
    get _baseMatrix() {
      if (!this[PRIVATE$2].baseMatrix) {
        if (this[PRIVATE$2].inverseBaseMatrix) {
          this[PRIVATE$2].baseMatrix = new Float32Array(16);
          invert(this[PRIVATE$2].baseMatrix, this[PRIVATE$2].inverseBaseMatrix);
        }
      }
      return this[PRIVATE$2].baseMatrix;
    }
    set _inverseBaseMatrix(matrix) {
      this[PRIVATE$2].inverseBaseMatrix = matrix;
      this[PRIVATE$2].baseMatrix = null;
    }
    get _inverseBaseMatrix() {
      if (!this[PRIVATE$2].inverseBaseMatrix) {
        if (this[PRIVATE$2].baseMatrix) {
          this[PRIVATE$2].inverseBaseMatrix = new Float32Array(16);
          invert(this[PRIVATE$2].inverseBaseMatrix, this[PRIVATE$2].baseMatrix);
        }
      }
      return this[PRIVATE$2].inverseBaseMatrix;
    }
    _getSpaceRelativeTransform(space) {
      if (!this._inverseBaseMatrix || !space._baseMatrix) {
        return null;
      }
      let out = new Float32Array(16);
      multiply$1(out, this._inverseBaseMatrix, space._baseMatrix);
      return new XRRigidTransform$1(out);
    }
  }

  const DEFAULT_EMULATION_HEIGHT = 1.6;
  const PRIVATE$3 = Symbol('@@webxr-polyfill/XRReferenceSpace');
  const XRReferenceSpaceTypes = [
    'viewer',
    'local',
    'local-floor',
    'bounded-floor',
    'unbounded'
  ];
  function isFloor(type) {
    return type === 'bounded-floor' || type === 'local-floor';
  }
  class XRReferenceSpace extends XRSpace {
    constructor(type, transform = null) {
      if (!XRReferenceSpaceTypes.includes(type)) {
        throw new Error(`XRReferenceSpaceType must be one of ${XRReferenceSpaceTypes}`);
      }
      super(type);
      if (type === 'bounded-floor' && !transform) {
        throw new Error(`XRReferenceSpace cannot use 'bounded-floor' type if the platform does not provide the floor level`);
      }
      if (isFloor(type) && !transform) {
        transform = identity(new Float32Array(16));
        transform[13] = DEFAULT_EMULATION_HEIGHT;
      }
      this._inverseBaseMatrix = transform || identity(new Float32Array(16));
      this[PRIVATE$3] = {
        type,
        transform,
        originOffset : identity(new Float32Array(16)),
      };
    }
    _transformBasePoseMatrix(out, pose) {
      multiply$1(out, this._inverseBaseMatrix, pose);
    }
    _originOffsetMatrix() {
      return this[PRIVATE$3].originOffset;
    }
    _adjustForOriginOffset(transformMatrix) {
      let inverseOriginOffsetMatrix = new Float32Array(16);
      invert(inverseOriginOffsetMatrix, this[PRIVATE$3].originOffset);
      multiply$1(transformMatrix, inverseOriginOffsetMatrix, transformMatrix);
    }
    _getSpaceRelativeTransform(space) {
      let transform = super._getSpaceRelativeTransform(space);
      this._adjustForOriginOffset(transform.matrix);
      return new XRRigidTransform(transform.matrix);
    }
    getOffsetReferenceSpace(additionalOffset) {
      let newSpace = new XRReferenceSpace(
        this[PRIVATE$3].type,
        this[PRIVATE$3].transform,
        this[PRIVATE$3].bounds);
      multiply$1(newSpace[PRIVATE$3].originOffset, this[PRIVATE$3].originOffset, additionalOffset.matrix);
      return newSpace;
    }
  }

  const PRIVATE$4 = Symbol('@@webxr-polyfill/XR');
  const XRSessionModes = ['inline', 'immersive-vr', 'immersive-ar'];
  const DEFAULT_SESSION_OPTIONS = {
    'inline': {
      requiredFeatures: ['viewer'],
      optionalFeatures: [],
    },
    'immersive-vr': {
      requiredFeatures: ['viewer', 'local'],
      optionalFeatures: [],
    },
    'immersive-ar': {
      requiredFeatures: ['viewer', 'local'],
      optionalFeatures: [],
    }
  };
  const POLYFILL_REQUEST_SESSION_ERROR =
`Polyfill Error: Must call navigator.xr.isSessionSupported() with any XRSessionMode
or navigator.xr.requestSession('inline') prior to requesting an immersive
session. This is a limitation specific to the WebXR Polyfill and does not apply
to native implementations of the API.`  ;
  class XRSystem extends EventTarget {
    constructor(devicePromise) {
      super();
      this[PRIVATE$4] = {
        device: null,
        devicePromise,
        immersiveSession: null,
        inlineSessions: new Set(),
      };
      devicePromise.then((device) => { this[PRIVATE$4].device = device; });
    }
    async isSessionSupported(mode) {
      if (!this[PRIVATE$4].device) {
        await this[PRIVATE$4].devicePromise;
      }
      if (mode != 'inline') {
        return Promise.resolve(this[PRIVATE$4].device.isSessionSupported(mode));
      }
      return Promise.resolve(true);
    }
    async requestSession(mode, options) {
      if (!this[PRIVATE$4].device) {
        if (mode != 'inline') {
          throw new Error(POLYFILL_REQUEST_SESSION_ERROR);
        } else {
          await this[PRIVATE$4].devicePromise;
        }
      }
      if (!XRSessionModes.includes(mode)) {
        throw new TypeError(
            `The provided value '${mode}' is not a valid enum value of type XRSessionMode`);
      }
      const defaultOptions = DEFAULT_SESSION_OPTIONS[mode];
      const requiredFeatures = defaultOptions.requiredFeatures.concat(
          options && options.requiredFeatures ? options.requiredFeatures : []);
      const optionalFeatures = defaultOptions.optionalFeatures.concat(
          options && options.optionalFeatures ? options.optionalFeatures : []);
      const enabledFeatures = new Set();
      let requirementsFailed = false;
      for (let feature of requiredFeatures) {
        if (!this[PRIVATE$4].device.isFeatureSupported(feature)) {
          console.error(`The required feature '${feature}' is not supported`);
          requirementsFailed = true;
        } else {
          enabledFeatures.add(feature);
        }
      }
      if (requirementsFailed) {
        throw new DOMException('Session does not support some required features', 'NotSupportedError');
      }
      for (let feature of optionalFeatures) {
        if (!this[PRIVATE$4].device.isFeatureSupported(feature)) {
          console.log(`The optional feature '${feature}' is not supported`);
        } else {
          enabledFeatures.add(feature);
        }
      }
      const sessionId = await this[PRIVATE$4].device.requestSession(mode, enabledFeatures);
      const session = new XRSession(this[PRIVATE$4].device, mode, sessionId);
      if (mode == 'inline') {
        this[PRIVATE$4].inlineSessions.add(session);
      } else {
        this[PRIVATE$4].immersiveSession = session;
      }
      const onSessionEnd = () => {
        if (mode == 'inline') {
          this[PRIVATE$4].inlineSessions.delete(session);
        } else {
          this[PRIVATE$4].immersiveSession = null;
        }
        session.removeEventListener('end', onSessionEnd);
      };
      session.addEventListener('end', onSessionEnd);
      return session;
    }
  }

  let now;
  if ('performance' in _global$1 === false) {
    let startTime = Date.now();
    now = () => Date.now() - startTime;
  } else {
    now = () => performance.now();
  }
  var now$1 = now;

  const PRIVATE$5 = Symbol('@@webxr-polyfill/XRPose');
  class XRPose$1 {
    constructor(transform, emulatedPosition) {
      this[PRIVATE$5] = {
        transform,
        emulatedPosition,
      };
    }
    get transform() { return this[PRIVATE$5].transform; }
    get emulatedPosition() { return this[PRIVATE$5].emulatedPosition; }
  }

  const PRIVATE$6 = Symbol('@@webxr-polyfill/XRViewerPose');
  class XRViewerPose extends XRPose$1 {
    constructor(transform, views, emulatedPosition = false) {
      super(transform, emulatedPosition);
      this[PRIVATE$6] = {
        views
      };
    }
    get views() {
      return this[PRIVATE$6].views;
    }
  }

  const PRIVATE$7 = Symbol('@@webxr-polyfill/XRViewport');
  class XRViewport {
    constructor(target) {
      this[PRIVATE$7] = { target };
    }
    get x() { return this[PRIVATE$7].target.x; }
    get y() { return this[PRIVATE$7].target.y; }
    get width() { return this[PRIVATE$7].target.width; }
    get height() { return this[PRIVATE$7].target.height; }
  }

  const XREyes = ['left', 'right', 'none'];
  const PRIVATE$8 = Symbol('@@webxr-polyfill/XRView');
  class XRView {
    constructor(device, transform, eye, sessionId) {
      if (!XREyes.includes(eye)) {
        throw new Error(`XREye must be one of: ${XREyes}`);
      }
      const temp = Object.create(null);
      const viewport = new XRViewport(temp);
      this[PRIVATE$8] = {
        device,
        eye,
        viewport,
        temp,
        sessionId,
        transform,
      };
    }
    get eye() { return this[PRIVATE$8].eye; }
    get projectionMatrix() { return this[PRIVATE$8].device.getProjectionMatrix(this.eye); }
    get transform() { return this[PRIVATE$8].transform; }
    _getViewport(layer) {
      if (this[PRIVATE$8].device.getViewport(this[PRIVATE$8].sessionId,
                                             this.eye,
                                             layer,
                                             this[PRIVATE$8].temp)) {
        return this[PRIVATE$8].viewport;
      }
      return undefined;
    }
  }

  const PRIVATE$9 = Symbol('@@webxr-polyfill/XRFrame');
  const NON_ACTIVE_MSG = "XRFrame access outside the callback that produced it is invalid.";
  const NON_ANIMFRAME_MSG = "getViewerPose can only be called on XRFrame objects passed to XRSession.requestAnimationFrame callbacks.";
  let NEXT_FRAME_ID = 0;
  class XRFrame {
    constructor(device, session, sessionId) {
      this[PRIVATE$9] = {
        id: ++NEXT_FRAME_ID,
        active: false,
        animationFrame: false,
        device,
        session,
        sessionId
      };
    }
    get session() { return this[PRIVATE$9].session; }
    getViewerPose(referenceSpace) {
      if (!this[PRIVATE$9].animationFrame) {
        throw new DOMException(NON_ANIMFRAME_MSG, 'InvalidStateError');
      }
      if (!this[PRIVATE$9].active) {
        throw new DOMException(NON_ACTIVE_MSG, 'InvalidStateError');
      }
      const device = this[PRIVATE$9].device;
      const session = this[PRIVATE$9].session;
      session[PRIVATE$15].viewerSpace._ensurePoseUpdated(device, this[PRIVATE$9].id);
      referenceSpace._ensurePoseUpdated(device, this[PRIVATE$9].id);
      let viewerTransform = referenceSpace._getSpaceRelativeTransform(session[PRIVATE$15].viewerSpace);
      const views = [];
      for (let viewSpace of session[PRIVATE$15].viewSpaces) {
        viewSpace._ensurePoseUpdated(device, this[PRIVATE$9].id);
        let viewTransform = referenceSpace._getSpaceRelativeTransform(viewSpace);
        let view = new XRView(device, viewTransform, viewSpace.eye, this[PRIVATE$9].sessionId);
        views.push(view);
      }
      let viewerPose = new XRViewerPose(viewerTransform, views, false                             );
      return viewerPose;
    }
    getPose(space, baseSpace) {
      if (!this[PRIVATE$9].active) {
        throw new DOMException(NON_ACTIVE_MSG, 'InvalidStateError');
      }
      const device = this[PRIVATE$9].device;
      if (space._specialType === "target-ray" || space._specialType === "grip") {
        return device.getInputPose(
          space._inputSource, baseSpace, space._specialType);
      } else {
        space._ensurePoseUpdated(device, this[PRIVATE$9].id);
        baseSpace._ensurePoseUpdated(device, this[PRIVATE$9].id);
        let transform = baseSpace._getSpaceRelativeTransform(space);
        if (!transform) { return null; }
        return new XRPose(transform, false                             );
      }
    }
  }

  const PRIVATE$10 = Symbol('@@webxr-polyfill/XRRenderState');
  const XRRenderStateInit = Object.freeze({
    depthNear: 0.1,
    depthFar: 1000.0,
    inlineVerticalFieldOfView: null,
    baseLayer: null
  });
  class XRRenderState {
    constructor(stateInit = {}) {
      const config = Object.assign({}, XRRenderStateInit, stateInit);
      this[PRIVATE$10] = { config };
    }
    get depthNear() { return this[PRIVATE$10].config.depthNear; }
    get depthFar() { return this[PRIVATE$10].config.depthFar; }
    get inlineVerticalFieldOfView() { return this[PRIVATE$10].config.inlineVerticalFieldOfView; }
    get baseLayer() { return this[PRIVATE$10].config.baseLayer; }
  }

  const POLYFILLED_XR_COMPATIBLE = Symbol('@@webxr-polyfill/polyfilled-xr-compatible');
  const XR_COMPATIBLE = Symbol('@@webxr-polyfill/xr-compatible');

  const PRIVATE$11 = Symbol('@@webxr-polyfill/XRWebGLLayer');
  const XRWebGLLayerInit = Object.freeze({
    antialias: true,
    depth: false,
    stencil: false,
    alpha: true,
    multiview: false,
    ignoreDepthValues: false,
    framebufferScaleFactor: 1.0,
  });
  class XRWebGLLayer$1 {
    constructor(session, context, layerInit={}) {
      const config = Object.assign({}, XRWebGLLayerInit, layerInit);
      if (!(session instanceof XRSession$1)) {
        throw new Error('session must be a XRSession');
      }
      if (session.ended) {
        throw new Error(`InvalidStateError`);
      }
      if (context[POLYFILLED_XR_COMPATIBLE]) {
        if (context[XR_COMPATIBLE] !== true) {
          throw new Error(`InvalidStateError`);
        }
      }
      const framebuffer = context.getParameter(context.FRAMEBUFFER_BINDING);
      this[PRIVATE$11] = {
        context,
        config,
        framebuffer,
        session,
      };
    }
    get context() { return this[PRIVATE$11].context; }
    get antialias() { return this[PRIVATE$11].config.antialias; }
    get ignoreDepthValues() { return true; }
    get framebuffer() { return this[PRIVATE$11].framebuffer; }
    get framebufferWidth() { return this[PRIVATE$11].context.drawingBufferWidth; }
    get framebufferHeight() { return this[PRIVATE$11].context.drawingBufferHeight; }
    get _session() { return this[PRIVATE$11].session; }
    getViewport(view) {
      return view._getViewport(this);
    }
    static getNativeFramebufferScaleFactor(session) {
      if (!session) {
        throw new TypeError('getNativeFramebufferScaleFactor must be passed a session.')
      }
      if (session[PRIVATE$15].ended) { return 0.0; }
      return 1.0;
    }
  }

  const PRIVATE$12 = Symbol('@@webxr-polyfill/XRInputSourceEvent');
  class XRInputSourceEvent extends Event {
    constructor(type, eventInitDict) {
      super(type, eventInitDict);
      this[PRIVATE$12] = {
        frame: eventInitDict.frame,
        inputSource: eventInitDict.inputSource
      };
      Object.setPrototypeOf(this, XRInputSourceEvent.prototype);
    }
    get frame() { return this[PRIVATE$12].frame; }
    get inputSource() { return this[PRIVATE$12].inputSource; }
  }

  const PRIVATE$13 = Symbol('@@webxr-polyfill/XRSessionEvent');
  class XRSessionEvent extends Event {
    constructor(type, eventInitDict) {
      super(type, eventInitDict);
      this[PRIVATE$13] = {
        session: eventInitDict.session
      };
      Object.setPrototypeOf(this, XRSessionEvent.prototype);
    }
    get session() { return this[PRIVATE$13].session; }
  }

  const PRIVATE$14 = Symbol('@@webxr-polyfill/XRInputSourcesChangeEvent');
  class XRInputSourcesChangeEvent extends Event {
    constructor(type, eventInitDict) {
      super(type, eventInitDict);
      this[PRIVATE$14] = {
        session: eventInitDict.session,
        added: eventInitDict.added,
        removed: eventInitDict.removed
      };
      Object.setPrototypeOf(this, XRInputSourcesChangeEvent.prototype);
    }
    get session() { return this[PRIVATE$14].session; }
    get added() { return this[PRIVATE$14].added; }
    get removed() { return this[PRIVATE$14].removed; }
  }

  const PRIVATE$15 = Symbol('@@webxr-polyfill/XRSession');
  class XRViewSpace extends XRSpace {
    constructor(eye) {
      super(eye);
    }
    get eye() {
      return this._specialType;
    }
    _onPoseUpdate(device) {
      this._inverseBaseMatrix = device.getBaseViewMatrix(this._specialType);
    }
  }
  class XRSession$1 extends EventTarget {
    constructor(device, mode, id) {
      super();
      let immersive = mode != 'inline';
      let initialRenderState = new XRRenderState({
        inlineVerticalFieldOfView: immersive ? null : Math.PI * 0.5
      });
      this[PRIVATE$15] = {
        device,
        mode,
        immersive,
        ended: false,
        suspended: false,
        frameCallbacks: [],
        currentFrameCallbacks: null,
        frameHandle: 0,
        deviceFrameHandle: null,
        id,
        activeRenderState: initialRenderState,
        pendingRenderState: null,
        viewerSpace: new XRReferenceSpace("viewer"),
        viewSpaces: [],
        currentInputSources: []
      };
      if (immersive) {
        this[PRIVATE$15].viewSpaces.push(new XRViewSpace('left'),
                                      new XRViewSpace('right'));
      } else {
        this[PRIVATE$15].viewSpaces.push(new XRViewSpace('none'));
      }
      this[PRIVATE$15].onDeviceFrame = () => {
        if (this[PRIVATE$15].ended || this[PRIVATE$15].suspended) {
          return;
        }
        this[PRIVATE$15].deviceFrameHandle = null;
        this[PRIVATE$15].startDeviceFrameLoop();
        if (this[PRIVATE$15].pendingRenderState !== null) {
          this[PRIVATE$15].activeRenderState = new XRRenderState(this[PRIVATE$15].pendingRenderState);
          this[PRIVATE$15].pendingRenderState = null;
          if (this[PRIVATE$15].activeRenderState.baseLayer) {
            this[PRIVATE$15].device.onBaseLayerSet(
              this[PRIVATE$15].id,
              this[PRIVATE$15].activeRenderState.baseLayer);
          }
        }
        if (this[PRIVATE$15].activeRenderState.baseLayer === null) {
          return;
        }
        const frame = new XRFrame(device, this, this[PRIVATE$15].id);
        const callbacks = this[PRIVATE$15].currentFrameCallbacks = this[PRIVATE$15].frameCallbacks;
        this[PRIVATE$15].frameCallbacks = [];
        frame[PRIVATE$9].active = true;
        frame[PRIVATE$9].animationFrame = true;
        this[PRIVATE$15].device.onFrameStart(this[PRIVATE$15].id, this[PRIVATE$15].activeRenderState);
        this._checkInputSourcesChange();
        const rightNow = now$1();
        for (let i = 0; i < callbacks.length; i++) {
          try {
            if (!callbacks[i].cancelled && typeof callbacks[i].callback === 'function') {
              callbacks[i].callback(rightNow, frame);
            }
          } catch(err) {
            console.error(err);
          }
        }
        this[PRIVATE$15].currentFrameCallbacks = null;
        frame[PRIVATE$9].active = false;
        this[PRIVATE$15].device.onFrameEnd(this[PRIVATE$15].id);
      };
      this[PRIVATE$15].startDeviceFrameLoop = () => {
        if (this[PRIVATE$15].deviceFrameHandle === null) {
          this[PRIVATE$15].deviceFrameHandle = this[PRIVATE$15].device.requestAnimationFrame(
            this[PRIVATE$15].onDeviceFrame
          );
        }
      };
      this[PRIVATE$15].stopDeviceFrameLoop = () => {
        const handle = this[PRIVATE$15].deviceFrameHandle;
        if (handle !== null) {
          this[PRIVATE$15].device.cancelAnimationFrame(handle);
          this[PRIVATE$15].deviceFrameHandle = null;
        }
      };
      this[PRIVATE$15].onPresentationEnd = sessionId => {
        if (sessionId !== this[PRIVATE$15].id) {
          this[PRIVATE$15].suspended = false;
          this[PRIVATE$15].startDeviceFrameLoop();
          this.dispatchEvent('focus', { session: this });
          return;
        }
        this[PRIVATE$15].ended = true;
        this[PRIVATE$15].stopDeviceFrameLoop();
        device.removeEventListener('@@webxr-polyfill/vr-present-end', this[PRIVATE$15].onPresentationEnd);
        device.removeEventListener('@@webxr-polyfill/vr-present-start', this[PRIVATE$15].onPresentationStart);
        device.removeEventListener('@@webxr-polyfill/input-select-start', this[PRIVATE$15].onSelectStart);
        device.removeEventListener('@@webxr-polyfill/input-select-end', this[PRIVATE$15].onSelectEnd);
        this.dispatchEvent('end', new XRSessionEvent('end', { session: this }));
      };
      device.addEventListener('@@webxr-polyfill/vr-present-end', this[PRIVATE$15].onPresentationEnd);
      this[PRIVATE$15].onPresentationStart = sessionId => {
        if (sessionId === this[PRIVATE$15].id) {
          return;
        }
        this[PRIVATE$15].suspended = true;
        this[PRIVATE$15].stopDeviceFrameLoop();
        this.dispatchEvent('blur', { session: this });
      };
      device.addEventListener('@@webxr-polyfill/vr-present-start', this[PRIVATE$15].onPresentationStart);
      this[PRIVATE$15].onSelectStart = evt => {
        if (evt.sessionId !== this[PRIVATE$15].id) {
          return;
        }
        this[PRIVATE$15].dispatchInputSourceEvent('selectstart',  evt.inputSource);
      };
      device.addEventListener('@@webxr-polyfill/input-select-start', this[PRIVATE$15].onSelectStart);
      this[PRIVATE$15].onSelectEnd = evt => {
        if (evt.sessionId !== this[PRIVATE$15].id) {
          return;
        }
        this[PRIVATE$15].dispatchInputSourceEvent('selectend',  evt.inputSource);
        this[PRIVATE$15].dispatchInputSourceEvent('select',  evt.inputSource);
      };
      device.addEventListener('@@webxr-polyfill/input-select-end', this[PRIVATE$15].onSelectEnd);
      this[PRIVATE$15].onSqueezeStart = evt => {
        if (evt.sessionId !== this[PRIVATE$15].id) {
          return;
        }
        this[PRIVATE$15].dispatchInputSourceEvent('squeezestart',  evt.inputSource);
      };
      device.addEventListener('@@webxr-polyfill/input-squeeze-start', this[PRIVATE$15].onSqueezeStart);
      this[PRIVATE$15].onSqueezeEnd = evt => {
        if (evt.sessionId !== this[PRIVATE$15].id) {
          return;
        }
        this[PRIVATE$15].dispatchInputSourceEvent('squeezeend',  evt.inputSource);
        this[PRIVATE$15].dispatchInputSourceEvent('squeeze',  evt.inputSource);
      };
      device.addEventListener('@@webxr-polyfill/input-squeeze-end', this[PRIVATE$15].onSqueezeEnd);
      this[PRIVATE$15].dispatchInputSourceEvent = (type, inputSource) => {
        const frame = new XRFrame(device, this, this[PRIVATE$15].id);
        const event = new XRInputSourceEvent(type, { frame, inputSource });
        frame[PRIVATE$9].active = true;
        this.dispatchEvent(type, event);
        frame[PRIVATE$9].active = false;
      };
      this[PRIVATE$15].startDeviceFrameLoop();
      this.onblur = undefined;
      this.onfocus = undefined;
      this.onresetpose = undefined;
      this.onend = undefined;
      this.onselect = undefined;
      this.onselectstart = undefined;
      this.onselectend = undefined;
    }
    get renderState() { return this[PRIVATE$15].activeRenderState; }
    get environmentBlendMode() {
      return this[PRIVATE$15].device.environmentBlendMode || 'opaque';
    }
    async requestReferenceSpace(type) {
      if (this[PRIVATE$15].ended) {
        return;
      }
      if (!XRReferenceSpaceTypes.includes(type)) {
        throw new TypeError(`XRReferenceSpaceType must be one of ${XRReferenceSpaceTypes}`);
      }
      if (!this[PRIVATE$15].device.doesSessionSupportReferenceSpace(this[PRIVATE$15].id, type)) {
        throw new DOMException(`The ${type} reference space is not supported by this session.`, 'NotSupportedError');
      }
      if (type === 'viewer') {
        return this[PRIVATE$15].viewerSpace;
      }
      let transform = await this[PRIVATE$15].device.requestFrameOfReferenceTransform(type);
      if (type === 'bounded-floor') {
        if (!transform) {
          throw new DOMException(`${type} XRReferenceSpace not supported by this device.`, 'NotSupportedError');
        }
        let bounds = this[PRIVATE$15].device.requestStageBounds();
        if (!bounds) {
          throw new DOMException(`${type} XRReferenceSpace not supported by this device.`, 'NotSupportedError');
        }
        throw new DOMException(`The WebXR polyfill does not support the ${type} reference space yet.`, 'NotSupportedError');
      }
      return new XRReferenceSpace(type, transform);
    }
    requestAnimationFrame(callback) {
      if (this[PRIVATE$15].ended) {
        return;
      }
      const handle = ++this[PRIVATE$15].frameHandle;
      this[PRIVATE$15].frameCallbacks.push({
        handle,
        callback,
        cancelled: false
      });
      return handle;
    }
    cancelAnimationFrame(handle) {
      let callbacks = this[PRIVATE$15].frameCallbacks;
      let index = callbacks.findIndex(d => d && d.handle === handle);
      if (index > -1) {
        callbacks[index].cancelled = true;
        callbacks.splice(index, 1);
      }
      callbacks = this[PRIVATE$15].currentFrameCallbacks;
      if (callbacks) {
        index = callbacks.findIndex(d => d && d.handle === handle);
        if (index > -1) {
          callbacks[index].cancelled = true;
        }
      }
    }
    get inputSources() {
      return this[PRIVATE$15].device.getInputSources();
    }
    async end() {
      if (this[PRIVATE$15].ended) {
        return;
      }
      if (this[PRIVATE$15].immersive) {
        this[PRIVATE$15].ended = true;
        this[PRIVATE$15].device.removeEventListener('@@webxr-polyfill/vr-present-start',
                                                   this[PRIVATE$15].onPresentationStart);
        this[PRIVATE$15].device.removeEventListener('@@webxr-polyfill/vr-present-end',
                                                   this[PRIVATE$15].onPresentationEnd);
        this[PRIVATE$15].device.removeEventListener('@@webxr-polyfill/input-select-start',
                                                   this[PRIVATE$15].onSelectStart);
        this[PRIVATE$15].device.removeEventListener('@@webxr-polyfill/input-select-end',
                                                   this[PRIVATE$15].onSelectEnd);
        this.dispatchEvent('end', new XRSessionEvent('end', { session: this }));
      }
      this[PRIVATE$15].stopDeviceFrameLoop();
      return this[PRIVATE$15].device.endSession(this[PRIVATE$15].id);
    }
    updateRenderState(newState) {
      if (this[PRIVATE$15].ended) {
        const message = "Can't call updateRenderState on an XRSession " +
                        "that has already ended.";
        throw new Error(message);
      }
      if (newState.baseLayer && (newState.baseLayer._session !== this)) {
        const message = "Called updateRenderState with a base layer that was " +
                        "created by a different session.";
        throw new Error(message);
      }
      const fovSet = (newState.inlineVerticalFieldOfView !== null) &&
                     (newState.inlineVerticalFieldOfView !== undefined);
      if (fovSet) {
        if (this[PRIVATE$15].immersive) {
          const message = "inlineVerticalFieldOfView must not be set for an " +
                          "XRRenderState passed to updateRenderState for an " +
                          "immersive session.";
          throw new Error(message);
        } else {
          newState.inlineVerticalFieldOfView = Math.min(
            3.13, Math.max(0.01, newState.inlineVerticalFieldOfView));
        }
      }
      if (this[PRIVATE$15].pendingRenderState === null) {
        const activeRenderState = this[PRIVATE$15].activeRenderState;
        this[PRIVATE$15].pendingRenderState = {
          depthNear: activeRenderState.depthNear,
          depthFar: activeRenderState.depthFar,
          inlineVerticalFieldOfView: activeRenderState.inlineVerticalFieldOfView,
          baseLayer: activeRenderState.baseLayer
        };
      }
      Object.assign(this[PRIVATE$15].pendingRenderState, newState);
    }
    _checkInputSourcesChange() {
      const added = [];
      const removed = [];
      const newInputSources = this.inputSources;
      const oldInputSources = this[PRIVATE$15].currentInputSources;
      for (const newInputSource of newInputSources) {
        if (!oldInputSources.includes(newInputSource)) {
          added.push(newInputSource);
        }
      }
      for (const oldInputSource of oldInputSources) {
        if (!newInputSources.includes(oldInputSource)) {
          removed.push(oldInputSource);
        }
      }
      if (added.length > 0 || removed.length > 0) {
        this.dispatchEvent('inputsourceschange', new XRInputSourcesChangeEvent('inputsourceschange', {
          session: this,
          added: added,
          removed: removed
        }));
      }
      this[PRIVATE$15].currentInputSources.length = 0;
      for (const newInputSource of newInputSources) {
        this[PRIVATE$15].currentInputSources.push(newInputSource);
      }
    }
  }

  const PRIVATE$16 = Symbol('@@webxr-polyfill/XRInputSource');
  class XRInputSource {
    constructor(impl) {
      this[PRIVATE$16] = {
        impl,
        gripSpace: new XRSpace("grip", this),
        targetRaySpace: new XRSpace("target-ray", this)
      };
    }
    get handedness() { return this[PRIVATE$16].impl.handedness; }
    get targetRayMode() { return this[PRIVATE$16].impl.targetRayMode; }
    get gripSpace() {
      let mode = this[PRIVATE$16].impl.targetRayMode;
      if (mode === "gaze" || mode === "screen") {
        return null;
      }
      return this[PRIVATE$16].gripSpace;
    }
    get targetRaySpace() { return this[PRIVATE$16].targetRaySpace; }
    get profiles() { return this[PRIVATE$16].impl.profiles; }
    get gamepad() { return this[PRIVATE$16].impl.gamepad; }
  }

  const PRIVATE$17 = Symbol('@@webxr-polyfill/XRReferenceSpaceEvent');
  class XRReferenceSpaceEvent extends Event {
    constructor(type, eventInitDict) {
      super(type, eventInitDict);
      this[PRIVATE$17] = {
        referenceSpace: eventInitDict.referenceSpace,
        transform: eventInitDict.transform || null
      };
      Object.setPrototypeOf(this, XRReferenceSpaceEvent.prototype);
    }
    get referenceSpace() { return this[PRIVATE$17].referenceSpace; }
    get transform() { return this[PRIVATE$17].transform; }
  }

  var API = {
    XRSystem,
    XRSession: XRSession$1,
    XRSessionEvent,
    XRFrame,
    XRView,
    XRViewport,
    XRViewerPose,
    XRWebGLLayer: XRWebGLLayer$1,
    XRSpace,
    XRReferenceSpace,
    XRReferenceSpaceEvent,
    XRInputSource,
    XRInputSourceEvent,
    XRInputSourcesChangeEvent,
    XRRenderState,
    XRRigidTransform: XRRigidTransform$1,
    XRPose: XRPose$1,
  };

  const polyfillMakeXRCompatible = Context => {
    if (typeof Context.prototype.makeXRCompatible === 'function') {
      return false;
    }
    Context.prototype.makeXRCompatible = function () {
      this[XR_COMPATIBLE] = true;
      return Promise.resolve();
    };
    return true;
  };
  const polyfillGetContext = (Canvas) => {
    const getContext = Canvas.prototype.getContext;
    Canvas.prototype.getContext = function (contextType, glAttribs) {
      const ctx = getContext.call(this, contextType, glAttribs);
      if (ctx) {
        ctx[POLYFILLED_XR_COMPATIBLE] = true;
        if (glAttribs && ('xrCompatible' in glAttribs)) {
          ctx[XR_COMPATIBLE] = glAttribs.xrCompatible;
        }
      }
      return ctx;
    };
  };

  const isImageBitmapSupported = global =>
    !!(global.ImageBitmapRenderingContext &&
       global.createImageBitmap);
  const isMobile = global => {
    var check = false;
    (function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4)))check = true;})(global.navigator.userAgent||global.navigator.vendor||global.opera);
    return check;
  };
  const applyCanvasStylesForMinimalRendering = canvas => {
    canvas.style.display = 'block';
    canvas.style.position = 'absolute';
    canvas.style.width = canvas.style.height = '1px';
    canvas.style.top = canvas.style.left = '0px';
  };

  var commonjsGlobal$1 = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};



  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule$1(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var cardboardVrDisplay = createCommonjsModule$1(function (module, exports) {
  (function (global, factory) {
  	module.exports = factory();
  }(commonjsGlobal$1, (function () { var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };
  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();
  var slicedToArray = function () {
    function sliceIterator(arr, i) {
      var _arr = [];
      var _n = true;
      var _d = false;
      var _e = undefined;
      try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);
          if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"]) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }
      return _arr;
    }
    return function (arr, i) {
      if (Array.isArray(arr)) {
        return arr;
      } else if (Symbol.iterator in Object(arr)) {
        return sliceIterator(arr, i);
      } else {
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      }
    };
  }();
  var MIN_TIMESTEP = 0.001;
  var MAX_TIMESTEP = 1;
  var dataUri = function dataUri(mimeType, svg) {
    return 'data:' + mimeType + ',' + encodeURIComponent(svg);
  };
  var lerp = function lerp(a, b, t) {
    return a + (b - a) * t;
  };
  var isIOS = function () {
    var isIOS = /iPad|iPhone|iPod/.test(navigator.platform);
    return function () {
      return isIOS;
    };
  }();
  var isWebViewAndroid = function () {
    var isWebViewAndroid = navigator.userAgent.indexOf('Version') !== -1 && navigator.userAgent.indexOf('Android') !== -1 && navigator.userAgent.indexOf('Chrome') !== -1;
    return function () {
      return isWebViewAndroid;
    };
  }();
  var isSafari = function () {
    var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
    return function () {
      return isSafari;
    };
  }();
  var isFirefoxAndroid = function () {
    var isFirefoxAndroid = navigator.userAgent.indexOf('Firefox') !== -1 && navigator.userAgent.indexOf('Android') !== -1;
    return function () {
      return isFirefoxAndroid;
    };
  }();
  var getChromeVersion = function () {
    var match = navigator.userAgent.match(/.*Chrome\/([0-9]+)/);
    var value = match ? parseInt(match[1], 10) : null;
    return function () {
      return value;
    };
  }();
  var isSafariWithoutDeviceMotion = function () {
    var value = false;
    value = isIOS() && isSafari() && navigator.userAgent.indexOf('13_4') !== -1;
    return function () {
      return value;
    };
  }();
  var isChromeWithoutDeviceMotion = function () {
    var value = false;
    if (getChromeVersion() === 65) {
      var match = navigator.userAgent.match(/.*Chrome\/([0-9\.]*)/);
      if (match) {
        var _match$1$split = match[1].split('.'),
            _match$1$split2 = slicedToArray(_match$1$split, 4),
            major = _match$1$split2[0],
            minor = _match$1$split2[1],
            branch = _match$1$split2[2],
            build = _match$1$split2[3];
        value = parseInt(branch, 10) === 3325 && parseInt(build, 10) < 148;
      }
    }
    return function () {
      return value;
    };
  }();
  var isR7 = function () {
    var isR7 = navigator.userAgent.indexOf('R7 Build') !== -1;
    return function () {
      return isR7;
    };
  }();
  var isLandscapeMode = function isLandscapeMode() {
    var rtn = window.orientation == 90 || window.orientation == -90;
    return isR7() ? !rtn : rtn;
  };
  var isTimestampDeltaValid = function isTimestampDeltaValid(timestampDeltaS) {
    if (isNaN(timestampDeltaS)) {
      return false;
    }
    if (timestampDeltaS <= MIN_TIMESTEP) {
      return false;
    }
    if (timestampDeltaS > MAX_TIMESTEP) {
      return false;
    }
    return true;
  };
  var getScreenWidth = function getScreenWidth() {
    return Math.max(window.screen.width, window.screen.height) * window.devicePixelRatio;
  };
  var getScreenHeight = function getScreenHeight() {
    return Math.min(window.screen.width, window.screen.height) * window.devicePixelRatio;
  };
  var requestFullscreen = function requestFullscreen(element) {
    if (isWebViewAndroid()) {
      return false;
    }
    if (element.requestFullscreen) {
      element.requestFullscreen();
    } else if (element.webkitRequestFullscreen) {
      element.webkitRequestFullscreen();
    } else if (element.mozRequestFullScreen) {
      element.mozRequestFullScreen();
    } else if (element.msRequestFullscreen) {
      element.msRequestFullscreen();
    } else {
      return false;
    }
    return true;
  };
  var exitFullscreen = function exitFullscreen() {
    if (document.exitFullscreen) {
      document.exitFullscreen();
    } else if (document.webkitExitFullscreen) {
      document.webkitExitFullscreen();
    } else if (document.mozCancelFullScreen) {
      document.mozCancelFullScreen();
    } else if (document.msExitFullscreen) {
      document.msExitFullscreen();
    } else {
      return false;
    }
    return true;
  };
  var getFullscreenElement = function getFullscreenElement() {
    return document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement;
  };
  var linkProgram = function linkProgram(gl, vertexSource, fragmentSource, attribLocationMap) {
    var vertexShader = gl.createShader(gl.VERTEX_SHADER);
    gl.shaderSource(vertexShader, vertexSource);
    gl.compileShader(vertexShader);
    var fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);
    gl.shaderSource(fragmentShader, fragmentSource);
    gl.compileShader(fragmentShader);
    var program = gl.createProgram();
    gl.attachShader(program, vertexShader);
    gl.attachShader(program, fragmentShader);
    for (var attribName in attribLocationMap) {
      gl.bindAttribLocation(program, attribLocationMap[attribName], attribName);
    }gl.linkProgram(program);
    gl.deleteShader(vertexShader);
    gl.deleteShader(fragmentShader);
    return program;
  };
  var getProgramUniforms = function getProgramUniforms(gl, program) {
    var uniforms = {};
    var uniformCount = gl.getProgramParameter(program, gl.ACTIVE_UNIFORMS);
    var uniformName = '';
    for (var i = 0; i < uniformCount; i++) {
      var uniformInfo = gl.getActiveUniform(program, i);
      uniformName = uniformInfo.name.replace('[0]', '');
      uniforms[uniformName] = gl.getUniformLocation(program, uniformName);
    }
    return uniforms;
  };
  var orthoMatrix = function orthoMatrix(out, left, right, bottom, top, near, far) {
    var lr = 1 / (left - right),
        bt = 1 / (bottom - top),
        nf = 1 / (near - far);
    out[0] = -2 * lr;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = -2 * bt;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 2 * nf;
    out[11] = 0;
    out[12] = (left + right) * lr;
    out[13] = (top + bottom) * bt;
    out[14] = (far + near) * nf;
    out[15] = 1;
    return out;
  };
  var isMobile = function isMobile() {
    var check = false;
    (function (a) {
      if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) check = true;
    })(navigator.userAgent || navigator.vendor || window.opera);
    return check;
  };
  var extend = function extend(dest, src) {
    for (var key in src) {
      if (src.hasOwnProperty(key)) {
        dest[key] = src[key];
      }
    }
    return dest;
  };
  var safariCssSizeWorkaround = function safariCssSizeWorkaround(canvas) {
    if (isIOS()) {
      var width = canvas.style.width;
      var height = canvas.style.height;
      canvas.style.width = parseInt(width) + 1 + 'px';
      canvas.style.height = parseInt(height) + 'px';
      setTimeout(function () {
        canvas.style.width = width;
        canvas.style.height = height;
      }, 100);
    }
    window.canvas = canvas;
  };
  var frameDataFromPose = function () {
    var piOver180 = Math.PI / 180.0;
    var rad45 = Math.PI * 0.25;
    function mat4_perspectiveFromFieldOfView(out, fov, near, far) {
      var upTan = Math.tan(fov ? fov.upDegrees * piOver180 : rad45),
          downTan = Math.tan(fov ? fov.downDegrees * piOver180 : rad45),
          leftTan = Math.tan(fov ? fov.leftDegrees * piOver180 : rad45),
          rightTan = Math.tan(fov ? fov.rightDegrees * piOver180 : rad45),
          xScale = 2.0 / (leftTan + rightTan),
          yScale = 2.0 / (upTan + downTan);
      out[0] = xScale;
      out[1] = 0.0;
      out[2] = 0.0;
      out[3] = 0.0;
      out[4] = 0.0;
      out[5] = yScale;
      out[6] = 0.0;
      out[7] = 0.0;
      out[8] = -((leftTan - rightTan) * xScale * 0.5);
      out[9] = (upTan - downTan) * yScale * 0.5;
      out[10] = far / (near - far);
      out[11] = -1.0;
      out[12] = 0.0;
      out[13] = 0.0;
      out[14] = far * near / (near - far);
      out[15] = 0.0;
      return out;
    }
    function mat4_fromRotationTranslation(out, q, v) {
      var x = q[0],
          y = q[1],
          z = q[2],
          w = q[3],
          x2 = x + x,
          y2 = y + y,
          z2 = z + z,
          xx = x * x2,
          xy = x * y2,
          xz = x * z2,
          yy = y * y2,
          yz = y * z2,
          zz = z * z2,
          wx = w * x2,
          wy = w * y2,
          wz = w * z2;
      out[0] = 1 - (yy + zz);
      out[1] = xy + wz;
      out[2] = xz - wy;
      out[3] = 0;
      out[4] = xy - wz;
      out[5] = 1 - (xx + zz);
      out[6] = yz + wx;
      out[7] = 0;
      out[8] = xz + wy;
      out[9] = yz - wx;
      out[10] = 1 - (xx + yy);
      out[11] = 0;
      out[12] = v[0];
      out[13] = v[1];
      out[14] = v[2];
      out[15] = 1;
      return out;
    }
    function mat4_translate(out, a, v) {
      var x = v[0],
          y = v[1],
          z = v[2],
          a00,
          a01,
          a02,
          a03,
          a10,
          a11,
          a12,
          a13,
          a20,
          a21,
          a22,
          a23;
      if (a === out) {
        out[12] = a[0] * x + a[4] * y + a[8] * z + a[12];
        out[13] = a[1] * x + a[5] * y + a[9] * z + a[13];
        out[14] = a[2] * x + a[6] * y + a[10] * z + a[14];
        out[15] = a[3] * x + a[7] * y + a[11] * z + a[15];
      } else {
        a00 = a[0];a01 = a[1];a02 = a[2];a03 = a[3];
        a10 = a[4];a11 = a[5];a12 = a[6];a13 = a[7];
        a20 = a[8];a21 = a[9];a22 = a[10];a23 = a[11];
        out[0] = a00;out[1] = a01;out[2] = a02;out[3] = a03;
        out[4] = a10;out[5] = a11;out[6] = a12;out[7] = a13;
        out[8] = a20;out[9] = a21;out[10] = a22;out[11] = a23;
        out[12] = a00 * x + a10 * y + a20 * z + a[12];
        out[13] = a01 * x + a11 * y + a21 * z + a[13];
        out[14] = a02 * x + a12 * y + a22 * z + a[14];
        out[15] = a03 * x + a13 * y + a23 * z + a[15];
      }
      return out;
    }
    function mat4_invert(out, a) {
      var a00 = a[0],
          a01 = a[1],
          a02 = a[2],
          a03 = a[3],
          a10 = a[4],
          a11 = a[5],
          a12 = a[6],
          a13 = a[7],
          a20 = a[8],
          a21 = a[9],
          a22 = a[10],
          a23 = a[11],
          a30 = a[12],
          a31 = a[13],
          a32 = a[14],
          a33 = a[15],
          b00 = a00 * a11 - a01 * a10,
          b01 = a00 * a12 - a02 * a10,
          b02 = a00 * a13 - a03 * a10,
          b03 = a01 * a12 - a02 * a11,
          b04 = a01 * a13 - a03 * a11,
          b05 = a02 * a13 - a03 * a12,
          b06 = a20 * a31 - a21 * a30,
          b07 = a20 * a32 - a22 * a30,
          b08 = a20 * a33 - a23 * a30,
          b09 = a21 * a32 - a22 * a31,
          b10 = a21 * a33 - a23 * a31,
          b11 = a22 * a33 - a23 * a32,
      det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
      if (!det) {
        return null;
      }
      det = 1.0 / det;
      out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
      out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
      out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
      out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
      out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
      out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
      out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
      out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
      out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
      out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
      out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
      out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
      out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
      out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
      out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
      out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
      return out;
    }
    var defaultOrientation = new Float32Array([0, 0, 0, 1]);
    var defaultPosition = new Float32Array([0, 0, 0]);
    function updateEyeMatrices(projection, view, pose, fov, offset, vrDisplay) {
      mat4_perspectiveFromFieldOfView(projection, fov || null, vrDisplay.depthNear, vrDisplay.depthFar);
      var orientation = pose.orientation || defaultOrientation;
      var position = pose.position || defaultPosition;
      mat4_fromRotationTranslation(view, orientation, position);
      if (offset) mat4_translate(view, view, offset);
      mat4_invert(view, view);
    }
    return function (frameData, pose, vrDisplay) {
      if (!frameData || !pose) return false;
      frameData.pose = pose;
      frameData.timestamp = pose.timestamp;
      updateEyeMatrices(frameData.leftProjectionMatrix, frameData.leftViewMatrix, pose, vrDisplay._getFieldOfView("left"), vrDisplay._getEyeOffset("left"), vrDisplay);
      updateEyeMatrices(frameData.rightProjectionMatrix, frameData.rightViewMatrix, pose, vrDisplay._getFieldOfView("right"), vrDisplay._getEyeOffset("right"), vrDisplay);
      return true;
    };
  }();
  var isInsideCrossOriginIFrame = function isInsideCrossOriginIFrame() {
    var isFramed = window.self !== window.top;
    var refOrigin = getOriginFromUrl(document.referrer);
    var thisOrigin = getOriginFromUrl(window.location.href);
    return isFramed && refOrigin !== thisOrigin;
  };
  var getOriginFromUrl = function getOriginFromUrl(url) {
    var domainIdx;
    var protoSepIdx = url.indexOf("://");
    if (protoSepIdx !== -1) {
      domainIdx = protoSepIdx + 3;
    } else {
      domainIdx = 0;
    }
    var domainEndIdx = url.indexOf('/', domainIdx);
    if (domainEndIdx === -1) {
      domainEndIdx = url.length;
    }
    return url.substring(0, domainEndIdx);
  };
  var getQuaternionAngle = function getQuaternionAngle(quat) {
    if (quat.w > 1) {
      console.warn('getQuaternionAngle: w > 1');
      return 0;
    }
    var angle = 2 * Math.acos(quat.w);
    return angle;
  };
  var warnOnce = function () {
    var observedWarnings = {};
    return function (key, message) {
      if (observedWarnings[key] === undefined) {
        console.warn('webvr-polyfill: ' + message);
        observedWarnings[key] = true;
      }
    };
  }();
  var deprecateWarning = function deprecateWarning(deprecated, suggested) {
    var alternative = suggested ? 'Please use ' + suggested + ' instead.' : '';
    warnOnce(deprecated, deprecated + ' has been deprecated. ' + 'This may not work on native WebVR displays. ' + alternative);
  };
  function WGLUPreserveGLState(gl, bindings, callback) {
    if (!bindings) {
      callback(gl);
      return;
    }
    var boundValues = [];
    var activeTexture = null;
    for (var i = 0; i < bindings.length; ++i) {
      var binding = bindings[i];
      switch (binding) {
        case gl.TEXTURE_BINDING_2D:
        case gl.TEXTURE_BINDING_CUBE_MAP:
          var textureUnit = bindings[++i];
          if (textureUnit < gl.TEXTURE0 || textureUnit > gl.TEXTURE31) {
            console.error("TEXTURE_BINDING_2D or TEXTURE_BINDING_CUBE_MAP must be followed by a valid texture unit");
            boundValues.push(null, null);
            break;
          }
          if (!activeTexture) {
            activeTexture = gl.getParameter(gl.ACTIVE_TEXTURE);
          }
          gl.activeTexture(textureUnit);
          boundValues.push(gl.getParameter(binding), null);
          break;
        case gl.ACTIVE_TEXTURE:
          activeTexture = gl.getParameter(gl.ACTIVE_TEXTURE);
          boundValues.push(null);
          break;
        default:
          boundValues.push(gl.getParameter(binding));
          break;
      }
    }
    callback(gl);
    for (var i = 0; i < bindings.length; ++i) {
      var binding = bindings[i];
      var boundValue = boundValues[i];
      switch (binding) {
        case gl.ACTIVE_TEXTURE:
          break;
        case gl.ARRAY_BUFFER_BINDING:
          gl.bindBuffer(gl.ARRAY_BUFFER, boundValue);
          break;
        case gl.COLOR_CLEAR_VALUE:
          gl.clearColor(boundValue[0], boundValue[1], boundValue[2], boundValue[3]);
          break;
        case gl.COLOR_WRITEMASK:
          gl.colorMask(boundValue[0], boundValue[1], boundValue[2], boundValue[3]);
          break;
        case gl.CURRENT_PROGRAM:
          gl.useProgram(boundValue);
          break;
        case gl.ELEMENT_ARRAY_BUFFER_BINDING:
          gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, boundValue);
          break;
        case gl.FRAMEBUFFER_BINDING:
          gl.bindFramebuffer(gl.FRAMEBUFFER, boundValue);
          break;
        case gl.RENDERBUFFER_BINDING:
          gl.bindRenderbuffer(gl.RENDERBUFFER, boundValue);
          break;
        case gl.TEXTURE_BINDING_2D:
          var textureUnit = bindings[++i];
          if (textureUnit < gl.TEXTURE0 || textureUnit > gl.TEXTURE31)
            break;
          gl.activeTexture(textureUnit);
          gl.bindTexture(gl.TEXTURE_2D, boundValue);
          break;
        case gl.TEXTURE_BINDING_CUBE_MAP:
          var textureUnit = bindings[++i];
          if (textureUnit < gl.TEXTURE0 || textureUnit > gl.TEXTURE31)
            break;
          gl.activeTexture(textureUnit);
          gl.bindTexture(gl.TEXTURE_CUBE_MAP, boundValue);
          break;
        case gl.VIEWPORT:
          gl.viewport(boundValue[0], boundValue[1], boundValue[2], boundValue[3]);
          break;
        case gl.BLEND:
        case gl.CULL_FACE:
        case gl.DEPTH_TEST:
        case gl.SCISSOR_TEST:
        case gl.STENCIL_TEST:
          if (boundValue) {
            gl.enable(binding);
          } else {
            gl.disable(binding);
          }
          break;
        default:
          console.log("No GL restore behavior for 0x" + binding.toString(16));
          break;
      }
      if (activeTexture) {
        gl.activeTexture(activeTexture);
      }
    }
  }
  var glPreserveState = WGLUPreserveGLState;
  var distortionVS = ['attribute vec2 position;', 'attribute vec3 texCoord;', 'varying vec2 vTexCoord;', 'uniform vec4 viewportOffsetScale[2];', 'void main() {', '  vec4 viewport = viewportOffsetScale[int(texCoord.z)];', '  vTexCoord = (texCoord.xy * viewport.zw) + viewport.xy;', '  gl_Position = vec4( position, 1.0, 1.0 );', '}'].join('\n');
  var distortionFS = ['precision mediump float;', 'uniform sampler2D diffuse;', 'varying vec2 vTexCoord;', 'void main() {', '  gl_FragColor = texture2D(diffuse, vTexCoord);', '}'].join('\n');
  function CardboardDistorter(gl, cardboardUI, bufferScale, dirtySubmitFrameBindings) {
    this.gl = gl;
    this.cardboardUI = cardboardUI;
    this.bufferScale = bufferScale;
    this.dirtySubmitFrameBindings = dirtySubmitFrameBindings;
    this.ctxAttribs = gl.getContextAttributes();
    this.instanceExt = gl.getExtension('ANGLE_instanced_arrays');
    this.meshWidth = 20;
    this.meshHeight = 20;
    this.bufferWidth = gl.drawingBufferWidth;
    this.bufferHeight = gl.drawingBufferHeight;
    this.realBindFramebuffer = gl.bindFramebuffer;
    this.realEnable = gl.enable;
    this.realDisable = gl.disable;
    this.realColorMask = gl.colorMask;
    this.realClearColor = gl.clearColor;
    this.realViewport = gl.viewport;
    if (!isIOS()) {
      this.realCanvasWidth = Object.getOwnPropertyDescriptor(gl.canvas.__proto__, 'width');
      this.realCanvasHeight = Object.getOwnPropertyDescriptor(gl.canvas.__proto__, 'height');
    }
    this.isPatched = false;
    this.lastBoundFramebuffer = null;
    this.cullFace = false;
    this.depthTest = false;
    this.blend = false;
    this.scissorTest = false;
    this.stencilTest = false;
    this.viewport = [0, 0, 0, 0];
    this.colorMask = [true, true, true, true];
    this.clearColor = [0, 0, 0, 0];
    this.attribs = {
      position: 0,
      texCoord: 1
    };
    this.program = linkProgram(gl, distortionVS, distortionFS, this.attribs);
    this.uniforms = getProgramUniforms(gl, this.program);
    this.viewportOffsetScale = new Float32Array(8);
    this.setTextureBounds();
    this.vertexBuffer = gl.createBuffer();
    this.indexBuffer = gl.createBuffer();
    this.indexCount = 0;
    this.renderTarget = gl.createTexture();
    this.framebuffer = gl.createFramebuffer();
    this.depthStencilBuffer = null;
    this.depthBuffer = null;
    this.stencilBuffer = null;
    if (this.ctxAttribs.depth && this.ctxAttribs.stencil) {
      this.depthStencilBuffer = gl.createRenderbuffer();
    } else if (this.ctxAttribs.depth) {
      this.depthBuffer = gl.createRenderbuffer();
    } else if (this.ctxAttribs.stencil) {
      this.stencilBuffer = gl.createRenderbuffer();
    }
    this.patch();
    this.onResize();
  }
  CardboardDistorter.prototype.destroy = function () {
    var gl = this.gl;
    this.unpatch();
    gl.deleteProgram(this.program);
    gl.deleteBuffer(this.vertexBuffer);
    gl.deleteBuffer(this.indexBuffer);
    gl.deleteTexture(this.renderTarget);
    gl.deleteFramebuffer(this.framebuffer);
    if (this.depthStencilBuffer) {
      gl.deleteRenderbuffer(this.depthStencilBuffer);
    }
    if (this.depthBuffer) {
      gl.deleteRenderbuffer(this.depthBuffer);
    }
    if (this.stencilBuffer) {
      gl.deleteRenderbuffer(this.stencilBuffer);
    }
    if (this.cardboardUI) {
      this.cardboardUI.destroy();
    }
  };
  CardboardDistorter.prototype.onResize = function () {
    var gl = this.gl;
    var self = this;
    var glState = [gl.RENDERBUFFER_BINDING, gl.TEXTURE_BINDING_2D, gl.TEXTURE0];
    glPreserveState(gl, glState, function (gl) {
      self.realBindFramebuffer.call(gl, gl.FRAMEBUFFER, null);
      if (self.scissorTest) {
        self.realDisable.call(gl, gl.SCISSOR_TEST);
      }
      self.realColorMask.call(gl, true, true, true, true);
      self.realViewport.call(gl, 0, 0, gl.drawingBufferWidth, gl.drawingBufferHeight);
      self.realClearColor.call(gl, 0, 0, 0, 1);
      gl.clear(gl.COLOR_BUFFER_BIT);
      self.realBindFramebuffer.call(gl, gl.FRAMEBUFFER, self.framebuffer);
      gl.bindTexture(gl.TEXTURE_2D, self.renderTarget);
      gl.texImage2D(gl.TEXTURE_2D, 0, self.ctxAttribs.alpha ? gl.RGBA : gl.RGB, self.bufferWidth, self.bufferHeight, 0, self.ctxAttribs.alpha ? gl.RGBA : gl.RGB, gl.UNSIGNED_BYTE, null);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
      gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, self.renderTarget, 0);
      if (self.ctxAttribs.depth && self.ctxAttribs.stencil) {
        gl.bindRenderbuffer(gl.RENDERBUFFER, self.depthStencilBuffer);
        gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, self.bufferWidth, self.bufferHeight);
        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, self.depthStencilBuffer);
      } else if (self.ctxAttribs.depth) {
        gl.bindRenderbuffer(gl.RENDERBUFFER, self.depthBuffer);
        gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, self.bufferWidth, self.bufferHeight);
        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, self.depthBuffer);
      } else if (self.ctxAttribs.stencil) {
        gl.bindRenderbuffer(gl.RENDERBUFFER, self.stencilBuffer);
        gl.renderbufferStorage(gl.RENDERBUFFER, gl.STENCIL_INDEX8, self.bufferWidth, self.bufferHeight);
        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.STENCIL_ATTACHMENT, gl.RENDERBUFFER, self.stencilBuffer);
      }
      if (!gl.checkFramebufferStatus(gl.FRAMEBUFFER) === gl.FRAMEBUFFER_COMPLETE) {
        console.error('Framebuffer incomplete!');
      }
      self.realBindFramebuffer.call(gl, gl.FRAMEBUFFER, self.lastBoundFramebuffer);
      if (self.scissorTest) {
        self.realEnable.call(gl, gl.SCISSOR_TEST);
      }
      self.realColorMask.apply(gl, self.colorMask);
      self.realViewport.apply(gl, self.viewport);
      self.realClearColor.apply(gl, self.clearColor);
    });
    if (this.cardboardUI) {
      this.cardboardUI.onResize();
    }
  };
  CardboardDistorter.prototype.patch = function () {
    if (this.isPatched) {
      return;
    }
    var self = this;
    var canvas = this.gl.canvas;
    var gl = this.gl;
    if (!isIOS()) {
      canvas.width = getScreenWidth() * this.bufferScale;
      canvas.height = getScreenHeight() * this.bufferScale;
      Object.defineProperty(canvas, 'width', {
        configurable: true,
        enumerable: true,
        get: function get() {
          return self.bufferWidth;
        },
        set: function set(value) {
          self.bufferWidth = value;
          self.realCanvasWidth.set.call(canvas, value);
          self.onResize();
        }
      });
      Object.defineProperty(canvas, 'height', {
        configurable: true,
        enumerable: true,
        get: function get() {
          return self.bufferHeight;
        },
        set: function set(value) {
          self.bufferHeight = value;
          self.realCanvasHeight.set.call(canvas, value);
          self.onResize();
        }
      });
    }
    this.lastBoundFramebuffer = gl.getParameter(gl.FRAMEBUFFER_BINDING);
    if (this.lastBoundFramebuffer == null) {
      this.lastBoundFramebuffer = this.framebuffer;
      this.gl.bindFramebuffer(gl.FRAMEBUFFER, this.framebuffer);
    }
    this.gl.bindFramebuffer = function (target, framebuffer) {
      self.lastBoundFramebuffer = framebuffer ? framebuffer : self.framebuffer;
      self.realBindFramebuffer.call(gl, target, self.lastBoundFramebuffer);
    };
    this.cullFace = gl.getParameter(gl.CULL_FACE);
    this.depthTest = gl.getParameter(gl.DEPTH_TEST);
    this.blend = gl.getParameter(gl.BLEND);
    this.scissorTest = gl.getParameter(gl.SCISSOR_TEST);
    this.stencilTest = gl.getParameter(gl.STENCIL_TEST);
    gl.enable = function (pname) {
      switch (pname) {
        case gl.CULL_FACE:
          self.cullFace = true;break;
        case gl.DEPTH_TEST:
          self.depthTest = true;break;
        case gl.BLEND:
          self.blend = true;break;
        case gl.SCISSOR_TEST:
          self.scissorTest = true;break;
        case gl.STENCIL_TEST:
          self.stencilTest = true;break;
      }
      self.realEnable.call(gl, pname);
    };
    gl.disable = function (pname) {
      switch (pname) {
        case gl.CULL_FACE:
          self.cullFace = false;break;
        case gl.DEPTH_TEST:
          self.depthTest = false;break;
        case gl.BLEND:
          self.blend = false;break;
        case gl.SCISSOR_TEST:
          self.scissorTest = false;break;
        case gl.STENCIL_TEST:
          self.stencilTest = false;break;
      }
      self.realDisable.call(gl, pname);
    };
    this.colorMask = gl.getParameter(gl.COLOR_WRITEMASK);
    gl.colorMask = function (r, g, b, a) {
      self.colorMask[0] = r;
      self.colorMask[1] = g;
      self.colorMask[2] = b;
      self.colorMask[3] = a;
      self.realColorMask.call(gl, r, g, b, a);
    };
    this.clearColor = gl.getParameter(gl.COLOR_CLEAR_VALUE);
    gl.clearColor = function (r, g, b, a) {
      self.clearColor[0] = r;
      self.clearColor[1] = g;
      self.clearColor[2] = b;
      self.clearColor[3] = a;
      self.realClearColor.call(gl, r, g, b, a);
    };
    this.viewport = gl.getParameter(gl.VIEWPORT);
    gl.viewport = function (x, y, w, h) {
      self.viewport[0] = x;
      self.viewport[1] = y;
      self.viewport[2] = w;
      self.viewport[3] = h;
      self.realViewport.call(gl, x, y, w, h);
    };
    this.isPatched = true;
    safariCssSizeWorkaround(canvas);
  };
  CardboardDistorter.prototype.unpatch = function () {
    if (!this.isPatched) {
      return;
    }
    var gl = this.gl;
    var canvas = this.gl.canvas;
    if (!isIOS()) {
      Object.defineProperty(canvas, 'width', this.realCanvasWidth);
      Object.defineProperty(canvas, 'height', this.realCanvasHeight);
    }
    canvas.width = this.bufferWidth;
    canvas.height = this.bufferHeight;
    gl.bindFramebuffer = this.realBindFramebuffer;
    gl.enable = this.realEnable;
    gl.disable = this.realDisable;
    gl.colorMask = this.realColorMask;
    gl.clearColor = this.realClearColor;
    gl.viewport = this.realViewport;
    if (this.lastBoundFramebuffer == this.framebuffer) {
      gl.bindFramebuffer(gl.FRAMEBUFFER, null);
    }
    this.isPatched = false;
    setTimeout(function () {
      safariCssSizeWorkaround(canvas);
    }, 1);
  };
  CardboardDistorter.prototype.setTextureBounds = function (leftBounds, rightBounds) {
    if (!leftBounds) {
      leftBounds = [0, 0, 0.5, 1];
    }
    if (!rightBounds) {
      rightBounds = [0.5, 0, 0.5, 1];
    }
    this.viewportOffsetScale[0] = leftBounds[0];
    this.viewportOffsetScale[1] = leftBounds[1];
    this.viewportOffsetScale[2] = leftBounds[2];
    this.viewportOffsetScale[3] = leftBounds[3];
    this.viewportOffsetScale[4] = rightBounds[0];
    this.viewportOffsetScale[5] = rightBounds[1];
    this.viewportOffsetScale[6] = rightBounds[2];
    this.viewportOffsetScale[7] = rightBounds[3];
  };
  CardboardDistorter.prototype.submitFrame = function () {
    var gl = this.gl;
    var self = this;
    var glState = [];
    if (!this.dirtySubmitFrameBindings) {
      glState.push(gl.CURRENT_PROGRAM, gl.ARRAY_BUFFER_BINDING, gl.ELEMENT_ARRAY_BUFFER_BINDING, gl.TEXTURE_BINDING_2D, gl.TEXTURE0);
    }
    glPreserveState(gl, glState, function (gl) {
      self.realBindFramebuffer.call(gl, gl.FRAMEBUFFER, null);
      var positionDivisor = 0;
      var texCoordDivisor = 0;
      if (self.instanceExt) {
        positionDivisor = gl.getVertexAttrib(self.attribs.position, self.instanceExt.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE);
        texCoordDivisor = gl.getVertexAttrib(self.attribs.texCoord, self.instanceExt.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE);
      }
      if (self.cullFace) {
        self.realDisable.call(gl, gl.CULL_FACE);
      }
      if (self.depthTest) {
        self.realDisable.call(gl, gl.DEPTH_TEST);
      }
      if (self.blend) {
        self.realDisable.call(gl, gl.BLEND);
      }
      if (self.scissorTest) {
        self.realDisable.call(gl, gl.SCISSOR_TEST);
      }
      if (self.stencilTest) {
        self.realDisable.call(gl, gl.STENCIL_TEST);
      }
      self.realColorMask.call(gl, true, true, true, true);
      self.realViewport.call(gl, 0, 0, gl.drawingBufferWidth, gl.drawingBufferHeight);
      if (self.ctxAttribs.alpha || isIOS()) {
        self.realClearColor.call(gl, 0, 0, 0, 1);
        gl.clear(gl.COLOR_BUFFER_BIT);
      }
      gl.useProgram(self.program);
      gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, self.indexBuffer);
      gl.bindBuffer(gl.ARRAY_BUFFER, self.vertexBuffer);
      gl.enableVertexAttribArray(self.attribs.position);
      gl.enableVertexAttribArray(self.attribs.texCoord);
      gl.vertexAttribPointer(self.attribs.position, 2, gl.FLOAT, false, 20, 0);
      gl.vertexAttribPointer(self.attribs.texCoord, 3, gl.FLOAT, false, 20, 8);
      if (self.instanceExt) {
        if (positionDivisor != 0) {
          self.instanceExt.vertexAttribDivisorANGLE(self.attribs.position, 0);
        }
        if (texCoordDivisor != 0) {
          self.instanceExt.vertexAttribDivisorANGLE(self.attribs.texCoord, 0);
        }
      }
      gl.activeTexture(gl.TEXTURE0);
      gl.uniform1i(self.uniforms.diffuse, 0);
      gl.bindTexture(gl.TEXTURE_2D, self.renderTarget);
      gl.uniform4fv(self.uniforms.viewportOffsetScale, self.viewportOffsetScale);
      gl.drawElements(gl.TRIANGLES, self.indexCount, gl.UNSIGNED_SHORT, 0);
      if (self.cardboardUI) {
        self.cardboardUI.renderNoState();
      }
      self.realBindFramebuffer.call(self.gl, gl.FRAMEBUFFER, self.framebuffer);
      if (!self.ctxAttribs.preserveDrawingBuffer) {
        self.realClearColor.call(gl, 0, 0, 0, 0);
        gl.clear(gl.COLOR_BUFFER_BIT);
      }
      if (!self.dirtySubmitFrameBindings) {
        self.realBindFramebuffer.call(gl, gl.FRAMEBUFFER, self.lastBoundFramebuffer);
      }
      if (self.cullFace) {
        self.realEnable.call(gl, gl.CULL_FACE);
      }
      if (self.depthTest) {
        self.realEnable.call(gl, gl.DEPTH_TEST);
      }
      if (self.blend) {
        self.realEnable.call(gl, gl.BLEND);
      }
      if (self.scissorTest) {
        self.realEnable.call(gl, gl.SCISSOR_TEST);
      }
      if (self.stencilTest) {
        self.realEnable.call(gl, gl.STENCIL_TEST);
      }
      self.realColorMask.apply(gl, self.colorMask);
      self.realViewport.apply(gl, self.viewport);
      if (self.ctxAttribs.alpha || !self.ctxAttribs.preserveDrawingBuffer) {
        self.realClearColor.apply(gl, self.clearColor);
      }
      if (self.instanceExt) {
        if (positionDivisor != 0) {
          self.instanceExt.vertexAttribDivisorANGLE(self.attribs.position, positionDivisor);
        }
        if (texCoordDivisor != 0) {
          self.instanceExt.vertexAttribDivisorANGLE(self.attribs.texCoord, texCoordDivisor);
        }
      }
    });
    if (isIOS()) {
      var canvas = gl.canvas;
      if (canvas.width != self.bufferWidth || canvas.height != self.bufferHeight) {
        self.bufferWidth = canvas.width;
        self.bufferHeight = canvas.height;
        self.onResize();
      }
    }
  };
  CardboardDistorter.prototype.updateDeviceInfo = function (deviceInfo) {
    var gl = this.gl;
    var self = this;
    var glState = [gl.ARRAY_BUFFER_BINDING, gl.ELEMENT_ARRAY_BUFFER_BINDING];
    glPreserveState(gl, glState, function (gl) {
      var vertices = self.computeMeshVertices_(self.meshWidth, self.meshHeight, deviceInfo);
      gl.bindBuffer(gl.ARRAY_BUFFER, self.vertexBuffer);
      gl.bufferData(gl.ARRAY_BUFFER, vertices, gl.STATIC_DRAW);
      if (!self.indexCount) {
        var indices = self.computeMeshIndices_(self.meshWidth, self.meshHeight);
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, self.indexBuffer);
        gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, indices, gl.STATIC_DRAW);
        self.indexCount = indices.length;
      }
    });
  };
  CardboardDistorter.prototype.computeMeshVertices_ = function (width, height, deviceInfo) {
    var vertices = new Float32Array(2 * width * height * 5);
    var lensFrustum = deviceInfo.getLeftEyeVisibleTanAngles();
    var noLensFrustum = deviceInfo.getLeftEyeNoLensTanAngles();
    var viewport = deviceInfo.getLeftEyeVisibleScreenRect(noLensFrustum);
    var vidx = 0;
    for (var e = 0; e < 2; e++) {
      for (var j = 0; j < height; j++) {
        for (var i = 0; i < width; i++, vidx++) {
          var u = i / (width - 1);
          var v = j / (height - 1);
          var s = u;
          var t = v;
          var x = lerp(lensFrustum[0], lensFrustum[2], u);
          var y = lerp(lensFrustum[3], lensFrustum[1], v);
          var d = Math.sqrt(x * x + y * y);
          var r = deviceInfo.distortion.distortInverse(d);
          var p = x * r / d;
          var q = y * r / d;
          u = (p - noLensFrustum[0]) / (noLensFrustum[2] - noLensFrustum[0]);
          v = (q - noLensFrustum[3]) / (noLensFrustum[1] - noLensFrustum[3]);
          u = (viewport.x + u * viewport.width - 0.5) * 2.0;
          v = (viewport.y + v * viewport.height - 0.5) * 2.0;
          vertices[vidx * 5 + 0] = u;
          vertices[vidx * 5 + 1] = v;
          vertices[vidx * 5 + 2] = s;
          vertices[vidx * 5 + 3] = t;
          vertices[vidx * 5 + 4] = e;
        }
      }
      var w = lensFrustum[2] - lensFrustum[0];
      lensFrustum[0] = -(w + lensFrustum[0]);
      lensFrustum[2] = w - lensFrustum[2];
      w = noLensFrustum[2] - noLensFrustum[0];
      noLensFrustum[0] = -(w + noLensFrustum[0]);
      noLensFrustum[2] = w - noLensFrustum[2];
      viewport.x = 1 - (viewport.x + viewport.width);
    }
    return vertices;
  };
  CardboardDistorter.prototype.computeMeshIndices_ = function (width, height) {
    var indices = new Uint16Array(2 * (width - 1) * (height - 1) * 6);
    var halfwidth = width / 2;
    var halfheight = height / 2;
    var vidx = 0;
    var iidx = 0;
    for (var e = 0; e < 2; e++) {
      for (var j = 0; j < height; j++) {
        for (var i = 0; i < width; i++, vidx++) {
          if (i == 0 || j == 0) continue;
          if (i <= halfwidth == j <= halfheight) {
            indices[iidx++] = vidx;
            indices[iidx++] = vidx - width - 1;
            indices[iidx++] = vidx - width;
            indices[iidx++] = vidx - width - 1;
            indices[iidx++] = vidx;
            indices[iidx++] = vidx - 1;
          } else {
            indices[iidx++] = vidx - 1;
            indices[iidx++] = vidx - width;
            indices[iidx++] = vidx;
            indices[iidx++] = vidx - width;
            indices[iidx++] = vidx - 1;
            indices[iidx++] = vidx - width - 1;
          }
        }
      }
    }
    return indices;
  };
  CardboardDistorter.prototype.getOwnPropertyDescriptor_ = function (proto, attrName) {
    var descriptor = Object.getOwnPropertyDescriptor(proto, attrName);
    if (descriptor.get === undefined || descriptor.set === undefined) {
      descriptor.configurable = true;
      descriptor.enumerable = true;
      descriptor.get = function () {
        return this.getAttribute(attrName);
      };
      descriptor.set = function (val) {
        this.setAttribute(attrName, val);
      };
    }
    return descriptor;
  };
  var uiVS = ['attribute vec2 position;', 'uniform mat4 projectionMat;', 'void main() {', '  gl_Position = projectionMat * vec4( position, -1.0, 1.0 );', '}'].join('\n');
  var uiFS = ['precision mediump float;', 'uniform vec4 color;', 'void main() {', '  gl_FragColor = color;', '}'].join('\n');
  var DEG2RAD = Math.PI / 180.0;
  var kAnglePerGearSection = 60;
  var kOuterRimEndAngle = 12;
  var kInnerRimBeginAngle = 20;
  var kOuterRadius = 1;
  var kMiddleRadius = 0.75;
  var kInnerRadius = 0.3125;
  var kCenterLineThicknessDp = 4;
  var kButtonWidthDp = 28;
  var kTouchSlopFactor = 1.5;
  function CardboardUI(gl) {
    this.gl = gl;
    this.attribs = {
      position: 0
    };
    this.program = linkProgram(gl, uiVS, uiFS, this.attribs);
    this.uniforms = getProgramUniforms(gl, this.program);
    this.vertexBuffer = gl.createBuffer();
    this.gearOffset = 0;
    this.gearVertexCount = 0;
    this.arrowOffset = 0;
    this.arrowVertexCount = 0;
    this.projMat = new Float32Array(16);
    this.listener = null;
    this.onResize();
  }
  CardboardUI.prototype.destroy = function () {
    var gl = this.gl;
    if (this.listener) {
      gl.canvas.removeEventListener('click', this.listener, false);
    }
    gl.deleteProgram(this.program);
    gl.deleteBuffer(this.vertexBuffer);
  };
  CardboardUI.prototype.listen = function (optionsCallback, backCallback) {
    var canvas = this.gl.canvas;
    this.listener = function (event) {
      var midline = canvas.clientWidth / 2;
      var buttonSize = kButtonWidthDp * kTouchSlopFactor;
      if (event.clientX > midline - buttonSize && event.clientX < midline + buttonSize && event.clientY > canvas.clientHeight - buttonSize) {
        optionsCallback(event);
      }
      else if (event.clientX < buttonSize && event.clientY < buttonSize) {
          backCallback(event);
        }
    };
    canvas.addEventListener('click', this.listener, false);
  };
  CardboardUI.prototype.onResize = function () {
    var gl = this.gl;
    var self = this;
    var glState = [gl.ARRAY_BUFFER_BINDING];
    glPreserveState(gl, glState, function (gl) {
      var vertices = [];
      var midline = gl.drawingBufferWidth / 2;
      var physicalPixels = Math.max(screen.width, screen.height) * window.devicePixelRatio;
      var scalingRatio = gl.drawingBufferWidth / physicalPixels;
      var dps = scalingRatio * window.devicePixelRatio;
      var lineWidth = kCenterLineThicknessDp * dps / 2;
      var buttonSize = kButtonWidthDp * kTouchSlopFactor * dps;
      var buttonScale = kButtonWidthDp * dps / 2;
      var buttonBorder = (kButtonWidthDp * kTouchSlopFactor - kButtonWidthDp) * dps;
      vertices.push(midline - lineWidth, buttonSize);
      vertices.push(midline - lineWidth, gl.drawingBufferHeight);
      vertices.push(midline + lineWidth, buttonSize);
      vertices.push(midline + lineWidth, gl.drawingBufferHeight);
      self.gearOffset = vertices.length / 2;
      function addGearSegment(theta, r) {
        var angle = (90 - theta) * DEG2RAD;
        var x = Math.cos(angle);
        var y = Math.sin(angle);
        vertices.push(kInnerRadius * x * buttonScale + midline, kInnerRadius * y * buttonScale + buttonScale);
        vertices.push(r * x * buttonScale + midline, r * y * buttonScale + buttonScale);
      }
      for (var i = 0; i <= 6; i++) {
        var segmentTheta = i * kAnglePerGearSection;
        addGearSegment(segmentTheta, kOuterRadius);
        addGearSegment(segmentTheta + kOuterRimEndAngle, kOuterRadius);
        addGearSegment(segmentTheta + kInnerRimBeginAngle, kMiddleRadius);
        addGearSegment(segmentTheta + (kAnglePerGearSection - kInnerRimBeginAngle), kMiddleRadius);
        addGearSegment(segmentTheta + (kAnglePerGearSection - kOuterRimEndAngle), kOuterRadius);
      }
      self.gearVertexCount = vertices.length / 2 - self.gearOffset;
      self.arrowOffset = vertices.length / 2;
      function addArrowVertex(x, y) {
        vertices.push(buttonBorder + x, gl.drawingBufferHeight - buttonBorder - y);
      }
      var angledLineWidth = lineWidth / Math.sin(45 * DEG2RAD);
      addArrowVertex(0, buttonScale);
      addArrowVertex(buttonScale, 0);
      addArrowVertex(buttonScale + angledLineWidth, angledLineWidth);
      addArrowVertex(angledLineWidth, buttonScale + angledLineWidth);
      addArrowVertex(angledLineWidth, buttonScale - angledLineWidth);
      addArrowVertex(0, buttonScale);
      addArrowVertex(buttonScale, buttonScale * 2);
      addArrowVertex(buttonScale + angledLineWidth, buttonScale * 2 - angledLineWidth);
      addArrowVertex(angledLineWidth, buttonScale - angledLineWidth);
      addArrowVertex(0, buttonScale);
      addArrowVertex(angledLineWidth, buttonScale - lineWidth);
      addArrowVertex(kButtonWidthDp * dps, buttonScale - lineWidth);
      addArrowVertex(angledLineWidth, buttonScale + lineWidth);
      addArrowVertex(kButtonWidthDp * dps, buttonScale + lineWidth);
      self.arrowVertexCount = vertices.length / 2 - self.arrowOffset;
      gl.bindBuffer(gl.ARRAY_BUFFER, self.vertexBuffer);
      gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(vertices), gl.STATIC_DRAW);
    });
  };
  CardboardUI.prototype.render = function () {
    var gl = this.gl;
    var self = this;
    var glState = [gl.CULL_FACE, gl.DEPTH_TEST, gl.BLEND, gl.SCISSOR_TEST, gl.STENCIL_TEST, gl.COLOR_WRITEMASK, gl.VIEWPORT, gl.CURRENT_PROGRAM, gl.ARRAY_BUFFER_BINDING];
    glPreserveState(gl, glState, function (gl) {
      gl.disable(gl.CULL_FACE);
      gl.disable(gl.DEPTH_TEST);
      gl.disable(gl.BLEND);
      gl.disable(gl.SCISSOR_TEST);
      gl.disable(gl.STENCIL_TEST);
      gl.colorMask(true, true, true, true);
      gl.viewport(0, 0, gl.drawingBufferWidth, gl.drawingBufferHeight);
      self.renderNoState();
    });
  };
  CardboardUI.prototype.renderNoState = function () {
    var gl = this.gl;
    gl.useProgram(this.program);
    gl.bindBuffer(gl.ARRAY_BUFFER, this.vertexBuffer);
    gl.enableVertexAttribArray(this.attribs.position);
    gl.vertexAttribPointer(this.attribs.position, 2, gl.FLOAT, false, 8, 0);
    gl.uniform4f(this.uniforms.color, 1.0, 1.0, 1.0, 1.0);
    orthoMatrix(this.projMat, 0, gl.drawingBufferWidth, 0, gl.drawingBufferHeight, 0.1, 1024.0);
    gl.uniformMatrix4fv(this.uniforms.projectionMat, false, this.projMat);
    gl.drawArrays(gl.TRIANGLE_STRIP, 0, 4);
    gl.drawArrays(gl.TRIANGLE_STRIP, this.gearOffset, this.gearVertexCount);
    gl.drawArrays(gl.TRIANGLE_STRIP, this.arrowOffset, this.arrowVertexCount);
  };
  function Distortion(coefficients) {
    this.coefficients = coefficients;
  }
  Distortion.prototype.distortInverse = function (radius) {
    var r0 = 0;
    var r1 = 1;
    var dr0 = radius - this.distort(r0);
    while (Math.abs(r1 - r0) > 0.0001             ) {
      var dr1 = radius - this.distort(r1);
      var r2 = r1 - dr1 * ((r1 - r0) / (dr1 - dr0));
      r0 = r1;
      r1 = r2;
      dr0 = dr1;
    }
    return r1;
  };
  Distortion.prototype.distort = function (radius) {
    var r2 = radius * radius;
    var ret = 0;
    for (var i = 0; i < this.coefficients.length; i++) {
      ret = r2 * (ret + this.coefficients[i]);
    }
    return (ret + 1) * radius;
  };
  var degToRad = Math.PI / 180;
  var radToDeg = 180 / Math.PI;
  var Vector3 = function Vector3(x, y, z) {
    this.x = x || 0;
    this.y = y || 0;
    this.z = z || 0;
  };
  Vector3.prototype = {
    constructor: Vector3,
    set: function set(x, y, z) {
      this.x = x;
      this.y = y;
      this.z = z;
      return this;
    },
    copy: function copy(v) {
      this.x = v.x;
      this.y = v.y;
      this.z = v.z;
      return this;
    },
    length: function length() {
      return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    },
    normalize: function normalize() {
      var scalar = this.length();
      if (scalar !== 0) {
        var invScalar = 1 / scalar;
        this.multiplyScalar(invScalar);
      } else {
        this.x = 0;
        this.y = 0;
        this.z = 0;
      }
      return this;
    },
    multiplyScalar: function multiplyScalar(scalar) {
      this.x *= scalar;
      this.y *= scalar;
      this.z *= scalar;
    },
    applyQuaternion: function applyQuaternion(q) {
      var x = this.x;
      var y = this.y;
      var z = this.z;
      var qx = q.x;
      var qy = q.y;
      var qz = q.z;
      var qw = q.w;
      var ix = qw * x + qy * z - qz * y;
      var iy = qw * y + qz * x - qx * z;
      var iz = qw * z + qx * y - qy * x;
      var iw = -qx * x - qy * y - qz * z;
      this.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
      this.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
      this.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
      return this;
    },
    dot: function dot(v) {
      return this.x * v.x + this.y * v.y + this.z * v.z;
    },
    crossVectors: function crossVectors(a, b) {
      var ax = a.x,
          ay = a.y,
          az = a.z;
      var bx = b.x,
          by = b.y,
          bz = b.z;
      this.x = ay * bz - az * by;
      this.y = az * bx - ax * bz;
      this.z = ax * by - ay * bx;
      return this;
    }
  };
  var Quaternion = function Quaternion(x, y, z, w) {
    this.x = x || 0;
    this.y = y || 0;
    this.z = z || 0;
    this.w = w !== undefined ? w : 1;
  };
  Quaternion.prototype = {
    constructor: Quaternion,
    set: function set(x, y, z, w) {
      this.x = x;
      this.y = y;
      this.z = z;
      this.w = w;
      return this;
    },
    copy: function copy(quaternion) {
      this.x = quaternion.x;
      this.y = quaternion.y;
      this.z = quaternion.z;
      this.w = quaternion.w;
      return this;
    },
    setFromEulerXYZ: function setFromEulerXYZ(x, y, z) {
      var c1 = Math.cos(x / 2);
      var c2 = Math.cos(y / 2);
      var c3 = Math.cos(z / 2);
      var s1 = Math.sin(x / 2);
      var s2 = Math.sin(y / 2);
      var s3 = Math.sin(z / 2);
      this.x = s1 * c2 * c3 + c1 * s2 * s3;
      this.y = c1 * s2 * c3 - s1 * c2 * s3;
      this.z = c1 * c2 * s3 + s1 * s2 * c3;
      this.w = c1 * c2 * c3 - s1 * s2 * s3;
      return this;
    },
    setFromEulerYXZ: function setFromEulerYXZ(x, y, z) {
      var c1 = Math.cos(x / 2);
      var c2 = Math.cos(y / 2);
      var c3 = Math.cos(z / 2);
      var s1 = Math.sin(x / 2);
      var s2 = Math.sin(y / 2);
      var s3 = Math.sin(z / 2);
      this.x = s1 * c2 * c3 + c1 * s2 * s3;
      this.y = c1 * s2 * c3 - s1 * c2 * s3;
      this.z = c1 * c2 * s3 - s1 * s2 * c3;
      this.w = c1 * c2 * c3 + s1 * s2 * s3;
      return this;
    },
    setFromAxisAngle: function setFromAxisAngle(axis, angle) {
      var halfAngle = angle / 2,
          s = Math.sin(halfAngle);
      this.x = axis.x * s;
      this.y = axis.y * s;
      this.z = axis.z * s;
      this.w = Math.cos(halfAngle);
      return this;
    },
    multiply: function multiply(q) {
      return this.multiplyQuaternions(this, q);
    },
    multiplyQuaternions: function multiplyQuaternions(a, b) {
      var qax = a.x,
          qay = a.y,
          qaz = a.z,
          qaw = a.w;
      var qbx = b.x,
          qby = b.y,
          qbz = b.z,
          qbw = b.w;
      this.x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;
      this.y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;
      this.z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;
      this.w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;
      return this;
    },
    inverse: function inverse() {
      this.x *= -1;
      this.y *= -1;
      this.z *= -1;
      this.normalize();
      return this;
    },
    normalize: function normalize() {
      var l = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
      if (l === 0) {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.w = 1;
      } else {
        l = 1 / l;
        this.x = this.x * l;
        this.y = this.y * l;
        this.z = this.z * l;
        this.w = this.w * l;
      }
      return this;
    },
    slerp: function slerp(qb, t) {
      if (t === 0) return this;
      if (t === 1) return this.copy(qb);
      var x = this.x,
          y = this.y,
          z = this.z,
          w = this.w;
      var cosHalfTheta = w * qb.w + x * qb.x + y * qb.y + z * qb.z;
      if (cosHalfTheta < 0) {
        this.w = -qb.w;
        this.x = -qb.x;
        this.y = -qb.y;
        this.z = -qb.z;
        cosHalfTheta = -cosHalfTheta;
      } else {
        this.copy(qb);
      }
      if (cosHalfTheta >= 1.0) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
      }
      var halfTheta = Math.acos(cosHalfTheta);
      var sinHalfTheta = Math.sqrt(1.0 - cosHalfTheta * cosHalfTheta);
      if (Math.abs(sinHalfTheta) < 0.001) {
        this.w = 0.5 * (w + this.w);
        this.x = 0.5 * (x + this.x);
        this.y = 0.5 * (y + this.y);
        this.z = 0.5 * (z + this.z);
        return this;
      }
      var ratioA = Math.sin((1 - t) * halfTheta) / sinHalfTheta,
          ratioB = Math.sin(t * halfTheta) / sinHalfTheta;
      this.w = w * ratioA + this.w * ratioB;
      this.x = x * ratioA + this.x * ratioB;
      this.y = y * ratioA + this.y * ratioB;
      this.z = z * ratioA + this.z * ratioB;
      return this;
    },
    setFromUnitVectors: function () {
      var v1, r;
      var EPS = 0.000001;
      return function (vFrom, vTo) {
        if (v1 === undefined) v1 = new Vector3();
        r = vFrom.dot(vTo) + 1;
        if (r < EPS) {
          r = 0;
          if (Math.abs(vFrom.x) > Math.abs(vFrom.z)) {
            v1.set(-vFrom.y, vFrom.x, 0);
          } else {
            v1.set(0, -vFrom.z, vFrom.y);
          }
        } else {
          v1.crossVectors(vFrom, vTo);
        }
        this.x = v1.x;
        this.y = v1.y;
        this.z = v1.z;
        this.w = r;
        this.normalize();
        return this;
      };
    }()
  };
  function Device(params) {
    this.width = params.width || getScreenWidth();
    this.height = params.height || getScreenHeight();
    this.widthMeters = params.widthMeters;
    this.heightMeters = params.heightMeters;
    this.bevelMeters = params.bevelMeters;
  }
  var DEFAULT_ANDROID = new Device({
    widthMeters: 0.110,
    heightMeters: 0.062,
    bevelMeters: 0.004
  });
  var DEFAULT_IOS = new Device({
    widthMeters: 0.1038,
    heightMeters: 0.0584,
    bevelMeters: 0.004
  });
  var Viewers = {
    CardboardV1: new CardboardViewer({
      id: 'CardboardV1',
      label: 'Cardboard I/O 2014',
      fov: 40,
      interLensDistance: 0.060,
      baselineLensDistance: 0.035,
      screenLensDistance: 0.042,
      distortionCoefficients: [0.441, 0.156],
      inverseCoefficients: [-0.4410035, 0.42756155, -0.4804439, 0.5460139, -0.58821183, 0.5733938, -0.48303202, 0.33299083, -0.17573841, 0.0651772, -0.01488963, 0.001559834]
    }),
    CardboardV2: new CardboardViewer({
      id: 'CardboardV2',
      label: 'Cardboard I/O 2015',
      fov: 60,
      interLensDistance: 0.064,
      baselineLensDistance: 0.035,
      screenLensDistance: 0.039,
      distortionCoefficients: [0.34, 0.55],
      inverseCoefficients: [-0.33836704, -0.18162185, 0.862655, -1.2462051, 1.0560602, -0.58208317, 0.21609078, -0.05444823, 0.009177956, -9.904169E-4, 6.183535E-5, -1.6981803E-6]
    })
  };
  function DeviceInfo(deviceParams, additionalViewers) {
    this.viewer = Viewers.CardboardV2;
    this.updateDeviceParams(deviceParams);
    this.distortion = new Distortion(this.viewer.distortionCoefficients);
    for (var i = 0; i < additionalViewers.length; i++) {
      var viewer = additionalViewers[i];
      Viewers[viewer.id] = new CardboardViewer(viewer);
    }
  }
  DeviceInfo.prototype.updateDeviceParams = function (deviceParams) {
    this.device = this.determineDevice_(deviceParams) || this.device;
  };
  DeviceInfo.prototype.getDevice = function () {
    return this.device;
  };
  DeviceInfo.prototype.setViewer = function (viewer) {
    this.viewer = viewer;
    this.distortion = new Distortion(this.viewer.distortionCoefficients);
  };
  DeviceInfo.prototype.determineDevice_ = function (deviceParams) {
    if (!deviceParams) {
      if (isIOS()) {
        console.warn('Using fallback iOS device measurements.');
        return DEFAULT_IOS;
      } else {
        console.warn('Using fallback Android device measurements.');
        return DEFAULT_ANDROID;
      }
    }
    var METERS_PER_INCH = 0.0254;
    var metersPerPixelX = METERS_PER_INCH / deviceParams.xdpi;
    var metersPerPixelY = METERS_PER_INCH / deviceParams.ydpi;
    var width = getScreenWidth();
    var height = getScreenHeight();
    return new Device({
      widthMeters: metersPerPixelX * width,
      heightMeters: metersPerPixelY * height,
      bevelMeters: deviceParams.bevelMm * 0.001
    });
  };
  DeviceInfo.prototype.getDistortedFieldOfViewLeftEye = function () {
    var viewer = this.viewer;
    var device = this.device;
    var distortion = this.distortion;
    var eyeToScreenDistance = viewer.screenLensDistance;
    var outerDist = (device.widthMeters - viewer.interLensDistance) / 2;
    var innerDist = viewer.interLensDistance / 2;
    var bottomDist = viewer.baselineLensDistance - device.bevelMeters;
    var topDist = device.heightMeters - bottomDist;
    var outerAngle = radToDeg * Math.atan(distortion.distort(outerDist / eyeToScreenDistance));
    var innerAngle = radToDeg * Math.atan(distortion.distort(innerDist / eyeToScreenDistance));
    var bottomAngle = radToDeg * Math.atan(distortion.distort(bottomDist / eyeToScreenDistance));
    var topAngle = radToDeg * Math.atan(distortion.distort(topDist / eyeToScreenDistance));
    return {
      leftDegrees: Math.min(outerAngle, viewer.fov),
      rightDegrees: Math.min(innerAngle, viewer.fov),
      downDegrees: Math.min(bottomAngle, viewer.fov),
      upDegrees: Math.min(topAngle, viewer.fov)
    };
  };
  DeviceInfo.prototype.getLeftEyeVisibleTanAngles = function () {
    var viewer = this.viewer;
    var device = this.device;
    var distortion = this.distortion;
    var fovLeft = Math.tan(-degToRad * viewer.fov);
    var fovTop = Math.tan(degToRad * viewer.fov);
    var fovRight = Math.tan(degToRad * viewer.fov);
    var fovBottom = Math.tan(-degToRad * viewer.fov);
    var halfWidth = device.widthMeters / 4;
    var halfHeight = device.heightMeters / 2;
    var verticalLensOffset = viewer.baselineLensDistance - device.bevelMeters - halfHeight;
    var centerX = viewer.interLensDistance / 2 - halfWidth;
    var centerY = -verticalLensOffset;
    var centerZ = viewer.screenLensDistance;
    var screenLeft = distortion.distort((centerX - halfWidth) / centerZ);
    var screenTop = distortion.distort((centerY + halfHeight) / centerZ);
    var screenRight = distortion.distort((centerX + halfWidth) / centerZ);
    var screenBottom = distortion.distort((centerY - halfHeight) / centerZ);
    var result = new Float32Array(4);
    result[0] = Math.max(fovLeft, screenLeft);
    result[1] = Math.min(fovTop, screenTop);
    result[2] = Math.min(fovRight, screenRight);
    result[3] = Math.max(fovBottom, screenBottom);
    return result;
  };
  DeviceInfo.prototype.getLeftEyeNoLensTanAngles = function () {
    var viewer = this.viewer;
    var device = this.device;
    var distortion = this.distortion;
    var result = new Float32Array(4);
    var fovLeft = distortion.distortInverse(Math.tan(-degToRad * viewer.fov));
    var fovTop = distortion.distortInverse(Math.tan(degToRad * viewer.fov));
    var fovRight = distortion.distortInverse(Math.tan(degToRad * viewer.fov));
    var fovBottom = distortion.distortInverse(Math.tan(-degToRad * viewer.fov));
    var halfWidth = device.widthMeters / 4;
    var halfHeight = device.heightMeters / 2;
    var verticalLensOffset = viewer.baselineLensDistance - device.bevelMeters - halfHeight;
    var centerX = viewer.interLensDistance / 2 - halfWidth;
    var centerY = -verticalLensOffset;
    var centerZ = viewer.screenLensDistance;
    var screenLeft = (centerX - halfWidth) / centerZ;
    var screenTop = (centerY + halfHeight) / centerZ;
    var screenRight = (centerX + halfWidth) / centerZ;
    var screenBottom = (centerY - halfHeight) / centerZ;
    result[0] = Math.max(fovLeft, screenLeft);
    result[1] = Math.min(fovTop, screenTop);
    result[2] = Math.min(fovRight, screenRight);
    result[3] = Math.max(fovBottom, screenBottom);
    return result;
  };
  DeviceInfo.prototype.getLeftEyeVisibleScreenRect = function (undistortedFrustum) {
    var viewer = this.viewer;
    var device = this.device;
    var dist = viewer.screenLensDistance;
    var eyeX = (device.widthMeters - viewer.interLensDistance) / 2;
    var eyeY = viewer.baselineLensDistance - device.bevelMeters;
    var left = (undistortedFrustum[0] * dist + eyeX) / device.widthMeters;
    var top = (undistortedFrustum[1] * dist + eyeY) / device.heightMeters;
    var right = (undistortedFrustum[2] * dist + eyeX) / device.widthMeters;
    var bottom = (undistortedFrustum[3] * dist + eyeY) / device.heightMeters;
    return {
      x: left,
      y: bottom,
      width: right - left,
      height: top - bottom
    };
  };
  DeviceInfo.prototype.getFieldOfViewLeftEye = function (opt_isUndistorted) {
    return opt_isUndistorted ? this.getUndistortedFieldOfViewLeftEye() : this.getDistortedFieldOfViewLeftEye();
  };
  DeviceInfo.prototype.getFieldOfViewRightEye = function (opt_isUndistorted) {
    var fov = this.getFieldOfViewLeftEye(opt_isUndistorted);
    return {
      leftDegrees: fov.rightDegrees,
      rightDegrees: fov.leftDegrees,
      upDegrees: fov.upDegrees,
      downDegrees: fov.downDegrees
    };
  };
  DeviceInfo.prototype.getUndistortedFieldOfViewLeftEye = function () {
    var p = this.getUndistortedParams_();
    return {
      leftDegrees: radToDeg * Math.atan(p.outerDist),
      rightDegrees: radToDeg * Math.atan(p.innerDist),
      downDegrees: radToDeg * Math.atan(p.bottomDist),
      upDegrees: radToDeg * Math.atan(p.topDist)
    };
  };
  DeviceInfo.prototype.getUndistortedViewportLeftEye = function () {
    var p = this.getUndistortedParams_();
    var viewer = this.viewer;
    var device = this.device;
    var eyeToScreenDistance = viewer.screenLensDistance;
    var screenWidth = device.widthMeters / eyeToScreenDistance;
    var screenHeight = device.heightMeters / eyeToScreenDistance;
    var xPxPerTanAngle = device.width / screenWidth;
    var yPxPerTanAngle = device.height / screenHeight;
    var x = Math.round((p.eyePosX - p.outerDist) * xPxPerTanAngle);
    var y = Math.round((p.eyePosY - p.bottomDist) * yPxPerTanAngle);
    return {
      x: x,
      y: y,
      width: Math.round((p.eyePosX + p.innerDist) * xPxPerTanAngle) - x,
      height: Math.round((p.eyePosY + p.topDist) * yPxPerTanAngle) - y
    };
  };
  DeviceInfo.prototype.getUndistortedParams_ = function () {
    var viewer = this.viewer;
    var device = this.device;
    var distortion = this.distortion;
    var eyeToScreenDistance = viewer.screenLensDistance;
    var halfLensDistance = viewer.interLensDistance / 2 / eyeToScreenDistance;
    var screenWidth = device.widthMeters / eyeToScreenDistance;
    var screenHeight = device.heightMeters / eyeToScreenDistance;
    var eyePosX = screenWidth / 2 - halfLensDistance;
    var eyePosY = (viewer.baselineLensDistance - device.bevelMeters) / eyeToScreenDistance;
    var maxFov = viewer.fov;
    var viewerMax = distortion.distortInverse(Math.tan(degToRad * maxFov));
    var outerDist = Math.min(eyePosX, viewerMax);
    var innerDist = Math.min(halfLensDistance, viewerMax);
    var bottomDist = Math.min(eyePosY, viewerMax);
    var topDist = Math.min(screenHeight - eyePosY, viewerMax);
    return {
      outerDist: outerDist,
      innerDist: innerDist,
      topDist: topDist,
      bottomDist: bottomDist,
      eyePosX: eyePosX,
      eyePosY: eyePosY
    };
  };
  function CardboardViewer(params) {
    this.id = params.id;
    this.label = params.label;
    this.fov = params.fov;
    this.interLensDistance = params.interLensDistance;
    this.baselineLensDistance = params.baselineLensDistance;
    this.screenLensDistance = params.screenLensDistance;
    this.distortionCoefficients = params.distortionCoefficients;
    this.inverseCoefficients = params.inverseCoefficients;
  }
  DeviceInfo.Viewers = Viewers;
  var format = 1;
  var last_updated = "2019-11-09T17:36:14Z";
  var devices = [{"type":"android","rules":[{"mdmh":"asus/*/Nexus 7/*"},{"ua":"Nexus 7"}],"dpi":[320.8,323],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"asus/*/ASUS_X00PD/*"},{"ua":"ASUS_X00PD"}],"dpi":245,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"asus/*/ASUS_X008D/*"},{"ua":"ASUS_X008D"}],"dpi":282,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"asus/*/ASUS_Z00AD/*"},{"ua":"ASUS_Z00AD"}],"dpi":[403,404.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Google/*/Pixel 2 XL/*"},{"ua":"Pixel 2 XL"}],"dpi":537.9,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Google/*/Pixel 3 XL/*"},{"ua":"Pixel 3 XL"}],"dpi":[558.5,553.8],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Google/*/Pixel XL/*"},{"ua":"Pixel XL"}],"dpi":[537.9,533],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Google/*/Pixel 3/*"},{"ua":"Pixel 3"}],"dpi":442.4,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Google/*/Pixel 2/*"},{"ua":"Pixel 2"}],"dpi":441,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"Google/*/Pixel/*"},{"ua":"Pixel"}],"dpi":[432.6,436.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"HTC/*/HTC6435LVW/*"},{"ua":"HTC6435LVW"}],"dpi":[449.7,443.3],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"HTC/*/HTC One XL/*"},{"ua":"HTC One XL"}],"dpi":[315.3,314.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"htc/*/Nexus 9/*"},{"ua":"Nexus 9"}],"dpi":289,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"HTC/*/HTC One M9/*"},{"ua":"HTC One M9"}],"dpi":[442.5,443.3],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"HTC/*/HTC One_M8/*"},{"ua":"HTC One_M8"}],"dpi":[449.7,447.4],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"HTC/*/HTC One/*"},{"ua":"HTC One"}],"dpi":472.8,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Huawei/*/Nexus 6P/*"},{"ua":"Nexus 6P"}],"dpi":[515.1,518],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Huawei/*/BLN-L24/*"},{"ua":"HONORBLN-L24"}],"dpi":480,"bw":4,"ac":500},{"type":"android","rules":[{"mdmh":"Huawei/*/BKL-L09/*"},{"ua":"BKL-L09"}],"dpi":403,"bw":3.47,"ac":500},{"type":"android","rules":[{"mdmh":"LENOVO/*/Lenovo PB2-690Y/*"},{"ua":"Lenovo PB2-690Y"}],"dpi":[457.2,454.713],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"LGE/*/Nexus 5X/*"},{"ua":"Nexus 5X"}],"dpi":[422,419.9],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"LGE/*/LGMS345/*"},{"ua":"LGMS345"}],"dpi":[221.7,219.1],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"LGE/*/LG-D800/*"},{"ua":"LG-D800"}],"dpi":[422,424.1],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"LGE/*/LG-D850/*"},{"ua":"LG-D850"}],"dpi":[537.9,541.9],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"LGE/*/VS985 4G/*"},{"ua":"VS985 4G"}],"dpi":[537.9,535.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"LGE/*/Nexus 5/*"},{"ua":"Nexus 5 B"}],"dpi":[442.4,444.8],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"LGE/*/Nexus 4/*"},{"ua":"Nexus 4"}],"dpi":[319.8,318.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"LGE/*/LG-P769/*"},{"ua":"LG-P769"}],"dpi":[240.6,247.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"LGE/*/LGMS323/*"},{"ua":"LGMS323"}],"dpi":[206.6,204.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"LGE/*/LGLS996/*"},{"ua":"LGLS996"}],"dpi":[403.4,401.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Micromax/*/4560MMX/*"},{"ua":"4560MMX"}],"dpi":[240,219.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Micromax/*/A250/*"},{"ua":"Micromax A250"}],"dpi":[480,446.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Micromax/*/Micromax AQ4501/*"},{"ua":"Micromax AQ4501"}],"dpi":240,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"motorola/*/G5/*"},{"ua":"Moto G (5) Plus"}],"dpi":[403.4,403],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/DROID RAZR/*"},{"ua":"DROID RAZR"}],"dpi":[368.1,256.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/XT830C/*"},{"ua":"XT830C"}],"dpi":[254,255.9],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/XT1021/*"},{"ua":"XT1021"}],"dpi":[254,256.7],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"motorola/*/XT1023/*"},{"ua":"XT1023"}],"dpi":[254,256.7],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"motorola/*/XT1028/*"},{"ua":"XT1028"}],"dpi":[326.6,327.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/XT1034/*"},{"ua":"XT1034"}],"dpi":[326.6,328.4],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"motorola/*/XT1053/*"},{"ua":"XT1053"}],"dpi":[315.3,316.1],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/XT1562/*"},{"ua":"XT1562"}],"dpi":[403.4,402.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/Nexus 6/*"},{"ua":"Nexus 6 B"}],"dpi":[494.3,489.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/XT1063/*"},{"ua":"XT1063"}],"dpi":[295,296.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/XT1064/*"},{"ua":"XT1064"}],"dpi":[295,295.6],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"motorola/*/XT1092/*"},{"ua":"XT1092"}],"dpi":[422,424.1],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"motorola/*/XT1095/*"},{"ua":"XT1095"}],"dpi":[422,423.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"motorola/*/G4/*"},{"ua":"Moto G (4)"}],"dpi":401,"bw":4,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/A0001/*"},{"ua":"A0001"}],"dpi":[403.4,401],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE E1001/*"},{"ua":"ONE E1001"}],"dpi":[442.4,441.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE E1003/*"},{"ua":"ONE E1003"}],"dpi":[442.4,441.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE E1005/*"},{"ua":"ONE E1005"}],"dpi":[442.4,441.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE A2001/*"},{"ua":"ONE A2001"}],"dpi":[391.9,405.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE A2003/*"},{"ua":"ONE A2003"}],"dpi":[391.9,405.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE A2005/*"},{"ua":"ONE A2005"}],"dpi":[391.9,405.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A3000/*"},{"ua":"ONEPLUS A3000"}],"dpi":401,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A3003/*"},{"ua":"ONEPLUS A3003"}],"dpi":401,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A3010/*"},{"ua":"ONEPLUS A3010"}],"dpi":401,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A5000/*"},{"ua":"ONEPLUS A5000 "}],"dpi":[403.411,399.737],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONE A5010/*"},{"ua":"ONEPLUS A5010"}],"dpi":[403,400],"bw":2,"ac":1000},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A6000/*"},{"ua":"ONEPLUS A6000"}],"dpi":401,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A6003/*"},{"ua":"ONEPLUS A6003"}],"dpi":401,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A6010/*"},{"ua":"ONEPLUS A6010"}],"dpi":401,"bw":2,"ac":500},{"type":"android","rules":[{"mdmh":"OnePlus/*/ONEPLUS A6013/*"},{"ua":"ONEPLUS A6013"}],"dpi":401,"bw":2,"ac":500},{"type":"android","rules":[{"mdmh":"OPPO/*/X909/*"},{"ua":"X909"}],"dpi":[442.4,444.1],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9082/*"},{"ua":"GT-I9082"}],"dpi":[184.7,185.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G360P/*"},{"ua":"SM-G360P"}],"dpi":[196.7,205.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/Nexus S/*"},{"ua":"Nexus S"}],"dpi":[234.5,229.8],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9300/*"},{"ua":"GT-I9300"}],"dpi":[304.8,303.9],"bw":5,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-T230NU/*"},{"ua":"SM-T230NU"}],"dpi":216,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SGH-T399/*"},{"ua":"SGH-T399"}],"dpi":[217.7,231.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SGH-M919/*"},{"ua":"SGH-M919"}],"dpi":[440.8,437.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-N9005/*"},{"ua":"SM-N9005"}],"dpi":[386.4,387],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SAMSUNG-SM-N900A/*"},{"ua":"SAMSUNG-SM-N900A"}],"dpi":[386.4,387.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9500/*"},{"ua":"GT-I9500"}],"dpi":[442.5,443.3],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9505/*"},{"ua":"GT-I9505"}],"dpi":439.4,"bw":4,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G900F/*"},{"ua":"SM-G900F"}],"dpi":[415.6,431.6],"bw":5,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G900M/*"},{"ua":"SM-G900M"}],"dpi":[415.6,431.6],"bw":5,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G800F/*"},{"ua":"SM-G800F"}],"dpi":326.8,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G906S/*"},{"ua":"SM-G906S"}],"dpi":[562.7,572.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9300/*"},{"ua":"GT-I9300"}],"dpi":[306.7,304.8],"bw":5,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-T535/*"},{"ua":"SM-T535"}],"dpi":[142.6,136.4],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-N920C/*"},{"ua":"SM-N920C"}],"dpi":[515.1,518.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-N920P/*"},{"ua":"SM-N920P"}],"dpi":[386.3655,390.144],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-N920W8/*"},{"ua":"SM-N920W8"}],"dpi":[515.1,518.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9300I/*"},{"ua":"GT-I9300I"}],"dpi":[304.8,305.8],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-I9195/*"},{"ua":"GT-I9195"}],"dpi":[249.4,256.7],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SPH-L520/*"},{"ua":"SPH-L520"}],"dpi":[249.4,255.9],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SAMSUNG-SGH-I717/*"},{"ua":"SAMSUNG-SGH-I717"}],"dpi":285.8,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SPH-D710/*"},{"ua":"SPH-D710"}],"dpi":[217.7,204.2],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/GT-N7100/*"},{"ua":"GT-N7100"}],"dpi":265.1,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SCH-I605/*"},{"ua":"SCH-I605"}],"dpi":265.1,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/Galaxy Nexus/*"},{"ua":"Galaxy Nexus"}],"dpi":[315.3,314.2],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-N910H/*"},{"ua":"SM-N910H"}],"dpi":[515.1,518],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-N910C/*"},{"ua":"SM-N910C"}],"dpi":[515.2,520.2],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G130M/*"},{"ua":"SM-G130M"}],"dpi":[165.9,164.8],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G928I/*"},{"ua":"SM-G928I"}],"dpi":[515.1,518.4],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G920F/*"},{"ua":"SM-G920F"}],"dpi":580.6,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G920P/*"},{"ua":"SM-G920P"}],"dpi":[522.5,577],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G925F/*"},{"ua":"SM-G925F"}],"dpi":580.6,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G925V/*"},{"ua":"SM-G925V"}],"dpi":[522.5,576.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G930F/*"},{"ua":"SM-G930F"}],"dpi":576.6,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G935F/*"},{"ua":"SM-G935F"}],"dpi":533,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G950F/*"},{"ua":"SM-G950F"}],"dpi":[562.707,565.293],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G955U/*"},{"ua":"SM-G955U"}],"dpi":[522.514,525.762],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G955F/*"},{"ua":"SM-G955F"}],"dpi":[522.514,525.762],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G960F/*"},{"ua":"SM-G960F"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G9600/*"},{"ua":"SM-G9600"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G960T/*"},{"ua":"SM-G960T"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G960N/*"},{"ua":"SM-G960N"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G960U/*"},{"ua":"SM-G960U"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G9608/*"},{"ua":"SM-G9608"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G960FD/*"},{"ua":"SM-G960FD"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G960W/*"},{"ua":"SM-G960W"}],"dpi":[569.575,571.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G965F/*"},{"ua":"SM-G965F"}],"dpi":529,"bw":2,"ac":1000},{"type":"android","rules":[{"mdmh":"Sony/*/C6903/*"},{"ua":"C6903"}],"dpi":[442.5,443.3],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"Sony/*/D6653/*"},{"ua":"D6653"}],"dpi":[428.6,427.6],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Sony/*/E6653/*"},{"ua":"E6653"}],"dpi":[428.6,425.7],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Sony/*/E6853/*"},{"ua":"E6853"}],"dpi":[403.4,401.9],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Sony/*/SGP321/*"},{"ua":"SGP321"}],"dpi":[224.7,224.1],"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"TCT/*/ALCATEL ONE TOUCH Fierce/*"},{"ua":"ALCATEL ONE TOUCH Fierce"}],"dpi":[240,247.5],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"THL/*/thl 5000/*"},{"ua":"thl 5000"}],"dpi":[480,443.3],"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"Fly/*/IQ4412/*"},{"ua":"IQ4412"}],"dpi":307.9,"bw":3,"ac":1000},{"type":"android","rules":[{"mdmh":"ZTE/*/ZTE Blade L2/*"},{"ua":"ZTE Blade L2"}],"dpi":240,"bw":3,"ac":500},{"type":"android","rules":[{"mdmh":"BENEVE/*/VR518/*"},{"ua":"VR518"}],"dpi":480,"bw":3,"ac":500},{"type":"ios","rules":[{"res":[640,960]}],"dpi":[325.1,328.4],"bw":4,"ac":1000},{"type":"ios","rules":[{"res":[640,1136]}],"dpi":[317.1,320.2],"bw":3,"ac":1000},{"type":"ios","rules":[{"res":[750,1334]}],"dpi":326.4,"bw":4,"ac":1000},{"type":"ios","rules":[{"res":[1242,2208]}],"dpi":[453.6,458.4],"bw":4,"ac":1000},{"type":"ios","rules":[{"res":[1125,2001]}],"dpi":[410.9,415.4],"bw":4,"ac":1000},{"type":"ios","rules":[{"res":[1125,2436]}],"dpi":458,"bw":4,"ac":1000},{"type":"android","rules":[{"mdmh":"Huawei/*/EML-L29/*"},{"ua":"EML-L29"}],"dpi":428,"bw":3.45,"ac":500},{"type":"android","rules":[{"mdmh":"Nokia/*/Nokia 7.1/*"},{"ua":"Nokia 7.1"}],"dpi":[432,431.9],"bw":3,"ac":500},{"type":"ios","rules":[{"res":[1242,2688]}],"dpi":458,"bw":4,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G570M/*"},{"ua":"SM-G570M"}],"dpi":320,"bw":3.684,"ac":1000},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G970F/*"},{"ua":"SM-G970F"}],"dpi":438,"bw":2.281,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G973F/*"},{"ua":"SM-G973F"}],"dpi":550,"bw":2.002,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G975F/*"},{"ua":"SM-G975F"}],"dpi":522,"bw":2.054,"ac":500},{"type":"android","rules":[{"mdmh":"samsung/*/SM-G977F/*"},{"ua":"SM-G977F"}],"dpi":505,"bw":2.334,"ac":500},{"type":"ios","rules":[{"res":[828,1792]}],"dpi":326,"bw":5,"ac":500}];
  var DPDB_CACHE = {
  	format: format,
  	last_updated: last_updated,
  	devices: devices
  };
  function Dpdb(url, onDeviceParamsUpdated) {
    this.dpdb = DPDB_CACHE;
    this.recalculateDeviceParams_();
    if (url) {
      this.onDeviceParamsUpdated = onDeviceParamsUpdated;
      var xhr = new XMLHttpRequest();
      var obj = this;
      xhr.open('GET', url, true);
      xhr.addEventListener('load', function () {
        obj.loading = false;
        if (xhr.status >= 200 && xhr.status <= 299) {
          obj.dpdb = JSON.parse(xhr.response);
          obj.recalculateDeviceParams_();
        } else {
          console.error('Error loading online DPDB!');
        }
      });
      xhr.send();
    }
  }
  Dpdb.prototype.getDeviceParams = function () {
    return this.deviceParams;
  };
  Dpdb.prototype.recalculateDeviceParams_ = function () {
    var newDeviceParams = this.calcDeviceParams_();
    if (newDeviceParams) {
      this.deviceParams = newDeviceParams;
      if (this.onDeviceParamsUpdated) {
        this.onDeviceParamsUpdated(this.deviceParams);
      }
    } else {
      console.error('Failed to recalculate device parameters.');
    }
  };
  Dpdb.prototype.calcDeviceParams_ = function () {
    var db = this.dpdb;
    if (!db) {
      console.error('DPDB not available.');
      return null;
    }
    if (db.format != 1) {
      console.error('DPDB has unexpected format version.');
      return null;
    }
    if (!db.devices || !db.devices.length) {
      console.error('DPDB does not have a devices section.');
      return null;
    }
    var userAgent = navigator.userAgent || navigator.vendor || window.opera;
    var width = getScreenWidth();
    var height = getScreenHeight();
    if (!db.devices) {
      console.error('DPDB has no devices section.');
      return null;
    }
    for (var i = 0; i < db.devices.length; i++) {
      var device = db.devices[i];
      if (!device.rules) {
        console.warn('Device[' + i + '] has no rules section.');
        continue;
      }
      if (device.type != 'ios' && device.type != 'android') {
        console.warn('Device[' + i + '] has invalid type.');
        continue;
      }
      if (isIOS() != (device.type == 'ios')) continue;
      var matched = false;
      for (var j = 0; j < device.rules.length; j++) {
        var rule = device.rules[j];
        if (this.ruleMatches_(rule, userAgent, width, height)) {
          matched = true;
          break;
        }
      }
      if (!matched) continue;
      var xdpi = device.dpi[0] || device.dpi;
      var ydpi = device.dpi[1] || device.dpi;
      return new DeviceParams({ xdpi: xdpi, ydpi: ydpi, bevelMm: device.bw });
    }
    console.warn('No DPDB device match.');
    return null;
  };
  Dpdb.prototype.ruleMatches_ = function (rule, ua, screenWidth, screenHeight) {
    if (!rule.ua && !rule.res) return false;
    if (rule.ua && rule.ua.substring(0, 2) === 'SM') rule.ua = rule.ua.substring(0, 7);
    if (rule.ua && ua.indexOf(rule.ua) < 0) return false;
    if (rule.res) {
      if (!rule.res[0] || !rule.res[1]) return false;
      var resX = rule.res[0];
      var resY = rule.res[1];
      if (Math.min(screenWidth, screenHeight) != Math.min(resX, resY) || Math.max(screenWidth, screenHeight) != Math.max(resX, resY)) {
        return false;
      }
    }
    return true;
  };
  function DeviceParams(params) {
    this.xdpi = params.xdpi;
    this.ydpi = params.ydpi;
    this.bevelMm = params.bevelMm;
  }
  function SensorSample(sample, timestampS) {
    this.set(sample, timestampS);
  }
  SensorSample.prototype.set = function (sample, timestampS) {
    this.sample = sample;
    this.timestampS = timestampS;
  };
  SensorSample.prototype.copy = function (sensorSample) {
    this.set(sensorSample.sample, sensorSample.timestampS);
  };
  function ComplementaryFilter(kFilter, isDebug) {
    this.kFilter = kFilter;
    this.isDebug = isDebug;
    this.currentAccelMeasurement = new SensorSample();
    this.currentGyroMeasurement = new SensorSample();
    this.previousGyroMeasurement = new SensorSample();
    if (isIOS()) {
      this.filterQ = new Quaternion(-1, 0, 0, 1);
    } else {
      this.filterQ = new Quaternion(1, 0, 0, 1);
    }
    this.previousFilterQ = new Quaternion();
    this.previousFilterQ.copy(this.filterQ);
    this.accelQ = new Quaternion();
    this.isOrientationInitialized = false;
    this.estimatedGravity = new Vector3();
    this.measuredGravity = new Vector3();
    this.gyroIntegralQ = new Quaternion();
  }
  ComplementaryFilter.prototype.addAccelMeasurement = function (vector, timestampS) {
    this.currentAccelMeasurement.set(vector, timestampS);
  };
  ComplementaryFilter.prototype.addGyroMeasurement = function (vector, timestampS) {
    this.currentGyroMeasurement.set(vector, timestampS);
    var deltaT = timestampS - this.previousGyroMeasurement.timestampS;
    if (isTimestampDeltaValid(deltaT)) {
      this.run_();
    }
    this.previousGyroMeasurement.copy(this.currentGyroMeasurement);
  };
  ComplementaryFilter.prototype.run_ = function () {
    if (!this.isOrientationInitialized) {
      this.accelQ = this.accelToQuaternion_(this.currentAccelMeasurement.sample);
      this.previousFilterQ.copy(this.accelQ);
      this.isOrientationInitialized = true;
      return;
    }
    var deltaT = this.currentGyroMeasurement.timestampS - this.previousGyroMeasurement.timestampS;
    var gyroDeltaQ = this.gyroToQuaternionDelta_(this.currentGyroMeasurement.sample, deltaT);
    this.gyroIntegralQ.multiply(gyroDeltaQ);
    this.filterQ.copy(this.previousFilterQ);
    this.filterQ.multiply(gyroDeltaQ);
    var invFilterQ = new Quaternion();
    invFilterQ.copy(this.filterQ);
    invFilterQ.inverse();
    this.estimatedGravity.set(0, 0, -1);
    this.estimatedGravity.applyQuaternion(invFilterQ);
    this.estimatedGravity.normalize();
    this.measuredGravity.copy(this.currentAccelMeasurement.sample);
    this.measuredGravity.normalize();
    var deltaQ = new Quaternion();
    deltaQ.setFromUnitVectors(this.estimatedGravity, this.measuredGravity);
    deltaQ.inverse();
    if (this.isDebug) {
      console.log('Delta: %d deg, G_est: (%s, %s, %s), G_meas: (%s, %s, %s)', radToDeg * getQuaternionAngle(deltaQ), this.estimatedGravity.x.toFixed(1), this.estimatedGravity.y.toFixed(1), this.estimatedGravity.z.toFixed(1), this.measuredGravity.x.toFixed(1), this.measuredGravity.y.toFixed(1), this.measuredGravity.z.toFixed(1));
    }
    var targetQ = new Quaternion();
    targetQ.copy(this.filterQ);
    targetQ.multiply(deltaQ);
    this.filterQ.slerp(targetQ, 1 - this.kFilter);
    this.previousFilterQ.copy(this.filterQ);
  };
  ComplementaryFilter.prototype.getOrientation = function () {
    return this.filterQ;
  };
  ComplementaryFilter.prototype.accelToQuaternion_ = function (accel) {
    var normAccel = new Vector3();
    normAccel.copy(accel);
    normAccel.normalize();
    var quat = new Quaternion();
    quat.setFromUnitVectors(new Vector3(0, 0, -1), normAccel);
    quat.inverse();
    return quat;
  };
  ComplementaryFilter.prototype.gyroToQuaternionDelta_ = function (gyro, dt) {
    var quat = new Quaternion();
    var axis = new Vector3();
    axis.copy(gyro);
    axis.normalize();
    quat.setFromAxisAngle(axis, gyro.length() * dt);
    return quat;
  };
  function PosePredictor(predictionTimeS, isDebug) {
    this.predictionTimeS = predictionTimeS;
    this.isDebug = isDebug;
    this.previousQ = new Quaternion();
    this.previousTimestampS = null;
    this.deltaQ = new Quaternion();
    this.outQ = new Quaternion();
  }
  PosePredictor.prototype.getPrediction = function (currentQ, gyro, timestampS) {
    if (!this.previousTimestampS) {
      this.previousQ.copy(currentQ);
      this.previousTimestampS = timestampS;
      return currentQ;
    }
    var axis = new Vector3();
    axis.copy(gyro);
    axis.normalize();
    var angularSpeed = gyro.length();
    if (angularSpeed < degToRad * 20) {
      if (this.isDebug) {
        console.log('Moving slowly, at %s deg/s: no prediction', (radToDeg * angularSpeed).toFixed(1));
      }
      this.outQ.copy(currentQ);
      this.previousQ.copy(currentQ);
      return this.outQ;
    }
    var predictAngle = angularSpeed * this.predictionTimeS;
    this.deltaQ.setFromAxisAngle(axis, predictAngle);
    this.outQ.copy(this.previousQ);
    this.outQ.multiply(this.deltaQ);
    this.previousQ.copy(currentQ);
    this.previousTimestampS = timestampS;
    return this.outQ;
  };
  function FusionPoseSensor(kFilter, predictionTime, yawOnly, isDebug) {
    this.yawOnly = yawOnly;
    this.accelerometer = new Vector3();
    this.gyroscope = new Vector3();
    this.filter = new ComplementaryFilter(kFilter, isDebug);
    this.posePredictor = new PosePredictor(predictionTime, isDebug);
    this.isFirefoxAndroid = isFirefoxAndroid();
    this.isIOS = isIOS();
    var chromeVersion = getChromeVersion();
    this.isDeviceMotionInRadians = !this.isIOS && chromeVersion && chromeVersion < 66;
    this.isWithoutDeviceMotion = isChromeWithoutDeviceMotion() || isSafariWithoutDeviceMotion();
    this.filterToWorldQ = new Quaternion();
    if (isIOS()) {
      this.filterToWorldQ.setFromAxisAngle(new Vector3(1, 0, 0), Math.PI / 2);
    } else {
      this.filterToWorldQ.setFromAxisAngle(new Vector3(1, 0, 0), -Math.PI / 2);
    }
    this.inverseWorldToScreenQ = new Quaternion();
    this.worldToScreenQ = new Quaternion();
    this.originalPoseAdjustQ = new Quaternion();
    this.originalPoseAdjustQ.setFromAxisAngle(new Vector3(0, 0, 1), -window.orientation * Math.PI / 180);
    this.setScreenTransform_();
    if (isLandscapeMode()) {
      this.filterToWorldQ.multiply(this.inverseWorldToScreenQ);
    }
    this.resetQ = new Quaternion();
    this.orientationOut_ = new Float32Array(4);
    this.start();
  }
  FusionPoseSensor.prototype.getPosition = function () {
    return null;
  };
  FusionPoseSensor.prototype.getOrientation = function () {
    var orientation = void 0;
    if (this.isWithoutDeviceMotion && this._deviceOrientationQ) {
      this.deviceOrientationFixQ = this.deviceOrientationFixQ || function () {
        var z = new Quaternion().setFromAxisAngle(new Vector3(0, 0, -1), 0);
        var y = new Quaternion();
        if (window.orientation === -90) {
          y.setFromAxisAngle(new Vector3(0, 1, 0), Math.PI / -2);
        } else {
          y.setFromAxisAngle(new Vector3(0, 1, 0), Math.PI / 2);
        }
        return z.multiply(y);
      }();
      this.deviceOrientationFilterToWorldQ = this.deviceOrientationFilterToWorldQ || function () {
        var q = new Quaternion();
        q.setFromAxisAngle(new Vector3(1, 0, 0), -Math.PI / 2);
        return q;
      }();
      orientation = this._deviceOrientationQ;
      var out = new Quaternion();
      out.copy(orientation);
      out.multiply(this.deviceOrientationFilterToWorldQ);
      out.multiply(this.resetQ);
      out.multiply(this.worldToScreenQ);
      out.multiplyQuaternions(this.deviceOrientationFixQ, out);
      if (this.yawOnly) {
        out.x = 0;
        out.z = 0;
        out.normalize();
      }
      this.orientationOut_[0] = out.x;
      this.orientationOut_[1] = out.y;
      this.orientationOut_[2] = out.z;
      this.orientationOut_[3] = out.w;
      return this.orientationOut_;
    } else {
      var filterOrientation = this.filter.getOrientation();
      orientation = this.posePredictor.getPrediction(filterOrientation, this.gyroscope, this.previousTimestampS);
    }
    var out = new Quaternion();
    out.copy(this.filterToWorldQ);
    out.multiply(this.resetQ);
    out.multiply(orientation);
    out.multiply(this.worldToScreenQ);
    if (this.yawOnly) {
      out.x = 0;
      out.z = 0;
      out.normalize();
    }
    this.orientationOut_[0] = out.x;
    this.orientationOut_[1] = out.y;
    this.orientationOut_[2] = out.z;
    this.orientationOut_[3] = out.w;
    return this.orientationOut_;
  };
  FusionPoseSensor.prototype.resetPose = function () {
    this.resetQ.copy(this.filter.getOrientation());
    this.resetQ.x = 0;
    this.resetQ.y = 0;
    this.resetQ.z *= -1;
    this.resetQ.normalize();
    if (isLandscapeMode()) {
      this.resetQ.multiply(this.inverseWorldToScreenQ);
    }
    this.resetQ.multiply(this.originalPoseAdjustQ);
  };
  FusionPoseSensor.prototype.onDeviceOrientation_ = function (e) {
    this._deviceOrientationQ = this._deviceOrientationQ || new Quaternion();
    var alpha = e.alpha,
        beta = e.beta,
        gamma = e.gamma;
    alpha = (alpha || 0) * Math.PI / 180;
    beta = (beta || 0) * Math.PI / 180;
    gamma = (gamma || 0) * Math.PI / 180;
    this._deviceOrientationQ.setFromEulerYXZ(beta, alpha, -gamma);
  };
  FusionPoseSensor.prototype.onDeviceMotion_ = function (deviceMotion) {
    this.updateDeviceMotion_(deviceMotion);
  };
  FusionPoseSensor.prototype.updateDeviceMotion_ = function (deviceMotion) {
    var accGravity = deviceMotion.accelerationIncludingGravity;
    var rotRate = deviceMotion.rotationRate;
    var timestampS = deviceMotion.timeStamp / 1000;
    var deltaS = timestampS - this.previousTimestampS;
    if (deltaS < 0) {
      warnOnce('fusion-pose-sensor:invalid:non-monotonic', 'Invalid timestamps detected: non-monotonic timestamp from devicemotion');
      this.previousTimestampS = timestampS;
      return;
    } else if (deltaS <= MIN_TIMESTEP || deltaS > MAX_TIMESTEP) {
      warnOnce('fusion-pose-sensor:invalid:outside-threshold', 'Invalid timestamps detected: Timestamp from devicemotion outside expected range.');
      this.previousTimestampS = timestampS;
      return;
    }
    this.accelerometer.set(-accGravity.x, -accGravity.y, -accGravity.z);
    if (rotRate) {
      if (isR7()) {
        this.gyroscope.set(-rotRate.beta, rotRate.alpha, rotRate.gamma);
      } else {
        this.gyroscope.set(rotRate.alpha, rotRate.beta, rotRate.gamma);
      }
      if (!this.isDeviceMotionInRadians) {
        this.gyroscope.multiplyScalar(Math.PI / 180);
      }
      this.filter.addGyroMeasurement(this.gyroscope, timestampS);
    }
    this.filter.addAccelMeasurement(this.accelerometer, timestampS);
    this.previousTimestampS = timestampS;
  };
  FusionPoseSensor.prototype.onOrientationChange_ = function (screenOrientation) {
    this.setScreenTransform_();
  };
  FusionPoseSensor.prototype.onMessage_ = function (event) {
    var message = event.data;
    if (!message || !message.type) {
      return;
    }
    var type = message.type.toLowerCase();
    if (type !== 'devicemotion') {
      return;
    }
    this.updateDeviceMotion_(message.deviceMotionEvent);
  };
  FusionPoseSensor.prototype.setScreenTransform_ = function () {
    this.worldToScreenQ.set(0, 0, 0, 1);
    switch (window.orientation) {
      case 0:
        break;
      case 90:
        this.worldToScreenQ.setFromAxisAngle(new Vector3(0, 0, 1), -Math.PI / 2);
        break;
      case -90:
        this.worldToScreenQ.setFromAxisAngle(new Vector3(0, 0, 1), Math.PI / 2);
        break;
    }
    this.inverseWorldToScreenQ.copy(this.worldToScreenQ);
    this.inverseWorldToScreenQ.inverse();
  };
  FusionPoseSensor.prototype.start = function () {
    this.onDeviceMotionCallback_ = this.onDeviceMotion_.bind(this);
    this.onOrientationChangeCallback_ = this.onOrientationChange_.bind(this);
    this.onMessageCallback_ = this.onMessage_.bind(this);
    this.onDeviceOrientationCallback_ = this.onDeviceOrientation_.bind(this);
    if (isIOS() && isInsideCrossOriginIFrame()) {
      window.addEventListener('message', this.onMessageCallback_);
    }
    window.addEventListener('orientationchange', this.onOrientationChangeCallback_);
    if (this.isWithoutDeviceMotion) {
      window.addEventListener('deviceorientation', this.onDeviceOrientationCallback_);
    } else {
      window.addEventListener('devicemotion', this.onDeviceMotionCallback_);
    }
  };
  FusionPoseSensor.prototype.stop = function () {
    window.removeEventListener('devicemotion', this.onDeviceMotionCallback_);
    window.removeEventListener('deviceorientation', this.onDeviceOrientationCallback_);
    window.removeEventListener('orientationchange', this.onOrientationChangeCallback_);
    window.removeEventListener('message', this.onMessageCallback_);
  };
  var SENSOR_FREQUENCY = 60;
  var X_AXIS = new Vector3(1, 0, 0);
  var Z_AXIS = new Vector3(0, 0, 1);
  var SENSOR_TO_VR = new Quaternion();
  SENSOR_TO_VR.setFromAxisAngle(X_AXIS, -Math.PI / 2);
  SENSOR_TO_VR.multiply(new Quaternion().setFromAxisAngle(Z_AXIS, Math.PI / 2));
  var PoseSensor = function () {
    function PoseSensor(config) {
      classCallCheck(this, PoseSensor);
      this.config = config;
      this.sensor = null;
      this.fusionSensor = null;
      this._out = new Float32Array(4);
      this.api = null;
      this.errors = [];
      this._sensorQ = new Quaternion();
      this._outQ = new Quaternion();
      this._onSensorRead = this._onSensorRead.bind(this);
      this._onSensorError = this._onSensorError.bind(this);
      this.init();
    }
    createClass(PoseSensor, [{
      key: 'init',
      value: function init() {
        var sensor = null;
        try {
          sensor = new RelativeOrientationSensor({
            frequency: SENSOR_FREQUENCY,
            referenceFrame: 'screen'
          });
          sensor.addEventListener('error', this._onSensorError);
        } catch (error) {
          this.errors.push(error);
          if (error.name === 'SecurityError') {
            console.error('Cannot construct sensors due to the Feature Policy');
            console.warn('Attempting to fall back using "devicemotion"; however this will ' + 'fail in the future without correct permissions.');
            this.useDeviceMotion();
          } else if (error.name === 'ReferenceError') {
            this.useDeviceMotion();
          } else {
            console.error(error);
          }
        }
        if (sensor) {
          this.api = 'sensor';
          this.sensor = sensor;
          this.sensor.addEventListener('reading', this._onSensorRead);
          this.sensor.start();
        }
      }
    }, {
      key: 'useDeviceMotion',
      value: function useDeviceMotion() {
        this.api = 'devicemotion';
        this.fusionSensor = new FusionPoseSensor(this.config.K_FILTER, this.config.PREDICTION_TIME_S, this.config.YAW_ONLY, this.config.DEBUG);
        if (this.sensor) {
          this.sensor.removeEventListener('reading', this._onSensorRead);
          this.sensor.removeEventListener('error', this._onSensorError);
          this.sensor = null;
        }
      }
    }, {
      key: 'getOrientation',
      value: function getOrientation() {
        if (this.fusionSensor) {
          return this.fusionSensor.getOrientation();
        }
        if (!this.sensor || !this.sensor.quaternion) {
          this._out[0] = this._out[1] = this._out[2] = 0;
          this._out[3] = 1;
          return this._out;
        }
        var q = this.sensor.quaternion;
        this._sensorQ.set(q[0], q[1], q[2], q[3]);
        var out = this._outQ;
        out.copy(SENSOR_TO_VR);
        out.multiply(this._sensorQ);
        if (this.config.YAW_ONLY) {
          out.x = out.z = 0;
          out.normalize();
        }
        this._out[0] = out.x;
        this._out[1] = out.y;
        this._out[2] = out.z;
        this._out[3] = out.w;
        return this._out;
      }
    }, {
      key: '_onSensorError',
      value: function _onSensorError(event) {
        this.errors.push(event.error);
        if (event.error.name === 'NotAllowedError') {
          console.error('Permission to access sensor was denied');
        } else if (event.error.name === 'NotReadableError') {
          console.error('Sensor could not be read');
        } else {
          console.error(event.error);
        }
        this.useDeviceMotion();
      }
    }, {
      key: '_onSensorRead',
      value: function _onSensorRead() {}
    }]);
    return PoseSensor;
  }();
  var rotateInstructionsAsset = "<svg width='198' height='240' viewBox='0 0 198 240' xmlns='http://www.w3.org/2000/svg'><g fill='none' fill-rule='evenodd'><path d='M149.625 109.527l6.737 3.891v.886c0 .177.013.36.038.549.01.081.02.162.027.242.14 1.415.974 2.998 2.105 3.999l5.72 5.062.081-.09s4.382-2.53 5.235-3.024l25.97 14.993v54.001c0 .771-.386 1.217-.948 1.217-.233 0-.495-.076-.772-.236l-23.967-13.838-.014.024-27.322 15.775-.85-1.323c-4.731-1.529-9.748-2.74-14.951-3.61a.27.27 0 0 0-.007.024l-5.067 16.961-7.891 4.556-.037-.063v27.59c0 .772-.386 1.217-.948 1.217-.232 0-.495-.076-.772-.236l-42.473-24.522c-.95-.549-1.72-1.877-1.72-2.967v-1.035l-.021.047a5.111 5.111 0 0 0-1.816-.399 5.682 5.682 0 0 0-.546.001 13.724 13.724 0 0 1-1.918-.041c-1.655-.153-3.2-.6-4.404-1.296l-46.576-26.89.005.012-10.278-18.75c-1.001-1.827-.241-4.216 1.698-5.336l56.011-32.345a4.194 4.194 0 0 1 2.099-.572c1.326 0 2.572.659 3.227 1.853l.005-.003.227.413-.006.004a9.63 9.63 0 0 0 1.477 2.018l.277.27c1.914 1.85 4.468 2.801 7.113 2.801 1.949 0 3.948-.517 5.775-1.572.013 0 7.319-4.219 7.319-4.219a4.194 4.194 0 0 1 2.099-.572c1.326 0 2.572.658 3.226 1.853l3.25 5.928.022-.018 6.785 3.917-.105-.182 46.881-26.965m0-1.635c-.282 0-.563.073-.815.218l-46.169 26.556-5.41-3.124-3.005-5.481c-.913-1.667-2.699-2.702-4.66-2.703-1.011 0-2.02.274-2.917.792a3825 3825 0 0 1-7.275 4.195l-.044.024a9.937 9.937 0 0 1-4.957 1.353c-2.292 0-4.414-.832-5.976-2.342l-.252-.245a7.992 7.992 0 0 1-1.139-1.534 1.379 1.379 0 0 0-.06-.122l-.227-.414a1.718 1.718 0 0 0-.095-.154c-.938-1.574-2.673-2.545-4.571-2.545-1.011 0-2.02.274-2.917.792L3.125 155.502c-2.699 1.559-3.738 4.94-2.314 7.538l10.278 18.75c.177.323.448.563.761.704l46.426 26.804c1.403.81 3.157 1.332 5.072 1.508a15.661 15.661 0 0 0 2.146.046 4.766 4.766 0 0 1 .396 0c.096.004.19.011.283.022.109 1.593 1.159 3.323 2.529 4.114l42.472 24.522c.524.302 1.058.455 1.59.455 1.497 0 2.583-1.2 2.583-2.852v-26.562l7.111-4.105a1.64 1.64 0 0 0 .749-.948l4.658-15.593c4.414.797 8.692 1.848 12.742 3.128l.533.829a1.634 1.634 0 0 0 2.193.531l26.532-15.317L193 192.433c.523.302 1.058.455 1.59.455 1.497 0 2.583-1.199 2.583-2.852v-54.001c0-.584-.312-1.124-.818-1.416l-25.97-14.993a1.633 1.633 0 0 0-1.636.001c-.606.351-2.993 1.73-4.325 2.498l-4.809-4.255c-.819-.725-1.461-1.933-1.561-2.936a7.776 7.776 0 0 0-.033-.294 2.487 2.487 0 0 1-.023-.336v-.886c0-.584-.312-1.123-.817-1.416l-6.739-3.891a1.633 1.633 0 0 0-.817-.219' fill='#455A64'/><path d='M96.027 132.636l46.576 26.891c1.204.695 1.979 1.587 2.242 2.541l-.01.007-81.374 46.982h-.001c-1.654-.152-3.199-.6-4.403-1.295l-46.576-26.891 83.546-48.235' fill='#FAFAFA'/><path d='M63.461 209.174c-.008 0-.015 0-.022-.002-1.693-.156-3.228-.609-4.441-1.309l-46.576-26.89a.118.118 0 0 1 0-.203l83.546-48.235a.117.117 0 0 1 .117 0l46.576 26.891c1.227.708 2.021 1.612 2.296 2.611a.116.116 0 0 1-.042.124l-.021.016-81.375 46.981a.11.11 0 0 1-.058.016zm-50.747-28.303l46.401 26.79c1.178.68 2.671 1.121 4.32 1.276l81.272-46.922c-.279-.907-1.025-1.73-2.163-2.387l-46.517-26.857-83.313 48.1z' fill='#607D8B'/><path d='M148.327 165.471a5.85 5.85 0 0 1-.546.001c-1.894-.083-3.302-1.038-3.145-2.132a2.693 2.693 0 0 0-.072-1.105l-81.103 46.822c.628.058 1.272.073 1.918.042.182-.009.364-.009.546-.001 1.894.083 3.302 1.038 3.145 2.132l79.257-45.759' fill='#FFF'/><path d='M69.07 211.347a.118.118 0 0 1-.115-.134c.045-.317-.057-.637-.297-.925-.505-.61-1.555-1.022-2.738-1.074a5.966 5.966 0 0 0-.535.001 14.03 14.03 0 0 1-1.935-.041.117.117 0 0 1-.103-.092.116.116 0 0 1 .055-.126l81.104-46.822a.117.117 0 0 1 .171.07c.104.381.129.768.074 1.153-.045.316.057.637.296.925.506.61 1.555 1.021 2.739 1.073.178.008.357.008.535-.001a.117.117 0 0 1 .064.218l-79.256 45.759a.114.114 0 0 1-.059.016zm-3.405-2.372c.089 0 .177.002.265.006 1.266.056 2.353.488 2.908 1.158.227.274.35.575.36.882l78.685-45.429c-.036 0-.072-.001-.107-.003-1.267-.056-2.354-.489-2.909-1.158-.282-.34-.402-.724-.347-1.107a2.604 2.604 0 0 0-.032-.91L63.846 208.97a13.91 13.91 0 0 0 1.528.012c.097-.005.194-.007.291-.007z' fill='#607D8B'/><path d='M2.208 162.134c-1.001-1.827-.241-4.217 1.698-5.337l56.011-32.344c1.939-1.12 4.324-.546 5.326 1.281l.232.41a9.344 9.344 0 0 0 1.47 2.021l.278.27c3.325 3.214 8.583 3.716 12.888 1.23l7.319-4.22c1.94-1.119 4.324-.546 5.325 1.282l3.25 5.928-83.519 48.229-10.278-18.75z' fill='#FAFAFA'/><path d='M12.486 181.001a.112.112 0 0 1-.031-.005.114.114 0 0 1-.071-.056L2.106 162.19c-1.031-1.88-.249-4.345 1.742-5.494l56.01-32.344a4.328 4.328 0 0 1 2.158-.588c1.415 0 2.65.702 3.311 1.882.01.008.018.017.024.028l.227.414a.122.122 0 0 1 .013.038 9.508 9.508 0 0 0 1.439 1.959l.275.266c1.846 1.786 4.344 2.769 7.031 2.769 1.977 0 3.954-.538 5.717-1.557a.148.148 0 0 1 .035-.013l7.284-4.206a4.321 4.321 0 0 1 2.157-.588c1.427 0 2.672.716 3.329 1.914l3.249 5.929a.116.116 0 0 1-.044.157l-83.518 48.229a.116.116 0 0 1-.059.016zm49.53-57.004c-.704 0-1.41.193-2.041.557l-56.01 32.345c-1.882 1.086-2.624 3.409-1.655 5.179l10.221 18.645 83.317-48.112-3.195-5.829c-.615-1.122-1.783-1.792-3.124-1.792a4.08 4.08 0 0 0-2.04.557l-7.317 4.225a.148.148 0 0 1-.035.013 11.7 11.7 0 0 1-5.801 1.569c-2.748 0-5.303-1.007-7.194-2.835l-.278-.27a9.716 9.716 0 0 1-1.497-2.046.096.096 0 0 1-.013-.037l-.191-.347a.11.11 0 0 1-.023-.029c-.615-1.123-1.783-1.793-3.124-1.793z' fill='#607D8B'/><path d='M42.434 155.808c-2.51-.001-4.697-1.258-5.852-3.365-1.811-3.304-.438-7.634 3.059-9.654l12.291-7.098a7.599 7.599 0 0 1 3.789-1.033c2.51 0 4.697 1.258 5.852 3.365 1.811 3.304.439 7.634-3.059 9.654l-12.291 7.098a7.606 7.606 0 0 1-3.789 1.033zm13.287-20.683a7.128 7.128 0 0 0-3.555.971l-12.291 7.098c-3.279 1.893-4.573 5.942-2.883 9.024 1.071 1.955 3.106 3.122 5.442 3.122a7.13 7.13 0 0 0 3.556-.97l12.291-7.098c3.279-1.893 4.572-5.942 2.883-9.024-1.072-1.955-3.106-3.123-5.443-3.123z' fill='#607D8B'/><path d='M149.588 109.407l6.737 3.89v.887c0 .176.013.36.037.549.011.081.02.161.028.242.14 1.415.973 2.998 2.105 3.999l7.396 6.545c.177.156.358.295.541.415 1.579 1.04 2.95.466 3.062-1.282.049-.784.057-1.595.023-2.429l-.003-.16v-1.151l25.987 15.003v54c0 1.09-.77 1.53-1.72.982l-42.473-24.523c-.95-.548-1.72-1.877-1.72-2.966v-34.033' fill='#FAFAFA'/><path d='M194.553 191.25c-.257 0-.54-.085-.831-.253l-42.472-24.521c-.981-.567-1.779-1.943-1.779-3.068v-34.033h.234v34.033c0 1.051.745 2.336 1.661 2.866l42.473 24.521c.424.245.816.288 1.103.122.285-.164.442-.52.442-1.002v-53.933l-25.753-14.868.003 1.106c.034.832.026 1.654-.024 2.439-.054.844-.396 1.464-.963 1.746-.619.309-1.45.173-2.28-.373a5.023 5.023 0 0 1-.553-.426l-7.397-6.544c-1.158-1.026-1.999-2.625-2.143-4.076a9.624 9.624 0 0 0-.027-.238 4.241 4.241 0 0 1-.038-.564v-.82l-6.68-3.856.117-.202 6.738 3.89.058.034v.954c0 .171.012.351.036.533.011.083.021.165.029.246.138 1.395.948 2.935 2.065 3.923l7.397 6.545c.173.153.35.289.527.406.758.499 1.504.63 2.047.359.49-.243.786-.795.834-1.551.05-.778.057-1.591.024-2.417l-.004-.163v-1.355l.175.1 25.987 15.004.059.033v54.068c0 .569-.198.996-.559 1.204a1.002 1.002 0 0 1-.506.131' fill='#607D8B'/><path d='M145.685 163.161l24.115 13.922-25.978 14.998-1.462-.307c-6.534-2.17-13.628-3.728-21.019-4.616-4.365-.524-8.663 1.096-9.598 3.62a2.746 2.746 0 0 0-.011 1.928c1.538 4.267 4.236 8.363 7.995 12.135l.532.845-25.977 14.997-24.115-13.922 75.518-43.6' fill='#FFF'/><path d='M94.282 220.818l-.059-.033-24.29-14.024.175-.101 75.577-43.634.058.033 24.29 14.024-26.191 15.122-.045-.01-1.461-.307c-6.549-2.174-13.613-3.725-21.009-4.614a13.744 13.744 0 0 0-1.638-.097c-3.758 0-7.054 1.531-7.837 3.642a2.62 2.62 0 0 0-.01 1.848c1.535 4.258 4.216 8.326 7.968 12.091l.016.021.526.835.006.01.064.102-.105.061-25.977 14.998-.058.033zm-23.881-14.057l23.881 13.788 24.802-14.32c.546-.315.846-.489 1.017-.575l-.466-.74c-3.771-3.787-6.467-7.881-8.013-12.168a2.851 2.851 0 0 1 .011-2.008c.815-2.199 4.203-3.795 8.056-3.795.557 0 1.117.033 1.666.099 7.412.891 14.491 2.445 21.041 4.621.836.175 1.215.254 1.39.304l25.78-14.884-23.881-13.788-75.284 43.466z' fill='#607D8B'/><path d='M167.23 125.979v50.871l-27.321 15.773-6.461-14.167c-.91-1.996-3.428-1.738-5.624.574a10.238 10.238 0 0 0-2.33 4.018l-6.46 21.628-27.322 15.774v-50.871l75.518-43.6' fill='#FFF'/><path d='M91.712 220.567a.127.127 0 0 1-.059-.016.118.118 0 0 1-.058-.101v-50.871c0-.042.023-.08.058-.101l75.519-43.6a.117.117 0 0 1 .175.101v50.871c0 .041-.023.08-.059.1l-27.321 15.775a.118.118 0 0 1-.094.01.12.12 0 0 1-.071-.063l-6.46-14.168c-.375-.822-1.062-1.275-1.934-1.275-1.089 0-2.364.686-3.5 1.881a10.206 10.206 0 0 0-2.302 3.972l-6.46 21.627a.118.118 0 0 1-.054.068L91.77 220.551a.12.12 0 0 1-.058.016zm.117-50.92v50.601l27.106-15.65 6.447-21.583a10.286 10.286 0 0 1 2.357-4.065c1.18-1.242 2.517-1.954 3.669-1.954.969 0 1.731.501 2.146 1.411l6.407 14.051 27.152-15.676v-50.601l-75.284 43.466z' fill='#607D8B'/><path d='M168.543 126.213v50.87l-27.322 15.774-6.46-14.168c-.91-1.995-3.428-1.738-5.624.574a10.248 10.248 0 0 0-2.33 4.019l-6.461 21.627-27.321 15.774v-50.87l75.518-43.6' fill='#FFF'/><path d='M93.025 220.8a.123.123 0 0 1-.059-.015.12.12 0 0 1-.058-.101v-50.871c0-.042.023-.08.058-.101l75.518-43.6a.112.112 0 0 1 .117 0c.036.02.059.059.059.1v50.871a.116.116 0 0 1-.059.101l-27.321 15.774a.111.111 0 0 1-.094.01.115.115 0 0 1-.071-.062l-6.46-14.168c-.375-.823-1.062-1.275-1.935-1.275-1.088 0-2.363.685-3.499 1.881a10.19 10.19 0 0 0-2.302 3.971l-6.461 21.628a.108.108 0 0 1-.053.067l-27.322 15.775a.12.12 0 0 1-.058.015zm.117-50.919v50.6l27.106-15.649 6.447-21.584a10.293 10.293 0 0 1 2.357-4.065c1.179-1.241 2.516-1.954 3.668-1.954.969 0 1.732.502 2.147 1.412l6.407 14.051 27.152-15.676v-50.601l-75.284 43.466z' fill='#607D8B'/><path d='M169.8 177.083l-27.322 15.774-6.46-14.168c-.91-1.995-3.428-1.738-5.625.574a10.246 10.246 0 0 0-2.329 4.019l-6.461 21.627-27.321 15.774v-50.87l75.518-43.6v50.87z' fill='#FAFAFA'/><path d='M94.282 220.917a.234.234 0 0 1-.234-.233v-50.871c0-.083.045-.161.117-.202l75.518-43.601a.234.234 0 1 1 .35.202v50.871a.233.233 0 0 1-.116.202l-27.322 15.775a.232.232 0 0 1-.329-.106l-6.461-14.168c-.36-.789-.992-1.206-1.828-1.206-1.056 0-2.301.672-3.415 1.844a10.099 10.099 0 0 0-2.275 3.924l-6.46 21.628a.235.235 0 0 1-.107.136l-27.322 15.774a.23.23 0 0 1-.116.031zm.233-50.969v50.331l26.891-15.525 6.434-21.539a10.41 10.41 0 0 1 2.384-4.112c1.201-1.265 2.569-1.991 3.753-1.991 1.018 0 1.818.526 2.253 1.48l6.354 13.934 26.982-15.578v-50.331l-75.051 43.331z' fill='#607D8B'/><path d='M109.894 199.943c-1.774 0-3.241-.725-4.244-2.12a.224.224 0 0 1 .023-.294.233.233 0 0 1 .301-.023c.78.547 1.705.827 2.75.827 1.323 0 2.754-.439 4.256-1.306 5.311-3.067 9.631-10.518 9.631-16.611 0-1.927-.442-3.56-1.278-4.724a.232.232 0 0 1 .323-.327c1.671 1.172 2.591 3.381 2.591 6.219 0 6.242-4.426 13.863-9.865 17.003-1.574.908-3.084 1.356-4.488 1.356zm-2.969-1.542c.813.651 1.82.877 2.968.877h.001c1.321 0 2.753-.327 4.254-1.194 5.311-3.067 9.632-10.463 9.632-16.556 0-1.979-.463-3.599-1.326-4.761.411 1.035.625 2.275.625 3.635 0 6.243-4.426 13.883-9.865 17.023-1.574.909-3.084 1.317-4.49 1.317-.641 0-1.243-.149-1.799-.341z' fill='#607D8B'/><path d='M113.097 197.23c5.384-3.108 9.748-10.636 9.748-16.814 0-2.051-.483-3.692-1.323-4.86-1.784-1.252-4.374-1.194-7.257.47-5.384 3.108-9.748 10.636-9.748 16.814 0 2.051.483 3.692 1.323 4.86 1.784 1.252 4.374 1.194 7.257-.47' fill='#FAFAFA'/><path d='M108.724 198.614c-1.142 0-2.158-.213-3.019-.817-.021-.014-.04.014-.055-.007-.894-1.244-1.367-2.948-1.367-4.973 0-6.242 4.426-13.864 9.865-17.005 1.574-.908 3.084-1.363 4.49-1.363 1.142 0 2.158.309 3.018.913a.23.23 0 0 1 .056.056c.894 1.244 1.367 2.972 1.367 4.997 0 6.243-4.426 13.783-9.865 16.923-1.574.909-3.084 1.276-4.49 1.276zm-2.718-1.109c.774.532 1.688.776 2.718.776 1.323 0 2.754-.413 4.256-1.28 5.311-3.066 9.631-10.505 9.631-16.598 0-1.909-.434-3.523-1.255-4.685-.774-.533-1.688-.799-2.718-.799-1.323 0-2.755.441-4.256 1.308-5.311 3.066-9.631 10.506-9.631 16.599 0 1.909.434 3.517 1.255 4.679z' fill='#607D8B'/><path d='M149.318 114.262l-9.984 8.878 15.893 11.031 5.589-6.112-11.498-13.797' fill='#FAFAFA'/><path d='M169.676 120.84l-9.748 5.627c-3.642 2.103-9.528 2.113-13.147.024-3.62-2.089-3.601-5.488.041-7.591l9.495-5.608-6.729-3.885-81.836 47.071 45.923 26.514 3.081-1.779c.631-.365.869-.898.618-1.39-2.357-4.632-2.593-9.546-.683-14.262 5.638-13.92 24.509-24.815 48.618-28.07 8.169-1.103 16.68-.967 24.704.394.852.145 1.776.008 2.407-.357l3.081-1.778-25.825-14.91' fill='#FAFAFA'/><path d='M113.675 183.459a.47.47 0 0 1-.233-.062l-45.924-26.515a.468.468 0 0 1 .001-.809l81.836-47.071a.467.467 0 0 1 .466 0l6.729 3.885a.467.467 0 0 1-.467.809l-6.496-3.75-80.9 46.533 44.988 25.973 2.848-1.644c.192-.111.62-.409.435-.773-2.416-4.748-2.658-9.814-.7-14.65 2.806-6.927 8.885-13.242 17.582-18.263 8.657-4.998 19.518-8.489 31.407-10.094 8.198-1.107 16.79-.97 24.844.397.739.125 1.561.007 2.095-.301l2.381-1.374-25.125-14.506a.467.467 0 0 1 .467-.809l25.825 14.91a.467.467 0 0 1 0 .809l-3.081 1.779c-.721.417-1.763.575-2.718.413-7.963-1.351-16.457-1.486-24.563-.392-11.77 1.589-22.512 5.039-31.065 9.977-8.514 4.916-14.456 11.073-17.183 17.805-1.854 4.578-1.623 9.376.666 13.875.37.725.055 1.513-.8 2.006l-3.081 1.78a.476.476 0 0 1-.234.062' fill='#455A64'/><path d='M153.316 128.279c-2.413 0-4.821-.528-6.652-1.586-1.818-1.049-2.82-2.461-2.82-3.975 0-1.527 1.016-2.955 2.861-4.02l9.493-5.607a.233.233 0 1 1 .238.402l-9.496 5.609c-1.696.979-2.628 2.263-2.628 3.616 0 1.34.918 2.608 2.585 3.571 3.549 2.049 9.343 2.038 12.914-.024l9.748-5.628a.234.234 0 0 1 .234.405l-9.748 5.628c-1.858 1.072-4.296 1.609-6.729 1.609' fill='#607D8B'/><path d='M113.675 182.992l-45.913-26.508M113.675 183.342a.346.346 0 0 1-.175-.047l-45.913-26.508a.35.35 0 1 1 .35-.607l45.913 26.508a.35.35 0 0 1-.175.654' fill='#455A64'/><path d='M67.762 156.484v54.001c0 1.09.77 2.418 1.72 2.967l42.473 24.521c.95.549 1.72.11 1.72-.98v-54.001' fill='#FAFAFA'/><path d='M112.727 238.561c-.297 0-.62-.095-.947-.285l-42.473-24.521c-1.063-.613-1.895-2.05-1.895-3.27v-54.001a.35.35 0 1 1 .701 0v54.001c0 .96.707 2.18 1.544 2.663l42.473 24.522c.344.198.661.243.87.122.206-.119.325-.411.325-.799v-54.001a.35.35 0 1 1 .7 0v54.001c0 .655-.239 1.154-.675 1.406a1.235 1.235 0 0 1-.623.162' fill='#455A64'/><path d='M112.86 147.512h-.001c-2.318 0-4.499-.522-6.142-1.471-1.705-.984-2.643-2.315-2.643-3.749 0-1.445.952-2.791 2.68-3.788l12.041-6.953c1.668-.962 3.874-1.493 6.212-1.493 2.318 0 4.499.523 6.143 1.472 1.704.984 2.643 2.315 2.643 3.748 0 1.446-.952 2.791-2.68 3.789l-12.042 6.952c-1.668.963-3.874 1.493-6.211 1.493zm12.147-16.753c-2.217 0-4.298.497-5.861 1.399l-12.042 6.952c-1.502.868-2.33 1.998-2.33 3.182 0 1.173.815 2.289 2.293 3.142 1.538.889 3.596 1.378 5.792 1.378h.001c2.216 0 4.298-.497 5.861-1.399l12.041-6.953c1.502-.867 2.33-1.997 2.33-3.182 0-1.172-.814-2.288-2.292-3.142-1.539-.888-3.596-1.377-5.793-1.377z' fill='#607D8B'/><path d='M165.63 123.219l-5.734 3.311c-3.167 1.828-8.286 1.837-11.433.02-3.147-1.817-3.131-4.772.036-6.601l5.734-3.31 11.397 6.58' fill='#FAFAFA'/><path d='M154.233 117.448l9.995 5.771-4.682 2.704c-1.434.827-3.352 1.283-5.399 1.283-2.029 0-3.923-.449-5.333-1.263-1.29-.744-2-1.694-2-2.674 0-.991.723-1.955 2.036-2.713l5.383-3.108m0-.809l-5.734 3.31c-3.167 1.829-3.183 4.784-.036 6.601 1.568.905 3.623 1.357 5.684 1.357 2.077 0 4.159-.46 5.749-1.377l5.734-3.311-11.397-6.58M145.445 179.667c-1.773 0-3.241-.85-4.243-2.245-.067-.092-.057-.275.023-.356.08-.081.207-.12.3-.055.781.548 1.706.812 2.751.811 1.322 0 2.754-.446 4.256-1.313 5.31-3.066 9.631-10.522 9.631-16.615 0-1.927-.442-3.562-1.279-4.726a.235.235 0 0 1 .024-.301.232.232 0 0 1 .3-.027c1.67 1.172 2.59 3.38 2.59 6.219 0 6.242-4.425 13.987-9.865 17.127-1.573.908-3.083 1.481-4.488 1.481zM142.476 178c.814.651 1.82 1.002 2.969 1.002 1.322 0 2.753-.452 4.255-1.32 5.31-3.065 9.631-10.523 9.631-16.617 0-1.98-.463-3.63-1.325-4.793.411 1.035.624 2.26.624 3.62 0 6.242-4.425 13.875-9.865 17.015-1.573.909-3.084 1.376-4.489 1.376a5.49 5.49 0 0 1-1.8-.283z' fill='#607D8B'/><path d='M148.648 176.704c5.384-3.108 9.748-10.636 9.748-16.813 0-2.052-.483-3.693-1.322-4.861-1.785-1.252-4.375-1.194-7.258.471-5.383 3.108-9.748 10.636-9.748 16.813 0 2.051.484 3.692 1.323 4.86 1.785 1.253 4.374 1.195 7.257-.47' fill='#FAFAFA'/><path d='M144.276 178.276c-1.143 0-2.158-.307-3.019-.911a.217.217 0 0 1-.055-.054c-.895-1.244-1.367-2.972-1.367-4.997 0-6.241 4.425-13.875 9.865-17.016 1.573-.908 3.084-1.369 4.489-1.369 1.143 0 2.158.307 3.019.91a.24.24 0 0 1 .055.055c.894 1.244 1.367 2.971 1.367 4.997 0 6.241-4.425 13.875-9.865 17.016-1.573.908-3.084 1.369-4.489 1.369zm-2.718-1.172c.773.533 1.687.901 2.718.901 1.322 0 2.754-.538 4.256-1.405 5.31-3.066 9.631-10.567 9.631-16.661 0-1.908-.434-3.554-1.256-4.716-.774-.532-1.688-.814-2.718-.814-1.322 0-2.754.433-4.256 1.3-5.31 3.066-9.631 10.564-9.631 16.657 0 1.91.434 3.576 1.256 4.738z' fill='#607D8B'/><path d='M150.72 172.361l-.363-.295a24.105 24.105 0 0 0 2.148-3.128 24.05 24.05 0 0 0 1.977-4.375l.443.149a24.54 24.54 0 0 1-2.015 4.46 24.61 24.61 0 0 1-2.19 3.189M115.917 191.514l-.363-.294a24.174 24.174 0 0 0 2.148-3.128 24.038 24.038 0 0 0 1.976-4.375l.443.148a24.48 24.48 0 0 1-2.015 4.461 24.662 24.662 0 0 1-2.189 3.188M114 237.476V182.584 237.476' fill='#607D8B'/><g><path d='M81.822 37.474c.017-.135-.075-.28-.267-.392-.327-.188-.826-.21-1.109-.045l-6.012 3.471c-.131.076-.194.178-.191.285.002.132.002.461.002.578v.043l-.007.128-6.591 3.779c-.001 0-2.077 1.046-2.787 5.192 0 0-.912 6.961-.898 19.745.015 12.57.606 17.07 1.167 21.351.22 1.684 3.001 2.125 3.001 2.125.331.04.698-.027 1.08-.248l75.273-43.551c1.808-1.069 2.667-3.719 3.056-6.284 1.213-7.99 1.675-32.978-.275-39.878-.196-.693-.51-1.083-.868-1.282l-2.086-.79c-.727.028-1.416.467-1.534.535L82.032 37.072l-.21.402' fill='#FFF'/><path d='M144.311 1.701l2.085.79c.358.199.672.589.868 1.282 1.949 6.9 1.487 31.887.275 39.878-.39 2.565-1.249 5.215-3.056 6.284L69.21 93.486a1.78 1.78 0 0 1-.896.258l-.183-.011c0 .001-2.782-.44-3.003-2.124-.56-4.282-1.151-8.781-1.165-21.351-.015-12.784.897-19.745.897-19.745.71-4.146 2.787-5.192 2.787-5.192l6.591-3.779.007-.128v-.043c0-.117 0-.446-.002-.578-.003-.107.059-.21.191-.285l6.012-3.472a.98.98 0 0 1 .481-.11c.218 0 .449.053.627.156.193.112.285.258.268.392l.211-.402 60.744-34.836c.117-.068.806-.507 1.534-.535m0-.997l-.039.001c-.618.023-1.283.244-1.974.656l-.021.012-60.519 34.706a2.358 2.358 0 0 0-.831-.15c-.365 0-.704.084-.98.244l-6.012 3.471c-.442.255-.699.69-.689 1.166l.001.15-6.08 3.487c-.373.199-2.542 1.531-3.29 5.898l-.006.039c-.009.07-.92 7.173-.906 19.875.014 12.62.603 17.116 1.172 21.465l.002.015c.308 2.355 3.475 2.923 3.836 2.98l.034.004c.101.013.204.019.305.019a2.77 2.77 0 0 0 1.396-.392l75.273-43.552c1.811-1.071 2.999-3.423 3.542-6.997 1.186-7.814 1.734-33.096-.301-40.299-.253-.893-.704-1.527-1.343-1.882l-.132-.062-2.085-.789a.973.973 0 0 0-.353-.065' fill='#455A64'/><path d='M128.267 11.565l1.495.434-56.339 32.326' fill='#FFF'/><path d='M74.202 90.545a.5.5 0 0 1-.25-.931l18.437-10.645a.499.499 0 1 1 .499.864L74.451 90.478l-.249.067M75.764 42.654l-.108-.062.046-.171 5.135-2.964.17.045-.045.171-5.135 2.964-.063.017M70.52 90.375V46.421l.063-.036L137.84 7.554v43.954l-.062.036L70.52 90.375zm.25-43.811v43.38l66.821-38.579V7.985L70.77 46.564z' fill='#607D8B'/><path d='M86.986 83.182c-.23.149-.612.384-.849.523l-11.505 6.701c-.237.139-.206.252.068.252h.565c.275 0 .693-.113.93-.252L87.7 83.705c.237-.139.428-.253.425-.256a11.29 11.29 0 0 1-.006-.503c0-.274-.188-.377-.418-.227l-.715.463' fill='#607D8B'/><path d='M75.266 90.782H74.7c-.2 0-.316-.056-.346-.166-.03-.11.043-.217.215-.317l11.505-6.702c.236-.138.615-.371.844-.519l.715-.464a.488.488 0 0 1 .266-.089c.172 0 .345.13.345.421 0 .214.001.363.003.437l.006.004-.004.069c-.003.075-.003.075-.486.356l-11.505 6.702a2.282 2.282 0 0 1-.992.268zm-.6-.25l.034.001h.566c.252 0 .649-.108.866-.234l11.505-6.702c.168-.098.294-.173.361-.214-.004-.084-.004-.218-.004-.437l-.095-.171-.131.049-.714.463c-.232.15-.616.386-.854.525l-11.505 6.702-.029.018z' fill='#607D8B'/><path d='M75.266 89.871H74.7c-.2 0-.316-.056-.346-.166-.03-.11.043-.217.215-.317l11.505-6.702c.258-.151.694-.268.993-.268h.565c.2 0 .316.056.346.166.03.11-.043.217-.215.317l-11.505 6.702a2.282 2.282 0 0 1-.992.268zm-.6-.25l.034.001h.566c.252 0 .649-.107.866-.234l11.505-6.702.03-.018-.035-.001h-.565c-.252 0-.649.108-.867.234l-11.505 6.702-.029.018zM74.37 90.801v-1.247 1.247' fill='#607D8B'/><path d='M68.13 93.901c-.751-.093-1.314-.737-1.439-1.376-.831-4.238-1.151-8.782-1.165-21.352-.015-12.784.897-19.745.897-19.745.711-4.146 2.787-5.192 2.787-5.192l74.859-43.219c.223-.129 2.487-1.584 3.195.923 1.95 6.9 1.488 31.887.275 39.878-.389 2.565-1.248 5.215-3.056 6.283L69.21 93.653c-.382.221-.749.288-1.08.248 0 0-2.781-.441-3.001-2.125-.561-4.281-1.152-8.781-1.167-21.351-.014-12.784.898-19.745.898-19.745.71-4.146 2.787-5.191 2.787-5.191l6.598-3.81.871-.119 6.599-3.83.046-.461L68.13 93.901' fill='#FAFAFA'/><path d='M68.317 94.161l-.215-.013h-.001l-.244-.047c-.719-.156-2.772-.736-2.976-2.292-.568-4.34-1.154-8.813-1.168-21.384-.014-12.654.891-19.707.9-19.777.725-4.231 2.832-5.338 2.922-5.382l6.628-3.827.87-.119 6.446-3.742.034-.334a.248.248 0 0 1 .273-.223.248.248 0 0 1 .223.272l-.059.589-6.752 3.919-.87.118-6.556 3.785c-.031.016-1.99 1.068-2.666 5.018-.007.06-.908 7.086-.894 19.702.014 12.539.597 16.996 1.161 21.305.091.691.689 1.154 1.309 1.452a1.95 1.95 0 0 1-.236-.609c-.781-3.984-1.155-8.202-1.17-21.399-.014-12.653.891-19.707.9-19.777.725-4.231 2.832-5.337 2.922-5.382-.004.001 74.444-42.98 74.846-43.212l.028-.017c.904-.538 1.72-.688 2.36-.433.555.221.949.733 1.172 1.52 2.014 7.128 1.46 32.219.281 39.983-.507 3.341-1.575 5.515-3.175 6.462L69.335 93.869a2.023 2.023 0 0 1-1.018.292zm-.147-.507c.293.036.604-.037.915-.217l75.273-43.551c1.823-1.078 2.602-3.915 2.934-6.106 1.174-7.731 1.731-32.695-.268-39.772-.178-.631-.473-1.032-.876-1.192-.484-.193-1.166-.052-1.921.397l-.034.021-74.858 43.218c-.031.017-1.989 1.069-2.666 5.019-.007.059-.908 7.085-.894 19.702.015 13.155.386 17.351 1.161 21.303.09.461.476.983 1.037 1.139.114.025.185.037.196.039h.001z' fill='#455A64'/><path d='M69.317 68.982c.489-.281.885-.056.885.505 0 .56-.396 1.243-.885 1.525-.488.282-.884.057-.884-.504 0-.56.396-1.243.884-1.526' fill='#FFF'/><path d='M68.92 71.133c-.289 0-.487-.228-.487-.625 0-.56.396-1.243.884-1.526a.812.812 0 0 1 .397-.121c.289 0 .488.229.488.626 0 .56-.396 1.243-.885 1.525a.812.812 0 0 1-.397.121m.794-2.459a.976.976 0 0 0-.49.147c-.548.317-.978 1.058-.978 1.687 0 .486.271.812.674.812a.985.985 0 0 0 .491-.146c.548-.317.978-1.057.978-1.687 0-.486-.272-.813-.675-.813' fill='#8097A2'/><path d='M68.92 70.947c-.271 0-.299-.307-.299-.439 0-.491.361-1.116.79-1.363a.632.632 0 0 1 .303-.096c.272 0 .301.306.301.438 0 .491-.363 1.116-.791 1.364a.629.629 0 0 1-.304.096m.794-2.086a.812.812 0 0 0-.397.121c-.488.283-.884.966-.884 1.526 0 .397.198.625.487.625a.812.812 0 0 0 .397-.121c.489-.282.885-.965.885-1.525 0-.397-.199-.626-.488-.626' fill='#8097A2'/><path d='M69.444 85.35c.264-.152.477-.031.477.272 0 .303-.213.67-.477.822-.263.153-.477.031-.477-.271 0-.302.214-.671.477-.823' fill='#FFF'/><path d='M69.23 86.51c-.156 0-.263-.123-.263-.337 0-.302.214-.671.477-.823a.431.431 0 0 1 .214-.066c.156 0 .263.124.263.338 0 .303-.213.67-.477.822a.431.431 0 0 1-.214.066m.428-1.412c-.1 0-.203.029-.307.09-.32.185-.57.618-.57.985 0 .309.185.524.449.524a.63.63 0 0 0 .308-.09c.32-.185.57-.618.57-.985 0-.309-.185-.524-.45-.524' fill='#8097A2'/><path d='M69.23 86.322l-.076-.149c0-.235.179-.544.384-.661l.12-.041.076.151c0 .234-.179.542-.383.66l-.121.04m.428-1.038a.431.431 0 0 0-.214.066c-.263.152-.477.521-.477.823 0 .214.107.337.263.337a.431.431 0 0 0 .214-.066c.264-.152.477-.519.477-.822 0-.214-.107-.338-.263-.338' fill='#8097A2'/><path d='M139.278 7.769v43.667L72.208 90.16V46.493l67.07-38.724' fill='#455A64'/><path d='M72.083 90.375V46.421l.063-.036 67.257-38.831v43.954l-.062.036-67.258 38.831zm.25-43.811v43.38l66.821-38.579V7.985L72.333 46.564z' fill='#607D8B'/></g><path d='M125.737 88.647l-7.639 3.334V84l-11.459 4.713v8.269L99 100.315l13.369 3.646 13.368-15.314' fill='#455A64'/></g></svg>";
  function RotateInstructions() {
    this.loadIcon_();
    var overlay = document.createElement('div');
    var s = overlay.style;
    s.position = 'fixed';
    s.top = 0;
    s.right = 0;
    s.bottom = 0;
    s.left = 0;
    s.backgroundColor = 'gray';
    s.fontFamily = 'sans-serif';
    s.zIndex = 1000000;
    var img = document.createElement('img');
    img.src = this.icon;
    var s = img.style;
    s.marginLeft = '25%';
    s.marginTop = '25%';
    s.width = '50%';
    overlay.appendChild(img);
    var text = document.createElement('div');
    var s = text.style;
    s.textAlign = 'center';
    s.fontSize = '16px';
    s.lineHeight = '24px';
    s.margin = '24px 25%';
    s.width = '50%';
    text.innerHTML = 'Place your phone into your Cardboard viewer.';
    overlay.appendChild(text);
    var snackbar = document.createElement('div');
    var s = snackbar.style;
    s.backgroundColor = '#CFD8DC';
    s.position = 'fixed';
    s.bottom = 0;
    s.width = '100%';
    s.height = '48px';
    s.padding = '14px 24px';
    s.boxSizing = 'border-box';
    s.color = '#656A6B';
    overlay.appendChild(snackbar);
    var snackbarText = document.createElement('div');
    snackbarText.style.float = 'left';
    snackbarText.innerHTML = 'No Cardboard viewer?';
    var snackbarButton = document.createElement('a');
    snackbarButton.href = 'https://www.google.com/get/cardboard/get-cardboard/';
    snackbarButton.innerHTML = 'get one';
    snackbarButton.target = '_blank';
    var s = snackbarButton.style;
    s.float = 'right';
    s.fontWeight = 600;
    s.textTransform = 'uppercase';
    s.borderLeft = '1px solid gray';
    s.paddingLeft = '24px';
    s.textDecoration = 'none';
    s.color = '#656A6B';
    snackbar.appendChild(snackbarText);
    snackbar.appendChild(snackbarButton);
    this.overlay = overlay;
    this.text = text;
    this.hide();
  }
  RotateInstructions.prototype.show = function (parent) {
    if (!parent && !this.overlay.parentElement) {
      document.body.appendChild(this.overlay);
    } else if (parent) {
      if (this.overlay.parentElement && this.overlay.parentElement != parent) this.overlay.parentElement.removeChild(this.overlay);
      parent.appendChild(this.overlay);
    }
    this.overlay.style.display = 'block';
    var img = this.overlay.querySelector('img');
    var s = img.style;
    if (isLandscapeMode()) {
      s.width = '20%';
      s.marginLeft = '40%';
      s.marginTop = '3%';
    } else {
      s.width = '50%';
      s.marginLeft = '25%';
      s.marginTop = '25%';
    }
  };
  RotateInstructions.prototype.hide = function () {
    this.overlay.style.display = 'none';
  };
  RotateInstructions.prototype.showTemporarily = function (ms, parent) {
    this.show(parent);
    this.timer = setTimeout(this.hide.bind(this), ms);
  };
  RotateInstructions.prototype.disableShowTemporarily = function () {
    clearTimeout(this.timer);
  };
  RotateInstructions.prototype.update = function () {
    this.disableShowTemporarily();
    if (!isLandscapeMode() && isMobile()) {
      this.show();
    } else {
      this.hide();
    }
  };
  RotateInstructions.prototype.loadIcon_ = function () {
    this.icon = dataUri('image/svg+xml', rotateInstructionsAsset);
  };
  var DEFAULT_VIEWER = 'CardboardV1';
  var VIEWER_KEY = 'WEBVR_CARDBOARD_VIEWER';
  var CLASS_NAME = 'webvr-polyfill-viewer-selector';
  function ViewerSelector(defaultViewer) {
    try {
      this.selectedKey = localStorage.getItem(VIEWER_KEY);
    } catch (error) {
      console.error('Failed to load viewer profile: %s', error);
    }
    if (!this.selectedKey) {
      this.selectedKey = defaultViewer || DEFAULT_VIEWER;
    }
    this.dialog = this.createDialog_(DeviceInfo.Viewers);
    this.root = null;
    this.onChangeCallbacks_ = [];
  }
  ViewerSelector.prototype.show = function (root) {
    this.root = root;
    root.appendChild(this.dialog);
    var selected = this.dialog.querySelector('#' + this.selectedKey);
    selected.checked = true;
    this.dialog.style.display = 'block';
  };
  ViewerSelector.prototype.hide = function () {
    if (this.root && this.root.contains(this.dialog)) {
      this.root.removeChild(this.dialog);
    }
    this.dialog.style.display = 'none';
  };
  ViewerSelector.prototype.getCurrentViewer = function () {
    return DeviceInfo.Viewers[this.selectedKey];
  };
  ViewerSelector.prototype.getSelectedKey_ = function () {
    var input = this.dialog.querySelector('input[name=field]:checked');
    if (input) {
      return input.id;
    }
    return null;
  };
  ViewerSelector.prototype.onChange = function (cb) {
    this.onChangeCallbacks_.push(cb);
  };
  ViewerSelector.prototype.fireOnChange_ = function (viewer) {
    for (var i = 0; i < this.onChangeCallbacks_.length; i++) {
      this.onChangeCallbacks_[i](viewer);
    }
  };
  ViewerSelector.prototype.onSave_ = function () {
    this.selectedKey = this.getSelectedKey_();
    if (!this.selectedKey || !DeviceInfo.Viewers[this.selectedKey]) {
      console.error('ViewerSelector.onSave_: this should never happen!');
      return;
    }
    this.fireOnChange_(DeviceInfo.Viewers[this.selectedKey]);
    try {
      localStorage.setItem(VIEWER_KEY, this.selectedKey);
    } catch (error) {
      console.error('Failed to save viewer profile: %s', error);
    }
    this.hide();
  };
  ViewerSelector.prototype.createDialog_ = function (options) {
    var container = document.createElement('div');
    container.classList.add(CLASS_NAME);
    container.style.display = 'none';
    var overlay = document.createElement('div');
    var s = overlay.style;
    s.position = 'fixed';
    s.left = 0;
    s.top = 0;
    s.width = '100%';
    s.height = '100%';
    s.background = 'rgba(0, 0, 0, 0.3)';
    overlay.addEventListener('click', this.hide.bind(this));
    var width = 280;
    var dialog = document.createElement('div');
    var s = dialog.style;
    s.boxSizing = 'border-box';
    s.position = 'fixed';
    s.top = '24px';
    s.left = '50%';
    s.marginLeft = -width / 2 + 'px';
    s.width = width + 'px';
    s.padding = '24px';
    s.overflow = 'hidden';
    s.background = '#fafafa';
    s.fontFamily = "'Roboto', sans-serif";
    s.boxShadow = '0px 5px 20px #666';
    dialog.appendChild(this.createH1_('Select your viewer'));
    for (var id in options) {
      dialog.appendChild(this.createChoice_(id, options[id].label));
    }
    dialog.appendChild(this.createButton_('Save', this.onSave_.bind(this)));
    container.appendChild(overlay);
    container.appendChild(dialog);
    return container;
  };
  ViewerSelector.prototype.createH1_ = function (name) {
    var h1 = document.createElement('h1');
    var s = h1.style;
    s.color = 'black';
    s.fontSize = '20px';
    s.fontWeight = 'bold';
    s.marginTop = 0;
    s.marginBottom = '24px';
    h1.innerHTML = name;
    return h1;
  };
  ViewerSelector.prototype.createChoice_ = function (id, name) {
    var div = document.createElement('div');
    div.style.marginTop = '8px';
    div.style.color = 'black';
    var input = document.createElement('input');
    input.style.fontSize = '30px';
    input.setAttribute('id', id);
    input.setAttribute('type', 'radio');
    input.setAttribute('value', id);
    input.setAttribute('name', 'field');
    var label = document.createElement('label');
    label.style.marginLeft = '4px';
    label.setAttribute('for', id);
    label.innerHTML = name;
    div.appendChild(input);
    div.appendChild(label);
    return div;
  };
  ViewerSelector.prototype.createButton_ = function (label, onclick) {
    var button = document.createElement('button');
    button.innerHTML = label;
    var s = button.style;
    s.float = 'right';
    s.textTransform = 'uppercase';
    s.color = '#1094f7';
    s.fontSize = '14px';
    s.letterSpacing = 0;
    s.border = 0;
    s.background = 'none';
    s.marginTop = '16px';
    button.addEventListener('click', onclick);
    return button;
  };
  var commonjsGlobal$$1 = typeof window !== 'undefined' ? window : typeof commonjsGlobal$1 !== 'undefined' ? commonjsGlobal$1 : typeof self !== 'undefined' ? self : {};
  function unwrapExports$$1 (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }
  function createCommonjsModule$$1(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }
  var NoSleep = createCommonjsModule$$1(function (module, exports) {
  (function webpackUniversalModuleDefinition(root, factory) {
  	module.exports = factory();
  })(commonjsGlobal$$1, function() {
  return          (function(modules) {
           	var installedModules = {};
           	function __webpack_require__(moduleId) {
           		if(installedModules[moduleId]) {
           			return installedModules[moduleId].exports;
           		}
           		var module = installedModules[moduleId] = {
           			i: moduleId,
           			l: false,
           			exports: {}
           		};
           		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
           		module.l = true;
           		return module.exports;
           	}
           	__webpack_require__.m = modules;
           	__webpack_require__.c = installedModules;
           	__webpack_require__.d = function(exports, name, getter) {
           		if(!__webpack_require__.o(exports, name)) {
           			Object.defineProperty(exports, name, {
           				configurable: false,
           				enumerable: true,
           				get: getter
           			});
           		}
           	};
           	__webpack_require__.n = function(module) {
           		var getter = module && module.__esModule ?
           			function getDefault() { return module['default']; } :
           			function getModuleExports() { return module; };
           		__webpack_require__.d(getter, 'a', getter);
           		return getter;
           	};
           	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
           	__webpack_require__.p = "";
           	return __webpack_require__(__webpack_require__.s = 0);
           })
           ([
        (function(module, exports, __webpack_require__) {
  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();
  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
  var mediaFile = __webpack_require__(1);
  var oldIOS = typeof navigator !== 'undefined' && parseFloat(('' + (/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0, ''])[1]).replace('undefined', '3_2').replace('_', '.').replace('_', '')) < 10 && !window.MSStream;
  var NoSleep = function () {
    function NoSleep() {
      _classCallCheck(this, NoSleep);
      if (oldIOS) {
        this.noSleepTimer = null;
      } else {
        this.noSleepVideo = document.createElement('video');
        this.noSleepVideo.setAttribute('playsinline', '');
        this.noSleepVideo.setAttribute('src', mediaFile);
        this.noSleepVideo.addEventListener('timeupdate', function (e) {
          if (this.noSleepVideo.currentTime > 0.5) {
            this.noSleepVideo.currentTime = Math.random();
          }
        }.bind(this));
      }
    }
    _createClass(NoSleep, [{
      key: 'enable',
      value: function enable() {
        if (oldIOS) {
          this.disable();
          this.noSleepTimer = window.setInterval(function () {
            window.location.href = '/';
            window.setTimeout(window.stop, 0);
          }, 15000);
        } else {
          this.noSleepVideo.play();
        }
      }
    }, {
      key: 'disable',
      value: function disable() {
        if (oldIOS) {
          if (this.noSleepTimer) {
            window.clearInterval(this.noSleepTimer);
            this.noSleepTimer = null;
          }
        } else {
          this.noSleepVideo.pause();
        }
      }
    }]);
    return NoSleep;
  }();
  module.exports = NoSleep;
        }),
        (function(module, exports, __webpack_require__) {
  module.exports = 'data:video/mp4;base64,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';
        })
           ]);
  });
  });
  var NoSleep$1 = unwrapExports$$1(NoSleep);
  var nextDisplayId = 1000;
  var defaultLeftBounds = [0, 0, 0.5, 1];
  var defaultRightBounds = [0.5, 0, 0.5, 1];
  var raf = window.requestAnimationFrame;
  var caf = window.cancelAnimationFrame;
  function VRFrameData() {
    this.leftProjectionMatrix = new Float32Array(16);
    this.leftViewMatrix = new Float32Array(16);
    this.rightProjectionMatrix = new Float32Array(16);
    this.rightViewMatrix = new Float32Array(16);
    this.pose = null;
  }
  function VRDisplayCapabilities(config) {
    Object.defineProperties(this, {
      hasPosition: {
        writable: false, enumerable: true, value: config.hasPosition
      },
      hasExternalDisplay: {
        writable: false, enumerable: true, value: config.hasExternalDisplay
      },
      canPresent: {
        writable: false, enumerable: true, value: config.canPresent
      },
      maxLayers: {
        writable: false, enumerable: true, value: config.maxLayers
      },
      hasOrientation: {
        enumerable: true, get: function get() {
          deprecateWarning('VRDisplayCapabilities.prototype.hasOrientation', 'VRDisplay.prototype.getFrameData');
          return config.hasOrientation;
        }
      }
    });
  }
  function VRDisplay(config) {
    config = config || {};
    var USE_WAKELOCK = 'wakelock' in config ? config.wakelock : true;
    this.isPolyfilled = true;
    this.displayId = nextDisplayId++;
    this.displayName = '';
    this.depthNear = 0.01;
    this.depthFar = 10000.0;
    this.isPresenting = false;
    Object.defineProperty(this, 'isConnected', {
      get: function get() {
        deprecateWarning('VRDisplay.prototype.isConnected', 'VRDisplayCapabilities.prototype.hasExternalDisplay');
        return false;
      }
    });
    this.capabilities = new VRDisplayCapabilities({
      hasPosition: false,
      hasOrientation: false,
      hasExternalDisplay: false,
      canPresent: false,
      maxLayers: 1
    });
    this.stageParameters = null;
    this.waitingForPresent_ = false;
    this.layer_ = null;
    this.originalParent_ = null;
    this.fullscreenElement_ = null;
    this.fullscreenWrapper_ = null;
    this.fullscreenElementCachedStyle_ = null;
    this.fullscreenEventTarget_ = null;
    this.fullscreenChangeHandler_ = null;
    this.fullscreenErrorHandler_ = null;
    if (USE_WAKELOCK && isMobile()) {
      this.wakelock_ = new NoSleep$1();
    }
  }
  VRDisplay.prototype.getFrameData = function (frameData) {
    return frameDataFromPose(frameData, this._getPose(), this);
  };
  VRDisplay.prototype.getPose = function () {
    deprecateWarning('VRDisplay.prototype.getPose', 'VRDisplay.prototype.getFrameData');
    return this._getPose();
  };
  VRDisplay.prototype.resetPose = function () {
    deprecateWarning('VRDisplay.prototype.resetPose');
    return this._resetPose();
  };
  VRDisplay.prototype.getImmediatePose = function () {
    deprecateWarning('VRDisplay.prototype.getImmediatePose', 'VRDisplay.prototype.getFrameData');
    return this._getPose();
  };
  VRDisplay.prototype.requestAnimationFrame = function (callback) {
    return raf(callback);
  };
  VRDisplay.prototype.cancelAnimationFrame = function (id) {
    return caf(id);
  };
  VRDisplay.prototype.wrapForFullscreen = function (element) {
    if (isIOS()) {
      return element;
    }
    if (!this.fullscreenWrapper_) {
      this.fullscreenWrapper_ = document.createElement('div');
      var cssProperties = ['height: ' + Math.min(screen.height, screen.width) + 'px !important', 'top: 0 !important', 'left: 0 !important', 'right: 0 !important', 'border: 0', 'margin: 0', 'padding: 0', 'z-index: 999999 !important', 'position: fixed'];
      this.fullscreenWrapper_.setAttribute('style', cssProperties.join('; ') + ';');
      this.fullscreenWrapper_.classList.add('webvr-polyfill-fullscreen-wrapper');
    }
    if (this.fullscreenElement_ == element) {
      return this.fullscreenWrapper_;
    }
    if (this.fullscreenElement_) {
      if (this.originalParent_) {
        this.originalParent_.appendChild(this.fullscreenElement_);
      } else {
        this.fullscreenElement_.parentElement.removeChild(this.fullscreenElement_);
      }
    }
    this.fullscreenElement_ = element;
    this.originalParent_ = element.parentElement;
    if (!this.originalParent_) {
      document.body.appendChild(element);
    }
    if (!this.fullscreenWrapper_.parentElement) {
      var parent = this.fullscreenElement_.parentElement;
      parent.insertBefore(this.fullscreenWrapper_, this.fullscreenElement_);
      parent.removeChild(this.fullscreenElement_);
    }
    this.fullscreenWrapper_.insertBefore(this.fullscreenElement_, this.fullscreenWrapper_.firstChild);
    this.fullscreenElementCachedStyle_ = this.fullscreenElement_.getAttribute('style');
    var self = this;
    function applyFullscreenElementStyle() {
      if (!self.fullscreenElement_) {
        return;
      }
      var cssProperties = ['position: absolute', 'top: 0', 'left: 0', 'width: ' + Math.max(screen.width, screen.height) + 'px', 'height: ' + Math.min(screen.height, screen.width) + 'px', 'border: 0', 'margin: 0', 'padding: 0'];
      self.fullscreenElement_.setAttribute('style', cssProperties.join('; ') + ';');
    }
    applyFullscreenElementStyle();
    return this.fullscreenWrapper_;
  };
  VRDisplay.prototype.removeFullscreenWrapper = function () {
    if (!this.fullscreenElement_) {
      return;
    }
    var element = this.fullscreenElement_;
    if (this.fullscreenElementCachedStyle_) {
      element.setAttribute('style', this.fullscreenElementCachedStyle_);
    } else {
      element.removeAttribute('style');
    }
    this.fullscreenElement_ = null;
    this.fullscreenElementCachedStyle_ = null;
    var parent = this.fullscreenWrapper_.parentElement;
    this.fullscreenWrapper_.removeChild(element);
    if (this.originalParent_ === parent) {
      parent.insertBefore(element, this.fullscreenWrapper_);
    }
    else if (this.originalParent_) {
        this.originalParent_.appendChild(element);
      }
    parent.removeChild(this.fullscreenWrapper_);
    return element;
  };
  VRDisplay.prototype.requestPresent = function (layers) {
    var wasPresenting = this.isPresenting;
    var self = this;
    if (!(layers instanceof Array)) {
      deprecateWarning('VRDisplay.prototype.requestPresent with non-array argument', 'an array of VRLayers as the first argument');
      layers = [layers];
    }
    return new Promise(function (resolve, reject) {
      if (!self.capabilities.canPresent) {
        reject(new Error('VRDisplay is not capable of presenting.'));
        return;
      }
      if (layers.length == 0 || layers.length > self.capabilities.maxLayers) {
        reject(new Error('Invalid number of layers.'));
        return;
      }
      var incomingLayer = layers[0];
      if (!incomingLayer.source) {
        resolve();
        return;
      }
      var leftBounds = incomingLayer.leftBounds || defaultLeftBounds;
      var rightBounds = incomingLayer.rightBounds || defaultRightBounds;
      if (wasPresenting) {
        var layer = self.layer_;
        if (layer.source !== incomingLayer.source) {
          layer.source = incomingLayer.source;
        }
        for (var i = 0; i < 4; i++) {
          layer.leftBounds[i] = leftBounds[i];
          layer.rightBounds[i] = rightBounds[i];
        }
        self.wrapForFullscreen(self.layer_.source);
        self.updatePresent_();
        resolve();
        return;
      }
      self.layer_ = {
        predistorted: incomingLayer.predistorted,
        source: incomingLayer.source,
        leftBounds: leftBounds.slice(0),
        rightBounds: rightBounds.slice(0)
      };
      self.waitingForPresent_ = false;
      if (self.layer_ && self.layer_.source) {
        var fullscreenElement = self.wrapForFullscreen(self.layer_.source);
        var onFullscreenChange = function onFullscreenChange() {
          var actualFullscreenElement = getFullscreenElement();
          self.isPresenting = fullscreenElement === actualFullscreenElement;
          if (self.isPresenting) {
            if (screen.orientation && screen.orientation.lock) {
              screen.orientation.lock('landscape-primary').catch(function (error) {
                console.error('screen.orientation.lock() failed due to', error.message);
              });
            }
            self.waitingForPresent_ = false;
            self.beginPresent_();
            resolve();
          } else {
            if (screen.orientation && screen.orientation.unlock) {
              screen.orientation.unlock();
            }
            self.removeFullscreenWrapper();
            self.disableWakeLock();
            self.endPresent_();
            self.removeFullscreenListeners_();
          }
          self.fireVRDisplayPresentChange_();
        };
        var onFullscreenError = function onFullscreenError() {
          if (!self.waitingForPresent_) {
            return;
          }
          self.removeFullscreenWrapper();
          self.removeFullscreenListeners_();
          self.disableWakeLock();
          self.waitingForPresent_ = false;
          self.isPresenting = false;
          reject(new Error('Unable to present.'));
        };
        self.addFullscreenListeners_(fullscreenElement, onFullscreenChange, onFullscreenError);
        if (requestFullscreen(fullscreenElement)) {
          self.enableWakeLock();
          self.waitingForPresent_ = true;
        } else if (isIOS() || isWebViewAndroid()) {
          self.enableWakeLock();
          self.isPresenting = true;
          self.beginPresent_();
          self.fireVRDisplayPresentChange_();
          resolve();
        }
      }
      if (!self.waitingForPresent_ && !isIOS()) {
        exitFullscreen();
        reject(new Error('Unable to present.'));
      }
    });
  };
  VRDisplay.prototype.exitPresent = function () {
    var wasPresenting = this.isPresenting;
    var self = this;
    this.isPresenting = false;
    this.layer_ = null;
    this.disableWakeLock();
    return new Promise(function (resolve, reject) {
      if (wasPresenting) {
        if (!exitFullscreen() && isIOS()) {
          self.endPresent_();
          self.fireVRDisplayPresentChange_();
        }
        if (isWebViewAndroid()) {
          self.removeFullscreenWrapper();
          self.removeFullscreenListeners_();
          self.endPresent_();
          self.fireVRDisplayPresentChange_();
        }
        resolve();
      } else {
        reject(new Error('Was not presenting to VRDisplay.'));
      }
    });
  };
  VRDisplay.prototype.getLayers = function () {
    if (this.layer_) {
      return [this.layer_];
    }
    return [];
  };
  VRDisplay.prototype.fireVRDisplayPresentChange_ = function () {
    var event = new CustomEvent('vrdisplaypresentchange', { detail: { display: this } });
    window.dispatchEvent(event);
  };
  VRDisplay.prototype.fireVRDisplayConnect_ = function () {
    var event = new CustomEvent('vrdisplayconnect', { detail: { display: this } });
    window.dispatchEvent(event);
  };
  VRDisplay.prototype.addFullscreenListeners_ = function (element, changeHandler, errorHandler) {
    this.removeFullscreenListeners_();
    this.fullscreenEventTarget_ = element;
    this.fullscreenChangeHandler_ = changeHandler;
    this.fullscreenErrorHandler_ = errorHandler;
    if (changeHandler) {
      if (document.fullscreenEnabled) {
        element.addEventListener('fullscreenchange', changeHandler, false);
      } else if (document.webkitFullscreenEnabled) {
        element.addEventListener('webkitfullscreenchange', changeHandler, false);
      } else if (document.mozFullScreenEnabled) {
        document.addEventListener('mozfullscreenchange', changeHandler, false);
      } else if (document.msFullscreenEnabled) {
        element.addEventListener('msfullscreenchange', changeHandler, false);
      }
    }
    if (errorHandler) {
      if (document.fullscreenEnabled) {
        element.addEventListener('fullscreenerror', errorHandler, false);
      } else if (document.webkitFullscreenEnabled) {
        element.addEventListener('webkitfullscreenerror', errorHandler, false);
      } else if (document.mozFullScreenEnabled) {
        document.addEventListener('mozfullscreenerror', errorHandler, false);
      } else if (document.msFullscreenEnabled) {
        element.addEventListener('msfullscreenerror', errorHandler, false);
      }
    }
  };
  VRDisplay.prototype.removeFullscreenListeners_ = function () {
    if (!this.fullscreenEventTarget_) return;
    var element = this.fullscreenEventTarget_;
    if (this.fullscreenChangeHandler_) {
      var changeHandler = this.fullscreenChangeHandler_;
      element.removeEventListener('fullscreenchange', changeHandler, false);
      element.removeEventListener('webkitfullscreenchange', changeHandler, false);
      document.removeEventListener('mozfullscreenchange', changeHandler, false);
      element.removeEventListener('msfullscreenchange', changeHandler, false);
    }
    if (this.fullscreenErrorHandler_) {
      var errorHandler = this.fullscreenErrorHandler_;
      element.removeEventListener('fullscreenerror', errorHandler, false);
      element.removeEventListener('webkitfullscreenerror', errorHandler, false);
      document.removeEventListener('mozfullscreenerror', errorHandler, false);
      element.removeEventListener('msfullscreenerror', errorHandler, false);
    }
    this.fullscreenEventTarget_ = null;
    this.fullscreenChangeHandler_ = null;
    this.fullscreenErrorHandler_ = null;
  };
  VRDisplay.prototype.enableWakeLock = function () {
    if (this.wakelock_) {
      this.wakelock_.enable();
    }
  };
  VRDisplay.prototype.disableWakeLock = function () {
    if (this.wakelock_) {
      this.wakelock_.disable();
    }
  };
  VRDisplay.prototype.beginPresent_ = function () {
  };
  VRDisplay.prototype.endPresent_ = function () {
  };
  VRDisplay.prototype.submitFrame = function (pose) {
  };
  VRDisplay.prototype.getEyeParameters = function (whichEye) {
    return null;
  };
  var config = {
    ADDITIONAL_VIEWERS: [],
    DEFAULT_VIEWER: '',
    MOBILE_WAKE_LOCK: true,
    DEBUG: false,
    DPDB_URL: 'https://dpdb.webvr.rocks/dpdb.json',
    K_FILTER: 0.98,
    PREDICTION_TIME_S: 0.040,
    CARDBOARD_UI_DISABLED: false,
    ROTATE_INSTRUCTIONS_DISABLED: false,
    YAW_ONLY: false,
    BUFFER_SCALE: 0.5,
    DIRTY_SUBMIT_FRAME_BINDINGS: false
  };
  var Eye = {
    LEFT: 'left',
    RIGHT: 'right'
  };
  function CardboardVRDisplay(config$$1) {
    var defaults = extend({}, config);
    config$$1 = extend(defaults, config$$1 || {});
    VRDisplay.call(this, {
      wakelock: config$$1.MOBILE_WAKE_LOCK
    });
    this.config = config$$1;
    this.displayName = 'Cardboard VRDisplay';
    this.capabilities = new VRDisplayCapabilities({
      hasPosition: false,
      hasOrientation: true,
      hasExternalDisplay: false,
      canPresent: true,
      maxLayers: 1
    });
    this.stageParameters = null;
    this.bufferScale_ = this.config.BUFFER_SCALE;
    this.poseSensor_ = new PoseSensor(this.config);
    this.distorter_ = null;
    this.cardboardUI_ = null;
    this.dpdb_ = new Dpdb(this.config.DPDB_URL, this.onDeviceParamsUpdated_.bind(this));
    this.deviceInfo_ = new DeviceInfo(this.dpdb_.getDeviceParams(), config$$1.ADDITIONAL_VIEWERS);
    this.viewerSelector_ = new ViewerSelector(config$$1.DEFAULT_VIEWER);
    this.viewerSelector_.onChange(this.onViewerChanged_.bind(this));
    this.deviceInfo_.setViewer(this.viewerSelector_.getCurrentViewer());
    if (!this.config.ROTATE_INSTRUCTIONS_DISABLED) {
      this.rotateInstructions_ = new RotateInstructions();
    }
    if (isIOS()) {
      window.addEventListener('resize', this.onResize_.bind(this));
    }
  }
  CardboardVRDisplay.prototype = Object.create(VRDisplay.prototype);
  CardboardVRDisplay.prototype._getPose = function () {
    return {
      position: null,
      orientation: this.poseSensor_.getOrientation(),
      linearVelocity: null,
      linearAcceleration: null,
      angularVelocity: null,
      angularAcceleration: null
    };
  };
  CardboardVRDisplay.prototype._resetPose = function () {
    if (this.poseSensor_.resetPose) {
      this.poseSensor_.resetPose();
    }
  };
  CardboardVRDisplay.prototype._getFieldOfView = function (whichEye) {
    var fieldOfView;
    if (whichEye == Eye.LEFT) {
      fieldOfView = this.deviceInfo_.getFieldOfViewLeftEye();
    } else if (whichEye == Eye.RIGHT) {
      fieldOfView = this.deviceInfo_.getFieldOfViewRightEye();
    } else {
      console.error('Invalid eye provided: %s', whichEye);
      return null;
    }
    return fieldOfView;
  };
  CardboardVRDisplay.prototype._getEyeOffset = function (whichEye) {
    var offset;
    if (whichEye == Eye.LEFT) {
      offset = [-this.deviceInfo_.viewer.interLensDistance * 0.5, 0.0, 0.0];
    } else if (whichEye == Eye.RIGHT) {
      offset = [this.deviceInfo_.viewer.interLensDistance * 0.5, 0.0, 0.0];
    } else {
      console.error('Invalid eye provided: %s', whichEye);
      return null;
    }
    return offset;
  };
  CardboardVRDisplay.prototype.getEyeParameters = function (whichEye) {
    var offset = this._getEyeOffset(whichEye);
    var fieldOfView = this._getFieldOfView(whichEye);
    var eyeParams = {
      offset: offset,
      renderWidth: this.deviceInfo_.device.width * 0.5 * this.bufferScale_,
      renderHeight: this.deviceInfo_.device.height * this.bufferScale_
    };
    Object.defineProperty(eyeParams, 'fieldOfView', {
      enumerable: true,
      get: function get() {
        deprecateWarning('VRFieldOfView', 'VRFrameData\'s projection matrices');
        return fieldOfView;
      }
    });
    return eyeParams;
  };
  CardboardVRDisplay.prototype.onDeviceParamsUpdated_ = function (newParams) {
    if (this.config.DEBUG) {
      console.log('DPDB reported that device params were updated.');
    }
    this.deviceInfo_.updateDeviceParams(newParams);
    if (this.distorter_) {
      this.distorter_.updateDeviceInfo(this.deviceInfo_);
    }
  };
  CardboardVRDisplay.prototype.updateBounds_ = function () {
    if (this.layer_ && this.distorter_ && (this.layer_.leftBounds || this.layer_.rightBounds)) {
      this.distorter_.setTextureBounds(this.layer_.leftBounds, this.layer_.rightBounds);
    }
  };
  CardboardVRDisplay.prototype.beginPresent_ = function () {
    var gl = this.layer_.source.getContext('webgl');
    if (!gl) gl = this.layer_.source.getContext('experimental-webgl');
    if (!gl) gl = this.layer_.source.getContext('webgl2');
    if (!gl) return;
    if (this.layer_.predistorted) {
      if (!this.config.CARDBOARD_UI_DISABLED) {
        gl.canvas.width = getScreenWidth() * this.bufferScale_;
        gl.canvas.height = getScreenHeight() * this.bufferScale_;
        this.cardboardUI_ = new CardboardUI(gl);
      }
    } else {
      if (!this.config.CARDBOARD_UI_DISABLED) {
        this.cardboardUI_ = new CardboardUI(gl);
      }
      this.distorter_ = new CardboardDistorter(gl, this.cardboardUI_, this.config.BUFFER_SCALE, this.config.DIRTY_SUBMIT_FRAME_BINDINGS);
      this.distorter_.updateDeviceInfo(this.deviceInfo_);
    }
    if (this.cardboardUI_) {
      this.cardboardUI_.listen(function (e) {
        this.viewerSelector_.show(this.layer_.source.parentElement);
        e.stopPropagation();
        e.preventDefault();
      }.bind(this), function (e) {
        this.exitPresent();
        e.stopPropagation();
        e.preventDefault();
      }.bind(this));
    }
    if (this.rotateInstructions_) {
      if (isLandscapeMode() && isMobile()) {
        this.rotateInstructions_.showTemporarily(3000, this.layer_.source.parentElement);
      } else {
        this.rotateInstructions_.update();
      }
    }
    this.orientationHandler = this.onOrientationChange_.bind(this);
    window.addEventListener('orientationchange', this.orientationHandler);
    this.vrdisplaypresentchangeHandler = this.updateBounds_.bind(this);
    window.addEventListener('vrdisplaypresentchange', this.vrdisplaypresentchangeHandler);
    this.fireVRDisplayDeviceParamsChange_();
  };
  CardboardVRDisplay.prototype.endPresent_ = function () {
    if (this.distorter_) {
      this.distorter_.destroy();
      this.distorter_ = null;
    }
    if (this.cardboardUI_) {
      this.cardboardUI_.destroy();
      this.cardboardUI_ = null;
    }
    if (this.rotateInstructions_) {
      this.rotateInstructions_.hide();
    }
    this.viewerSelector_.hide();
    window.removeEventListener('orientationchange', this.orientationHandler);
    window.removeEventListener('vrdisplaypresentchange', this.vrdisplaypresentchangeHandler);
  };
  CardboardVRDisplay.prototype.updatePresent_ = function () {
    this.endPresent_();
    this.beginPresent_();
  };
  CardboardVRDisplay.prototype.submitFrame = function (pose) {
    if (this.distorter_) {
      this.updateBounds_();
      this.distorter_.submitFrame();
    } else if (this.cardboardUI_ && this.layer_) {
      var gl = this.layer_.source.getContext('webgl');
      if (!gl) gl = this.layer_.source.getContext('experimental-webgl');
      if (!gl) gl = this.layer_.source.getContext('webgl2');
      var canvas = gl.canvas;
      if (canvas.width != this.lastWidth || canvas.height != this.lastHeight) {
        this.cardboardUI_.onResize();
      }
      this.lastWidth = canvas.width;
      this.lastHeight = canvas.height;
      this.cardboardUI_.render();
    }
  };
  CardboardVRDisplay.prototype.onOrientationChange_ = function (e) {
    this.viewerSelector_.hide();
    if (this.rotateInstructions_) {
      this.rotateInstructions_.update();
    }
    this.onResize_();
  };
  CardboardVRDisplay.prototype.onResize_ = function (e) {
    if (this.layer_) {
      var gl = this.layer_.source.getContext('webgl');
      if (!gl) gl = this.layer_.source.getContext('experimental-webgl');
      if (!gl) gl = this.layer_.source.getContext('webgl2');
      var cssProperties = ['position: absolute', 'top: 0', 'left: 0',
      'width: 100vw', 'height: 100vh', 'border: 0', 'margin: 0',
      'padding: 0px', 'box-sizing: content-box'];
      gl.canvas.setAttribute('style', cssProperties.join('; ') + ';');
      safariCssSizeWorkaround(gl.canvas);
    }
  };
  CardboardVRDisplay.prototype.onViewerChanged_ = function (viewer) {
    this.deviceInfo_.setViewer(viewer);
    if (this.distorter_) {
      this.distorter_.updateDeviceInfo(this.deviceInfo_);
    }
    this.fireVRDisplayDeviceParamsChange_();
  };
  CardboardVRDisplay.prototype.fireVRDisplayDeviceParamsChange_ = function () {
    var event = new CustomEvent('vrdisplaydeviceparamschange', {
      detail: {
        vrdisplay: this,
        deviceInfo: this.deviceInfo_
      }
    });
    window.dispatchEvent(event);
  };
  CardboardVRDisplay.VRFrameData = VRFrameData;
  CardboardVRDisplay.VRDisplay = VRDisplay;
  return CardboardVRDisplay;
  })));
  });
  var CardboardVRDisplay = unwrapExports(cardboardVrDisplay);

  class XRDevice extends EventTarget {
    constructor(global) {
      super();
      this.global = global;
      this.onWindowResize = this.onWindowResize.bind(this);
      this.global.window.addEventListener('resize', this.onWindowResize);
      this.environmentBlendMode = 'opaque';
    }
    onBaseLayerSet(sessionId, layer) { throw new Error('Not implemented'); }
    isSessionSupported(mode) { throw new Error('Not implemented'); }
    isFeatureSupported(featureDescriptor) { throw new Error('Not implemented'); }
    async requestSession(mode, enabledFeatures) { throw new Error('Not implemented'); }
    requestAnimationFrame(callback) { throw new Error('Not implemented'); }
    onFrameStart(sessionId) { throw new Error('Not implemented'); }
    onFrameEnd(sessionId) { throw new Error('Not implemented'); }
    doesSessionSupportReferenceSpace(sessionId, type) { throw new Error('Not implemented'); }
    requestStageBounds() { throw new Error('Not implemented'); }
    async requestFrameOfReferenceTransform(type, options) {
      return undefined;
    }
    cancelAnimationFrame(handle) { throw new Error('Not implemented'); }
    endSession(sessionId) { throw new Error('Not implemented'); }
    getViewport(sessionId, eye, layer, target) { throw new Error('Not implemented'); }
    getProjectionMatrix(eye) { throw new Error('Not implemented'); }
    getBasePoseMatrix() { throw new Error('Not implemented'); }
    getBaseViewMatrix(eye) { throw new Error('Not implemented'); }
    getInputSources() { throw new Error('Not implemented'); }
    getInputPose(inputSource, coordinateSystem, poseType) { throw new Error('Not implemented'); }
    onWindowResize() {
      this.onWindowResize();
    }
  }

  let daydream = {
    mapping: '',
    profiles: ['google-daydream', 'generic-trigger-touchpad'],
    buttons: {
      length: 3,
      0: null,
      1: null,
      2: 0
    },
  };
  let viveFocus = {
    mapping: 'xr-standard',
    profiles: ['htc-vive-focus', 'generic-trigger-touchpad'],
    buttons: {
      length: 3,
      0: 1,
      1: null,
      2: 0
    },
  };
  let oculusGo = {
    mapping: 'xr-standard',
    profiles: ['oculus-go', 'generic-trigger-touchpad'],
    buttons: {
      length: 3,
      0: 1,
      1: null,
      2: 0
    },
    gripTransform: {
      orientation: [Math.PI * 0.11, 0, 0, 1]
    }
  };
  let oculusTouch = {
    mapping: 'xr-standard',
    displayProfiles: {
      'Oculus Quest': ['oculus-touch-v2', 'oculus-touch', 'generic-trigger-squeeze-thumbstick']
    },
    profiles: ['oculus-touch', 'generic-trigger-squeeze-thumbstick'],
    axes: {
      length: 4,
      0: null,
      1: null,
      2: 0,
      3: 1
    },
    buttons: {
      length: 7,
      0: 1,
      1: 2,
      2: null,
      3: 0,
      4: 3,
      5: 4,
      6: null
    },
    gripTransform: {
      position: [0, -0.02, 0.04, 1],
      orientation: [Math.PI * 0.11, 0, 0, 1]
    }
  };
  let openVr = {
    mapping: 'xr-standard',
    profiles: ['htc-vive', 'generic-trigger-squeeze-touchpad'],
    displayProfiles: {
      'HTC Vive': ['htc-vive', 'generic-trigger-squeeze-touchpad'],
      'HTC Vive DVT': ['htc-vive', 'generic-trigger-squeeze-touchpad'],
      'Valve Index': ['valve-index', 'generic-trigger-squeeze-touchpad-thumbstick']
    },
    buttons: {
      length: 3,
      0: 1,
      1: 2,
      2: 0
    },
    gripTransform: {
      position: [0, 0, 0.05, 1],
    },
    targetRayTransform: {
      orientation: [Math.PI * -0.08, 0, 0, 1]
    },
    userAgentOverrides: {
      "Firefox": {
        axes: {
          invert: [1, 3]
        }
      }
    }
  };
  let samsungGearVR = {
    mapping: 'xr-standard',
    profiles: ['samsung-gearvr', 'generic-trigger-touchpad'],
    buttons: {
      length: 3,
      0: 1,
      1: null,
      2: 0
    },
    gripTransform: {
      orientation: [Math.PI * 0.11, 0, 0, 1]
    }
  };
  let samsungOdyssey = {
    mapping: 'xr-standard',
    profiles: ['samsung-odyssey', 'microsoft-mixed-reality', 'generic-trigger-squeeze-touchpad-thumbstick'],
    buttons: {
      length: 4,
      0: 1,
      1: 0,
      2: 2,
      3: 4,
    },
    gripTransform: {
      position: [0, -0.02, 0.04, 1],
      orientation: [Math.PI * 0.11, 0, 0, 1]
    }
  };
  let windowsMixedReality = {
    mapping: 'xr-standard',
    profiles: ['microsoft-mixed-reality', 'generic-trigger-squeeze-touchpad-thumbstick'],
    buttons: {
      length: 4,
      0: 1,
      1: 0,
      2: 2,
      3: 4,
    },
    gripTransform: {
      position: [0, -0.02, 0.04, 1],
      orientation: [Math.PI * 0.11, 0, 0, 1]
    }
  };
  let GamepadMappings = {
    'Daydream Controller': daydream,
    'Gear VR Controller': samsungGearVR,
    'HTC Vive Focus Controller': viveFocus,
    'Oculus Go Controller': oculusGo,
    'Oculus Touch (Right)': oculusTouch,
    'Oculus Touch (Left)': oculusTouch,
    'OpenVR Gamepad': openVr,
    'Spatial Controller (Spatial Interaction Source) 045E-065A': windowsMixedReality,
    'Spatial Controller (Spatial Interaction Source) 045E-065D': samsungOdyssey,
    'Windows Mixed Reality (Right)': windowsMixedReality,
    'Windows Mixed Reality (Left)': windowsMixedReality,
  };

  const HEAD_ELBOW_OFFSET_RIGHTHANDED = fromValues$1(0.155, -0.465, -0.15);
  const HEAD_ELBOW_OFFSET_LEFTHANDED = fromValues$1(-0.155, -0.465, -0.15);
  const ELBOW_WRIST_OFFSET = fromValues$1(0, 0, -0.25);
  const WRIST_CONTROLLER_OFFSET = fromValues$1(0, 0, 0.05);
  const ARM_EXTENSION_OFFSET = fromValues$1(-0.08, 0.14, 0.08);
  const ELBOW_BEND_RATIO = 0.4;
  const EXTENSION_RATIO_WEIGHT = 0.4;
  const MIN_ANGULAR_SPEED = 0.61;
  const MIN_ANGLE_DELTA = 0.175;
  const MIN_EXTENSION_COS = 0.12;
  const MAX_EXTENSION_COS = 0.87;
  const RAD_TO_DEG = 180 / Math.PI;
  function eulerFromQuaternion(out, q, order) {
    function clamp(value, min$$1, max$$1) {
      return (value < min$$1 ? min$$1 : (value > max$$1 ? max$$1 : value));
    }
    var sqx = q[0] * q[0];
    var sqy = q[1] * q[1];
    var sqz = q[2] * q[2];
    var sqw = q[3] * q[3];
    if ( order === 'XYZ' ) {
      out[0] = Math.atan2( 2 * ( q[0] * q[3] - q[1] * q[2] ), ( sqw - sqx - sqy + sqz ) );
      out[1] = Math.asin(  clamp( 2 * ( q[0] * q[2] + q[1] * q[3] ), -1, 1 ) );
      out[2] = Math.atan2( 2 * ( q[2] * q[3] - q[0] * q[1] ), ( sqw + sqx - sqy - sqz ) );
    } else if ( order ===  'YXZ' ) {
      out[0] = Math.asin(  clamp( 2 * ( q[0] * q[3] - q[1] * q[2] ), -1, 1 ) );
      out[1] = Math.atan2( 2 * ( q[0] * q[2] + q[1] * q[3] ), ( sqw - sqx - sqy + sqz ) );
      out[2] = Math.atan2( 2 * ( q[0] * q[1] + q[2] * q[3] ), ( sqw - sqx + sqy - sqz ) );
    } else if ( order === 'ZXY' ) {
      out[0] = Math.asin(  clamp( 2 * ( q[0] * q[3] + q[1] * q[2] ), -1, 1 ) );
      out[1] = Math.atan2( 2 * ( q[1] * q[3] - q[2] * q[0] ), ( sqw - sqx - sqy + sqz ) );
      out[2] = Math.atan2( 2 * ( q[2] * q[3] - q[0] * q[1] ), ( sqw - sqx + sqy - sqz ) );
    } else if ( order === 'ZYX' ) {
      out[0] = Math.atan2( 2 * ( q[0] * q[3] + q[2] * q[1] ), ( sqw - sqx - sqy + sqz ) );
      out[1] = Math.asin(  clamp( 2 * ( q[1] * q[3] - q[0] * q[2] ), -1, 1 ) );
      out[2] = Math.atan2( 2 * ( q[0] * q[1] + q[2] * q[3] ), ( sqw + sqx - sqy - sqz ) );
    } else if ( order === 'YZX' ) {
      out[0] = Math.atan2( 2 * ( q[0] * q[3] - q[2] * q[1] ), ( sqw - sqx + sqy - sqz ) );
      out[1] = Math.atan2( 2 * ( q[1] * q[3] - q[0] * q[2] ), ( sqw + sqx - sqy - sqz ) );
      out[2] = Math.asin(  clamp( 2 * ( q[0] * q[1] + q[2] * q[3] ), -1, 1 ) );
    } else if ( order === 'XZY' ) {
      out[0] = Math.atan2( 2 * ( q[0] * q[3] + q[1] * q[2] ), ( sqw - sqx + sqy - sqz ) );
      out[1] = Math.atan2( 2 * ( q[0] * q[2] + q[1] * q[3] ), ( sqw + sqx - sqy - sqz ) );
      out[2] = Math.asin(  clamp( 2 * ( q[2] * q[3] - q[0] * q[1] ), -1, 1 ) );
    } else {
      console.log('No order given for quaternion to euler conversion.');
      return;
    }
  }
  class OrientationArmModel {
    constructor() {
      this.hand = 'right';
      this.headElbowOffset = HEAD_ELBOW_OFFSET_RIGHTHANDED;
      this.controllerQ = create$4();
      this.lastControllerQ = create$4();
      this.headQ = create$4();
      this.headPos = create$1();
      this.elbowPos = create$1();
      this.wristPos = create$1();
      this.time = null;
      this.lastTime = null;
      this.rootQ = create$4();
      this.position = create$1();
    }
    setHandedness(hand) {
      if (this.hand != hand) {
        this.hand = hand;
        if (this.hand == 'left') {
          this.headElbowOffset = HEAD_ELBOW_OFFSET_LEFTHANDED;
        } else {
          this.headElbowOffset = HEAD_ELBOW_OFFSET_RIGHTHANDED;
        }
      }
    }
    update(controllerOrientation, headPoseMatrix) {
      this.time = now$1();
      if (controllerOrientation) {
        copy$4(this.lastControllerQ, this.controllerQ);
        copy$4(this.controllerQ, controllerOrientation);
      }
      if (headPoseMatrix) {
        getTranslation(this.headPos, headPoseMatrix);
        getRotation(this.headQ, headPoseMatrix);
      }
      let headYawQ = this.getHeadYawOrientation_();
      let angleDelta = this.quatAngle_(this.lastControllerQ, this.controllerQ);
      let timeDelta = (this.time - this.lastTime) / 1000;
      let controllerAngularSpeed = angleDelta / timeDelta;
      if (controllerAngularSpeed > MIN_ANGULAR_SPEED) {
        slerp(this.rootQ, this.rootQ, headYawQ,
                   Math.min(angleDelta / MIN_ANGLE_DELTA, 1.0));
      } else {
        copy$4(this.rootQ, headYawQ);
      }
      let controllerForward = fromValues$1(0, 0, -1.0);
      transformQuat(controllerForward, controllerForward, this.controllerQ);
      let controllerDotY = dot(controllerForward, [0, 1, 0]);
      let extensionRatio = this.clamp_(
          (controllerDotY - MIN_EXTENSION_COS) / MAX_EXTENSION_COS, 0.0, 1.0);
      let controllerCameraQ = clone$4(this.rootQ);
      invert$2(controllerCameraQ, controllerCameraQ);
      multiply$4(controllerCameraQ, controllerCameraQ, this.controllerQ);
      let elbowPos = this.elbowPos;
      copy$1(elbowPos, this.headPos);
      add$1(elbowPos, elbowPos, this.headElbowOffset);
      let elbowOffset = clone$1(ARM_EXTENSION_OFFSET);
      scale$1(elbowOffset, elbowOffset, extensionRatio);
      add$1(elbowPos, elbowPos, elbowOffset);
      let totalAngle = this.quatAngle_(controllerCameraQ, create$4());
      let totalAngleDeg = totalAngle * RAD_TO_DEG;
      let lerpSuppression = 1 - Math.pow(totalAngleDeg / 180, 4);let elbowRatio = ELBOW_BEND_RATIO;
      let wristRatio = 1 - ELBOW_BEND_RATIO;
      let lerpValue = lerpSuppression *
          (elbowRatio + wristRatio * extensionRatio * EXTENSION_RATIO_WEIGHT);
      let wristQ = create$4();
      slerp(wristQ, wristQ, controllerCameraQ, lerpValue);
      let invWristQ = invert$2(create$4(), wristQ);
      let elbowQ = clone$4(controllerCameraQ);
      multiply$4(elbowQ, elbowQ, invWristQ);
      let wristPos = this.wristPos;
      copy$1(wristPos, WRIST_CONTROLLER_OFFSET);
      transformQuat(wristPos, wristPos, wristQ);
      add$1(wristPos, wristPos, ELBOW_WRIST_OFFSET);
      transformQuat(wristPos, wristPos, elbowQ);
      add$1(wristPos, wristPos, elbowPos);
      let offset = clone$1(ARM_EXTENSION_OFFSET);
      scale$1(offset, offset, extensionRatio);
      add$1(this.position, this.wristPos, offset);
      transformQuat(this.position, this.position, this.rootQ);
      this.lastTime = this.time;
    }
    getPosition() {
      return this.position;
    }
    getHeadYawOrientation_() {
      let headEuler = create$1();
      eulerFromQuaternion(headEuler, this.headQ, 'YXZ');
      let destinationQ = fromEuler(create$4(), 0, headEuler[1] * RAD_TO_DEG, 0);
      return destinationQ;
    }
    clamp_(value, min$$1, max$$1) {
      return Math.min(Math.max(value, min$$1), max$$1);
    }
    quatAngle_(q1, q2) {
      let vec1 = [0, 0, -1];
      let vec2 = [0, 0, -1];
      transformQuat(vec1, vec1, q1);
      transformQuat(vec2, vec2, q2);
      return angle(vec1, vec2);
    }
  }

  const PRIVATE$18 = Symbol('@@webxr-polyfill/XRRemappedGamepad');
  const PLACEHOLDER_BUTTON = { pressed: false, touched: false, value: 0.0 };
  Object.freeze(PLACEHOLDER_BUTTON);
  class XRRemappedGamepad {
    constructor(gamepad, display, map) {
      if (!map) {
        map = {};
      }
      if (map.userAgentOverrides) {
        for (let agent in map.userAgentOverrides) {
          if (navigator.userAgent.includes(agent)) {
            let override = map.userAgentOverrides[agent];
            for (let key in override) {
              if (key in map) {
                Object.assign(map[key], override[key]);
              } else {
                map[key] = override[key];
              }
            }
            break;
          }
        }
      }
      let axes = new Array(map.axes && map.axes.length ? map.axes.length : gamepad.axes.length);
      let buttons = new Array(map.buttons && map.buttons.length ? map.buttons.length : gamepad.buttons.length);
      let gripTransform = null;
      if (map.gripTransform) {
        let orientation = map.gripTransform.orientation || [0, 0, 0, 1];
        gripTransform = create();
        fromRotationTranslation(
          gripTransform,
          normalize$2(orientation, orientation),
          map.gripTransform.position || [0, 0, 0]
        );
      }
      let targetRayTransform = null;
      if (map.targetRayTransform) {
        let orientation =  map.targetRayTransform.orientation || [0, 0, 0, 1];
        targetRayTransform = create();
        fromRotationTranslation(
          targetRayTransform,
          normalize$2(orientation, orientation),
          map.targetRayTransform.position || [0, 0, 0]
        );
      }
      let profiles = map.profiles;
      if (map.displayProfiles) {
        if (display.displayName in map.displayProfiles) {
          profiles = map.displayProfiles[display.displayName];
        }
      }
      this[PRIVATE$18] = {
        gamepad,
        map,
        profiles: profiles || [gamepad.id],
        mapping: map.mapping || gamepad.mapping,
        axes,
        buttons,
        gripTransform,
        targetRayTransform,
      };
      this._update();
    }
    _update() {
      let gamepad = this[PRIVATE$18].gamepad;
      let map = this[PRIVATE$18].map;
      let axes = this[PRIVATE$18].axes;
      for (let i = 0; i < axes.length; ++i) {
        if (map.axes && i in map.axes) {
          if (map.axes[i] === null) {
            axes[i] = 0;
          } else {
            axes[i] = gamepad.axes[map.axes[i]];
          }
        } else {
          axes[i] = gamepad.axes[i];
        }
      }
      if (map.axes && map.axes.invert) {
        for (let axis of map.axes.invert) {
          if (axis < axes.length) {
            axes[axis] *= -1;
          }
        }
      }
      let buttons = this[PRIVATE$18].buttons;
      for (let i = 0; i < buttons.length; ++i) {
        if (map.buttons && i in map.buttons) {
          if (map.buttons[i] === null) {
            buttons[i] = PLACEHOLDER_BUTTON;
          } else {
            buttons[i] = gamepad.buttons[map.buttons[i]];
          }
        } else {
          buttons[i] = gamepad.buttons[i];
        }
      }
    }
    get id() {
      return '';
    }
    get _profiles() {
      return this[PRIVATE$18].profiles;
    }
    get index() {
      return -1;
    }
    get connected() {
      return this[PRIVATE$18].gamepad.connected;
    }
    get timestamp() {
      return this[PRIVATE$18].gamepad.timestamp;
    }
    get mapping() {
      return this[PRIVATE$18].mapping;
    }
    get axes() {
      return this[PRIVATE$18].axes;
    }
    get buttons() {
      return this[PRIVATE$18].buttons;
    }
    get hapticActuators() {
      return this[PRIVATE$18].gamepad.hapticActuators;
    }
  }
  class GamepadXRInputSource {
    constructor(polyfill, display, primaryButtonIndex = 0, primarySqueezeButtonIndex = -1) {
      this.polyfill = polyfill;
      this.display = display;
      this.nativeGamepad = null;
      this.gamepad = null;
      this.inputSource = new XRInputSource(this);
      this.lastPosition = create$1();
      this.emulatedPosition = false;
      this.basePoseMatrix = create();
      this.outputMatrix = create();
      this.primaryButtonIndex = primaryButtonIndex;
      this.primaryActionPressed = false;
      this.primarySqueezeButtonIndex = primarySqueezeButtonIndex;
      this.primarySqueezeActionPressed = false;
      this.handedness = '';
      this.targetRayMode = 'gaze';
      this.armModel = null;
    }
    get profiles() {
      return this.gamepad ? this.gamepad._profiles : [];
    }
    updateFromGamepad(gamepad) {
      if (this.nativeGamepad !== gamepad) {
        this.nativeGamepad = gamepad;
        if (gamepad) {
          this.gamepad = new XRRemappedGamepad(gamepad, this.display, GamepadMappings[gamepad.id]);
        } else {
          this.gamepad = null;
        }
      }
      this.handedness = gamepad.hand === '' ? 'none' : gamepad.hand;
      if (this.gamepad) {
        this.gamepad._update();
      }
      if (gamepad.pose) {
        this.targetRayMode = 'tracked-pointer';
        this.emulatedPosition = !gamepad.pose.hasPosition;
      } else if (gamepad.hand === '') {
        this.targetRayMode = 'gaze';
        this.emulatedPosition = false;
      }
    }
    updateBasePoseMatrix() {
      if (this.nativeGamepad && this.nativeGamepad.pose) {
        let pose = this.nativeGamepad.pose;
        let position = pose.position;
        let orientation = pose.orientation;
        if (!position && !orientation) {
          return;
        }
        if (!position) {
          if (!pose.hasPosition) {
            if (!this.armModel) {
              this.armModel = new OrientationArmModel();
            }
            this.armModel.setHandedness(this.nativeGamepad.hand);
            this.armModel.update(orientation, this.polyfill.getBasePoseMatrix());
            position = this.armModel.getPosition();
          } else {
            position = this.lastPosition;
          }
        } else {
          this.lastPosition[0] = position[0];
          this.lastPosition[1] = position[1];
          this.lastPosition[2] = position[2];
        }
        fromRotationTranslation(this.basePoseMatrix, orientation, position);
      } else {
        copy(this.basePoseMatrix, this.polyfill.getBasePoseMatrix());
      }
      return this.basePoseMatrix;
    }
    getXRPose(coordinateSystem, poseType) {
      this.updateBasePoseMatrix();
      switch(poseType) {
        case "target-ray":
          coordinateSystem._transformBasePoseMatrix(this.outputMatrix, this.basePoseMatrix);
          if (this.gamepad && this.gamepad[PRIVATE$18].targetRayTransform) {
            multiply$1(this.outputMatrix, this.outputMatrix, this.gamepad[PRIVATE$18].targetRayTransform);
          }
          break;
        case "grip":
          if (!this.nativeGamepad || !this.nativeGamepad.pose) {
            return null;
          }
          coordinateSystem._transformBasePoseMatrix(this.outputMatrix, this.basePoseMatrix);
          if (this.gamepad && this.gamepad[PRIVATE$18].gripTransform) {
            multiply$1(this.outputMatrix, this.outputMatrix, this.gamepad[PRIVATE$18].gripTransform);
          }
          break;
        default:
          return null;
      }
      coordinateSystem._adjustForOriginOffset(this.outputMatrix);
      return new XRPose(new XRRigidTransform(this.outputMatrix), this.emulatedPosition);
    }
  }

  const TEST_ENV = "production" === 'test';
  const EXTRA_PRESENTATION_ATTRIBUTES = {
    highRefreshRate: true,
  };
  const PRIMARY_BUTTON_MAP = {
    oculus: 1,
    openvr: 1,
    'spatial controller (spatial interaction source)': 1
  };
  let SESSION_ID = 0;
  class Session {
    constructor(mode, enabledFeatures, polyfillOptions={}) {
      this.mode = mode;
      this.enabledFeatures = enabledFeatures;
      this.outputContext = null;
      this.immersive = mode == 'immersive-vr' || mode == 'immersive-ar';
      this.ended = null;
      this.baseLayer = null;
      this.id = ++SESSION_ID;
      this.modifiedCanvasLayer = false;
      if (this.outputContext && !TEST_ENV) {
        const renderContextType = polyfillOptions.renderContextType || '2d';
        this.renderContext = this.outputContext.canvas.getContext(renderContextType);
      }
    }
  }
  class WebVRDevice extends XRDevice {
    constructor(global, display) {
      const { canPresent } = display.capabilities;
      super(global);
      this.display = display;
      this.frame = new global.VRFrameData();
      this.sessions = new Map();
      this.immersiveSession = null;
      this.canPresent = canPresent;
      this.baseModelMatrix = create();
      this.gamepadInputSources = {};
      this.tempVec3 = new Float32Array(3);
      this.onVRDisplayPresentChange = this.onVRDisplayPresentChange.bind(this);
      global.window.addEventListener('vrdisplaypresentchange', this.onVRDisplayPresentChange);
      this.CAN_USE_GAMEPAD = global.navigator && ('getGamepads' in global.navigator);
      this.HAS_BITMAP_SUPPORT = isImageBitmapSupported(global);
    }
    get depthNear() { return this.display.depthNear; }
    set depthNear(val) { this.display.depthNear = val; }
    get depthFar() { return this.display.depthFar; }
    set depthFar(val) { this.display.depthFar = val; }
    onBaseLayerSet(sessionId, layer) {
      const session = this.sessions.get(sessionId);
      const canvas = layer.context.canvas;
      if (session.immersive) {
        const left = this.display.getEyeParameters('left');
        const right = this.display.getEyeParameters('right');
        canvas.width = Math.max(left.renderWidth, right.renderWidth) * 2;
        canvas.height = Math.max(left.renderHeight, right.renderHeight);
        this.display.requestPresent([{
            source: canvas, attributes: EXTRA_PRESENTATION_ATTRIBUTES
          }]).then(() => {
          if ( !this.global.document.body.contains(canvas)) {
            session.modifiedCanvasLayer = true;
            this.global.document.body.appendChild(canvas);
            applyCanvasStylesForMinimalRendering(canvas);
          }
          session.baseLayer = layer;
        });
      }
      else {
        session.baseLayer = layer;
      }
    }
    isSessionSupported(mode) {
      if (mode == 'immersive-ar') {
        return false;
      }
      if (mode == 'immersive-vr' && this.canPresent === false) {
        return false;
      }
      return true;
    }
    isFeatureSupported(featureDescriptor) {
      switch(featureDescriptor) {
        case 'viewer': return true;
        case 'local': return true;
        case 'local-floor': return true;
        case 'bounded': return false;
        case 'unbounded': return false;
        default: return false;
      }
    }
    async requestSession(mode, enabledFeatures) {
      if (!this.isSessionSupported(mode)) {
        return Promise.reject();
      }
      let immersive = mode == 'immersive-vr';
      if (immersive) {
        const canvas = this.global.document.createElement('canvas');
        {
          const ctx = canvas.getContext('webgl');
        }
        await this.display.requestPresent([{
            source: canvas, attributes: EXTRA_PRESENTATION_ATTRIBUTES }]);
      }
      const session = new Session(mode, enabledFeatures, {
        renderContextType: this.HAS_BITMAP_SUPPORT ? 'bitmaprenderer' : '2d'
      });
      this.sessions.set(session.id, session);
      if (immersive) {
        this.immersiveSession = session;
        this.dispatchEvent('@@webxr-polyfill/vr-present-start', session.id);
      }
      return Promise.resolve(session.id);
    }
    requestAnimationFrame(callback) {
      return this.display.requestAnimationFrame(callback);
    }
    getPrimaryButtonIndex(gamepad) {
      let primaryButton = 0;
      let name = gamepad.id.toLowerCase();
      for (let key in PRIMARY_BUTTON_MAP) {
        if (name.includes(key)) {
          primaryButton = PRIMARY_BUTTON_MAP[key];
          break;
        }
      }
      return Math.min(primaryButton, gamepad.buttons.length - 1);
    }
    onFrameStart(sessionId, renderState) {
      this.display.depthNear = renderState.depthNear;
      this.display.depthFar = renderState.depthFar;
      this.display.getFrameData(this.frame);
      const session = this.sessions.get(sessionId);
      if (session.immersive && this.CAN_USE_GAMEPAD) {
        let prevInputSources = this.gamepadInputSources;
        this.gamepadInputSources = {};
        let gamepads = this.global.navigator.getGamepads();
        for (let i = 0; i < gamepads.length; ++i) {
          let gamepad = gamepads[i];
          if (gamepad && gamepad.displayId > 0) {
            let inputSourceImpl = prevInputSources[i];
            if (!inputSourceImpl) {
              inputSourceImpl = new GamepadXRInputSource(this, this.display, this.getPrimaryButtonIndex(gamepad));
            }
            inputSourceImpl.updateFromGamepad(gamepad);
            this.gamepadInputSources[i] = inputSourceImpl;
            if (inputSourceImpl.primaryButtonIndex != -1) {
              let primaryActionPressed = gamepad.buttons[inputSourceImpl.primaryButtonIndex].pressed;
              if (primaryActionPressed && !inputSourceImpl.primaryActionPressed) {
                this.dispatchEvent('@@webxr-polyfill/input-select-start', { sessionId: session.id, inputSource: inputSourceImpl.inputSource });
              } else if (!primaryActionPressed && inputSourceImpl.primaryActionPressed) {
                this.dispatchEvent('@@webxr-polyfill/input-select-end', { sessionId: session.id, inputSource: inputSourceImpl.inputSource });
              }
              inputSourceImpl.primaryActionPressed = primaryActionPressed;
            }
            if (inputSourceImpl.primarySqueezeButtonIndex != -1) {
              let primarySqueezeActionPressed = gamepad.buttons[inputSourceImpl.primarySqueezeButtonIndex].pressed;
              if (primarySqueezeActionPressed && !inputSourceImpl.primarySqueezeActionPressed) {
                this.dispatchEvent('@@webxr-polyfill/input-squeeze-start', { sessionId: session.id, inputSource: inputSourceImpl.inputSource });
              } else if (!primarySqueezeActionPressed && inputSourceImpl.primarySqueezeActionPressed) {
                this.dispatchEvent('@@webxr-polyfill/input-squeeze-end', { sessionId: session.id, inputSource: inputSourceImpl.inputSource });
              }
              inputSourceImpl.primarySqueezeActionPressed = primarySqueezeActionPressed;
            }
          }
        }
      }
      if (!session.immersive && session.baseLayer) {
        const canvas = session.baseLayer.context.canvas;
        perspective(this.frame.leftProjectionMatrix, renderState.inlineVerticalFieldOfView,
            canvas.width/canvas.height, renderState.depthNear, renderState.depthFar);
      }
    }
    onFrameEnd(sessionId) {
      const session = this.sessions.get(sessionId);
      if (session.ended || !session.baseLayer) {
        return;
      }
      if (session.outputContext &&
          !(session.immersive && !this.display.capabilities.hasExternalDisplay)) {
        const mirroring =
          session.immersive && this.display.capabilities.hasExternalDisplay;
        const iCanvas = session.baseLayer.context.canvas;
        const iWidth = mirroring ? iCanvas.width / 2 : iCanvas.width;
        const iHeight = iCanvas.height;
        {
          const oCanvas = session.outputContext.canvas;
          const oWidth = oCanvas.width;
          const oHeight = oCanvas.height;
          const renderContext = session.renderContext;
          if (this.HAS_BITMAP_SUPPORT) {
            if (iCanvas.transferToImageBitmap) {
              renderContext.transferFromImageBitmap(iCanvas.transferToImageBitmap());
            }
            else {
              this.global.createImageBitmap(iCanvas, 0, 0, iWidth, iHeight, {
                resizeWidth: oWidth,
                resizeHeight: oHeight,
              }).then(bitmap => renderContext.transferFromImageBitmap(bitmap));
            }
          } else {
            renderContext.drawImage(iCanvas, 0, 0, iWidth, iHeight,
                                             0, 0, oWidth, oHeight);
          }
        }
      }
      if (session.immersive && session.baseLayer) {
        this.display.submitFrame();
      }
    }
    cancelAnimationFrame(handle) {
      this.display.cancelAnimationFrame(handle);
    }
    async endSession(sessionId) {
      const session = this.sessions.get(sessionId);
      if (session.ended) {
        return;
      }
      if (session.immersive) {
        return this.display.exitPresent();
      } else {
        session.ended = true;
      }
    }
    doesSessionSupportReferenceSpace(sessionId, type) {
      const session = this.sessions.get(sessionId);
      if (session.ended) {
        return false;
      }
      return session.enabledFeatures.has(type);
    }
    requestStageBounds() {
      if (this.display.stageParameters) {
        const width = this.display.stageParameters.sizeX;
        const depth = this.display.stageParameters.sizeZ;
        const data = [];
        data.push(-width / 2);
        data.push(-depth / 2);
        data.push(width / 2);
        data.push(-depth / 2);
        data.push(width / 2);
        data.push(depth / 2);
        data.push(-width / 2);
        data.push(depth / 2);
        return data;
      }
      return null;
    }
    async requestFrameOfReferenceTransform(type, options) {
      if ((type === 'local-floor' || type === 'bounded-floor') &&
          this.display.stageParameters &&
          this.display.stageParameters.sittingToStandingTransform) {
        return this.display.stageParameters.sittingToStandingTransform;
      }
      return null;
    }
    getProjectionMatrix(eye) {
      if (eye === 'left') {
        return this.frame.leftProjectionMatrix;
      } else if (eye === 'right') {
        return this.frame.rightProjectionMatrix;
      } else if (eye === 'none') {
        return this.frame.leftProjectionMatrix;
      } else {
        throw new Error(`eye must be of type 'left' or 'right'`);
      }
    }
    getViewport(sessionId, eye, layer, target) {
      const session = this.sessions.get(sessionId);
      const { width, height } = layer.context.canvas;
      if (!session.immersive) {
        target.x = target.y = 0;
        target.width = width;
        target.height = height;
        return true;
      }
      if (eye === 'left' || eye === 'none') {
        target.x = 0;
      } else if (eye === 'right') {
        target.x = width / 2;
      } else {
        return false;
      }
      target.y = 0;
      target.width = width / 2;
      target.height = height;
      return true;
    }
    getBasePoseMatrix() {
      let { position, orientation } = this.frame.pose;
      if (!position && !orientation) {
        return this.baseModelMatrix;
      }
      if (!position) {
        position = this.tempVec3;
        position[0] = position[1] = position[2] = 0;
      }
      fromRotationTranslation(this.baseModelMatrix, orientation, position);
      return this.baseModelMatrix;
    }
    getBaseViewMatrix(eye) {
      if (eye === 'left' || eye === 'none') {
        return this.frame.leftViewMatrix;
      } else if (eye === 'right') {
        return this.frame.rightViewMatrix;
      } else {
        throw new Error(`eye must be of type 'left' or 'right'`);
      }
    }
    getInputSources() {
      let inputSources = [];
      for (let i in this.gamepadInputSources) {
        inputSources.push(this.gamepadInputSources[i].inputSource);
      }
      return inputSources;
    }
    getInputPose(inputSource, coordinateSystem, poseType) {
      if (!coordinateSystem) {
        return null;
      }
      for (let i in this.gamepadInputSources) {
        let inputSourceImpl = this.gamepadInputSources[i];
        if (inputSourceImpl.inputSource === inputSource) {
          return inputSourceImpl.getXRPose(coordinateSystem, poseType);
        }
      }
      return null;
    }
    onWindowResize() {
    }
    onVRDisplayPresentChange(e) {
      if (!this.display.isPresenting) {
        this.sessions.forEach(session => {
          if (session.immersive && !session.ended) {
            if (session.modifiedCanvasLayer) {
              const canvas = session.baseLayer.context.canvas;
              document.body.removeChild(canvas);
              canvas.setAttribute('style', '');
            }
            if (this.immersiveSession === session) {
              this.immersiveSession = null;
            }
            this.dispatchEvent('@@webxr-polyfill/vr-present-end', session.id);
          }
        });
      }
    }
  }

  class CardboardXRDevice extends WebVRDevice {
    constructor(global, cardboardConfig) {
      const display = new CardboardVRDisplay(cardboardConfig || {});
      super(global, display);
      this.display = display;
      this.frame = {
        rightViewMatrix: new Float32Array(16),
        leftViewMatrix: new Float32Array(16),
        rightProjectionMatrix: new Float32Array(16),
        leftProjectionMatrix: new Float32Array(16),
        pose: null,
        timestamp: null,
      };
    }
  }
  let SESSION_ID$1 = 0;
  class Session$1 {
    constructor(mode, enabledFeatures) {
      this.mode = mode;
      this.enabledFeatures = enabledFeatures;
      this.ended = null;
      this.baseLayer = null;
      this.id = ++SESSION_ID$1;
    }
  }
  class InlineDevice extends XRDevice {
    constructor(global) {
      super(global);
      this.sessions = new Map();
      this.projectionMatrix = create();
      this.identityMatrix = create();
    }
    onBaseLayerSet(sessionId, layer) {
      const session = this.sessions.get(sessionId);
      session.baseLayer = layer;
    }
    isSessionSupported(mode) {
      return mode == 'inline';
    }
    isFeatureSupported(featureDescriptor) {
      switch(featureDescriptor) {
        case 'viewer': return true;
        default: return false;
      }
    }
    async requestSession(mode, enabledFeatures) {
      if (!this.isSessionSupported(mode)) {
        return Promise.reject();
      }
      const session = new Session$1(mode, enabledFeatures);
      this.sessions.set(session.id, session);
      return Promise.resolve(session.id);
    }
    requestAnimationFrame(callback) {
      return window.requestAnimationFrame(callback);
    }
    cancelAnimationFrame(handle) {
      window.cancelAnimationFrame(handle);
    }
    onFrameStart(sessionId, renderState) {
      const session = this.sessions.get(sessionId);
      if (session.baseLayer) {
        const canvas = session.baseLayer.context.canvas;
        perspective(this.projectionMatrix, renderState.inlineVerticalFieldOfView,
            canvas.width/canvas.height, renderState.depthNear, renderState.depthFar);
      }
    }
    onFrameEnd(sessionId) {
    }
    async endSession(sessionId) {
      const session = this.sessions.get(sessionId);
      session.ended = true;
    }
    doesSessionSupportReferenceSpace(sessionId, type) {
      const session = this.sessions.get(sessionId);
      if (session.ended) {
        return false;
      }
      return session.enabledFeatures.has(type);
    }
    requestStageBounds() {
      return null;
    }
    async requestFrameOfReferenceTransform(type, options) {
      return null;
    }
    getProjectionMatrix(eye) {
      return this.projectionMatrix;
    }
    getViewport(sessionId, eye, layer, target) {
      const session = this.sessions.get(sessionId);
      const { width, height } = layer.context.canvas;
      target.x = target.y = 0;
      target.width = width;
      target.height = height;
      return true;
    }
    getBasePoseMatrix() {
      return this.identityMatrix;
    }
    getBaseViewMatrix(eye) {
      return this.identityMatrix;
    }
    getInputSources() {
      return [];
    }
    getInputPose(inputSource, coordinateSystem, poseType) {
      return null;
    }
    onWindowResize() {
    }
  }

  const getWebVRDevice = async function (global) {
    let device = null;
    if ('getVRDisplays' in global.navigator) {
      try {
        const displays = await global.navigator.getVRDisplays();
        if (displays && displays.length) {
          device = new WebVRDevice(global, displays[0]);
        }
      } catch (e) {}
    }
    return device;
  };
  const requestXRDevice = async function (global, config) {
    if (config.webvr) {
      let xr = await getWebVRDevice(global);
      if (xr) {
        return xr;
      }
    }
    let mobile = isMobile(global);
    if ((mobile && config.cardboard) ||
        (!mobile && config.allowCardboardOnDesktop)) {
      if (!global.VRFrameData) {
        global.VRFrameData = function () {
          this.rightViewMatrix = new Float32Array(16);
          this.leftViewMatrix = new Float32Array(16);
          this.rightProjectionMatrix = new Float32Array(16);
          this.leftProjectionMatrix = new Float32Array(16);
          this.pose = null;
        };
      }
      return new CardboardXRDevice(global, config.cardboardConfig);
    }
    return new InlineDevice(global);
  };

  const CONFIG_DEFAULTS = {
    global: _global$1,
    webvr: true,
    cardboard: true,
    cardboardConfig: null,
    allowCardboardOnDesktop: false,
  };
  const partials = ['navigator', 'HTMLCanvasElement', 'WebGLRenderingContext'];
  class WebXRPolyfill {
    constructor(config={}) {
      this.config = Object.freeze(Object.assign({}, CONFIG_DEFAULTS, config));
      this.global = this.config.global;
      this.nativeWebXR = 'xr' in this.global.navigator;
      this.injected = false;
      if (!this.nativeWebXR) {
        this._injectPolyfill(this.global);
      } else {
        this._injectCompatibilityShims(this.global);
      }
    }
    _injectPolyfill(global) {
      if (!partials.every(iface => !!global[iface])) {
        throw new Error(`Global must have the following attributes : ${partials}`);
      }
      for (const className of Object.keys(API)) {
        if (global[className] !== undefined) {
          console.warn(`${className} already defined on global.`);
        } else {
          global[className] = API[className];
        }
      }
      {
        const polyfilledCtx = polyfillMakeXRCompatible(global.WebGLRenderingContext);
        if (polyfilledCtx) {
          polyfillGetContext(global.HTMLCanvasElement);
          if (global.OffscreenCanvas) {
            polyfillGetContext(global.OffscreenCanvas);
          }
          if (global.WebGL2RenderingContext){
            polyfillMakeXRCompatible(global.WebGL2RenderingContext);
          }
          if (!window.isSecureContext) {
            console.warn(`WebXR Polyfill Warning:
This page is not running in a secure context (https:// or localhost)!
This means that although the page may be able to use the WebXR Polyfill it will
not be able to use native WebXR implementations, and as such will not be able to
access dedicated VR or AR hardware, and will not be able to take advantage of
any performance improvements a native WebXR implementation may offer. Please
host this content on a secure origin for the best user experience.
`);
          }
        }
      }
      this.injected = true;
      this._patchNavigatorXR();
    }
    _patchNavigatorXR() {
      let devicePromise = requestXRDevice(this.global, this.config);
      this.xr = new API.XRSystem(devicePromise);
      Object.defineProperty(this.global.navigator, 'xr', {
        value: this.xr,
        configurable: true,
      });
    }
    _injectCompatibilityShims(global) {
      if (!partials.every(iface => !!global[iface])) {
        throw new Error(`Global must have the following attributes : ${partials}`);
      }
      if (global.navigator.xr &&
          'supportsSession' in global.navigator.xr &&
          !('isSessionSupported' in global.navigator.xr)) {
        let originalSupportsSession = global.navigator.xr.supportsSession;
        global.navigator.xr.isSessionSupported = function(mode) {
          return originalSupportsSession.call(this, mode).then(() => {
            return true;
          }).catch(() => {
            return false;
          });
        };
        global.navigator.xr.supportsSession = function(mode) {
          console.warn("navigator.xr.supportsSession() is deprecated. Please " +
          "call navigator.xr.isSessionSupported() instead and check the boolean " +
          "value returned when the promise resolves.");
          return originalSupportsSession.call(this, mode);
        };
      }
    }
  }

  // threejs.org/license
  const REVISION = '125';
  const MOUSE = { LEFT: 0, MIDDLE: 1, RIGHT: 2, ROTATE: 0, DOLLY: 1, PAN: 2 };
  const TOUCH = { ROTATE: 0, PAN: 1, DOLLY_PAN: 2, DOLLY_ROTATE: 3 };
  const CullFaceNone = 0;
  const CullFaceBack = 1;
  const CullFaceFront = 2;
  const PCFShadowMap = 1;
  const PCFSoftShadowMap = 2;
  const VSMShadowMap = 3;
  const FrontSide = 0;
  const BackSide = 1;
  const DoubleSide = 2;
  const FlatShading = 1;
  const NoBlending = 0;
  const NormalBlending = 1;
  const AdditiveBlending = 2;
  const SubtractiveBlending = 3;
  const MultiplyBlending = 4;
  const CustomBlending = 5;
  const AddEquation = 100;
  const SubtractEquation = 101;
  const ReverseSubtractEquation = 102;
  const MinEquation = 103;
  const MaxEquation = 104;
  const ZeroFactor = 200;
  const OneFactor = 201;
  const SrcColorFactor = 202;
  const OneMinusSrcColorFactor = 203;
  const SrcAlphaFactor = 204;
  const OneMinusSrcAlphaFactor = 205;
  const DstAlphaFactor = 206;
  const OneMinusDstAlphaFactor = 207;
  const DstColorFactor = 208;
  const OneMinusDstColorFactor = 209;
  const SrcAlphaSaturateFactor = 210;
  const NeverDepth = 0;
  const AlwaysDepth = 1;
  const LessDepth = 2;
  const LessEqualDepth = 3;
  const EqualDepth = 4;
  const GreaterEqualDepth = 5;
  const GreaterDepth = 6;
  const NotEqualDepth = 7;
  const MultiplyOperation = 0;
  const MixOperation = 1;
  const AddOperation = 2;
  const NoToneMapping = 0;
  const LinearToneMapping = 1;
  const ReinhardToneMapping = 2;
  const CineonToneMapping = 3;
  const ACESFilmicToneMapping = 4;
  const CustomToneMapping = 5;

  const UVMapping = 300;
  const CubeReflectionMapping = 301;
  const CubeRefractionMapping = 302;
  const EquirectangularReflectionMapping = 303;
  const EquirectangularRefractionMapping = 304;
  const CubeUVReflectionMapping = 306;
  const CubeUVRefractionMapping = 307;
  const RepeatWrapping = 1000;
  const ClampToEdgeWrapping = 1001;
  const MirroredRepeatWrapping = 1002;
  const NearestFilter = 1003;
  const NearestMipmapNearestFilter = 1004;
  const NearestMipmapLinearFilter = 1005;
  const LinearFilter = 1006;
  const LinearMipmapNearestFilter = 1007;
  const LinearMipmapLinearFilter = 1008;
  const UnsignedByteType = 1009;
  const ByteType = 1010;
  const ShortType = 1011;
  const UnsignedShortType = 1012;
  const IntType = 1013;
  const UnsignedIntType = 1014;
  const FloatType = 1015;
  const HalfFloatType = 1016;
  const UnsignedShort4444Type = 1017;
  const UnsignedShort5551Type = 1018;
  const UnsignedShort565Type = 1019;
  const UnsignedInt248Type = 1020;
  const AlphaFormat = 1021;
  const RGBFormat = 1022;
  const RGBAFormat = 1023;
  const LuminanceFormat = 1024;
  const LuminanceAlphaFormat = 1025;
  const DepthFormat = 1026;
  const DepthStencilFormat = 1027;
  const RedFormat = 1028;
  const RedIntegerFormat = 1029;
  const RGFormat = 1030;
  const RGIntegerFormat = 1031;
  const RGBIntegerFormat = 1032;
  const RGBAIntegerFormat = 1033;

  const RGB_S3TC_DXT1_Format = 33776;
  const RGBA_S3TC_DXT1_Format = 33777;
  const RGBA_S3TC_DXT3_Format = 33778;
  const RGBA_S3TC_DXT5_Format = 33779;
  const RGB_PVRTC_4BPPV1_Format = 35840;
  const RGB_PVRTC_2BPPV1_Format = 35841;
  const RGBA_PVRTC_4BPPV1_Format = 35842;
  const RGBA_PVRTC_2BPPV1_Format = 35843;
  const RGB_ETC1_Format = 36196;
  const RGB_ETC2_Format = 37492;
  const RGBA_ETC2_EAC_Format = 37496;
  const RGBA_ASTC_4x4_Format = 37808;
  const RGBA_ASTC_5x4_Format = 37809;
  const RGBA_ASTC_5x5_Format = 37810;
  const RGBA_ASTC_6x5_Format = 37811;
  const RGBA_ASTC_6x6_Format = 37812;
  const RGBA_ASTC_8x5_Format = 37813;
  const RGBA_ASTC_8x6_Format = 37814;
  const RGBA_ASTC_8x8_Format = 37815;
  const RGBA_ASTC_10x5_Format = 37816;
  const RGBA_ASTC_10x6_Format = 37817;
  const RGBA_ASTC_10x8_Format = 37818;
  const RGBA_ASTC_10x10_Format = 37819;
  const RGBA_ASTC_12x10_Format = 37820;
  const RGBA_ASTC_12x12_Format = 37821;
  const RGBA_BPTC_Format = 36492;
  const SRGB8_ALPHA8_ASTC_4x4_Format = 37840;
  const SRGB8_ALPHA8_ASTC_5x4_Format = 37841;
  const SRGB8_ALPHA8_ASTC_5x5_Format = 37842;
  const SRGB8_ALPHA8_ASTC_6x5_Format = 37843;
  const SRGB8_ALPHA8_ASTC_6x6_Format = 37844;
  const SRGB8_ALPHA8_ASTC_8x5_Format = 37845;
  const SRGB8_ALPHA8_ASTC_8x6_Format = 37846;
  const SRGB8_ALPHA8_ASTC_8x8_Format = 37847;
  const SRGB8_ALPHA8_ASTC_10x5_Format = 37848;
  const SRGB8_ALPHA8_ASTC_10x6_Format = 37849;
  const SRGB8_ALPHA8_ASTC_10x8_Format = 37850;
  const SRGB8_ALPHA8_ASTC_10x10_Format = 37851;
  const SRGB8_ALPHA8_ASTC_12x10_Format = 37852;
  const SRGB8_ALPHA8_ASTC_12x12_Format = 37853;
  const LoopOnce = 2200;
  const LoopRepeat = 2201;
  const LoopPingPong = 2202;
  const InterpolateDiscrete = 2300;
  const InterpolateLinear = 2301;
  const InterpolateSmooth = 2302;
  const ZeroCurvatureEnding = 2400;
  const ZeroSlopeEnding = 2401;
  const WrapAroundEnding = 2402;
  const NormalAnimationBlendMode = 2500;
  const AdditiveAnimationBlendMode = 2501;
  const TrianglesDrawMode = 0;
  const LinearEncoding = 3000;
  const sRGBEncoding = 3001;
  const GammaEncoding = 3007;
  const RGBEEncoding = 3002;
  const LogLuvEncoding = 3003;
  const RGBM7Encoding = 3004;
  const RGBM16Encoding = 3005;
  const RGBDEncoding = 3006;
  const BasicDepthPacking = 3200;
  const RGBADepthPacking = 3201;
  const TangentSpaceNormalMap = 0;
  const ObjectSpaceNormalMap = 1;
  const KeepStencilOp = 7680;
  const AlwaysStencilFunc = 519;

  const StaticDrawUsage = 35044;
  const DynamicDrawUsage = 35048;
  const GLSL3 = '300 es';

  /**
   * https://github.com/mrdoob/eventdispatcher.js/
   */

  function EventDispatcher() {}

  Object.assign( EventDispatcher.prototype, {

  	addEventListener: function ( type, listener ) {

  		if ( this._listeners === undefined ) this._listeners = {};

  		const listeners = this._listeners;

  		if ( listeners[ type ] === undefined ) {

  			listeners[ type ] = [];

  		}

  		if ( listeners[ type ].indexOf( listener ) === - 1 ) {

  			listeners[ type ].push( listener );

  		}

  	},

  	hasEventListener: function ( type, listener ) {

  		if ( this._listeners === undefined ) return false;

  		const listeners = this._listeners;

  		return listeners[ type ] !== undefined && listeners[ type ].indexOf( listener ) !== - 1;

  	},

  	removeEventListener: function ( type, listener ) {

  		if ( this._listeners === undefined ) return;

  		const listeners = this._listeners;
  		const listenerArray = listeners[ type ];

  		if ( listenerArray !== undefined ) {

  			const index = listenerArray.indexOf( listener );

  			if ( index !== - 1 ) {

  				listenerArray.splice( index, 1 );

  			}

  		}

  	},

  	dispatchEvent: function ( event ) {

  		if ( this._listeners === undefined ) return;

  		const listeners = this._listeners;
  		const listenerArray = listeners[ event.type ];

  		if ( listenerArray !== undefined ) {

  			event.target = this;

  			// Make a copy, in case listeners are removed while iterating.
  			const array = listenerArray.slice( 0 );

  			for ( let i = 0, l = array.length; i < l; i ++ ) {

  				array[ i ].call( this, event );

  			}

  		}

  	}

  } );

  const _lut = [];

  for ( let i = 0; i < 256; i ++ ) {

  	_lut[ i ] = ( i < 16 ? '0' : '' ) + ( i ).toString( 16 );

  }

  let _seed = 1234567;

  const MathUtils = {

  	DEG2RAD: Math.PI / 180,
  	RAD2DEG: 180 / Math.PI,

  	generateUUID: function () {

  		// http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136

  		const d0 = Math.random() * 0xffffffff | 0;
  		const d1 = Math.random() * 0xffffffff | 0;
  		const d2 = Math.random() * 0xffffffff | 0;
  		const d3 = Math.random() * 0xffffffff | 0;
  		const uuid = _lut[ d0 & 0xff ] + _lut[ d0 >> 8 & 0xff ] + _lut[ d0 >> 16 & 0xff ] + _lut[ d0 >> 24 & 0xff ] + '-' +
  			_lut[ d1 & 0xff ] + _lut[ d1 >> 8 & 0xff ] + '-' + _lut[ d1 >> 16 & 0x0f | 0x40 ] + _lut[ d1 >> 24 & 0xff ] + '-' +
  			_lut[ d2 & 0x3f | 0x80 ] + _lut[ d2 >> 8 & 0xff ] + '-' + _lut[ d2 >> 16 & 0xff ] + _lut[ d2 >> 24 & 0xff ] +
  			_lut[ d3 & 0xff ] + _lut[ d3 >> 8 & 0xff ] + _lut[ d3 >> 16 & 0xff ] + _lut[ d3 >> 24 & 0xff ];

  		// .toUpperCase() here flattens concatenated strings to save heap memory space.
  		return uuid.toUpperCase();

  	},

  	clamp: function ( value, min, max ) {

  		return Math.max( min, Math.min( max, value ) );

  	},

  	// compute euclidian modulo of m % n
  	// https://en.wikipedia.org/wiki/Modulo_operation

  	euclideanModulo: function ( n, m ) {

  		return ( ( n % m ) + m ) % m;

  	},

  	// Linear mapping from range <a1, a2> to range <b1, b2>

  	mapLinear: function ( x, a1, a2, b1, b2 ) {

  		return b1 + ( x - a1 ) * ( b2 - b1 ) / ( a2 - a1 );

  	},

  	// https://en.wikipedia.org/wiki/Linear_interpolation

  	lerp: function ( x, y, t ) {

  		return ( 1 - t ) * x + t * y;

  	},

  	// http://www.rorydriscoll.com/2016/03/07/frame-rate-independent-damping-using-lerp/

  	damp: function ( x, y, lambda, dt ) {

  		return MathUtils.lerp( x, y, 1 - Math.exp( - lambda * dt ) );

  	},

  	// https://www.desmos.com/calculator/vcsjnyz7x4

  	pingpong: function ( x, length = 1 ) {

  		return length - Math.abs( MathUtils.euclideanModulo( x, length * 2 ) - length );

  	},

  	// http://en.wikipedia.org/wiki/Smoothstep

  	smoothstep: function ( x, min, max ) {

  		if ( x <= min ) return 0;
  		if ( x >= max ) return 1;

  		x = ( x - min ) / ( max - min );

  		return x * x * ( 3 - 2 * x );

  	},

  	smootherstep: function ( x, min, max ) {

  		if ( x <= min ) return 0;
  		if ( x >= max ) return 1;

  		x = ( x - min ) / ( max - min );

  		return x * x * x * ( x * ( x * 6 - 15 ) + 10 );

  	},

  	// Random integer from <low, high> interval

  	randInt: function ( low, high ) {

  		return low + Math.floor( Math.random() * ( high - low + 1 ) );

  	},

  	// Random float from <low, high> interval

  	randFloat: function ( low, high ) {

  		return low + Math.random() * ( high - low );

  	},

  	// Random float from <-range/2, range/2> interval

  	randFloatSpread: function ( range ) {

  		return range * ( 0.5 - Math.random() );

  	},

  	// Deterministic pseudo-random float in the interval [ 0, 1 ]

  	seededRandom: function ( s ) {

  		if ( s !== undefined ) _seed = s % 2147483647;

  		// Park-Miller algorithm

  		_seed = _seed * 16807 % 2147483647;

  		return ( _seed - 1 ) / 2147483646;

  	},

  	degToRad: function ( degrees ) {

  		return degrees * MathUtils.DEG2RAD;

  	},

  	radToDeg: function ( radians ) {

  		return radians * MathUtils.RAD2DEG;

  	},

  	isPowerOfTwo: function ( value ) {

  		return ( value & ( value - 1 ) ) === 0 && value !== 0;

  	},

  	ceilPowerOfTwo: function ( value ) {

  		return Math.pow( 2, Math.ceil( Math.log( value ) / Math.LN2 ) );

  	},

  	floorPowerOfTwo: function ( value ) {

  		return Math.pow( 2, Math.floor( Math.log( value ) / Math.LN2 ) );

  	},

  	setQuaternionFromProperEuler: function ( q, a, b, c, order ) {

  		// Intrinsic Proper Euler Angles - see https://en.wikipedia.org/wiki/Euler_angles

  		// rotations are applied to the axes in the order specified by 'order'
  		// rotation by angle 'a' is applied first, then by angle 'b', then by angle 'c'
  		// angles are in radians

  		const cos = Math.cos;
  		const sin = Math.sin;

  		const c2 = cos( b / 2 );
  		const s2 = sin( b / 2 );

  		const c13 = cos( ( a + c ) / 2 );
  		const s13 = sin( ( a + c ) / 2 );

  		const c1_3 = cos( ( a - c ) / 2 );
  		const s1_3 = sin( ( a - c ) / 2 );

  		const c3_1 = cos( ( c - a ) / 2 );
  		const s3_1 = sin( ( c - a ) / 2 );

  		switch ( order ) {

  			case 'XYX':
  				q.set( c2 * s13, s2 * c1_3, s2 * s1_3, c2 * c13 );
  				break;

  			case 'YZY':
  				q.set( s2 * s1_3, c2 * s13, s2 * c1_3, c2 * c13 );
  				break;

  			case 'ZXZ':
  				q.set( s2 * c1_3, s2 * s1_3, c2 * s13, c2 * c13 );
  				break;

  			case 'XZX':
  				q.set( c2 * s13, s2 * s3_1, s2 * c3_1, c2 * c13 );
  				break;

  			case 'YXY':
  				q.set( s2 * c3_1, c2 * s13, s2 * s3_1, c2 * c13 );
  				break;

  			case 'ZYZ':
  				q.set( s2 * s3_1, s2 * c3_1, c2 * s13, c2 * c13 );
  				break;

  			default:
  				console.warn( 'THREE.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: ' + order );

  		}

  	}

  };

  class Vector2 {

  	constructor( x = 0, y = 0 ) {

  		Object.defineProperty( this, 'isVector2', { value: true } );

  		this.x = x;
  		this.y = y;

  	}

  	get width() {

  		return this.x;

  	}

  	set width( value ) {

  		this.x = value;

  	}

  	get height() {

  		return this.y;

  	}

  	set height( value ) {

  		this.y = value;

  	}

  	set( x, y ) {

  		this.x = x;
  		this.y = y;

  		return this;

  	}

  	setScalar( scalar ) {

  		this.x = scalar;
  		this.y = scalar;

  		return this;

  	}

  	setX( x ) {

  		this.x = x;

  		return this;

  	}

  	setY( y ) {

  		this.y = y;

  		return this;

  	}

  	setComponent( index, value ) {

  		switch ( index ) {

  			case 0: this.x = value; break;
  			case 1: this.y = value; break;
  			default: throw new Error( 'index is out of range: ' + index );

  		}

  		return this;

  	}

  	getComponent( index ) {

  		switch ( index ) {

  			case 0: return this.x;
  			case 1: return this.y;
  			default: throw new Error( 'index is out of range: ' + index );

  		}

  	}

  	clone() {

  		return new this.constructor( this.x, this.y );

  	}

  	copy( v ) {

  		this.x = v.x;
  		this.y = v.y;

  		return this;

  	}

  	add( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );
  			return this.addVectors( v, w );

  		}

  		this.x += v.x;
  		this.y += v.y;

  		return this;

  	}

  	addScalar( s ) {

  		this.x += s;
  		this.y += s;

  		return this;

  	}

  	addVectors( a, b ) {

  		this.x = a.x + b.x;
  		this.y = a.y + b.y;

  		return this;

  	}

  	addScaledVector( v, s ) {

  		this.x += v.x * s;
  		this.y += v.y * s;

  		return this;

  	}

  	sub( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );
  			return this.subVectors( v, w );

  		}

  		this.x -= v.x;
  		this.y -= v.y;

  		return this;

  	}

  	subScalar( s ) {

  		this.x -= s;
  		this.y -= s;

  		return this;

  	}

  	subVectors( a, b ) {

  		this.x = a.x - b.x;
  		this.y = a.y - b.y;

  		return this;

  	}

  	multiply( v ) {

  		this.x *= v.x;
  		this.y *= v.y;

  		return this;

  	}

  	multiplyScalar( scalar ) {

  		this.x *= scalar;
  		this.y *= scalar;

  		return this;

  	}

  	divide( v ) {

  		this.x /= v.x;
  		this.y /= v.y;

  		return this;

  	}

  	divideScalar( scalar ) {

  		return this.multiplyScalar( 1 / scalar );

  	}

  	applyMatrix3( m ) {

  		const x = this.x, y = this.y;
  		const e = m.elements;

  		this.x = e[ 0 ] * x + e[ 3 ] * y + e[ 6 ];
  		this.y = e[ 1 ] * x + e[ 4 ] * y + e[ 7 ];

  		return this;

  	}

  	min( v ) {

  		this.x = Math.min( this.x, v.x );
  		this.y = Math.min( this.y, v.y );

  		return this;

  	}

  	max( v ) {

  		this.x = Math.max( this.x, v.x );
  		this.y = Math.max( this.y, v.y );

  		return this;

  	}

  	clamp( min, max ) {

  		// assumes min < max, componentwise

  		this.x = Math.max( min.x, Math.min( max.x, this.x ) );
  		this.y = Math.max( min.y, Math.min( max.y, this.y ) );

  		return this;

  	}

  	clampScalar( minVal, maxVal ) {

  		this.x = Math.max( minVal, Math.min( maxVal, this.x ) );
  		this.y = Math.max( minVal, Math.min( maxVal, this.y ) );

  		return this;

  	}

  	clampLength( min, max ) {

  		const length = this.length();

  		return this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );

  	}

  	floor() {

  		this.x = Math.floor( this.x );
  		this.y = Math.floor( this.y );

  		return this;

  	}

  	ceil() {

  		this.x = Math.ceil( this.x );
  		this.y = Math.ceil( this.y );

  		return this;

  	}

  	round() {

  		this.x = Math.round( this.x );
  		this.y = Math.round( this.y );

  		return this;

  	}

  	roundToZero() {

  		this.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );
  		this.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );

  		return this;

  	}

  	negate() {

  		this.x = - this.x;
  		this.y = - this.y;

  		return this;

  	}

  	dot( v ) {

  		return this.x * v.x + this.y * v.y;

  	}

  	cross( v ) {

  		return this.x * v.y - this.y * v.x;

  	}

  	lengthSq() {

  		return this.x * this.x + this.y * this.y;

  	}

  	length() {

  		return Math.sqrt( this.x * this.x + this.y * this.y );

  	}

  	manhattanLength() {

  		return Math.abs( this.x ) + Math.abs( this.y );

  	}

  	normalize() {

  		return this.divideScalar( this.length() || 1 );

  	}

  	angle() {

  		// computes the angle in radians with respect to the positive x-axis

  		const angle = Math.atan2( - this.y, - this.x ) + Math.PI;

  		return angle;

  	}

  	distanceTo( v ) {

  		return Math.sqrt( this.distanceToSquared( v ) );

  	}

  	distanceToSquared( v ) {

  		const dx = this.x - v.x, dy = this.y - v.y;
  		return dx * dx + dy * dy;

  	}

  	manhattanDistanceTo( v ) {

  		return Math.abs( this.x - v.x ) + Math.abs( this.y - v.y );

  	}

  	setLength( length ) {

  		return this.normalize().multiplyScalar( length );

  	}

  	lerp( v, alpha ) {

  		this.x += ( v.x - this.x ) * alpha;
  		this.y += ( v.y - this.y ) * alpha;

  		return this;

  	}

  	lerpVectors( v1, v2, alpha ) {

  		this.x = v1.x + ( v2.x - v1.x ) * alpha;
  		this.y = v1.y + ( v2.y - v1.y ) * alpha;

  		return this;

  	}

  	equals( v ) {

  		return ( ( v.x === this.x ) && ( v.y === this.y ) );

  	}

  	fromArray( array, offset = 0 ) {

  		this.x = array[ offset ];
  		this.y = array[ offset + 1 ];

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		array[ offset ] = this.x;
  		array[ offset + 1 ] = this.y;

  		return array;

  	}

  	fromBufferAttribute( attribute, index, offset ) {

  		if ( offset !== undefined ) {

  			console.warn( 'THREE.Vector2: offset has been removed from .fromBufferAttribute().' );

  		}

  		this.x = attribute.getX( index );
  		this.y = attribute.getY( index );

  		return this;

  	}

  	rotateAround( center, angle ) {

  		const c = Math.cos( angle ), s = Math.sin( angle );

  		const x = this.x - center.x;
  		const y = this.y - center.y;

  		this.x = x * c - y * s + center.x;
  		this.y = x * s + y * c + center.y;

  		return this;

  	}

  	random() {

  		this.x = Math.random();
  		this.y = Math.random();

  		return this;

  	}

  }

  class Matrix3 {

  	constructor() {

  		Object.defineProperty( this, 'isMatrix3', { value: true } );

  		this.elements = [

  			1, 0, 0,
  			0, 1, 0,
  			0, 0, 1

  		];

  		if ( arguments.length > 0 ) {

  			console.error( 'THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.' );

  		}

  	}

  	set( n11, n12, n13, n21, n22, n23, n31, n32, n33 ) {

  		const te = this.elements;

  		te[ 0 ] = n11; te[ 1 ] = n21; te[ 2 ] = n31;
  		te[ 3 ] = n12; te[ 4 ] = n22; te[ 5 ] = n32;
  		te[ 6 ] = n13; te[ 7 ] = n23; te[ 8 ] = n33;

  		return this;

  	}

  	identity() {

  		this.set(

  			1, 0, 0,
  			0, 1, 0,
  			0, 0, 1

  		);

  		return this;

  	}

  	clone() {

  		return new this.constructor().fromArray( this.elements );

  	}

  	copy( m ) {

  		const te = this.elements;
  		const me = m.elements;

  		te[ 0 ] = me[ 0 ]; te[ 1 ] = me[ 1 ]; te[ 2 ] = me[ 2 ];
  		te[ 3 ] = me[ 3 ]; te[ 4 ] = me[ 4 ]; te[ 5 ] = me[ 5 ];
  		te[ 6 ] = me[ 6 ]; te[ 7 ] = me[ 7 ]; te[ 8 ] = me[ 8 ];

  		return this;

  	}

  	extractBasis( xAxis, yAxis, zAxis ) {

  		xAxis.setFromMatrix3Column( this, 0 );
  		yAxis.setFromMatrix3Column( this, 1 );
  		zAxis.setFromMatrix3Column( this, 2 );

  		return this;

  	}

  	setFromMatrix4( m ) {

  		const me = m.elements;

  		this.set(

  			me[ 0 ], me[ 4 ], me[ 8 ],
  			me[ 1 ], me[ 5 ], me[ 9 ],
  			me[ 2 ], me[ 6 ], me[ 10 ]

  		);

  		return this;

  	}

  	multiply( m ) {

  		return this.multiplyMatrices( this, m );

  	}

  	premultiply( m ) {

  		return this.multiplyMatrices( m, this );

  	}

  	multiplyMatrices( a, b ) {

  		const ae = a.elements;
  		const be = b.elements;
  		const te = this.elements;

  		const a11 = ae[ 0 ], a12 = ae[ 3 ], a13 = ae[ 6 ];
  		const a21 = ae[ 1 ], a22 = ae[ 4 ], a23 = ae[ 7 ];
  		const a31 = ae[ 2 ], a32 = ae[ 5 ], a33 = ae[ 8 ];

  		const b11 = be[ 0 ], b12 = be[ 3 ], b13 = be[ 6 ];
  		const b21 = be[ 1 ], b22 = be[ 4 ], b23 = be[ 7 ];
  		const b31 = be[ 2 ], b32 = be[ 5 ], b33 = be[ 8 ];

  		te[ 0 ] = a11 * b11 + a12 * b21 + a13 * b31;
  		te[ 3 ] = a11 * b12 + a12 * b22 + a13 * b32;
  		te[ 6 ] = a11 * b13 + a12 * b23 + a13 * b33;

  		te[ 1 ] = a21 * b11 + a22 * b21 + a23 * b31;
  		te[ 4 ] = a21 * b12 + a22 * b22 + a23 * b32;
  		te[ 7 ] = a21 * b13 + a22 * b23 + a23 * b33;

  		te[ 2 ] = a31 * b11 + a32 * b21 + a33 * b31;
  		te[ 5 ] = a31 * b12 + a32 * b22 + a33 * b32;
  		te[ 8 ] = a31 * b13 + a32 * b23 + a33 * b33;

  		return this;

  	}

  	multiplyScalar( s ) {

  		const te = this.elements;

  		te[ 0 ] *= s; te[ 3 ] *= s; te[ 6 ] *= s;
  		te[ 1 ] *= s; te[ 4 ] *= s; te[ 7 ] *= s;
  		te[ 2 ] *= s; te[ 5 ] *= s; te[ 8 ] *= s;

  		return this;

  	}

  	determinant() {

  		const te = this.elements;

  		const a = te[ 0 ], b = te[ 1 ], c = te[ 2 ],
  			d = te[ 3 ], e = te[ 4 ], f = te[ 5 ],
  			g = te[ 6 ], h = te[ 7 ], i = te[ 8 ];

  		return a * e * i - a * f * h - b * d * i + b * f * g + c * d * h - c * e * g;

  	}

  	invert() {

  		const te = this.elements,

  			n11 = te[ 0 ], n21 = te[ 1 ], n31 = te[ 2 ],
  			n12 = te[ 3 ], n22 = te[ 4 ], n32 = te[ 5 ],
  			n13 = te[ 6 ], n23 = te[ 7 ], n33 = te[ 8 ],

  			t11 = n33 * n22 - n32 * n23,
  			t12 = n32 * n13 - n33 * n12,
  			t13 = n23 * n12 - n22 * n13,

  			det = n11 * t11 + n21 * t12 + n31 * t13;

  		if ( det === 0 ) return this.set( 0, 0, 0, 0, 0, 0, 0, 0, 0 );

  		const detInv = 1 / det;

  		te[ 0 ] = t11 * detInv;
  		te[ 1 ] = ( n31 * n23 - n33 * n21 ) * detInv;
  		te[ 2 ] = ( n32 * n21 - n31 * n22 ) * detInv;

  		te[ 3 ] = t12 * detInv;
  		te[ 4 ] = ( n33 * n11 - n31 * n13 ) * detInv;
  		te[ 5 ] = ( n31 * n12 - n32 * n11 ) * detInv;

  		te[ 6 ] = t13 * detInv;
  		te[ 7 ] = ( n21 * n13 - n23 * n11 ) * detInv;
  		te[ 8 ] = ( n22 * n11 - n21 * n12 ) * detInv;

  		return this;

  	}

  	transpose() {

  		let tmp;
  		const m = this.elements;

  		tmp = m[ 1 ]; m[ 1 ] = m[ 3 ]; m[ 3 ] = tmp;
  		tmp = m[ 2 ]; m[ 2 ] = m[ 6 ]; m[ 6 ] = tmp;
  		tmp = m[ 5 ]; m[ 5 ] = m[ 7 ]; m[ 7 ] = tmp;

  		return this;

  	}

  	getNormalMatrix( matrix4 ) {

  		return this.setFromMatrix4( matrix4 ).copy( this ).invert().transpose();

  	}

  	transposeIntoArray( r ) {

  		const m = this.elements;

  		r[ 0 ] = m[ 0 ];
  		r[ 1 ] = m[ 3 ];
  		r[ 2 ] = m[ 6 ];
  		r[ 3 ] = m[ 1 ];
  		r[ 4 ] = m[ 4 ];
  		r[ 5 ] = m[ 7 ];
  		r[ 6 ] = m[ 2 ];
  		r[ 7 ] = m[ 5 ];
  		r[ 8 ] = m[ 8 ];

  		return this;

  	}

  	setUvTransform( tx, ty, sx, sy, rotation, cx, cy ) {

  		const c = Math.cos( rotation );
  		const s = Math.sin( rotation );

  		this.set(
  			sx * c, sx * s, - sx * ( c * cx + s * cy ) + cx + tx,
  			- sy * s, sy * c, - sy * ( - s * cx + c * cy ) + cy + ty,
  			0, 0, 1
  		);

  		return this;

  	}

  	scale( sx, sy ) {

  		const te = this.elements;

  		te[ 0 ] *= sx; te[ 3 ] *= sx; te[ 6 ] *= sx;
  		te[ 1 ] *= sy; te[ 4 ] *= sy; te[ 7 ] *= sy;

  		return this;

  	}

  	rotate( theta ) {

  		const c = Math.cos( theta );
  		const s = Math.sin( theta );

  		const te = this.elements;

  		const a11 = te[ 0 ], a12 = te[ 3 ], a13 = te[ 6 ];
  		const a21 = te[ 1 ], a22 = te[ 4 ], a23 = te[ 7 ];

  		te[ 0 ] = c * a11 + s * a21;
  		te[ 3 ] = c * a12 + s * a22;
  		te[ 6 ] = c * a13 + s * a23;

  		te[ 1 ] = - s * a11 + c * a21;
  		te[ 4 ] = - s * a12 + c * a22;
  		te[ 7 ] = - s * a13 + c * a23;

  		return this;

  	}

  	translate( tx, ty ) {

  		const te = this.elements;

  		te[ 0 ] += tx * te[ 2 ]; te[ 3 ] += tx * te[ 5 ]; te[ 6 ] += tx * te[ 8 ];
  		te[ 1 ] += ty * te[ 2 ]; te[ 4 ] += ty * te[ 5 ]; te[ 7 ] += ty * te[ 8 ];

  		return this;

  	}

  	equals( matrix ) {

  		const te = this.elements;
  		const me = matrix.elements;

  		for ( let i = 0; i < 9; i ++ ) {

  			if ( te[ i ] !== me[ i ] ) return false;

  		}

  		return true;

  	}

  	fromArray( array, offset = 0 ) {

  		for ( let i = 0; i < 9; i ++ ) {

  			this.elements[ i ] = array[ i + offset ];

  		}

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		const te = this.elements;

  		array[ offset ] = te[ 0 ];
  		array[ offset + 1 ] = te[ 1 ];
  		array[ offset + 2 ] = te[ 2 ];

  		array[ offset + 3 ] = te[ 3 ];
  		array[ offset + 4 ] = te[ 4 ];
  		array[ offset + 5 ] = te[ 5 ];

  		array[ offset + 6 ] = te[ 6 ];
  		array[ offset + 7 ] = te[ 7 ];
  		array[ offset + 8 ] = te[ 8 ];

  		return array;

  	}

  }

  let _canvas;

  const ImageUtils = {

  	getDataURL: function ( image ) {

  		if ( /^data:/i.test( image.src ) ) {

  			return image.src;

  		}

  		if ( typeof HTMLCanvasElement == 'undefined' ) {

  			return image.src;

  		}

  		let canvas;

  		if ( image instanceof HTMLCanvasElement ) {

  			canvas = image;

  		} else {

  			if ( _canvas === undefined ) _canvas = document.createElementNS( 'http://www.w3.org/1999/xhtml', 'canvas' );

  			_canvas.width = image.width;
  			_canvas.height = image.height;

  			const context = _canvas.getContext( '2d' );

  			if ( image instanceof ImageData ) {

  				context.putImageData( image, 0, 0 );

  			} else {

  				context.drawImage( image, 0, 0, image.width, image.height );

  			}

  			canvas = _canvas;

  		}

  		if ( canvas.width > 2048 || canvas.height > 2048 ) {

  			return canvas.toDataURL( 'image/jpeg', 0.6 );

  		} else {

  			return canvas.toDataURL( 'image/png' );

  		}

  	}

  };

  let textureId = 0;

  function Texture( image = Texture.DEFAULT_IMAGE, mapping = Texture.DEFAULT_MAPPING, wrapS = ClampToEdgeWrapping, wrapT = ClampToEdgeWrapping, magFilter = LinearFilter, minFilter = LinearMipmapLinearFilter, format = RGBAFormat, type = UnsignedByteType, anisotropy = 1, encoding = LinearEncoding ) {

  	Object.defineProperty( this, 'id', { value: textureId ++ } );

  	this.uuid = MathUtils.generateUUID();

  	this.name = '';

  	this.image = image;
  	this.mipmaps = [];

  	this.mapping = mapping;

  	this.wrapS = wrapS;
  	this.wrapT = wrapT;

  	this.magFilter = magFilter;
  	this.minFilter = minFilter;

  	this.anisotropy = anisotropy;

  	this.format = format;
  	this.internalFormat = null;
  	this.type = type;

  	this.offset = new Vector2( 0, 0 );
  	this.repeat = new Vector2( 1, 1 );
  	this.center = new Vector2( 0, 0 );
  	this.rotation = 0;

  	this.matrixAutoUpdate = true;
  	this.matrix = new Matrix3();

  	this.generateMipmaps = true;
  	this.premultiplyAlpha = false;
  	this.flipY = true;
  	this.unpackAlignment = 4;	// valid values: 1, 2, 4, 8 (see http://www.khronos.org/opengles/sdk/docs/man/xhtml/glPixelStorei.xml)

  	// Values of encoding !== THREE.LinearEncoding only supported on map, envMap and emissiveMap.
  	//
  	// Also changing the encoding after already used by a Material will not automatically make the Material
  	// update. You need to explicitly call Material.needsUpdate to trigger it to recompile.
  	this.encoding = encoding;

  	this.version = 0;
  	this.onUpdate = null;

  }

  Texture.DEFAULT_IMAGE = undefined;
  Texture.DEFAULT_MAPPING = UVMapping;

  Texture.prototype = Object.assign( Object.create( EventDispatcher.prototype ), {

  	constructor: Texture,

  	isTexture: true,

  	updateMatrix: function () {

  		this.matrix.setUvTransform( this.offset.x, this.offset.y, this.repeat.x, this.repeat.y, this.rotation, this.center.x, this.center.y );

  	},

  	clone: function () {

  		return new this.constructor().copy( this );

  	},

  	copy: function ( source ) {

  		this.name = source.name;

  		this.image = source.image;
  		this.mipmaps = source.mipmaps.slice( 0 );

  		this.mapping = source.mapping;

  		this.wrapS = source.wrapS;
  		this.wrapT = source.wrapT;

  		this.magFilter = source.magFilter;
  		this.minFilter = source.minFilter;

  		this.anisotropy = source.anisotropy;

  		this.format = source.format;
  		this.internalFormat = source.internalFormat;
  		this.type = source.type;

  		this.offset.copy( source.offset );
  		this.repeat.copy( source.repeat );
  		this.center.copy( source.center );
  		this.rotation = source.rotation;

  		this.matrixAutoUpdate = source.matrixAutoUpdate;
  		this.matrix.copy( source.matrix );

  		this.generateMipmaps = source.generateMipmaps;
  		this.premultiplyAlpha = source.premultiplyAlpha;
  		this.flipY = source.flipY;
  		this.unpackAlignment = source.unpackAlignment;
  		this.encoding = source.encoding;

  		return this;

  	},

  	toJSON: function ( meta ) {

  		const isRootObject = ( meta === undefined || typeof meta === 'string' );

  		if ( ! isRootObject && meta.textures[ this.uuid ] !== undefined ) {

  			return meta.textures[ this.uuid ];

  		}

  		const output = {

  			metadata: {
  				version: 4.5,
  				type: 'Texture',
  				generator: 'Texture.toJSON'
  			},

  			uuid: this.uuid,
  			name: this.name,

  			mapping: this.mapping,

  			repeat: [ this.repeat.x, this.repeat.y ],
  			offset: [ this.offset.x, this.offset.y ],
  			center: [ this.center.x, this.center.y ],
  			rotation: this.rotation,

  			wrap: [ this.wrapS, this.wrapT ],

  			format: this.format,
  			type: this.type,
  			encoding: this.encoding,

  			minFilter: this.minFilter,
  			magFilter: this.magFilter,
  			anisotropy: this.anisotropy,

  			flipY: this.flipY,

  			premultiplyAlpha: this.premultiplyAlpha,
  			unpackAlignment: this.unpackAlignment

  		};

  		if ( this.image !== undefined ) {

  			// TODO: Move to THREE.Image

  			const image = this.image;

  			if ( image.uuid === undefined ) {

  				image.uuid = MathUtils.generateUUID(); // UGH

  			}

  			if ( ! isRootObject && meta.images[ image.uuid ] === undefined ) {

  				let url;

  				if ( Array.isArray( image ) ) {

  					// process array of images e.g. CubeTexture

  					url = [];

  					for ( let i = 0, l = image.length; i < l; i ++ ) {

  						// check cube texture with data textures

  						if ( image[ i ].isDataTexture ) {

  							url.push( serializeImage( image[ i ].image ) );

  						} else {

  							url.push( serializeImage( image[ i ] ) );

  						}

  					}

  				} else {

  					// process single image

  					url = serializeImage( image );

  				}

  				meta.images[ image.uuid ] = {
  					uuid: image.uuid,
  					url: url
  				};

  			}

  			output.image = image.uuid;

  		}

  		if ( ! isRootObject ) {

  			meta.textures[ this.uuid ] = output;

  		}

  		return output;

  	},

  	dispose: function () {

  		this.dispatchEvent( { type: 'dispose' } );

  	},

  	transformUv: function ( uv ) {

  		if ( this.mapping !== UVMapping ) return uv;

  		uv.applyMatrix3( this.matrix );

  		if ( uv.x < 0 || uv.x > 1 ) {

  			switch ( this.wrapS ) {

  				case RepeatWrapping:

  					uv.x = uv.x - Math.floor( uv.x );
  					break;

  				case ClampToEdgeWrapping:

  					uv.x = uv.x < 0 ? 0 : 1;
  					break;

  				case MirroredRepeatWrapping:

  					if ( Math.abs( Math.floor( uv.x ) % 2 ) === 1 ) {

  						uv.x = Math.ceil( uv.x ) - uv.x;

  					} else {

  						uv.x = uv.x - Math.floor( uv.x );

  					}

  					break;

  			}

  		}

  		if ( uv.y < 0 || uv.y > 1 ) {

  			switch ( this.wrapT ) {

  				case RepeatWrapping:

  					uv.y = uv.y - Math.floor( uv.y );
  					break;

  				case ClampToEdgeWrapping:

  					uv.y = uv.y < 0 ? 0 : 1;
  					break;

  				case MirroredRepeatWrapping:

  					if ( Math.abs( Math.floor( uv.y ) % 2 ) === 1 ) {

  						uv.y = Math.ceil( uv.y ) - uv.y;

  					} else {

  						uv.y = uv.y - Math.floor( uv.y );

  					}

  					break;

  			}

  		}

  		if ( this.flipY ) {

  			uv.y = 1 - uv.y;

  		}

  		return uv;

  	}

  } );

  Object.defineProperty( Texture.prototype, 'needsUpdate', {

  	set: function ( value ) {

  		if ( value === true ) this.version ++;

  	}

  } );

  function serializeImage( image ) {

  	if ( ( typeof HTMLImageElement !== 'undefined' && image instanceof HTMLImageElement ) ||
  		( typeof HTMLCanvasElement !== 'undefined' && image instanceof HTMLCanvasElement ) ||
  		( typeof ImageBitmap !== 'undefined' && image instanceof ImageBitmap ) ) {

  		// default images

  		return ImageUtils.getDataURL( image );

  	} else {

  		if ( image.data ) {

  			// images of DataTexture

  			return {
  				data: Array.prototype.slice.call( image.data ),
  				width: image.width,
  				height: image.height,
  				type: image.data.constructor.name
  			};

  		} else {

  			console.warn( 'THREE.Texture: Unable to serialize Texture.' );
  			return {};

  		}

  	}

  }

  class Vector4 {

  	constructor( x = 0, y = 0, z = 0, w = 1 ) {

  		Object.defineProperty( this, 'isVector4', { value: true } );

  		this.x = x;
  		this.y = y;
  		this.z = z;
  		this.w = w;

  	}

  	get width() {

  		return this.z;

  	}

  	set width( value ) {

  		this.z = value;

  	}

  	get height() {

  		return this.w;

  	}

  	set height( value ) {

  		this.w = value;

  	}

  	set( x, y, z, w ) {

  		this.x = x;
  		this.y = y;
  		this.z = z;
  		this.w = w;

  		return this;

  	}

  	setScalar( scalar ) {

  		this.x = scalar;
  		this.y = scalar;
  		this.z = scalar;
  		this.w = scalar;

  		return this;

  	}

  	setX( x ) {

  		this.x = x;

  		return this;

  	}

  	setY( y ) {

  		this.y = y;

  		return this;

  	}

  	setZ( z ) {

  		this.z = z;

  		return this;

  	}

  	setW( w ) {

  		this.w = w;

  		return this;

  	}

  	setComponent( index, value ) {

  		switch ( index ) {

  			case 0: this.x = value; break;
  			case 1: this.y = value; break;
  			case 2: this.z = value; break;
  			case 3: this.w = value; break;
  			default: throw new Error( 'index is out of range: ' + index );

  		}

  		return this;

  	}

  	getComponent( index ) {

  		switch ( index ) {

  			case 0: return this.x;
  			case 1: return this.y;
  			case 2: return this.z;
  			case 3: return this.w;
  			default: throw new Error( 'index is out of range: ' + index );

  		}

  	}

  	clone() {

  		return new this.constructor( this.x, this.y, this.z, this.w );

  	}

  	copy( v ) {

  		this.x = v.x;
  		this.y = v.y;
  		this.z = v.z;
  		this.w = ( v.w !== undefined ) ? v.w : 1;

  		return this;

  	}

  	add( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );
  			return this.addVectors( v, w );

  		}

  		this.x += v.x;
  		this.y += v.y;
  		this.z += v.z;
  		this.w += v.w;

  		return this;

  	}

  	addScalar( s ) {

  		this.x += s;
  		this.y += s;
  		this.z += s;
  		this.w += s;

  		return this;

  	}

  	addVectors( a, b ) {

  		this.x = a.x + b.x;
  		this.y = a.y + b.y;
  		this.z = a.z + b.z;
  		this.w = a.w + b.w;

  		return this;

  	}

  	addScaledVector( v, s ) {

  		this.x += v.x * s;
  		this.y += v.y * s;
  		this.z += v.z * s;
  		this.w += v.w * s;

  		return this;

  	}

  	sub( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );
  			return this.subVectors( v, w );

  		}

  		this.x -= v.x;
  		this.y -= v.y;
  		this.z -= v.z;
  		this.w -= v.w;

  		return this;

  	}

  	subScalar( s ) {

  		this.x -= s;
  		this.y -= s;
  		this.z -= s;
  		this.w -= s;

  		return this;

  	}

  	subVectors( a, b ) {

  		this.x = a.x - b.x;
  		this.y = a.y - b.y;
  		this.z = a.z - b.z;
  		this.w = a.w - b.w;

  		return this;

  	}

  	multiply( v ) {

  		this.x *= v.x;
  		this.y *= v.y;
  		this.z *= v.z;
  		this.w *= v.w;

  		return this;

  	}

  	multiplyScalar( scalar ) {

  		this.x *= scalar;
  		this.y *= scalar;
  		this.z *= scalar;
  		this.w *= scalar;

  		return this;

  	}

  	applyMatrix4( m ) {

  		const x = this.x, y = this.y, z = this.z, w = this.w;
  		const e = m.elements;

  		this.x = e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z + e[ 12 ] * w;
  		this.y = e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z + e[ 13 ] * w;
  		this.z = e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z + e[ 14 ] * w;
  		this.w = e[ 3 ] * x + e[ 7 ] * y + e[ 11 ] * z + e[ 15 ] * w;

  		return this;

  	}

  	divideScalar( scalar ) {

  		return this.multiplyScalar( 1 / scalar );

  	}

  	setAxisAngleFromQuaternion( q ) {

  		// http://www.euclideanspace.com/maths/geometry/rotations/conversions/quaternionToAngle/index.htm

  		// q is assumed to be normalized

  		this.w = 2 * Math.acos( q.w );

  		const s = Math.sqrt( 1 - q.w * q.w );

  		if ( s < 0.0001 ) {

  			this.x = 1;
  			this.y = 0;
  			this.z = 0;

  		} else {

  			this.x = q.x / s;
  			this.y = q.y / s;
  			this.z = q.z / s;

  		}

  		return this;

  	}

  	setAxisAngleFromRotationMatrix( m ) {

  		// http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToAngle/index.htm

  		// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)

  		let angle, x, y, z; // variables for result
  		const epsilon = 0.01,		// margin to allow for rounding errors
  			epsilon2 = 0.1,		// margin to distinguish between 0 and 180 degrees

  			te = m.elements,

  			m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ],
  			m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ],
  			m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ];

  		if ( ( Math.abs( m12 - m21 ) < epsilon ) &&
  		     ( Math.abs( m13 - m31 ) < epsilon ) &&
  		     ( Math.abs( m23 - m32 ) < epsilon ) ) {

  			// singularity found
  			// first check for identity matrix which must have +1 for all terms
  			// in leading diagonal and zero in other terms

  			if ( ( Math.abs( m12 + m21 ) < epsilon2 ) &&
  			     ( Math.abs( m13 + m31 ) < epsilon2 ) &&
  			     ( Math.abs( m23 + m32 ) < epsilon2 ) &&
  			     ( Math.abs( m11 + m22 + m33 - 3 ) < epsilon2 ) ) {

  				// this singularity is identity matrix so angle = 0

  				this.set( 1, 0, 0, 0 );

  				return this; // zero angle, arbitrary axis

  			}

  			// otherwise this singularity is angle = 180

  			angle = Math.PI;

  			const xx = ( m11 + 1 ) / 2;
  			const yy = ( m22 + 1 ) / 2;
  			const zz = ( m33 + 1 ) / 2;
  			const xy = ( m12 + m21 ) / 4;
  			const xz = ( m13 + m31 ) / 4;
  			const yz = ( m23 + m32 ) / 4;

  			if ( ( xx > yy ) && ( xx > zz ) ) {

  				// m11 is the largest diagonal term

  				if ( xx < epsilon ) {

  					x = 0;
  					y = 0.707106781;
  					z = 0.707106781;

  				} else {

  					x = Math.sqrt( xx );
  					y = xy / x;
  					z = xz / x;

  				}

  			} else if ( yy > zz ) {

  				// m22 is the largest diagonal term

  				if ( yy < epsilon ) {

  					x = 0.707106781;
  					y = 0;
  					z = 0.707106781;

  				} else {

  					y = Math.sqrt( yy );
  					x = xy / y;
  					z = yz / y;

  				}

  			} else {

  				// m33 is the largest diagonal term so base result on this

  				if ( zz < epsilon ) {

  					x = 0.707106781;
  					y = 0.707106781;
  					z = 0;

  				} else {

  					z = Math.sqrt( zz );
  					x = xz / z;
  					y = yz / z;

  				}

  			}

  			this.set( x, y, z, angle );

  			return this; // return 180 deg rotation

  		}

  		// as we have reached here there are no singularities so we can handle normally

  		let s = Math.sqrt( ( m32 - m23 ) * ( m32 - m23 ) +
  			( m13 - m31 ) * ( m13 - m31 ) +
  			( m21 - m12 ) * ( m21 - m12 ) ); // used to normalize

  		if ( Math.abs( s ) < 0.001 ) s = 1;

  		// prevent divide by zero, should not happen if matrix is orthogonal and should be
  		// caught by singularity test above, but I've left it in just in case

  		this.x = ( m32 - m23 ) / s;
  		this.y = ( m13 - m31 ) / s;
  		this.z = ( m21 - m12 ) / s;
  		this.w = Math.acos( ( m11 + m22 + m33 - 1 ) / 2 );

  		return this;

  	}

  	min( v ) {

  		this.x = Math.min( this.x, v.x );
  		this.y = Math.min( this.y, v.y );
  		this.z = Math.min( this.z, v.z );
  		this.w = Math.min( this.w, v.w );

  		return this;

  	}

  	max( v ) {

  		this.x = Math.max( this.x, v.x );
  		this.y = Math.max( this.y, v.y );
  		this.z = Math.max( this.z, v.z );
  		this.w = Math.max( this.w, v.w );

  		return this;

  	}

  	clamp( min, max ) {

  		// assumes min < max, componentwise

  		this.x = Math.max( min.x, Math.min( max.x, this.x ) );
  		this.y = Math.max( min.y, Math.min( max.y, this.y ) );
  		this.z = Math.max( min.z, Math.min( max.z, this.z ) );
  		this.w = Math.max( min.w, Math.min( max.w, this.w ) );

  		return this;

  	}

  	clampScalar( minVal, maxVal ) {

  		this.x = Math.max( minVal, Math.min( maxVal, this.x ) );
  		this.y = Math.max( minVal, Math.min( maxVal, this.y ) );
  		this.z = Math.max( minVal, Math.min( maxVal, this.z ) );
  		this.w = Math.max( minVal, Math.min( maxVal, this.w ) );

  		return this;

  	}

  	clampLength( min, max ) {

  		const length = this.length();

  		return this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );

  	}

  	floor() {

  		this.x = Math.floor( this.x );
  		this.y = Math.floor( this.y );
  		this.z = Math.floor( this.z );
  		this.w = Math.floor( this.w );

  		return this;

  	}

  	ceil() {

  		this.x = Math.ceil( this.x );
  		this.y = Math.ceil( this.y );
  		this.z = Math.ceil( this.z );
  		this.w = Math.ceil( this.w );

  		return this;

  	}

  	round() {

  		this.x = Math.round( this.x );
  		this.y = Math.round( this.y );
  		this.z = Math.round( this.z );
  		this.w = Math.round( this.w );

  		return this;

  	}

  	roundToZero() {

  		this.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );
  		this.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );
  		this.z = ( this.z < 0 ) ? Math.ceil( this.z ) : Math.floor( this.z );
  		this.w = ( this.w < 0 ) ? Math.ceil( this.w ) : Math.floor( this.w );

  		return this;

  	}

  	negate() {

  		this.x = - this.x;
  		this.y = - this.y;
  		this.z = - this.z;
  		this.w = - this.w;

  		return this;

  	}

  	dot( v ) {

  		return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;

  	}

  	lengthSq() {

  		return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;

  	}

  	length() {

  		return Math.sqrt( this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w );

  	}

  	manhattanLength() {

  		return Math.abs( this.x ) + Math.abs( this.y ) + Math.abs( this.z ) + Math.abs( this.w );

  	}

  	normalize() {

  		return this.divideScalar( this.length() || 1 );

  	}

  	setLength( length ) {

  		return this.normalize().multiplyScalar( length );

  	}

  	lerp( v, alpha ) {

  		this.x += ( v.x - this.x ) * alpha;
  		this.y += ( v.y - this.y ) * alpha;
  		this.z += ( v.z - this.z ) * alpha;
  		this.w += ( v.w - this.w ) * alpha;

  		return this;

  	}

  	lerpVectors( v1, v2, alpha ) {

  		this.x = v1.x + ( v2.x - v1.x ) * alpha;
  		this.y = v1.y + ( v2.y - v1.y ) * alpha;
  		this.z = v1.z + ( v2.z - v1.z ) * alpha;
  		this.w = v1.w + ( v2.w - v1.w ) * alpha;

  		return this;

  	}

  	equals( v ) {

  		return ( ( v.x === this.x ) && ( v.y === this.y ) && ( v.z === this.z ) && ( v.w === this.w ) );

  	}

  	fromArray( array, offset = 0 ) {

  		this.x = array[ offset ];
  		this.y = array[ offset + 1 ];
  		this.z = array[ offset + 2 ];
  		this.w = array[ offset + 3 ];

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		array[ offset ] = this.x;
  		array[ offset + 1 ] = this.y;
  		array[ offset + 2 ] = this.z;
  		array[ offset + 3 ] = this.w;

  		return array;

  	}

  	fromBufferAttribute( attribute, index, offset ) {

  		if ( offset !== undefined ) {

  			console.warn( 'THREE.Vector4: offset has been removed from .fromBufferAttribute().' );

  		}

  		this.x = attribute.getX( index );
  		this.y = attribute.getY( index );
  		this.z = attribute.getZ( index );
  		this.w = attribute.getW( index );

  		return this;

  	}

  	random() {

  		this.x = Math.random();
  		this.y = Math.random();
  		this.z = Math.random();
  		this.w = Math.random();

  		return this;

  	}

  }

  /*
   In options, we can specify:
   * Texture parameters for an auto-generated target texture
   * depthBuffer/stencilBuffer: Booleans to indicate if we should generate these buffers
  */
  class WebGLRenderTarget extends EventDispatcher {

  	constructor( width, height, options ) {

  		super();

  		Object.defineProperty( this, 'isWebGLRenderTarget', { value: true } );

  		this.width = width;
  		this.height = height;

  		this.scissor = new Vector4( 0, 0, width, height );
  		this.scissorTest = false;

  		this.viewport = new Vector4( 0, 0, width, height );

  		options = options || {};

  		this.texture = new Texture( undefined, options.mapping, options.wrapS, options.wrapT, options.magFilter, options.minFilter, options.format, options.type, options.anisotropy, options.encoding );

  		this.texture.image = {};
  		this.texture.image.width = width;
  		this.texture.image.height = height;

  		this.texture.generateMipmaps = options.generateMipmaps !== undefined ? options.generateMipmaps : false;
  		this.texture.minFilter = options.minFilter !== undefined ? options.minFilter : LinearFilter;

  		this.depthBuffer = options.depthBuffer !== undefined ? options.depthBuffer : true;
  		this.stencilBuffer = options.stencilBuffer !== undefined ? options.stencilBuffer : false;
  		this.depthTexture = options.depthTexture !== undefined ? options.depthTexture : null;

  	}

  	setSize( width, height ) {

  		if ( this.width !== width || this.height !== height ) {

  			this.width = width;
  			this.height = height;

  			this.texture.image.width = width;
  			this.texture.image.height = height;

  			this.dispose();

  		}

  		this.viewport.set( 0, 0, width, height );
  		this.scissor.set( 0, 0, width, height );

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( source ) {

  		this.width = source.width;
  		this.height = source.height;

  		this.viewport.copy( source.viewport );

  		this.texture = source.texture.clone();

  		this.depthBuffer = source.depthBuffer;
  		this.stencilBuffer = source.stencilBuffer;
  		this.depthTexture = source.depthTexture;

  		return this;

  	}

  	dispose() {

  		this.dispatchEvent( { type: 'dispose' } );

  	}

  }

  class Quaternion {

  	constructor( x = 0, y = 0, z = 0, w = 1 ) {

  		Object.defineProperty( this, 'isQuaternion', { value: true } );

  		this._x = x;
  		this._y = y;
  		this._z = z;
  		this._w = w;

  	}

  	static slerp( qa, qb, qm, t ) {

  		return qm.copy( qa ).slerp( qb, t );

  	}

  	static slerpFlat( dst, dstOffset, src0, srcOffset0, src1, srcOffset1, t ) {

  		// fuzz-free, array-based Quaternion SLERP operation

  		let x0 = src0[ srcOffset0 + 0 ],
  			y0 = src0[ srcOffset0 + 1 ],
  			z0 = src0[ srcOffset0 + 2 ],
  			w0 = src0[ srcOffset0 + 3 ];

  		const x1 = src1[ srcOffset1 + 0 ],
  			y1 = src1[ srcOffset1 + 1 ],
  			z1 = src1[ srcOffset1 + 2 ],
  			w1 = src1[ srcOffset1 + 3 ];

  		if ( w0 !== w1 || x0 !== x1 || y0 !== y1 || z0 !== z1 ) {

  			let s = 1 - t;
  			const cos = x0 * x1 + y0 * y1 + z0 * z1 + w0 * w1,
  				dir = ( cos >= 0 ? 1 : - 1 ),
  				sqrSin = 1 - cos * cos;

  			// Skip the Slerp for tiny steps to avoid numeric problems:
  			if ( sqrSin > Number.EPSILON ) {

  				const sin = Math.sqrt( sqrSin ),
  					len = Math.atan2( sin, cos * dir );

  				s = Math.sin( s * len ) / sin;
  				t = Math.sin( t * len ) / sin;

  			}

  			const tDir = t * dir;

  			x0 = x0 * s + x1 * tDir;
  			y0 = y0 * s + y1 * tDir;
  			z0 = z0 * s + z1 * tDir;
  			w0 = w0 * s + w1 * tDir;

  			// Normalize in case we just did a lerp:
  			if ( s === 1 - t ) {

  				const f = 1 / Math.sqrt( x0 * x0 + y0 * y0 + z0 * z0 + w0 * w0 );

  				x0 *= f;
  				y0 *= f;
  				z0 *= f;
  				w0 *= f;

  			}

  		}

  		dst[ dstOffset ] = x0;
  		dst[ dstOffset + 1 ] = y0;
  		dst[ dstOffset + 2 ] = z0;
  		dst[ dstOffset + 3 ] = w0;

  	}

  	static multiplyQuaternionsFlat( dst, dstOffset, src0, srcOffset0, src1, srcOffset1 ) {

  		const x0 = src0[ srcOffset0 ];
  		const y0 = src0[ srcOffset0 + 1 ];
  		const z0 = src0[ srcOffset0 + 2 ];
  		const w0 = src0[ srcOffset0 + 3 ];

  		const x1 = src1[ srcOffset1 ];
  		const y1 = src1[ srcOffset1 + 1 ];
  		const z1 = src1[ srcOffset1 + 2 ];
  		const w1 = src1[ srcOffset1 + 3 ];

  		dst[ dstOffset ] = x0 * w1 + w0 * x1 + y0 * z1 - z0 * y1;
  		dst[ dstOffset + 1 ] = y0 * w1 + w0 * y1 + z0 * x1 - x0 * z1;
  		dst[ dstOffset + 2 ] = z0 * w1 + w0 * z1 + x0 * y1 - y0 * x1;
  		dst[ dstOffset + 3 ] = w0 * w1 - x0 * x1 - y0 * y1 - z0 * z1;

  		return dst;

  	}

  	get x() {

  		return this._x;

  	}

  	set x( value ) {

  		this._x = value;
  		this._onChangeCallback();

  	}

  	get y() {

  		return this._y;

  	}

  	set y( value ) {

  		this._y = value;
  		this._onChangeCallback();

  	}

  	get z() {

  		return this._z;

  	}

  	set z( value ) {

  		this._z = value;
  		this._onChangeCallback();

  	}

  	get w() {

  		return this._w;

  	}

  	set w( value ) {

  		this._w = value;
  		this._onChangeCallback();

  	}

  	set( x, y, z, w ) {

  		this._x = x;
  		this._y = y;
  		this._z = z;
  		this._w = w;

  		this._onChangeCallback();

  		return this;

  	}

  	clone() {

  		return new this.constructor( this._x, this._y, this._z, this._w );

  	}

  	copy( quaternion ) {

  		this._x = quaternion.x;
  		this._y = quaternion.y;
  		this._z = quaternion.z;
  		this._w = quaternion.w;

  		this._onChangeCallback();

  		return this;

  	}

  	setFromEuler( euler, update ) {

  		if ( ! ( euler && euler.isEuler ) ) {

  			throw new Error( 'THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.' );

  		}

  		const x = euler._x, y = euler._y, z = euler._z, order = euler._order;

  		// http://www.mathworks.com/matlabcentral/fileexchange/
  		// 	20696-function-to-convert-between-dcm-euler-angles-quaternions-and-euler-vectors/
  		//	content/SpinCalc.m

  		const cos = Math.cos;
  		const sin = Math.sin;

  		const c1 = cos( x / 2 );
  		const c2 = cos( y / 2 );
  		const c3 = cos( z / 2 );

  		const s1 = sin( x / 2 );
  		const s2 = sin( y / 2 );
  		const s3 = sin( z / 2 );

  		switch ( order ) {

  			case 'XYZ':
  				this._x = s1 * c2 * c3 + c1 * s2 * s3;
  				this._y = c1 * s2 * c3 - s1 * c2 * s3;
  				this._z = c1 * c2 * s3 + s1 * s2 * c3;
  				this._w = c1 * c2 * c3 - s1 * s2 * s3;
  				break;

  			case 'YXZ':
  				this._x = s1 * c2 * c3 + c1 * s2 * s3;
  				this._y = c1 * s2 * c3 - s1 * c2 * s3;
  				this._z = c1 * c2 * s3 - s1 * s2 * c3;
  				this._w = c1 * c2 * c3 + s1 * s2 * s3;
  				break;

  			case 'ZXY':
  				this._x = s1 * c2 * c3 - c1 * s2 * s3;
  				this._y = c1 * s2 * c3 + s1 * c2 * s3;
  				this._z = c1 * c2 * s3 + s1 * s2 * c3;
  				this._w = c1 * c2 * c3 - s1 * s2 * s3;
  				break;

  			case 'ZYX':
  				this._x = s1 * c2 * c3 - c1 * s2 * s3;
  				this._y = c1 * s2 * c3 + s1 * c2 * s3;
  				this._z = c1 * c2 * s3 - s1 * s2 * c3;
  				this._w = c1 * c2 * c3 + s1 * s2 * s3;
  				break;

  			case 'YZX':
  				this._x = s1 * c2 * c3 + c1 * s2 * s3;
  				this._y = c1 * s2 * c3 + s1 * c2 * s3;
  				this._z = c1 * c2 * s3 - s1 * s2 * c3;
  				this._w = c1 * c2 * c3 - s1 * s2 * s3;
  				break;

  			case 'XZY':
  				this._x = s1 * c2 * c3 - c1 * s2 * s3;
  				this._y = c1 * s2 * c3 - s1 * c2 * s3;
  				this._z = c1 * c2 * s3 + s1 * s2 * c3;
  				this._w = c1 * c2 * c3 + s1 * s2 * s3;
  				break;

  			default:
  				console.warn( 'THREE.Quaternion: .setFromEuler() encountered an unknown order: ' + order );

  		}

  		if ( update !== false ) this._onChangeCallback();

  		return this;

  	}

  	setFromAxisAngle( axis, angle ) {

  		// http://www.euclideanspace.com/maths/geometry/rotations/conversions/angleToQuaternion/index.htm

  		// assumes axis is normalized

  		const halfAngle = angle / 2, s = Math.sin( halfAngle );

  		this._x = axis.x * s;
  		this._y = axis.y * s;
  		this._z = axis.z * s;
  		this._w = Math.cos( halfAngle );

  		this._onChangeCallback();

  		return this;

  	}

  	setFromRotationMatrix( m ) {

  		// http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToQuaternion/index.htm

  		// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)

  		const te = m.elements,

  			m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ],
  			m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ],
  			m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ],

  			trace = m11 + m22 + m33;

  		if ( trace > 0 ) {

  			const s = 0.5 / Math.sqrt( trace + 1.0 );

  			this._w = 0.25 / s;
  			this._x = ( m32 - m23 ) * s;
  			this._y = ( m13 - m31 ) * s;
  			this._z = ( m21 - m12 ) * s;

  		} else if ( m11 > m22 && m11 > m33 ) {

  			const s = 2.0 * Math.sqrt( 1.0 + m11 - m22 - m33 );

  			this._w = ( m32 - m23 ) / s;
  			this._x = 0.25 * s;
  			this._y = ( m12 + m21 ) / s;
  			this._z = ( m13 + m31 ) / s;

  		} else if ( m22 > m33 ) {

  			const s = 2.0 * Math.sqrt( 1.0 + m22 - m11 - m33 );

  			this._w = ( m13 - m31 ) / s;
  			this._x = ( m12 + m21 ) / s;
  			this._y = 0.25 * s;
  			this._z = ( m23 + m32 ) / s;

  		} else {

  			const s = 2.0 * Math.sqrt( 1.0 + m33 - m11 - m22 );

  			this._w = ( m21 - m12 ) / s;
  			this._x = ( m13 + m31 ) / s;
  			this._y = ( m23 + m32 ) / s;
  			this._z = 0.25 * s;

  		}

  		this._onChangeCallback();

  		return this;

  	}

  	setFromUnitVectors( vFrom, vTo ) {

  		// assumes direction vectors vFrom and vTo are normalized

  		const EPS = 0.000001;

  		let r = vFrom.dot( vTo ) + 1;

  		if ( r < EPS ) {

  			r = 0;

  			if ( Math.abs( vFrom.x ) > Math.abs( vFrom.z ) ) {

  				this._x = - vFrom.y;
  				this._y = vFrom.x;
  				this._z = 0;
  				this._w = r;

  			} else {

  				this._x = 0;
  				this._y = - vFrom.z;
  				this._z = vFrom.y;
  				this._w = r;

  			}

  		} else {

  			// crossVectors( vFrom, vTo ); // inlined to avoid cyclic dependency on Vector3

  			this._x = vFrom.y * vTo.z - vFrom.z * vTo.y;
  			this._y = vFrom.z * vTo.x - vFrom.x * vTo.z;
  			this._z = vFrom.x * vTo.y - vFrom.y * vTo.x;
  			this._w = r;

  		}

  		return this.normalize();

  	}

  	angleTo( q ) {

  		return 2 * Math.acos( Math.abs( MathUtils.clamp( this.dot( q ), - 1, 1 ) ) );

  	}

  	rotateTowards( q, step ) {

  		const angle = this.angleTo( q );

  		if ( angle === 0 ) return this;

  		const t = Math.min( 1, step / angle );

  		this.slerp( q, t );

  		return this;

  	}

  	identity() {

  		return this.set( 0, 0, 0, 1 );

  	}

  	invert() {

  		// quaternion is assumed to have unit length

  		return this.conjugate();

  	}

  	conjugate() {

  		this._x *= - 1;
  		this._y *= - 1;
  		this._z *= - 1;

  		this._onChangeCallback();

  		return this;

  	}

  	dot( v ) {

  		return this._x * v._x + this._y * v._y + this._z * v._z + this._w * v._w;

  	}

  	lengthSq() {

  		return this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w;

  	}

  	length() {

  		return Math.sqrt( this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w );

  	}

  	normalize() {

  		let l = this.length();

  		if ( l === 0 ) {

  			this._x = 0;
  			this._y = 0;
  			this._z = 0;
  			this._w = 1;

  		} else {

  			l = 1 / l;

  			this._x = this._x * l;
  			this._y = this._y * l;
  			this._z = this._z * l;
  			this._w = this._w * l;

  		}

  		this._onChangeCallback();

  		return this;

  	}

  	multiply( q, p ) {

  		if ( p !== undefined ) {

  			console.warn( 'THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead.' );
  			return this.multiplyQuaternions( q, p );

  		}

  		return this.multiplyQuaternions( this, q );

  	}

  	premultiply( q ) {

  		return this.multiplyQuaternions( q, this );

  	}

  	multiplyQuaternions( a, b ) {

  		// from http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/code/index.htm

  		const qax = a._x, qay = a._y, qaz = a._z, qaw = a._w;
  		const qbx = b._x, qby = b._y, qbz = b._z, qbw = b._w;

  		this._x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;
  		this._y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;
  		this._z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;
  		this._w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;

  		this._onChangeCallback();

  		return this;

  	}

  	slerp( qb, t ) {

  		if ( t === 0 ) return this;
  		if ( t === 1 ) return this.copy( qb );

  		const x = this._x, y = this._y, z = this._z, w = this._w;

  		// http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/slerp/

  		let cosHalfTheta = w * qb._w + x * qb._x + y * qb._y + z * qb._z;

  		if ( cosHalfTheta < 0 ) {

  			this._w = - qb._w;
  			this._x = - qb._x;
  			this._y = - qb._y;
  			this._z = - qb._z;

  			cosHalfTheta = - cosHalfTheta;

  		} else {

  			this.copy( qb );

  		}

  		if ( cosHalfTheta >= 1.0 ) {

  			this._w = w;
  			this._x = x;
  			this._y = y;
  			this._z = z;

  			return this;

  		}

  		const sqrSinHalfTheta = 1.0 - cosHalfTheta * cosHalfTheta;

  		if ( sqrSinHalfTheta <= Number.EPSILON ) {

  			const s = 1 - t;
  			this._w = s * w + t * this._w;
  			this._x = s * x + t * this._x;
  			this._y = s * y + t * this._y;
  			this._z = s * z + t * this._z;

  			this.normalize();
  			this._onChangeCallback();

  			return this;

  		}

  		const sinHalfTheta = Math.sqrt( sqrSinHalfTheta );
  		const halfTheta = Math.atan2( sinHalfTheta, cosHalfTheta );
  		const ratioA = Math.sin( ( 1 - t ) * halfTheta ) / sinHalfTheta,
  			ratioB = Math.sin( t * halfTheta ) / sinHalfTheta;

  		this._w = ( w * ratioA + this._w * ratioB );
  		this._x = ( x * ratioA + this._x * ratioB );
  		this._y = ( y * ratioA + this._y * ratioB );
  		this._z = ( z * ratioA + this._z * ratioB );

  		this._onChangeCallback();

  		return this;

  	}

  	equals( quaternion ) {

  		return ( quaternion._x === this._x ) && ( quaternion._y === this._y ) && ( quaternion._z === this._z ) && ( quaternion._w === this._w );

  	}

  	fromArray( array, offset = 0 ) {

  		this._x = array[ offset ];
  		this._y = array[ offset + 1 ];
  		this._z = array[ offset + 2 ];
  		this._w = array[ offset + 3 ];

  		this._onChangeCallback();

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		array[ offset ] = this._x;
  		array[ offset + 1 ] = this._y;
  		array[ offset + 2 ] = this._z;
  		array[ offset + 3 ] = this._w;

  		return array;

  	}

  	fromBufferAttribute( attribute, index ) {

  		this._x = attribute.getX( index );
  		this._y = attribute.getY( index );
  		this._z = attribute.getZ( index );
  		this._w = attribute.getW( index );

  		return this;

  	}

  	_onChange( callback ) {

  		this._onChangeCallback = callback;

  		return this;

  	}

  	_onChangeCallback() {}

  }

  class Vector3 {

  	constructor( x = 0, y = 0, z = 0 ) {

  		Object.defineProperty( this, 'isVector3', { value: true } );

  		this.x = x;
  		this.y = y;
  		this.z = z;

  	}

  	set( x, y, z ) {

  		if ( z === undefined ) z = this.z; // sprite.scale.set(x,y)

  		this.x = x;
  		this.y = y;
  		this.z = z;

  		return this;

  	}

  	setScalar( scalar ) {

  		this.x = scalar;
  		this.y = scalar;
  		this.z = scalar;

  		return this;

  	}

  	setX( x ) {

  		this.x = x;

  		return this;

  	}

  	setY( y ) {

  		this.y = y;

  		return this;

  	}

  	setZ( z ) {

  		this.z = z;

  		return this;

  	}

  	setComponent( index, value ) {

  		switch ( index ) {

  			case 0: this.x = value; break;
  			case 1: this.y = value; break;
  			case 2: this.z = value; break;
  			default: throw new Error( 'index is out of range: ' + index );

  		}

  		return this;

  	}

  	getComponent( index ) {

  		switch ( index ) {

  			case 0: return this.x;
  			case 1: return this.y;
  			case 2: return this.z;
  			default: throw new Error( 'index is out of range: ' + index );

  		}

  	}

  	clone() {

  		return new this.constructor( this.x, this.y, this.z );

  	}

  	copy( v ) {

  		this.x = v.x;
  		this.y = v.y;
  		this.z = v.z;

  		return this;

  	}

  	add( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );
  			return this.addVectors( v, w );

  		}

  		this.x += v.x;
  		this.y += v.y;
  		this.z += v.z;

  		return this;

  	}

  	addScalar( s ) {

  		this.x += s;
  		this.y += s;
  		this.z += s;

  		return this;

  	}

  	addVectors( a, b ) {

  		this.x = a.x + b.x;
  		this.y = a.y + b.y;
  		this.z = a.z + b.z;

  		return this;

  	}

  	addScaledVector( v, s ) {

  		this.x += v.x * s;
  		this.y += v.y * s;
  		this.z += v.z * s;

  		return this;

  	}

  	sub( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );
  			return this.subVectors( v, w );

  		}

  		this.x -= v.x;
  		this.y -= v.y;
  		this.z -= v.z;

  		return this;

  	}

  	subScalar( s ) {

  		this.x -= s;
  		this.y -= s;
  		this.z -= s;

  		return this;

  	}

  	subVectors( a, b ) {

  		this.x = a.x - b.x;
  		this.y = a.y - b.y;
  		this.z = a.z - b.z;

  		return this;

  	}

  	multiply( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead.' );
  			return this.multiplyVectors( v, w );

  		}

  		this.x *= v.x;
  		this.y *= v.y;
  		this.z *= v.z;

  		return this;

  	}

  	multiplyScalar( scalar ) {

  		this.x *= scalar;
  		this.y *= scalar;
  		this.z *= scalar;

  		return this;

  	}

  	multiplyVectors( a, b ) {

  		this.x = a.x * b.x;
  		this.y = a.y * b.y;
  		this.z = a.z * b.z;

  		return this;

  	}

  	applyEuler( euler ) {

  		if ( ! ( euler && euler.isEuler ) ) {

  			console.error( 'THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order.' );

  		}

  		return this.applyQuaternion( _quaternion.setFromEuler( euler ) );

  	}

  	applyAxisAngle( axis, angle ) {

  		return this.applyQuaternion( _quaternion.setFromAxisAngle( axis, angle ) );

  	}

  	applyMatrix3( m ) {

  		const x = this.x, y = this.y, z = this.z;
  		const e = m.elements;

  		this.x = e[ 0 ] * x + e[ 3 ] * y + e[ 6 ] * z;
  		this.y = e[ 1 ] * x + e[ 4 ] * y + e[ 7 ] * z;
  		this.z = e[ 2 ] * x + e[ 5 ] * y + e[ 8 ] * z;

  		return this;

  	}

  	applyNormalMatrix( m ) {

  		return this.applyMatrix3( m ).normalize();

  	}

  	applyMatrix4( m ) {

  		const x = this.x, y = this.y, z = this.z;
  		const e = m.elements;

  		const w = 1 / ( e[ 3 ] * x + e[ 7 ] * y + e[ 11 ] * z + e[ 15 ] );

  		this.x = ( e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z + e[ 12 ] ) * w;
  		this.y = ( e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z + e[ 13 ] ) * w;
  		this.z = ( e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z + e[ 14 ] ) * w;

  		return this;

  	}

  	applyQuaternion( q ) {

  		const x = this.x, y = this.y, z = this.z;
  		const qx = q.x, qy = q.y, qz = q.z, qw = q.w;

  		// calculate quat * vector

  		const ix = qw * x + qy * z - qz * y;
  		const iy = qw * y + qz * x - qx * z;
  		const iz = qw * z + qx * y - qy * x;
  		const iw = - qx * x - qy * y - qz * z;

  		// calculate result * inverse quat

  		this.x = ix * qw + iw * - qx + iy * - qz - iz * - qy;
  		this.y = iy * qw + iw * - qy + iz * - qx - ix * - qz;
  		this.z = iz * qw + iw * - qz + ix * - qy - iy * - qx;

  		return this;

  	}

  	project( camera ) {

  		return this.applyMatrix4( camera.matrixWorldInverse ).applyMatrix4( camera.projectionMatrix );

  	}

  	unproject( camera ) {

  		return this.applyMatrix4( camera.projectionMatrixInverse ).applyMatrix4( camera.matrixWorld );

  	}

  	transformDirection( m ) {

  		// input: THREE.Matrix4 affine matrix
  		// vector interpreted as a direction

  		const x = this.x, y = this.y, z = this.z;
  		const e = m.elements;

  		this.x = e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z;
  		this.y = e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z;
  		this.z = e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z;

  		return this.normalize();

  	}

  	divide( v ) {

  		this.x /= v.x;
  		this.y /= v.y;
  		this.z /= v.z;

  		return this;

  	}

  	divideScalar( scalar ) {

  		return this.multiplyScalar( 1 / scalar );

  	}

  	min( v ) {

  		this.x = Math.min( this.x, v.x );
  		this.y = Math.min( this.y, v.y );
  		this.z = Math.min( this.z, v.z );

  		return this;

  	}

  	max( v ) {

  		this.x = Math.max( this.x, v.x );
  		this.y = Math.max( this.y, v.y );
  		this.z = Math.max( this.z, v.z );

  		return this;

  	}

  	clamp( min, max ) {

  		// assumes min < max, componentwise

  		this.x = Math.max( min.x, Math.min( max.x, this.x ) );
  		this.y = Math.max( min.y, Math.min( max.y, this.y ) );
  		this.z = Math.max( min.z, Math.min( max.z, this.z ) );

  		return this;

  	}

  	clampScalar( minVal, maxVal ) {

  		this.x = Math.max( minVal, Math.min( maxVal, this.x ) );
  		this.y = Math.max( minVal, Math.min( maxVal, this.y ) );
  		this.z = Math.max( minVal, Math.min( maxVal, this.z ) );

  		return this;

  	}

  	clampLength( min, max ) {

  		const length = this.length();

  		return this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );

  	}

  	floor() {

  		this.x = Math.floor( this.x );
  		this.y = Math.floor( this.y );
  		this.z = Math.floor( this.z );

  		return this;

  	}

  	ceil() {

  		this.x = Math.ceil( this.x );
  		this.y = Math.ceil( this.y );
  		this.z = Math.ceil( this.z );

  		return this;

  	}

  	round() {

  		this.x = Math.round( this.x );
  		this.y = Math.round( this.y );
  		this.z = Math.round( this.z );

  		return this;

  	}

  	roundToZero() {

  		this.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );
  		this.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );
  		this.z = ( this.z < 0 ) ? Math.ceil( this.z ) : Math.floor( this.z );

  		return this;

  	}

  	negate() {

  		this.x = - this.x;
  		this.y = - this.y;
  		this.z = - this.z;

  		return this;

  	}

  	dot( v ) {

  		return this.x * v.x + this.y * v.y + this.z * v.z;

  	}

  	// TODO lengthSquared?

  	lengthSq() {

  		return this.x * this.x + this.y * this.y + this.z * this.z;

  	}

  	length() {

  		return Math.sqrt( this.x * this.x + this.y * this.y + this.z * this.z );

  	}

  	manhattanLength() {

  		return Math.abs( this.x ) + Math.abs( this.y ) + Math.abs( this.z );

  	}

  	normalize() {

  		return this.divideScalar( this.length() || 1 );

  	}

  	setLength( length ) {

  		return this.normalize().multiplyScalar( length );

  	}

  	lerp( v, alpha ) {

  		this.x += ( v.x - this.x ) * alpha;
  		this.y += ( v.y - this.y ) * alpha;
  		this.z += ( v.z - this.z ) * alpha;

  		return this;

  	}

  	lerpVectors( v1, v2, alpha ) {

  		this.x = v1.x + ( v2.x - v1.x ) * alpha;
  		this.y = v1.y + ( v2.y - v1.y ) * alpha;
  		this.z = v1.z + ( v2.z - v1.z ) * alpha;

  		return this;

  	}

  	cross( v, w ) {

  		if ( w !== undefined ) {

  			console.warn( 'THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead.' );
  			return this.crossVectors( v, w );

  		}

  		return this.crossVectors( this, v );

  	}

  	crossVectors( a, b ) {

  		const ax = a.x, ay = a.y, az = a.z;
  		const bx = b.x, by = b.y, bz = b.z;

  		this.x = ay * bz - az * by;
  		this.y = az * bx - ax * bz;
  		this.z = ax * by - ay * bx;

  		return this;

  	}

  	projectOnVector( v ) {

  		const denominator = v.lengthSq();

  		if ( denominator === 0 ) return this.set( 0, 0, 0 );

  		const scalar = v.dot( this ) / denominator;

  		return this.copy( v ).multiplyScalar( scalar );

  	}

  	projectOnPlane( planeNormal ) {

  		_vector.copy( this ).projectOnVector( planeNormal );

  		return this.sub( _vector );

  	}

  	reflect( normal ) {

  		// reflect incident vector off plane orthogonal to normal
  		// normal is assumed to have unit length

  		return this.sub( _vector.copy( normal ).multiplyScalar( 2 * this.dot( normal ) ) );

  	}

  	angleTo( v ) {

  		const denominator = Math.sqrt( this.lengthSq() * v.lengthSq() );

  		if ( denominator === 0 ) return Math.PI / 2;

  		const theta = this.dot( v ) / denominator;

  		// clamp, to handle numerical problems

  		return Math.acos( MathUtils.clamp( theta, - 1, 1 ) );

  	}

  	distanceTo( v ) {

  		return Math.sqrt( this.distanceToSquared( v ) );

  	}

  	distanceToSquared( v ) {

  		const dx = this.x - v.x, dy = this.y - v.y, dz = this.z - v.z;

  		return dx * dx + dy * dy + dz * dz;

  	}

  	manhattanDistanceTo( v ) {

  		return Math.abs( this.x - v.x ) + Math.abs( this.y - v.y ) + Math.abs( this.z - v.z );

  	}

  	setFromSpherical( s ) {

  		return this.setFromSphericalCoords( s.radius, s.phi, s.theta );

  	}

  	setFromSphericalCoords( radius, phi, theta ) {

  		const sinPhiRadius = Math.sin( phi ) * radius;

  		this.x = sinPhiRadius * Math.sin( theta );
  		this.y = Math.cos( phi ) * radius;
  		this.z = sinPhiRadius * Math.cos( theta );

  		return this;

  	}

  	setFromCylindrical( c ) {

  		return this.setFromCylindricalCoords( c.radius, c.theta, c.y );

  	}

  	setFromCylindricalCoords( radius, theta, y ) {

  		this.x = radius * Math.sin( theta );
  		this.y = y;
  		this.z = radius * Math.cos( theta );

  		return this;

  	}

  	setFromMatrixPosition( m ) {

  		const e = m.elements;

  		this.x = e[ 12 ];
  		this.y = e[ 13 ];
  		this.z = e[ 14 ];

  		return this;

  	}

  	setFromMatrixScale( m ) {

  		const sx = this.setFromMatrixColumn( m, 0 ).length();
  		const sy = this.setFromMatrixColumn( m, 1 ).length();
  		const sz = this.setFromMatrixColumn( m, 2 ).length();

  		this.x = sx;
  		this.y = sy;
  		this.z = sz;

  		return this;

  	}

  	setFromMatrixColumn( m, index ) {

  		return this.fromArray( m.elements, index * 4 );

  	}

  	setFromMatrix3Column( m, index ) {

  		return this.fromArray( m.elements, index * 3 );

  	}

  	equals( v ) {

  		return ( ( v.x === this.x ) && ( v.y === this.y ) && ( v.z === this.z ) );

  	}

  	fromArray( array, offset = 0 ) {

  		this.x = array[ offset ];
  		this.y = array[ offset + 1 ];
  		this.z = array[ offset + 2 ];

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		array[ offset ] = this.x;
  		array[ offset + 1 ] = this.y;
  		array[ offset + 2 ] = this.z;

  		return array;

  	}

  	fromBufferAttribute( attribute, index, offset ) {

  		if ( offset !== undefined ) {

  			console.warn( 'THREE.Vector3: offset has been removed from .fromBufferAttribute().' );

  		}

  		this.x = attribute.getX( index );
  		this.y = attribute.getY( index );
  		this.z = attribute.getZ( index );

  		return this;

  	}

  	random() {

  		this.x = Math.random();
  		this.y = Math.random();
  		this.z = Math.random();

  		return this;

  	}

  }

  const _vector = /*@__PURE__*/ new Vector3();
  const _quaternion = /*@__PURE__*/ new Quaternion();

  class Box3 {

  	constructor( min, max ) {

  		Object.defineProperty( this, 'isBox3', { value: true } );

  		this.min = ( min !== undefined ) ? min : new Vector3( + Infinity, + Infinity, + Infinity );
  		this.max = ( max !== undefined ) ? max : new Vector3( - Infinity, - Infinity, - Infinity );

  	}

  	set( min, max ) {

  		this.min.copy( min );
  		this.max.copy( max );

  		return this;

  	}

  	setFromArray( array ) {

  		let minX = + Infinity;
  		let minY = + Infinity;
  		let minZ = + Infinity;

  		let maxX = - Infinity;
  		let maxY = - Infinity;
  		let maxZ = - Infinity;

  		for ( let i = 0, l = array.length; i < l; i += 3 ) {

  			const x = array[ i ];
  			const y = array[ i + 1 ];
  			const z = array[ i + 2 ];

  			if ( x < minX ) minX = x;
  			if ( y < minY ) minY = y;
  			if ( z < minZ ) minZ = z;

  			if ( x > maxX ) maxX = x;
  			if ( y > maxY ) maxY = y;
  			if ( z > maxZ ) maxZ = z;

  		}

  		this.min.set( minX, minY, minZ );
  		this.max.set( maxX, maxY, maxZ );

  		return this;

  	}

  	setFromBufferAttribute( attribute ) {

  		let minX = + Infinity;
  		let minY = + Infinity;
  		let minZ = + Infinity;

  		let maxX = - Infinity;
  		let maxY = - Infinity;
  		let maxZ = - Infinity;

  		for ( let i = 0, l = attribute.count; i < l; i ++ ) {

  			const x = attribute.getX( i );
  			const y = attribute.getY( i );
  			const z = attribute.getZ( i );

  			if ( x < minX ) minX = x;
  			if ( y < minY ) minY = y;
  			if ( z < minZ ) minZ = z;

  			if ( x > maxX ) maxX = x;
  			if ( y > maxY ) maxY = y;
  			if ( z > maxZ ) maxZ = z;

  		}

  		this.min.set( minX, minY, minZ );
  		this.max.set( maxX, maxY, maxZ );

  		return this;

  	}

  	setFromPoints( points ) {

  		this.makeEmpty();

  		for ( let i = 0, il = points.length; i < il; i ++ ) {

  			this.expandByPoint( points[ i ] );

  		}

  		return this;

  	}

  	setFromCenterAndSize( center, size ) {

  		const halfSize = _vector$1.copy( size ).multiplyScalar( 0.5 );

  		this.min.copy( center ).sub( halfSize );
  		this.max.copy( center ).add( halfSize );

  		return this;

  	}

  	setFromObject( object ) {

  		this.makeEmpty();

  		return this.expandByObject( object );

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( box ) {

  		this.min.copy( box.min );
  		this.max.copy( box.max );

  		return this;

  	}

  	makeEmpty() {

  		this.min.x = this.min.y = this.min.z = + Infinity;
  		this.max.x = this.max.y = this.max.z = - Infinity;

  		return this;

  	}

  	isEmpty() {

  		// this is a more robust check for empty than ( volume <= 0 ) because volume can get positive with two negative axes

  		return ( this.max.x < this.min.x ) || ( this.max.y < this.min.y ) || ( this.max.z < this.min.z );

  	}

  	getCenter( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Box3: .getCenter() target is now required' );
  			target = new Vector3();

  		}

  		return this.isEmpty() ? target.set( 0, 0, 0 ) : target.addVectors( this.min, this.max ).multiplyScalar( 0.5 );

  	}

  	getSize( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Box3: .getSize() target is now required' );
  			target = new Vector3();

  		}

  		return this.isEmpty() ? target.set( 0, 0, 0 ) : target.subVectors( this.max, this.min );

  	}

  	expandByPoint( point ) {

  		this.min.min( point );
  		this.max.max( point );

  		return this;

  	}

  	expandByVector( vector ) {

  		this.min.sub( vector );
  		this.max.add( vector );

  		return this;

  	}

  	expandByScalar( scalar ) {

  		this.min.addScalar( - scalar );
  		this.max.addScalar( scalar );

  		return this;

  	}

  	expandByObject( object ) {

  		// Computes the world-axis-aligned bounding box of an object (including its children),
  		// accounting for both the object's, and children's, world transforms

  		object.updateWorldMatrix( false, false );

  		const geometry = object.geometry;

  		if ( geometry !== undefined ) {

  			if ( geometry.boundingBox === null ) {

  				geometry.computeBoundingBox();

  			}

  			_box.copy( geometry.boundingBox );
  			_box.applyMatrix4( object.matrixWorld );

  			this.union( _box );

  		}

  		const children = object.children;

  		for ( let i = 0, l = children.length; i < l; i ++ ) {

  			this.expandByObject( children[ i ] );

  		}

  		return this;

  	}

  	containsPoint( point ) {

  		return point.x < this.min.x || point.x > this.max.x ||
  			point.y < this.min.y || point.y > this.max.y ||
  			point.z < this.min.z || point.z > this.max.z ? false : true;

  	}

  	containsBox( box ) {

  		return this.min.x <= box.min.x && box.max.x <= this.max.x &&
  			this.min.y <= box.min.y && box.max.y <= this.max.y &&
  			this.min.z <= box.min.z && box.max.z <= this.max.z;

  	}

  	getParameter( point, target ) {

  		// This can potentially have a divide by zero if the box
  		// has a size dimension of 0.

  		if ( target === undefined ) {

  			console.warn( 'THREE.Box3: .getParameter() target is now required' );
  			target = new Vector3();

  		}

  		return target.set(
  			( point.x - this.min.x ) / ( this.max.x - this.min.x ),
  			( point.y - this.min.y ) / ( this.max.y - this.min.y ),
  			( point.z - this.min.z ) / ( this.max.z - this.min.z )
  		);

  	}

  	intersectsBox( box ) {

  		// using 6 splitting planes to rule out intersections.
  		return box.max.x < this.min.x || box.min.x > this.max.x ||
  			box.max.y < this.min.y || box.min.y > this.max.y ||
  			box.max.z < this.min.z || box.min.z > this.max.z ? false : true;

  	}

  	intersectsSphere( sphere ) {

  		// Find the point on the AABB closest to the sphere center.
  		this.clampPoint( sphere.center, _vector$1 );

  		// If that point is inside the sphere, the AABB and sphere intersect.
  		return _vector$1.distanceToSquared( sphere.center ) <= ( sphere.radius * sphere.radius );

  	}

  	intersectsPlane( plane ) {

  		// We compute the minimum and maximum dot product values. If those values
  		// are on the same side (back or front) of the plane, then there is no intersection.

  		let min, max;

  		if ( plane.normal.x > 0 ) {

  			min = plane.normal.x * this.min.x;
  			max = plane.normal.x * this.max.x;

  		} else {

  			min = plane.normal.x * this.max.x;
  			max = plane.normal.x * this.min.x;

  		}

  		if ( plane.normal.y > 0 ) {

  			min += plane.normal.y * this.min.y;
  			max += plane.normal.y * this.max.y;

  		} else {

  			min += plane.normal.y * this.max.y;
  			max += plane.normal.y * this.min.y;

  		}

  		if ( plane.normal.z > 0 ) {

  			min += plane.normal.z * this.min.z;
  			max += plane.normal.z * this.max.z;

  		} else {

  			min += plane.normal.z * this.max.z;
  			max += plane.normal.z * this.min.z;

  		}

  		return ( min <= - plane.constant && max >= - plane.constant );

  	}

  	intersectsTriangle( triangle ) {

  		if ( this.isEmpty() ) {

  			return false;

  		}

  		// compute box center and extents
  		this.getCenter( _center );
  		_extents.subVectors( this.max, _center );

  		// translate triangle to aabb origin
  		_v0.subVectors( triangle.a, _center );
  		_v1.subVectors( triangle.b, _center );
  		_v2.subVectors( triangle.c, _center );

  		// compute edge vectors for triangle
  		_f0.subVectors( _v1, _v0 );
  		_f1.subVectors( _v2, _v1 );
  		_f2.subVectors( _v0, _v2 );

  		// test against axes that are given by cross product combinations of the edges of the triangle and the edges of the aabb
  		// make an axis testing of each of the 3 sides of the aabb against each of the 3 sides of the triangle = 9 axis of separation
  		// axis_ij = u_i x f_j (u0, u1, u2 = face normals of aabb = x,y,z axes vectors since aabb is axis aligned)
  		let axes = [
  			0, - _f0.z, _f0.y, 0, - _f1.z, _f1.y, 0, - _f2.z, _f2.y,
  			_f0.z, 0, - _f0.x, _f1.z, 0, - _f1.x, _f2.z, 0, - _f2.x,
  			- _f0.y, _f0.x, 0, - _f1.y, _f1.x, 0, - _f2.y, _f2.x, 0
  		];
  		if ( ! satForAxes( axes, _v0, _v1, _v2, _extents ) ) {

  			return false;

  		}

  		// test 3 face normals from the aabb
  		axes = [ 1, 0, 0, 0, 1, 0, 0, 0, 1 ];
  		if ( ! satForAxes( axes, _v0, _v1, _v2, _extents ) ) {

  			return false;

  		}

  		// finally testing the face normal of the triangle
  		// use already existing triangle edge vectors here
  		_triangleNormal.crossVectors( _f0, _f1 );
  		axes = [ _triangleNormal.x, _triangleNormal.y, _triangleNormal.z ];

  		return satForAxes( axes, _v0, _v1, _v2, _extents );

  	}

  	clampPoint( point, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Box3: .clampPoint() target is now required' );
  			target = new Vector3();

  		}

  		return target.copy( point ).clamp( this.min, this.max );

  	}

  	distanceToPoint( point ) {

  		const clampedPoint = _vector$1.copy( point ).clamp( this.min, this.max );

  		return clampedPoint.sub( point ).length();

  	}

  	getBoundingSphere( target ) {

  		if ( target === undefined ) {

  			console.error( 'THREE.Box3: .getBoundingSphere() target is now required' );
  			//target = new Sphere(); // removed to avoid cyclic dependency

  		}

  		this.getCenter( target.center );

  		target.radius = this.getSize( _vector$1 ).length() * 0.5;

  		return target;

  	}

  	intersect( box ) {

  		this.min.max( box.min );
  		this.max.min( box.max );

  		// ensure that if there is no overlap, the result is fully empty, not slightly empty with non-inf/+inf values that will cause subsequence intersects to erroneously return valid values.
  		if ( this.isEmpty() ) this.makeEmpty();

  		return this;

  	}

  	union( box ) {

  		this.min.min( box.min );
  		this.max.max( box.max );

  		return this;

  	}

  	applyMatrix4( matrix ) {

  		// transform of empty box is an empty box.
  		if ( this.isEmpty() ) return this;

  		// NOTE: I am using a binary pattern to specify all 2^3 combinations below
  		_points[ 0 ].set( this.min.x, this.min.y, this.min.z ).applyMatrix4( matrix ); // 000
  		_points[ 1 ].set( this.min.x, this.min.y, this.max.z ).applyMatrix4( matrix ); // 001
  		_points[ 2 ].set( this.min.x, this.max.y, this.min.z ).applyMatrix4( matrix ); // 010
  		_points[ 3 ].set( this.min.x, this.max.y, this.max.z ).applyMatrix4( matrix ); // 011
  		_points[ 4 ].set( this.max.x, this.min.y, this.min.z ).applyMatrix4( matrix ); // 100
  		_points[ 5 ].set( this.max.x, this.min.y, this.max.z ).applyMatrix4( matrix ); // 101
  		_points[ 6 ].set( this.max.x, this.max.y, this.min.z ).applyMatrix4( matrix ); // 110
  		_points[ 7 ].set( this.max.x, this.max.y, this.max.z ).applyMatrix4( matrix ); // 111

  		this.setFromPoints( _points );

  		return this;

  	}

  	translate( offset ) {

  		this.min.add( offset );
  		this.max.add( offset );

  		return this;

  	}

  	equals( box ) {

  		return box.min.equals( this.min ) && box.max.equals( this.max );

  	}

  }

  function satForAxes( axes, v0, v1, v2, extents ) {

  	for ( let i = 0, j = axes.length - 3; i <= j; i += 3 ) {

  		_testAxis.fromArray( axes, i );
  		// project the aabb onto the seperating axis
  		const r = extents.x * Math.abs( _testAxis.x ) + extents.y * Math.abs( _testAxis.y ) + extents.z * Math.abs( _testAxis.z );
  		// project all 3 vertices of the triangle onto the seperating axis
  		const p0 = v0.dot( _testAxis );
  		const p1 = v1.dot( _testAxis );
  		const p2 = v2.dot( _testAxis );
  		// actual test, basically see if either of the most extreme of the triangle points intersects r
  		if ( Math.max( - Math.max( p0, p1, p2 ), Math.min( p0, p1, p2 ) ) > r ) {

  			// points of the projected triangle are outside the projected half-length of the aabb
  			// the axis is seperating and we can exit
  			return false;

  		}

  	}

  	return true;

  }

  const _points = [
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3(),
  	/*@__PURE__*/ new Vector3()
  ];

  const _vector$1 = /*@__PURE__*/ new Vector3();

  const _box = /*@__PURE__*/ new Box3();

  // triangle centered vertices

  const _v0 = /*@__PURE__*/ new Vector3();
  const _v1 = /*@__PURE__*/ new Vector3();
  const _v2 = /*@__PURE__*/ new Vector3();

  // triangle edge vectors

  const _f0 = /*@__PURE__*/ new Vector3();
  const _f1 = /*@__PURE__*/ new Vector3();
  const _f2 = /*@__PURE__*/ new Vector3();

  const _center = /*@__PURE__*/ new Vector3();
  const _extents = /*@__PURE__*/ new Vector3();
  const _triangleNormal = /*@__PURE__*/ new Vector3();
  const _testAxis = /*@__PURE__*/ new Vector3();

  const _box$1 = /*@__PURE__*/ new Box3();

  class Sphere {

  	constructor( center, radius ) {

  		this.center = ( center !== undefined ) ? center : new Vector3();
  		this.radius = ( radius !== undefined ) ? radius : - 1;

  	}

  	set( center, radius ) {

  		this.center.copy( center );
  		this.radius = radius;

  		return this;

  	}

  	setFromPoints( points, optionalCenter ) {

  		const center = this.center;

  		if ( optionalCenter !== undefined ) {

  			center.copy( optionalCenter );

  		} else {

  			_box$1.setFromPoints( points ).getCenter( center );

  		}

  		let maxRadiusSq = 0;

  		for ( let i = 0, il = points.length; i < il; i ++ ) {

  			maxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( points[ i ] ) );

  		}

  		this.radius = Math.sqrt( maxRadiusSq );

  		return this;

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( sphere ) {

  		this.center.copy( sphere.center );
  		this.radius = sphere.radius;

  		return this;

  	}

  	isEmpty() {

  		return ( this.radius < 0 );

  	}

  	makeEmpty() {

  		this.center.set( 0, 0, 0 );
  		this.radius = - 1;

  		return this;

  	}

  	containsPoint( point ) {

  		return ( point.distanceToSquared( this.center ) <= ( this.radius * this.radius ) );

  	}

  	distanceToPoint( point ) {

  		return ( point.distanceTo( this.center ) - this.radius );

  	}

  	intersectsSphere( sphere ) {

  		const radiusSum = this.radius + sphere.radius;

  		return sphere.center.distanceToSquared( this.center ) <= ( radiusSum * radiusSum );

  	}

  	intersectsBox( box ) {

  		return box.intersectsSphere( this );

  	}

  	intersectsPlane( plane ) {

  		return Math.abs( plane.distanceToPoint( this.center ) ) <= this.radius;

  	}

  	clampPoint( point, target ) {

  		const deltaLengthSq = this.center.distanceToSquared( point );

  		if ( target === undefined ) {

  			console.warn( 'THREE.Sphere: .clampPoint() target is now required' );
  			target = new Vector3();

  		}

  		target.copy( point );

  		if ( deltaLengthSq > ( this.radius * this.radius ) ) {

  			target.sub( this.center ).normalize();
  			target.multiplyScalar( this.radius ).add( this.center );

  		}

  		return target;

  	}

  	getBoundingBox( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Sphere: .getBoundingBox() target is now required' );
  			target = new Box3();

  		}

  		if ( this.isEmpty() ) {

  			// Empty sphere produces empty bounding box
  			target.makeEmpty();
  			return target;

  		}

  		target.set( this.center, this.center );
  		target.expandByScalar( this.radius );

  		return target;

  	}

  	applyMatrix4( matrix ) {

  		this.center.applyMatrix4( matrix );
  		this.radius = this.radius * matrix.getMaxScaleOnAxis();

  		return this;

  	}

  	translate( offset ) {

  		this.center.add( offset );

  		return this;

  	}

  	equals( sphere ) {

  		return sphere.center.equals( this.center ) && ( sphere.radius === this.radius );

  	}

  }

  const _vector$2 = /*@__PURE__*/ new Vector3();
  const _segCenter = /*@__PURE__*/ new Vector3();
  const _segDir = /*@__PURE__*/ new Vector3();
  const _diff = /*@__PURE__*/ new Vector3();

  const _edge1 = /*@__PURE__*/ new Vector3();
  const _edge2 = /*@__PURE__*/ new Vector3();
  const _normal = /*@__PURE__*/ new Vector3();

  class Ray {

  	constructor( origin, direction ) {

  		this.origin = ( origin !== undefined ) ? origin : new Vector3();
  		this.direction = ( direction !== undefined ) ? direction : new Vector3( 0, 0, - 1 );

  	}

  	set( origin, direction ) {

  		this.origin.copy( origin );
  		this.direction.copy( direction );

  		return this;

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( ray ) {

  		this.origin.copy( ray.origin );
  		this.direction.copy( ray.direction );

  		return this;

  	}

  	at( t, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Ray: .at() target is now required' );
  			target = new Vector3();

  		}

  		return target.copy( this.direction ).multiplyScalar( t ).add( this.origin );

  	}

  	lookAt( v ) {

  		this.direction.copy( v ).sub( this.origin ).normalize();

  		return this;

  	}

  	recast( t ) {

  		this.origin.copy( this.at( t, _vector$2 ) );

  		return this;

  	}

  	closestPointToPoint( point, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Ray: .closestPointToPoint() target is now required' );
  			target = new Vector3();

  		}

  		target.subVectors( point, this.origin );

  		const directionDistance = target.dot( this.direction );

  		if ( directionDistance < 0 ) {

  			return target.copy( this.origin );

  		}

  		return target.copy( this.direction ).multiplyScalar( directionDistance ).add( this.origin );

  	}

  	distanceToPoint( point ) {

  		return Math.sqrt( this.distanceSqToPoint( point ) );

  	}

  	distanceSqToPoint( point ) {

  		const directionDistance = _vector$2.subVectors( point, this.origin ).dot( this.direction );

  		// point behind the ray

  		if ( directionDistance < 0 ) {

  			return this.origin.distanceToSquared( point );

  		}

  		_vector$2.copy( this.direction ).multiplyScalar( directionDistance ).add( this.origin );

  		return _vector$2.distanceToSquared( point );

  	}

  	distanceSqToSegment( v0, v1, optionalPointOnRay, optionalPointOnSegment ) {

  		// from http://www.geometrictools.com/GTEngine/Include/Mathematics/GteDistRaySegment.h
  		// It returns the min distance between the ray and the segment
  		// defined by v0 and v1
  		// It can also set two optional targets :
  		// - The closest point on the ray
  		// - The closest point on the segment

  		_segCenter.copy( v0 ).add( v1 ).multiplyScalar( 0.5 );
  		_segDir.copy( v1 ).sub( v0 ).normalize();
  		_diff.copy( this.origin ).sub( _segCenter );

  		const segExtent = v0.distanceTo( v1 ) * 0.5;
  		const a01 = - this.direction.dot( _segDir );
  		const b0 = _diff.dot( this.direction );
  		const b1 = - _diff.dot( _segDir );
  		const c = _diff.lengthSq();
  		const det = Math.abs( 1 - a01 * a01 );
  		let s0, s1, sqrDist, extDet;

  		if ( det > 0 ) {

  			// The ray and segment are not parallel.

  			s0 = a01 * b1 - b0;
  			s1 = a01 * b0 - b1;
  			extDet = segExtent * det;

  			if ( s0 >= 0 ) {

  				if ( s1 >= - extDet ) {

  					if ( s1 <= extDet ) {

  						// region 0
  						// Minimum at interior points of ray and segment.

  						const invDet = 1 / det;
  						s0 *= invDet;
  						s1 *= invDet;
  						sqrDist = s0 * ( s0 + a01 * s1 + 2 * b0 ) + s1 * ( a01 * s0 + s1 + 2 * b1 ) + c;

  					} else {

  						// region 1

  						s1 = segExtent;
  						s0 = Math.max( 0, - ( a01 * s1 + b0 ) );
  						sqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;

  					}

  				} else {

  					// region 5

  					s1 = - segExtent;
  					s0 = Math.max( 0, - ( a01 * s1 + b0 ) );
  					sqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;

  				}

  			} else {

  				if ( s1 <= - extDet ) {

  					// region 4

  					s0 = Math.max( 0, - ( - a01 * segExtent + b0 ) );
  					s1 = ( s0 > 0 ) ? - segExtent : Math.min( Math.max( - segExtent, - b1 ), segExtent );
  					sqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;

  				} else if ( s1 <= extDet ) {

  					// region 3

  					s0 = 0;
  					s1 = Math.min( Math.max( - segExtent, - b1 ), segExtent );
  					sqrDist = s1 * ( s1 + 2 * b1 ) + c;

  				} else {

  					// region 2

  					s0 = Math.max( 0, - ( a01 * segExtent + b0 ) );
  					s1 = ( s0 > 0 ) ? segExtent : Math.min( Math.max( - segExtent, - b1 ), segExtent );
  					sqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;

  				}

  			}

  		} else {

  			// Ray and segment are parallel.

  			s1 = ( a01 > 0 ) ? - segExtent : segExtent;
  			s0 = Math.max( 0, - ( a01 * s1 + b0 ) );
  			sqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;

  		}

  		if ( optionalPointOnRay ) {

  			optionalPointOnRay.copy( this.direction ).multiplyScalar( s0 ).add( this.origin );

  		}

  		if ( optionalPointOnSegment ) {

  			optionalPointOnSegment.copy( _segDir ).multiplyScalar( s1 ).add( _segCenter );

  		}

  		return sqrDist;

  	}

  	intersectSphere( sphere, target ) {

  		_vector$2.subVectors( sphere.center, this.origin );
  		const tca = _vector$2.dot( this.direction );
  		const d2 = _vector$2.dot( _vector$2 ) - tca * tca;
  		const radius2 = sphere.radius * sphere.radius;

  		if ( d2 > radius2 ) return null;

  		const thc = Math.sqrt( radius2 - d2 );

  		// t0 = first intersect point - entrance on front of sphere
  		const t0 = tca - thc;

  		// t1 = second intersect point - exit point on back of sphere
  		const t1 = tca + thc;

  		// test to see if both t0 and t1 are behind the ray - if so, return null
  		if ( t0 < 0 && t1 < 0 ) return null;

  		// test to see if t0 is behind the ray:
  		// if it is, the ray is inside the sphere, so return the second exit point scaled by t1,
  		// in order to always return an intersect point that is in front of the ray.
  		if ( t0 < 0 ) return this.at( t1, target );

  		// else t0 is in front of the ray, so return the first collision point scaled by t0
  		return this.at( t0, target );

  	}

  	intersectsSphere( sphere ) {

  		return this.distanceSqToPoint( sphere.center ) <= ( sphere.radius * sphere.radius );

  	}

  	distanceToPlane( plane ) {

  		const denominator = plane.normal.dot( this.direction );

  		if ( denominator === 0 ) {

  			// line is coplanar, return origin
  			if ( plane.distanceToPoint( this.origin ) === 0 ) {

  				return 0;

  			}

  			// Null is preferable to undefined since undefined means.... it is undefined

  			return null;

  		}

  		const t = - ( this.origin.dot( plane.normal ) + plane.constant ) / denominator;

  		// Return if the ray never intersects the plane

  		return t >= 0 ? t : null;

  	}

  	intersectPlane( plane, target ) {

  		const t = this.distanceToPlane( plane );

  		if ( t === null ) {

  			return null;

  		}

  		return this.at( t, target );

  	}

  	intersectsPlane( plane ) {

  		// check if the ray lies on the plane first

  		const distToPoint = plane.distanceToPoint( this.origin );

  		if ( distToPoint === 0 ) {

  			return true;

  		}

  		const denominator = plane.normal.dot( this.direction );

  		if ( denominator * distToPoint < 0 ) {

  			return true;

  		}

  		// ray origin is behind the plane (and is pointing behind it)

  		return false;

  	}

  	intersectBox( box, target ) {

  		let tmin, tmax, tymin, tymax, tzmin, tzmax;

  		const invdirx = 1 / this.direction.x,
  			invdiry = 1 / this.direction.y,
  			invdirz = 1 / this.direction.z;

  		const origin = this.origin;

  		if ( invdirx >= 0 ) {

  			tmin = ( box.min.x - origin.x ) * invdirx;
  			tmax = ( box.max.x - origin.x ) * invdirx;

  		} else {

  			tmin = ( box.max.x - origin.x ) * invdirx;
  			tmax = ( box.min.x - origin.x ) * invdirx;

  		}

  		if ( invdiry >= 0 ) {

  			tymin = ( box.min.y - origin.y ) * invdiry;
  			tymax = ( box.max.y - origin.y ) * invdiry;

  		} else {

  			tymin = ( box.max.y - origin.y ) * invdiry;
  			tymax = ( box.min.y - origin.y ) * invdiry;

  		}

  		if ( ( tmin > tymax ) || ( tymin > tmax ) ) return null;

  		// These lines also handle the case where tmin or tmax is NaN
  		// (result of 0 * Infinity). x !== x returns true if x is NaN

  		if ( tymin > tmin || tmin !== tmin ) tmin = tymin;

  		if ( tymax < tmax || tmax !== tmax ) tmax = tymax;

  		if ( invdirz >= 0 ) {

  			tzmin = ( box.min.z - origin.z ) * invdirz;
  			tzmax = ( box.max.z - origin.z ) * invdirz;

  		} else {

  			tzmin = ( box.max.z - origin.z ) * invdirz;
  			tzmax = ( box.min.z - origin.z ) * invdirz;

  		}

  		if ( ( tmin > tzmax ) || ( tzmin > tmax ) ) return null;

  		if ( tzmin > tmin || tmin !== tmin ) tmin = tzmin;

  		if ( tzmax < tmax || tmax !== tmax ) tmax = tzmax;

  		//return point closest to the ray (positive side)

  		if ( tmax < 0 ) return null;

  		return this.at( tmin >= 0 ? tmin : tmax, target );

  	}

  	intersectsBox( box ) {

  		return this.intersectBox( box, _vector$2 ) !== null;

  	}

  	intersectTriangle( a, b, c, backfaceCulling, target ) {

  		// Compute the offset origin, edges, and normal.

  		// from http://www.geometrictools.com/GTEngine/Include/Mathematics/GteIntrRay3Triangle3.h

  		_edge1.subVectors( b, a );
  		_edge2.subVectors( c, a );
  		_normal.crossVectors( _edge1, _edge2 );

  		// Solve Q + t*D = b1*E1 + b2*E2 (Q = kDiff, D = ray direction,
  		// E1 = kEdge1, E2 = kEdge2, N = Cross(E1,E2)) by
  		//   |Dot(D,N)|*b1 = sign(Dot(D,N))*Dot(D,Cross(Q,E2))
  		//   |Dot(D,N)|*b2 = sign(Dot(D,N))*Dot(D,Cross(E1,Q))
  		//   |Dot(D,N)|*t = -sign(Dot(D,N))*Dot(Q,N)
  		let DdN = this.direction.dot( _normal );
  		let sign;

  		if ( DdN > 0 ) {

  			if ( backfaceCulling ) return null;
  			sign = 1;

  		} else if ( DdN < 0 ) {

  			sign = - 1;
  			DdN = - DdN;

  		} else {

  			return null;

  		}

  		_diff.subVectors( this.origin, a );
  		const DdQxE2 = sign * this.direction.dot( _edge2.crossVectors( _diff, _edge2 ) );

  		// b1 < 0, no intersection
  		if ( DdQxE2 < 0 ) {

  			return null;

  		}

  		const DdE1xQ = sign * this.direction.dot( _edge1.cross( _diff ) );

  		// b2 < 0, no intersection
  		if ( DdE1xQ < 0 ) {

  			return null;

  		}

  		// b1+b2 > 1, no intersection
  		if ( DdQxE2 + DdE1xQ > DdN ) {

  			return null;

  		}

  		// Line intersects triangle, check if ray does.
  		const QdN = - sign * _diff.dot( _normal );

  		// t < 0, no intersection
  		if ( QdN < 0 ) {

  			return null;

  		}

  		// Ray intersects triangle.
  		return this.at( QdN / DdN, target );

  	}

  	applyMatrix4( matrix4 ) {

  		this.origin.applyMatrix4( matrix4 );
  		this.direction.transformDirection( matrix4 );

  		return this;

  	}

  	equals( ray ) {

  		return ray.origin.equals( this.origin ) && ray.direction.equals( this.direction );

  	}

  }

  class Matrix4 {

  	constructor() {

  		Object.defineProperty( this, 'isMatrix4', { value: true } );

  		this.elements = [

  			1, 0, 0, 0,
  			0, 1, 0, 0,
  			0, 0, 1, 0,
  			0, 0, 0, 1

  		];

  		if ( arguments.length > 0 ) {

  			console.error( 'THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.' );

  		}

  	}

  	set( n11, n12, n13, n14, n21, n22, n23, n24, n31, n32, n33, n34, n41, n42, n43, n44 ) {

  		const te = this.elements;

  		te[ 0 ] = n11; te[ 4 ] = n12; te[ 8 ] = n13; te[ 12 ] = n14;
  		te[ 1 ] = n21; te[ 5 ] = n22; te[ 9 ] = n23; te[ 13 ] = n24;
  		te[ 2 ] = n31; te[ 6 ] = n32; te[ 10 ] = n33; te[ 14 ] = n34;
  		te[ 3 ] = n41; te[ 7 ] = n42; te[ 11 ] = n43; te[ 15 ] = n44;

  		return this;

  	}

  	identity() {

  		this.set(

  			1, 0, 0, 0,
  			0, 1, 0, 0,
  			0, 0, 1, 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	clone() {

  		return new Matrix4().fromArray( this.elements );

  	}

  	copy( m ) {

  		const te = this.elements;
  		const me = m.elements;

  		te[ 0 ] = me[ 0 ]; te[ 1 ] = me[ 1 ]; te[ 2 ] = me[ 2 ]; te[ 3 ] = me[ 3 ];
  		te[ 4 ] = me[ 4 ]; te[ 5 ] = me[ 5 ]; te[ 6 ] = me[ 6 ]; te[ 7 ] = me[ 7 ];
  		te[ 8 ] = me[ 8 ]; te[ 9 ] = me[ 9 ]; te[ 10 ] = me[ 10 ]; te[ 11 ] = me[ 11 ];
  		te[ 12 ] = me[ 12 ]; te[ 13 ] = me[ 13 ]; te[ 14 ] = me[ 14 ]; te[ 15 ] = me[ 15 ];

  		return this;

  	}

  	copyPosition( m ) {

  		const te = this.elements, me = m.elements;

  		te[ 12 ] = me[ 12 ];
  		te[ 13 ] = me[ 13 ];
  		te[ 14 ] = me[ 14 ];

  		return this;

  	}

  	setFromMatrix3( m ) {

  		const me = m.elements;

  		this.set(

  			me[ 0 ], me[ 3 ], me[ 6 ], 0,
  			me[ 1 ], me[ 4 ], me[ 7 ], 0,
  			me[ 2 ], me[ 5 ], me[ 8 ], 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	extractBasis( xAxis, yAxis, zAxis ) {

  		xAxis.setFromMatrixColumn( this, 0 );
  		yAxis.setFromMatrixColumn( this, 1 );
  		zAxis.setFromMatrixColumn( this, 2 );

  		return this;

  	}

  	makeBasis( xAxis, yAxis, zAxis ) {

  		this.set(
  			xAxis.x, yAxis.x, zAxis.x, 0,
  			xAxis.y, yAxis.y, zAxis.y, 0,
  			xAxis.z, yAxis.z, zAxis.z, 0,
  			0, 0, 0, 1
  		);

  		return this;

  	}

  	extractRotation( m ) {

  		// this method does not support reflection matrices

  		const te = this.elements;
  		const me = m.elements;

  		const scaleX = 1 / _v1$1.setFromMatrixColumn( m, 0 ).length();
  		const scaleY = 1 / _v1$1.setFromMatrixColumn( m, 1 ).length();
  		const scaleZ = 1 / _v1$1.setFromMatrixColumn( m, 2 ).length();

  		te[ 0 ] = me[ 0 ] * scaleX;
  		te[ 1 ] = me[ 1 ] * scaleX;
  		te[ 2 ] = me[ 2 ] * scaleX;
  		te[ 3 ] = 0;

  		te[ 4 ] = me[ 4 ] * scaleY;
  		te[ 5 ] = me[ 5 ] * scaleY;
  		te[ 6 ] = me[ 6 ] * scaleY;
  		te[ 7 ] = 0;

  		te[ 8 ] = me[ 8 ] * scaleZ;
  		te[ 9 ] = me[ 9 ] * scaleZ;
  		te[ 10 ] = me[ 10 ] * scaleZ;
  		te[ 11 ] = 0;

  		te[ 12 ] = 0;
  		te[ 13 ] = 0;
  		te[ 14 ] = 0;
  		te[ 15 ] = 1;

  		return this;

  	}

  	makeRotationFromEuler( euler ) {

  		if ( ! ( euler && euler.isEuler ) ) {

  			console.error( 'THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.' );

  		}

  		const te = this.elements;

  		const x = euler.x, y = euler.y, z = euler.z;
  		const a = Math.cos( x ), b = Math.sin( x );
  		const c = Math.cos( y ), d = Math.sin( y );
  		const e = Math.cos( z ), f = Math.sin( z );

  		if ( euler.order === 'XYZ' ) {

  			const ae = a * e, af = a * f, be = b * e, bf = b * f;

  			te[ 0 ] = c * e;
  			te[ 4 ] = - c * f;
  			te[ 8 ] = d;

  			te[ 1 ] = af + be * d;
  			te[ 5 ] = ae - bf * d;
  			te[ 9 ] = - b * c;

  			te[ 2 ] = bf - ae * d;
  			te[ 6 ] = be + af * d;
  			te[ 10 ] = a * c;

  		} else if ( euler.order === 'YXZ' ) {

  			const ce = c * e, cf = c * f, de = d * e, df = d * f;

  			te[ 0 ] = ce + df * b;
  			te[ 4 ] = de * b - cf;
  			te[ 8 ] = a * d;

  			te[ 1 ] = a * f;
  			te[ 5 ] = a * e;
  			te[ 9 ] = - b;

  			te[ 2 ] = cf * b - de;
  			te[ 6 ] = df + ce * b;
  			te[ 10 ] = a * c;

  		} else if ( euler.order === 'ZXY' ) {

  			const ce = c * e, cf = c * f, de = d * e, df = d * f;

  			te[ 0 ] = ce - df * b;
  			te[ 4 ] = - a * f;
  			te[ 8 ] = de + cf * b;

  			te[ 1 ] = cf + de * b;
  			te[ 5 ] = a * e;
  			te[ 9 ] = df - ce * b;

  			te[ 2 ] = - a * d;
  			te[ 6 ] = b;
  			te[ 10 ] = a * c;

  		} else if ( euler.order === 'ZYX' ) {

  			const ae = a * e, af = a * f, be = b * e, bf = b * f;

  			te[ 0 ] = c * e;
  			te[ 4 ] = be * d - af;
  			te[ 8 ] = ae * d + bf;

  			te[ 1 ] = c * f;
  			te[ 5 ] = bf * d + ae;
  			te[ 9 ] = af * d - be;

  			te[ 2 ] = - d;
  			te[ 6 ] = b * c;
  			te[ 10 ] = a * c;

  		} else if ( euler.order === 'YZX' ) {

  			const ac = a * c, ad = a * d, bc = b * c, bd = b * d;

  			te[ 0 ] = c * e;
  			te[ 4 ] = bd - ac * f;
  			te[ 8 ] = bc * f + ad;

  			te[ 1 ] = f;
  			te[ 5 ] = a * e;
  			te[ 9 ] = - b * e;

  			te[ 2 ] = - d * e;
  			te[ 6 ] = ad * f + bc;
  			te[ 10 ] = ac - bd * f;

  		} else if ( euler.order === 'XZY' ) {

  			const ac = a * c, ad = a * d, bc = b * c, bd = b * d;

  			te[ 0 ] = c * e;
  			te[ 4 ] = - f;
  			te[ 8 ] = d * e;

  			te[ 1 ] = ac * f + bd;
  			te[ 5 ] = a * e;
  			te[ 9 ] = ad * f - bc;

  			te[ 2 ] = bc * f - ad;
  			te[ 6 ] = b * e;
  			te[ 10 ] = bd * f + ac;

  		}

  		// bottom row
  		te[ 3 ] = 0;
  		te[ 7 ] = 0;
  		te[ 11 ] = 0;

  		// last column
  		te[ 12 ] = 0;
  		te[ 13 ] = 0;
  		te[ 14 ] = 0;
  		te[ 15 ] = 1;

  		return this;

  	}

  	makeRotationFromQuaternion( q ) {

  		return this.compose( _zero, q, _one );

  	}

  	lookAt( eye, target, up ) {

  		const te = this.elements;

  		_z.subVectors( eye, target );

  		if ( _z.lengthSq() === 0 ) {

  			// eye and target are in the same position

  			_z.z = 1;

  		}

  		_z.normalize();
  		_x.crossVectors( up, _z );

  		if ( _x.lengthSq() === 0 ) {

  			// up and z are parallel

  			if ( Math.abs( up.z ) === 1 ) {

  				_z.x += 0.0001;

  			} else {

  				_z.z += 0.0001;

  			}

  			_z.normalize();
  			_x.crossVectors( up, _z );

  		}

  		_x.normalize();
  		_y.crossVectors( _z, _x );

  		te[ 0 ] = _x.x; te[ 4 ] = _y.x; te[ 8 ] = _z.x;
  		te[ 1 ] = _x.y; te[ 5 ] = _y.y; te[ 9 ] = _z.y;
  		te[ 2 ] = _x.z; te[ 6 ] = _y.z; te[ 10 ] = _z.z;

  		return this;

  	}

  	multiply( m, n ) {

  		if ( n !== undefined ) {

  			console.warn( 'THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead.' );
  			return this.multiplyMatrices( m, n );

  		}

  		return this.multiplyMatrices( this, m );

  	}

  	premultiply( m ) {

  		return this.multiplyMatrices( m, this );

  	}

  	multiplyMatrices( a, b ) {

  		const ae = a.elements;
  		const be = b.elements;
  		const te = this.elements;

  		const a11 = ae[ 0 ], a12 = ae[ 4 ], a13 = ae[ 8 ], a14 = ae[ 12 ];
  		const a21 = ae[ 1 ], a22 = ae[ 5 ], a23 = ae[ 9 ], a24 = ae[ 13 ];
  		const a31 = ae[ 2 ], a32 = ae[ 6 ], a33 = ae[ 10 ], a34 = ae[ 14 ];
  		const a41 = ae[ 3 ], a42 = ae[ 7 ], a43 = ae[ 11 ], a44 = ae[ 15 ];

  		const b11 = be[ 0 ], b12 = be[ 4 ], b13 = be[ 8 ], b14 = be[ 12 ];
  		const b21 = be[ 1 ], b22 = be[ 5 ], b23 = be[ 9 ], b24 = be[ 13 ];
  		const b31 = be[ 2 ], b32 = be[ 6 ], b33 = be[ 10 ], b34 = be[ 14 ];
  		const b41 = be[ 3 ], b42 = be[ 7 ], b43 = be[ 11 ], b44 = be[ 15 ];

  		te[ 0 ] = a11 * b11 + a12 * b21 + a13 * b31 + a14 * b41;
  		te[ 4 ] = a11 * b12 + a12 * b22 + a13 * b32 + a14 * b42;
  		te[ 8 ] = a11 * b13 + a12 * b23 + a13 * b33 + a14 * b43;
  		te[ 12 ] = a11 * b14 + a12 * b24 + a13 * b34 + a14 * b44;

  		te[ 1 ] = a21 * b11 + a22 * b21 + a23 * b31 + a24 * b41;
  		te[ 5 ] = a21 * b12 + a22 * b22 + a23 * b32 + a24 * b42;
  		te[ 9 ] = a21 * b13 + a22 * b23 + a23 * b33 + a24 * b43;
  		te[ 13 ] = a21 * b14 + a22 * b24 + a23 * b34 + a24 * b44;

  		te[ 2 ] = a31 * b11 + a32 * b21 + a33 * b31 + a34 * b41;
  		te[ 6 ] = a31 * b12 + a32 * b22 + a33 * b32 + a34 * b42;
  		te[ 10 ] = a31 * b13 + a32 * b23 + a33 * b33 + a34 * b43;
  		te[ 14 ] = a31 * b14 + a32 * b24 + a33 * b34 + a34 * b44;

  		te[ 3 ] = a41 * b11 + a42 * b21 + a43 * b31 + a44 * b41;
  		te[ 7 ] = a41 * b12 + a42 * b22 + a43 * b32 + a44 * b42;
  		te[ 11 ] = a41 * b13 + a42 * b23 + a43 * b33 + a44 * b43;
  		te[ 15 ] = a41 * b14 + a42 * b24 + a43 * b34 + a44 * b44;

  		return this;

  	}

  	multiplyScalar( s ) {

  		const te = this.elements;

  		te[ 0 ] *= s; te[ 4 ] *= s; te[ 8 ] *= s; te[ 12 ] *= s;
  		te[ 1 ] *= s; te[ 5 ] *= s; te[ 9 ] *= s; te[ 13 ] *= s;
  		te[ 2 ] *= s; te[ 6 ] *= s; te[ 10 ] *= s; te[ 14 ] *= s;
  		te[ 3 ] *= s; te[ 7 ] *= s; te[ 11 ] *= s; te[ 15 ] *= s;

  		return this;

  	}

  	determinant() {

  		const te = this.elements;

  		const n11 = te[ 0 ], n12 = te[ 4 ], n13 = te[ 8 ], n14 = te[ 12 ];
  		const n21 = te[ 1 ], n22 = te[ 5 ], n23 = te[ 9 ], n24 = te[ 13 ];
  		const n31 = te[ 2 ], n32 = te[ 6 ], n33 = te[ 10 ], n34 = te[ 14 ];
  		const n41 = te[ 3 ], n42 = te[ 7 ], n43 = te[ 11 ], n44 = te[ 15 ];

  		//TODO: make this more efficient
  		//( based on http://www.euclideanspace.com/maths/algebra/matrix/functions/inverse/fourD/index.htm )

  		return (
  			n41 * (
  				+ n14 * n23 * n32
  				 - n13 * n24 * n32
  				 - n14 * n22 * n33
  				 + n12 * n24 * n33
  				 + n13 * n22 * n34
  				 - n12 * n23 * n34
  			) +
  			n42 * (
  				+ n11 * n23 * n34
  				 - n11 * n24 * n33
  				 + n14 * n21 * n33
  				 - n13 * n21 * n34
  				 + n13 * n24 * n31
  				 - n14 * n23 * n31
  			) +
  			n43 * (
  				+ n11 * n24 * n32
  				 - n11 * n22 * n34
  				 - n14 * n21 * n32
  				 + n12 * n21 * n34
  				 + n14 * n22 * n31
  				 - n12 * n24 * n31
  			) +
  			n44 * (
  				- n13 * n22 * n31
  				 - n11 * n23 * n32
  				 + n11 * n22 * n33
  				 + n13 * n21 * n32
  				 - n12 * n21 * n33
  				 + n12 * n23 * n31
  			)

  		);

  	}

  	transpose() {

  		const te = this.elements;
  		let tmp;

  		tmp = te[ 1 ]; te[ 1 ] = te[ 4 ]; te[ 4 ] = tmp;
  		tmp = te[ 2 ]; te[ 2 ] = te[ 8 ]; te[ 8 ] = tmp;
  		tmp = te[ 6 ]; te[ 6 ] = te[ 9 ]; te[ 9 ] = tmp;

  		tmp = te[ 3 ]; te[ 3 ] = te[ 12 ]; te[ 12 ] = tmp;
  		tmp = te[ 7 ]; te[ 7 ] = te[ 13 ]; te[ 13 ] = tmp;
  		tmp = te[ 11 ]; te[ 11 ] = te[ 14 ]; te[ 14 ] = tmp;

  		return this;

  	}

  	setPosition( x, y, z ) {

  		const te = this.elements;

  		if ( x.isVector3 ) {

  			te[ 12 ] = x.x;
  			te[ 13 ] = x.y;
  			te[ 14 ] = x.z;

  		} else {

  			te[ 12 ] = x;
  			te[ 13 ] = y;
  			te[ 14 ] = z;

  		}

  		return this;

  	}

  	invert() {

  		// based on http://www.euclideanspace.com/maths/algebra/matrix/functions/inverse/fourD/index.htm
  		const te = this.elements,

  			n11 = te[ 0 ], n21 = te[ 1 ], n31 = te[ 2 ], n41 = te[ 3 ],
  			n12 = te[ 4 ], n22 = te[ 5 ], n32 = te[ 6 ], n42 = te[ 7 ],
  			n13 = te[ 8 ], n23 = te[ 9 ], n33 = te[ 10 ], n43 = te[ 11 ],
  			n14 = te[ 12 ], n24 = te[ 13 ], n34 = te[ 14 ], n44 = te[ 15 ],

  			t11 = n23 * n34 * n42 - n24 * n33 * n42 + n24 * n32 * n43 - n22 * n34 * n43 - n23 * n32 * n44 + n22 * n33 * n44,
  			t12 = n14 * n33 * n42 - n13 * n34 * n42 - n14 * n32 * n43 + n12 * n34 * n43 + n13 * n32 * n44 - n12 * n33 * n44,
  			t13 = n13 * n24 * n42 - n14 * n23 * n42 + n14 * n22 * n43 - n12 * n24 * n43 - n13 * n22 * n44 + n12 * n23 * n44,
  			t14 = n14 * n23 * n32 - n13 * n24 * n32 - n14 * n22 * n33 + n12 * n24 * n33 + n13 * n22 * n34 - n12 * n23 * n34;

  		const det = n11 * t11 + n21 * t12 + n31 * t13 + n41 * t14;

  		if ( det === 0 ) return this.set( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );

  		const detInv = 1 / det;

  		te[ 0 ] = t11 * detInv;
  		te[ 1 ] = ( n24 * n33 * n41 - n23 * n34 * n41 - n24 * n31 * n43 + n21 * n34 * n43 + n23 * n31 * n44 - n21 * n33 * n44 ) * detInv;
  		te[ 2 ] = ( n22 * n34 * n41 - n24 * n32 * n41 + n24 * n31 * n42 - n21 * n34 * n42 - n22 * n31 * n44 + n21 * n32 * n44 ) * detInv;
  		te[ 3 ] = ( n23 * n32 * n41 - n22 * n33 * n41 - n23 * n31 * n42 + n21 * n33 * n42 + n22 * n31 * n43 - n21 * n32 * n43 ) * detInv;

  		te[ 4 ] = t12 * detInv;
  		te[ 5 ] = ( n13 * n34 * n41 - n14 * n33 * n41 + n14 * n31 * n43 - n11 * n34 * n43 - n13 * n31 * n44 + n11 * n33 * n44 ) * detInv;
  		te[ 6 ] = ( n14 * n32 * n41 - n12 * n34 * n41 - n14 * n31 * n42 + n11 * n34 * n42 + n12 * n31 * n44 - n11 * n32 * n44 ) * detInv;
  		te[ 7 ] = ( n12 * n33 * n41 - n13 * n32 * n41 + n13 * n31 * n42 - n11 * n33 * n42 - n12 * n31 * n43 + n11 * n32 * n43 ) * detInv;

  		te[ 8 ] = t13 * detInv;
  		te[ 9 ] = ( n14 * n23 * n41 - n13 * n24 * n41 - n14 * n21 * n43 + n11 * n24 * n43 + n13 * n21 * n44 - n11 * n23 * n44 ) * detInv;
  		te[ 10 ] = ( n12 * n24 * n41 - n14 * n22 * n41 + n14 * n21 * n42 - n11 * n24 * n42 - n12 * n21 * n44 + n11 * n22 * n44 ) * detInv;
  		te[ 11 ] = ( n13 * n22 * n41 - n12 * n23 * n41 - n13 * n21 * n42 + n11 * n23 * n42 + n12 * n21 * n43 - n11 * n22 * n43 ) * detInv;

  		te[ 12 ] = t14 * detInv;
  		te[ 13 ] = ( n13 * n24 * n31 - n14 * n23 * n31 + n14 * n21 * n33 - n11 * n24 * n33 - n13 * n21 * n34 + n11 * n23 * n34 ) * detInv;
  		te[ 14 ] = ( n14 * n22 * n31 - n12 * n24 * n31 - n14 * n21 * n32 + n11 * n24 * n32 + n12 * n21 * n34 - n11 * n22 * n34 ) * detInv;
  		te[ 15 ] = ( n12 * n23 * n31 - n13 * n22 * n31 + n13 * n21 * n32 - n11 * n23 * n32 - n12 * n21 * n33 + n11 * n22 * n33 ) * detInv;

  		return this;

  	}

  	scale( v ) {

  		const te = this.elements;
  		const x = v.x, y = v.y, z = v.z;

  		te[ 0 ] *= x; te[ 4 ] *= y; te[ 8 ] *= z;
  		te[ 1 ] *= x; te[ 5 ] *= y; te[ 9 ] *= z;
  		te[ 2 ] *= x; te[ 6 ] *= y; te[ 10 ] *= z;
  		te[ 3 ] *= x; te[ 7 ] *= y; te[ 11 ] *= z;

  		return this;

  	}

  	getMaxScaleOnAxis() {

  		const te = this.elements;

  		const scaleXSq = te[ 0 ] * te[ 0 ] + te[ 1 ] * te[ 1 ] + te[ 2 ] * te[ 2 ];
  		const scaleYSq = te[ 4 ] * te[ 4 ] + te[ 5 ] * te[ 5 ] + te[ 6 ] * te[ 6 ];
  		const scaleZSq = te[ 8 ] * te[ 8 ] + te[ 9 ] * te[ 9 ] + te[ 10 ] * te[ 10 ];

  		return Math.sqrt( Math.max( scaleXSq, scaleYSq, scaleZSq ) );

  	}

  	makeTranslation( x, y, z ) {

  		this.set(

  			1, 0, 0, x,
  			0, 1, 0, y,
  			0, 0, 1, z,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	makeRotationX( theta ) {

  		const c = Math.cos( theta ), s = Math.sin( theta );

  		this.set(

  			1, 0, 0, 0,
  			0, c, - s, 0,
  			0, s, c, 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	makeRotationY( theta ) {

  		const c = Math.cos( theta ), s = Math.sin( theta );

  		this.set(

  			 c, 0, s, 0,
  			 0, 1, 0, 0,
  			- s, 0, c, 0,
  			 0, 0, 0, 1

  		);

  		return this;

  	}

  	makeRotationZ( theta ) {

  		const c = Math.cos( theta ), s = Math.sin( theta );

  		this.set(

  			c, - s, 0, 0,
  			s, c, 0, 0,
  			0, 0, 1, 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	makeRotationAxis( axis, angle ) {

  		// Based on http://www.gamedev.net/reference/articles/article1199.asp

  		const c = Math.cos( angle );
  		const s = Math.sin( angle );
  		const t = 1 - c;
  		const x = axis.x, y = axis.y, z = axis.z;
  		const tx = t * x, ty = t * y;

  		this.set(

  			tx * x + c, tx * y - s * z, tx * z + s * y, 0,
  			tx * y + s * z, ty * y + c, ty * z - s * x, 0,
  			tx * z - s * y, ty * z + s * x, t * z * z + c, 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	makeScale( x, y, z ) {

  		this.set(

  			x, 0, 0, 0,
  			0, y, 0, 0,
  			0, 0, z, 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	makeShear( x, y, z ) {

  		this.set(

  			1, y, z, 0,
  			x, 1, z, 0,
  			x, y, 1, 0,
  			0, 0, 0, 1

  		);

  		return this;

  	}

  	compose( position, quaternion, scale ) {

  		const te = this.elements;

  		const x = quaternion._x, y = quaternion._y, z = quaternion._z, w = quaternion._w;
  		const x2 = x + x,	y2 = y + y, z2 = z + z;
  		const xx = x * x2, xy = x * y2, xz = x * z2;
  		const yy = y * y2, yz = y * z2, zz = z * z2;
  		const wx = w * x2, wy = w * y2, wz = w * z2;

  		const sx = scale.x, sy = scale.y, sz = scale.z;

  		te[ 0 ] = ( 1 - ( yy + zz ) ) * sx;
  		te[ 1 ] = ( xy + wz ) * sx;
  		te[ 2 ] = ( xz - wy ) * sx;
  		te[ 3 ] = 0;

  		te[ 4 ] = ( xy - wz ) * sy;
  		te[ 5 ] = ( 1 - ( xx + zz ) ) * sy;
  		te[ 6 ] = ( yz + wx ) * sy;
  		te[ 7 ] = 0;

  		te[ 8 ] = ( xz + wy ) * sz;
  		te[ 9 ] = ( yz - wx ) * sz;
  		te[ 10 ] = ( 1 - ( xx + yy ) ) * sz;
  		te[ 11 ] = 0;

  		te[ 12 ] = position.x;
  		te[ 13 ] = position.y;
  		te[ 14 ] = position.z;
  		te[ 15 ] = 1;

  		return this;

  	}

  	decompose( position, quaternion, scale ) {

  		const te = this.elements;

  		let sx = _v1$1.set( te[ 0 ], te[ 1 ], te[ 2 ] ).length();
  		const sy = _v1$1.set( te[ 4 ], te[ 5 ], te[ 6 ] ).length();
  		const sz = _v1$1.set( te[ 8 ], te[ 9 ], te[ 10 ] ).length();

  		// if determine is negative, we need to invert one scale
  		const det = this.determinant();
  		if ( det < 0 ) sx = - sx;

  		position.x = te[ 12 ];
  		position.y = te[ 13 ];
  		position.z = te[ 14 ];

  		// scale the rotation part
  		_m1.copy( this );

  		const invSX = 1 / sx;
  		const invSY = 1 / sy;
  		const invSZ = 1 / sz;

  		_m1.elements[ 0 ] *= invSX;
  		_m1.elements[ 1 ] *= invSX;
  		_m1.elements[ 2 ] *= invSX;

  		_m1.elements[ 4 ] *= invSY;
  		_m1.elements[ 5 ] *= invSY;
  		_m1.elements[ 6 ] *= invSY;

  		_m1.elements[ 8 ] *= invSZ;
  		_m1.elements[ 9 ] *= invSZ;
  		_m1.elements[ 10 ] *= invSZ;

  		quaternion.setFromRotationMatrix( _m1 );

  		scale.x = sx;
  		scale.y = sy;
  		scale.z = sz;

  		return this;

  	}

  	makePerspective( left, right, top, bottom, near, far ) {

  		if ( far === undefined ) {

  			console.warn( 'THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.' );

  		}

  		const te = this.elements;
  		const x = 2 * near / ( right - left );
  		const y = 2 * near / ( top - bottom );

  		const a = ( right + left ) / ( right - left );
  		const b = ( top + bottom ) / ( top - bottom );
  		const c = - ( far + near ) / ( far - near );
  		const d = - 2 * far * near / ( far - near );

  		te[ 0 ] = x;	te[ 4 ] = 0;	te[ 8 ] = a;	te[ 12 ] = 0;
  		te[ 1 ] = 0;	te[ 5 ] = y;	te[ 9 ] = b;	te[ 13 ] = 0;
  		te[ 2 ] = 0;	te[ 6 ] = 0;	te[ 10 ] = c;	te[ 14 ] = d;
  		te[ 3 ] = 0;	te[ 7 ] = 0;	te[ 11 ] = - 1;	te[ 15 ] = 0;

  		return this;

  	}

  	makeOrthographic( left, right, top, bottom, near, far ) {

  		const te = this.elements;
  		const w = 1.0 / ( right - left );
  		const h = 1.0 / ( top - bottom );
  		const p = 1.0 / ( far - near );

  		const x = ( right + left ) * w;
  		const y = ( top + bottom ) * h;
  		const z = ( far + near ) * p;

  		te[ 0 ] = 2 * w;	te[ 4 ] = 0;	te[ 8 ] = 0;	te[ 12 ] = - x;
  		te[ 1 ] = 0;	te[ 5 ] = 2 * h;	te[ 9 ] = 0;	te[ 13 ] = - y;
  		te[ 2 ] = 0;	te[ 6 ] = 0;	te[ 10 ] = - 2 * p;	te[ 14 ] = - z;
  		te[ 3 ] = 0;	te[ 7 ] = 0;	te[ 11 ] = 0;	te[ 15 ] = 1;

  		return this;

  	}

  	equals( matrix ) {

  		const te = this.elements;
  		const me = matrix.elements;

  		for ( let i = 0; i < 16; i ++ ) {

  			if ( te[ i ] !== me[ i ] ) return false;

  		}

  		return true;

  	}

  	fromArray( array, offset = 0 ) {

  		for ( let i = 0; i < 16; i ++ ) {

  			this.elements[ i ] = array[ i + offset ];

  		}

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		const te = this.elements;

  		array[ offset ] = te[ 0 ];
  		array[ offset + 1 ] = te[ 1 ];
  		array[ offset + 2 ] = te[ 2 ];
  		array[ offset + 3 ] = te[ 3 ];

  		array[ offset + 4 ] = te[ 4 ];
  		array[ offset + 5 ] = te[ 5 ];
  		array[ offset + 6 ] = te[ 6 ];
  		array[ offset + 7 ] = te[ 7 ];

  		array[ offset + 8 ] = te[ 8 ];
  		array[ offset + 9 ] = te[ 9 ];
  		array[ offset + 10 ] = te[ 10 ];
  		array[ offset + 11 ] = te[ 11 ];

  		array[ offset + 12 ] = te[ 12 ];
  		array[ offset + 13 ] = te[ 13 ];
  		array[ offset + 14 ] = te[ 14 ];
  		array[ offset + 15 ] = te[ 15 ];

  		return array;

  	}

  }

  const _v1$1 = /*@__PURE__*/ new Vector3();
  const _m1 = /*@__PURE__*/ new Matrix4();
  const _zero = /*@__PURE__*/ new Vector3( 0, 0, 0 );
  const _one = /*@__PURE__*/ new Vector3( 1, 1, 1 );
  const _x = /*@__PURE__*/ new Vector3();
  const _y = /*@__PURE__*/ new Vector3();
  const _z = /*@__PURE__*/ new Vector3();

  class Euler {

  	constructor( x = 0, y = 0, z = 0, order = Euler.DefaultOrder ) {

  		Object.defineProperty( this, 'isEuler', { value: true } );

  		this._x = x;
  		this._y = y;
  		this._z = z;
  		this._order = order;

  	}

  	get x() {

  		return this._x;

  	}

  	set x( value ) {

  		this._x = value;
  		this._onChangeCallback();

  	}

  	get y() {

  		return this._y;

  	}

  	set y( value ) {

  		this._y = value;
  		this._onChangeCallback();

  	}

  	get z() {

  		return this._z;

  	}

  	set z( value ) {

  		this._z = value;
  		this._onChangeCallback();

  	}

  	get order() {

  		return this._order;

  	}

  	set order( value ) {

  		this._order = value;
  		this._onChangeCallback();

  	}

  	set( x, y, z, order ) {

  		this._x = x;
  		this._y = y;
  		this._z = z;
  		this._order = order || this._order;

  		this._onChangeCallback();

  		return this;

  	}

  	clone() {

  		return new this.constructor( this._x, this._y, this._z, this._order );

  	}

  	copy( euler ) {

  		this._x = euler._x;
  		this._y = euler._y;
  		this._z = euler._z;
  		this._order = euler._order;

  		this._onChangeCallback();

  		return this;

  	}

  	setFromRotationMatrix( m, order, update ) {

  		const clamp = MathUtils.clamp;

  		// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)

  		const te = m.elements;
  		const m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ];
  		const m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ];
  		const m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ];

  		order = order || this._order;

  		switch ( order ) {

  			case 'XYZ':

  				this._y = Math.asin( clamp( m13, - 1, 1 ) );

  				if ( Math.abs( m13 ) < 0.9999999 ) {

  					this._x = Math.atan2( - m23, m33 );
  					this._z = Math.atan2( - m12, m11 );

  				} else {

  					this._x = Math.atan2( m32, m22 );
  					this._z = 0;

  				}

  				break;

  			case 'YXZ':

  				this._x = Math.asin( - clamp( m23, - 1, 1 ) );

  				if ( Math.abs( m23 ) < 0.9999999 ) {

  					this._y = Math.atan2( m13, m33 );
  					this._z = Math.atan2( m21, m22 );

  				} else {

  					this._y = Math.atan2( - m31, m11 );
  					this._z = 0;

  				}

  				break;

  			case 'ZXY':

  				this._x = Math.asin( clamp( m32, - 1, 1 ) );

  				if ( Math.abs( m32 ) < 0.9999999 ) {

  					this._y = Math.atan2( - m31, m33 );
  					this._z = Math.atan2( - m12, m22 );

  				} else {

  					this._y = 0;
  					this._z = Math.atan2( m21, m11 );

  				}

  				break;

  			case 'ZYX':

  				this._y = Math.asin( - clamp( m31, - 1, 1 ) );

  				if ( Math.abs( m31 ) < 0.9999999 ) {

  					this._x = Math.atan2( m32, m33 );
  					this._z = Math.atan2( m21, m11 );

  				} else {

  					this._x = 0;
  					this._z = Math.atan2( - m12, m22 );

  				}

  				break;

  			case 'YZX':

  				this._z = Math.asin( clamp( m21, - 1, 1 ) );

  				if ( Math.abs( m21 ) < 0.9999999 ) {

  					this._x = Math.atan2( - m23, m22 );
  					this._y = Math.atan2( - m31, m11 );

  				} else {

  					this._x = 0;
  					this._y = Math.atan2( m13, m33 );

  				}

  				break;

  			case 'XZY':

  				this._z = Math.asin( - clamp( m12, - 1, 1 ) );

  				if ( Math.abs( m12 ) < 0.9999999 ) {

  					this._x = Math.atan2( m32, m22 );
  					this._y = Math.atan2( m13, m11 );

  				} else {

  					this._x = Math.atan2( - m23, m33 );
  					this._y = 0;

  				}

  				break;

  			default:

  				console.warn( 'THREE.Euler: .setFromRotationMatrix() encountered an unknown order: ' + order );

  		}

  		this._order = order;

  		if ( update !== false ) this._onChangeCallback();

  		return this;

  	}

  	setFromQuaternion( q, order, update ) {

  		_matrix.makeRotationFromQuaternion( q );

  		return this.setFromRotationMatrix( _matrix, order, update );

  	}

  	setFromVector3( v, order ) {

  		return this.set( v.x, v.y, v.z, order || this._order );

  	}

  	reorder( newOrder ) {

  		// WARNING: this discards revolution information -bhouston

  		_quaternion$1.setFromEuler( this );

  		return this.setFromQuaternion( _quaternion$1, newOrder );

  	}

  	equals( euler ) {

  		return ( euler._x === this._x ) && ( euler._y === this._y ) && ( euler._z === this._z ) && ( euler._order === this._order );

  	}

  	fromArray( array ) {

  		this._x = array[ 0 ];
  		this._y = array[ 1 ];
  		this._z = array[ 2 ];
  		if ( array[ 3 ] !== undefined ) this._order = array[ 3 ];

  		this._onChangeCallback();

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		array[ offset ] = this._x;
  		array[ offset + 1 ] = this._y;
  		array[ offset + 2 ] = this._z;
  		array[ offset + 3 ] = this._order;

  		return array;

  	}

  	toVector3( optionalResult ) {

  		if ( optionalResult ) {

  			return optionalResult.set( this._x, this._y, this._z );

  		} else {

  			return new Vector3( this._x, this._y, this._z );

  		}

  	}

  	_onChange( callback ) {

  		this._onChangeCallback = callback;

  		return this;

  	}

  	_onChangeCallback() {}

  }

  Euler.DefaultOrder = 'XYZ';
  Euler.RotationOrders = [ 'XYZ', 'YZX', 'ZXY', 'XZY', 'YXZ', 'ZYX' ];

  const _matrix = /*@__PURE__*/ new Matrix4();
  const _quaternion$1 = /*@__PURE__*/ new Quaternion();

  class Layers {

  	constructor() {

  		this.mask = 1 | 0;

  	}

  	set( channel ) {

  		this.mask = 1 << channel | 0;

  	}

  	enable( channel ) {

  		this.mask |= 1 << channel | 0;

  	}

  	enableAll() {

  		this.mask = 0xffffffff | 0;

  	}

  	toggle( channel ) {

  		this.mask ^= 1 << channel | 0;

  	}

  	disable( channel ) {

  		this.mask &= ~ ( 1 << channel | 0 );

  	}

  	disableAll() {

  		this.mask = 0;

  	}

  	test( layers ) {

  		return ( this.mask & layers.mask ) !== 0;

  	}

  }

  let _object3DId = 0;

  const _v1$2 = new Vector3();
  const _q1 = new Quaternion();
  const _m1$1 = new Matrix4();
  const _target = new Vector3();

  const _position = new Vector3();
  const _scale = new Vector3();
  const _quaternion$2 = new Quaternion();

  const _xAxis = new Vector3( 1, 0, 0 );
  const _yAxis = new Vector3( 0, 1, 0 );
  const _zAxis = new Vector3( 0, 0, 1 );

  const _addedEvent = { type: 'added' };
  const _removedEvent = { type: 'removed' };

  function Object3D() {

  	Object.defineProperty( this, 'id', { value: _object3DId ++ } );

  	this.uuid = MathUtils.generateUUID();

  	this.name = '';
  	this.type = 'Object3D';

  	this.parent = null;
  	this.children = [];

  	this.up = Object3D.DefaultUp.clone();

  	const position = new Vector3();
  	const rotation = new Euler();
  	const quaternion = new Quaternion();
  	const scale = new Vector3( 1, 1, 1 );

  	function onRotationChange() {

  		quaternion.setFromEuler( rotation, false );

  	}

  	function onQuaternionChange() {

  		rotation.setFromQuaternion( quaternion, undefined, false );

  	}

  	rotation._onChange( onRotationChange );
  	quaternion._onChange( onQuaternionChange );

  	Object.defineProperties( this, {
  		position: {
  			configurable: true,
  			enumerable: true,
  			value: position
  		},
  		rotation: {
  			configurable: true,
  			enumerable: true,
  			value: rotation
  		},
  		quaternion: {
  			configurable: true,
  			enumerable: true,
  			value: quaternion
  		},
  		scale: {
  			configurable: true,
  			enumerable: true,
  			value: scale
  		},
  		modelViewMatrix: {
  			value: new Matrix4()
  		},
  		normalMatrix: {
  			value: new Matrix3()
  		}
  	} );

  	this.matrix = new Matrix4();
  	this.matrixWorld = new Matrix4();

  	this.matrixAutoUpdate = Object3D.DefaultMatrixAutoUpdate;
  	this.matrixWorldNeedsUpdate = false;

  	this.layers = new Layers();
  	this.visible = true;

  	this.castShadow = false;
  	this.receiveShadow = false;

  	this.frustumCulled = true;
  	this.renderOrder = 0;

  	this.animations = [];

  	this.userData = {};

  }

  Object3D.DefaultUp = new Vector3( 0, 1, 0 );
  Object3D.DefaultMatrixAutoUpdate = true;

  Object3D.prototype = Object.assign( Object.create( EventDispatcher.prototype ), {

  	constructor: Object3D,

  	isObject3D: true,

  	onBeforeRender: function () {},
  	onAfterRender: function () {},

  	applyMatrix4: function ( matrix ) {

  		if ( this.matrixAutoUpdate ) this.updateMatrix();

  		this.matrix.premultiply( matrix );

  		this.matrix.decompose( this.position, this.quaternion, this.scale );

  	},

  	applyQuaternion: function ( q ) {

  		this.quaternion.premultiply( q );

  		return this;

  	},

  	setRotationFromAxisAngle: function ( axis, angle ) {

  		// assumes axis is normalized

  		this.quaternion.setFromAxisAngle( axis, angle );

  	},

  	setRotationFromEuler: function ( euler ) {

  		this.quaternion.setFromEuler( euler, true );

  	},

  	setRotationFromMatrix: function ( m ) {

  		// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)

  		this.quaternion.setFromRotationMatrix( m );

  	},

  	setRotationFromQuaternion: function ( q ) {

  		// assumes q is normalized

  		this.quaternion.copy( q );

  	},

  	rotateOnAxis: function ( axis, angle ) {

  		// rotate object on axis in object space
  		// axis is assumed to be normalized

  		_q1.setFromAxisAngle( axis, angle );

  		this.quaternion.multiply( _q1 );

  		return this;

  	},

  	rotateOnWorldAxis: function ( axis, angle ) {

  		// rotate object on axis in world space
  		// axis is assumed to be normalized
  		// method assumes no rotated parent

  		_q1.setFromAxisAngle( axis, angle );

  		this.quaternion.premultiply( _q1 );

  		return this;

  	},

  	rotateX: function ( angle ) {

  		return this.rotateOnAxis( _xAxis, angle );

  	},

  	rotateY: function ( angle ) {

  		return this.rotateOnAxis( _yAxis, angle );

  	},

  	rotateZ: function ( angle ) {

  		return this.rotateOnAxis( _zAxis, angle );

  	},

  	translateOnAxis: function ( axis, distance ) {

  		// translate object by distance along axis in object space
  		// axis is assumed to be normalized

  		_v1$2.copy( axis ).applyQuaternion( this.quaternion );

  		this.position.add( _v1$2.multiplyScalar( distance ) );

  		return this;

  	},

  	translateX: function ( distance ) {

  		return this.translateOnAxis( _xAxis, distance );

  	},

  	translateY: function ( distance ) {

  		return this.translateOnAxis( _yAxis, distance );

  	},

  	translateZ: function ( distance ) {

  		return this.translateOnAxis( _zAxis, distance );

  	},

  	localToWorld: function ( vector ) {

  		return vector.applyMatrix4( this.matrixWorld );

  	},

  	worldToLocal: function ( vector ) {

  		return vector.applyMatrix4( _m1$1.copy( this.matrixWorld ).invert() );

  	},

  	lookAt: function ( x, y, z ) {

  		// This method does not support objects having non-uniformly-scaled parent(s)

  		if ( x.isVector3 ) {

  			_target.copy( x );

  		} else {

  			_target.set( x, y, z );

  		}

  		const parent = this.parent;

  		this.updateWorldMatrix( true, false );

  		_position.setFromMatrixPosition( this.matrixWorld );

  		if ( this.isCamera || this.isLight ) {

  			_m1$1.lookAt( _position, _target, this.up );

  		} else {

  			_m1$1.lookAt( _target, _position, this.up );

  		}

  		this.quaternion.setFromRotationMatrix( _m1$1 );

  		if ( parent ) {

  			_m1$1.extractRotation( parent.matrixWorld );
  			_q1.setFromRotationMatrix( _m1$1 );
  			this.quaternion.premultiply( _q1.invert() );

  		}

  	},

  	add: function ( object ) {

  		if ( arguments.length > 1 ) {

  			for ( let i = 0; i < arguments.length; i ++ ) {

  				this.add( arguments[ i ] );

  			}

  			return this;

  		}

  		if ( object === this ) {

  			console.error( 'THREE.Object3D.add: object can\'t be added as a child of itself.', object );
  			return this;

  		}

  		if ( object && object.isObject3D ) {

  			if ( object.parent !== null ) {

  				object.parent.remove( object );

  			}

  			object.parent = this;
  			this.children.push( object );

  			object.dispatchEvent( _addedEvent );

  		} else {

  			console.error( 'THREE.Object3D.add: object not an instance of THREE.Object3D.', object );

  		}

  		return this;

  	},

  	remove: function ( object ) {

  		if ( arguments.length > 1 ) {

  			for ( let i = 0; i < arguments.length; i ++ ) {

  				this.remove( arguments[ i ] );

  			}

  			return this;

  		}

  		const index = this.children.indexOf( object );

  		if ( index !== - 1 ) {

  			object.parent = null;
  			this.children.splice( index, 1 );

  			object.dispatchEvent( _removedEvent );

  		}

  		return this;

  	},

  	clear: function () {

  		for ( let i = 0; i < this.children.length; i ++ ) {

  			const object = this.children[ i ];

  			object.parent = null;

  			object.dispatchEvent( _removedEvent );

  		}

  		this.children.length = 0;

  		return this;


  	},

  	attach: function ( object ) {

  		// adds object as a child of this, while maintaining the object's world transform

  		this.updateWorldMatrix( true, false );

  		_m1$1.copy( this.matrixWorld ).invert();

  		if ( object.parent !== null ) {

  			object.parent.updateWorldMatrix( true, false );

  			_m1$1.multiply( object.parent.matrixWorld );

  		}

  		object.applyMatrix4( _m1$1 );

  		object.updateWorldMatrix( false, false );

  		this.add( object );

  		return this;

  	},

  	getObjectById: function ( id ) {

  		return this.getObjectByProperty( 'id', id );

  	},

  	getObjectByName: function ( name ) {

  		return this.getObjectByProperty( 'name', name );

  	},

  	getObjectByProperty: function ( name, value ) {

  		if ( this[ name ] === value ) return this;

  		for ( let i = 0, l = this.children.length; i < l; i ++ ) {

  			const child = this.children[ i ];
  			const object = child.getObjectByProperty( name, value );

  			if ( object !== undefined ) {

  				return object;

  			}

  		}

  		return undefined;

  	},

  	getWorldPosition: function ( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Object3D: .getWorldPosition() target is now required' );
  			target = new Vector3();

  		}

  		this.updateWorldMatrix( true, false );

  		return target.setFromMatrixPosition( this.matrixWorld );

  	},

  	getWorldQuaternion: function ( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Object3D: .getWorldQuaternion() target is now required' );
  			target = new Quaternion();

  		}

  		this.updateWorldMatrix( true, false );

  		this.matrixWorld.decompose( _position, target, _scale );

  		return target;

  	},

  	getWorldScale: function ( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Object3D: .getWorldScale() target is now required' );
  			target = new Vector3();

  		}

  		this.updateWorldMatrix( true, false );

  		this.matrixWorld.decompose( _position, _quaternion$2, target );

  		return target;

  	},

  	getWorldDirection: function ( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Object3D: .getWorldDirection() target is now required' );
  			target = new Vector3();

  		}

  		this.updateWorldMatrix( true, false );

  		const e = this.matrixWorld.elements;

  		return target.set( e[ 8 ], e[ 9 ], e[ 10 ] ).normalize();

  	},

  	raycast: function () {},

  	traverse: function ( callback ) {

  		callback( this );

  		const children = this.children;

  		for ( let i = 0, l = children.length; i < l; i ++ ) {

  			children[ i ].traverse( callback );

  		}

  	},

  	traverseVisible: function ( callback ) {

  		if ( this.visible === false ) return;

  		callback( this );

  		const children = this.children;

  		for ( let i = 0, l = children.length; i < l; i ++ ) {

  			children[ i ].traverseVisible( callback );

  		}

  	},

  	traverseAncestors: function ( callback ) {

  		const parent = this.parent;

  		if ( parent !== null ) {

  			callback( parent );

  			parent.traverseAncestors( callback );

  		}

  	},

  	updateMatrix: function () {

  		this.matrix.compose( this.position, this.quaternion, this.scale );

  		this.matrixWorldNeedsUpdate = true;

  	},

  	updateMatrixWorld: function ( force ) {

  		if ( this.matrixAutoUpdate ) this.updateMatrix();

  		if ( this.matrixWorldNeedsUpdate || force ) {

  			if ( this.parent === null ) {

  				this.matrixWorld.copy( this.matrix );

  			} else {

  				this.matrixWorld.multiplyMatrices( this.parent.matrixWorld, this.matrix );

  			}

  			this.matrixWorldNeedsUpdate = false;

  			force = true;

  		}

  		// update children

  		const children = this.children;

  		for ( let i = 0, l = children.length; i < l; i ++ ) {

  			children[ i ].updateMatrixWorld( force );

  		}

  	},

  	updateWorldMatrix: function ( updateParents, updateChildren ) {

  		const parent = this.parent;

  		if ( updateParents === true && parent !== null ) {

  			parent.updateWorldMatrix( true, false );

  		}

  		if ( this.matrixAutoUpdate ) this.updateMatrix();

  		if ( this.parent === null ) {

  			this.matrixWorld.copy( this.matrix );

  		} else {

  			this.matrixWorld.multiplyMatrices( this.parent.matrixWorld, this.matrix );

  		}

  		// update children

  		if ( updateChildren === true ) {

  			const children = this.children;

  			for ( let i = 0, l = children.length; i < l; i ++ ) {

  				children[ i ].updateWorldMatrix( false, true );

  			}

  		}

  	},

  	toJSON: function ( meta ) {

  		// meta is a string when called from JSON.stringify
  		const isRootObject = ( meta === undefined || typeof meta === 'string' );

  		const output = {};

  		// meta is a hash used to collect geometries, materials.
  		// not providing it implies that this is the root object
  		// being serialized.
  		if ( isRootObject ) {

  			// initialize meta obj
  			meta = {
  				geometries: {},
  				materials: {},
  				textures: {},
  				images: {},
  				shapes: {},
  				skeletons: {},
  				animations: {}
  			};

  			output.metadata = {
  				version: 4.5,
  				type: 'Object',
  				generator: 'Object3D.toJSON'
  			};

  		}

  		// standard Object3D serialization

  		const object = {};

  		object.uuid = this.uuid;
  		object.type = this.type;

  		if ( this.name !== '' ) object.name = this.name;
  		if ( this.castShadow === true ) object.castShadow = true;
  		if ( this.receiveShadow === true ) object.receiveShadow = true;
  		if ( this.visible === false ) object.visible = false;
  		if ( this.frustumCulled === false ) object.frustumCulled = false;
  		if ( this.renderOrder !== 0 ) object.renderOrder = this.renderOrder;
  		if ( JSON.stringify( this.userData ) !== '{}' ) object.userData = this.userData;

  		object.layers = this.layers.mask;
  		object.matrix = this.matrix.toArray();

  		if ( this.matrixAutoUpdate === false ) object.matrixAutoUpdate = false;

  		// object specific properties

  		if ( this.isInstancedMesh ) {

  			object.type = 'InstancedMesh';
  			object.count = this.count;
  			object.instanceMatrix = this.instanceMatrix.toJSON();

  		}

  		//

  		function serialize( library, element ) {

  			if ( library[ element.uuid ] === undefined ) {

  				library[ element.uuid ] = element.toJSON( meta );

  			}

  			return element.uuid;

  		}

  		if ( this.isMesh || this.isLine || this.isPoints ) {

  			object.geometry = serialize( meta.geometries, this.geometry );

  			const parameters = this.geometry.parameters;

  			if ( parameters !== undefined && parameters.shapes !== undefined ) {

  				const shapes = parameters.shapes;

  				if ( Array.isArray( shapes ) ) {

  					for ( let i = 0, l = shapes.length; i < l; i ++ ) {

  						const shape = shapes[ i ];

  						serialize( meta.shapes, shape );

  					}

  				} else {

  					serialize( meta.shapes, shapes );

  				}

  			}

  		}

  		if ( this.isSkinnedMesh ) {

  			object.bindMode = this.bindMode;
  			object.bindMatrix = this.bindMatrix.toArray();

  			if ( this.skeleton !== undefined ) {

  				serialize( meta.skeletons, this.skeleton );

  				object.skeleton = this.skeleton.uuid;

  			}

  		}

  		if ( this.material !== undefined ) {

  			if ( Array.isArray( this.material ) ) {

  				const uuids = [];

  				for ( let i = 0, l = this.material.length; i < l; i ++ ) {

  					uuids.push( serialize( meta.materials, this.material[ i ] ) );

  				}

  				object.material = uuids;

  			} else {

  				object.material = serialize( meta.materials, this.material );

  			}

  		}

  		//

  		if ( this.children.length > 0 ) {

  			object.children = [];

  			for ( let i = 0; i < this.children.length; i ++ ) {

  				object.children.push( this.children[ i ].toJSON( meta ).object );

  			}

  		}

  		//

  		if ( this.animations.length > 0 ) {

  			object.animations = [];

  			for ( let i = 0; i < this.animations.length; i ++ ) {

  				const animation = this.animations[ i ];

  				object.animations.push( serialize( meta.animations, animation ) );

  			}

  		}

  		if ( isRootObject ) {

  			const geometries = extractFromCache( meta.geometries );
  			const materials = extractFromCache( meta.materials );
  			const textures = extractFromCache( meta.textures );
  			const images = extractFromCache( meta.images );
  			const shapes = extractFromCache( meta.shapes );
  			const skeletons = extractFromCache( meta.skeletons );
  			const animations = extractFromCache( meta.animations );

  			if ( geometries.length > 0 ) output.geometries = geometries;
  			if ( materials.length > 0 ) output.materials = materials;
  			if ( textures.length > 0 ) output.textures = textures;
  			if ( images.length > 0 ) output.images = images;
  			if ( shapes.length > 0 ) output.shapes = shapes;
  			if ( skeletons.length > 0 ) output.skeletons = skeletons;
  			if ( animations.length > 0 ) output.animations = animations;

  		}

  		output.object = object;

  		return output;

  		// extract data from the cache hash
  		// remove metadata on each item
  		// and return as array
  		function extractFromCache( cache ) {

  			const values = [];
  			for ( const key in cache ) {

  				const data = cache[ key ];
  				delete data.metadata;
  				values.push( data );

  			}

  			return values;

  		}

  	},

  	clone: function ( recursive ) {

  		return new this.constructor().copy( this, recursive );

  	},

  	copy: function ( source, recursive = true ) {

  		this.name = source.name;

  		this.up.copy( source.up );

  		this.position.copy( source.position );
  		this.rotation.order = source.rotation.order;
  		this.quaternion.copy( source.quaternion );
  		this.scale.copy( source.scale );

  		this.matrix.copy( source.matrix );
  		this.matrixWorld.copy( source.matrixWorld );

  		this.matrixAutoUpdate = source.matrixAutoUpdate;
  		this.matrixWorldNeedsUpdate = source.matrixWorldNeedsUpdate;

  		this.layers.mask = source.layers.mask;
  		this.visible = source.visible;

  		this.castShadow = source.castShadow;
  		this.receiveShadow = source.receiveShadow;

  		this.frustumCulled = source.frustumCulled;
  		this.renderOrder = source.renderOrder;

  		this.userData = JSON.parse( JSON.stringify( source.userData ) );

  		if ( recursive === true ) {

  			for ( let i = 0; i < source.children.length; i ++ ) {

  				const child = source.children[ i ];
  				this.add( child.clone() );

  			}

  		}

  		return this;

  	}

  } );

  const _vector1 = /*@__PURE__*/ new Vector3();
  const _vector2 = /*@__PURE__*/ new Vector3();
  const _normalMatrix = /*@__PURE__*/ new Matrix3();

  class Plane {

  	constructor( normal, constant ) {

  		Object.defineProperty( this, 'isPlane', { value: true } );

  		// normal is assumed to be normalized

  		this.normal = ( normal !== undefined ) ? normal : new Vector3( 1, 0, 0 );
  		this.constant = ( constant !== undefined ) ? constant : 0;

  	}

  	set( normal, constant ) {

  		this.normal.copy( normal );
  		this.constant = constant;

  		return this;

  	}

  	setComponents( x, y, z, w ) {

  		this.normal.set( x, y, z );
  		this.constant = w;

  		return this;

  	}

  	setFromNormalAndCoplanarPoint( normal, point ) {

  		this.normal.copy( normal );
  		this.constant = - point.dot( this.normal );

  		return this;

  	}

  	setFromCoplanarPoints( a, b, c ) {

  		const normal = _vector1.subVectors( c, b ).cross( _vector2.subVectors( a, b ) ).normalize();

  		// Q: should an error be thrown if normal is zero (e.g. degenerate plane)?

  		this.setFromNormalAndCoplanarPoint( normal, a );

  		return this;

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( plane ) {

  		this.normal.copy( plane.normal );
  		this.constant = plane.constant;

  		return this;

  	}

  	normalize() {

  		// Note: will lead to a divide by zero if the plane is invalid.

  		const inverseNormalLength = 1.0 / this.normal.length();
  		this.normal.multiplyScalar( inverseNormalLength );
  		this.constant *= inverseNormalLength;

  		return this;

  	}

  	negate() {

  		this.constant *= - 1;
  		this.normal.negate();

  		return this;

  	}

  	distanceToPoint( point ) {

  		return this.normal.dot( point ) + this.constant;

  	}

  	distanceToSphere( sphere ) {

  		return this.distanceToPoint( sphere.center ) - sphere.radius;

  	}

  	projectPoint( point, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Plane: .projectPoint() target is now required' );
  			target = new Vector3();

  		}

  		return target.copy( this.normal ).multiplyScalar( - this.distanceToPoint( point ) ).add( point );

  	}

  	intersectLine( line, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Plane: .intersectLine() target is now required' );
  			target = new Vector3();

  		}

  		const direction = line.delta( _vector1 );

  		const denominator = this.normal.dot( direction );

  		if ( denominator === 0 ) {

  			// line is coplanar, return origin
  			if ( this.distanceToPoint( line.start ) === 0 ) {

  				return target.copy( line.start );

  			}

  			// Unsure if this is the correct method to handle this case.
  			return undefined;

  		}

  		const t = - ( line.start.dot( this.normal ) + this.constant ) / denominator;

  		if ( t < 0 || t > 1 ) {

  			return undefined;

  		}

  		return target.copy( direction ).multiplyScalar( t ).add( line.start );

  	}

  	intersectsLine( line ) {

  		// Note: this tests if a line intersects the plane, not whether it (or its end-points) are coplanar with it.

  		const startSign = this.distanceToPoint( line.start );
  		const endSign = this.distanceToPoint( line.end );

  		return ( startSign < 0 && endSign > 0 ) || ( endSign < 0 && startSign > 0 );

  	}

  	intersectsBox( box ) {

  		return box.intersectsPlane( this );

  	}

  	intersectsSphere( sphere ) {

  		return sphere.intersectsPlane( this );

  	}

  	coplanarPoint( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Plane: .coplanarPoint() target is now required' );
  			target = new Vector3();

  		}

  		return target.copy( this.normal ).multiplyScalar( - this.constant );

  	}

  	applyMatrix4( matrix, optionalNormalMatrix ) {

  		const normalMatrix = optionalNormalMatrix || _normalMatrix.getNormalMatrix( matrix );

  		const referencePoint = this.coplanarPoint( _vector1 ).applyMatrix4( matrix );

  		const normal = this.normal.applyMatrix3( normalMatrix ).normalize();

  		this.constant = - referencePoint.dot( normal );

  		return this;

  	}

  	translate( offset ) {

  		this.constant -= offset.dot( this.normal );

  		return this;

  	}

  	equals( plane ) {

  		return plane.normal.equals( this.normal ) && ( plane.constant === this.constant );

  	}

  }

  const _v0$1 = /*@__PURE__*/ new Vector3();
  const _v1$3 = /*@__PURE__*/ new Vector3();
  const _v2$1 = /*@__PURE__*/ new Vector3();
  const _v3 = /*@__PURE__*/ new Vector3();

  const _vab = /*@__PURE__*/ new Vector3();
  const _vac = /*@__PURE__*/ new Vector3();
  const _vbc = /*@__PURE__*/ new Vector3();
  const _vap = /*@__PURE__*/ new Vector3();
  const _vbp = /*@__PURE__*/ new Vector3();
  const _vcp = /*@__PURE__*/ new Vector3();

  class Triangle {

  	constructor( a, b, c ) {

  		this.a = ( a !== undefined ) ? a : new Vector3();
  		this.b = ( b !== undefined ) ? b : new Vector3();
  		this.c = ( c !== undefined ) ? c : new Vector3();

  	}

  	static getNormal( a, b, c, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Triangle: .getNormal() target is now required' );
  			target = new Vector3();

  		}

  		target.subVectors( c, b );
  		_v0$1.subVectors( a, b );
  		target.cross( _v0$1 );

  		const targetLengthSq = target.lengthSq();
  		if ( targetLengthSq > 0 ) {

  			return target.multiplyScalar( 1 / Math.sqrt( targetLengthSq ) );

  		}

  		return target.set( 0, 0, 0 );

  	}

  	// static/instance method to calculate barycentric coordinates
  	// based on: http://www.blackpawn.com/texts/pointinpoly/default.html
  	static getBarycoord( point, a, b, c, target ) {

  		_v0$1.subVectors( c, a );
  		_v1$3.subVectors( b, a );
  		_v2$1.subVectors( point, a );

  		const dot00 = _v0$1.dot( _v0$1 );
  		const dot01 = _v0$1.dot( _v1$3 );
  		const dot02 = _v0$1.dot( _v2$1 );
  		const dot11 = _v1$3.dot( _v1$3 );
  		const dot12 = _v1$3.dot( _v2$1 );

  		const denom = ( dot00 * dot11 - dot01 * dot01 );

  		if ( target === undefined ) {

  			console.warn( 'THREE.Triangle: .getBarycoord() target is now required' );
  			target = new Vector3();

  		}

  		// collinear or singular triangle
  		if ( denom === 0 ) {

  			// arbitrary location outside of triangle?
  			// not sure if this is the best idea, maybe should be returning undefined
  			return target.set( - 2, - 1, - 1 );

  		}

  		const invDenom = 1 / denom;
  		const u = ( dot11 * dot02 - dot01 * dot12 ) * invDenom;
  		const v = ( dot00 * dot12 - dot01 * dot02 ) * invDenom;

  		// barycentric coordinates must always sum to 1
  		return target.set( 1 - u - v, v, u );

  	}

  	static containsPoint( point, a, b, c ) {

  		this.getBarycoord( point, a, b, c, _v3 );

  		return ( _v3.x >= 0 ) && ( _v3.y >= 0 ) && ( ( _v3.x + _v3.y ) <= 1 );

  	}

  	static getUV( point, p1, p2, p3, uv1, uv2, uv3, target ) {

  		this.getBarycoord( point, p1, p2, p3, _v3 );

  		target.set( 0, 0 );
  		target.addScaledVector( uv1, _v3.x );
  		target.addScaledVector( uv2, _v3.y );
  		target.addScaledVector( uv3, _v3.z );

  		return target;

  	}

  	static isFrontFacing( a, b, c, direction ) {

  		_v0$1.subVectors( c, b );
  		_v1$3.subVectors( a, b );

  		// strictly front facing
  		return ( _v0$1.cross( _v1$3 ).dot( direction ) < 0 ) ? true : false;

  	}

  	set( a, b, c ) {

  		this.a.copy( a );
  		this.b.copy( b );
  		this.c.copy( c );

  		return this;

  	}

  	setFromPointsAndIndices( points, i0, i1, i2 ) {

  		this.a.copy( points[ i0 ] );
  		this.b.copy( points[ i1 ] );
  		this.c.copy( points[ i2 ] );

  		return this;

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( triangle ) {

  		this.a.copy( triangle.a );
  		this.b.copy( triangle.b );
  		this.c.copy( triangle.c );

  		return this;

  	}

  	getArea() {

  		_v0$1.subVectors( this.c, this.b );
  		_v1$3.subVectors( this.a, this.b );

  		return _v0$1.cross( _v1$3 ).length() * 0.5;

  	}

  	getMidpoint( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Triangle: .getMidpoint() target is now required' );
  			target = new Vector3();

  		}

  		return target.addVectors( this.a, this.b ).add( this.c ).multiplyScalar( 1 / 3 );

  	}

  	getNormal( target ) {

  		return Triangle.getNormal( this.a, this.b, this.c, target );

  	}

  	getPlane( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Triangle: .getPlane() target is now required' );
  			target = new Plane();

  		}

  		return target.setFromCoplanarPoints( this.a, this.b, this.c );

  	}

  	getBarycoord( point, target ) {

  		return Triangle.getBarycoord( point, this.a, this.b, this.c, target );

  	}

  	getUV( point, uv1, uv2, uv3, target ) {

  		return Triangle.getUV( point, this.a, this.b, this.c, uv1, uv2, uv3, target );

  	}

  	containsPoint( point ) {

  		return Triangle.containsPoint( point, this.a, this.b, this.c );

  	}

  	isFrontFacing( direction ) {

  		return Triangle.isFrontFacing( this.a, this.b, this.c, direction );

  	}

  	intersectsBox( box ) {

  		return box.intersectsTriangle( this );

  	}

  	closestPointToPoint( p, target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Triangle: .closestPointToPoint() target is now required' );
  			target = new Vector3();

  		}

  		const a = this.a, b = this.b, c = this.c;
  		let v, w;

  		// algorithm thanks to Real-Time Collision Detection by Christer Ericson,
  		// published by Morgan Kaufmann Publishers, (c) 2005 Elsevier Inc.,
  		// under the accompanying license; see chapter 5.1.5 for detailed explanation.
  		// basically, we're distinguishing which of the voronoi regions of the triangle
  		// the point lies in with the minimum amount of redundant computation.

  		_vab.subVectors( b, a );
  		_vac.subVectors( c, a );
  		_vap.subVectors( p, a );
  		const d1 = _vab.dot( _vap );
  		const d2 = _vac.dot( _vap );
  		if ( d1 <= 0 && d2 <= 0 ) {

  			// vertex region of A; barycentric coords (1, 0, 0)
  			return target.copy( a );

  		}

  		_vbp.subVectors( p, b );
  		const d3 = _vab.dot( _vbp );
  		const d4 = _vac.dot( _vbp );
  		if ( d3 >= 0 && d4 <= d3 ) {

  			// vertex region of B; barycentric coords (0, 1, 0)
  			return target.copy( b );

  		}

  		const vc = d1 * d4 - d3 * d2;
  		if ( vc <= 0 && d1 >= 0 && d3 <= 0 ) {

  			v = d1 / ( d1 - d3 );
  			// edge region of AB; barycentric coords (1-v, v, 0)
  			return target.copy( a ).addScaledVector( _vab, v );

  		}

  		_vcp.subVectors( p, c );
  		const d5 = _vab.dot( _vcp );
  		const d6 = _vac.dot( _vcp );
  		if ( d6 >= 0 && d5 <= d6 ) {

  			// vertex region of C; barycentric coords (0, 0, 1)
  			return target.copy( c );

  		}

  		const vb = d5 * d2 - d1 * d6;
  		if ( vb <= 0 && d2 >= 0 && d6 <= 0 ) {

  			w = d2 / ( d2 - d6 );
  			// edge region of AC; barycentric coords (1-w, 0, w)
  			return target.copy( a ).addScaledVector( _vac, w );

  		}

  		const va = d3 * d6 - d5 * d4;
  		if ( va <= 0 && ( d4 - d3 ) >= 0 && ( d5 - d6 ) >= 0 ) {

  			_vbc.subVectors( c, b );
  			w = ( d4 - d3 ) / ( ( d4 - d3 ) + ( d5 - d6 ) );
  			// edge region of BC; barycentric coords (0, 1-w, w)
  			return target.copy( b ).addScaledVector( _vbc, w ); // edge region of BC

  		}

  		// face region
  		const denom = 1 / ( va + vb + vc );
  		// u = va * denom
  		v = vb * denom;
  		w = vc * denom;

  		return target.copy( a ).addScaledVector( _vab, v ).addScaledVector( _vac, w );

  	}

  	equals( triangle ) {

  		return triangle.a.equals( this.a ) && triangle.b.equals( this.b ) && triangle.c.equals( this.c );

  	}

  }

  const _colorKeywords = { 'aliceblue': 0xF0F8FF, 'antiquewhite': 0xFAEBD7, 'aqua': 0x00FFFF, 'aquamarine': 0x7FFFD4, 'azure': 0xF0FFFF,
  	'beige': 0xF5F5DC, 'bisque': 0xFFE4C4, 'black': 0x000000, 'blanchedalmond': 0xFFEBCD, 'blue': 0x0000FF, 'blueviolet': 0x8A2BE2,
  	'brown': 0xA52A2A, 'burlywood': 0xDEB887, 'cadetblue': 0x5F9EA0, 'chartreuse': 0x7FFF00, 'chocolate': 0xD2691E, 'coral': 0xFF7F50,
  	'cornflowerblue': 0x6495ED, 'cornsilk': 0xFFF8DC, 'crimson': 0xDC143C, 'cyan': 0x00FFFF, 'darkblue': 0x00008B, 'darkcyan': 0x008B8B,
  	'darkgoldenrod': 0xB8860B, 'darkgray': 0xA9A9A9, 'darkgreen': 0x006400, 'darkgrey': 0xA9A9A9, 'darkkhaki': 0xBDB76B, 'darkmagenta': 0x8B008B,
  	'darkolivegreen': 0x556B2F, 'darkorange': 0xFF8C00, 'darkorchid': 0x9932CC, 'darkred': 0x8B0000, 'darksalmon': 0xE9967A, 'darkseagreen': 0x8FBC8F,
  	'darkslateblue': 0x483D8B, 'darkslategray': 0x2F4F4F, 'darkslategrey': 0x2F4F4F, 'darkturquoise': 0x00CED1, 'darkviolet': 0x9400D3,
  	'deeppink': 0xFF1493, 'deepskyblue': 0x00BFFF, 'dimgray': 0x696969, 'dimgrey': 0x696969, 'dodgerblue': 0x1E90FF, 'firebrick': 0xB22222,
  	'floralwhite': 0xFFFAF0, 'forestgreen': 0x228B22, 'fuchsia': 0xFF00FF, 'gainsboro': 0xDCDCDC, 'ghostwhite': 0xF8F8FF, 'gold': 0xFFD700,
  	'goldenrod': 0xDAA520, 'gray': 0x808080, 'green': 0x008000, 'greenyellow': 0xADFF2F, 'grey': 0x808080, 'honeydew': 0xF0FFF0, 'hotpink': 0xFF69B4,
  	'indianred': 0xCD5C5C, 'indigo': 0x4B0082, 'ivory': 0xFFFFF0, 'khaki': 0xF0E68C, 'lavender': 0xE6E6FA, 'lavenderblush': 0xFFF0F5, 'lawngreen': 0x7CFC00,
  	'lemonchiffon': 0xFFFACD, 'lightblue': 0xADD8E6, 'lightcoral': 0xF08080, 'lightcyan': 0xE0FFFF, 'lightgoldenrodyellow': 0xFAFAD2, 'lightgray': 0xD3D3D3,
  	'lightgreen': 0x90EE90, 'lightgrey': 0xD3D3D3, 'lightpink': 0xFFB6C1, 'lightsalmon': 0xFFA07A, 'lightseagreen': 0x20B2AA, 'lightskyblue': 0x87CEFA,
  	'lightslategray': 0x778899, 'lightslategrey': 0x778899, 'lightsteelblue': 0xB0C4DE, 'lightyellow': 0xFFFFE0, 'lime': 0x00FF00, 'limegreen': 0x32CD32,
  	'linen': 0xFAF0E6, 'magenta': 0xFF00FF, 'maroon': 0x800000, 'mediumaquamarine': 0x66CDAA, 'mediumblue': 0x0000CD, 'mediumorchid': 0xBA55D3,
  	'mediumpurple': 0x9370DB, 'mediumseagreen': 0x3CB371, 'mediumslateblue': 0x7B68EE, 'mediumspringgreen': 0x00FA9A, 'mediumturquoise': 0x48D1CC,
  	'mediumvioletred': 0xC71585, 'midnightblue': 0x191970, 'mintcream': 0xF5FFFA, 'mistyrose': 0xFFE4E1, 'moccasin': 0xFFE4B5, 'navajowhite': 0xFFDEAD,
  	'navy': 0x000080, 'oldlace': 0xFDF5E6, 'olive': 0x808000, 'olivedrab': 0x6B8E23, 'orange': 0xFFA500, 'orangered': 0xFF4500, 'orchid': 0xDA70D6,
  	'palegoldenrod': 0xEEE8AA, 'palegreen': 0x98FB98, 'paleturquoise': 0xAFEEEE, 'palevioletred': 0xDB7093, 'papayawhip': 0xFFEFD5, 'peachpuff': 0xFFDAB9,
  	'peru': 0xCD853F, 'pink': 0xFFC0CB, 'plum': 0xDDA0DD, 'powderblue': 0xB0E0E6, 'purple': 0x800080, 'rebeccapurple': 0x663399, 'red': 0xFF0000, 'rosybrown': 0xBC8F8F,
  	'royalblue': 0x4169E1, 'saddlebrown': 0x8B4513, 'salmon': 0xFA8072, 'sandybrown': 0xF4A460, 'seagreen': 0x2E8B57, 'seashell': 0xFFF5EE,
  	'sienna': 0xA0522D, 'silver': 0xC0C0C0, 'skyblue': 0x87CEEB, 'slateblue': 0x6A5ACD, 'slategray': 0x708090, 'slategrey': 0x708090, 'snow': 0xFFFAFA,
  	'springgreen': 0x00FF7F, 'steelblue': 0x4682B4, 'tan': 0xD2B48C, 'teal': 0x008080, 'thistle': 0xD8BFD8, 'tomato': 0xFF6347, 'turquoise': 0x40E0D0,
  	'violet': 0xEE82EE, 'wheat': 0xF5DEB3, 'white': 0xFFFFFF, 'whitesmoke': 0xF5F5F5, 'yellow': 0xFFFF00, 'yellowgreen': 0x9ACD32 };

  const _hslA = { h: 0, s: 0, l: 0 };
  const _hslB = { h: 0, s: 0, l: 0 };

  function hue2rgb( p, q, t ) {

  	if ( t < 0 ) t += 1;
  	if ( t > 1 ) t -= 1;
  	if ( t < 1 / 6 ) return p + ( q - p ) * 6 * t;
  	if ( t < 1 / 2 ) return q;
  	if ( t < 2 / 3 ) return p + ( q - p ) * 6 * ( 2 / 3 - t );
  	return p;

  }

  function SRGBToLinear( c ) {

  	return ( c < 0.04045 ) ? c * 0.0773993808 : Math.pow( c * 0.9478672986 + 0.0521327014, 2.4 );

  }

  function LinearToSRGB( c ) {

  	return ( c < 0.0031308 ) ? c * 12.92 : 1.055 * ( Math.pow( c, 0.41666 ) ) - 0.055;

  }

  class Color {

  	constructor( r, g, b ) {

  		Object.defineProperty( this, 'isColor', { value: true } );

  		if ( g === undefined && b === undefined ) {

  			// r is THREE.Color, hex or string
  			return this.set( r );

  		}

  		return this.setRGB( r, g, b );

  	}

  	set( value ) {

  		if ( value && value.isColor ) {

  			this.copy( value );

  		} else if ( typeof value === 'number' ) {

  			this.setHex( value );

  		} else if ( typeof value === 'string' ) {

  			this.setStyle( value );

  		}

  		return this;

  	}

  	setScalar( scalar ) {

  		this.r = scalar;
  		this.g = scalar;
  		this.b = scalar;

  		return this;

  	}

  	setHex( hex ) {

  		hex = Math.floor( hex );

  		this.r = ( hex >> 16 & 255 ) / 255;
  		this.g = ( hex >> 8 & 255 ) / 255;
  		this.b = ( hex & 255 ) / 255;

  		return this;

  	}

  	setRGB( r, g, b ) {

  		this.r = r;
  		this.g = g;
  		this.b = b;

  		return this;

  	}

  	setHSL( h, s, l ) {

  		// h,s,l ranges are in 0.0 - 1.0
  		h = MathUtils.euclideanModulo( h, 1 );
  		s = MathUtils.clamp( s, 0, 1 );
  		l = MathUtils.clamp( l, 0, 1 );

  		if ( s === 0 ) {

  			this.r = this.g = this.b = l;

  		} else {

  			const p = l <= 0.5 ? l * ( 1 + s ) : l + s - ( l * s );
  			const q = ( 2 * l ) - p;

  			this.r = hue2rgb( q, p, h + 1 / 3 );
  			this.g = hue2rgb( q, p, h );
  			this.b = hue2rgb( q, p, h - 1 / 3 );

  		}

  		return this;

  	}

  	setStyle( style ) {

  		function handleAlpha( string ) {

  			if ( string === undefined ) return;

  			if ( parseFloat( string ) < 1 ) {

  				console.warn( 'THREE.Color: Alpha component of ' + style + ' will be ignored.' );

  			}

  		}


  		let m;

  		if ( m = /^((?:rgb|hsl)a?)\(([^\)]*)\)/.exec( style ) ) {

  			// rgb / hsl

  			let color;
  			const name = m[ 1 ];
  			const components = m[ 2 ];

  			switch ( name ) {

  				case 'rgb':
  				case 'rgba':

  					if ( color = /^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec( components ) ) {

  						// rgb(255,0,0) rgba(255,0,0,0.5)
  						this.r = Math.min( 255, parseInt( color[ 1 ], 10 ) ) / 255;
  						this.g = Math.min( 255, parseInt( color[ 2 ], 10 ) ) / 255;
  						this.b = Math.min( 255, parseInt( color[ 3 ], 10 ) ) / 255;

  						handleAlpha( color[ 4 ] );

  						return this;

  					}

  					if ( color = /^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec( components ) ) {

  						// rgb(100%,0%,0%) rgba(100%,0%,0%,0.5)
  						this.r = Math.min( 100, parseInt( color[ 1 ], 10 ) ) / 100;
  						this.g = Math.min( 100, parseInt( color[ 2 ], 10 ) ) / 100;
  						this.b = Math.min( 100, parseInt( color[ 3 ], 10 ) ) / 100;

  						handleAlpha( color[ 4 ] );

  						return this;

  					}

  					break;

  				case 'hsl':
  				case 'hsla':

  					if ( color = /^\s*(\d*\.?\d+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec( components ) ) {

  						// hsl(120,50%,50%) hsla(120,50%,50%,0.5)
  						const h = parseFloat( color[ 1 ] ) / 360;
  						const s = parseInt( color[ 2 ], 10 ) / 100;
  						const l = parseInt( color[ 3 ], 10 ) / 100;

  						handleAlpha( color[ 4 ] );

  						return this.setHSL( h, s, l );

  					}

  					break;

  			}

  		} else if ( m = /^\#([A-Fa-f\d]+)$/.exec( style ) ) {

  			// hex color

  			const hex = m[ 1 ];
  			const size = hex.length;

  			if ( size === 3 ) {

  				// #ff0
  				this.r = parseInt( hex.charAt( 0 ) + hex.charAt( 0 ), 16 ) / 255;
  				this.g = parseInt( hex.charAt( 1 ) + hex.charAt( 1 ), 16 ) / 255;
  				this.b = parseInt( hex.charAt( 2 ) + hex.charAt( 2 ), 16 ) / 255;

  				return this;

  			} else if ( size === 6 ) {

  				// #ff0000
  				this.r = parseInt( hex.charAt( 0 ) + hex.charAt( 1 ), 16 ) / 255;
  				this.g = parseInt( hex.charAt( 2 ) + hex.charAt( 3 ), 16 ) / 255;
  				this.b = parseInt( hex.charAt( 4 ) + hex.charAt( 5 ), 16 ) / 255;

  				return this;

  			}

  		}

  		if ( style && style.length > 0 ) {

  			return this.setColorName( style );

  		}

  		return this;

  	}

  	setColorName( style ) {

  		// color keywords
  		const hex = _colorKeywords[ style ];

  		if ( hex !== undefined ) {

  			// red
  			this.setHex( hex );

  		} else {

  			// unknown color
  			console.warn( 'THREE.Color: Unknown color ' + style );

  		}

  		return this;

  	}

  	clone() {

  		return new this.constructor( this.r, this.g, this.b );

  	}

  	copy( color ) {

  		this.r = color.r;
  		this.g = color.g;
  		this.b = color.b;

  		return this;

  	}

  	copyGammaToLinear( color, gammaFactor = 2.0 ) {

  		this.r = Math.pow( color.r, gammaFactor );
  		this.g = Math.pow( color.g, gammaFactor );
  		this.b = Math.pow( color.b, gammaFactor );

  		return this;

  	}

  	copyLinearToGamma( color, gammaFactor = 2.0 ) {

  		const safeInverse = ( gammaFactor > 0 ) ? ( 1.0 / gammaFactor ) : 1.0;

  		this.r = Math.pow( color.r, safeInverse );
  		this.g = Math.pow( color.g, safeInverse );
  		this.b = Math.pow( color.b, safeInverse );

  		return this;

  	}

  	convertGammaToLinear( gammaFactor ) {

  		this.copyGammaToLinear( this, gammaFactor );

  		return this;

  	}

  	convertLinearToGamma( gammaFactor ) {

  		this.copyLinearToGamma( this, gammaFactor );

  		return this;

  	}

  	copySRGBToLinear( color ) {

  		this.r = SRGBToLinear( color.r );
  		this.g = SRGBToLinear( color.g );
  		this.b = SRGBToLinear( color.b );

  		return this;

  	}

  	copyLinearToSRGB( color ) {

  		this.r = LinearToSRGB( color.r );
  		this.g = LinearToSRGB( color.g );
  		this.b = LinearToSRGB( color.b );

  		return this;

  	}

  	convertSRGBToLinear() {

  		this.copySRGBToLinear( this );

  		return this;

  	}

  	convertLinearToSRGB() {

  		this.copyLinearToSRGB( this );

  		return this;

  	}

  	getHex() {

  		return ( this.r * 255 ) << 16 ^ ( this.g * 255 ) << 8 ^ ( this.b * 255 ) << 0;

  	}

  	getHexString() {

  		return ( '000000' + this.getHex().toString( 16 ) ).slice( - 6 );

  	}

  	getHSL( target ) {

  		// h,s,l ranges are in 0.0 - 1.0

  		if ( target === undefined ) {

  			console.warn( 'THREE.Color: .getHSL() target is now required' );
  			target = { h: 0, s: 0, l: 0 };

  		}

  		const r = this.r, g = this.g, b = this.b;

  		const max = Math.max( r, g, b );
  		const min = Math.min( r, g, b );

  		let hue, saturation;
  		const lightness = ( min + max ) / 2.0;

  		if ( min === max ) {

  			hue = 0;
  			saturation = 0;

  		} else {

  			const delta = max - min;

  			saturation = lightness <= 0.5 ? delta / ( max + min ) : delta / ( 2 - max - min );

  			switch ( max ) {

  				case r: hue = ( g - b ) / delta + ( g < b ? 6 : 0 ); break;
  				case g: hue = ( b - r ) / delta + 2; break;
  				case b: hue = ( r - g ) / delta + 4; break;

  			}

  			hue /= 6;

  		}

  		target.h = hue;
  		target.s = saturation;
  		target.l = lightness;

  		return target;

  	}

  	getStyle() {

  		return 'rgb(' + ( ( this.r * 255 ) | 0 ) + ',' + ( ( this.g * 255 ) | 0 ) + ',' + ( ( this.b * 255 ) | 0 ) + ')';

  	}

  	offsetHSL( h, s, l ) {

  		this.getHSL( _hslA );

  		_hslA.h += h; _hslA.s += s; _hslA.l += l;

  		this.setHSL( _hslA.h, _hslA.s, _hslA.l );

  		return this;

  	}

  	add( color ) {

  		this.r += color.r;
  		this.g += color.g;
  		this.b += color.b;

  		return this;

  	}

  	addColors( color1, color2 ) {

  		this.r = color1.r + color2.r;
  		this.g = color1.g + color2.g;
  		this.b = color1.b + color2.b;

  		return this;

  	}

  	addScalar( s ) {

  		this.r += s;
  		this.g += s;
  		this.b += s;

  		return this;

  	}

  	sub( color ) {

  		this.r = Math.max( 0, this.r - color.r );
  		this.g = Math.max( 0, this.g - color.g );
  		this.b = Math.max( 0, this.b - color.b );

  		return this;

  	}

  	multiply( color ) {

  		this.r *= color.r;
  		this.g *= color.g;
  		this.b *= color.b;

  		return this;

  	}

  	multiplyScalar( s ) {

  		this.r *= s;
  		this.g *= s;
  		this.b *= s;

  		return this;

  	}

  	lerp( color, alpha ) {

  		this.r += ( color.r - this.r ) * alpha;
  		this.g += ( color.g - this.g ) * alpha;
  		this.b += ( color.b - this.b ) * alpha;

  		return this;

  	}

  	lerpColors( color1, color2, alpha ) {

  		this.r = color1.r + ( color2.r - color1.r ) * alpha;
  		this.g = color1.g + ( color2.g - color1.g ) * alpha;
  		this.b = color1.b + ( color2.b - color1.b ) * alpha;

  		return this;

  	}

  	lerpHSL( color, alpha ) {

  		this.getHSL( _hslA );
  		color.getHSL( _hslB );

  		const h = MathUtils.lerp( _hslA.h, _hslB.h, alpha );
  		const s = MathUtils.lerp( _hslA.s, _hslB.s, alpha );
  		const l = MathUtils.lerp( _hslA.l, _hslB.l, alpha );

  		this.setHSL( h, s, l );

  		return this;

  	}

  	equals( c ) {

  		return ( c.r === this.r ) && ( c.g === this.g ) && ( c.b === this.b );

  	}

  	fromArray( array, offset = 0 ) {

  		this.r = array[ offset ];
  		this.g = array[ offset + 1 ];
  		this.b = array[ offset + 2 ];

  		return this;

  	}

  	toArray( array = [], offset = 0 ) {

  		array[ offset ] = this.r;
  		array[ offset + 1 ] = this.g;
  		array[ offset + 2 ] = this.b;

  		return array;

  	}

  	fromBufferAttribute( attribute, index ) {

  		this.r = attribute.getX( index );
  		this.g = attribute.getY( index );
  		this.b = attribute.getZ( index );

  		if ( attribute.normalized === true ) {

  			// assuming Uint8Array

  			this.r /= 255;
  			this.g /= 255;
  			this.b /= 255;

  		}

  		return this;

  	}

  	toJSON() {

  		return this.getHex();

  	}

  }

  Color.NAMES = _colorKeywords;
  Color.prototype.r = 1;
  Color.prototype.g = 1;
  Color.prototype.b = 1;

  class Face3 {

  	constructor( a, b, c, normal, color, materialIndex = 0 ) {

  		this.a = a;
  		this.b = b;
  		this.c = c;

  		this.normal = ( normal && normal.isVector3 ) ? normal : new Vector3();
  		this.vertexNormals = Array.isArray( normal ) ? normal : [];

  		this.color = ( color && color.isColor ) ? color : new Color();
  		this.vertexColors = Array.isArray( color ) ? color : [];

  		this.materialIndex = materialIndex;

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( source ) {

  		this.a = source.a;
  		this.b = source.b;
  		this.c = source.c;

  		this.normal.copy( source.normal );
  		this.color.copy( source.color );

  		this.materialIndex = source.materialIndex;

  		for ( let i = 0, il = source.vertexNormals.length; i < il; i ++ ) {

  			this.vertexNormals[ i ] = source.vertexNormals[ i ].clone();

  		}

  		for ( let i = 0, il = source.vertexColors.length; i < il; i ++ ) {

  			this.vertexColors[ i ] = source.vertexColors[ i ].clone();

  		}

  		return this;

  	}

  }

  let materialId = 0;

  function Material() {

  	Object.defineProperty( this, 'id', { value: materialId ++ } );

  	this.uuid = MathUtils.generateUUID();

  	this.name = '';
  	this.type = 'Material';

  	this.fog = true;

  	this.blending = NormalBlending;
  	this.side = FrontSide;
  	this.flatShading = false;
  	this.vertexColors = false;

  	this.opacity = 1;
  	this.transparent = false;

  	this.blendSrc = SrcAlphaFactor;
  	this.blendDst = OneMinusSrcAlphaFactor;
  	this.blendEquation = AddEquation;
  	this.blendSrcAlpha = null;
  	this.blendDstAlpha = null;
  	this.blendEquationAlpha = null;

  	this.depthFunc = LessEqualDepth;
  	this.depthTest = true;
  	this.depthWrite = true;

  	this.stencilWriteMask = 0xff;
  	this.stencilFunc = AlwaysStencilFunc;
  	this.stencilRef = 0;
  	this.stencilFuncMask = 0xff;
  	this.stencilFail = KeepStencilOp;
  	this.stencilZFail = KeepStencilOp;
  	this.stencilZPass = KeepStencilOp;
  	this.stencilWrite = false;

  	this.clippingPlanes = null;
  	this.clipIntersection = false;
  	this.clipShadows = false;

  	this.shadowSide = null;

  	this.colorWrite = true;

  	this.precision = null; // override the renderer's default precision for this material

  	this.polygonOffset = false;
  	this.polygonOffsetFactor = 0;
  	this.polygonOffsetUnits = 0;

  	this.dithering = false;

  	this.alphaTest = 0;
  	this.premultipliedAlpha = false;

  	this.visible = true;

  	this.toneMapped = true;

  	this.userData = {};

  	this.version = 0;

  }

  Material.prototype = Object.assign( Object.create( EventDispatcher.prototype ), {

  	constructor: Material,

  	isMaterial: true,

  	onBeforeCompile: function ( /* shaderobject, renderer */ ) {},

  	customProgramCacheKey: function () {

  		return this.onBeforeCompile.toString();

  	},

  	setValues: function ( values ) {

  		if ( values === undefined ) return;

  		for ( const key in values ) {

  			const newValue = values[ key ];

  			if ( newValue === undefined ) {

  				console.warn( 'THREE.Material: \'' + key + '\' parameter is undefined.' );
  				continue;

  			}

  			// for backward compatability if shading is set in the constructor
  			if ( key === 'shading' ) {

  				console.warn( 'THREE.' + this.type + ': .shading has been removed. Use the boolean .flatShading instead.' );
  				this.flatShading = ( newValue === FlatShading ) ? true : false;
  				continue;

  			}

  			const currentValue = this[ key ];

  			if ( currentValue === undefined ) {

  				console.warn( 'THREE.' + this.type + ': \'' + key + '\' is not a property of this material.' );
  				continue;

  			}

  			if ( currentValue && currentValue.isColor ) {

  				currentValue.set( newValue );

  			} else if ( ( currentValue && currentValue.isVector3 ) && ( newValue && newValue.isVector3 ) ) {

  				currentValue.copy( newValue );

  			} else {

  				this[ key ] = newValue;

  			}

  		}

  	},

  	toJSON: function ( meta ) {

  		const isRoot = ( meta === undefined || typeof meta === 'string' );

  		if ( isRoot ) {

  			meta = {
  				textures: {},
  				images: {}
  			};

  		}

  		const data = {
  			metadata: {
  				version: 4.5,
  				type: 'Material',
  				generator: 'Material.toJSON'
  			}
  		};

  		// standard Material serialization
  		data.uuid = this.uuid;
  		data.type = this.type;

  		if ( this.name !== '' ) data.name = this.name;

  		if ( this.color && this.color.isColor ) data.color = this.color.getHex();

  		if ( this.roughness !== undefined ) data.roughness = this.roughness;
  		if ( this.metalness !== undefined ) data.metalness = this.metalness;

  		if ( this.sheen && this.sheen.isColor ) data.sheen = this.sheen.getHex();
  		if ( this.emissive && this.emissive.isColor ) data.emissive = this.emissive.getHex();
  		if ( this.emissiveIntensity && this.emissiveIntensity !== 1 ) data.emissiveIntensity = this.emissiveIntensity;

  		if ( this.specular && this.specular.isColor ) data.specular = this.specular.getHex();
  		if ( this.shininess !== undefined ) data.shininess = this.shininess;
  		if ( this.clearcoat !== undefined ) data.clearcoat = this.clearcoat;
  		if ( this.clearcoatRoughness !== undefined ) data.clearcoatRoughness = this.clearcoatRoughness;

  		if ( this.clearcoatMap && this.clearcoatMap.isTexture ) {

  			data.clearcoatMap = this.clearcoatMap.toJSON( meta ).uuid;

  		}

  		if ( this.clearcoatRoughnessMap && this.clearcoatRoughnessMap.isTexture ) {

  			data.clearcoatRoughnessMap = this.clearcoatRoughnessMap.toJSON( meta ).uuid;

  		}

  		if ( this.clearcoatNormalMap && this.clearcoatNormalMap.isTexture ) {

  			data.clearcoatNormalMap = this.clearcoatNormalMap.toJSON( meta ).uuid;
  			data.clearcoatNormalScale = this.clearcoatNormalScale.toArray();

  		}

  		if ( this.map && this.map.isTexture ) data.map = this.map.toJSON( meta ).uuid;
  		if ( this.matcap && this.matcap.isTexture ) data.matcap = this.matcap.toJSON( meta ).uuid;
  		if ( this.alphaMap && this.alphaMap.isTexture ) data.alphaMap = this.alphaMap.toJSON( meta ).uuid;
  		if ( this.lightMap && this.lightMap.isTexture ) data.lightMap = this.lightMap.toJSON( meta ).uuid;

  		if ( this.aoMap && this.aoMap.isTexture ) {

  			data.aoMap = this.aoMap.toJSON( meta ).uuid;
  			data.aoMapIntensity = this.aoMapIntensity;

  		}

  		if ( this.bumpMap && this.bumpMap.isTexture ) {

  			data.bumpMap = this.bumpMap.toJSON( meta ).uuid;
  			data.bumpScale = this.bumpScale;

  		}

  		if ( this.normalMap && this.normalMap.isTexture ) {

  			data.normalMap = this.normalMap.toJSON( meta ).uuid;
  			data.normalMapType = this.normalMapType;
  			data.normalScale = this.normalScale.toArray();

  		}

  		if ( this.displacementMap && this.displacementMap.isTexture ) {

  			data.displacementMap = this.displacementMap.toJSON( meta ).uuid;
  			data.displacementScale = this.displacementScale;
  			data.displacementBias = this.displacementBias;

  		}

  		if ( this.roughnessMap && this.roughnessMap.isTexture ) data.roughnessMap = this.roughnessMap.toJSON( meta ).uuid;
  		if ( this.metalnessMap && this.metalnessMap.isTexture ) data.metalnessMap = this.metalnessMap.toJSON( meta ).uuid;

  		if ( this.emissiveMap && this.emissiveMap.isTexture ) data.emissiveMap = this.emissiveMap.toJSON( meta ).uuid;
  		if ( this.specularMap && this.specularMap.isTexture ) data.specularMap = this.specularMap.toJSON( meta ).uuid;

  		if ( this.envMap && this.envMap.isTexture ) {

  			data.envMap = this.envMap.toJSON( meta ).uuid;
  			data.reflectivity = this.reflectivity; // Scale behind envMap
  			data.refractionRatio = this.refractionRatio;

  			if ( this.combine !== undefined ) data.combine = this.combine;
  			if ( this.envMapIntensity !== undefined ) data.envMapIntensity = this.envMapIntensity;

  		}

  		if ( this.gradientMap && this.gradientMap.isTexture ) {

  			data.gradientMap = this.gradientMap.toJSON( meta ).uuid;

  		}

  		if ( this.size !== undefined ) data.size = this.size;
  		if ( this.sizeAttenuation !== undefined ) data.sizeAttenuation = this.sizeAttenuation;

  		if ( this.blending !== NormalBlending ) data.blending = this.blending;
  		if ( this.flatShading === true ) data.flatShading = this.flatShading;
  		if ( this.side !== FrontSide ) data.side = this.side;
  		if ( this.vertexColors ) data.vertexColors = true;

  		if ( this.opacity < 1 ) data.opacity = this.opacity;
  		if ( this.transparent === true ) data.transparent = this.transparent;

  		data.depthFunc = this.depthFunc;
  		data.depthTest = this.depthTest;
  		data.depthWrite = this.depthWrite;

  		data.stencilWrite = this.stencilWrite;
  		data.stencilWriteMask = this.stencilWriteMask;
  		data.stencilFunc = this.stencilFunc;
  		data.stencilRef = this.stencilRef;
  		data.stencilFuncMask = this.stencilFuncMask;
  		data.stencilFail = this.stencilFail;
  		data.stencilZFail = this.stencilZFail;
  		data.stencilZPass = this.stencilZPass;

  		// rotation (SpriteMaterial)
  		if ( this.rotation && this.rotation !== 0 ) data.rotation = this.rotation;

  		if ( this.polygonOffset === true ) data.polygonOffset = true;
  		if ( this.polygonOffsetFactor !== 0 ) data.polygonOffsetFactor = this.polygonOffsetFactor;
  		if ( this.polygonOffsetUnits !== 0 ) data.polygonOffsetUnits = this.polygonOffsetUnits;

  		if ( this.linewidth && this.linewidth !== 1 ) data.linewidth = this.linewidth;
  		if ( this.dashSize !== undefined ) data.dashSize = this.dashSize;
  		if ( this.gapSize !== undefined ) data.gapSize = this.gapSize;
  		if ( this.scale !== undefined ) data.scale = this.scale;

  		if ( this.dithering === true ) data.dithering = true;

  		if ( this.alphaTest > 0 ) data.alphaTest = this.alphaTest;
  		if ( this.premultipliedAlpha === true ) data.premultipliedAlpha = this.premultipliedAlpha;

  		if ( this.wireframe === true ) data.wireframe = this.wireframe;
  		if ( this.wireframeLinewidth > 1 ) data.wireframeLinewidth = this.wireframeLinewidth;
  		if ( this.wireframeLinecap !== 'round' ) data.wireframeLinecap = this.wireframeLinecap;
  		if ( this.wireframeLinejoin !== 'round' ) data.wireframeLinejoin = this.wireframeLinejoin;

  		if ( this.morphTargets === true ) data.morphTargets = true;
  		if ( this.morphNormals === true ) data.morphNormals = true;
  		if ( this.skinning === true ) data.skinning = true;

  		if ( this.visible === false ) data.visible = false;

  		if ( this.toneMapped === false ) data.toneMapped = false;

  		if ( JSON.stringify( this.userData ) !== '{}' ) data.userData = this.userData;

  		// TODO: Copied from Object3D.toJSON

  		function extractFromCache( cache ) {

  			const values = [];

  			for ( const key in cache ) {

  				const data = cache[ key ];
  				delete data.metadata;
  				values.push( data );

  			}

  			return values;

  		}

  		if ( isRoot ) {

  			const textures = extractFromCache( meta.textures );
  			const images = extractFromCache( meta.images );

  			if ( textures.length > 0 ) data.textures = textures;
  			if ( images.length > 0 ) data.images = images;

  		}

  		return data;

  	},

  	clone: function () {

  		return new this.constructor().copy( this );

  	},

  	copy: function ( source ) {

  		this.name = source.name;

  		this.fog = source.fog;

  		this.blending = source.blending;
  		this.side = source.side;
  		this.flatShading = source.flatShading;
  		this.vertexColors = source.vertexColors;

  		this.opacity = source.opacity;
  		this.transparent = source.transparent;

  		this.blendSrc = source.blendSrc;
  		this.blendDst = source.blendDst;
  		this.blendEquation = source.blendEquation;
  		this.blendSrcAlpha = source.blendSrcAlpha;
  		this.blendDstAlpha = source.blendDstAlpha;
  		this.blendEquationAlpha = source.blendEquationAlpha;

  		this.depthFunc = source.depthFunc;
  		this.depthTest = source.depthTest;
  		this.depthWrite = source.depthWrite;

  		this.stencilWriteMask = source.stencilWriteMask;
  		this.stencilFunc = source.stencilFunc;
  		this.stencilRef = source.stencilRef;
  		this.stencilFuncMask = source.stencilFuncMask;
  		this.stencilFail = source.stencilFail;
  		this.stencilZFail = source.stencilZFail;
  		this.stencilZPass = source.stencilZPass;
  		this.stencilWrite = source.stencilWrite;

  		const srcPlanes = source.clippingPlanes;
  		let dstPlanes = null;

  		if ( srcPlanes !== null ) {

  			const n = srcPlanes.length;
  			dstPlanes = new Array( n );

  			for ( let i = 0; i !== n; ++ i ) {

  				dstPlanes[ i ] = srcPlanes[ i ].clone();

  			}

  		}

  		this.clippingPlanes = dstPlanes;
  		this.clipIntersection = source.clipIntersection;
  		this.clipShadows = source.clipShadows;

  		this.shadowSide = source.shadowSide;

  		this.colorWrite = source.colorWrite;

  		this.precision = source.precision;

  		this.polygonOffset = source.polygonOffset;
  		this.polygonOffsetFactor = source.polygonOffsetFactor;
  		this.polygonOffsetUnits = source.polygonOffsetUnits;

  		this.dithering = source.dithering;

  		this.alphaTest = source.alphaTest;
  		this.premultipliedAlpha = source.premultipliedAlpha;

  		this.visible = source.visible;

  		this.toneMapped = source.toneMapped;

  		this.userData = JSON.parse( JSON.stringify( source.userData ) );

  		return this;

  	},

  	dispose: function () {

  		this.dispatchEvent( { type: 'dispose' } );

  	}

  } );

  Object.defineProperty( Material.prototype, 'needsUpdate', {

  	set: function ( value ) {

  		if ( value === true ) this.version ++;

  	}

  } );

  /**
   * parameters = {
   *  color: <hex>,
   *  opacity: <float>,
   *  map: new THREE.Texture( <Image> ),
   *
   *  lightMap: new THREE.Texture( <Image> ),
   *  lightMapIntensity: <float>
   *
   *  aoMap: new THREE.Texture( <Image> ),
   *  aoMapIntensity: <float>
   *
   *  specularMap: new THREE.Texture( <Image> ),
   *
   *  alphaMap: new THREE.Texture( <Image> ),
   *
   *  envMap: new THREE.CubeTexture( [posx, negx, posy, negy, posz, negz] ),
   *  combine: THREE.Multiply,
   *  reflectivity: <float>,
   *  refractionRatio: <float>,
   *
   *  depthTest: <bool>,
   *  depthWrite: <bool>,
   *
   *  wireframe: <boolean>,
   *  wireframeLinewidth: <float>,
   *
   *  skinning: <bool>,
   *  morphTargets: <bool>
   * }
   */

  function MeshBasicMaterial( parameters ) {

  	Material.call( this );

  	this.type = 'MeshBasicMaterial';

  	this.color = new Color( 0xffffff ); // emissive

  	this.map = null;

  	this.lightMap = null;
  	this.lightMapIntensity = 1.0;

  	this.aoMap = null;
  	this.aoMapIntensity = 1.0;

  	this.specularMap = null;

  	this.alphaMap = null;

  	this.envMap = null;
  	this.combine = MultiplyOperation;
  	this.reflectivity = 1;
  	this.refractionRatio = 0.98;

  	this.wireframe = false;
  	this.wireframeLinewidth = 1;
  	this.wireframeLinecap = 'round';
  	this.wireframeLinejoin = 'round';

  	this.skinning = false;
  	this.morphTargets = false;

  	this.setValues( parameters );

  }

  MeshBasicMaterial.prototype = Object.create( Material.prototype );
  MeshBasicMaterial.prototype.constructor = MeshBasicMaterial;

  MeshBasicMaterial.prototype.isMeshBasicMaterial = true;

  MeshBasicMaterial.prototype.copy = function ( source ) {

  	Material.prototype.copy.call( this, source );

  	this.color.copy( source.color );

  	this.map = source.map;

  	this.lightMap = source.lightMap;
  	this.lightMapIntensity = source.lightMapIntensity;

  	this.aoMap = source.aoMap;
  	this.aoMapIntensity = source.aoMapIntensity;

  	this.specularMap = source.specularMap;

  	this.alphaMap = source.alphaMap;

  	this.envMap = source.envMap;
  	this.combine = source.combine;
  	this.reflectivity = source.reflectivity;
  	this.refractionRatio = source.refractionRatio;

  	this.wireframe = source.wireframe;
  	this.wireframeLinewidth = source.wireframeLinewidth;
  	this.wireframeLinecap = source.wireframeLinecap;
  	this.wireframeLinejoin = source.wireframeLinejoin;

  	this.skinning = source.skinning;
  	this.morphTargets = source.morphTargets;

  	return this;

  };

  const _vector$3 = new Vector3();
  const _vector2$1 = new Vector2();

  function BufferAttribute( array, itemSize, normalized ) {

  	if ( Array.isArray( array ) ) {

  		throw new TypeError( 'THREE.BufferAttribute: array should be a Typed Array.' );

  	}

  	this.name = '';

  	this.array = array;
  	this.itemSize = itemSize;
  	this.count = array !== undefined ? array.length / itemSize : 0;
  	this.normalized = normalized === true;

  	this.usage = StaticDrawUsage;
  	this.updateRange = { offset: 0, count: - 1 };

  	this.version = 0;

  }

  Object.defineProperty( BufferAttribute.prototype, 'needsUpdate', {

  	set: function ( value ) {

  		if ( value === true ) this.version ++;

  	}

  } );

  Object.assign( BufferAttribute.prototype, {

  	isBufferAttribute: true,

  	onUploadCallback: function () {},

  	setUsage: function ( value ) {

  		this.usage = value;

  		return this;

  	},

  	copy: function ( source ) {

  		this.name = source.name;
  		this.array = new source.array.constructor( source.array );
  		this.itemSize = source.itemSize;
  		this.count = source.count;
  		this.normalized = source.normalized;

  		this.usage = source.usage;

  		return this;

  	},

  	copyAt: function ( index1, attribute, index2 ) {

  		index1 *= this.itemSize;
  		index2 *= attribute.itemSize;

  		for ( let i = 0, l = this.itemSize; i < l; i ++ ) {

  			this.array[ index1 + i ] = attribute.array[ index2 + i ];

  		}

  		return this;

  	},

  	copyArray: function ( array ) {

  		this.array.set( array );

  		return this;

  	},

  	copyColorsArray: function ( colors ) {

  		const array = this.array;
  		let offset = 0;

  		for ( let i = 0, l = colors.length; i < l; i ++ ) {

  			let color = colors[ i ];

  			if ( color === undefined ) {

  				console.warn( 'THREE.BufferAttribute.copyColorsArray(): color is undefined', i );
  				color = new Color();

  			}

  			array[ offset ++ ] = color.r;
  			array[ offset ++ ] = color.g;
  			array[ offset ++ ] = color.b;

  		}

  		return this;

  	},

  	copyVector2sArray: function ( vectors ) {

  		const array = this.array;
  		let offset = 0;

  		for ( let i = 0, l = vectors.length; i < l; i ++ ) {

  			let vector = vectors[ i ];

  			if ( vector === undefined ) {

  				console.warn( 'THREE.BufferAttribute.copyVector2sArray(): vector is undefined', i );
  				vector = new Vector2();

  			}

  			array[ offset ++ ] = vector.x;
  			array[ offset ++ ] = vector.y;

  		}

  		return this;

  	},

  	copyVector3sArray: function ( vectors ) {

  		const array = this.array;
  		let offset = 0;

  		for ( let i = 0, l = vectors.length; i < l; i ++ ) {

  			let vector = vectors[ i ];

  			if ( vector === undefined ) {

  				console.warn( 'THREE.BufferAttribute.copyVector3sArray(): vector is undefined', i );
  				vector = new Vector3();

  			}

  			array[ offset ++ ] = vector.x;
  			array[ offset ++ ] = vector.y;
  			array[ offset ++ ] = vector.z;

  		}

  		return this;

  	},

  	copyVector4sArray: function ( vectors ) {

  		const array = this.array;
  		let offset = 0;

  		for ( let i = 0, l = vectors.length; i < l; i ++ ) {

  			let vector = vectors[ i ];

  			if ( vector === undefined ) {

  				console.warn( 'THREE.BufferAttribute.copyVector4sArray(): vector is undefined', i );
  				vector = new Vector4();

  			}

  			array[ offset ++ ] = vector.x;
  			array[ offset ++ ] = vector.y;
  			array[ offset ++ ] = vector.z;
  			array[ offset ++ ] = vector.w;

  		}

  		return this;

  	},

  	applyMatrix3: function ( m ) {

  		if ( this.itemSize === 2 ) {

  			for ( let i = 0, l = this.count; i < l; i ++ ) {

  				_vector2$1.fromBufferAttribute( this, i );
  				_vector2$1.applyMatrix3( m );

  				this.setXY( i, _vector2$1.x, _vector2$1.y );

  			}

  		} else if ( this.itemSize === 3 ) {

  			for ( let i = 0, l = this.count; i < l; i ++ ) {

  				_vector$3.fromBufferAttribute( this, i );
  				_vector$3.applyMatrix3( m );

  				this.setXYZ( i, _vector$3.x, _vector$3.y, _vector$3.z );

  			}

  		}

  		return this;

  	},

  	applyMatrix4: function ( m ) {

  		for ( let i = 0, l = this.count; i < l; i ++ ) {

  			_vector$3.x = this.getX( i );
  			_vector$3.y = this.getY( i );
  			_vector$3.z = this.getZ( i );

  			_vector$3.applyMatrix4( m );

  			this.setXYZ( i, _vector$3.x, _vector$3.y, _vector$3.z );

  		}

  		return this;

  	},

  	applyNormalMatrix: function ( m ) {

  		for ( let i = 0, l = this.count; i < l; i ++ ) {

  			_vector$3.x = this.getX( i );
  			_vector$3.y = this.getY( i );
  			_vector$3.z = this.getZ( i );

  			_vector$3.applyNormalMatrix( m );

  			this.setXYZ( i, _vector$3.x, _vector$3.y, _vector$3.z );

  		}

  		return this;

  	},

  	transformDirection: function ( m ) {

  		for ( let i = 0, l = this.count; i < l; i ++ ) {

  			_vector$3.x = this.getX( i );
  			_vector$3.y = this.getY( i );
  			_vector$3.z = this.getZ( i );

  			_vector$3.transformDirection( m );

  			this.setXYZ( i, _vector$3.x, _vector$3.y, _vector$3.z );

  		}

  		return this;

  	},

  	set: function ( value, offset = 0 ) {

  		this.array.set( value, offset );

  		return this;

  	},

  	getX: function ( index ) {

  		return this.array[ index * this.itemSize ];

  	},

  	setX: function ( index, x ) {

  		this.array[ index * this.itemSize ] = x;

  		return this;

  	},

  	getY: function ( index ) {

  		return this.array[ index * this.itemSize + 1 ];

  	},

  	setY: function ( index, y ) {

  		this.array[ index * this.itemSize + 1 ] = y;

  		return this;

  	},

  	getZ: function ( index ) {

  		return this.array[ index * this.itemSize + 2 ];

  	},

  	setZ: function ( index, z ) {

  		this.array[ index * this.itemSize + 2 ] = z;

  		return this;

  	},

  	getW: function ( index ) {

  		return this.array[ index * this.itemSize + 3 ];

  	},

  	setW: function ( index, w ) {

  		this.array[ index * this.itemSize + 3 ] = w;

  		return this;

  	},

  	setXY: function ( index, x, y ) {

  		index *= this.itemSize;

  		this.array[ index + 0 ] = x;
  		this.array[ index + 1 ] = y;

  		return this;

  	},

  	setXYZ: function ( index, x, y, z ) {

  		index *= this.itemSize;

  		this.array[ index + 0 ] = x;
  		this.array[ index + 1 ] = y;
  		this.array[ index + 2 ] = z;

  		return this;

  	},

  	setXYZW: function ( index, x, y, z, w ) {

  		index *= this.itemSize;

  		this.array[ index + 0 ] = x;
  		this.array[ index + 1 ] = y;
  		this.array[ index + 2 ] = z;
  		this.array[ index + 3 ] = w;

  		return this;

  	},

  	onUpload: function ( callback ) {

  		this.onUploadCallback = callback;

  		return this;

  	},

  	clone: function () {

  		return new this.constructor( this.array, this.itemSize ).copy( this );

  	},

  	toJSON: function () {

  		return {
  			itemSize: this.itemSize,
  			type: this.array.constructor.name,
  			array: Array.prototype.slice.call( this.array ),
  			normalized: this.normalized
  		};

  	}

  } );

  //

  function Int8BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Int8Array( array ), itemSize, normalized );

  }

  Int8BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Int8BufferAttribute.prototype.constructor = Int8BufferAttribute;


  function Uint8BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Uint8Array( array ), itemSize, normalized );

  }

  Uint8BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Uint8BufferAttribute.prototype.constructor = Uint8BufferAttribute;


  function Uint8ClampedBufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Uint8ClampedArray( array ), itemSize, normalized );

  }

  Uint8ClampedBufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Uint8ClampedBufferAttribute.prototype.constructor = Uint8ClampedBufferAttribute;


  function Int16BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Int16Array( array ), itemSize, normalized );

  }

  Int16BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Int16BufferAttribute.prototype.constructor = Int16BufferAttribute;


  function Uint16BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Uint16Array( array ), itemSize, normalized );

  }

  Uint16BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Uint16BufferAttribute.prototype.constructor = Uint16BufferAttribute;


  function Int32BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Int32Array( array ), itemSize, normalized );

  }

  Int32BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Int32BufferAttribute.prototype.constructor = Int32BufferAttribute;


  function Uint32BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Uint32Array( array ), itemSize, normalized );

  }

  Uint32BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Uint32BufferAttribute.prototype.constructor = Uint32BufferAttribute;

  function Float16BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Uint16Array( array ), itemSize, normalized );

  }

  Float16BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Float16BufferAttribute.prototype.constructor = Float16BufferAttribute;
  Float16BufferAttribute.prototype.isFloat16BufferAttribute = true;

  function Float32BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Float32Array( array ), itemSize, normalized );

  }

  Float32BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Float32BufferAttribute.prototype.constructor = Float32BufferAttribute;


  function Float64BufferAttribute( array, itemSize, normalized ) {

  	BufferAttribute.call( this, new Float64Array( array ), itemSize, normalized );

  }

  Float64BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
  Float64BufferAttribute.prototype.constructor = Float64BufferAttribute;

  function arrayMax( array ) {

  	if ( array.length === 0 ) return - Infinity;

  	let max = array[ 0 ];

  	for ( let i = 1, l = array.length; i < l; ++ i ) {

  		if ( array[ i ] > max ) max = array[ i ];

  	}

  	return max;

  }

  const TYPED_ARRAYS = {
  	Int8Array: Int8Array,
  	Uint8Array: Uint8Array,
  	// Workaround for IE11 pre KB2929437. See #11440
  	Uint8ClampedArray: typeof Uint8ClampedArray !== 'undefined' ? Uint8ClampedArray : Uint8Array,
  	Int16Array: Int16Array,
  	Uint16Array: Uint16Array,
  	Int32Array: Int32Array,
  	Uint32Array: Uint32Array,
  	Float32Array: Float32Array,
  	Float64Array: Float64Array
  };

  function getTypedArray( type, buffer ) {

  	return new TYPED_ARRAYS[ type ]( buffer );

  }

  let _id = 0;

  const _m1$2 = new Matrix4();
  const _obj = new Object3D();
  const _offset = new Vector3();
  const _box$2 = new Box3();
  const _boxMorphTargets = new Box3();
  const _vector$4 = new Vector3();

  function BufferGeometry() {

  	Object.defineProperty( this, 'id', { value: _id ++ } );

  	this.uuid = MathUtils.generateUUID();

  	this.name = '';
  	this.type = 'BufferGeometry';

  	this.index = null;
  	this.attributes = {};

  	this.morphAttributes = {};
  	this.morphTargetsRelative = false;

  	this.groups = [];

  	this.boundingBox = null;
  	this.boundingSphere = null;

  	this.drawRange = { start: 0, count: Infinity };

  	this.userData = {};

  }

  BufferGeometry.prototype = Object.assign( Object.create( EventDispatcher.prototype ), {

  	constructor: BufferGeometry,

  	isBufferGeometry: true,

  	getIndex: function () {

  		return this.index;

  	},

  	setIndex: function ( index ) {

  		if ( Array.isArray( index ) ) {

  			this.index = new ( arrayMax( index ) > 65535 ? Uint32BufferAttribute : Uint16BufferAttribute )( index, 1 );

  		} else {

  			this.index = index;

  		}

  		return this;

  	},

  	getAttribute: function ( name ) {

  		return this.attributes[ name ];

  	},

  	setAttribute: function ( name, attribute ) {

  		this.attributes[ name ] = attribute;

  		return this;

  	},

  	deleteAttribute: function ( name ) {

  		delete this.attributes[ name ];

  		return this;

  	},

  	hasAttribute: function ( name ) {

  		return this.attributes[ name ] !== undefined;

  	},

  	addGroup: function ( start, count, materialIndex = 0 ) {

  		this.groups.push( {

  			start: start,
  			count: count,
  			materialIndex: materialIndex

  		} );

  	},

  	clearGroups: function () {

  		this.groups = [];

  	},

  	setDrawRange: function ( start, count ) {

  		this.drawRange.start = start;
  		this.drawRange.count = count;

  	},

  	applyMatrix4: function ( matrix ) {

  		const position = this.attributes.position;

  		if ( position !== undefined ) {

  			position.applyMatrix4( matrix );

  			position.needsUpdate = true;

  		}

  		const normal = this.attributes.normal;

  		if ( normal !== undefined ) {

  			const normalMatrix = new Matrix3().getNormalMatrix( matrix );

  			normal.applyNormalMatrix( normalMatrix );

  			normal.needsUpdate = true;

  		}

  		const tangent = this.attributes.tangent;

  		if ( tangent !== undefined ) {

  			tangent.transformDirection( matrix );

  			tangent.needsUpdate = true;

  		}

  		if ( this.boundingBox !== null ) {

  			this.computeBoundingBox();

  		}

  		if ( this.boundingSphere !== null ) {

  			this.computeBoundingSphere();

  		}

  		return this;

  	},

  	rotateX: function ( angle ) {

  		// rotate geometry around world x-axis

  		_m1$2.makeRotationX( angle );

  		this.applyMatrix4( _m1$2 );

  		return this;

  	},

  	rotateY: function ( angle ) {

  		// rotate geometry around world y-axis

  		_m1$2.makeRotationY( angle );

  		this.applyMatrix4( _m1$2 );

  		return this;

  	},

  	rotateZ: function ( angle ) {

  		// rotate geometry around world z-axis

  		_m1$2.makeRotationZ( angle );

  		this.applyMatrix4( _m1$2 );

  		return this;

  	},

  	translate: function ( x, y, z ) {

  		// translate geometry

  		_m1$2.makeTranslation( x, y, z );

  		this.applyMatrix4( _m1$2 );

  		return this;

  	},

  	scale: function ( x, y, z ) {

  		// scale geometry

  		_m1$2.makeScale( x, y, z );

  		this.applyMatrix4( _m1$2 );

  		return this;

  	},

  	lookAt: function ( vector ) {

  		_obj.lookAt( vector );

  		_obj.updateMatrix();

  		this.applyMatrix4( _obj.matrix );

  		return this;

  	},

  	center: function () {

  		this.computeBoundingBox();

  		this.boundingBox.getCenter( _offset ).negate();

  		this.translate( _offset.x, _offset.y, _offset.z );

  		return this;

  	},

  	setFromPoints: function ( points ) {

  		const position = [];

  		for ( let i = 0, l = points.length; i < l; i ++ ) {

  			const point = points[ i ];
  			position.push( point.x, point.y, point.z || 0 );

  		}

  		this.setAttribute( 'position', new Float32BufferAttribute( position, 3 ) );

  		return this;

  	},

  	computeBoundingBox: function () {

  		if ( this.boundingBox === null ) {

  			this.boundingBox = new Box3();

  		}

  		const position = this.attributes.position;
  		const morphAttributesPosition = this.morphAttributes.position;

  		if ( position && position.isGLBufferAttribute ) {

  			console.error( 'THREE.BufferGeometry.computeBoundingBox(): GLBufferAttribute requires a manual bounding box. Alternatively set "mesh.frustumCulled" to "false".', this );

  			this.boundingBox.set(
  				new Vector3( - Infinity, - Infinity, - Infinity ),
  				new Vector3( + Infinity, + Infinity, + Infinity )
  			);

  			return;

  		}

  		if ( position !== undefined ) {

  			this.boundingBox.setFromBufferAttribute( position );

  			// process morph attributes if present

  			if ( morphAttributesPosition ) {

  				for ( let i = 0, il = morphAttributesPosition.length; i < il; i ++ ) {

  					const morphAttribute = morphAttributesPosition[ i ];
  					_box$2.setFromBufferAttribute( morphAttribute );

  					if ( this.morphTargetsRelative ) {

  						_vector$4.addVectors( this.boundingBox.min, _box$2.min );
  						this.boundingBox.expandByPoint( _vector$4 );

  						_vector$4.addVectors( this.boundingBox.max, _box$2.max );
  						this.boundingBox.expandByPoint( _vector$4 );

  					} else {

  						this.boundingBox.expandByPoint( _box$2.min );
  						this.boundingBox.expandByPoint( _box$2.max );

  					}

  				}

  			}

  		} else {

  			this.boundingBox.makeEmpty();

  		}

  		if ( isNaN( this.boundingBox.min.x ) || isNaN( this.boundingBox.min.y ) || isNaN( this.boundingBox.min.z ) ) {

  			console.error( 'THREE.BufferGeometry.computeBoundingBox(): Computed min/max have NaN values. The "position" attribute is likely to have NaN values.', this );

  		}

  	},

  	computeBoundingSphere: function () {

  		if ( this.boundingSphere === null ) {

  			this.boundingSphere = new Sphere();

  		}

  		const position = this.attributes.position;
  		const morphAttributesPosition = this.morphAttributes.position;

  		if ( position && position.isGLBufferAttribute ) {

  			console.error( 'THREE.BufferGeometry.computeBoundingSphere(): GLBufferAttribute requires a manual bounding sphere. Alternatively set "mesh.frustumCulled" to "false".', this );

  			this.boundingSphere.set( new Vector3(), Infinity );

  			return;

  		}

  		if ( position ) {

  			// first, find the center of the bounding sphere

  			const center = this.boundingSphere.center;

  			_box$2.setFromBufferAttribute( position );

  			// process morph attributes if present

  			if ( morphAttributesPosition ) {

  				for ( let i = 0, il = morphAttributesPosition.length; i < il; i ++ ) {

  					const morphAttribute = morphAttributesPosition[ i ];
  					_boxMorphTargets.setFromBufferAttribute( morphAttribute );

  					if ( this.morphTargetsRelative ) {

  						_vector$4.addVectors( _box$2.min, _boxMorphTargets.min );
  						_box$2.expandByPoint( _vector$4 );

  						_vector$4.addVectors( _box$2.max, _boxMorphTargets.max );
  						_box$2.expandByPoint( _vector$4 );

  					} else {

  						_box$2.expandByPoint( _boxMorphTargets.min );
  						_box$2.expandByPoint( _boxMorphTargets.max );

  					}

  				}

  			}

  			_box$2.getCenter( center );

  			// second, try to find a boundingSphere with a radius smaller than the
  			// boundingSphere of the boundingBox: sqrt(3) smaller in the best case

  			let maxRadiusSq = 0;

  			for ( let i = 0, il = position.count; i < il; i ++ ) {

  				_vector$4.fromBufferAttribute( position, i );

  				maxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( _vector$4 ) );

  			}

  			// process morph attributes if present

  			if ( morphAttributesPosition ) {

  				for ( let i = 0, il = morphAttributesPosition.length; i < il; i ++ ) {

  					const morphAttribute = morphAttributesPosition[ i ];
  					const morphTargetsRelative = this.morphTargetsRelative;

  					for ( let j = 0, jl = morphAttribute.count; j < jl; j ++ ) {

  						_vector$4.fromBufferAttribute( morphAttribute, j );

  						if ( morphTargetsRelative ) {

  							_offset.fromBufferAttribute( position, j );
  							_vector$4.add( _offset );

  						}

  						maxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( _vector$4 ) );

  					}

  				}

  			}

  			this.boundingSphere.radius = Math.sqrt( maxRadiusSq );

  			if ( isNaN( this.boundingSphere.radius ) ) {

  				console.error( 'THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.', this );

  			}

  		}

  	},

  	computeFaceNormals: function () {

  		// backwards compatibility

  	},

  	computeTangents: function () {

  		const index = this.index;
  		const attributes = this.attributes;

  		// based on http://www.terathon.com/code/tangent.html
  		// (per vertex tangents)

  		if ( index === null ||
  			 attributes.position === undefined ||
  			 attributes.normal === undefined ||
  			 attributes.uv === undefined ) {

  			console.error( 'THREE.BufferGeometry: .computeTangents() failed. Missing required attributes (index, position, normal or uv)' );
  			return;

  		}

  		const indices = index.array;
  		const positions = attributes.position.array;
  		const normals = attributes.normal.array;
  		const uvs = attributes.uv.array;

  		const nVertices = positions.length / 3;

  		if ( attributes.tangent === undefined ) {

  			this.setAttribute( 'tangent', new BufferAttribute( new Float32Array( 4 * nVertices ), 4 ) );

  		}

  		const tangents = attributes.tangent.array;

  		const tan1 = [], tan2 = [];

  		for ( let i = 0; i < nVertices; i ++ ) {

  			tan1[ i ] = new Vector3();
  			tan2[ i ] = new Vector3();

  		}

  		const vA = new Vector3(),
  			vB = new Vector3(),
  			vC = new Vector3(),

  			uvA = new Vector2(),
  			uvB = new Vector2(),
  			uvC = new Vector2(),

  			sdir = new Vector3(),
  			tdir = new Vector3();

  		function handleTriangle( a, b, c ) {

  			vA.fromArray( positions, a * 3 );
  			vB.fromArray( positions, b * 3 );
  			vC.fromArray( positions, c * 3 );

  			uvA.fromArray( uvs, a * 2 );
  			uvB.fromArray( uvs, b * 2 );
  			uvC.fromArray( uvs, c * 2 );

  			vB.sub( vA );
  			vC.sub( vA );

  			uvB.sub( uvA );
  			uvC.sub( uvA );

  			const r = 1.0 / ( uvB.x * uvC.y - uvC.x * uvB.y );

  			// silently ignore degenerate uv triangles having coincident or colinear vertices

  			if ( ! isFinite( r ) ) return;

  			sdir.copy( vB ).multiplyScalar( uvC.y ).addScaledVector( vC, - uvB.y ).multiplyScalar( r );
  			tdir.copy( vC ).multiplyScalar( uvB.x ).addScaledVector( vB, - uvC.x ).multiplyScalar( r );

  			tan1[ a ].add( sdir );
  			tan1[ b ].add( sdir );
  			tan1[ c ].add( sdir );

  			tan2[ a ].add( tdir );
  			tan2[ b ].add( tdir );
  			tan2[ c ].add( tdir );

  		}

  		let groups = this.groups;

  		if ( groups.length === 0 ) {

  			groups = [ {
  				start: 0,
  				count: indices.length
  			} ];

  		}

  		for ( let i = 0, il = groups.length; i < il; ++ i ) {

  			const group = groups[ i ];

  			const start = group.start;
  			const count = group.count;

  			for ( let j = start, jl = start + count; j < jl; j += 3 ) {

  				handleTriangle(
  					indices[ j + 0 ],
  					indices[ j + 1 ],
  					indices[ j + 2 ]
  				);

  			}

  		}

  		const tmp = new Vector3(), tmp2 = new Vector3();
  		const n = new Vector3(), n2 = new Vector3();

  		function handleVertex( v ) {

  			n.fromArray( normals, v * 3 );
  			n2.copy( n );

  			const t = tan1[ v ];

  			// Gram-Schmidt orthogonalize

  			tmp.copy( t );
  			tmp.sub( n.multiplyScalar( n.dot( t ) ) ).normalize();

  			// Calculate handedness

  			tmp2.crossVectors( n2, t );
  			const test = tmp2.dot( tan2[ v ] );
  			const w = ( test < 0.0 ) ? - 1.0 : 1.0;

  			tangents[ v * 4 ] = tmp.x;
  			tangents[ v * 4 + 1 ] = tmp.y;
  			tangents[ v * 4 + 2 ] = tmp.z;
  			tangents[ v * 4 + 3 ] = w;

  		}

  		for ( let i = 0, il = groups.length; i < il; ++ i ) {

  			const group = groups[ i ];

  			const start = group.start;
  			const count = group.count;

  			for ( let j = start, jl = start + count; j < jl; j += 3 ) {

  				handleVertex( indices[ j + 0 ] );
  				handleVertex( indices[ j + 1 ] );
  				handleVertex( indices[ j + 2 ] );

  			}

  		}

  	},

  	computeVertexNormals: function () {

  		const index = this.index;
  		const positionAttribute = this.getAttribute( 'position' );

  		if ( positionAttribute !== undefined ) {

  			let normalAttribute = this.getAttribute( 'normal' );

  			if ( normalAttribute === undefined ) {

  				normalAttribute = new BufferAttribute( new Float32Array( positionAttribute.count * 3 ), 3 );
  				this.setAttribute( 'normal', normalAttribute );

  			} else {

  				// reset existing normals to zero

  				for ( let i = 0, il = normalAttribute.count; i < il; i ++ ) {

  					normalAttribute.setXYZ( i, 0, 0, 0 );

  				}

  			}

  			const pA = new Vector3(), pB = new Vector3(), pC = new Vector3();
  			const nA = new Vector3(), nB = new Vector3(), nC = new Vector3();
  			const cb = new Vector3(), ab = new Vector3();

  			// indexed elements

  			if ( index ) {

  				for ( let i = 0, il = index.count; i < il; i += 3 ) {

  					const vA = index.getX( i + 0 );
  					const vB = index.getX( i + 1 );
  					const vC = index.getX( i + 2 );

  					pA.fromBufferAttribute( positionAttribute, vA );
  					pB.fromBufferAttribute( positionAttribute, vB );
  					pC.fromBufferAttribute( positionAttribute, vC );

  					cb.subVectors( pC, pB );
  					ab.subVectors( pA, pB );
  					cb.cross( ab );

  					nA.fromBufferAttribute( normalAttribute, vA );
  					nB.fromBufferAttribute( normalAttribute, vB );
  					nC.fromBufferAttribute( normalAttribute, vC );

  					nA.add( cb );
  					nB.add( cb );
  					nC.add( cb );

  					normalAttribute.setXYZ( vA, nA.x, nA.y, nA.z );
  					normalAttribute.setXYZ( vB, nB.x, nB.y, nB.z );
  					normalAttribute.setXYZ( vC, nC.x, nC.y, nC.z );

  				}

  			} else {

  				// non-indexed elements (unconnected triangle soup)

  				for ( let i = 0, il = positionAttribute.count; i < il; i += 3 ) {

  					pA.fromBufferAttribute( positionAttribute, i + 0 );
  					pB.fromBufferAttribute( positionAttribute, i + 1 );
  					pC.fromBufferAttribute( positionAttribute, i + 2 );

  					cb.subVectors( pC, pB );
  					ab.subVectors( pA, pB );
  					cb.cross( ab );

  					normalAttribute.setXYZ( i + 0, cb.x, cb.y, cb.z );
  					normalAttribute.setXYZ( i + 1, cb.x, cb.y, cb.z );
  					normalAttribute.setXYZ( i + 2, cb.x, cb.y, cb.z );

  				}

  			}

  			this.normalizeNormals();

  			normalAttribute.needsUpdate = true;

  		}

  	},

  	merge: function ( geometry, offset ) {

  		if ( ! ( geometry && geometry.isBufferGeometry ) ) {

  			console.error( 'THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.', geometry );
  			return;

  		}

  		if ( offset === undefined ) {

  			offset = 0;

  			console.warn(
  				'THREE.BufferGeometry.merge(): Overwriting original geometry, starting at offset=0. '
  				+ 'Use BufferGeometryUtils.mergeBufferGeometries() for lossless merge.'
  			);

  		}

  		const attributes = this.attributes;

  		for ( const key in attributes ) {

  			if ( geometry.attributes[ key ] === undefined ) continue;

  			const attribute1 = attributes[ key ];
  			const attributeArray1 = attribute1.array;

  			const attribute2 = geometry.attributes[ key ];
  			const attributeArray2 = attribute2.array;

  			const attributeOffset = attribute2.itemSize * offset;
  			const length = Math.min( attributeArray2.length, attributeArray1.length - attributeOffset );

  			for ( let i = 0, j = attributeOffset; i < length; i ++, j ++ ) {

  				attributeArray1[ j ] = attributeArray2[ i ];

  			}

  		}

  		return this;

  	},

  	normalizeNormals: function () {

  		const normals = this.attributes.normal;

  		for ( let i = 0, il = normals.count; i < il; i ++ ) {

  			_vector$4.fromBufferAttribute( normals, i );

  			_vector$4.normalize();

  			normals.setXYZ( i, _vector$4.x, _vector$4.y, _vector$4.z );

  		}

  	},

  	toNonIndexed: function () {

  		function convertBufferAttribute( attribute, indices ) {

  			const array = attribute.array;
  			const itemSize = attribute.itemSize;
  			const normalized = attribute.normalized;

  			const array2 = new array.constructor( indices.length * itemSize );

  			let index = 0, index2 = 0;

  			for ( let i = 0, l = indices.length; i < l; i ++ ) {

  				index = indices[ i ] * itemSize;

  				for ( let j = 0; j < itemSize; j ++ ) {

  					array2[ index2 ++ ] = array[ index ++ ];

  				}

  			}

  			return new BufferAttribute( array2, itemSize, normalized );

  		}

  		//

  		if ( this.index === null ) {

  			console.warn( 'THREE.BufferGeometry.toNonIndexed(): BufferGeometry is already non-indexed.' );
  			return this;

  		}

  		const geometry2 = new BufferGeometry();

  		const indices = this.index.array;
  		const attributes = this.attributes;

  		// attributes

  		for ( const name in attributes ) {

  			const attribute = attributes[ name ];

  			const newAttribute = convertBufferAttribute( attribute, indices );

  			geometry2.setAttribute( name, newAttribute );

  		}

  		// morph attributes

  		const morphAttributes = this.morphAttributes;

  		for ( const name in morphAttributes ) {

  			const morphArray = [];
  			const morphAttribute = morphAttributes[ name ]; // morphAttribute: array of Float32BufferAttributes

  			for ( let i = 0, il = morphAttribute.length; i < il; i ++ ) {

  				const attribute = morphAttribute[ i ];

  				const newAttribute = convertBufferAttribute( attribute, indices );

  				morphArray.push( newAttribute );

  			}

  			geometry2.morphAttributes[ name ] = morphArray;

  		}

  		geometry2.morphTargetsRelative = this.morphTargetsRelative;

  		// groups

  		const groups = this.groups;

  		for ( let i = 0, l = groups.length; i < l; i ++ ) {

  			const group = groups[ i ];
  			geometry2.addGroup( group.start, group.count, group.materialIndex );

  		}

  		return geometry2;

  	},

  	toJSON: function () {

  		const data = {
  			metadata: {
  				version: 4.5,
  				type: 'BufferGeometry',
  				generator: 'BufferGeometry.toJSON'
  			}
  		};

  		// standard BufferGeometry serialization

  		data.uuid = this.uuid;
  		data.type = this.type;
  		if ( this.name !== '' ) data.name = this.name;
  		if ( Object.keys( this.userData ).length > 0 ) data.userData = this.userData;

  		if ( this.parameters !== undefined ) {

  			const parameters = this.parameters;

  			for ( const key in parameters ) {

  				if ( parameters[ key ] !== undefined ) data[ key ] = parameters[ key ];

  			}

  			return data;

  		}

  		data.data = { attributes: {} };

  		const index = this.index;

  		if ( index !== null ) {

  			data.data.index = {
  				type: index.array.constructor.name,
  				array: Array.prototype.slice.call( index.array )
  			};

  		}

  		const attributes = this.attributes;

  		for ( const key in attributes ) {

  			const attribute = attributes[ key ];

  			const attributeData = attribute.toJSON( data.data );

  			if ( attribute.name !== '' ) attributeData.name = attribute.name;

  			data.data.attributes[ key ] = attributeData;

  		}

  		const morphAttributes = {};
  		let hasMorphAttributes = false;

  		for ( const key in this.morphAttributes ) {

  			const attributeArray = this.morphAttributes[ key ];

  			const array = [];

  			for ( let i = 0, il = attributeArray.length; i < il; i ++ ) {

  				const attribute = attributeArray[ i ];

  				const attributeData = attribute.toJSON( data.data );

  				if ( attribute.name !== '' ) attributeData.name = attribute.name;

  				array.push( attributeData );

  			}

  			if ( array.length > 0 ) {

  				morphAttributes[ key ] = array;

  				hasMorphAttributes = true;

  			}

  		}

  		if ( hasMorphAttributes ) {

  			data.data.morphAttributes = morphAttributes;
  			data.data.morphTargetsRelative = this.morphTargetsRelative;

  		}

  		const groups = this.groups;

  		if ( groups.length > 0 ) {

  			data.data.groups = JSON.parse( JSON.stringify( groups ) );

  		}

  		const boundingSphere = this.boundingSphere;

  		if ( boundingSphere !== null ) {

  			data.data.boundingSphere = {
  				center: boundingSphere.center.toArray(),
  				radius: boundingSphere.radius
  			};

  		}

  		return data;

  	},

  	clone: function () {

  		/*
  		 // Handle primitives

  		 const parameters = this.parameters;

  		 if ( parameters !== undefined ) {

  		 const values = [];

  		 for ( const key in parameters ) {

  		 values.push( parameters[ key ] );

  		 }

  		 const geometry = Object.create( this.constructor.prototype );
  		 this.constructor.apply( geometry, values );
  		 return geometry;

  		 }

  		 return new this.constructor().copy( this );
  		 */

  		return new BufferGeometry().copy( this );

  	},

  	copy: function ( source ) {

  		// reset

  		this.index = null;
  		this.attributes = {};
  		this.morphAttributes = {};
  		this.groups = [];
  		this.boundingBox = null;
  		this.boundingSphere = null;

  		// used for storing cloned, shared data

  		const data = {};

  		// name

  		this.name = source.name;

  		// index

  		const index = source.index;

  		if ( index !== null ) {

  			this.setIndex( index.clone( data ) );

  		}

  		// attributes

  		const attributes = source.attributes;

  		for ( const name in attributes ) {

  			const attribute = attributes[ name ];
  			this.setAttribute( name, attribute.clone( data ) );

  		}

  		// morph attributes

  		const morphAttributes = source.morphAttributes;

  		for ( const name in morphAttributes ) {

  			const array = [];
  			const morphAttribute = morphAttributes[ name ]; // morphAttribute: array of Float32BufferAttributes

  			for ( let i = 0, l = morphAttribute.length; i < l; i ++ ) {

  				array.push( morphAttribute[ i ].clone( data ) );

  			}

  			this.morphAttributes[ name ] = array;

  		}

  		this.morphTargetsRelative = source.morphTargetsRelative;

  		// groups

  		const groups = source.groups;

  		for ( let i = 0, l = groups.length; i < l; i ++ ) {

  			const group = groups[ i ];
  			this.addGroup( group.start, group.count, group.materialIndex );

  		}

  		// bounding box

  		const boundingBox = source.boundingBox;

  		if ( boundingBox !== null ) {

  			this.boundingBox = boundingBox.clone();

  		}

  		// bounding sphere

  		const boundingSphere = source.boundingSphere;

  		if ( boundingSphere !== null ) {

  			this.boundingSphere = boundingSphere.clone();

  		}

  		// draw range

  		this.drawRange.start = source.drawRange.start;
  		this.drawRange.count = source.drawRange.count;

  		// user data

  		this.userData = source.userData;

  		return this;

  	},

  	dispose: function () {

  		this.dispatchEvent( { type: 'dispose' } );

  	}

  } );

  const _inverseMatrix = new Matrix4();
  const _ray = new Ray();
  const _sphere = new Sphere();

  const _vA = new Vector3();
  const _vB = new Vector3();
  const _vC = new Vector3();

  const _tempA = new Vector3();
  const _tempB = new Vector3();
  const _tempC = new Vector3();

  const _morphA = new Vector3();
  const _morphB = new Vector3();
  const _morphC = new Vector3();

  const _uvA = new Vector2();
  const _uvB = new Vector2();
  const _uvC = new Vector2();

  const _intersectionPoint = new Vector3();
  const _intersectionPointWorld = new Vector3();

  function Mesh( geometry = new BufferGeometry(), material = new MeshBasicMaterial() ) {

  	Object3D.call( this );

  	this.type = 'Mesh';

  	this.geometry = geometry;
  	this.material = material;

  	this.updateMorphTargets();

  }

  Mesh.prototype = Object.assign( Object.create( Object3D.prototype ), {

  	constructor: Mesh,

  	isMesh: true,

  	copy: function ( source ) {

  		Object3D.prototype.copy.call( this, source );

  		if ( source.morphTargetInfluences !== undefined ) {

  			this.morphTargetInfluences = source.morphTargetInfluences.slice();

  		}

  		if ( source.morphTargetDictionary !== undefined ) {

  			this.morphTargetDictionary = Object.assign( {}, source.morphTargetDictionary );

  		}

  		this.material = source.material;
  		this.geometry = source.geometry;

  		return this;

  	},

  	updateMorphTargets: function () {

  		const geometry = this.geometry;

  		if ( geometry.isBufferGeometry ) {

  			const morphAttributes = geometry.morphAttributes;
  			const keys = Object.keys( morphAttributes );

  			if ( keys.length > 0 ) {

  				const morphAttribute = morphAttributes[ keys[ 0 ] ];

  				if ( morphAttribute !== undefined ) {

  					this.morphTargetInfluences = [];
  					this.morphTargetDictionary = {};

  					for ( let m = 0, ml = morphAttribute.length; m < ml; m ++ ) {

  						const name = morphAttribute[ m ].name || String( m );

  						this.morphTargetInfluences.push( 0 );
  						this.morphTargetDictionary[ name ] = m;

  					}

  				}

  			}

  		} else {

  			const morphTargets = geometry.morphTargets;

  			if ( morphTargets !== undefined && morphTargets.length > 0 ) {

  				console.error( 'THREE.Mesh.updateMorphTargets() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.' );

  			}

  		}

  	},

  	raycast: function ( raycaster, intersects ) {

  		const geometry = this.geometry;
  		const material = this.material;
  		const matrixWorld = this.matrixWorld;

  		if ( material === undefined ) return;

  		// Checking boundingSphere distance to ray

  		if ( geometry.boundingSphere === null ) geometry.computeBoundingSphere();

  		_sphere.copy( geometry.boundingSphere );
  		_sphere.applyMatrix4( matrixWorld );

  		if ( raycaster.ray.intersectsSphere( _sphere ) === false ) return;

  		//

  		_inverseMatrix.copy( matrixWorld ).invert();
  		_ray.copy( raycaster.ray ).applyMatrix4( _inverseMatrix );

  		// Check boundingBox before continuing

  		if ( geometry.boundingBox !== null ) {

  			if ( _ray.intersectsBox( geometry.boundingBox ) === false ) return;

  		}

  		let intersection;

  		if ( geometry.isBufferGeometry ) {

  			const index = geometry.index;
  			const position = geometry.attributes.position;
  			const morphPosition = geometry.morphAttributes.position;
  			const morphTargetsRelative = geometry.morphTargetsRelative;
  			const uv = geometry.attributes.uv;
  			const uv2 = geometry.attributes.uv2;
  			const groups = geometry.groups;
  			const drawRange = geometry.drawRange;

  			if ( index !== null ) {

  				// indexed buffer geometry

  				if ( Array.isArray( material ) ) {

  					for ( let i = 0, il = groups.length; i < il; i ++ ) {

  						const group = groups[ i ];
  						const groupMaterial = material[ group.materialIndex ];

  						const start = Math.max( group.start, drawRange.start );
  						const end = Math.min( ( group.start + group.count ), ( drawRange.start + drawRange.count ) );

  						for ( let j = start, jl = end; j < jl; j += 3 ) {

  							const a = index.getX( j );
  							const b = index.getX( j + 1 );
  							const c = index.getX( j + 2 );

  							intersection = checkBufferGeometryIntersection( this, groupMaterial, raycaster, _ray, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );

  							if ( intersection ) {

  								intersection.faceIndex = Math.floor( j / 3 ); // triangle number in indexed buffer semantics
  								intersection.face.materialIndex = group.materialIndex;
  								intersects.push( intersection );

  							}

  						}

  					}

  				} else {

  					const start = Math.max( 0, drawRange.start );
  					const end = Math.min( index.count, ( drawRange.start + drawRange.count ) );

  					for ( let i = start, il = end; i < il; i += 3 ) {

  						const a = index.getX( i );
  						const b = index.getX( i + 1 );
  						const c = index.getX( i + 2 );

  						intersection = checkBufferGeometryIntersection( this, material, raycaster, _ray, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );

  						if ( intersection ) {

  							intersection.faceIndex = Math.floor( i / 3 ); // triangle number in indexed buffer semantics
  							intersects.push( intersection );

  						}

  					}

  				}

  			} else if ( position !== undefined ) {

  				// non-indexed buffer geometry

  				if ( Array.isArray( material ) ) {

  					for ( let i = 0, il = groups.length; i < il; i ++ ) {

  						const group = groups[ i ];
  						const groupMaterial = material[ group.materialIndex ];

  						const start = Math.max( group.start, drawRange.start );
  						const end = Math.min( ( group.start + group.count ), ( drawRange.start + drawRange.count ) );

  						for ( let j = start, jl = end; j < jl; j += 3 ) {

  							const a = j;
  							const b = j + 1;
  							const c = j + 2;

  							intersection = checkBufferGeometryIntersection( this, groupMaterial, raycaster, _ray, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );

  							if ( intersection ) {

  								intersection.faceIndex = Math.floor( j / 3 ); // triangle number in non-indexed buffer semantics
  								intersection.face.materialIndex = group.materialIndex;
  								intersects.push( intersection );

  							}

  						}

  					}

  				} else {

  					const start = Math.max( 0, drawRange.start );
  					const end = Math.min( position.count, ( drawRange.start + drawRange.count ) );

  					for ( let i = start, il = end; i < il; i += 3 ) {

  						const a = i;
  						const b = i + 1;
  						const c = i + 2;

  						intersection = checkBufferGeometryIntersection( this, material, raycaster, _ray, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );

  						if ( intersection ) {

  							intersection.faceIndex = Math.floor( i / 3 ); // triangle number in non-indexed buffer semantics
  							intersects.push( intersection );

  						}

  					}

  				}

  			}

  		} else if ( geometry.isGeometry ) {

  			console.error( 'THREE.Mesh.raycast() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.' );

  		}

  	}

  } );

  function checkIntersection( object, material, raycaster, ray, pA, pB, pC, point ) {

  	let intersect;

  	if ( material.side === BackSide ) {

  		intersect = ray.intersectTriangle( pC, pB, pA, true, point );

  	} else {

  		intersect = ray.intersectTriangle( pA, pB, pC, material.side !== DoubleSide, point );

  	}

  	if ( intersect === null ) return null;

  	_intersectionPointWorld.copy( point );
  	_intersectionPointWorld.applyMatrix4( object.matrixWorld );

  	const distance = raycaster.ray.origin.distanceTo( _intersectionPointWorld );

  	if ( distance < raycaster.near || distance > raycaster.far ) return null;

  	return {
  		distance: distance,
  		point: _intersectionPointWorld.clone(),
  		object: object
  	};

  }

  function checkBufferGeometryIntersection( object, material, raycaster, ray, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c ) {

  	_vA.fromBufferAttribute( position, a );
  	_vB.fromBufferAttribute( position, b );
  	_vC.fromBufferAttribute( position, c );

  	const morphInfluences = object.morphTargetInfluences;

  	if ( material.morphTargets && morphPosition && morphInfluences ) {

  		_morphA.set( 0, 0, 0 );
  		_morphB.set( 0, 0, 0 );
  		_morphC.set( 0, 0, 0 );

  		for ( let i = 0, il = morphPosition.length; i < il; i ++ ) {

  			const influence = morphInfluences[ i ];
  			const morphAttribute = morphPosition[ i ];

  			if ( influence === 0 ) continue;

  			_tempA.fromBufferAttribute( morphAttribute, a );
  			_tempB.fromBufferAttribute( morphAttribute, b );
  			_tempC.fromBufferAttribute( morphAttribute, c );

  			if ( morphTargetsRelative ) {

  				_morphA.addScaledVector( _tempA, influence );
  				_morphB.addScaledVector( _tempB, influence );
  				_morphC.addScaledVector( _tempC, influence );

  			} else {

  				_morphA.addScaledVector( _tempA.sub( _vA ), influence );
  				_morphB.addScaledVector( _tempB.sub( _vB ), influence );
  				_morphC.addScaledVector( _tempC.sub( _vC ), influence );

  			}

  		}

  		_vA.add( _morphA );
  		_vB.add( _morphB );
  		_vC.add( _morphC );

  	}

  	if ( object.isSkinnedMesh ) {

  		object.boneTransform( a, _vA );
  		object.boneTransform( b, _vB );
  		object.boneTransform( c, _vC );

  	}

  	const intersection = checkIntersection( object, material, raycaster, ray, _vA, _vB, _vC, _intersectionPoint );

  	if ( intersection ) {

  		if ( uv ) {

  			_uvA.fromBufferAttribute( uv, a );
  			_uvB.fromBufferAttribute( uv, b );
  			_uvC.fromBufferAttribute( uv, c );

  			intersection.uv = Triangle.getUV( _intersectionPoint, _vA, _vB, _vC, _uvA, _uvB, _uvC, new Vector2() );

  		}

  		if ( uv2 ) {

  			_uvA.fromBufferAttribute( uv2, a );
  			_uvB.fromBufferAttribute( uv2, b );
  			_uvC.fromBufferAttribute( uv2, c );

  			intersection.uv2 = Triangle.getUV( _intersectionPoint, _vA, _vB, _vC, _uvA, _uvB, _uvC, new Vector2() );

  		}

  		const face = new Face3( a, b, c );
  		Triangle.getNormal( _vA, _vB, _vC, face.normal );

  		intersection.face = face;

  	}

  	return intersection;

  }

  class BoxGeometry extends BufferGeometry {

  	constructor( width = 1, height = 1, depth = 1, widthSegments = 1, heightSegments = 1, depthSegments = 1 ) {

  		super();

  		this.type = 'BoxGeometry';

  		this.parameters = {
  			width: width,
  			height: height,
  			depth: depth,
  			widthSegments: widthSegments,
  			heightSegments: heightSegments,
  			depthSegments: depthSegments
  		};

  		const scope = this;

  		// segments

  		widthSegments = Math.floor( widthSegments );
  		heightSegments = Math.floor( heightSegments );
  		depthSegments = Math.floor( depthSegments );

  		// buffers

  		const indices = [];
  		const vertices = [];
  		const normals = [];
  		const uvs = [];

  		// helper variables

  		let numberOfVertices = 0;
  		let groupStart = 0;

  		// build each side of the box geometry

  		buildPlane( 'z', 'y', 'x', - 1, - 1, depth, height, width, depthSegments, heightSegments, 0 ); // px
  		buildPlane( 'z', 'y', 'x', 1, - 1, depth, height, - width, depthSegments, heightSegments, 1 ); // nx
  		buildPlane( 'x', 'z', 'y', 1, 1, width, depth, height, widthSegments, depthSegments, 2 ); // py
  		buildPlane( 'x', 'z', 'y', 1, - 1, width, depth, - height, widthSegments, depthSegments, 3 ); // ny
  		buildPlane( 'x', 'y', 'z', 1, - 1, width, height, depth, widthSegments, heightSegments, 4 ); // pz
  		buildPlane( 'x', 'y', 'z', - 1, - 1, width, height, - depth, widthSegments, heightSegments, 5 ); // nz

  		// build geometry

  		this.setIndex( indices );
  		this.setAttribute( 'position', new Float32BufferAttribute( vertices, 3 ) );
  		this.setAttribute( 'normal', new Float32BufferAttribute( normals, 3 ) );
  		this.setAttribute( 'uv', new Float32BufferAttribute( uvs, 2 ) );

  		function buildPlane( u, v, w, udir, vdir, width, height, depth, gridX, gridY, materialIndex ) {

  			const segmentWidth = width / gridX;
  			const segmentHeight = height / gridY;

  			const widthHalf = width / 2;
  			const heightHalf = height / 2;
  			const depthHalf = depth / 2;

  			const gridX1 = gridX + 1;
  			const gridY1 = gridY + 1;

  			let vertexCounter = 0;
  			let groupCount = 0;

  			const vector = new Vector3();

  			// generate vertices, normals and uvs

  			for ( let iy = 0; iy < gridY1; iy ++ ) {

  				const y = iy * segmentHeight - heightHalf;

  				for ( let ix = 0; ix < gridX1; ix ++ ) {

  					const x = ix * segmentWidth - widthHalf;

  					// set values to correct vector component

  					vector[ u ] = x * udir;
  					vector[ v ] = y * vdir;
  					vector[ w ] = depthHalf;

  					// now apply vector to vertex buffer

  					vertices.push( vector.x, vector.y, vector.z );

  					// set values to correct vector component

  					vector[ u ] = 0;
  					vector[ v ] = 0;
  					vector[ w ] = depth > 0 ? 1 : - 1;

  					// now apply vector to normal buffer

  					normals.push( vector.x, vector.y, vector.z );

  					// uvs

  					uvs.push( ix / gridX );
  					uvs.push( 1 - ( iy / gridY ) );

  					// counters

  					vertexCounter += 1;

  				}

  			}

  			// indices

  			// 1. you need three indices to draw a single face
  			// 2. a single segment consists of two faces
  			// 3. so we need to generate six (2*3) indices per segment

  			for ( let iy = 0; iy < gridY; iy ++ ) {

  				for ( let ix = 0; ix < gridX; ix ++ ) {

  					const a = numberOfVertices + ix + gridX1 * iy;
  					const b = numberOfVertices + ix + gridX1 * ( iy + 1 );
  					const c = numberOfVertices + ( ix + 1 ) + gridX1 * ( iy + 1 );
  					const d = numberOfVertices + ( ix + 1 ) + gridX1 * iy;

  					// faces

  					indices.push( a, b, d );
  					indices.push( b, c, d );

  					// increase counter

  					groupCount += 6;

  				}

  			}

  			// add a group to the geometry. this will ensure multi material support

  			scope.addGroup( groupStart, groupCount, materialIndex );

  			// calculate new start value for groups

  			groupStart += groupCount;

  			// update total number of vertices

  			numberOfVertices += vertexCounter;

  		}

  	}

  }

  /**
   * Uniform Utilities
   */

  function cloneUniforms( src ) {

  	const dst = {};

  	for ( const u in src ) {

  		dst[ u ] = {};

  		for ( const p in src[ u ] ) {

  			const property = src[ u ][ p ];

  			if ( property && ( property.isColor ||
  				property.isMatrix3 || property.isMatrix4 ||
  				property.isVector2 || property.isVector3 || property.isVector4 ||
  				property.isTexture ) ) {

  				dst[ u ][ p ] = property.clone();

  			} else if ( Array.isArray( property ) ) {

  				dst[ u ][ p ] = property.slice();

  			} else {

  				dst[ u ][ p ] = property;

  			}

  		}

  	}

  	return dst;

  }

  function mergeUniforms( uniforms ) {

  	const merged = {};

  	for ( let u = 0; u < uniforms.length; u ++ ) {

  		const tmp = cloneUniforms( uniforms[ u ] );

  		for ( const p in tmp ) {

  			merged[ p ] = tmp[ p ];

  		}

  	}

  	return merged;

  }

  // Legacy

  const UniformsUtils = { clone: cloneUniforms, merge: mergeUniforms };

  var default_vertex = "void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}";

  var default_fragment = "void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}";

  /**
   * parameters = {
   *  defines: { "label" : "value" },
   *  uniforms: { "parameter1": { value: 1.0 }, "parameter2": { value2: 2 } },
   *
   *  fragmentShader: <string>,
   *  vertexShader: <string>,
   *
   *  wireframe: <boolean>,
   *  wireframeLinewidth: <float>,
   *
   *  lights: <bool>,
   *
   *  skinning: <bool>,
   *  morphTargets: <bool>,
   *  morphNormals: <bool>
   * }
   */

  function ShaderMaterial( parameters ) {

  	Material.call( this );

  	this.type = 'ShaderMaterial';

  	this.defines = {};
  	this.uniforms = {};

  	this.vertexShader = default_vertex;
  	this.fragmentShader = default_fragment;

  	this.linewidth = 1;

  	this.wireframe = false;
  	this.wireframeLinewidth = 1;

  	this.fog = false; // set to use scene fog
  	this.lights = false; // set to use scene lights
  	this.clipping = false; // set to use user-defined clipping planes

  	this.skinning = false; // set to use skinning attribute streams
  	this.morphTargets = false; // set to use morph targets
  	this.morphNormals = false; // set to use morph normals

  	this.extensions = {
  		derivatives: false, // set to use derivatives
  		fragDepth: false, // set to use fragment depth values
  		drawBuffers: false, // set to use draw buffers
  		shaderTextureLOD: false // set to use shader texture LOD
  	};

  	// When rendered geometry doesn't include these attributes but the material does,
  	// use these default values in WebGL. This avoids errors when buffer data is missing.
  	this.defaultAttributeValues = {
  		'color': [ 1, 1, 1 ],
  		'uv': [ 0, 0 ],
  		'uv2': [ 0, 0 ]
  	};

  	this.index0AttributeName = undefined;
  	this.uniformsNeedUpdate = false;

  	this.glslVersion = null;

  	if ( parameters !== undefined ) {

  		if ( parameters.attributes !== undefined ) {

  			console.error( 'THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead.' );

  		}

  		this.setValues( parameters );

  	}

  }

  ShaderMaterial.prototype = Object.create( Material.prototype );
  ShaderMaterial.prototype.constructor = ShaderMaterial;

  ShaderMaterial.prototype.isShaderMaterial = true;

  ShaderMaterial.prototype.copy = function ( source ) {

  	Material.prototype.copy.call( this, source );

  	this.fragmentShader = source.fragmentShader;
  	this.vertexShader = source.vertexShader;

  	this.uniforms = cloneUniforms( source.uniforms );

  	this.defines = Object.assign( {}, source.defines );

  	this.wireframe = source.wireframe;
  	this.wireframeLinewidth = source.wireframeLinewidth;

  	this.lights = source.lights;
  	this.clipping = source.clipping;

  	this.skinning = source.skinning;

  	this.morphTargets = source.morphTargets;
  	this.morphNormals = source.morphNormals;

  	this.extensions = Object.assign( {}, source.extensions );

  	this.glslVersion = source.glslVersion;

  	return this;

  };

  ShaderMaterial.prototype.toJSON = function ( meta ) {

  	const data = Material.prototype.toJSON.call( this, meta );

  	data.glslVersion = this.glslVersion;
  	data.uniforms = {};

  	for ( const name in this.uniforms ) {

  		const uniform = this.uniforms[ name ];
  		const value = uniform.value;

  		if ( value && value.isTexture ) {

  			data.uniforms[ name ] = {
  				type: 't',
  				value: value.toJSON( meta ).uuid
  			};

  		} else if ( value && value.isColor ) {

  			data.uniforms[ name ] = {
  				type: 'c',
  				value: value.getHex()
  			};

  		} else if ( value && value.isVector2 ) {

  			data.uniforms[ name ] = {
  				type: 'v2',
  				value: value.toArray()
  			};

  		} else if ( value && value.isVector3 ) {

  			data.uniforms[ name ] = {
  				type: 'v3',
  				value: value.toArray()
  			};

  		} else if ( value && value.isVector4 ) {

  			data.uniforms[ name ] = {
  				type: 'v4',
  				value: value.toArray()
  			};

  		} else if ( value && value.isMatrix3 ) {

  			data.uniforms[ name ] = {
  				type: 'm3',
  				value: value.toArray()
  			};

  		} else if ( value && value.isMatrix4 ) {

  			data.uniforms[ name ] = {
  				type: 'm4',
  				value: value.toArray()
  			};

  		} else {

  			data.uniforms[ name ] = {
  				value: value
  			};

  			// note: the array variants v2v, v3v, v4v, m4v and tv are not supported so far

  		}

  	}

  	if ( Object.keys( this.defines ).length > 0 ) data.defines = this.defines;

  	data.vertexShader = this.vertexShader;
  	data.fragmentShader = this.fragmentShader;

  	const extensions = {};

  	for ( const key in this.extensions ) {

  		if ( this.extensions[ key ] === true ) extensions[ key ] = true;

  	}

  	if ( Object.keys( extensions ).length > 0 ) data.extensions = extensions;

  	return data;

  };

  function Camera() {

  	Object3D.call( this );

  	this.type = 'Camera';

  	this.matrixWorldInverse = new Matrix4();

  	this.projectionMatrix = new Matrix4();
  	this.projectionMatrixInverse = new Matrix4();

  }

  Camera.prototype = Object.assign( Object.create( Object3D.prototype ), {

  	constructor: Camera,

  	isCamera: true,

  	copy: function ( source, recursive ) {

  		Object3D.prototype.copy.call( this, source, recursive );

  		this.matrixWorldInverse.copy( source.matrixWorldInverse );

  		this.projectionMatrix.copy( source.projectionMatrix );
  		this.projectionMatrixInverse.copy( source.projectionMatrixInverse );

  		return this;

  	},

  	getWorldDirection: function ( target ) {

  		if ( target === undefined ) {

  			console.warn( 'THREE.Camera: .getWorldDirection() target is now required' );
  			target = new Vector3();

  		}

  		this.updateWorldMatrix( true, false );

  		const e = this.matrixWorld.elements;

  		return target.set( - e[ 8 ], - e[ 9 ], - e[ 10 ] ).normalize();

  	},

  	updateMatrixWorld: function ( force ) {

  		Object3D.prototype.updateMatrixWorld.call( this, force );

  		this.matrixWorldInverse.copy( this.matrixWorld ).invert();

  	},

  	updateWorldMatrix: function ( updateParents, updateChildren ) {

  		Object3D.prototype.updateWorldMatrix.call( this, updateParents, updateChildren );

  		this.matrixWorldInverse.copy( this.matrixWorld ).invert();

  	},

  	clone: function () {

  		return new this.constructor().copy( this );

  	}

  } );

  function PerspectiveCamera( fov = 50, aspect = 1, near = 0.1, far = 2000 ) {

  	Camera.call( this );

  	this.type = 'PerspectiveCamera';

  	this.fov = fov;
  	this.zoom = 1;

  	this.near = near;
  	this.far = far;
  	this.focus = 10;

  	this.aspect = aspect;
  	this.view = null;

  	this.filmGauge = 35;	// width of the film (default in millimeters)
  	this.filmOffset = 0;	// horizontal film offset (same unit as gauge)

  	this.updateProjectionMatrix();

  }

  PerspectiveCamera.prototype = Object.assign( Object.create( Camera.prototype ), {

  	constructor: PerspectiveCamera,

  	isPerspectiveCamera: true,

  	copy: function ( source, recursive ) {

  		Camera.prototype.copy.call( this, source, recursive );

  		this.fov = source.fov;
  		this.zoom = source.zoom;

  		this.near = source.near;
  		this.far = source.far;
  		this.focus = source.focus;

  		this.aspect = source.aspect;
  		this.view = source.view === null ? null : Object.assign( {}, source.view );

  		this.filmGauge = source.filmGauge;
  		this.filmOffset = source.filmOffset;

  		return this;

  	},

  	/**
  	 * Sets the FOV by focal length in respect to the current .filmGauge.
  	 *
  	 * The default film gauge is 35, so that the focal length can be specified for
  	 * a 35mm (full frame) camera.
  	 *
  	 * Values for focal length and film gauge must have the same unit.
  	 */
  	setFocalLength: function ( focalLength ) {

  		/** see {@link http://www.bobatkins.com/photography/technical/field_of_view.html} */
  		const vExtentSlope = 0.5 * this.getFilmHeight() / focalLength;

  		this.fov = MathUtils.RAD2DEG * 2 * Math.atan( vExtentSlope );
  		this.updateProjectionMatrix();

  	},

  	/**
  	 * Calculates the focal length from the current .fov and .filmGauge.
  	 */
  	getFocalLength: function () {

  		const vExtentSlope = Math.tan( MathUtils.DEG2RAD * 0.5 * this.fov );

  		return 0.5 * this.getFilmHeight() / vExtentSlope;

  	},

  	getEffectiveFOV: function () {

  		return MathUtils.RAD2DEG * 2 * Math.atan(
  			Math.tan( MathUtils.DEG2RAD * 0.5 * this.fov ) / this.zoom );

  	},

  	getFilmWidth: function () {

  		// film not completely covered in portrait format (aspect < 1)
  		return this.filmGauge * Math.min( this.aspect, 1 );

  	},

  	getFilmHeight: function () {

  		// film not completely covered in landscape format (aspect > 1)
  		return this.filmGauge / Math.max( this.aspect, 1 );

  	},

  	/**
  	 * Sets an offset in a larger frustum. This is useful for multi-window or
  	 * multi-monitor/multi-machine setups.
  	 *
  	 * For example, if you have 3x2 monitors and each monitor is 1920x1080 and
  	 * the monitors are in grid like this
  	 *
  	 *   +---+---+---+
  	 *   | A | B | C |
  	 *   +---+---+---+
  	 *   | D | E | F |
  	 *   +---+---+---+
  	 *
  	 * then for each monitor you would call it like this
  	 *
  	 *   const w = 1920;
  	 *   const h = 1080;
  	 *   const fullWidth = w * 3;
  	 *   const fullHeight = h * 2;
  	 *
  	 *   --A--
  	 *   camera.setViewOffset( fullWidth, fullHeight, w * 0, h * 0, w, h );
  	 *   --B--
  	 *   camera.setViewOffset( fullWidth, fullHeight, w * 1, h * 0, w, h );
  	 *   --C--
  	 *   camera.setViewOffset( fullWidth, fullHeight, w * 2, h * 0, w, h );
  	 *   --D--
  	 *   camera.setViewOffset( fullWidth, fullHeight, w * 0, h * 1, w, h );
  	 *   --E--
  	 *   camera.setViewOffset( fullWidth, fullHeight, w * 1, h * 1, w, h );
  	 *   --F--
  	 *   camera.setViewOffset( fullWidth, fullHeight, w * 2, h * 1, w, h );
  	 *
  	 *   Note there is no reason monitors have to be the same size or in a grid.
  	 */
  	setViewOffset: function ( fullWidth, fullHeight, x, y, width, height ) {

  		this.aspect = fullWidth / fullHeight;

  		if ( this.view === null ) {

  			this.view = {
  				enabled: true,
  				fullWidth: 1,
  				fullHeight: 1,
  				offsetX: 0,
  				offsetY: 0,
  				width: 1,
  				height: 1
  			};

  		}

  		this.view.enabled = true;
  		this.view.fullWidth = fullWidth;
  		this.view.fullHeight = fullHeight;
  		this.view.offsetX = x;
  		this.view.offsetY = y;
  		this.view.width = width;
  		this.view.height = height;

  		this.updateProjectionMatrix();

  	},

  	clearViewOffset: function () {

  		if ( this.view !== null ) {

  			this.view.enabled = false;

  		}

  		this.updateProjectionMatrix();

  	},

  	updateProjectionMatrix: function () {

  		const near = this.near;
  		let top = near * Math.tan( MathUtils.DEG2RAD * 0.5 * this.fov ) / this.zoom;
  		let height = 2 * top;
  		let width = this.aspect * height;
  		let left = - 0.5 * width;
  		const view = this.view;

  		if ( this.view !== null && this.view.enabled ) {

  			const fullWidth = view.fullWidth,
  				fullHeight = view.fullHeight;

  			left += view.offsetX * width / fullWidth;
  			top -= view.offsetY * height / fullHeight;
  			width *= view.width / fullWidth;
  			height *= view.height / fullHeight;

  		}

  		const skew = this.filmOffset;
  		if ( skew !== 0 ) left += near * skew / this.getFilmWidth();

  		this.projectionMatrix.makePerspective( left, left + width, top, top - height, near, this.far );

  		this.projectionMatrixInverse.copy( this.projectionMatrix ).invert();

  	},

  	toJSON: function ( meta ) {

  		const data = Object3D.prototype.toJSON.call( this, meta );

  		data.object.fov = this.fov;
  		data.object.zoom = this.zoom;

  		data.object.near = this.near;
  		data.object.far = this.far;
  		data.object.focus = this.focus;

  		data.object.aspect = this.aspect;

  		if ( this.view !== null ) data.object.view = Object.assign( {}, this.view );

  		data.object.filmGauge = this.filmGauge;
  		data.object.filmOffset = this.filmOffset;

  		return data;

  	}

  } );

  const fov = 90, aspect = 1;

  function CubeCamera( near, far, renderTarget ) {

  	Object3D.call( this );

  	this.type = 'CubeCamera';

  	if ( renderTarget.isWebGLCubeRenderTarget !== true ) {

  		console.error( 'THREE.CubeCamera: The constructor now expects an instance of WebGLCubeRenderTarget as third parameter.' );
  		return;

  	}

  	this.renderTarget = renderTarget;

  	const cameraPX = new PerspectiveCamera( fov, aspect, near, far );
  	cameraPX.layers = this.layers;
  	cameraPX.up.set( 0, - 1, 0 );
  	cameraPX.lookAt( new Vector3( 1, 0, 0 ) );
  	this.add( cameraPX );

  	const cameraNX = new PerspectiveCamera( fov, aspect, near, far );
  	cameraNX.layers = this.layers;
  	cameraNX.up.set( 0, - 1, 0 );
  	cameraNX.lookAt( new Vector3( - 1, 0, 0 ) );
  	this.add( cameraNX );

  	const cameraPY = new PerspectiveCamera( fov, aspect, near, far );
  	cameraPY.layers = this.layers;
  	cameraPY.up.set( 0, 0, 1 );
  	cameraPY.lookAt( new Vector3( 0, 1, 0 ) );
  	this.add( cameraPY );

  	const cameraNY = new PerspectiveCamera( fov, aspect, near, far );
  	cameraNY.layers = this.layers;
  	cameraNY.up.set( 0, 0, - 1 );
  	cameraNY.lookAt( new Vector3( 0, - 1, 0 ) );
  	this.add( cameraNY );

  	const cameraPZ = new PerspectiveCamera( fov, aspect, near, far );
  	cameraPZ.layers = this.layers;
  	cameraPZ.up.set( 0, - 1, 0 );
  	cameraPZ.lookAt( new Vector3( 0, 0, 1 ) );
  	this.add( cameraPZ );

  	const cameraNZ = new PerspectiveCamera( fov, aspect, near, far );
  	cameraNZ.layers = this.layers;
  	cameraNZ.up.set( 0, - 1, 0 );
  	cameraNZ.lookAt( new Vector3( 0, 0, - 1 ) );
  	this.add( cameraNZ );

  	this.update = function ( renderer, scene ) {

  		if ( this.parent === null ) this.updateMatrixWorld();

  		const currentXrEnabled = renderer.xr.enabled;
  		const currentRenderTarget = renderer.getRenderTarget();

  		renderer.xr.enabled = false;

  		const generateMipmaps = renderTarget.texture.generateMipmaps;

  		renderTarget.texture.generateMipmaps = false;

  		renderer.setRenderTarget( renderTarget, 0 );
  		renderer.render( scene, cameraPX );

  		renderer.setRenderTarget( renderTarget, 1 );
  		renderer.render( scene, cameraNX );

  		renderer.setRenderTarget( renderTarget, 2 );
  		renderer.render( scene, cameraPY );

  		renderer.setRenderTarget( renderTarget, 3 );
  		renderer.render( scene, cameraNY );

  		renderer.setRenderTarget( renderTarget, 4 );
  		renderer.render( scene, cameraPZ );

  		renderTarget.texture.generateMipmaps = generateMipmaps;

  		renderer.setRenderTarget( renderTarget, 5 );
  		renderer.render( scene, cameraNZ );

  		renderer.setRenderTarget( currentRenderTarget );

  		renderer.xr.enabled = currentXrEnabled;

  	};

  }

  CubeCamera.prototype = Object.create( Object3D.prototype );
  CubeCamera.prototype.constructor = CubeCamera;

  function CubeTexture( images, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding ) {

  	images = images !== undefined ? images : [];
  	mapping = mapping !== undefined ? mapping : CubeReflectionMapping;
  	format = format !== undefined ? format : RGBFormat;

  	Texture.call( this, images, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding );

  	this.flipY = false;

  	// Why CubeTexture._needsFlipEnvMap is necessary:
  	//
  	// By convention -- likely based on the RenderMan spec from the 1990's -- cube maps are specified by WebGL (and three.js)
  	// in a coordinate system in which positive-x is to the right when looking up the positive-z axis -- in other words,
  	// in a left-handed coordinate system. By continuing this convention, preexisting cube maps continued to render correctly.

  	// three.js uses a right-handed coordinate system. So environment maps used in three.js appear to have px and nx swapped
  	// and the flag _needsFlipEnvMap controls this conversion. The flip is not required (and thus _needsFlipEnvMap is set to false)
  	// when using WebGLCubeRenderTarget.texture as a cube texture.

  	this._needsFlipEnvMap = true;

  }

  CubeTexture.prototype = Object.create( Texture.prototype );
  CubeTexture.prototype.constructor = CubeTexture;

  CubeTexture.prototype.isCubeTexture = true;

  Object.defineProperty( CubeTexture.prototype, 'images', {

  	get: function () {

  		return this.image;

  	},

  	set: function ( value ) {

  		this.image = value;

  	}

  } );

  class WebGLCubeRenderTarget extends WebGLRenderTarget {

  	constructor( size, options, dummy ) {

  		if ( Number.isInteger( options ) ) {

  			console.warn( 'THREE.WebGLCubeRenderTarget: constructor signature is now WebGLCubeRenderTarget( size, options )' );

  			options = dummy;

  		}

  		super( size, size, options );

  		Object.defineProperty( this, 'isWebGLCubeRenderTarget', { value: true } );

  		options = options || {};

  		this.texture = new CubeTexture( undefined, options.mapping, options.wrapS, options.wrapT, options.magFilter, options.minFilter, options.format, options.type, options.anisotropy, options.encoding );

  		this.texture._needsFlipEnvMap = false;

  	}

  	fromEquirectangularTexture( renderer, texture ) {

  		this.texture.type = texture.type;
  		this.texture.format = RGBAFormat; // see #18859
  		this.texture.encoding = texture.encoding;

  		this.texture.generateMipmaps = texture.generateMipmaps;
  		this.texture.minFilter = texture.minFilter;
  		this.texture.magFilter = texture.magFilter;

  		const shader = {

  			uniforms: {
  				tEquirect: { value: null },
  			},

  			vertexShader: /* glsl */`

				varying vec3 vWorldDirection;

				vec3 transformDirection( in vec3 dir, in mat4 matrix ) {

					return normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );

				}

				void main() {

					vWorldDirection = transformDirection( position, modelMatrix );

					#include <begin_vertex>
					#include <project_vertex>

				}
			`,

  			fragmentShader: /* glsl */`

				uniform sampler2D tEquirect;

				varying vec3 vWorldDirection;

				#include <common>

				void main() {

					vec3 direction = normalize( vWorldDirection );

					vec2 sampleUV = equirectUv( direction );

					gl_FragColor = texture2D( tEquirect, sampleUV );

				}
			`
  		};

  		const geometry = new BoxGeometry( 5, 5, 5 );

  		const material = new ShaderMaterial( {

  			name: 'CubemapFromEquirect',

  			uniforms: cloneUniforms( shader.uniforms ),
  			vertexShader: shader.vertexShader,
  			fragmentShader: shader.fragmentShader,
  			side: BackSide,
  			blending: NoBlending

  		} );

  		material.uniforms.tEquirect.value = texture;

  		const mesh = new Mesh( geometry, material );

  		const currentMinFilter = texture.minFilter;

  		// Avoid blurred poles
  		if ( texture.minFilter === LinearMipmapLinearFilter ) texture.minFilter = LinearFilter;

  		const camera = new CubeCamera( 1, 10, this );
  		camera.update( renderer, mesh );

  		texture.minFilter = currentMinFilter;

  		mesh.geometry.dispose();
  		mesh.material.dispose();

  		return this;

  	}

  	clear( renderer, color, depth, stencil ) {

  		const currentRenderTarget = renderer.getRenderTarget();

  		for ( let i = 0; i < 6; i ++ ) {

  			renderer.setRenderTarget( this, i );

  			renderer.clear( color, depth, stencil );

  		}

  		renderer.setRenderTarget( currentRenderTarget );

  	}

  }

  function DataTexture( data, width, height, format, type, mapping, wrapS, wrapT, magFilter, minFilter, anisotropy, encoding ) {

  	Texture.call( this, null, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding );

  	this.image = { data: data || null, width: width || 1, height: height || 1 };

  	this.magFilter = magFilter !== undefined ? magFilter : NearestFilter;
  	this.minFilter = minFilter !== undefined ? minFilter : NearestFilter;

  	this.generateMipmaps = false;
  	this.flipY = false;
  	this.unpackAlignment = 1;

  	this.needsUpdate = true;

  }

  DataTexture.prototype = Object.create( Texture.prototype );
  DataTexture.prototype.constructor = DataTexture;

  DataTexture.prototype.isDataTexture = true;

  const _sphere$1 = /*@__PURE__*/ new Sphere();
  const _vector$5 = /*@__PURE__*/ new Vector3();

  class Frustum {

  	constructor( p0, p1, p2, p3, p4, p5 ) {

  		this.planes = [

  			( p0 !== undefined ) ? p0 : new Plane(),
  			( p1 !== undefined ) ? p1 : new Plane(),
  			( p2 !== undefined ) ? p2 : new Plane(),
  			( p3 !== undefined ) ? p3 : new Plane(),
  			( p4 !== undefined ) ? p4 : new Plane(),
  			( p5 !== undefined ) ? p5 : new Plane()

  		];

  	}

  	set( p0, p1, p2, p3, p4, p5 ) {

  		const planes = this.planes;

  		planes[ 0 ].copy( p0 );
  		planes[ 1 ].copy( p1 );
  		planes[ 2 ].copy( p2 );
  		planes[ 3 ].copy( p3 );
  		planes[ 4 ].copy( p4 );
  		planes[ 5 ].copy( p5 );

  		return this;

  	}

  	clone() {

  		return new this.constructor().copy( this );

  	}

  	copy( frustum ) {

  		const planes = this.planes;

  		for ( let i = 0; i < 6; i ++ ) {

  			planes[ i ].copy( frustum.planes[ i ] );

  		}

  		return this;

  	}

  	setFromProjectionMatrix( m ) {

  		const planes = this.planes;
  		const me = m.elements;
  		const me0 = me[ 0 ], me1 = me[ 1 ], me2 = me[ 2 ], me3 = me[ 3 ];
  		const me4 = me[ 4 ], me5 = me[ 5 ], me6 = me[ 6 ], me7 = me[ 7 ];
  		const me8 = me[ 8 ], me9 = me[ 9 ], me10 = me[ 10 ], me11 = me[ 11 ];
  		const me12 = me[ 12 ], me13 = me[ 13 ], me14 = me[ 14 ], me15 = me[ 15 ];

  		planes[ 0 ].setComponents( me3 - me0, me7 - me4, me11 - me8, me15 - me12 ).normalize();
  		planes[ 1 ].setComponents( me3 + me0, me7 + me4, me11 + me8, me15 + me12 ).normalize();
  		planes[ 2 ].setComponents( me3 + me1, me7 + me5, me11 + me9, me15 + me13 ).normalize();
  		planes[ 3 ].setComponents( me3 - me1, me7 - me5, me11 - me9, me15 - me13 ).normalize();
  		planes[ 4 ].setComponents( me3 - me2, me7 - me6, me11 - me10, me15 - me14 ).normalize();
  		planes[ 5 ].setComponents( me3 + me2, me7 + me6, me11 + me10, me15 + me14 ).normalize();

  		return this;

  	}

  	intersectsObject( object ) {

  		const geometry = object.geometry;

  		if ( geometry.boundingSphere === null ) geometry.computeBoundingSphere();

  		_sphere$1.copy( geometry.boundingSphere ).applyMatrix4( object.matrixWorld );

  		return this.intersectsSphere( _sphere$1 );

  	}

  	intersectsSprite( sprite ) {

  		_sphere$1.center.set( 0, 0, 0 );
  		_sphere$1.radius = 0.7071067811865476;
  		_sphere$1.applyMatrix4( sprite.matrixWorld );

  		return this.intersectsSphere( _sphere$1 );

  	}

  	intersectsSphere( sphere ) {

  		const planes = this.planes;
  		const center = sphere.center;
  		const negRadius = - sphere.radius;

  		for ( let i = 0; i < 6; i ++ ) {

  			const distance = planes[ i ].distanceToPoint( center );

  			if ( distance < negRadius ) {

  				return false;

  			}

  		}

  		return true;

  	}

  	intersectsBox( box ) {

  		const planes = this.planes;

  		for ( let i = 0; i < 6; i ++ ) {

  			const plane = planes[ i ];

  			// corner at max distance

  			_vector$5.x = plane.normal.x > 0 ? box.max.x : box.min.x;
  			_vector$5.y = plane.normal.y > 0 ? box.max.y : box.min.y;
  			_vector$5.z = plane.normal.z > 0 ? box.max.z : box.min.z;

  			if ( plane.distanceToPoint( _vector$5 ) < 0 ) {

  				return false;

  			}

  		}

  		return true;

  	}

  	containsPoint( point ) {

  		const planes = this.planes;

  		for ( let i = 0; i < 6; i ++ ) {

  			if ( planes[ i ].distanceToPoint( point ) < 0 ) {

  				return false;

  			}

  		}

  		return true;

  	}

  }

  function WebGLAnimation() {

  	let context = null;
  	let isAnimating = false;
  	let animationLoop = null;
  	let requestId = null;

  	function onAnimationFrame( time, frame ) {

  		animationLoop( time, frame );

  		requestId = context.requestAnimationFrame( onAnimationFrame );

  	}

  	return {

  		start: function () {

  			if ( isAnimating === true ) return;
  			if ( animationLoop === null ) return;

  			requestId = context.requestAnimationFrame( onAnimationFrame );

  			isAnimating = true;

  		},

  		stop: function () {

  			context.cancelAnimationFrame( requestId );

  			isAnimating = false;

  		},

  		setAnimationLoop: function ( callback ) {

  			animationLoop = callback;

  		},

  		setContext: function ( value ) {

  			context = value;

  		}

  	};

  }

  function WebGLAttributes( gl, capabilities ) {

  	const isWebGL2 = capabilities.isWebGL2;

  	const buffers = new WeakMap();

  	function createBuffer( attribute, bufferType ) {

  		const array = attribute.array;
  		const usage = attribute.usage;

  		const buffer = gl.createBuffer();

  		gl.bindBuffer( bufferType, buffer );
  		gl.bufferData( bufferType, array, usage );

  		attribute.onUploadCallback();

  		let type = 5126;

  		if ( array instanceof Float32Array ) {

  			type = 5126;

  		} else if ( array instanceof Float64Array ) {

  			console.warn( 'THREE.WebGLAttributes: Unsupported data buffer format: Float64Array.' );

  		} else if ( array instanceof Uint16Array ) {

  			if ( attribute.isFloat16BufferAttribute ) {

  				if ( isWebGL2 ) {

  					type = 5131;

  				} else {

  					console.warn( 'THREE.WebGLAttributes: Usage of Float16BufferAttribute requires WebGL2.' );

  				}

  			} else {

  				type = 5123;

  			}

  		} else if ( array instanceof Int16Array ) {

  			type = 5122;

  		} else if ( array instanceof Uint32Array ) {

  			type = 5125;

  		} else if ( array instanceof Int32Array ) {

  			type = 5124;

  		} else if ( array instanceof Int8Array ) {

  			type = 5120;

  		} else if ( array instanceof Uint8Array ) {

  			type = 5121;

  		}

  		return {
  			buffer: buffer,
  			type: type,
  			bytesPerElement: array.BYTES_PER_ELEMENT,
  			version: attribute.version
  		};

  	}

  	function updateBuffer( buffer, attribute, bufferType ) {

  		const array = attribute.array;
  		const updateRange = attribute.updateRange;

  		gl.bindBuffer( bufferType, buffer );

  		if ( updateRange.count === - 1 ) {

  			// Not using update ranges

  			gl.bufferSubData( bufferType, 0, array );

  		} else {

  			if ( isWebGL2 ) {

  				gl.bufferSubData( bufferType, updateRange.offset * array.BYTES_PER_ELEMENT,
  					array, updateRange.offset, updateRange.count );

  			} else {

  				gl.bufferSubData( bufferType, updateRange.offset * array.BYTES_PER_ELEMENT,
  					array.subarray( updateRange.offset, updateRange.offset + updateRange.count ) );

  			}

  			updateRange.count = - 1; // reset range

  		}

  	}

  	//

  	function get( attribute ) {

  		if ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;

  		return buffers.get( attribute );

  	}

  	function remove( attribute ) {

  		if ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;

  		const data = buffers.get( attribute );

  		if ( data ) {

  			gl.deleteBuffer( data.buffer );

  			buffers.delete( attribute );

  		}

  	}

  	function update( attribute, bufferType ) {

  		if ( attribute.isGLBufferAttribute ) {

  			const cached = buffers.get( attribute );

  			if ( ! cached || cached.version < attribute.version ) {

  				buffers.set( attribute, {
  					buffer: attribute.buffer,
  					type: attribute.type,
  					bytesPerElement: attribute.elementSize,
  					version: attribute.version
  				} );

  			}

  			return;

  		}

  		if ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;

  		const data = buffers.get( attribute );

  		if ( data === undefined ) {

  			buffers.set( attribute, createBuffer( attribute, bufferType ) );

  		} else if ( data.version < attribute.version ) {

  			updateBuffer( data.buffer, attribute, bufferType );

  			data.version = attribute.version;

  		}

  	}

  	return {

  		get: get,
  		remove: remove,
  		update: update

  	};

  }

  class PlaneGeometry extends BufferGeometry {

  	constructor( width = 1, height = 1, widthSegments = 1, heightSegments = 1 ) {

  		super();
  		this.type = 'PlaneGeometry';

  		this.parameters = {
  			width: width,
  			height: height,
  			widthSegments: widthSegments,
  			heightSegments: heightSegments
  		};

  		const width_half = width / 2;
  		const height_half = height / 2;

  		const gridX = Math.floor( widthSegments );
  		const gridY = Math.floor( heightSegments );

  		const gridX1 = gridX + 1;
  		const gridY1 = gridY + 1;

  		const segment_width = width / gridX;
  		const segment_height = height / gridY;

  		//

  		const indices = [];
  		const vertices = [];
  		const normals = [];
  		const uvs = [];

  		for ( let iy = 0; iy < gridY1; iy ++ ) {

  			const y = iy * segment_height - height_half;

  			for ( let ix = 0; ix < gridX1; ix ++ ) {

  				const x = ix * segment_width - width_half;

  				vertices.push( x, - y, 0 );

  				normals.push( 0, 0, 1 );

  				uvs.push( ix / gridX );
  				uvs.push( 1 - ( iy / gridY ) );

  			}

  		}

  		for ( let iy = 0; iy < gridY; iy ++ ) {

  			for ( let ix = 0; ix < gridX; ix ++ ) {

  				const a = ix + gridX1 * iy;
  				const b = ix + gridX1 * ( iy + 1 );
  				const c = ( ix + 1 ) + gridX1 * ( iy + 1 );
  				const d = ( ix + 1 ) + gridX1 * iy;

  				indices.push( a, b, d );
  				indices.push( b, c, d );

  			}

  		}

  		this.setIndex( indices );
  		this.setAttribute( 'position', new Float32BufferAttribute( vertices, 3 ) );
  		this.setAttribute( 'normal', new Float32BufferAttribute( normals, 3 ) );
  		this.setAttribute( 'uv', new Float32BufferAttribute( uvs, 2 ) );

  	}

  }

  var alphamap_fragment = "#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif";

  var alphamap_pars_fragment = "#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif";

  var alphatest_fragment = "#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif";

  var aomap_fragment = "#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif";

  var aomap_pars_fragment = "#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif";

  var begin_vertex = "vec3 transformed = vec3( position );";

  var beginnormal_vertex = "vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif";

  var bsdfs = "vec2 integrateSpecularBRDF( const in float dotNV, const in float roughness ) {\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\treturn vec2( -1.04, 1.04 ) * a004 + r.zw;\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n#else\n\tif( cutoffDistance > 0.0 && decayExponent > 0.0 ) {\n\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n\t}\n\treturn 1.0;\n#endif\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nvec3 F_Schlick_RoughnessDependent( const in vec3 F0, const in float dotNV, const in float roughness ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotNV - 6.98316 ) * dotNV );\n\tvec3 Fr = max( vec3( 1.0 - roughness ), F0 ) - F0;\n\treturn Fr * fresnel + F0;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + viewDir );\n\tfloat dotNL = saturate( dot( normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\nvec3 BRDF_Specular_GGX_Environment( const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\n\treturn specularColor * brdf.x + brdf.y;\n}\nvoid BRDF_Specular_Multiscattering_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tvec3 F = F_Schlick_RoughnessDependent( specularColor, dotNV, roughness );\n\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\n\tvec3 FssEss = F * brdf.x + brdf.y;\n\tfloat Ess = brdf.x + brdf.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = specularColor + ( 1.0 - specularColor ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie(float roughness, float NoH) {\n\tfloat invAlpha = 1.0 / roughness;\n\tfloat cos2h = NoH * NoH;\n\tfloat sin2h = max(1.0 - cos2h, 0.0078125);\treturn (2.0 + invAlpha) * pow(sin2h, invAlpha * 0.5) / (2.0 * PI);\n}\nfloat V_Neubelt(float NoV, float NoL) {\n\treturn saturate(1.0 / (4.0 * (NoL + NoV - NoL * NoV)));\n}\nvec3 BRDF_Specular_Sheen( const in float roughness, const in vec3 L, const in GeometricContext geometry, vec3 specularColor ) {\n\tvec3 N = geometry.normal;\n\tvec3 V = geometry.viewDir;\n\tvec3 H = normalize( V + L );\n\tfloat dotNH = saturate( dot( N, H ) );\n\treturn specularColor * D_Charlie( roughness, dotNH ) * V_Neubelt( dot(N, V), dot(N, L) );\n}\n#endif";

  var bumpmap_pars_fragment = "#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tfDet *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif";

  var clipping_planes_fragment = "#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\tplane = clippingPlanes[ i ];\n\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t#pragma unroll_loop_end\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\tif ( clipped ) discard;\n\t#endif\n#endif";

  var clipping_planes_pars_fragment = "#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif";

  var clipping_planes_pars_vertex = "#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif";

  var clipping_planes_vertex = "#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif";

  var color_fragment = "#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif";

  var color_pars_fragment = "#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif";

  var color_pars_vertex = "#if defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR )\n\tvarying vec3 vColor;\n#endif";

  var color_vertex = "#if defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR )\n\tvColor = vec3( 1.0 );\n#endif\n#ifdef USE_COLOR\n\tvColor.xyz *= color.xyz;\n#endif\n#ifdef USE_INSTANCING_COLOR\n\tvColor.xyz *= instanceColor.xyz;\n#endif";

  var common = "#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat max3( vec3 v ) { return max( max( v.x, v.y ), v.z ); }\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n#ifdef CLEARCOAT\n\tvec3 clearcoatNormal;\n#endif\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nfloat linearToRelativeLuminance( const in vec3 color ) {\n\tvec3 weights = vec3( 0.2126, 0.7152, 0.0722 );\n\treturn dot( weights, color.rgb );\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}";

  var cube_uv_reflection_fragment = "#ifdef ENVMAP_TYPE_CUBE_UV\n\t#define cubeUV_maxMipLevel 8.0\n\t#define cubeUV_minMipLevel 4.0\n\t#define cubeUV_maxTileSize 256.0\n\t#define cubeUV_minTileSize 16.0\n\tfloat getFace( vec3 direction ) {\n\t\tvec3 absDirection = abs( direction );\n\t\tfloat face = - 1.0;\n\t\tif ( absDirection.x > absDirection.z ) {\n\t\t\tif ( absDirection.x > absDirection.y )\n\t\t\t\tface = direction.x > 0.0 ? 0.0 : 3.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t} else {\n\t\t\tif ( absDirection.z > absDirection.y )\n\t\t\t\tface = direction.z > 0.0 ? 2.0 : 5.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t}\n\t\treturn face;\n\t}\n\tvec2 getUV( vec3 direction, float face ) {\n\t\tvec2 uv;\n\t\tif ( face == 0.0 ) {\n\t\t\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 1.0 ) {\n\t\t\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\n\t\t} else if ( face == 2.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\n\t\t} else if ( face == 3.0 ) {\n\t\t\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 4.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\n\t\t} else {\n\t\t\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\n\t\t}\n\t\treturn 0.5 * ( uv + 1.0 );\n\t}\n\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\n\t\tfloat face = getFace( direction );\n\t\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\n\t\tmipInt = max( mipInt, cubeUV_minMipLevel );\n\t\tfloat faceSize = exp2( mipInt );\n\t\tfloat texelSize = 1.0 / ( 3.0 * cubeUV_maxTileSize );\n\t\tvec2 uv = getUV( direction, face ) * ( faceSize - 1.0 );\n\t\tvec2 f = fract( uv );\n\t\tuv += 0.5 - f;\n\t\tif ( face > 2.0 ) {\n\t\t\tuv.y += faceSize;\n\t\t\tface -= 3.0;\n\t\t}\n\t\tuv.x += face * faceSize;\n\t\tif ( mipInt < cubeUV_maxMipLevel ) {\n\t\t\tuv.y += 2.0 * cubeUV_maxTileSize;\n\t\t}\n\t\tuv.y += filterInt * 2.0 * cubeUV_minTileSize;\n\t\tuv.x += 3.0 * max( 0.0, cubeUV_maxTileSize - 2.0 * faceSize );\n\t\tuv *= texelSize;\n\t\tvec3 tl = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\n\t\tuv.x += texelSize;\n\t\tvec3 tr = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\n\t\tuv.y += texelSize;\n\t\tvec3 br = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\n\t\tuv.x -= texelSize;\n\t\tvec3 bl = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\n\t\tvec3 tm = mix( tl, tr, f.x );\n\t\tvec3 bm = mix( bl, br, f.x );\n\t\treturn mix( tm, bm, f.y );\n\t}\n\t#define r0 1.0\n\t#define v0 0.339\n\t#define m0 - 2.0\n\t#define r1 0.8\n\t#define v1 0.276\n\t#define m1 - 1.0\n\t#define r4 0.4\n\t#define v4 0.046\n\t#define m4 2.0\n\t#define r5 0.305\n\t#define v5 0.016\n\t#define m5 3.0\n\t#define r6 0.21\n\t#define v6 0.0038\n\t#define m6 4.0\n\tfloat roughnessToMip( float roughness ) {\n\t\tfloat mip = 0.0;\n\t\tif ( roughness >= r1 ) {\n\t\t\tmip = ( r0 - roughness ) * ( m1 - m0 ) / ( r0 - r1 ) + m0;\n\t\t} else if ( roughness >= r4 ) {\n\t\t\tmip = ( r1 - roughness ) * ( m4 - m1 ) / ( r1 - r4 ) + m1;\n\t\t} else if ( roughness >= r5 ) {\n\t\t\tmip = ( r4 - roughness ) * ( m5 - m4 ) / ( r4 - r5 ) + m4;\n\t\t} else if ( roughness >= r6 ) {\n\t\t\tmip = ( r5 - roughness ) * ( m6 - m5 ) / ( r5 - r6 ) + m5;\n\t\t} else {\n\t\t\tmip = - 2.0 * log2( 1.16 * roughness );\t\t}\n\t\treturn mip;\n\t}\n\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\n\t\tfloat mip = clamp( roughnessToMip( roughness ), m0, cubeUV_maxMipLevel );\n\t\tfloat mipF = fract( mip );\n\t\tfloat mipInt = floor( mip );\n\t\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\n\t\tif ( mipF == 0.0 ) {\n\t\t\treturn vec4( color0, 1.0 );\n\t\t} else {\n\t\t\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\n\t\t\treturn vec4( mix( color0, color1, mipF ), 1.0 );\n\t\t}\n\t}\n#endif";

  var defaultnormal_vertex = "vec3 transformedNormal = objectNormal;\n#ifdef USE_INSTANCING\n\tmat3 m = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( m[ 0 ], m[ 0 ] ), dot( m[ 1 ], m[ 1 ] ), dot( m[ 2 ], m[ 2 ] ) );\n\ttransformedNormal = m * transformedNormal;\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = ( modelViewMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif";

  var displacementmap_pars_vertex = "#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif";

  var displacementmap_vertex = "#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vUv ).x * displacementScale + displacementBias );\n#endif";

  var emissivemap_fragment = "#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif";

  var emissivemap_pars_fragment = "#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif";

  var encodings_fragment = "gl_FragColor = linearToOutputTexel( gl_FragColor );";

  var encodings_pars_fragment = "\nvec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.rgb, vec3( gammaFactor ) ), value.a );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.rgb, vec3( 1.0 / gammaFactor ) ), value.a );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n\tfloat maxComponent = max( max( value.r, value.g ), value.b );\n\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * value.a * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\n\tfloat M = clamp( maxRGB / maxRange, 0.0, 1.0 );\n\tM = ceil( M * 255.0 ) / 255.0;\n\treturn vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\n\tfloat D = max( maxRange / maxRGB, 1.0 );\n\tD = clamp( floor( D ) / 255.0, 0.0, 1.0 );\n\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value ) {\n\tvec3 Xp_Y_XYZp = cLogLuvM * value.rgb;\n\tXp_Y_XYZp = max( Xp_Y_XYZp, vec3( 1e-6, 1e-6, 1e-6 ) );\n\tvec4 vResult;\n\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n\tvResult.w = fract( Le );\n\tvResult.z = ( Le - ( floor( vResult.w * 255.0 ) ) / 255.0 ) / 255.0;\n\treturn vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n\tfloat Le = value.z * 255.0 + value.w;\n\tvec3 Xp_Y_XYZp;\n\tXp_Y_XYZp.y = exp2( ( Le - 127.0 ) / 2.0 );\n\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n\tvec3 vRGB = cLogLuvInverseM * Xp_Y_XYZp.rgb;\n\treturn vec4( max( vRGB, 0.0 ), 1.0 );\n}";

  var envmap_fragment = "#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 envColor = textureCubeUV( envMap, reflectVec, 0.0 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifndef ENVMAP_TYPE_CUBE_UV\n\t\tenvColor = envMapTexelToLinear( envColor );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif";

  var envmap_common_pars_fragment = "#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform int maxMipLevel;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif";

  var envmap_pars_fragment = "#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif";

  var envmap_pars_vertex = "#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) ||defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif";

  var envmap_vertex = "#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif";

  var fog_vertex = "#ifdef USE_FOG\n\tfogDepth = - mvPosition.z;\n#endif";

  var fog_pars_vertex = "#ifdef USE_FOG\n\tvarying float fogDepth;\n#endif";

  var fog_fragment = "#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * fogDepth * fogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif";

  var fog_pars_fragment = "#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float fogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif";

  var gradientmap_pars_fragment = "#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn texture2D( gradientMap, coord ).rgb;\n\t#else\n\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t#endif\n}";

  var lightmap_fragment = "#ifdef USE_LIGHTMAP\n\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\n\treflectedLight.indirectDiffuse += PI * lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\n#endif";

  var lightmap_pars_fragment = "#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif";

  var lights_lambert_vertex = "vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\nvIndirectFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n\tvIndirectBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\nvIndirectFront += getAmbientLightIrradiance( ambientLightColor );\nvIndirectFront += getLightProbeIrradiance( lightProbe, geometry );\n#ifdef DOUBLE_SIDED\n\tvIndirectBack += getAmbientLightIrradiance( ambientLightColor );\n\tvIndirectBack += getLightProbeIrradiance( lightProbe, backGeometry );\n#endif\n#if NUM_POINT_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_DIR_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvIndirectFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvIndirectBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif";

  var lights_pars_begin = "uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\nuniform vec3 lightProbe[ 9 ];\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in GeometricContext geometry ) {\n\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tdirectLight.color = pointLight.color;\n\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( angleCos > spotLight.coneCos ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif";

  var envmap_physical_pars_fragment = "#if defined( USE_ENVMAP )\n\t#ifdef ENVMAP_MODE_REFRACTION\n\t\tuniform float refractionRatio;\n\t#endif\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, worldNormal, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float roughness, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat sigma = PI * roughness * roughness / ( 1.0 + roughness );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar + log2( sigma );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( -viewDir, normal );\n\t\t\treflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( -viewDir, normal, refractionRatio );\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( roughness, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, reflectVec, roughness );\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif";

  var lights_toon_fragment = "ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;";

  var lights_toon_pars_fragment = "varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon\n#define Material_LightProbeLOD( material )\t(0)";

  var lights_phong_fragment = "BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;";

  var lights_phong_pars_fragment = "varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)";

  var lights_physical_fragment = "PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nvec3 dxy = max( abs( dFdx( geometryNormal ) ), abs( dFdy( geometryNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.specularRoughness = max( roughnessFactor, 0.0525 );material.specularRoughness += geometryRoughness;\nmaterial.specularRoughness = min( material.specularRoughness, 1.0 );\n#ifdef REFLECTIVITY\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#endif\n#ifdef CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheen;\n#endif";

  var lights_physical_pars_fragment = "struct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tfloat specularRoughness;\n\tvec3 specularColor;\n#ifdef CLEARCOAT\n\tfloat clearcoat;\n\tfloat clearcoatRoughness;\n#endif\n#ifdef USE_SHEEN\n\tvec3 sheenColor;\n#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearcoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.specularRoughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifdef CLEARCOAT\n\t\tfloat ccDotNL = saturate( dot( geometry.clearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = ccDotNL * directLight.color;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tccIrradiance *= PI;\n\t\t#endif\n\t\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\n\t\treflectedLight.directSpecular += ccIrradiance * material.clearcoat * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\n\t#else\n\t\tfloat clearcoatDHR = 0.0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_Sheen(\n\t\t\tmaterial.specularRoughness,\n\t\t\tdirectLight.direction,\n\t\t\tgeometry,\n\t\t\tmaterial.sheenColor\n\t\t);\n\t#else\n\t\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.normal, material.specularColor, material.specularRoughness);\n\t#endif\n\treflectedLight.directDiffuse += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef CLEARCOAT\n\t\tfloat ccDotNV = saturate( dot( geometry.clearcoatNormal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular += clearcoatRadiance * material.clearcoat * BRDF_Specular_GGX_Environment( geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\n\t\tfloat ccDotNL = ccDotNV;\n\t\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\n\t#else\n\t\tfloat clearcoatDHR = 0.0;\n\t#endif\n\tfloat clearcoatInv = 1.0 - clearcoatDHR;\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\tBRDF_Specular_Multiscattering_Environment( geometry, material.specularColor, material.specularRoughness, singleScattering, multiScattering );\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - ( singleScattering + multiScattering ) );\n\treflectedLight.indirectSpecular += clearcoatInv * radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}";

  var lights_fragment_begin = "\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\n#ifdef CLEARCOAT\n\tgeometry.clearcoatNormal = clearcoatNormal;\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\tirradiance += getLightProbeIrradiance( lightProbe, geometry );\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif";

  var lights_fragment_maps = "#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\n\t\tvec3 lightMapIrradiance = lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getLightProbeIndirectIrradiance( geometry, maxMipLevel );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tradiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.normal, material.specularRoughness, maxMipLevel );\n\t#ifdef CLEARCOAT\n\t\tclearcoatRadiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.clearcoatNormal, material.clearcoatRoughness, maxMipLevel );\n\t#endif\n#endif";

  var lights_fragment_end = "#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometry, material, reflectedLight );\n#endif";

  var logdepthbuf_fragment = "#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tgl_FragDepthEXT = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif";

  var logdepthbuf_pars_fragment = "#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif";

  var logdepthbuf_pars_vertex = "#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t\tvarying float vIsPerspective;\n\t#else\n\t\tuniform float logDepthBufFC;\n\t#endif\n#endif";

  var logdepthbuf_vertex = "#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n\t#else\n\t\tif ( isPerspectiveMatrix( projectionMatrix ) ) {\n\t\t\tgl_Position.z = log2( max( EPSILON, gl_Position.w + 1.0 ) ) * logDepthBufFC - 1.0;\n\t\t\tgl_Position.z *= gl_Position.w;\n\t\t}\n\t#endif\n#endif";

  var map_fragment = "#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif";

  var map_pars_fragment = "#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif";

  var map_particle_fragment = "#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n#endif\n#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, uv );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif";

  var map_particle_pars_fragment = "#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tuniform mat3 uvTransform;\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif";

  var metalnessmap_fragment = "float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif";

  var metalnessmap_pars_fragment = "#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif";

  var morphnormal_vertex = "#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\tobjectNormal += morphNormal0 * morphTargetInfluences[ 0 ];\n\tobjectNormal += morphNormal1 * morphTargetInfluences[ 1 ];\n\tobjectNormal += morphNormal2 * morphTargetInfluences[ 2 ];\n\tobjectNormal += morphNormal3 * morphTargetInfluences[ 3 ];\n#endif";

  var morphtarget_pars_vertex = "#ifdef USE_MORPHTARGETS\n\tuniform float morphTargetBaseInfluence;\n\t#ifndef USE_MORPHNORMALS\n\t\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\t\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif";

  var morphtarget_vertex = "#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\ttransformed += morphTarget0 * morphTargetInfluences[ 0 ];\n\ttransformed += morphTarget1 * morphTargetInfluences[ 1 ];\n\ttransformed += morphTarget2 * morphTargetInfluences[ 2 ];\n\ttransformed += morphTarget3 * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\t\ttransformed += morphTarget4 * morphTargetInfluences[ 4 ];\n\t\ttransformed += morphTarget5 * morphTargetInfluences[ 5 ];\n\t\ttransformed += morphTarget6 * morphTargetInfluences[ 6 ];\n\t\ttransformed += morphTarget7 * morphTargetInfluences[ 7 ];\n\t#endif\n#endif";

  var normal_fragment_begin = "#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n\t#ifdef USE_TANGENT\n\t\tvec3 tangent = normalize( vTangent );\n\t\tvec3 bitangent = normalize( vBitangent );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\ttangent = tangent * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t\tbitangent = bitangent * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t#endif\n\t\t#if defined( TANGENTSPACE_NORMALMAP ) || defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tmat3 vTBN = mat3( tangent, bitangent, normal );\n\t\t#endif\n\t#endif\n#endif\nvec3 geometryNormal = normal;";

  var normal_fragment_maps = "#ifdef OBJECTSPACE_NORMALMAP\n\tnormal = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( TANGENTSPACE_NORMALMAP )\n\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\t#ifdef USE_TANGENT\n\t\tnormal = normalize( vTBN * mapN );\n\t#else\n\t\tnormal = perturbNormal2Arb( -vViewPosition, normal, mapN );\n\t#endif\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif";

  var normalmap_pars_fragment = "#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef OBJECTSPACE_NORMALMAP\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( TANGENTSPACE_NORMALMAP ) || defined ( USE_CLEARCOAT_NORMALMAP ) )\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm, vec3 mapN ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tfloat scale = sign( st1.t * st0.s - st0.t * st1.s );\n\t\tvec3 S = normalize( ( q0 * st1.t - q1 * st0.t ) * scale );\n\t\tvec3 T = normalize( ( - q0 * st1.s + q1 * st0.s ) * scale );\n\t\tvec3 N = normalize( surf_norm );\n\t\tmat3 tsn = mat3( S, T, N );\n\t\tmapN.xy *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif";

  var clearcoat_normal_fragment_begin = "#ifdef CLEARCOAT\n\tvec3 clearcoatNormal = geometryNormal;\n#endif";

  var clearcoat_normal_fragment_maps = "#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\t#ifdef USE_TANGENT\n\t\tclearcoatNormal = normalize( vTBN * clearcoatMapN );\n\t#else\n\t\tclearcoatNormal = perturbNormal2Arb( - vViewPosition, clearcoatNormal, clearcoatMapN );\n\t#endif\n#endif";

  var clearcoat_pars_fragment = "#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif";

  var packing = "vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256., 256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nvec4 pack2HalfToRGBA( vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ));\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w);\n}\nvec2 unpackRGBATo2Half( vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}";

  var premultiplied_alpha_fragment = "#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif";

  var project_vertex = "vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;";

  var dithering_fragment = "#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif";

  var dithering_pars_fragment = "#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif";

  var roughnessmap_fragment = "float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif";

  var roughnessmap_pars_fragment = "#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif";

  var shadowmap_pars_fragment = "#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx = texelSize.x;\n\t\t\tfloat dy = texelSize.y;\n\t\t\tvec2 uv = shadowCoord.xy;\n\t\t\tvec2 f = fract( uv * shadowMapSize + 0.5 );\n\t\t\tuv -= f * texelSize;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ), \n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ), \n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t f.y )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\tdp += shadowBias;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif";

  var shadowmap_pars_vertex = "#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif";

  var shadowmap_vertex = "#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0 || NUM_SPOT_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0\n\t\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\tvec4 shadowWorldPosition;\n\t#endif\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n#endif";

  var shadowmask_pars_fragment = "float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}";

  var skinbase_vertex = "#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif";

  var skinning_pars_vertex = "#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform highp sampler2D boneTexture;\n\t\tuniform int boneTextureSize;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif";

  var skinning_vertex = "#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif";

  var skinnormal_vertex = "#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif";

  var specularmap_fragment = "float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif";

  var specularmap_pars_fragment = "#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif";

  var tonemapping_fragment = "#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif";

  var tonemapping_pars_fragment = "#ifndef saturate\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(  1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,  1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,  1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }";

  var transmissionmap_fragment = "#ifdef USE_TRANSMISSIONMAP\n\ttotalTransmission *= texture2D( transmissionMap, vUv ).r;\n#endif";

  var transmissionmap_pars_fragment = "#ifdef USE_TRANSMISSIONMAP\n\tuniform sampler2D transmissionMap;\n#endif";

  var uv_pars_fragment = "#if ( defined( USE_UV ) && ! defined( UVS_VERTEX_ONLY ) )\n\tvarying vec2 vUv;\n#endif";

  var uv_pars_vertex = "#ifdef USE_UV\n\t#ifdef UVS_VERTEX_ONLY\n\t\tvec2 vUv;\n\t#else\n\t\tvarying vec2 vUv;\n\t#endif\n\tuniform mat3 uvTransform;\n#endif";

  var uv_vertex = "#ifdef USE_UV\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n#endif";

  var uv2_pars_fragment = "#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif";

  var uv2_pars_vertex = "#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n\tuniform mat3 uv2Transform;\n#endif";

  var uv2_vertex = "#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = ( uv2Transform * vec3( uv2, 1 ) ).xy;\n#endif";

  var worldpos_vertex = "#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP )\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif";

  var background_frag = "uniform sampler2D t2D;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}";

  var background_vert = "varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}";

  var cube_frag = "#include <envmap_common_pars_fragment>\nuniform float opacity;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\tvec3 vReflect = vWorldDirection;\n\t#include <envmap_fragment>\n\tgl_FragColor = envColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}";

  var cube_vert = "varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}";

  var depth_frag = "#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#endif\n}";

  var depth_vert = "#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}";

  var distanceRGBA_frag = "#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}";

  var distanceRGBA_vert = "#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}";

  var equirect_frag = "uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tvec4 texColor = texture2D( tEquirect, sampleUV );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}";

  var equirect_vert = "varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}";

  var linedashed_frag = "uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}";

  var linedashed_vert = "uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}";

  var meshbasic_frag = "uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\n\t\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\n\t\treflectedLight.indirectDiffuse += lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";

  var meshbasic_vert = "#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}";

  var meshlambert_frag = "uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.indirectDiffuse += ( gl_FrontFacing ) ? vIndirectFront : vIndirectBack;\n\t#else\n\t\treflectedLight.indirectDiffuse += vIndirectFront;\n\t#endif\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";

  var meshlambert_vert = "#define LAMBERT\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";

  var meshmatcap_frag = "#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t\tmatcapColor = matcapTexelToLinear( matcapColor );\n\t#else\n\t\tvec4 matcapColor = vec4( 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";

  var meshmatcap_vert = "#define MATCAP\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#ifndef FLAT_SHADED\n\t\tvNormal = normalize( transformedNormal );\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}";

  var meshtoon_frag = "#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";

  var meshtoon_vert = "#define TOON\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";

  var meshphong_frag = "#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";

  var meshphong_vert = "#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";

  var meshphysical_frag = "#define STANDARD\n#ifdef PHYSICAL\n\t#define REFLECTIVITY\n\t#define CLEARCOAT\n\t#define TRANSMISSION\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef TRANSMISSION\n\tuniform float transmission;\n#endif\n#ifdef REFLECTIVITY\n\tuniform float reflectivity;\n#endif\n#ifdef CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheen;\n#endif\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <transmissionmap_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#ifdef TRANSMISSION\n\t\tfloat totalTransmission = transmission;\n\t#endif\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <transmissionmap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#ifdef TRANSMISSION\n\t\tdiffuseColor.a *= mix( saturate( 1. - totalTransmission + linearToRelativeLuminance( reflectedLight.directSpecular + reflectedLight.indirectSpecular ) ), 1.0, metalness );\n\t#endif\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";

  var meshphysical_vert = "#define STANDARD\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";

  var normal_frag = "#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n}";

  var normal_vert = "#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}";

  var points_frag = "uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}";

  var points_vert = "uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}";

  var shadow_frag = "uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}";

  var shadow_vert = "#include <common>\n#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";

  var sprite_frag = "uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}";

  var sprite_vert = "uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\n\tvec2 scale;\n\tscale.x = length( vec3( modelMatrix[ 0 ].x, modelMatrix[ 0 ].y, modelMatrix[ 0 ].z ) );\n\tscale.y = length( vec3( modelMatrix[ 1 ].x, modelMatrix[ 1 ].y, modelMatrix[ 1 ].z ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}";

  const ShaderChunk = {
  	alphamap_fragment: alphamap_fragment,
  	alphamap_pars_fragment: alphamap_pars_fragment,
  	alphatest_fragment: alphatest_fragment,
  	aomap_fragment: aomap_fragment,
  	aomap_pars_fragment: aomap_pars_fragment,
  	begin_vertex: begin_vertex,
  	beginnormal_vertex: beginnormal_vertex,
  	bsdfs: bsdfs,
  	bumpmap_pars_fragment: bumpmap_pars_fragment,
  	clipping_planes_fragment: clipping_planes_fragment,
  	clipping_planes_pars_fragment: clipping_planes_pars_fragment,
  	clipping_planes_pars_vertex: clipping_planes_pars_vertex,
  	clipping_planes_vertex: clipping_planes_vertex,
  	color_fragment: color_fragment,
  	color_pars_fragment: color_pars_fragment,
  	color_pars_vertex: color_pars_vertex,
  	color_vertex: color_vertex,
  	common: common,
  	cube_uv_reflection_fragment: cube_uv_reflection_fragment,
  	defaultnormal_vertex: defaultnormal_vertex,
  	displacementmap_pars_vertex: displacementmap_pars_vertex,
  	displacementmap_vertex: displacementmap_vertex,
  	emissivemap_fragment: emissivemap_fragment,
  	emissivemap_pars_fragment: emissivemap_pars_fragment,
  	encodings_fragment: encodings_fragment,
  	encodings_pars_fragment: encodings_pars_fragment,
  	envmap_fragment: envmap_fragment,
  	envmap_common_pars_fragment: envmap_common_pars_fragment,
  	envmap_pars_fragment: envmap_pars_fragment,
  	envmap_pars_vertex: envmap_pars_vertex,
  	envmap_physical_pars_fragment: envmap_physical_pars_fragment,
  	envmap_vertex: envmap_vertex,
  	fog_vertex: fog_vertex,
  	fog_pars_vertex: fog_pars_vertex,
  	fog_fragment: fog_fragment,
  	fog_pars_fragment: fog_pars_fragment,
  	gradientmap_pars_fragment: gradientmap_pars_fragment,
  	lightmap_fragment: lightmap_fragment,
  	lightmap_pars_fragment: lightmap_pars_fragment,
  	lights_lambert_vertex: lights_lambert_vertex,
  	lights_pars_begin: lights_pars_begin,
  	lights_toon_fragment: lights_toon_fragment,
  	lights_toon_pars_fragment: lights_toon_pars_fragment,
  	lights_phong_fragment: lights_phong_fragment,
  	lights_phong_pars_fragment: lights_phong_pars_fragment,
  	lights_physical_fragment: lights_physical_fragment,
  	lights_physical_pars_fragment: lights_physical_pars_fragment,
  	lights_fragment_begin: lights_fragment_begin,
  	lights_fragment_maps: lights_fragment_maps,
  	lights_fragment_end: lights_fragment_end,
  	logdepthbuf_fragment: logdepthbuf_fragment,
  	logdepthbuf_pars_fragment: logdepthbuf_pars_fragment,
  	logdepthbuf_pars_vertex: logdepthbuf_pars_vertex,
  	logdepthbuf_vertex: logdepthbuf_vertex,
  	map_fragment: map_fragment,
  	map_pars_fragment: map_pars_fragment,
  	map_particle_fragment: map_particle_fragment,
  	map_particle_pars_fragment: map_particle_pars_fragment,
  	metalnessmap_fragment: metalnessmap_fragment,
  	metalnessmap_pars_fragment: metalnessmap_pars_fragment,
  	morphnormal_vertex: morphnormal_vertex,
  	morphtarget_pars_vertex: morphtarget_pars_vertex,
  	morphtarget_vertex: morphtarget_vertex,
  	normal_fragment_begin: normal_fragment_begin,
  	normal_fragment_maps: normal_fragment_maps,
  	normalmap_pars_fragment: normalmap_pars_fragment,
  	clearcoat_normal_fragment_begin: clearcoat_normal_fragment_begin,
  	clearcoat_normal_fragment_maps: clearcoat_normal_fragment_maps,
  	clearcoat_pars_fragment: clearcoat_pars_fragment,
  	packing: packing,
  	premultiplied_alpha_fragment: premultiplied_alpha_fragment,
  	project_vertex: project_vertex,
  	dithering_fragment: dithering_fragment,
  	dithering_pars_fragment: dithering_pars_fragment,
  	roughnessmap_fragment: roughnessmap_fragment,
  	roughnessmap_pars_fragment: roughnessmap_pars_fragment,
  	shadowmap_pars_fragment: shadowmap_pars_fragment,
  	shadowmap_pars_vertex: shadowmap_pars_vertex,
  	shadowmap_vertex: shadowmap_vertex,
  	shadowmask_pars_fragment: shadowmask_pars_fragment,
  	skinbase_vertex: skinbase_vertex,
  	skinning_pars_vertex: skinning_pars_vertex,
  	skinning_vertex: skinning_vertex,
  	skinnormal_vertex: skinnormal_vertex,
  	specularmap_fragment: specularmap_fragment,
  	specularmap_pars_fragment: specularmap_pars_fragment,
  	tonemapping_fragment: tonemapping_fragment,
  	tonemapping_pars_fragment: tonemapping_pars_fragment,
  	transmissionmap_fragment: transmissionmap_fragment,
  	transmissionmap_pars_fragment: transmissionmap_pars_fragment,
  	uv_pars_fragment: uv_pars_fragment,
  	uv_pars_vertex: uv_pars_vertex,
  	uv_vertex: uv_vertex,
  	uv2_pars_fragment: uv2_pars_fragment,
  	uv2_pars_vertex: uv2_pars_vertex,
  	uv2_vertex: uv2_vertex,
  	worldpos_vertex: worldpos_vertex,

  	background_frag: background_frag,
  	background_vert: background_vert,
  	cube_frag: cube_frag,
  	cube_vert: cube_vert,
  	depth_frag: depth_frag,
  	depth_vert: depth_vert,
  	distanceRGBA_frag: distanceRGBA_frag,
  	distanceRGBA_vert: distanceRGBA_vert,
  	equirect_frag: equirect_frag,
  	equirect_vert: equirect_vert,
  	linedashed_frag: linedashed_frag,
  	linedashed_vert: linedashed_vert,
  	meshbasic_frag: meshbasic_frag,
  	meshbasic_vert: meshbasic_vert,
  	meshlambert_frag: meshlambert_frag,
  	meshlambert_vert: meshlambert_vert,
  	meshmatcap_frag: meshmatcap_frag,
  	meshmatcap_vert: meshmatcap_vert,
  	meshtoon_frag: meshtoon_frag,
  	meshtoon_vert: meshtoon_vert,
  	meshphong_frag: meshphong_frag,
  	meshphong_vert: meshphong_vert,
  	meshphysical_frag: meshphysical_frag,
  	meshphysical_vert: meshphysical_vert,
  	normal_frag: normal_frag,
  	normal_vert: normal_vert,
  	points_frag: points_frag,
  	points_vert: points_vert,
  	shadow_frag: shadow_frag,
  	shadow_vert: shadow_vert,
  	sprite_frag: sprite_frag,
  	sprite_vert: sprite_vert
  };

  /**
   * Uniforms library for shared webgl shaders
   */

  const UniformsLib = {

  	common: {

  		diffuse: { value: new Color( 0xeeeeee ) },
  		opacity: { value: 1.0 },

  		map: { value: null },
  		uvTransform: { value: new Matrix3() },
  		uv2Transform: { value: new Matrix3() },

  		alphaMap: { value: null },

  	},

  	specularmap: {

  		specularMap: { value: null },

  	},

  	envmap: {

  		envMap: { value: null },
  		flipEnvMap: { value: - 1 },
  		reflectivity: { value: 1.0 },
  		refractionRatio: { value: 0.98 },
  		maxMipLevel: { value: 0 }

  	},

  	aomap: {

  		aoMap: { value: null },
  		aoMapIntensity: { value: 1 }

  	},

  	lightmap: {

  		lightMap: { value: null },
  		lightMapIntensity: { value: 1 }

  	},

  	emissivemap: {

  		emissiveMap: { value: null }

  	},

  	bumpmap: {

  		bumpMap: { value: null },
  		bumpScale: { value: 1 }

  	},

  	normalmap: {

  		normalMap: { value: null },
  		normalScale: { value: new Vector2( 1, 1 ) }

  	},

  	displacementmap: {

  		displacementMap: { value: null },
  		displacementScale: { value: 1 },
  		displacementBias: { value: 0 }

  	},

  	roughnessmap: {

  		roughnessMap: { value: null }

  	},

  	metalnessmap: {

  		metalnessMap: { value: null }

  	},

  	gradientmap: {

  		gradientMap: { value: null }

  	},

  	fog: {

  		fogDensity: { value: 0.00025 },
  		fogNear: { value: 1 },
  		fogFar: { value: 2000 },
  		fogColor: { value: new Color( 0xffffff ) }

  	},

  	lights: {

  		ambientLightColor: { value: [] },

  		lightProbe: { value: [] },

  		directionalLights: { value: [], properties: {
  			direction: {},
  			color: {}
  		} },

  		directionalLightShadows: { value: [], properties: {
  			shadowBias: {},
  			shadowNormalBias: {},
  			shadowRadius: {},
  			shadowMapSize: {}
  		} },

  		directionalShadowMap: { value: [] },
  		directionalShadowMatrix: { value: [] },

  		spotLights: { value: [], properties: {
  			color: {},
  			position: {},
  			direction: {},
  			distance: {},
  			coneCos: {},
  			penumbraCos: {},
  			decay: {}
  		} },

  		spotLightShadows: { value: [], properties: {
  			shadowBias: {},
  			shadowNormalBias: {},
  			shadowRadius: {},
  			shadowMapSize: {}
  		} },

  		spotShadowMap: { value: [] },
  		spotShadowMatrix: { value: [] },

  		pointLights: { value: [], properties: {
  			color: {},
  			position: {},
  			decay: {},
  			distance: {}
  		} },

  		pointLightShadows: { value: [], properties: {
  			shadowBias: {},
  			shadowNormalBias: {},
  			shadowRadius: {},
  			shadowMapSize: {},
  			shadowCameraNear: {},
  			shadowCameraFar: {}
  		} },

  		pointShadowMap: { value: [] },
  		pointShadowMatrix: { value: [] },

  		hemisphereLights: { value: [], properties: {
  			direction: {},
  			skyColor: {},
  			groundColor: {}
  		} },

  		// TODO (abelnation): RectAreaLight BRDF data needs to be moved from example to main src
  		rectAreaLights: { value: [], properties: {
  			color: {},
  			position: {},
  			width: {},
  			height: {}
  		} },

  		ltc_1: { value: null },
  		ltc_2: { value: null }

  	},

  	points: {

  		diffuse: { value: new Color( 0xeeeeee ) },
  		opacity: { value: 1.0 },
  		size: { value: 1.0 },
  		scale: { value: 1.0 },
  		map: { value: null },
  		alphaMap: { value: null },
  		uvTransform: { value: new Matrix3() }

  	},

  	sprite: {

  		diffuse: { value: new Color( 0xeeeeee ) },
  		opacity: { value: 1.0 },
  		center: { value: new Vector2( 0.5, 0.5 ) },
  		rotation: { value: 0.0 },
  		map: { value: null },
  		alphaMap: { value: null },
  		uvTransform: { value: new Matrix3() }

  	}

  };

  const ShaderLib = {

  	basic: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.specularmap,
  			UniformsLib.envmap,
  			UniformsLib.aomap,
  			UniformsLib.lightmap,
  			UniformsLib.fog
  		] ),

  		vertexShader: ShaderChunk.meshbasic_vert,
  		fragmentShader: ShaderChunk.meshbasic_frag

  	},

  	lambert: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.specularmap,
  			UniformsLib.envmap,
  			UniformsLib.aomap,
  			UniformsLib.lightmap,
  			UniformsLib.emissivemap,
  			UniformsLib.fog,
  			UniformsLib.lights,
  			{
  				emissive: { value: new Color( 0x000000 ) }
  			}
  		] ),

  		vertexShader: ShaderChunk.meshlambert_vert,
  		fragmentShader: ShaderChunk.meshlambert_frag

  	},

  	phong: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.specularmap,
  			UniformsLib.envmap,
  			UniformsLib.aomap,
  			UniformsLib.lightmap,
  			UniformsLib.emissivemap,
  			UniformsLib.bumpmap,
  			UniformsLib.normalmap,
  			UniformsLib.displacementmap,
  			UniformsLib.fog,
  			UniformsLib.lights,
  			{
  				emissive: { value: new Color( 0x000000 ) },
  				specular: { value: new Color( 0x111111 ) },
  				shininess: { value: 30 }
  			}
  		] ),

  		vertexShader: ShaderChunk.meshphong_vert,
  		fragmentShader: ShaderChunk.meshphong_frag

  	},

  	standard: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.envmap,
  			UniformsLib.aomap,
  			UniformsLib.lightmap,
  			UniformsLib.emissivemap,
  			UniformsLib.bumpmap,
  			UniformsLib.normalmap,
  			UniformsLib.displacementmap,
  			UniformsLib.roughnessmap,
  			UniformsLib.metalnessmap,
  			UniformsLib.fog,
  			UniformsLib.lights,
  			{
  				emissive: { value: new Color( 0x000000 ) },
  				roughness: { value: 1.0 },
  				metalness: { value: 0.0 },
  				envMapIntensity: { value: 1 } // temporary
  			}
  		] ),

  		vertexShader: ShaderChunk.meshphysical_vert,
  		fragmentShader: ShaderChunk.meshphysical_frag

  	},

  	toon: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.aomap,
  			UniformsLib.lightmap,
  			UniformsLib.emissivemap,
  			UniformsLib.bumpmap,
  			UniformsLib.normalmap,
  			UniformsLib.displacementmap,
  			UniformsLib.gradientmap,
  			UniformsLib.fog,
  			UniformsLib.lights,
  			{
  				emissive: { value: new Color( 0x000000 ) }
  			}
  		] ),

  		vertexShader: ShaderChunk.meshtoon_vert,
  		fragmentShader: ShaderChunk.meshtoon_frag

  	},

  	matcap: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.bumpmap,
  			UniformsLib.normalmap,
  			UniformsLib.displacementmap,
  			UniformsLib.fog,
  			{
  				matcap: { value: null }
  			}
  		] ),

  		vertexShader: ShaderChunk.meshmatcap_vert,
  		fragmentShader: ShaderChunk.meshmatcap_frag

  	},

  	points: {

  		uniforms: mergeUniforms( [
  			UniformsLib.points,
  			UniformsLib.fog
  		] ),

  		vertexShader: ShaderChunk.points_vert,
  		fragmentShader: ShaderChunk.points_frag

  	},

  	dashed: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.fog,
  			{
  				scale: { value: 1 },
  				dashSize: { value: 1 },
  				totalSize: { value: 2 }
  			}
  		] ),

  		vertexShader: ShaderChunk.linedashed_vert,
  		fragmentShader: ShaderChunk.linedashed_frag

  	},

  	depth: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.displacementmap
  		] ),

  		vertexShader: ShaderChunk.depth_vert,
  		fragmentShader: ShaderChunk.depth_frag

  	},

  	normal: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.bumpmap,
  			UniformsLib.normalmap,
  			UniformsLib.displacementmap,
  			{
  				opacity: { value: 1.0 }
  			}
  		] ),

  		vertexShader: ShaderChunk.normal_vert,
  		fragmentShader: ShaderChunk.normal_frag

  	},

  	sprite: {

  		uniforms: mergeUniforms( [
  			UniformsLib.sprite,
  			UniformsLib.fog
  		] ),

  		vertexShader: ShaderChunk.sprite_vert,
  		fragmentShader: ShaderChunk.sprite_frag

  	},

  	background: {

  		uniforms: {
  			uvTransform: { value: new Matrix3() },
  			t2D: { value: null },
  		},

  		vertexShader: ShaderChunk.background_vert,
  		fragmentShader: ShaderChunk.background_frag

  	},
  	/* -------------------------------------------------------------------------
  	//	Cube map shader
  	 ------------------------------------------------------------------------- */

  	cube: {

  		uniforms: mergeUniforms( [
  			UniformsLib.envmap,
  			{
  				opacity: { value: 1.0 }
  			}
  		] ),

  		vertexShader: ShaderChunk.cube_vert,
  		fragmentShader: ShaderChunk.cube_frag

  	},

  	equirect: {

  		uniforms: {
  			tEquirect: { value: null },
  		},

  		vertexShader: ShaderChunk.equirect_vert,
  		fragmentShader: ShaderChunk.equirect_frag

  	},

  	distanceRGBA: {

  		uniforms: mergeUniforms( [
  			UniformsLib.common,
  			UniformsLib.displacementmap,
  			{
  				referencePosition: { value: new Vector3() },
  				nearDistance: { value: 1 },
  				farDistance: { value: 1000 }
  			}
  		] ),

  		vertexShader: ShaderChunk.distanceRGBA_vert,
  		fragmentShader: ShaderChunk.distanceRGBA_frag

  	},

  	shadow: {

  		uniforms: mergeUniforms( [
  			UniformsLib.lights,
  			UniformsLib.fog,
  			{
  				color: { value: new Color( 0x00000 ) },
  				opacity: { value: 1.0 }
  			},
  		] ),

  		vertexShader: ShaderChunk.shadow_vert,
  		fragmentShader: ShaderChunk.shadow_frag

  	}

  };

  ShaderLib.physical = {

  	uniforms: mergeUniforms( [
  		ShaderLib.standard.uniforms,
  		{
  			clearcoat: { value: 0 },
  			clearcoatMap: { value: null },
  			clearcoatRoughness: { value: 0 },
  			clearcoatRoughnessMap: { value: null },
  			clearcoatNormalScale: { value: new Vector2( 1, 1 ) },
  			clearcoatNormalMap: { value: null },
  			sheen: { value: new Color( 0x000000 ) },
  			transmission: { value: 0 },
  			transmissionMap: { value: null },
  		}
  	] ),

  	vertexShader: ShaderChunk.meshphysical_vert,
  	fragmentShader: ShaderChunk.meshphysical_frag

  };

  function WebGLBackground( renderer, cubemaps, state, objects, premultipliedAlpha ) {

  	const clearColor = new Color( 0x000000 );
  	let clearAlpha = 0;

  	let planeMesh;
  	let boxMesh;

  	let currentBackground = null;
  	let currentBackgroundVersion = 0;
  	let currentTonemapping = null;

  	function render( renderList, scene, camera, forceClear ) {

  		let background = scene.isScene === true ? scene.background : null;

  		if ( background && background.isTexture ) {

  			background = cubemaps.get( background );

  		}

  		// Ignore background in AR
  		// TODO: Reconsider this.

  		const xr = renderer.xr;
  		const session = xr.getSession && xr.getSession();

  		if ( session && session.environmentBlendMode === 'additive' ) {

  			background = null;

  		}

  		if ( background === null ) {

  			setClear( clearColor, clearAlpha );

  		} else if ( background && background.isColor ) {

  			setClear( background, 1 );
  			forceClear = true;

  		}

  		if ( renderer.autoClear || forceClear ) {

  			renderer.clear( renderer.autoClearColor, renderer.autoClearDepth, renderer.autoClearStencil );

  		}

  		if ( background && ( background.isCubeTexture || background.isWebGLCubeRenderTarget || background.mapping === CubeUVReflectionMapping ) ) {

  			if ( boxMesh === undefined ) {

  				boxMesh = new Mesh(
  					new BoxGeometry( 1, 1, 1 ),
  					new ShaderMaterial( {
  						name: 'BackgroundCubeMaterial',
  						uniforms: cloneUniforms( ShaderLib.cube.uniforms ),
  						vertexShader: ShaderLib.cube.vertexShader,
  						fragmentShader: ShaderLib.cube.fragmentShader,
  						side: BackSide,
  						depthTest: false,
  						depthWrite: false,
  						fog: false
  					} )
  				);

  				boxMesh.geometry.deleteAttribute( 'normal' );
  				boxMesh.geometry.deleteAttribute( 'uv' );

  				boxMesh.onBeforeRender = function ( renderer, scene, camera ) {

  					this.matrixWorld.copyPosition( camera.matrixWorld );

  				};

  				// enable code injection for non-built-in material
  				Object.defineProperty( boxMesh.material, 'envMap', {

  					get: function () {

  						return this.uniforms.envMap.value;

  					}

  				} );

  				objects.update( boxMesh );

  			}

  			if ( background.isWebGLCubeRenderTarget ) {

  				// TODO Deprecate

  				background = background.texture;

  			}

  			boxMesh.material.uniforms.envMap.value = background;
  			boxMesh.material.uniforms.flipEnvMap.value = ( background.isCubeTexture && background._needsFlipEnvMap ) ? - 1 : 1;

  			if ( currentBackground !== background ||
  				currentBackgroundVersion !== background.version ||
  				currentTonemapping !== renderer.toneMapping ) {

  				boxMesh.material.needsUpdate = true;

  				currentBackground = background;
  				currentBackgroundVersion = background.version;
  				currentTonemapping = renderer.toneMapping;

  			}

  			// push to the pre-sorted opaque render list
  			renderList.unshift( boxMesh, boxMesh.geometry, boxMesh.material, 0, 0, null );

  		} else if ( background && background.isTexture ) {

  			if ( planeMesh === undefined ) {

  				planeMesh = new Mesh(
  					new PlaneGeometry( 2, 2 ),
  					new ShaderMaterial( {
  						name: 'BackgroundMaterial',
  						uniforms: cloneUniforms( ShaderLib.background.uniforms ),
  						vertexShader: ShaderLib.background.vertexShader,
  						fragmentShader: ShaderLib.background.fragmentShader,
  						side: FrontSide,
  						depthTest: false,
  						depthWrite: false,
  						fog: false
  					} )
  				);

  				planeMesh.geometry.deleteAttribute( 'normal' );

  				// enable code injection for non-built-in material
  				Object.defineProperty( planeMesh.material, 'map', {

  					get: function () {

  						return this.uniforms.t2D.value;

  					}

  				} );

  				objects.update( planeMesh );

  			}

  			planeMesh.material.uniforms.t2D.value = background;

  			if ( background.matrixAutoUpdate === true ) {

  				background.updateMatrix();

  			}

  			planeMesh.material.uniforms.uvTransform.value.copy( background.matrix );

  			if ( currentBackground !== background ||
  				currentBackgroundVersion !== background.version ||
  				currentTonemapping !== renderer.toneMapping ) {

  				planeMesh.material.needsUpdate = true;

  				currentBackground = background;
  				currentBackgroundVersion = background.version;
  				currentTonemapping = renderer.toneMapping;

  			}


  			// push to the pre-sorted opaque render list
  			renderList.unshift( planeMesh, planeMesh.geometry, planeMesh.material, 0, 0, null );

  		}

  	}

  	function setClear( color, alpha ) {

  		state.buffers.color.setClear( color.r, color.g, color.b, alpha, premultipliedAlpha );

  	}

  	return {

  		getClearColor: function () {

  			return clearColor;

  		},
  		setClearColor: function ( color, alpha = 1 ) {

  			clearColor.set( color );
  			clearAlpha = alpha;
  			setClear( clearColor, clearAlpha );

  		},
  		getClearAlpha: function () {

  			return clearAlpha;

  		},
  		setClearAlpha: function ( alpha ) {

  			clearAlpha = alpha;
  			setClear( clearColor, clearAlpha );

  		},
  		render: render

  	};

  }

  function WebGLBindingStates( gl, extensions, attributes, capabilities ) {

  	const maxVertexAttributes = gl.getParameter( 34921 );

  	const extension = capabilities.isWebGL2 ? null : extensions.get( 'OES_vertex_array_object' );
  	const vaoAvailable = capabilities.isWebGL2 || extension !== null;

  	const bindingStates = {};

  	const defaultState = createBindingState( null );
  	let currentState = defaultState;

  	function setup( object, material, program, geometry, index ) {

  		let updateBuffers = false;

  		if ( vaoAvailable ) {

  			const state = getBindingState( geometry, program, material );

  			if ( currentState !== state ) {

  				currentState = state;
  				bindVertexArrayObject( currentState.object );

  			}

  			updateBuffers = needsUpdate( geometry, index );

  			if ( updateBuffers ) saveCache( geometry, index );

  		} else {

  			const wireframe = ( material.wireframe === true );

  			if ( currentState.geometry !== geometry.id ||
  				currentState.program !== program.id ||
  				currentState.wireframe !== wireframe ) {

  				currentState.geometry = geometry.id;
  				currentState.program = program.id;
  				currentState.wireframe = wireframe;

  				updateBuffers = true;

  			}

  		}

  		if ( object.isInstancedMesh === true ) {

  			updateBuffers = true;

  		}

  		if ( index !== null ) {

  			attributes.update( index, 34963 );

  		}

  		if ( updateBuffers ) {

  			setupVertexAttributes( object, material, program, geometry );

  			if ( index !== null ) {

  				gl.bindBuffer( 34963, attributes.get( index ).buffer );

  			}

  		}

  	}

  	function createVertexArrayObject() {

  		if ( capabilities.isWebGL2 ) return gl.createVertexArray();

  		return extension.createVertexArrayOES();

  	}

  	function bindVertexArrayObject( vao ) {

  		if ( capabilities.isWebGL2 ) return gl.bindVertexArray( vao );

  		return extension.bindVertexArrayOES( vao );

  	}

  	function deleteVertexArrayObject( vao ) {

  		if ( capabilities.isWebGL2 ) return gl.deleteVertexArray( vao );

  		return extension.deleteVertexArrayOES( vao );

  	}

  	function getBindingState( geometry, program, material ) {

  		const wireframe = ( material.wireframe === true );

  		let programMap = bindingStates[ geometry.id ];

  		if ( programMap === undefined ) {

  			programMap = {};
  			bindingStates[ geometry.id ] = programMap;

  		}

  		let stateMap = programMap[ program.id ];

  		if ( stateMap === undefined ) {

  			stateMap = {};
  			programMap[ program.id ] = stateMap;

  		}

  		let state = stateMap[ wireframe ];

  		if ( state === undefined ) {

  			state = createBindingState( createVertexArrayObject() );
  			stateMap[ wireframe ] = state;

  		}

  		return state;

  	}

  	function createBindingState( vao ) {

  		const newAttributes = [];
  		const enabledAttributes = [];
  		const attributeDivisors = [];

  		for ( let i = 0; i < maxVertexAttributes; i ++ ) {

  			newAttributes[ i ] = 0;
  			enabledAttributes[ i ] = 0;
  			attributeDivisors[ i ] = 0;

  		}

  		return {

  			// for backward compatibility on non-VAO support browser
  			geometry: null,
  			program: null,
  			wireframe: false,

  			newAttributes: newAttributes,
  			enabledAttributes: enabledAttributes,
  			attributeDivisors: attributeDivisors,
  			object: vao,
  			attributes: {},
  			index: null

  		};

  	}

  	function needsUpdate( geometry, index ) {

  		const cachedAttributes = currentState.attributes;
  		const geometryAttributes = geometry.attributes;

  		let attributesNum = 0;

  		for ( const key in geometryAttributes ) {

  			const cachedAttribute = cachedAttributes[ key ];
  			const geometryAttribute = geometryAttributes[ key ];

  			if ( cachedAttribute === undefined ) return true;

  			if ( cachedAttribute.attribute !== geometryAttribute ) return true;

  			if ( cachedAttribute.data !== geometryAttribute.data ) return true;

  			attributesNum ++;

  		}

  		if ( currentState.attributesNum !== attributesNum ) return true;

  		if ( currentState.index !== index ) return true;

  		return false;

  	}

  	function saveCache( geometry, index ) {

  		const cache = {};
  		const attributes = geometry.attributes;
  		let attributesNum = 0;

  		for ( const key in attributes ) {

  			const attribute = attributes[ key ];

  			const data = {};
  			data.attribute = attribute;

  			if ( attribute.data ) {

  				data.data = attribute.data;

  			}

  			cache[ key ] = data;

  			attributesNum ++;

  		}

  		currentState.attributes = cache;
  		currentState.attributesNum = attributesNum;

  		currentState.index = index;

  	}

  	function initAttributes() {

  		const newAttributes = currentState.newAttributes;

  		for ( let i = 0, il = newAttributes.length; i < il; i ++ ) {

  			newAttributes[ i ] = 0;

  		}

  	}

  	function enableAttribute( attribute ) {

  		enableAttributeAndDivisor( attribute, 0 );

  	}

  	function enableAttributeAndDivisor( attribute, meshPerAttribute ) {

  		const newAttributes = currentState.newAttributes;
  		const enabledAttributes = currentState.enabledAttributes;
  		const attributeDivisors = currentState.attributeDivisors;

  		newAttributes[ attribute ] = 1;

  		if ( enabledAttributes[ attribute ] === 0 ) {

  			gl.enableVertexAttribArray( attribute );
  			enabledAttributes[ attribute ] = 1;

  		}

  		if ( attributeDivisors[ attribute ] !== meshPerAttribute ) {

  			const extension = capabilities.isWebGL2 ? gl : extensions.get( 'ANGLE_instanced_arrays' );

  			extension[ capabilities.isWebGL2 ? 'vertexAttribDivisor' : 'vertexAttribDivisorANGLE' ]( attribute, meshPerAttribute );
  			attributeDivisors[ attribute ] = meshPerAttribute;

  		}

  	}

  	function disableUnusedAttributes() {

  		const newAttributes = currentState.newAttributes;
  		const enabledAttributes = currentState.enabledAttributes;

  		for ( let i = 0, il = enabledAttributes.length; i < il; i ++ ) {

  			if ( enabledAttributes[ i ] !== newAttributes[ i ] ) {

  				gl.disableVertexAttribArray( i );
  				enabledAttributes[ i ] = 0;

  			}

  		}

  	}

  	function vertexAttribPointer( index, size, type, normalized, stride, offset ) {

  		if ( capabilities.isWebGL2 === true && ( type === 5124 || type === 5125 ) ) {

  			gl.vertexAttribIPointer( index, size, type, stride, offset );

  		} else {

  			gl.vertexAttribPointer( index, size, type, normalized, stride, offset );

  		}

  	}

  	function setupVertexAttributes( object, material, program, geometry ) {

  		if ( capabilities.isWebGL2 === false && ( object.isInstancedMesh || geometry.isInstancedBufferGeometry ) ) {

  			if ( extensions.get( 'ANGLE_instanced_arrays' ) === null ) return;

  		}

  		initAttributes();

  		const geometryAttributes = geometry.attributes;

  		const programAttributes = program.getAttributes();

  		const materialDefaultAttributeValues = material.defaultAttributeValues;

  		for ( const name in programAttributes ) {

  			const programAttribute = programAttributes[ name ];

  			if ( programAttribute >= 0 ) {

  				const geometryAttribute = geometryAttributes[ name ];

  				if ( geometryAttribute !== undefined ) {

  					const normalized = geometryAttribute.normalized;
  					const size = geometryAttribute.itemSize;

  					const attribute = attributes.get( geometryAttribute );

  					// TODO Attribute may not be available on context restore

  					if ( attribute === undefined ) continue;

  					const buffer = attribute.buffer;
  					const type = attribute.type;
  					const bytesPerElement = attribute.bytesPerElement;

  					if ( geometryAttribute.isInterleavedBufferAttribute ) {

  						const data = geometryAttribute.data;
  						const stride = data.stride;
  						const offset = geometryAttribute.offset;

  						if ( data && data.isInstancedInterleavedBuffer ) {

  							enableAttributeAndDivisor( programAttribute, data.meshPerAttribute );

  							if ( geometry._maxInstanceCount === undefined ) {

  								geometry._maxInstanceCount = data.meshPerAttribute * data.count;

  							}

  						} else {

  							enableAttribute( programAttribute );

  						}

  						gl.bindBuffer( 34962, buffer );
  						vertexAttribPointer( programAttribute, size, type, normalized, stride * bytesPerElement, offset * bytesPerElement );

  					} else {

  						if ( geometryAttribute.isInstancedBufferAttribute ) {

  							enableAttributeAndDivisor( programAttribute, geometryAttribute.meshPerAttribute );

  							if ( geometry._maxInstanceCount === undefined ) {

  								geometry._maxInstanceCount = geometryAttribute.meshPerAttribute * geometryAttribute.count;

  							}

  						} else {

  							enableAttribute( programAttribute );

  						}

  						gl.bindBuffer( 34962, buffer );
  						vertexAttribPointer( programAttribute, size, type, normalized, 0, 0 );

  					}

  				} else if ( name === 'instanceMatrix' ) {

  					const attribute = attributes.get( object.instanceMatrix );

  					// TODO Attribute may not be available on context restore

  					if ( attribute === undefined ) continue;

  					const buffer = attribute.buffer;
  					const type = attribute.type;

  					enableAttributeAndDivisor( programAttribute + 0, 1 );
  					enableAttributeAndDivisor( programAttribute + 1, 1 );
  					enableAttributeAndDivisor( programAttribute + 2, 1 );
  					enableAttributeAndDivisor( programAttribute + 3, 1 );

  					gl.bindBuffer( 34962, buffer );

  					gl.vertexAttribPointer( programAttribute + 0, 4, type, false, 64, 0 );
  					gl.vertexAttribPointer( programAttribute + 1, 4, type, false, 64, 16 );
  					gl.vertexAttribPointer( programAttribute + 2, 4, type, false, 64, 32 );
  					gl.vertexAttribPointer( programAttribute + 3, 4, type, false, 64, 48 );

  				} else if ( name === 'instanceColor' ) {

  					const attribute = attributes.get( object.instanceColor );

  					// TODO Attribute may not be available on context restore

  					if ( attribute === undefined ) continue;

  					const buffer = attribute.buffer;
  					const type = attribute.type;

  					enableAttributeAndDivisor( programAttribute, 1 );

  					gl.bindBuffer( 34962, buffer );

  					gl.vertexAttribPointer( programAttribute, 3, type, false, 12, 0 );

  				} else if ( materialDefaultAttributeValues !== undefined ) {

  					const value = materialDefaultAttributeValues[ name ];

  					if ( value !== undefined ) {

  						switch ( value.length ) {

  							case 2:
  								gl.vertexAttrib2fv( programAttribute, value );
  								break;

  							case 3:
  								gl.vertexAttrib3fv( programAttribute, value );
  								break;

  							case 4:
  								gl.vertexAttrib4fv( programAttribute, value );
  								break;

  							default:
  								gl.vertexAttrib1fv( programAttribute, value );

  						}

  					}

  				}

  			}

  		}

  		disableUnusedAttributes();

  	}

  	function dispose() {

  		reset();

  		for ( const geometryId in bindingStates ) {

  			const programMap = bindingStates[ geometryId ];

  			for ( const programId in programMap ) {

  				const stateMap = programMap[ programId ];

  				for ( const wireframe in stateMap ) {

  					deleteVertexArrayObject( stateMap[ wireframe ].object );

  					delete stateMap[ wireframe ];

  				}

  				delete programMap[ programId ];

  			}

  			delete bindingStates[ geometryId ];

  		}

  	}

  	function releaseStatesOfGeometry( geometry ) {

  		if ( bindingStates[ geometry.id ] === undefined ) return;

  		const programMap = bindingStates[ geometry.id ];

  		for ( const programId in programMap ) {

  			const stateMap = programMap[ programId ];

  			for ( const wireframe in stateMap ) {

  				deleteVertexArrayObject( stateMap[ wireframe ].object );

  				delete stateMap[ wireframe ];

  			}

  			delete programMap[ programId ];

  		}

  		delete bindingStates[ geometry.id ];

  	}

  	function releaseStatesOfProgram( program ) {

  		for ( const geometryId in bindingStates ) {

  			const programMap = bindingStates[ geometryId ];

  			if ( programMap[ program.id ] === undefined ) continue;

  			const stateMap = programMap[ program.id ];

  			for ( const wireframe in stateMap ) {

  				deleteVertexArrayObject( stateMap[ wireframe ].object );

  				delete stateMap[ wireframe ];

  			}

  			delete programMap[ program.id ];

  		}

  	}

  	function reset() {

  		resetDefaultState();

  		if ( currentState === defaultState ) return;

  		currentState = defaultState;
  		bindVertexArrayObject( currentState.object );

  	}

  	// for backward-compatilibity

  	function resetDefaultState() {

  		defaultState.geometry = null;
  		defaultState.program = null;
  		defaultState.wireframe = false;

  	}

  	return {

  		setup: setup,
  		reset: reset,
  		resetDefaultState: resetDefaultState,
  		dispose: dispose,
  		releaseStatesOfGeometry: releaseStatesOfGeometry,
  		releaseStatesOfProgram: releaseStatesOfProgram,

  		initAttributes: initAttributes,
  		enableAttribute: enableAttribute,
  		disableUnusedAttributes: disableUnusedAttributes

  	};

  }

  function WebGLBufferRenderer( gl, extensions, info, capabilities ) {

  	const isWebGL2 = capabilities.isWebGL2;

  	let mode;

  	function setMode( value ) {

  		mode = value;

  	}

  	function render( start, count ) {

  		gl.drawArrays( mode, start, count );

  		info.update( count, mode, 1 );

  	}

  	function renderInstances( start, count, primcount ) {

  		if ( primcount === 0 ) return;

  		let extension, methodName;

  		if ( isWebGL2 ) {

  			extension = gl;
  			methodName = 'drawArraysInstanced';

  		} else {

  			extension = extensions.get( 'ANGLE_instanced_arrays' );
  			methodName = 'drawArraysInstancedANGLE';

  			if ( extension === null ) {

  				console.error( 'THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.' );
  				return;

  			}

  		}

  		extension[ methodName ]( mode, start, count, primcount );

  		info.update( count, mode, primcount );

  	}

  	//

  	this.setMode = setMode;
  	this.render = render;
  	this.renderInstances = renderInstances;

  }

  function WebGLCapabilities( gl, extensions, parameters ) {

  	let maxAnisotropy;

  	function getMaxAnisotropy() {

  		if ( maxAnisotropy !== undefined ) return maxAnisotropy;

  		const extension = extensions.get( 'EXT_texture_filter_anisotropic' );

  		if ( extension !== null ) {

  			maxAnisotropy = gl.getParameter( extension.MAX_TEXTURE_MAX_ANISOTROPY_EXT );

  		} else {

  			maxAnisotropy = 0;

  		}

  		return maxAnisotropy;

  	}

  	function getMaxPrecision( precision ) {

  		if ( precision === 'highp' ) {

  			if ( gl.getShaderPrecisionFormat( 35633, 36338 ).precision > 0 &&
  				gl.getShaderPrecisionFormat( 35632, 36338 ).precision > 0 ) {

  				return 'highp';

  			}

  			precision = 'mediump';

  		}

  		if ( precision === 'mediump' ) {

  			if ( gl.getShaderPrecisionFormat( 35633, 36337 ).precision > 0 &&
  				gl.getShaderPrecisionFormat( 35632, 36337 ).precision > 0 ) {

  				return 'mediump';

  			}

  		}

  		return 'lowp';

  	}

  	/* eslint-disable no-undef */
  	const isWebGL2 = ( typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext ) ||
  		( typeof WebGL2ComputeRenderingContext !== 'undefined' && gl instanceof WebGL2ComputeRenderingContext );
  	/* eslint-enable no-undef */

  	let precision = parameters.precision !== undefined ? parameters.precision : 'highp';
  	const maxPrecision = getMaxPrecision( precision );

  	if ( maxPrecision !== precision ) {

  		console.warn( 'THREE.WebGLRenderer:', precision, 'not supported, using', maxPrecision, 'instead.' );
  		precision = maxPrecision;

  	}

  	const logarithmicDepthBuffer = parameters.logarithmicDepthBuffer === true;

  	const maxTextures = gl.getParameter( 34930 );
  	const maxVertexTextures = gl.getParameter( 35660 );
  	const maxTextureSize = gl.getParameter( 3379 );
  	const maxCubemapSize = gl.getParameter( 34076 );

  	const maxAttributes = gl.getParameter( 34921 );
  	const maxVertexUniforms = gl.getParameter( 36347 );
  	const maxVaryings = gl.getParameter( 36348 );
  	const maxFragmentUniforms = gl.getParameter( 36349 );

  	const vertexTextures = maxVertexTextures > 0;
  	const floatFragmentTextures = isWebGL2 || !! extensions.get( 'OES_texture_float' );
  	const floatVertexTextures = vertexTextures && floatFragmentTextures;

  	const maxSamples = isWebGL2 ? gl.getParameter( 36183 ) : 0;

  	return {

  		isWebGL2: isWebGL2,

  		getMaxAnisotropy: getMaxAnisotropy,
  		getMaxPrecision: getMaxPrecision,

  		precision: precision,
  		logarithmicDepthBuffer: logarithmicDepthBuffer,

  		maxTextures: maxTextures,
  		maxVertexTextures: maxVertexTextures,
  		maxTextureSize: maxTextureSize,
  		maxCubemapSize: maxCubemapSize,

  		maxAttributes: maxAttributes,
  		maxVertexUniforms: maxVertexUniforms,
  		maxVaryings: maxVaryings,
  		maxFragmentUniforms: maxFragmentUniforms,

  		vertexTextures: vertexTextures,
  		floatFragmentTextures: floatFragmentTextures,
  		floatVertexTextures: floatVertexTextures,

  		maxSamples: maxSamples

  	};

  }

  function WebGLClipping( properties ) {

  	const scope = this;

  	let globalState = null,
  		numGlobalPlanes = 0,
  		localClippingEnabled = false,
  		renderingShadows = false;

  	const plane = new Plane(),
  		viewNormalMatrix = new Matrix3(),

  		uniform = { value: null, needsUpdate: false };

  	this.uniform = uniform;
  	this.numPlanes = 0;
  	this.numIntersection = 0;

  	this.init = function ( planes, enableLocalClipping, camera ) {

  		const enabled =
  			planes.length !== 0 ||
  			enableLocalClipping ||
  			// enable state of previous frame - the clipping code has to
  			// run another frame in order to reset the state:
  			numGlobalPlanes !== 0 ||
  			localClippingEnabled;

  		localClippingEnabled = enableLocalClipping;

  		globalState = projectPlanes( planes, camera, 0 );
  		numGlobalPlanes = planes.length;

  		return enabled;

  	};

  	this.beginShadows = function () {

  		renderingShadows = true;
  		projectPlanes( null );

  	};

  	this.endShadows = function () {

  		renderingShadows = false;
  		resetGlobalState();

  	};

  	this.setState = function ( material, camera, useCache ) {

  		const planes = material.clippingPlanes,
  			clipIntersection = material.clipIntersection,
  			clipShadows = material.clipShadows;

  		const materialProperties = properties.get( material );

  		if ( ! localClippingEnabled || planes === null || planes.length === 0 || renderingShadows && ! clipShadows ) {

  			// there's no local clipping

  			if ( renderingShadows ) {

  				// there's no global clipping

  				projectPlanes( null );

  			} else {

  				resetGlobalState();

  			}

  		} else {

  			const nGlobal = renderingShadows ? 0 : numGlobalPlanes,
  				lGlobal = nGlobal * 4;

  			let dstArray = materialProperties.clippingState || null;

  			uniform.value = dstArray; // ensure unique state

  			dstArray = projectPlanes( planes, camera, lGlobal, useCache );

  			for ( let i = 0; i !== lGlobal; ++ i ) {

  				dstArray[ i ] = globalState[ i ];

  			}

  			materialProperties.clippingState = dstArray;
  			this.numIntersection = clipIntersection ? this.numPlanes : 0;
  			this.numPlanes += nGlobal;

  		}


  	};

  	function resetGlobalState() {

  		if ( uniform.value !== globalState ) {

  			uniform.value = globalState;
  			uniform.needsUpdate = numGlobalPlanes > 0;

  		}

  		scope.numPlanes = numGlobalPlanes;
  		scope.numIntersection = 0;

  	}

  	function projectPlanes( planes, camera, dstOffset, skipTransform ) {

  		const nPlanes = planes !== null ? planes.length : 0;
  		let dstArray = null;

  		if ( nPlanes !== 0 ) {

  			dstArray = uniform.value;

  			if ( skipTransform !== true || dstArray === null ) {

  				const flatSize = dstOffset + nPlanes * 4,
  					viewMatrix = camera.matrixWorldInverse;

  				viewNormalMatrix.getNormalMatrix( viewMatrix );

  				if ( dstArray === null || dstArray.length < flatSize ) {

  					dstArray = new Float32Array( flatSize );

  				}

  				for ( let i = 0, i4 = dstOffset; i !== nPlanes; ++ i, i4 += 4 ) {

  					plane.copy( planes[ i ] ).applyMatrix4( viewMatrix, viewNormalMatrix );

  					plane.normal.toArray( dstArray, i4 );
  					dstArray[ i4 + 3 ] = plane.constant;

  				}

  			}

  			uniform.value = dstArray;
  			uniform.needsUpdate = true;

  		}

  		scope.numPlanes = nPlanes;
  		scope.numIntersection = 0;

  		return dstArray;

  	}

  }

  function WebGLCubeMaps( renderer ) {

  	let cubemaps = new WeakMap();

  	function mapTextureMapping( texture, mapping ) {

  		if ( mapping === EquirectangularReflectionMapping ) {

  			texture.mapping = CubeReflectionMapping;

  		} else if ( mapping === EquirectangularRefractionMapping ) {

  			texture.mapping = CubeRefractionMapping;

  		}

  		return texture;

  	}

  	function get( texture ) {

  		if ( texture && texture.isTexture ) {

  			const mapping = texture.mapping;

  			if ( mapping === EquirectangularReflectionMapping || mapping === EquirectangularRefractionMapping ) {

  				if ( cubemaps.has( texture ) ) {

  					const cubemap = cubemaps.get( texture ).texture;
  					return mapTextureMapping( cubemap, texture.mapping );

  				} else {

  					const image = texture.image;

  					if ( image && image.height > 0 ) {

  						const currentRenderList = renderer.getRenderList();
  						const currentRenderTarget = renderer.getRenderTarget();

  						const renderTarget = new WebGLCubeRenderTarget( image.height / 2 );
  						renderTarget.fromEquirectangularTexture( renderer, texture );
  						cubemaps.set( texture, renderTarget );

  						renderer.setRenderTarget( currentRenderTarget );
  						renderer.setRenderList( currentRenderList );

  						texture.addEventListener( 'dispose', onTextureDispose );

  						return mapTextureMapping( renderTarget.texture, texture.mapping );

  					} else {

  						// image not yet ready. try the conversion next frame

  						return null;

  					}

  				}

  			}

  		}

  		return texture;

  	}

  	function onTextureDispose( event ) {

  		const texture = event.target;

  		texture.removeEventListener( 'dispose', onTextureDispose );

  		const cubemap = cubemaps.get( texture );

  		if ( cubemap !== undefined ) {

  			cubemaps.delete( texture );
  			cubemap.dispose();

  		}

  	}

  	function dispose() {

  		cubemaps = new WeakMap();

  	}

  	return {
  		get: get,
  		dispose: dispose
  	};

  }

  function WebGLExtensions( gl ) {

  	const extensions = {};

  	function getExtension( name ) {

  		if ( extensions[ name ] !== undefined ) {

  			return extensions[ name ];

  		}

  		let extension;

  		switch ( name ) {

  			case 'WEBGL_depth_texture':
  				extension = gl.getExtension( 'WEBGL_depth_texture' ) || gl.getExtension( 'MOZ_WEBGL_depth_texture' ) || gl.getExtension( 'WEBKIT_WEBGL_depth_texture' );
  				break;

  			case 'EXT_texture_filter_anisotropic':
  				extension = gl.getExtension( 'EXT_texture_filter_anisotropic' ) || gl.getExtension( 'MOZ_EXT_texture_filter_anisotropic' ) || gl.getExtension( 'WEBKIT_EXT_texture_filter_anisotropic' );
  				break;

  			case 'WEBGL_compressed_texture_s3tc':
  				extension = gl.getExtension( 'WEBGL_compressed_texture_s3tc' ) || gl.getExtension( 'MOZ_WEBGL_compressed_texture_s3tc' ) || gl.getExtension( 'WEBKIT_WEBGL_compressed_texture_s3tc' );
  				break;

  			case 'WEBGL_compressed_texture_pvrtc':
  				extension = gl.getExtension( 'WEBGL_compressed_texture_pvrtc' ) || gl.getExtension( 'WEBKIT_WEBGL_compressed_texture_pvrtc' );
  				break;

  			default:
  				extension = gl.getExtension( name );

  		}

  		extensions[ name ] = extension;

  		return extension;

  	}

  	return {

  		has: function ( name ) {

  			return getExtension( name ) !== null;

  		},

  		init: function ( capabilities ) {

  			if ( capabilities.isWebGL2 ) {

  				getExtension( 'EXT_color_buffer_float' );

  			} else {

  				getExtension( 'WEBGL_depth_texture' );
  				getExtension( 'OES_texture_float' );
  				getExtension( 'OES_texture_half_float' );
  				getExtension( 'OES_texture_half_float_linear' );
  				getExtension( 'OES_standard_derivatives' );
  				getExtension( 'OES_element_index_uint' );
  				getExtension( 'OES_vertex_array_object' );
  				getExtension( 'ANGLE_instanced_arrays' );

  			}

  			getExtension( 'OES_texture_float_linear' );
  			getExtension( 'EXT_color_buffer_half_float' );

  		},

  		get: function ( name ) {

  			const extension = getExtension( name );

  			if ( extension === null ) {

  				console.warn( 'THREE.WebGLRenderer: ' + name + ' extension not supported.' );

  			}

  			return extension;

  		}

  	};

  }

  function WebGLGeometries( gl, attributes, info, bindingStates ) {

  	const geometries = {};
  	const wireframeAttributes = new WeakMap();

  	function onGeometryDispose( event ) {

  		const geometry = event.target;

  		if ( geometry.index !== null ) {

  			attributes.remove( geometry.index );

  		}

  		for ( const name in geometry.attributes ) {

  			attributes.remove( geometry.attributes[ name ] );

  		}

  		geometry.removeEventListener( 'dispose', onGeometryDispose );

  		delete geometries[ geometry.id ];

  		const attribute = wireframeAttributes.get( geometry );

  		if ( attribute ) {

  			attributes.remove( attribute );
  			wireframeAttributes.delete( geometry );

  		}

  		bindingStates.releaseStatesOfGeometry( geometry );

  		if ( geometry.isInstancedBufferGeometry === true ) {

  			delete geometry._maxInstanceCount;

  		}

  		//

  		info.memory.geometries --;

  	}

  	function get( object, geometry ) {

  		if ( geometries[ geometry.id ] === true ) return geometry;

  		geometry.addEventListener( 'dispose', onGeometryDispose );

  		geometries[ geometry.id ] = true;

  		info.memory.geometries ++;

  		return geometry;

  	}

  	function update( geometry ) {

  		const geometryAttributes = geometry.attributes;

  		// Updating index buffer in VAO now. See WebGLBindingStates.

  		for ( const name in geometryAttributes ) {

  			attributes.update( geometryAttributes[ name ], 34962 );

  		}

  		// morph targets

  		const morphAttributes = geometry.morphAttributes;

  		for ( const name in morphAttributes ) {

  			const array = morphAttributes[ name ];

  			for ( let i = 0, l = array.length; i < l; i ++ ) {

  				attributes.update( array[ i ], 34962 );

  			}

  		}

  	}

  	function updateWireframeAttribute( geometry ) {

  		const indices = [];

  		const geometryIndex = geometry.index;
  		const geometryPosition = geometry.attributes.position;
  		let version = 0;

  		if ( geometryIndex !== null ) {

  			const array = geometryIndex.array;
  			version = geometryIndex.version;

  			for ( let i = 0, l = array.length; i < l; i += 3 ) {

  				const a = array[ i + 0 ];
  				const b = array[ i + 1 ];
  				const c = array[ i + 2 ];

  				indices.push( a, b, b, c, c, a );

  			}

  		} else {

  			const array = geometryPosition.array;
  			version = geometryPosition.version;

  			for ( let i = 0, l = ( array.length / 3 ) - 1; i < l; i += 3 ) {

  				const a = i + 0;
  				const b = i + 1;
  				const c = i + 2;

  				indices.push( a, b, b, c, c, a );

  			}

  		}

  		const attribute = new ( arrayMax( indices ) > 65535 ? Uint32BufferAttribute : Uint16BufferAttribute )( indices, 1 );
  		attribute.version = version;

  		// Updating index buffer in VAO now. See WebGLBindingStates

  		//

  		const previousAttribute = wireframeAttributes.get( geometry );

  		if ( previousAttribute ) attributes.remove( previousAttribute );

  		//

  		wireframeAttributes.set( geometry, attribute );

  	}

  	function getWireframeAttribute( geometry ) {

  		const currentAttribute = wireframeAttributes.get( geometry );

  		if ( currentAttribute ) {

  			const geometryIndex = geometry.index;

  			if ( geometryIndex !== null ) {

  				// if the attribute is obsolete, create a new one

  				if ( currentAttribute.version < geometryIndex.version ) {

  					updateWireframeAttribute( geometry );

  				}

  			}

  		} else {

  			updateWireframeAttribute( geometry );

  		}

  		return wireframeAttributes.get( geometry );

  	}

  	return {

  		get: get,
  		update: update,

  		getWireframeAttribute: getWireframeAttribute

  	};

  }

  function WebGLIndexedBufferRenderer( gl, extensions, info, capabilities ) {

  	const isWebGL2 = capabilities.isWebGL2;

  	let mode;

  	function setMode( value ) {

  		mode = value;

  	}

  	let type, bytesPerElement;

  	function setIndex( value ) {

  		type = value.type;
  		bytesPerElement = value.bytesPerElement;

  	}

  	function render( start, count ) {

  		gl.drawElements( mode, count, type, start * bytesPerElement );

  		info.update( count, mode, 1 );

  	}

  	function renderInstances( start, count, primcount ) {

  		if ( primcount === 0 ) return;

  		let extension, methodName;

  		if ( isWebGL2 ) {

  			extension = gl;
  			methodName = 'drawElementsInstanced';

  		} else {

  			extension = extensions.get( 'ANGLE_instanced_arrays' );
  			methodName = 'drawElementsInstancedANGLE';

  			if ( extension === null ) {

  				console.error( 'THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.' );
  				return;

  			}

  		}

  		extension[ methodName ]( mode, count, type, start * bytesPerElement, primcount );

  		info.update( count, mode, primcount );

  	}

  	//

  	this.setMode = setMode;
  	this.setIndex = setIndex;
  	this.render = render;
  	this.renderInstances = renderInstances;

  }

  function WebGLInfo( gl ) {

  	const memory = {
  		geometries: 0,
  		textures: 0
  	};

  	const render = {
  		frame: 0,
  		calls: 0,
  		triangles: 0,
  		points: 0,
  		lines: 0
  	};

  	function update( count, mode, instanceCount ) {

  		render.calls ++;

  		switch ( mode ) {

  			case 4:
  				render.triangles += instanceCount * ( count / 3 );
  				break;

  			case 1:
  				render.lines += instanceCount * ( count / 2 );
  				break;

  			case 3:
  				render.lines += instanceCount * ( count - 1 );
  				break;

  			case 2:
  				render.lines += instanceCount * count;
  				break;

  			case 0:
  				render.points += instanceCount * count;
  				break;

  			default:
  				console.error( 'THREE.WebGLInfo: Unknown draw mode:', mode );
  				break;

  		}

  	}

  	function reset() {

  		render.frame ++;
  		render.calls = 0;
  		render.triangles = 0;
  		render.points = 0;
  		render.lines = 0;

  	}

  	return {
  		memory: memory,
  		render: render,
  		programs: null,
  		autoReset: true,
  		reset: reset,
  		update: update
  	};

  }

  function numericalSort( a, b ) {

  	return a[ 0 ] - b[ 0 ];

  }

  function absNumericalSort( a, b ) {

  	return Math.abs( b[ 1 ] ) - Math.abs( a[ 1 ] );

  }

  function WebGLMorphtargets( gl ) {

  	const influencesList = {};
  	const morphInfluences = new Float32Array( 8 );

  	const workInfluences = [];

  	for ( let i = 0; i < 8; i ++ ) {

  		workInfluences[ i ] = [ i, 0 ];

  	}

  	function update( object, geometry, material, program ) {

  		const objectInfluences = object.morphTargetInfluences;

  		// When object doesn't have morph target influences defined, we treat it as a 0-length array
  		// This is important to make sure we set up morphTargetBaseInfluence / morphTargetInfluences

  		const length = objectInfluences === undefined ? 0 : objectInfluences.length;

  		let influences = influencesList[ geometry.id ];

  		if ( influences === undefined ) {

  			// initialise list

  			influences = [];

  			for ( let i = 0; i < length; i ++ ) {

  				influences[ i ] = [ i, 0 ];

  			}

  			influencesList[ geometry.id ] = influences;

  		}

  		// Collect influences

  		for ( let i = 0; i < length; i ++ ) {

  			const influence = influences[ i ];

  			influence[ 0 ] = i;
  			influence[ 1 ] = objectInfluences[ i ];

  		}

  		influences.sort( absNumericalSort );

  		for ( let i = 0; i < 8; i ++ ) {

  			if ( i < length && influences[ i ][ 1 ] ) {

  				workInfluences[ i ][ 0 ] = influences[ i ][ 0 ];
  				workInfluences[ i ][ 1 ] = influences[ i ][ 1 ];

  			} else {

  				workInfluences[ i ][ 0 ] = Number.MAX_SAFE_INTEGER;
  				workInfluences[ i ][ 1 ] = 0;

  			}

  		}

  		workInfluences.sort( numericalSort );

  		const morphTargets = material.morphTargets && geometry.morphAttributes.position;
  		const morphNormals = material.morphNormals && geometry.morphAttributes.normal;

  		let morphInfluencesSum = 0;

  		for ( let i = 0; i < 8; i ++ ) {

  			const influence = workInfluences[ i ];
  			const index = influence[ 0 ];
  			const value = influence[ 1 ];

  			if ( index !== Number.MAX_SAFE_INTEGER && value ) {

  				if ( morphTargets && geometry.getAttribute( 'morphTarget' + i ) !== morphTargets[ index ] ) {

  					geometry.setAttribute( 'morphTarget' + i, morphTargets[ index ] );

  				}

  				if ( morphNormals && geometry.getAttribute( 'morphNormal' + i ) !== morphNormals[ index ] ) {

  					geometry.setAttribute( 'morphNormal' + i, morphNormals[ index ] );

  				}

  				morphInfluences[ i ] = value;
  				morphInfluencesSum += value;

  			} else {

  				if ( morphTargets && geometry.hasAttribute( 'morphTarget' + i ) === true ) {

  					geometry.deleteAttribute( 'morphTarget' + i );

  				}

  				if ( morphNormals && geometry.hasAttribute( 'morphNormal' + i ) === true ) {

  					geometry.deleteAttribute( 'morphNormal' + i );

  				}

  				morphInfluences[ i ] = 0;

  			}

  		}

  		// GLSL shader uses formula baseinfluence * base + sum(target * influence)
  		// This allows us to switch between absolute morphs and relative morphs without changing shader code
  		// When baseinfluence = 1 - sum(influence), the above is equivalent to sum((target - base) * influence)
  		const morphBaseInfluence = geometry.morphTargetsRelative ? 1 : 1 - morphInfluencesSum;

  		program.getUniforms().setValue( gl, 'morphTargetBaseInfluence', morphBaseInfluence );
  		program.getUniforms().setValue( gl, 'morphTargetInfluences', morphInfluences );

  	}

  	return {

  		update: update

  	};

  }

  function WebGLObjects( gl, geometries, attributes, info ) {

  	let updateMap = new WeakMap();

  	function update( object ) {

  		const frame = info.render.frame;

  		const geometry = object.geometry;
  		const buffergeometry = geometries.get( object, geometry );

  		// Update once per frame

  		if ( updateMap.get( buffergeometry ) !== frame ) {

  			geometries.update( buffergeometry );

  			updateMap.set( buffergeometry, frame );

  		}

  		if ( object.isInstancedMesh ) {

  			if ( object.hasEventListener( 'dispose', onInstancedMeshDispose ) === false ) {

  				object.addEventListener( 'dispose', onInstancedMeshDispose );

  			}

  			attributes.update( object.instanceMatrix, 34962 );

  			if ( object.instanceColor !== null ) {

  				attributes.update( object.instanceColor, 34962 );

  			}

  		}

  		return buffergeometry;

  	}

  	function dispose() {

  		updateMap = new WeakMap();

  	}

  	function onInstancedMeshDispose( event ) {

  		const instancedMesh = event.target;

  		instancedMesh.removeEventListener( 'dispose', onInstancedMeshDispose );

  		attributes.remove( instancedMesh.instanceMatrix );

  		if ( instancedMesh.instanceColor !== null ) attributes.remove( instancedMesh.instanceColor );

  	}

  	return {

  		update: update,
  		dispose: dispose

  	};

  }

  function DataTexture2DArray( data = null, width = 1, height = 1, depth = 1 ) {

  	Texture.call( this, null );

  	this.image = { data, width, height, depth };

  	this.magFilter = NearestFilter;
  	this.minFilter = NearestFilter;

  	this.wrapR = ClampToEdgeWrapping;

  	this.generateMipmaps = false;
  	this.flipY = false;

  	this.needsUpdate = true;

  }

  DataTexture2DArray.prototype = Object.create( Texture.prototype );
  DataTexture2DArray.prototype.constructor = DataTexture2DArray;
  DataTexture2DArray.prototype.isDataTexture2DArray = true;

  function DataTexture3D( data = null, width = 1, height = 1, depth = 1 ) {

  	// We're going to add .setXXX() methods for setting properties later.
  	// Users can still set in DataTexture3D directly.
  	//
  	//	const texture = new THREE.DataTexture3D( data, width, height, depth );
  	// 	texture.anisotropy = 16;
  	//
  	// See #14839

  	Texture.call( this, null );

  	this.image = { data, width, height, depth };

  	this.magFilter = NearestFilter;
  	this.minFilter = NearestFilter;

  	this.wrapR = ClampToEdgeWrapping;

  	this.generateMipmaps = false;
  	this.flipY = false;

  	this.needsUpdate = true;


  }

  DataTexture3D.prototype = Object.create( Texture.prototype );
  DataTexture3D.prototype.constructor = DataTexture3D;
  DataTexture3D.prototype.isDataTexture3D = true;

  /**
   * Uniforms of a program.
   * Those form a tree structure with a special top-level container for the root,
   * which you get by calling 'new WebGLUniforms( gl, program )'.
   *
   *
   * Properties of inner nodes including the top-level container:
   *
   * .seq - array of nested uniforms
   * .map - nested uniforms by name
   *
   *
   * Methods of all nodes except the top-level container:
   *
   * .setValue( gl, value, [textures] )
   *
   * 		uploads a uniform value(s)
   *  	the 'textures' parameter is needed for sampler uniforms
   *
   *
   * Static methods of the top-level container (textures factorizations):
   *
   * .upload( gl, seq, values, textures )
   *
   * 		sets uniforms in 'seq' to 'values[id].value'
   *
   * .seqWithValue( seq, values ) : filteredSeq
   *
   * 		filters 'seq' entries with corresponding entry in values
   *
   *
   * Methods of the top-level container (textures factorizations):
   *
   * .setValue( gl, name, value, textures )
   *
   * 		sets uniform with  name 'name' to 'value'
   *
   * .setOptional( gl, obj, prop )
   *
   * 		like .set for an optional property of the object
   *
   */

  const emptyTexture = new Texture();
  const emptyTexture2dArray = new DataTexture2DArray();
  const emptyTexture3d = new DataTexture3D();
  const emptyCubeTexture = new CubeTexture();

  // --- Utilities ---

  // Array Caches (provide typed arrays for temporary by size)

  const arrayCacheF32 = [];
  const arrayCacheI32 = [];

  // Float32Array caches used for uploading Matrix uniforms

  const mat4array = new Float32Array( 16 );
  const mat3array = new Float32Array( 9 );
  const mat2array = new Float32Array( 4 );

  // Flattening for arrays of vectors and matrices

  function flatten( array, nBlocks, blockSize ) {

  	const firstElem = array[ 0 ];

  	if ( firstElem <= 0 || firstElem > 0 ) return array;
  	// unoptimized: ! isNaN( firstElem )
  	// see http://jacksondunstan.com/articles/983

  	const n = nBlocks * blockSize;
  	let r = arrayCacheF32[ n ];

  	if ( r === undefined ) {

  		r = new Float32Array( n );
  		arrayCacheF32[ n ] = r;

  	}

  	if ( nBlocks !== 0 ) {

  		firstElem.toArray( r, 0 );

  		for ( let i = 1, offset = 0; i !== nBlocks; ++ i ) {

  			offset += blockSize;
  			array[ i ].toArray( r, offset );

  		}

  	}

  	return r;

  }

  function arraysEqual( a, b ) {

  	if ( a.length !== b.length ) return false;

  	for ( let i = 0, l = a.length; i < l; i ++ ) {

  		if ( a[ i ] !== b[ i ] ) return false;

  	}

  	return true;

  }

  function copyArray( a, b ) {

  	for ( let i = 0, l = b.length; i < l; i ++ ) {

  		a[ i ] = b[ i ];

  	}

  }

  // Texture unit allocation

  function allocTexUnits( textures, n ) {

  	let r = arrayCacheI32[ n ];

  	if ( r === undefined ) {

  		r = new Int32Array( n );
  		arrayCacheI32[ n ] = r;

  	}

  	for ( let i = 0; i !== n; ++ i ) {

  		r[ i ] = textures.allocateTextureUnit();

  	}

  	return r;

  }

  // --- Setters ---

  // Note: Defining these methods externally, because they come in a bunch
  // and this way their names minify.

  // Single scalar

  function setValueV1f( gl, v ) {

  	const cache = this.cache;

  	if ( cache[ 0 ] === v ) return;

  	gl.uniform1f( this.addr, v );

  	cache[ 0 ] = v;

  }

  // Single float vector (from flat array or THREE.VectorN)

  function setValueV2f( gl, v ) {

  	const cache = this.cache;

  	if ( v.x !== undefined ) {

  		if ( cache[ 0 ] !== v.x || cache[ 1 ] !== v.y ) {

  			gl.uniform2f( this.addr, v.x, v.y );

  			cache[ 0 ] = v.x;
  			cache[ 1 ] = v.y;

  		}

  	} else {

  		if ( arraysEqual( cache, v ) ) return;

  		gl.uniform2fv( this.addr, v );

  		copyArray( cache, v );

  	}

  }

  function setValueV3f( gl, v ) {

  	const cache = this.cache;

  	if ( v.x !== undefined ) {

  		if ( cache[ 0 ] !== v.x || cache[ 1 ] !== v.y || cache[ 2 ] !== v.z ) {

  			gl.uniform3f( this.addr, v.x, v.y, v.z );

  			cache[ 0 ] = v.x;
  			cache[ 1 ] = v.y;
  			cache[ 2 ] = v.z;

  		}

  	} else if ( v.r !== undefined ) {

  		if ( cache[ 0 ] !== v.r || cache[ 1 ] !== v.g || cache[ 2 ] !== v.b ) {

  			gl.uniform3f( this.addr, v.r, v.g, v.b );

  			cache[ 0 ] = v.r;
  			cache[ 1 ] = v.g;
  			cache[ 2 ] = v.b;

  		}

  	} else {

  		if ( arraysEqual( cache, v ) ) return;

  		gl.uniform3fv( this.addr, v );

  		copyArray( cache, v );

  	}

  }

  function setValueV4f( gl, v ) {

  	const cache = this.cache;

  	if ( v.x !== undefined ) {

  		if ( cache[ 0 ] !== v.x || cache[ 1 ] !== v.y || cache[ 2 ] !== v.z || cache[ 3 ] !== v.w ) {

  			gl.uniform4f( this.addr, v.x, v.y, v.z, v.w );

  			cache[ 0 ] = v.x;
  			cache[ 1 ] = v.y;
  			cache[ 2 ] = v.z;
  			cache[ 3 ] = v.w;

  		}

  	} else {

  		if ( arraysEqual( cache, v ) ) return;

  		gl.uniform4fv( this.addr, v );

  		copyArray( cache, v );

  	}

  }

  // Single matrix (from flat array or MatrixN)

  function setValueM2( gl, v ) {

  	const cache = this.cache;
  	const elements = v.elements;

  	if ( elements === undefined ) {

  		if ( arraysEqual( cache, v ) ) return;

  		gl.uniformMatrix2fv( this.addr, false, v );

  		copyArray( cache, v );

  	} else {

  		if ( arraysEqual( cache, elements ) ) return;

  		mat2array.set( elements );

  		gl.uniformMatrix2fv( this.addr, false, mat2array );

  		copyArray( cache, elements );

  	}

  }

  function setValueM3( gl, v ) {

  	const cache = this.cache;
  	const elements = v.elements;

  	if ( elements === undefined ) {

  		if ( arraysEqual( cache, v ) ) return;

  		gl.uniformMatrix3fv( this.addr, false, v );

  		copyArray( cache, v );

  	} else {

  		if ( arraysEqual( cache, elements ) ) return;

  		mat3array.set( elements );

  		gl.uniformMatrix3fv( this.addr, false, mat3array );

  		copyArray( cache, elements );

  	}

  }

  function setValueM4( gl, v ) {

  	const cache = this.cache;
  	const elements = v.elements;

  	if ( elements === undefined ) {

  		if ( arraysEqual( cache, v ) ) return;

  		gl.uniformMatrix4fv( this.addr, false, v );

  		copyArray( cache, v );

  	} else {

  		if ( arraysEqual( cache, elements ) ) return;

  		mat4array.set( elements );

  		gl.uniformMatrix4fv( this.addr, false, mat4array );

  		copyArray( cache, elements );

  	}

  }

  // Single texture (2D / Cube)

  function setValueT1( gl, v, textures ) {

  	const cache = this.cache;
  	const unit = textures.allocateTextureUnit();

  	if ( cache[ 0 ] !== unit ) {

  		gl.uniform1i( this.addr, unit );
  		cache[ 0 ] = unit;

  	}

  	textures.safeSetTexture2D( v || emptyTexture, unit );

  }

  function setValueT2DArray1( gl, v, textures ) {

  	const cache = this.cache;
  	const unit = textures.allocateTextureUnit();

  	if ( cache[ 0 ] !== unit ) {

  		gl.uniform1i( this.addr, unit );
  		cache[ 0 ] = unit;

  	}

  	textures.setTexture2DArray( v || emptyTexture2dArray, unit );

  }

  function setValueT3D1( gl, v, textures ) {

  	const cache = this.cache;
  	const unit = textures.allocateTextureUnit();

  	if ( cache[ 0 ] !== unit ) {

  		gl.uniform1i( this.addr, unit );
  		cache[ 0 ] = unit;

  	}

  	textures.setTexture3D( v || emptyTexture3d, unit );

  }

  function setValueT6( gl, v, textures ) {

  	const cache = this.cache;
  	const unit = textures.allocateTextureUnit();

  	if ( cache[ 0 ] !== unit ) {

  		gl.uniform1i( this.addr, unit );
  		cache[ 0 ] = unit;

  	}

  	textures.safeSetTextureCube( v || emptyCubeTexture, unit );

  }

  // Integer / Boolean vectors or arrays thereof (always flat arrays)

  function setValueV1i( gl, v ) {

  	const cache = this.cache;

  	if ( cache[ 0 ] === v ) return;

  	gl.uniform1i( this.addr, v );

  	cache[ 0 ] = v;

  }

  function setValueV2i( gl, v ) {

  	const cache = this.cache;

  	if ( arraysEqual( cache, v ) ) return;

  	gl.uniform2iv( this.addr, v );

  	copyArray( cache, v );

  }

  function setValueV3i( gl, v ) {

  	const cache = this.cache;

  	if ( arraysEqual( cache, v ) ) return;

  	gl.uniform3iv( this.addr, v );

  	copyArray( cache, v );

  }

  function setValueV4i( gl, v ) {

  	const cache = this.cache;

  	if ( arraysEqual( cache, v ) ) return;

  	gl.uniform4iv( this.addr, v );

  	copyArray( cache, v );

  }

  // uint

  function setValueV1ui( gl, v ) {

  	const cache = this.cache;

  	if ( cache[ 0 ] === v ) return;

  	gl.uniform1ui( this.addr, v );

  	cache[ 0 ] = v;

  }

  // Helper to pick the right setter for the singular case

  function getSingularSetter( type ) {

  	switch ( type ) {

  		case 0x1406: return setValueV1f; // FLOAT
  		case 0x8b50: return setValueV2f; // _VEC2
  		case 0x8b51: return setValueV3f; // _VEC3
  		case 0x8b52: return setValueV4f; // _VEC4

  		case 0x8b5a: return setValueM2; // _MAT2
  		case 0x8b5b: return setValueM3; // _MAT3
  		case 0x8b5c: return setValueM4; // _MAT4

  		case 0x1404: case 0x8b56: return setValueV1i; // INT, BOOL
  		case 0x8b53: case 0x8b57: return setValueV2i; // _VEC2
  		case 0x8b54: case 0x8b58: return setValueV3i; // _VEC3
  		case 0x8b55: case 0x8b59: return setValueV4i; // _VEC4

  		case 0x1405: return setValueV1ui; // UINT

  		case 0x8b5e: // SAMPLER_2D
  		case 0x8d66: // SAMPLER_EXTERNAL_OES
  		case 0x8dca: // INT_SAMPLER_2D
  		case 0x8dd2: // UNSIGNED_INT_SAMPLER_2D
  		case 0x8b62: // SAMPLER_2D_SHADOW
  			return setValueT1;

  		case 0x8b5f: // SAMPLER_3D
  		case 0x8dcb: // INT_SAMPLER_3D
  		case 0x8dd3: // UNSIGNED_INT_SAMPLER_3D
  			return setValueT3D1;

  		case 0x8b60: // SAMPLER_CUBE
  		case 0x8dcc: // INT_SAMPLER_CUBE
  		case 0x8dd4: // UNSIGNED_INT_SAMPLER_CUBE
  		case 0x8dc5: // SAMPLER_CUBE_SHADOW
  			return setValueT6;

  		case 0x8dc1: // SAMPLER_2D_ARRAY
  		case 0x8dcf: // INT_SAMPLER_2D_ARRAY
  		case 0x8dd7: // UNSIGNED_INT_SAMPLER_2D_ARRAY
  		case 0x8dc4: // SAMPLER_2D_ARRAY_SHADOW
  			return setValueT2DArray1;

  	}

  }

  // Array of scalars
  function setValueV1fArray( gl, v ) {

  	gl.uniform1fv( this.addr, v );

  }

  // Integer / Boolean vectors or arrays thereof (always flat arrays)
  function setValueV1iArray( gl, v ) {

  	gl.uniform1iv( this.addr, v );

  }

  function setValueV2iArray( gl, v ) {

  	gl.uniform2iv( this.addr, v );

  }

  function setValueV3iArray( gl, v ) {

  	gl.uniform3iv( this.addr, v );

  }

  function setValueV4iArray( gl, v ) {

  	gl.uniform4iv( this.addr, v );

  }


  // Array of vectors (flat or from THREE classes)

  function setValueV2fArray( gl, v ) {

  	const data = flatten( v, this.size, 2 );

  	gl.uniform2fv( this.addr, data );

  }

  function setValueV3fArray( gl, v ) {

  	const data = flatten( v, this.size, 3 );

  	gl.uniform3fv( this.addr, data );

  }

  function setValueV4fArray( gl, v ) {

  	const data = flatten( v, this.size, 4 );

  	gl.uniform4fv( this.addr, data );

  }

  // Array of matrices (flat or from THREE clases)

  function setValueM2Array( gl, v ) {

  	const data = flatten( v, this.size, 4 );

  	gl.uniformMatrix2fv( this.addr, false, data );

  }

  function setValueM3Array( gl, v ) {

  	const data = flatten( v, this.size, 9 );

  	gl.uniformMatrix3fv( this.addr, false, data );

  }

  function setValueM4Array( gl, v ) {

  	const data = flatten( v, this.size, 16 );

  	gl.uniformMatrix4fv( this.addr, false, data );

  }

  // Array of textures (2D / Cube)

  function setValueT1Array( gl, v, textures ) {

  	const n = v.length;

  	const units = allocTexUnits( textures, n );

  	gl.uniform1iv( this.addr, units );

  	for ( let i = 0; i !== n; ++ i ) {

  		textures.safeSetTexture2D( v[ i ] || emptyTexture, units[ i ] );

  	}

  }

  function setValueT6Array( gl, v, textures ) {

  	const n = v.length;

  	const units = allocTexUnits( textures, n );

  	gl.uniform1iv( this.addr, units );

  	for ( let i = 0; i !== n; ++ i ) {

  		textures.safeSetTextureCube( v[ i ] || emptyCubeTexture, units[ i ] );

  	}

  }

  // Helper to pick the right setter for a pure (bottom-level) array

  function getPureArraySetter( type ) {

  	switch ( type ) {

  		case 0x1406: return setValueV1fArray; // FLOAT
  		case 0x8b50: return setValueV2fArray; // _VEC2
  		case 0x8b51: return setValueV3fArray; // _VEC3
  		case 0x8b52: return setValueV4fArray; // _VEC4

  		case 0x8b5a: return setValueM2Array; // _MAT2
  		case 0x8b5b: return setValueM3Array; // _MAT3
  		case 0x8b5c: return setValueM4Array; // _MAT4

  		case 0x1404: case 0x8b56: return setValueV1iArray; // INT, BOOL
  		case 0x8b53: case 0x8b57: return setValueV2iArray; // _VEC2
  		case 0x8b54: case 0x8b58: return setValueV3iArray; // _VEC3
  		case 0x8b55: case 0x8b59: return setValueV4iArray; // _VEC4

  		case 0x8b5e: // SAMPLER_2D
  		case 0x8d66: // SAMPLER_EXTERNAL_OES
  		case 0x8dca: // INT_SAMPLER_2D
  		case 0x8dd2: // UNSIGNED_INT_SAMPLER_2D
  		case 0x8b62: // SAMPLER_2D_SHADOW
  			return setValueT1Array;

  		case 0x8b60: // SAMPLER_CUBE
  		case 0x8dcc: // INT_SAMPLER_CUBE
  		case 0x8dd4: // UNSIGNED_INT_SAMPLER_CUBE
  		case 0x8dc5: // SAMPLER_CUBE_SHADOW
  			return setValueT6Array;

  	}

  }

  // --- Uniform Classes ---

  function SingleUniform( id, activeInfo, addr ) {

  	this.id = id;
  	this.addr = addr;
  	this.cache = [];
  	this.setValue = getSingularSetter( activeInfo.type );

  	// this.path = activeInfo.name; // DEBUG

  }

  function PureArrayUniform( id, activeInfo, addr ) {

  	this.id = id;
  	this.addr = addr;
  	this.cache = [];
  	this.size = activeInfo.size;
  	this.setValue = getPureArraySetter( activeInfo.type );

  	// this.path = activeInfo.name; // DEBUG

  }

  PureArrayUniform.prototype.updateCache = function ( data ) {

  	const cache = this.cache;

  	if ( data instanceof Float32Array && cache.length !== data.length ) {

  		this.cache = new Float32Array( data.length );

  	}

  	copyArray( cache, data );

  };

  function StructuredUniform( id ) {

  	this.id = id;

  	this.seq = [];
  	this.map = {};

  }

  StructuredUniform.prototype.setValue = function ( gl, value, textures ) {

  	const seq = this.seq;

  	for ( let i = 0, n = seq.length; i !== n; ++ i ) {

  		const u = seq[ i ];
  		u.setValue( gl, value[ u.id ], textures );

  	}

  };

  // --- Top-level ---

  // Parser - builds up the property tree from the path strings

  const RePathPart = /(\w+)(\])?(\[|\.)?/g;

  // extracts
  // 	- the identifier (member name or array index)
  //  - followed by an optional right bracket (found when array index)
  //  - followed by an optional left bracket or dot (type of subscript)
  //
  // Note: These portions can be read in a non-overlapping fashion and
  // allow straightforward parsing of the hierarchy that WebGL encodes
  // in the uniform names.

  function addUniform( container, uniformObject ) {

  	container.seq.push( uniformObject );
  	container.map[ uniformObject.id ] = uniformObject;

  }

  function parseUniform( activeInfo, addr, container ) {

  	const path = activeInfo.name,
  		pathLength = path.length;

  	// reset RegExp object, because of the early exit of a previous run
  	RePathPart.lastIndex = 0;

  	while ( true ) {

  		const match = RePathPart.exec( path ),
  			matchEnd = RePathPart.lastIndex;

  		let id = match[ 1 ];
  		const idIsIndex = match[ 2 ] === ']',
  			subscript = match[ 3 ];

  		if ( idIsIndex ) id = id | 0; // convert to integer

  		if ( subscript === undefined || subscript === '[' && matchEnd + 2 === pathLength ) {

  			// bare name or "pure" bottom-level array "[0]" suffix

  			addUniform( container, subscript === undefined ?
  				new SingleUniform( id, activeInfo, addr ) :
  				new PureArrayUniform( id, activeInfo, addr ) );

  			break;

  		} else {

  			// step into inner node / create it in case it doesn't exist

  			const map = container.map;
  			let next = map[ id ];

  			if ( next === undefined ) {

  				next = new StructuredUniform( id );
  				addUniform( container, next );

  			}

  			container = next;

  		}

  	}

  }

  // Root Container

  function WebGLUniforms( gl, program ) {

  	this.seq = [];
  	this.map = {};

  	const n = gl.getProgramParameter( program, 35718 );

  	for ( let i = 0; i < n; ++ i ) {

  		const info = gl.getActiveUniform( program, i ),
  			addr = gl.getUniformLocation( program, info.name );

  		parseUniform( info, addr, this );

  	}

  }

  WebGLUniforms.prototype.setValue = function ( gl, name, value, textures ) {

  	const u = this.map[ name ];

  	if ( u !== undefined ) u.setValue( gl, value, textures );

  };

  WebGLUniforms.prototype.setOptional = function ( gl, object, name ) {

  	const v = object[ name ];

  	if ( v !== undefined ) this.setValue( gl, name, v );

  };


  // Static interface

  WebGLUniforms.upload = function ( gl, seq, values, textures ) {

  	for ( let i = 0, n = seq.length; i !== n; ++ i ) {

  		const u = seq[ i ],
  			v = values[ u.id ];

  		if ( v.needsUpdate !== false ) {

  			// note: always updating when .needsUpdate is undefined
  			u.setValue( gl, v.value, textures );

  		}

  	}

  };

  WebGLUniforms.seqWithValue = function ( seq, values ) {

  	const r = [];

  	for ( let i = 0, n = seq.length; i !== n; ++ i ) {

  		const u = seq[ i ];
  		if ( u.id in values ) r.push( u );

  	}

  	return r;

  };

  function WebGLShader( gl, type, string ) {

  	const shader = gl.createShader( type );

  	gl.shaderSource( shader, string );
  	gl.compileShader( shader );

  	return shader;

  }

  let programIdCount = 0;

  function addLineNumbers( string ) {

  	const lines = string.split( '\n' );

  	for ( let i = 0; i < lines.length; i ++ ) {

  		lines[ i ] = ( i + 1 ) + ': ' + lines[ i ];

  	}

  	return lines.join( '\n' );

  }

  function getEncodingComponents( encoding ) {

  	switch ( encoding ) {

  		case LinearEncoding:
  			return [ 'Linear', '( value )' ];
  		case sRGBEncoding:
  			return [ 'sRGB', '( value )' ];
  		case RGBEEncoding:
  			return [ 'RGBE', '( value )' ];
  		case RGBM7Encoding:
  			return [ 'RGBM', '( value, 7.0 )' ];
  		case RGBM16Encoding:
  			return [ 'RGBM', '( value, 16.0 )' ];
  		case RGBDEncoding:
  			return [ 'RGBD', '( value, 256.0 )' ];
  		case GammaEncoding:
  			return [ 'Gamma', '( value, float( GAMMA_FACTOR ) )' ];
  		case LogLuvEncoding:
  			return [ 'LogLuv', '( value )' ];
  		default:
  			console.warn( 'THREE.WebGLProgram: Unsupported encoding:', encoding );
  			return [ 'Linear', '( value )' ];

  	}

  }

  function getShaderErrors( gl, shader, type ) {

  	const status = gl.getShaderParameter( shader, 35713 );
  	const log = gl.getShaderInfoLog( shader ).trim();

  	if ( status && log === '' ) return '';

  	// --enable-privileged-webgl-extension
  	// console.log( '**' + type + '**', gl.getExtension( 'WEBGL_debug_shaders' ).getTranslatedShaderSource( shader ) );

  	const source = gl.getShaderSource( shader );

  	return 'THREE.WebGLShader: gl.getShaderInfoLog() ' + type + '\n' + log + addLineNumbers( source );

  }

  function getTexelDecodingFunction( functionName, encoding ) {

  	const components = getEncodingComponents( encoding );
  	return 'vec4 ' + functionName + '( vec4 value ) { return ' + components[ 0 ] + 'ToLinear' + components[ 1 ] + '; }';

  }

  function getTexelEncodingFunction( functionName, encoding ) {

  	const components = getEncodingComponents( encoding );
  	return 'vec4 ' + functionName + '( vec4 value ) { return LinearTo' + components[ 0 ] + components[ 1 ] + '; }';

  }

  function getToneMappingFunction( functionName, toneMapping ) {

  	let toneMappingName;

  	switch ( toneMapping ) {

  		case LinearToneMapping:
  			toneMappingName = 'Linear';
  			break;

  		case ReinhardToneMapping:
  			toneMappingName = 'Reinhard';
  			break;

  		case CineonToneMapping:
  			toneMappingName = 'OptimizedCineon';
  			break;

  		case ACESFilmicToneMapping:
  			toneMappingName = 'ACESFilmic';
  			break;

  		case CustomToneMapping:
  			toneMappingName = 'Custom';
  			break;

  		default:
  			console.warn( 'THREE.WebGLProgram: Unsupported toneMapping:', toneMapping );
  			toneMappingName = 'Linear';

  	}

  	return 'vec3 ' + functionName + '( vec3 color ) { return ' + toneMappingName + 'ToneMapping( color ); }';

  }

  function generateExtensions( parameters ) {

  	const chunks = [
  		( parameters.extensionDerivatives || parameters.envMapCubeUV || parameters.bumpMap || parameters.tangentSpaceNormalMap || parameters.clearcoatNormalMap || parameters.flatShading || parameters.shaderID === 'physical' ) ? '#extension GL_OES_standard_derivatives : enable' : '',
  		( parameters.extensionFragDepth || parameters.logarithmicDepthBuffer ) && parameters.rendererExtensionFragDepth ? '#extension GL_EXT_frag_depth : enable' : '',
  		( parameters.extensionDrawBuffers && parameters.rendererExtensionDrawBuffers ) ? '#extension GL_EXT_draw_buffers : require' : '',
  		( parameters.extensionShaderTextureLOD || parameters.envMap ) && parameters.rendererExtensionShaderTextureLod ? '#extension GL_EXT_shader_texture_lod : enable' : ''
  	];

  	return chunks.filter( filterEmptyLine ).join( '\n' );

  }

  function generateDefines( defines ) {

  	const chunks = [];

  	for ( const name in defines ) {

  		const value = defines[ name ];

  		if ( value === false ) continue;

  		chunks.push( '#define ' + name + ' ' + value );

  	}

  	return chunks.join( '\n' );

  }

  function fetchAttributeLocations( gl, program ) {

  	const attributes = {};

  	const n = gl.getProgramParameter( program, 35721 );

  	for ( let i = 0; i < n; i ++ ) {

  		const info = gl.getActiveAttrib( program, i );
  		const name = info.name;

  		// console.log( 'THREE.WebGLProgram: ACTIVE VERTEX ATTRIBUTE:', name, i );

  		attributes[ name ] = gl.getAttribLocation( program, name );

  	}

  	return attributes;

  }

  function filterEmptyLine( string ) {

  	return string !== '';

  }

  function replaceLightNums( string, parameters ) {

  	return string
  		.replace( /NUM_DIR_LIGHTS/g, parameters.numDirLights )
  		.replace( /NUM_SPOT_LIGHTS/g, parameters.numSpotLights )
  		.replace( /NUM_RECT_AREA_LIGHTS/g, parameters.numRectAreaLights )
  		.replace( /NUM_POINT_LIGHTS/g, parameters.numPointLights )
  		.replace( /NUM_HEMI_LIGHTS/g, parameters.numHemiLights )
  		.replace( /NUM_DIR_LIGHT_SHADOWS/g, parameters.numDirLightShadows )
  		.replace( /NUM_SPOT_LIGHT_SHADOWS/g, parameters.numSpotLightShadows )
  		.replace( /NUM_POINT_LIGHT_SHADOWS/g, parameters.numPointLightShadows );

  }

  function replaceClippingPlaneNums( string, parameters ) {

  	return string
  		.replace( /NUM_CLIPPING_PLANES/g, parameters.numClippingPlanes )
  		.replace( /UNION_CLIPPING_PLANES/g, ( parameters.numClippingPlanes - parameters.numClipIntersection ) );

  }

  // Resolve Includes

  const includePattern = /^[ \t]*#include +<([\w\d./]+)>/gm;

  function resolveIncludes( string ) {

  	return string.replace( includePattern, includeReplacer );

  }

  function includeReplacer( match, include ) {

  	const string = ShaderChunk[ include ];

  	if ( string === undefined ) {

  		throw new Error( 'Can not resolve #include <' + include + '>' );

  	}

  	return resolveIncludes( string );

  }

  // Unroll Loops

  const deprecatedUnrollLoopPattern = /#pragma unroll_loop[\s]+?for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g;
  const unrollLoopPattern = /#pragma unroll_loop_start\s+for\s*\(\s*int\s+i\s*=\s*(\d+)\s*;\s*i\s*<\s*(\d+)\s*;\s*i\s*\+\+\s*\)\s*{([\s\S]+?)}\s+#pragma unroll_loop_end/g;

  function unrollLoops( string ) {

  	return string
  		.replace( unrollLoopPattern, loopReplacer )
  		.replace( deprecatedUnrollLoopPattern, deprecatedLoopReplacer );

  }

  function deprecatedLoopReplacer( match, start, end, snippet ) {

  	console.warn( 'WebGLProgram: #pragma unroll_loop shader syntax is deprecated. Please use #pragma unroll_loop_start syntax instead.' );
  	return loopReplacer( match, start, end, snippet );

  }

  function loopReplacer( match, start, end, snippet ) {

  	let string = '';

  	for ( let i = parseInt( start ); i < parseInt( end ); i ++ ) {

  		string += snippet
  			.replace( /\[\s*i\s*\]/g, '[ ' + i + ' ]' )
  			.replace( /UNROLLED_LOOP_INDEX/g, i );

  	}

  	return string;

  }

  //

  function generatePrecision( parameters ) {

  	let precisionstring = 'precision ' + parameters.precision + ' float;\nprecision ' + parameters.precision + ' int;';

  	if ( parameters.precision === 'highp' ) {

  		precisionstring += '\n#define HIGH_PRECISION';

  	} else if ( parameters.precision === 'mediump' ) {

  		precisionstring += '\n#define MEDIUM_PRECISION';

  	} else if ( parameters.precision === 'lowp' ) {

  		precisionstring += '\n#define LOW_PRECISION';

  	}

  	return precisionstring;

  }

  function generateShadowMapTypeDefine( parameters ) {

  	let shadowMapTypeDefine = 'SHADOWMAP_TYPE_BASIC';

  	if ( parameters.shadowMapType === PCFShadowMap ) {

  		shadowMapTypeDefine = 'SHADOWMAP_TYPE_PCF';

  	} else if ( parameters.shadowMapType === PCFSoftShadowMap ) {

  		shadowMapTypeDefine = 'SHADOWMAP_TYPE_PCF_SOFT';

  	} else if ( parameters.shadowMapType === VSMShadowMap ) {

  		shadowMapTypeDefine = 'SHADOWMAP_TYPE_VSM';

  	}

  	return shadowMapTypeDefine;

  }

  function generateEnvMapTypeDefine( parameters ) {

  	let envMapTypeDefine = 'ENVMAP_TYPE_CUBE';

  	if ( parameters.envMap ) {

  		switch ( parameters.envMapMode ) {

  			case CubeReflectionMapping:
  			case CubeRefractionMapping:
  				envMapTypeDefine = 'ENVMAP_TYPE_CUBE';
  				break;

  			case CubeUVReflectionMapping:
  			case CubeUVRefractionMapping:
  				envMapTypeDefine = 'ENVMAP_TYPE_CUBE_UV';
  				break;

  		}

  	}

  	return envMapTypeDefine;

  }

  function generateEnvMapModeDefine( parameters ) {

  	let envMapModeDefine = 'ENVMAP_MODE_REFLECTION';

  	if ( parameters.envMap ) {

  		switch ( parameters.envMapMode ) {

  			case CubeRefractionMapping:
  			case CubeUVRefractionMapping:

  				envMapModeDefine = 'ENVMAP_MODE_REFRACTION';
  				break;

  		}

  	}

  	return envMapModeDefine;

  }

  function generateEnvMapBlendingDefine( parameters ) {

  	let envMapBlendingDefine = 'ENVMAP_BLENDING_NONE';

  	if ( parameters.envMap ) {

  		switch ( parameters.combine ) {

  			case MultiplyOperation:
  				envMapBlendingDefine = 'ENVMAP_BLENDING_MULTIPLY';
  				break;

  			case MixOperation:
  				envMapBlendingDefine = 'ENVMAP_BLENDING_MIX';
  				break;

  			case AddOperation:
  				envMapBlendingDefine = 'ENVMAP_BLENDING_ADD';
  				break;

  		}

  	}

  	return envMapBlendingDefine;

  }

  function WebGLProgram( renderer, cacheKey, parameters, bindingStates ) {

  	const gl = renderer.getContext();

  	const defines = parameters.defines;

  	let vertexShader = parameters.vertexShader;
  	let fragmentShader = parameters.fragmentShader;

  	const shadowMapTypeDefine = generateShadowMapTypeDefine( parameters );
  	const envMapTypeDefine = generateEnvMapTypeDefine( parameters );
  	const envMapModeDefine = generateEnvMapModeDefine( parameters );
  	const envMapBlendingDefine = generateEnvMapBlendingDefine( parameters );


  	const gammaFactorDefine = ( renderer.gammaFactor > 0 ) ? renderer.gammaFactor : 1.0;

  	const customExtensions = parameters.isWebGL2 ? '' : generateExtensions( parameters );

  	const customDefines = generateDefines( defines );

  	const program = gl.createProgram();

  	let prefixVertex, prefixFragment;
  	let versionString = parameters.glslVersion ? '#version ' + parameters.glslVersion + '\n' : '';

  	if ( parameters.isRawShaderMaterial ) {

  		prefixVertex = [

  			customDefines

  		].filter( filterEmptyLine ).join( '\n' );

  		if ( prefixVertex.length > 0 ) {

  			prefixVertex += '\n';

  		}

  		prefixFragment = [

  			customExtensions,
  			customDefines

  		].filter( filterEmptyLine ).join( '\n' );

  		if ( prefixFragment.length > 0 ) {

  			prefixFragment += '\n';

  		}

  	} else {

  		prefixVertex = [

  			generatePrecision( parameters ),

  			'#define SHADER_NAME ' + parameters.shaderName,

  			customDefines,

  			parameters.instancing ? '#define USE_INSTANCING' : '',
  			parameters.instancingColor ? '#define USE_INSTANCING_COLOR' : '',

  			parameters.supportsVertexTextures ? '#define VERTEX_TEXTURES' : '',

  			'#define GAMMA_FACTOR ' + gammaFactorDefine,

  			'#define MAX_BONES ' + parameters.maxBones,
  			( parameters.useFog && parameters.fog ) ? '#define USE_FOG' : '',
  			( parameters.useFog && parameters.fogExp2 ) ? '#define FOG_EXP2' : '',

  			parameters.map ? '#define USE_MAP' : '',
  			parameters.envMap ? '#define USE_ENVMAP' : '',
  			parameters.envMap ? '#define ' + envMapModeDefine : '',
  			parameters.lightMap ? '#define USE_LIGHTMAP' : '',
  			parameters.aoMap ? '#define USE_AOMAP' : '',
  			parameters.emissiveMap ? '#define USE_EMISSIVEMAP' : '',
  			parameters.bumpMap ? '#define USE_BUMPMAP' : '',
  			parameters.normalMap ? '#define USE_NORMALMAP' : '',
  			( parameters.normalMap && parameters.objectSpaceNormalMap ) ? '#define OBJECTSPACE_NORMALMAP' : '',
  			( parameters.normalMap && parameters.tangentSpaceNormalMap ) ? '#define TANGENTSPACE_NORMALMAP' : '',

  			parameters.clearcoatMap ? '#define USE_CLEARCOATMAP' : '',
  			parameters.clearcoatRoughnessMap ? '#define USE_CLEARCOAT_ROUGHNESSMAP' : '',
  			parameters.clearcoatNormalMap ? '#define USE_CLEARCOAT_NORMALMAP' : '',
  			parameters.displacementMap && parameters.supportsVertexTextures ? '#define USE_DISPLACEMENTMAP' : '',
  			parameters.specularMap ? '#define USE_SPECULARMAP' : '',
  			parameters.roughnessMap ? '#define USE_ROUGHNESSMAP' : '',
  			parameters.metalnessMap ? '#define USE_METALNESSMAP' : '',
  			parameters.alphaMap ? '#define USE_ALPHAMAP' : '',
  			parameters.transmissionMap ? '#define USE_TRANSMISSIONMAP' : '',

  			parameters.vertexTangents ? '#define USE_TANGENT' : '',
  			parameters.vertexColors ? '#define USE_COLOR' : '',
  			parameters.vertexUvs ? '#define USE_UV' : '',
  			parameters.uvsVertexOnly ? '#define UVS_VERTEX_ONLY' : '',

  			parameters.flatShading ? '#define FLAT_SHADED' : '',

  			parameters.skinning ? '#define USE_SKINNING' : '',
  			parameters.useVertexTexture ? '#define BONE_TEXTURE' : '',

  			parameters.morphTargets ? '#define USE_MORPHTARGETS' : '',
  			parameters.morphNormals && parameters.flatShading === false ? '#define USE_MORPHNORMALS' : '',
  			parameters.doubleSided ? '#define DOUBLE_SIDED' : '',
  			parameters.flipSided ? '#define FLIP_SIDED' : '',

  			parameters.shadowMapEnabled ? '#define USE_SHADOWMAP' : '',
  			parameters.shadowMapEnabled ? '#define ' + shadowMapTypeDefine : '',

  			parameters.sizeAttenuation ? '#define USE_SIZEATTENUATION' : '',

  			parameters.logarithmicDepthBuffer ? '#define USE_LOGDEPTHBUF' : '',
  			( parameters.logarithmicDepthBuffer && parameters.rendererExtensionFragDepth ) ? '#define USE_LOGDEPTHBUF_EXT' : '',

  			'uniform mat4 modelMatrix;',
  			'uniform mat4 modelViewMatrix;',
  			'uniform mat4 projectionMatrix;',
  			'uniform mat4 viewMatrix;',
  			'uniform mat3 normalMatrix;',
  			'uniform vec3 cameraPosition;',
  			'uniform bool isOrthographic;',

  			'#ifdef USE_INSTANCING',

  			'	attribute mat4 instanceMatrix;',

  			'#endif',

  			'#ifdef USE_INSTANCING_COLOR',

  			'	attribute vec3 instanceColor;',

  			'#endif',

  			'attribute vec3 position;',
  			'attribute vec3 normal;',
  			'attribute vec2 uv;',

  			'#ifdef USE_TANGENT',

  			'	attribute vec4 tangent;',

  			'#endif',

  			'#ifdef USE_COLOR',

  			'	attribute vec3 color;',

  			'#endif',

  			'#ifdef USE_MORPHTARGETS',

  			'	attribute vec3 morphTarget0;',
  			'	attribute vec3 morphTarget1;',
  			'	attribute vec3 morphTarget2;',
  			'	attribute vec3 morphTarget3;',

  			'	#ifdef USE_MORPHNORMALS',

  			'		attribute vec3 morphNormal0;',
  			'		attribute vec3 morphNormal1;',
  			'		attribute vec3 morphNormal2;',
  			'		attribute vec3 morphNormal3;',

  			'	#else',

  			'		attribute vec3 morphTarget4;',
  			'		attribute vec3 morphTarget5;',
  			'		attribute vec3 morphTarget6;',
  			'		attribute vec3 morphTarget7;',

  			'	#endif',

  			'#endif',

  			'#ifdef USE_SKINNING',

  			'	attribute vec4 skinIndex;',
  			'	attribute vec4 skinWeight;',

  			'#endif',

  			'\n'

  		].filter( filterEmptyLine ).join( '\n' );

  		prefixFragment = [

  			customExtensions,

  			generatePrecision( parameters ),

  			'#define SHADER_NAME ' + parameters.shaderName,

  			customDefines,

  			parameters.alphaTest ? '#define ALPHATEST ' + parameters.alphaTest + ( parameters.alphaTest % 1 ? '' : '.0' ) : '', // add '.0' if integer

  			'#define GAMMA_FACTOR ' + gammaFactorDefine,

  			( parameters.useFog && parameters.fog ) ? '#define USE_FOG' : '',
  			( parameters.useFog && parameters.fogExp2 ) ? '#define FOG_EXP2' : '',

  			parameters.map ? '#define USE_MAP' : '',
  			parameters.matcap ? '#define USE_MATCAP' : '',
  			parameters.envMap ? '#define USE_ENVMAP' : '',
  			parameters.envMap ? '#define ' + envMapTypeDefine : '',
  			parameters.envMap ? '#define ' + envMapModeDefine : '',
  			parameters.envMap ? '#define ' + envMapBlendingDefine : '',
  			parameters.lightMap ? '#define USE_LIGHTMAP' : '',
  			parameters.aoMap ? '#define USE_AOMAP' : '',
  			parameters.emissiveMap ? '#define USE_EMISSIVEMAP' : '',
  			parameters.bumpMap ? '#define USE_BUMPMAP' : '',
  			parameters.normalMap ? '#define USE_NORMALMAP' : '',
  			( parameters.normalMap && parameters.objectSpaceNormalMap ) ? '#define OBJECTSPACE_NORMALMAP' : '',
  			( parameters.normalMap && parameters.tangentSpaceNormalMap ) ? '#define TANGENTSPACE_NORMALMAP' : '',
  			parameters.clearcoatMap ? '#define USE_CLEARCOATMAP' : '',
  			parameters.clearcoatRoughnessMap ? '#define USE_CLEARCOAT_ROUGHNESSMAP' : '',
  			parameters.clearcoatNormalMap ? '#define USE_CLEARCOAT_NORMALMAP' : '',
  			parameters.specularMap ? '#define USE_SPECULARMAP' : '',
  			parameters.roughnessMap ? '#define USE_ROUGHNESSMAP' : '',
  			parameters.metalnessMap ? '#define USE_METALNESSMAP' : '',
  			parameters.alphaMap ? '#define USE_ALPHAMAP' : '',

  			parameters.sheen ? '#define USE_SHEEN' : '',
  			parameters.transmissionMap ? '#define USE_TRANSMISSIONMAP' : '',

  			parameters.vertexTangents ? '#define USE_TANGENT' : '',
  			parameters.vertexColors || parameters.instancingColor ? '#define USE_COLOR' : '',
  			parameters.vertexUvs ? '#define USE_UV' : '',
  			parameters.uvsVertexOnly ? '#define UVS_VERTEX_ONLY' : '',

  			parameters.gradientMap ? '#define USE_GRADIENTMAP' : '',

  			parameters.flatShading ? '#define FLAT_SHADED' : '',

  			parameters.doubleSided ? '#define DOUBLE_SIDED' : '',
  			parameters.flipSided ? '#define FLIP_SIDED' : '',

  			parameters.shadowMapEnabled ? '#define USE_SHADOWMAP' : '',
  			parameters.shadowMapEnabled ? '#define ' + shadowMapTypeDefine : '',

  			parameters.premultipliedAlpha ? '#define PREMULTIPLIED_ALPHA' : '',

  			parameters.physicallyCorrectLights ? '#define PHYSICALLY_CORRECT_LIGHTS' : '',

  			parameters.logarithmicDepthBuffer ? '#define USE_LOGDEPTHBUF' : '',
  			( parameters.logarithmicDepthBuffer && parameters.rendererExtensionFragDepth ) ? '#define USE_LOGDEPTHBUF_EXT' : '',

  			( ( parameters.extensionShaderTextureLOD || parameters.envMap ) && parameters.rendererExtensionShaderTextureLod ) ? '#define TEXTURE_LOD_EXT' : '',

  			'uniform mat4 viewMatrix;',
  			'uniform vec3 cameraPosition;',
  			'uniform bool isOrthographic;',

  			( parameters.toneMapping !== NoToneMapping ) ? '#define TONE_MAPPING' : '',
  			( parameters.toneMapping !== NoToneMapping ) ? ShaderChunk[ 'tonemapping_pars_fragment' ] : '', // this code is required here because it is used by the toneMapping() function defined below
  			( parameters.toneMapping !== NoToneMapping ) ? getToneMappingFunction( 'toneMapping', parameters.toneMapping ) : '',

  			parameters.dithering ? '#define DITHERING' : '',

  			ShaderChunk[ 'encodings_pars_fragment' ], // this code is required here because it is used by the various encoding/decoding function defined below
  			parameters.map ? getTexelDecodingFunction( 'mapTexelToLinear', parameters.mapEncoding ) : '',
  			parameters.matcap ? getTexelDecodingFunction( 'matcapTexelToLinear', parameters.matcapEncoding ) : '',
  			parameters.envMap ? getTexelDecodingFunction( 'envMapTexelToLinear', parameters.envMapEncoding ) : '',
  			parameters.emissiveMap ? getTexelDecodingFunction( 'emissiveMapTexelToLinear', parameters.emissiveMapEncoding ) : '',
  			parameters.lightMap ? getTexelDecodingFunction( 'lightMapTexelToLinear', parameters.lightMapEncoding ) : '',
  			getTexelEncodingFunction( 'linearToOutputTexel', parameters.outputEncoding ),

  			parameters.depthPacking ? '#define DEPTH_PACKING ' + parameters.depthPacking : '',

  			'\n'

  		].filter( filterEmptyLine ).join( '\n' );

  	}

  	vertexShader = resolveIncludes( vertexShader );
  	vertexShader = replaceLightNums( vertexShader, parameters );
  	vertexShader = replaceClippingPlaneNums( vertexShader, parameters );

  	fragmentShader = resolveIncludes( fragmentShader );
  	fragmentShader = replaceLightNums( fragmentShader, parameters );
  	fragmentShader = replaceClippingPlaneNums( fragmentShader, parameters );

  	vertexShader = unrollLoops( vertexShader );
  	fragmentShader = unrollLoops( fragmentShader );

  	if ( parameters.isWebGL2 && parameters.isRawShaderMaterial !== true ) {

  		// GLSL 3.0 conversion for built-in materials and ShaderMaterial

  		versionString = '#version 300 es\n';

  		prefixVertex = [
  			'#define attribute in',
  			'#define varying out',
  			'#define texture2D texture'
  		].join( '\n' ) + '\n' + prefixVertex;

  		prefixFragment = [
  			'#define varying in',
  			( parameters.glslVersion === GLSL3 ) ? '' : 'out highp vec4 pc_fragColor;',
  			( parameters.glslVersion === GLSL3 ) ? '' : '#define gl_FragColor pc_fragColor',
  			'#define gl_FragDepthEXT gl_FragDepth',
  			'#define texture2D texture',
  			'#define textureCube texture',
  			'#define texture2DProj textureProj',
  			'#define texture2DLodEXT textureLod',
  			'#define texture2DProjLodEXT textureProjLod',
  			'#define textureCubeLodEXT textureLod',
  			'#define texture2DGradEXT textureGrad',
  			'#define texture2DProjGradEXT textureProjGrad',
  			'#define textureCubeGradEXT textureGrad'
  		].join( '\n' ) + '\n' + prefixFragment;

  	}

  	const vertexGlsl = versionString + prefixVertex + vertexShader;
  	const fragmentGlsl = versionString + prefixFragment + fragmentShader;

  	// console.log( '*VERTEX*', vertexGlsl );
  	// console.log( '*FRAGMENT*', fragmentGlsl );

  	const glVertexShader = WebGLShader( gl, 35633, vertexGlsl );
  	const glFragmentShader = WebGLShader( gl, 35632, fragmentGlsl );

  	gl.attachShader( program, glVertexShader );
  	gl.attachShader( program, glFragmentShader );

  	// Force a particular attribute to index 0.

  	if ( parameters.index0AttributeName !== undefined ) {

  		gl.bindAttribLocation( program, 0, parameters.index0AttributeName );

  	} else if ( parameters.morphTargets === true ) {

  		// programs with morphTargets displace position out of attribute 0
  		gl.bindAttribLocation( program, 0, 'position' );

  	}

  	gl.linkProgram( program );

  	// check for link errors
  	if ( renderer.debug.checkShaderErrors ) {

  		const programLog = gl.getProgramInfoLog( program ).trim();
  		const vertexLog = gl.getShaderInfoLog( glVertexShader ).trim();
  		const fragmentLog = gl.getShaderInfoLog( glFragmentShader ).trim();

  		let runnable = true;
  		let haveDiagnostics = true;

  		if ( gl.getProgramParameter( program, 35714 ) === false ) {

  			runnable = false;

  			const vertexErrors = getShaderErrors( gl, glVertexShader, 'vertex' );
  			const fragmentErrors = getShaderErrors( gl, glFragmentShader, 'fragment' );

  			console.error( 'THREE.WebGLProgram: shader error: ', gl.getError(), '35715', gl.getProgramParameter( program, 35715 ), 'gl.getProgramInfoLog', programLog, vertexErrors, fragmentErrors );

  		} else if ( programLog !== '' ) {

  			console.warn( 'THREE.WebGLProgram: gl.getProgramInfoLog()', programLog );

  		} else if ( vertexLog === '' || fragmentLog === '' ) {

  			haveDiagnostics = false;

  		}

  		if ( haveDiagnostics ) {

  			this.diagnostics = {

  				runnable: runnable,

  				programLog: programLog,

  				vertexShader: {

  					log: vertexLog,
  					prefix: prefixVertex

  				},

  				fragmentShader: {

  					log: fragmentLog,
  					prefix: prefixFragment

  				}

  			};

  		}

  	}

  	// Clean up

  	// Crashes in iOS9 and iOS10. #18402
  	// gl.detachShader( program, glVertexShader );
  	// gl.detachShader( program, glFragmentShader );

  	gl.deleteShader( glVertexShader );
  	gl.deleteShader( glFragmentShader );

  	// set up caching for uniform locations

  	let cachedUniforms;

  	this.getUniforms = function () {

  		if ( cachedUniforms === undefined ) {

  			cachedUniforms = new WebGLUniforms( gl, program );

  		}

  		return cachedUniforms;

  	};

  	// set up caching for attribute locations

  	let cachedAttributes;

  	this.getAttributes = function () {

  		if ( cachedAttributes === undefined ) {

  			cachedAttributes = fetchAttributeLocations( gl, program );

  		}

  		return cachedAttributes;

  	};

  	// free resource

  	this.destroy = function () {

  		bindingStates.releaseStatesOfProgram( this );

  		gl.deleteProgram( program );
  		this.program = undefined;

  	};

  	//

  	this.name = parameters.shaderName;
  	this.id = programIdCount ++;
  	this.cacheKey = cacheKey;
  	this.usedTimes = 1;
  	this.program = program;
  	this.vertexShader = glVertexShader;
  	this.fragmentShader = glFragmentShader;

  	return this;

  }

  function WebGLPrograms( renderer, cubemaps, extensions, capabilities, bindingStates, clipping ) {

  	const programs = [];

  	const isWebGL2 = capabilities.isWebGL2;
  	const logarithmicDepthBuffer = capabilities.logarithmicDepthBuffer;
  	const floatVertexTextures = capabilities.floatVertexTextures;
  	const maxVertexUniforms = capabilities.maxVertexUniforms;
  	const vertexTextures = capabilities.vertexTextures;

  	let precision = capabilities.precision;

  	const shaderIDs = {
  		MeshDepthMaterial: 'depth',
  		MeshDistanceMaterial: 'distanceRGBA',
  		MeshNormalMaterial: 'normal',
  		MeshBasicMaterial: 'basic',
  		MeshLambertMaterial: 'lambert',
  		MeshPhongMaterial: 'phong',
  		MeshToonMaterial: 'toon',
  		MeshStandardMaterial: 'physical',
  		MeshPhysicalMaterial: 'physical',
  		MeshMatcapMaterial: 'matcap',
  		LineBasicMaterial: 'basic',
  		LineDashedMaterial: 'dashed',
  		PointsMaterial: 'points',
  		ShadowMaterial: 'shadow',
  		SpriteMaterial: 'sprite'
  	};

  	const parameterNames = [
  		'precision', 'isWebGL2', 'supportsVertexTextures', 'outputEncoding', 'instancing', 'instancingColor',
  		'map', 'mapEncoding', 'matcap', 'matcapEncoding', 'envMap', 'envMapMode', 'envMapEncoding', 'envMapCubeUV',
  		'lightMap', 'lightMapEncoding', 'aoMap', 'emissiveMap', 'emissiveMapEncoding', 'bumpMap', 'normalMap', 'objectSpaceNormalMap', 'tangentSpaceNormalMap', 'clearcoatMap', 'clearcoatRoughnessMap', 'clearcoatNormalMap', 'displacementMap', 'specularMap',
  		'roughnessMap', 'metalnessMap', 'gradientMap',
  		'alphaMap', 'combine', 'vertexColors', 'vertexTangents', 'vertexUvs', 'uvsVertexOnly', 'fog', 'useFog', 'fogExp2',
  		'flatShading', 'sizeAttenuation', 'logarithmicDepthBuffer', 'skinning',
  		'maxBones', 'useVertexTexture', 'morphTargets', 'morphNormals',
  		'maxMorphTargets', 'maxMorphNormals', 'premultipliedAlpha',
  		'numDirLights', 'numPointLights', 'numSpotLights', 'numHemiLights', 'numRectAreaLights',
  		'numDirLightShadows', 'numPointLightShadows', 'numSpotLightShadows',
  		'shadowMapEnabled', 'shadowMapType', 'toneMapping', 'physicallyCorrectLights',
  		'alphaTest', 'doubleSided', 'flipSided', 'numClippingPlanes', 'numClipIntersection', 'depthPacking', 'dithering',
  		'sheen', 'transmissionMap'
  	];

  	function getMaxBones( object ) {

  		const skeleton = object.skeleton;
  		const bones = skeleton.bones;

  		if ( floatVertexTextures ) {

  			return 1024;

  		} else {

  			// default for when object is not specified
  			// ( for example when prebuilding shader to be used with multiple objects )
  			//
  			//  - leave some extra space for other uniforms
  			//  - limit here is ANGLE's 254 max uniform vectors
  			//    (up to 54 should be safe)

  			const nVertexUniforms = maxVertexUniforms;
  			const nVertexMatrices = Math.floor( ( nVertexUniforms - 20 ) / 4 );

  			const maxBones = Math.min( nVertexMatrices, bones.length );

  			if ( maxBones < bones.length ) {

  				console.warn( 'THREE.WebGLRenderer: Skeleton has ' + bones.length + ' bones. This GPU supports ' + maxBones + '.' );
  				return 0;

  			}

  			return maxBones;

  		}

  	}

  	function getTextureEncodingFromMap( map ) {

  		let encoding;

  		if ( map && map.isTexture ) {

  			encoding = map.encoding;

  		} else if ( map && map.isWebGLRenderTarget ) {

  			console.warn( 'THREE.WebGLPrograms.getTextureEncodingFromMap: don\'t use render targets as textures. Use their .texture property instead.' );
  			encoding = map.texture.encoding;

  		} else {

  			encoding = LinearEncoding;

  		}

  		return encoding;

  	}

  	function getParameters( material, lights, shadows, scene, object ) {

  		const fog = scene.fog;
  		const environment = material.isMeshStandardMaterial ? scene.environment : null;

  		const envMap = cubemaps.get( material.envMap || environment );

  		const shaderID = shaderIDs[ material.type ];

  		// heuristics to create shader parameters according to lights in the scene
  		// (not to blow over maxLights budget)

  		const maxBones = object.isSkinnedMesh ? getMaxBones( object ) : 0;

  		if ( material.precision !== null ) {

  			precision = capabilities.getMaxPrecision( material.precision );

  			if ( precision !== material.precision ) {

  				console.warn( 'THREE.WebGLProgram.getParameters:', material.precision, 'not supported, using', precision, 'instead.' );

  			}

  		}

  		let vertexShader, fragmentShader;

  		if ( shaderID ) {

  			const shader = ShaderLib[ shaderID ];

  			vertexShader = shader.vertexShader;
  			fragmentShader = shader.fragmentShader;

  		} else {

  			vertexShader = material.vertexShader;
  			fragmentShader = material.fragmentShader;

  		}

  		const currentRenderTarget = renderer.getRenderTarget();

  		const parameters = {

  			isWebGL2: isWebGL2,

  			shaderID: shaderID,
  			shaderName: material.type,

  			vertexShader: vertexShader,
  			fragmentShader: fragmentShader,
  			defines: material.defines,

  			isRawShaderMaterial: material.isRawShaderMaterial === true,
  			glslVersion: material.glslVersion,

  			precision: precision,

  			instancing: object.isInstancedMesh === true,
  			instancingColor: object.isInstancedMesh === true && object.instanceColor !== null,

  			supportsVertexTextures: vertexTextures,
  			outputEncoding: ( currentRenderTarget !== null ) ? getTextureEncodingFromMap( currentRenderTarget.texture ) : renderer.outputEncoding,
  			map: !! material.map,
  			mapEncoding: getTextureEncodingFromMap( material.map ),
  			matcap: !! material.matcap,
  			matcapEncoding: getTextureEncodingFromMap( material.matcap ),
  			envMap: !! envMap,
  			envMapMode: envMap && envMap.mapping,
  			envMapEncoding: getTextureEncodingFromMap( envMap ),
  			envMapCubeUV: ( !! envMap ) && ( ( envMap.mapping === CubeUVReflectionMapping ) || ( envMap.mapping === CubeUVRefractionMapping ) ),
  			lightMap: !! material.lightMap,
  			lightMapEncoding: getTextureEncodingFromMap( material.lightMap ),
  			aoMap: !! material.aoMap,
  			emissiveMap: !! material.emissiveMap,
  			emissiveMapEncoding: getTextureEncodingFromMap( material.emissiveMap ),
  			bumpMap: !! material.bumpMap,
  			normalMap: !! material.normalMap,
  			objectSpaceNormalMap: material.normalMapType === ObjectSpaceNormalMap,
  			tangentSpaceNormalMap: material.normalMapType === TangentSpaceNormalMap,
  			clearcoatMap: !! material.clearcoatMap,
  			clearcoatRoughnessMap: !! material.clearcoatRoughnessMap,
  			clearcoatNormalMap: !! material.clearcoatNormalMap,
  			displacementMap: !! material.displacementMap,
  			roughnessMap: !! material.roughnessMap,
  			metalnessMap: !! material.metalnessMap,
  			specularMap: !! material.specularMap,
  			alphaMap: !! material.alphaMap,

  			gradientMap: !! material.gradientMap,

  			sheen: !! material.sheen,

  			transmissionMap: !! material.transmissionMap,

  			combine: material.combine,

  			vertexTangents: ( material.normalMap && material.vertexTangents ),
  			vertexColors: material.vertexColors,
  			vertexUvs: !! material.map || !! material.bumpMap || !! material.normalMap || !! material.specularMap || !! material.alphaMap || !! material.emissiveMap || !! material.roughnessMap || !! material.metalnessMap || !! material.clearcoatMap || !! material.clearcoatRoughnessMap || !! material.clearcoatNormalMap || !! material.displacementMap || !! material.transmissionMap,
  			uvsVertexOnly: ! ( !! material.map || !! material.bumpMap || !! material.normalMap || !! material.specularMap || !! material.alphaMap || !! material.emissiveMap || !! material.roughnessMap || !! material.metalnessMap || !! material.clearcoatNormalMap || !! material.transmissionMap ) && !! material.displacementMap,

  			fog: !! fog,
  			useFog: material.fog,
  			fogExp2: ( fog && fog.isFogExp2 ),

  			flatShading: material.flatShading,

  			sizeAttenuation: material.sizeAttenuation,
  			logarithmicDepthBuffer: logarithmicDepthBuffer,

  			skinning: material.skinning && maxBones > 0,
  			maxBones: maxBones,
  			useVertexTexture: floatVertexTextures,

  			morphTargets: material.morphTargets,
  			morphNormals: material.morphNormals,
  			maxMorphTargets: renderer.maxMorphTargets,
  			maxMorphNormals: renderer.maxMorphNormals,

  			numDirLights: lights.directional.length,
  			numPointLights: lights.point.length,
  			numSpotLights: lights.spot.length,
  			numRectAreaLights: lights.rectArea.length,
  			numHemiLights: lights.hemi.length,

  			numDirLightShadows: lights.directionalShadowMap.length,
  			numPointLightShadows: lights.pointShadowMap.length,
  			numSpotLightShadows: lights.spotShadowMap.length,

  			numClippingPlanes: clipping.numPlanes,
  			numClipIntersection: clipping.numIntersection,

  			dithering: material.dithering,

  			shadowMapEnabled: renderer.shadowMap.enabled && shadows.length > 0,
  			shadowMapType: renderer.shadowMap.type,

  			toneMapping: material.toneMapped ? renderer.toneMapping : NoToneMapping,
  			physicallyCorrectLights: renderer.physicallyCorrectLights,

  			premultipliedAlpha: material.premultipliedAlpha,

  			alphaTest: material.alphaTest,
  			doubleSided: material.side === DoubleSide,
  			flipSided: material.side === BackSide,

  			depthPacking: ( material.depthPacking !== undefined ) ? material.depthPacking : false,

  			index0AttributeName: material.index0AttributeName,

  			extensionDerivatives: material.extensions && material.extensions.derivatives,
  			extensionFragDepth: material.extensions && material.extensions.fragDepth,
  			extensionDrawBuffers: material.extensions && material.extensions.drawBuffers,
  			extensionShaderTextureLOD: material.extensions && material.extensions.shaderTextureLOD,

  			rendererExtensionFragDepth: isWebGL2 || extensions.has( 'EXT_frag_depth' ),
  			rendererExtensionDrawBuffers: isWebGL2 || extensions.has( 'WEBGL_draw_buffers' ),
  			rendererExtensionShaderTextureLod: isWebGL2 || extensions.has( 'EXT_shader_texture_lod' ),

  			customProgramCacheKey: material.customProgramCacheKey()

  		};

  		return parameters;

  	}

  	function getProgramCacheKey( parameters ) {

  		const array = [];

  		if ( parameters.shaderID ) {

  			array.push( parameters.shaderID );

  		} else {

  			array.push( parameters.fragmentShader );
  			array.push( parameters.vertexShader );

  		}

  		if ( parameters.defines !== undefined ) {

  			for ( const name in parameters.defines ) {

  				array.push( name );
  				array.push( parameters.defines[ name ] );

  			}

  		}

  		if ( parameters.isRawShaderMaterial === false ) {

  			for ( let i = 0; i < parameterNames.length; i ++ ) {

  				array.push( parameters[ parameterNames[ i ] ] );

  			}

  			array.push( renderer.outputEncoding );
  			array.push( renderer.gammaFactor );

  		}

  		array.push( parameters.customProgramCacheKey );

  		return array.join();

  	}

  	function getUniforms( material ) {

  		const shaderID = shaderIDs[ material.type ];
  		let uniforms;

  		if ( shaderID ) {

  			const shader = ShaderLib[ shaderID ];
  			uniforms = UniformsUtils.clone( shader.uniforms );

  		} else {

  			uniforms = material.uniforms;

  		}

  		return uniforms;

  	}

  	function acquireProgram( parameters, cacheKey ) {

  		let program;

  		// Check if code has been already compiled
  		for ( let p = 0, pl = programs.length; p < pl; p ++ ) {

  			const preexistingProgram = programs[ p ];

  			if ( preexistingProgram.cacheKey === cacheKey ) {

  				program = preexistingProgram;
  				++ program.usedTimes;

  				break;

  			}

  		}

  		if ( program === undefined ) {

  			program = new WebGLProgram( renderer, cacheKey, parameters, bindingStates );
  			programs.push( program );

  		}

  		return program;

  	}

  	function releaseProgram( program ) {

  		if ( -- program.usedTimes === 0 ) {

  			// Remove from unordered set
  			const i = programs.indexOf( program );
  			programs[ i ] = programs[ programs.length - 1 ];
  			programs.pop();

  			// Free WebGL resources
  			program.destroy();

  		}

  	}

  	return {
  		getParameters: getParameters,
  		getProgramCacheKey: getProgramCacheKey,
  		getUniforms: getUniforms,
  		acquireProgram: acquireProgram,
  		releaseProgram: releaseProgram,
  		// Exposed for resource monitoring & error feedback via renderer.info:
  		programs: programs
  	};

  }

  function WebGLProperties() {

  	let properties = new WeakMap();

  	function get( object ) {

  		let map = properties.get( object );

  		if ( map === undefined ) {

  			map = {};
  			properties.set( object, map );

  		}

  		return map;

  	}

  	function remove( object ) {

  		properties.delete( object );

  	}

  	function update( object, key, value ) {

  		properties.get( object )[ key ] = value;

  	}

  	function dispose() {

  		properties = new WeakMap();

  	}

  	return {
  		get: get,
  		remove: remove,
  		update: update,
  		dispose: dispose
  	};

  }

  function painterSortStable( a, b ) {

  	if ( a.groupOrder !== b.groupOrder ) {

  		return a.groupOrder - b.groupOrder;

  	} else if ( a.renderOrder !== b.renderOrder ) {

  		return a.renderOrder - b.renderOrder;

  	} else if ( a.program !== b.program ) {

  		return a.program.id - b.program.id;

  	} else if ( a.material.id !== b.material.id ) {

  		return a.material.id - b.material.id;

  	} else if ( a.z !== b.z ) {

  		return a.z - b.z;

  	} else {

  		return a.id - b.id;

  	}

  }

  function reversePainterSortStable( a, b ) {

  	if ( a.groupOrder !== b.groupOrder ) {

  		return a.groupOrder - b.groupOrder;

  	} else if ( a.renderOrder !== b.renderOrder ) {

  		return a.renderOrder - b.renderOrder;

  	} else if ( a.z !== b.z ) {

  		return b.z - a.z;

  	} else {

  		return a.id - b.id;

  	}

  }


  function WebGLRenderList( properties ) {

  	const renderItems = [];
  	let renderItemsIndex = 0;

  	const opaque = [];
  	const transparent = [];

  	const defaultProgram = { id: - 1 };

  	function init() {

  		renderItemsIndex = 0;

  		opaque.length = 0;
  		transparent.length = 0;

  	}

  	function getNextRenderItem( object, geometry, material, groupOrder, z, group ) {

  		let renderItem = renderItems[ renderItemsIndex ];
  		const materialProperties = properties.get( material );

  		if ( renderItem === undefined ) {

  			renderItem = {
  				id: object.id,
  				object: object,
  				geometry: geometry,
  				material: material,
  				program: materialProperties.program || defaultProgram,
  				groupOrder: groupOrder,
  				renderOrder: object.renderOrder,
  				z: z,
  				group: group
  			};

  			renderItems[ renderItemsIndex ] = renderItem;

  		} else {

  			renderItem.id = object.id;
  			renderItem.object = object;
  			renderItem.geometry = geometry;
  			renderItem.material = material;
  			renderItem.program = materialProperties.program || defaultProgram;
  			renderItem.groupOrder = groupOrder;
  			renderItem.renderOrder = object.renderOrder;
  			renderItem.z = z;
  			renderItem.group = group;

  		}

  		renderItemsIndex ++;

  		return renderItem;

  	}

  	function push( object, geometry, material, groupOrder, z, group ) {

  		const renderItem = getNextRenderItem( object, geometry, material, groupOrder, z, group );

  		( material.transparent === true ? transparent : opaque ).push( renderItem );

  	}

  	function unshift( object, geometry, material, groupOrder, z, group ) {

  		const renderItem = getNextRenderItem( object, geometry, material, groupOrder, z, group );

  		( material.transparent === true ? transparent : opaque ).unshift( renderItem );

  	}

  	function sort( customOpaqueSort, customTransparentSort ) {

  		if ( opaque.length > 1 ) opaque.sort( customOpaqueSort || painterSortStable );
  		if ( transparent.length > 1 ) transparent.sort( customTransparentSort || reversePainterSortStable );

  	}

  	function finish() {

  		// Clear references from inactive renderItems in the list

  		for ( let i = renderItemsIndex, il = renderItems.length; i < il; i ++ ) {

  			const renderItem = renderItems[ i ];

  			if ( renderItem.id === null ) break;

  			renderItem.id = null;
  			renderItem.object = null;
  			renderItem.geometry = null;
  			renderItem.material = null;
  			renderItem.program = null;
  			renderItem.group = null;

  		}

  	}

  	return {

  		opaque: opaque,
  		transparent: transparent,

  		init: init,
  		push: push,
  		unshift: unshift,
  		finish: finish,

  		sort: sort
  	};

  }

  function WebGLRenderLists( properties ) {

  	let lists = new WeakMap();

  	function get( scene, camera ) {

  		const cameras = lists.get( scene );
  		let list;

  		if ( cameras === undefined ) {

  			list = new WebGLRenderList( properties );
  			lists.set( scene, new WeakMap() );
  			lists.get( scene ).set( camera, list );

  		} else {

  			list = cameras.get( camera );
  			if ( list === undefined ) {

  				list = new WebGLRenderList( properties );
  				cameras.set( camera, list );

  			}

  		}

  		return list;

  	}

  	function dispose() {

  		lists = new WeakMap();

  	}

  	return {
  		get: get,
  		dispose: dispose
  	};

  }

  function UniformsCache() {

  	const lights = {};

  	return {

  		get: function ( light ) {

  			if ( lights[ light.id ] !== undefined ) {

  				return lights[ light.id ];

  			}

  			let uniforms;

  			switch ( light.type ) {

  				case 'DirectionalLight':
  					uniforms = {
  						direction: new Vector3(),
  						color: new Color()
  					};
  					break;

  				case 'SpotLight':
  					uniforms = {
  						position: new Vector3(),
  						direction: new Vector3(),
  						color: new Color(),
  						distance: 0,
  						coneCos: 0,
  						penumbraCos: 0,
  						decay: 0
  					};
  					break;

  				case 'PointLight':
  					uniforms = {
  						position: new Vector3(),
  						color: new Color(),
  						distance: 0,
  						decay: 0
  					};
  					break;

  				case 'HemisphereLight':
  					uniforms = {
  						direction: new Vector3(),
  						skyColor: new Color(),
  						groundColor: new Color()
  					};
  					break;

  				case 'RectAreaLight':
  					uniforms = {
  						color: new Color(),
  						position: new Vector3(),
  						halfWidth: new Vector3(),
  						halfHeight: new Vector3()
  					};
  					break;

  			}

  			lights[ light.id ] = uniforms;

  			return uniforms;

  		}

  	};

  }

  function ShadowUniformsCache() {

  	const lights = {};

  	return {

  		get: function ( light ) {

  			if ( lights[ light.id ] !== undefined ) {

  				return lights[ light.id ];

  			}

  			let uniforms;

  			switch ( light.type ) {

  				case 'DirectionalLight':
  					uniforms = {
  						shadowBias: 0,
  						shadowNormalBias: 0,
  						shadowRadius: 1,
  						shadowMapSize: new Vector2()
  					};
  					break;

  				case 'SpotLight':
  					uniforms = {
  						shadowBias: 0,
  						shadowNormalBias: 0,
  						shadowRadius: 1,
  						shadowMapSize: new Vector2()
  					};
  					break;

  				case 'PointLight':
  					uniforms = {
  						shadowBias: 0,
  						shadowNormalBias: 0,
  						shadowRadius: 1,
  						shadowMapSize: new Vector2(),
  						shadowCameraNear: 1,
  						shadowCameraFar: 1000
  					};
  					break;

  				// TODO (abelnation): set RectAreaLight shadow uniforms

  			}

  			lights[ light.id ] = uniforms;

  			return uniforms;

  		}

  	};

  }



  let nextVersion = 0;

  function shadowCastingLightsFirst( lightA, lightB ) {

  	return ( lightB.castShadow ? 1 : 0 ) - ( lightA.castShadow ? 1 : 0 );

  }

  function WebGLLights( extensions, capabilities ) {

  	const cache = new UniformsCache();

  	const shadowCache = ShadowUniformsCache();

  	const state = {

  		version: 0,

  		hash: {
  			directionalLength: - 1,
  			pointLength: - 1,
  			spotLength: - 1,
  			rectAreaLength: - 1,
  			hemiLength: - 1,

  			numDirectionalShadows: - 1,
  			numPointShadows: - 1,
  			numSpotShadows: - 1
  		},

  		ambient: [ 0, 0, 0 ],
  		probe: [],
  		directional: [],
  		directionalShadow: [],
  		directionalShadowMap: [],
  		directionalShadowMatrix: [],
  		spot: [],
  		spotShadow: [],
  		spotShadowMap: [],
  		spotShadowMatrix: [],
  		rectArea: [],
  		rectAreaLTC1: null,
  		rectAreaLTC2: null,
  		point: [],
  		pointShadow: [],
  		pointShadowMap: [],
  		pointShadowMatrix: [],
  		hemi: []

  	};

  	for ( let i = 0; i < 9; i ++ ) state.probe.push( new Vector3() );

  	const vector3 = new Vector3();
  	const matrix4 = new Matrix4();
  	const matrix42 = new Matrix4();

  	function setup( lights ) {

  		let r = 0, g = 0, b = 0;

  		for ( let i = 0; i < 9; i ++ ) state.probe[ i ].set( 0, 0, 0 );

  		let directionalLength = 0;
  		let pointLength = 0;
  		let spotLength = 0;
  		let rectAreaLength = 0;
  		let hemiLength = 0;

  		let numDirectionalShadows = 0;
  		let numPointShadows = 0;
  		let numSpotShadows = 0;

  		lights.sort( shadowCastingLightsFirst );

  		for ( let i = 0, l = lights.length; i < l; i ++ ) {

  			const light = lights[ i ];

  			const color = light.color;
  			const intensity = light.intensity;
  			const distance = light.distance;

  			const shadowMap = ( light.shadow && light.shadow.map ) ? light.shadow.map.texture : null;

  			if ( light.isAmbientLight ) {

  				r += color.r * intensity;
  				g += color.g * intensity;
  				b += color.b * intensity;

  			} else if ( light.isLightProbe ) {

  				for ( let j = 0; j < 9; j ++ ) {

  					state.probe[ j ].addScaledVector( light.sh.coefficients[ j ], intensity );

  				}

  			} else if ( light.isDirectionalLight ) {

  				const uniforms = cache.get( light );

  				uniforms.color.copy( light.color ).multiplyScalar( light.intensity );

  				if ( light.castShadow ) {

  					const shadow = light.shadow;

  					const shadowUniforms = shadowCache.get( light );

  					shadowUniforms.shadowBias = shadow.bias;
  					shadowUniforms.shadowNormalBias = shadow.normalBias;
  					shadowUniforms.shadowRadius = shadow.radius;
  					shadowUniforms.shadowMapSize = shadow.mapSize;

  					state.directionalShadow[ directionalLength ] = shadowUniforms;
  					state.directionalShadowMap[ directionalLength ] = shadowMap;
  					state.directionalShadowMatrix[ directionalLength ] = light.shadow.matrix;

  					numDirectionalShadows ++;

  				}

  				state.directional[ directionalLength ] = uniforms;

  				directionalLength ++;

  			} else if ( light.isSpotLight ) {

  				const uniforms = cache.get( light );

  				uniforms.position.setFromMatrixPosition( light.matrixWorld );

  				uniforms.color.copy( color ).multiplyScalar( intensity );
  				uniforms.distance = distance;

  				uniforms.coneCos = Math.cos( light.angle );
  				uniforms.penumbraCos = Math.cos( light.angle * ( 1 - light.penumbra ) );
  				uniforms.decay = light.decay;

  				if ( light.castShadow ) {

  					const shadow = light.shadow;

  					const shadowUniforms = shadowCache.get( light );

  					shadowUniforms.shadowBias = shadow.bias;
  					shadowUniforms.shadowNormalBias = shadow.normalBias;
  					shadowUniforms.shadowRadius = shadow.radius;
  					shadowUniforms.shadowMapSize = shadow.mapSize;

  					state.spotShadow[ spotLength ] = shadowUniforms;
  					state.spotShadowMap[ spotLength ] = shadowMap;
  					state.spotShadowMatrix[ spotLength ] = light.shadow.matrix;

  					numSpotShadows ++;

  				}

  				state.spot[ spotLength ] = uniforms;

  				spotLength ++;

  			} else if ( light.isRectAreaLight ) {

  				const uniforms = cache.get( light );

  				// (a) intensity is the total visible light emitted
  				//uniforms.color.copy( color ).multiplyScalar( intensity / ( light.width * light.height * Math.PI ) );

  				// (b) intensity is the brightness of the light
  				uniforms.color.copy( color ).multiplyScalar( intensity );

  				uniforms.halfWidth.set( light.width * 0.5, 0.0, 0.0 );
  				uniforms.halfHeight.set( 0.0, light.height * 0.5, 0.0 );

  				state.rectArea[ rectAreaLength ] = uniforms;

  				rectAreaLength ++;

  			} else if ( light.isPointLight ) {

  				const uniforms = cache.get( light );

  				uniforms.color.copy( light.color ).multiplyScalar( light.intensity );
  				uniforms.distance = light.distance;
  				uniforms.decay = light.decay;

  				if ( light.castShadow ) {

  					const shadow = light.shadow;

  					const shadowUniforms = shadowCache.get( light );

  					shadowUniforms.shadowBias = shadow.bias;
  					shadowUniforms.shadowNormalBias = shadow.normalBias;
  					shadowUniforms.shadowRadius = shadow.radius;
  					shadowUniforms.shadowMapSize = shadow.mapSize;
  					shadowUniforms.shadowCameraNear = shadow.camera.near;
  					shadowUniforms.shadowCameraFar = shadow.camera.far;

  					state.pointShadow[ pointLength ] = shadowUniforms;
  					state.pointShadowMap[ pointLength ] = shadowMap;
  					state.pointShadowMatrix[ pointLength ] = light.shadow.matrix;

  					numPointShadows ++;

  				}

  				state.point[ pointLength ] = uniforms;

  				pointLength ++;

  			} else if ( light.isHemisphereLight ) {

  				const uniforms = cache.get( light );

  				uniforms.skyColor.copy( light.color ).multiplyScalar( intensity );
  				uniforms.groundColor.copy( light.groundColor ).multiplyScalar( intensity );

  				state.hemi[ hemiLength ] = uniforms;

  				hemiLength ++;

  			}

  		}

  		if ( rectAreaLength > 0 ) {

  			if ( capabilities.isWebGL2 ) {

  				// WebGL 2

  				state.rectAreaLTC1 = UniformsLib.LTC_FLOAT_1;
  				state.rectAreaLTC2 = UniformsLib.LTC_FLOAT_2;

  			} else {

  				// WebGL 1

  				if ( extensions.has( 'OES_texture_float_linear' ) === true ) {

  					state.rectAreaLTC1 = UniformsLib.LTC_FLOAT_1;
  					state.rectAreaLTC2 = UniformsLib.LTC_FLOAT_2;

  				} else if ( extensions.has( 'OES_texture_half_float_linear' ) === true ) {

  					state.rectAreaLTC1 = UniformsLi